

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.Settings
    ( 

-- * Exported types
    Settings(..)                            ,
    SettingsK                               ,
    toSettings                              ,
    noSettings                              ,


 -- * Methods
-- ** settingsGetAllowFileAccessFromFileUrls
    SettingsGetAllowFileAccessFromFileUrlsMethodInfo,
    settingsGetAllowFileAccessFromFileUrls  ,


-- ** settingsGetAllowModalDialogs
    SettingsGetAllowModalDialogsMethodInfo  ,
    settingsGetAllowModalDialogs            ,


-- ** settingsGetAutoLoadImages
    SettingsGetAutoLoadImagesMethodInfo     ,
    settingsGetAutoLoadImages               ,


-- ** settingsGetCursiveFontFamily
    SettingsGetCursiveFontFamilyMethodInfo  ,
    settingsGetCursiveFontFamily            ,


-- ** settingsGetDefaultCharset
    SettingsGetDefaultCharsetMethodInfo     ,
    settingsGetDefaultCharset               ,


-- ** settingsGetDefaultFontFamily
    SettingsGetDefaultFontFamilyMethodInfo  ,
    settingsGetDefaultFontFamily            ,


-- ** settingsGetDefaultFontSize
    SettingsGetDefaultFontSizeMethodInfo    ,
    settingsGetDefaultFontSize              ,


-- ** settingsGetDefaultMonospaceFontSize
    SettingsGetDefaultMonospaceFontSizeMethodInfo,
    settingsGetDefaultMonospaceFontSize     ,


-- ** settingsGetDrawCompositingIndicators
    SettingsGetDrawCompositingIndicatorsMethodInfo,
    settingsGetDrawCompositingIndicators    ,


-- ** settingsGetEnableAccelerated2dCanvas
    SettingsGetEnableAccelerated2dCanvasMethodInfo,
    settingsGetEnableAccelerated2dCanvas    ,


-- ** settingsGetEnableCaretBrowsing
    SettingsGetEnableCaretBrowsingMethodInfo,
    settingsGetEnableCaretBrowsing          ,


-- ** settingsGetEnableDeveloperExtras
    SettingsGetEnableDeveloperExtrasMethodInfo,
    settingsGetEnableDeveloperExtras        ,


-- ** settingsGetEnableDnsPrefetching
    SettingsGetEnableDnsPrefetchingMethodInfo,
    settingsGetEnableDnsPrefetching         ,


-- ** settingsGetEnableFrameFlattening
    SettingsGetEnableFrameFlatteningMethodInfo,
    settingsGetEnableFrameFlattening        ,


-- ** settingsGetEnableFullscreen
    SettingsGetEnableFullscreenMethodInfo   ,
    settingsGetEnableFullscreen             ,


-- ** settingsGetEnableHtml5Database
    SettingsGetEnableHtml5DatabaseMethodInfo,
    settingsGetEnableHtml5Database          ,


-- ** settingsGetEnableHtml5LocalStorage
    SettingsGetEnableHtml5LocalStorageMethodInfo,
    settingsGetEnableHtml5LocalStorage      ,


-- ** settingsGetEnableHyperlinkAuditing
    SettingsGetEnableHyperlinkAuditingMethodInfo,
    settingsGetEnableHyperlinkAuditing      ,


-- ** settingsGetEnableJava
    SettingsGetEnableJavaMethodInfo         ,
    settingsGetEnableJava                   ,


-- ** settingsGetEnableJavascript
    SettingsGetEnableJavascriptMethodInfo   ,
    settingsGetEnableJavascript             ,


-- ** settingsGetEnableMediaStream
    SettingsGetEnableMediaStreamMethodInfo  ,
    settingsGetEnableMediaStream            ,


-- ** settingsGetEnableMediasource
    SettingsGetEnableMediasourceMethodInfo  ,
    settingsGetEnableMediasource            ,


-- ** settingsGetEnableOfflineWebApplicationCache
    SettingsGetEnableOfflineWebApplicationCacheMethodInfo,
    settingsGetEnableOfflineWebApplicationCache,


-- ** settingsGetEnablePageCache
    SettingsGetEnablePageCacheMethodInfo    ,
    settingsGetEnablePageCache              ,


-- ** settingsGetEnablePlugins
    SettingsGetEnablePluginsMethodInfo      ,
    settingsGetEnablePlugins                ,


-- ** settingsGetEnablePrivateBrowsing
    SettingsGetEnablePrivateBrowsingMethodInfo,
    settingsGetEnablePrivateBrowsing        ,


-- ** settingsGetEnableResizableTextAreas
    SettingsGetEnableResizableTextAreasMethodInfo,
    settingsGetEnableResizableTextAreas     ,


-- ** settingsGetEnableSiteSpecificQuirks
    SettingsGetEnableSiteSpecificQuirksMethodInfo,
    settingsGetEnableSiteSpecificQuirks     ,


-- ** settingsGetEnableSmoothScrolling
    SettingsGetEnableSmoothScrollingMethodInfo,
    settingsGetEnableSmoothScrolling        ,


-- ** settingsGetEnableSpatialNavigation
    SettingsGetEnableSpatialNavigationMethodInfo,
    settingsGetEnableSpatialNavigation      ,


-- ** settingsGetEnableTabsToLinks
    SettingsGetEnableTabsToLinksMethodInfo  ,
    settingsGetEnableTabsToLinks            ,


-- ** settingsGetEnableWebaudio
    SettingsGetEnableWebaudioMethodInfo     ,
    settingsGetEnableWebaudio               ,


-- ** settingsGetEnableWebgl
    SettingsGetEnableWebglMethodInfo        ,
    settingsGetEnableWebgl                  ,


-- ** settingsGetEnableWriteConsoleMessagesToStdout
    SettingsGetEnableWriteConsoleMessagesToStdoutMethodInfo,
    settingsGetEnableWriteConsoleMessagesToStdout,


-- ** settingsGetEnableXssAuditor
    SettingsGetEnableXssAuditorMethodInfo   ,
    settingsGetEnableXssAuditor             ,


-- ** settingsGetFantasyFontFamily
    SettingsGetFantasyFontFamilyMethodInfo  ,
    settingsGetFantasyFontFamily            ,


-- ** settingsGetJavascriptCanAccessClipboard
    SettingsGetJavascriptCanAccessClipboardMethodInfo,
    settingsGetJavascriptCanAccessClipboard ,


-- ** settingsGetJavascriptCanOpenWindowsAutomatically
    SettingsGetJavascriptCanOpenWindowsAutomaticallyMethodInfo,
    settingsGetJavascriptCanOpenWindowsAutomatically,


-- ** settingsGetLoadIconsIgnoringImageLoadSetting
    SettingsGetLoadIconsIgnoringImageLoadSettingMethodInfo,
    settingsGetLoadIconsIgnoringImageLoadSetting,


-- ** settingsGetMediaPlaybackAllowsInline
    SettingsGetMediaPlaybackAllowsInlineMethodInfo,
    settingsGetMediaPlaybackAllowsInline    ,


-- ** settingsGetMediaPlaybackRequiresUserGesture
    SettingsGetMediaPlaybackRequiresUserGestureMethodInfo,
    settingsGetMediaPlaybackRequiresUserGesture,


-- ** settingsGetMinimumFontSize
    SettingsGetMinimumFontSizeMethodInfo    ,
    settingsGetMinimumFontSize              ,


-- ** settingsGetMonospaceFontFamily
    SettingsGetMonospaceFontFamilyMethodInfo,
    settingsGetMonospaceFontFamily          ,


-- ** settingsGetPictographFontFamily
    SettingsGetPictographFontFamilyMethodInfo,
    settingsGetPictographFontFamily         ,


-- ** settingsGetPrintBackgrounds
    SettingsGetPrintBackgroundsMethodInfo   ,
    settingsGetPrintBackgrounds             ,


-- ** settingsGetSansSerifFontFamily
    SettingsGetSansSerifFontFamilyMethodInfo,
    settingsGetSansSerifFontFamily          ,


-- ** settingsGetSerifFontFamily
    SettingsGetSerifFontFamilyMethodInfo    ,
    settingsGetSerifFontFamily              ,


-- ** settingsGetUserAgent
    SettingsGetUserAgentMethodInfo          ,
    settingsGetUserAgent                    ,


-- ** settingsGetZoomTextOnly
    SettingsGetZoomTextOnlyMethodInfo       ,
    settingsGetZoomTextOnly                 ,


-- ** settingsNew
    settingsNew                             ,


-- ** settingsSetAllowFileAccessFromFileUrls
    SettingsSetAllowFileAccessFromFileUrlsMethodInfo,
    settingsSetAllowFileAccessFromFileUrls  ,


-- ** settingsSetAllowModalDialogs
    SettingsSetAllowModalDialogsMethodInfo  ,
    settingsSetAllowModalDialogs            ,


-- ** settingsSetAutoLoadImages
    SettingsSetAutoLoadImagesMethodInfo     ,
    settingsSetAutoLoadImages               ,


-- ** settingsSetCursiveFontFamily
    SettingsSetCursiveFontFamilyMethodInfo  ,
    settingsSetCursiveFontFamily            ,


-- ** settingsSetDefaultCharset
    SettingsSetDefaultCharsetMethodInfo     ,
    settingsSetDefaultCharset               ,


-- ** settingsSetDefaultFontFamily
    SettingsSetDefaultFontFamilyMethodInfo  ,
    settingsSetDefaultFontFamily            ,


-- ** settingsSetDefaultFontSize
    SettingsSetDefaultFontSizeMethodInfo    ,
    settingsSetDefaultFontSize              ,


-- ** settingsSetDefaultMonospaceFontSize
    SettingsSetDefaultMonospaceFontSizeMethodInfo,
    settingsSetDefaultMonospaceFontSize     ,


-- ** settingsSetDrawCompositingIndicators
    SettingsSetDrawCompositingIndicatorsMethodInfo,
    settingsSetDrawCompositingIndicators    ,


-- ** settingsSetEnableAccelerated2dCanvas
    SettingsSetEnableAccelerated2dCanvasMethodInfo,
    settingsSetEnableAccelerated2dCanvas    ,


-- ** settingsSetEnableCaretBrowsing
    SettingsSetEnableCaretBrowsingMethodInfo,
    settingsSetEnableCaretBrowsing          ,


-- ** settingsSetEnableDeveloperExtras
    SettingsSetEnableDeveloperExtrasMethodInfo,
    settingsSetEnableDeveloperExtras        ,


-- ** settingsSetEnableDnsPrefetching
    SettingsSetEnableDnsPrefetchingMethodInfo,
    settingsSetEnableDnsPrefetching         ,


-- ** settingsSetEnableFrameFlattening
    SettingsSetEnableFrameFlatteningMethodInfo,
    settingsSetEnableFrameFlattening        ,


-- ** settingsSetEnableFullscreen
    SettingsSetEnableFullscreenMethodInfo   ,
    settingsSetEnableFullscreen             ,


-- ** settingsSetEnableHtml5Database
    SettingsSetEnableHtml5DatabaseMethodInfo,
    settingsSetEnableHtml5Database          ,


-- ** settingsSetEnableHtml5LocalStorage
    SettingsSetEnableHtml5LocalStorageMethodInfo,
    settingsSetEnableHtml5LocalStorage      ,


-- ** settingsSetEnableHyperlinkAuditing
    SettingsSetEnableHyperlinkAuditingMethodInfo,
    settingsSetEnableHyperlinkAuditing      ,


-- ** settingsSetEnableJava
    SettingsSetEnableJavaMethodInfo         ,
    settingsSetEnableJava                   ,


-- ** settingsSetEnableJavascript
    SettingsSetEnableJavascriptMethodInfo   ,
    settingsSetEnableJavascript             ,


-- ** settingsSetEnableMediaStream
    SettingsSetEnableMediaStreamMethodInfo  ,
    settingsSetEnableMediaStream            ,


-- ** settingsSetEnableMediasource
    SettingsSetEnableMediasourceMethodInfo  ,
    settingsSetEnableMediasource            ,


-- ** settingsSetEnableOfflineWebApplicationCache
    SettingsSetEnableOfflineWebApplicationCacheMethodInfo,
    settingsSetEnableOfflineWebApplicationCache,


-- ** settingsSetEnablePageCache
    SettingsSetEnablePageCacheMethodInfo    ,
    settingsSetEnablePageCache              ,


-- ** settingsSetEnablePlugins
    SettingsSetEnablePluginsMethodInfo      ,
    settingsSetEnablePlugins                ,


-- ** settingsSetEnablePrivateBrowsing
    SettingsSetEnablePrivateBrowsingMethodInfo,
    settingsSetEnablePrivateBrowsing        ,


-- ** settingsSetEnableResizableTextAreas
    SettingsSetEnableResizableTextAreasMethodInfo,
    settingsSetEnableResizableTextAreas     ,


-- ** settingsSetEnableSiteSpecificQuirks
    SettingsSetEnableSiteSpecificQuirksMethodInfo,
    settingsSetEnableSiteSpecificQuirks     ,


-- ** settingsSetEnableSmoothScrolling
    SettingsSetEnableSmoothScrollingMethodInfo,
    settingsSetEnableSmoothScrolling        ,


-- ** settingsSetEnableSpatialNavigation
    SettingsSetEnableSpatialNavigationMethodInfo,
    settingsSetEnableSpatialNavigation      ,


-- ** settingsSetEnableTabsToLinks
    SettingsSetEnableTabsToLinksMethodInfo  ,
    settingsSetEnableTabsToLinks            ,


-- ** settingsSetEnableWebaudio
    SettingsSetEnableWebaudioMethodInfo     ,
    settingsSetEnableWebaudio               ,


-- ** settingsSetEnableWebgl
    SettingsSetEnableWebglMethodInfo        ,
    settingsSetEnableWebgl                  ,


-- ** settingsSetEnableWriteConsoleMessagesToStdout
    SettingsSetEnableWriteConsoleMessagesToStdoutMethodInfo,
    settingsSetEnableWriteConsoleMessagesToStdout,


-- ** settingsSetEnableXssAuditor
    SettingsSetEnableXssAuditorMethodInfo   ,
    settingsSetEnableXssAuditor             ,


-- ** settingsSetFantasyFontFamily
    SettingsSetFantasyFontFamilyMethodInfo  ,
    settingsSetFantasyFontFamily            ,


-- ** settingsSetJavascriptCanAccessClipboard
    SettingsSetJavascriptCanAccessClipboardMethodInfo,
    settingsSetJavascriptCanAccessClipboard ,


-- ** settingsSetJavascriptCanOpenWindowsAutomatically
    SettingsSetJavascriptCanOpenWindowsAutomaticallyMethodInfo,
    settingsSetJavascriptCanOpenWindowsAutomatically,


-- ** settingsSetLoadIconsIgnoringImageLoadSetting
    SettingsSetLoadIconsIgnoringImageLoadSettingMethodInfo,
    settingsSetLoadIconsIgnoringImageLoadSetting,


-- ** settingsSetMediaPlaybackAllowsInline
    SettingsSetMediaPlaybackAllowsInlineMethodInfo,
    settingsSetMediaPlaybackAllowsInline    ,


-- ** settingsSetMediaPlaybackRequiresUserGesture
    SettingsSetMediaPlaybackRequiresUserGestureMethodInfo,
    settingsSetMediaPlaybackRequiresUserGesture,


-- ** settingsSetMinimumFontSize
    SettingsSetMinimumFontSizeMethodInfo    ,
    settingsSetMinimumFontSize              ,


-- ** settingsSetMonospaceFontFamily
    SettingsSetMonospaceFontFamilyMethodInfo,
    settingsSetMonospaceFontFamily          ,


-- ** settingsSetPictographFontFamily
    SettingsSetPictographFontFamilyMethodInfo,
    settingsSetPictographFontFamily         ,


-- ** settingsSetPrintBackgrounds
    SettingsSetPrintBackgroundsMethodInfo   ,
    settingsSetPrintBackgrounds             ,


-- ** settingsSetSansSerifFontFamily
    SettingsSetSansSerifFontFamilyMethodInfo,
    settingsSetSansSerifFontFamily          ,


-- ** settingsSetSerifFontFamily
    SettingsSetSerifFontFamilyMethodInfo    ,
    settingsSetSerifFontFamily              ,


-- ** settingsSetUserAgent
    SettingsSetUserAgentMethodInfo          ,
    settingsSetUserAgent                    ,


-- ** settingsSetUserAgentWithApplicationDetails
    SettingsSetUserAgentWithApplicationDetailsMethodInfo,
    settingsSetUserAgentWithApplicationDetails,


-- ** settingsSetZoomTextOnly
    SettingsSetZoomTextOnlyMethodInfo       ,
    settingsSetZoomTextOnly                 ,




 -- * Properties
-- ** AllowFileAccessFromFileUrls
    SettingsAllowFileAccessFromFileUrlsPropertyInfo,
    constructSettingsAllowFileAccessFromFileUrls,
    getSettingsAllowFileAccessFromFileUrls  ,
    setSettingsAllowFileAccessFromFileUrls  ,
    settingsAllowFileAccessFromFileUrls     ,


-- ** AllowModalDialogs
    SettingsAllowModalDialogsPropertyInfo   ,
    constructSettingsAllowModalDialogs      ,
    getSettingsAllowModalDialogs            ,
    setSettingsAllowModalDialogs            ,
    settingsAllowModalDialogs               ,


-- ** AutoLoadImages
    SettingsAutoLoadImagesPropertyInfo      ,
    constructSettingsAutoLoadImages         ,
    getSettingsAutoLoadImages               ,
    setSettingsAutoLoadImages               ,
    settingsAutoLoadImages                  ,


-- ** CursiveFontFamily
    SettingsCursiveFontFamilyPropertyInfo   ,
    constructSettingsCursiveFontFamily      ,
    getSettingsCursiveFontFamily            ,
    setSettingsCursiveFontFamily            ,
    settingsCursiveFontFamily               ,


-- ** DefaultCharset
    SettingsDefaultCharsetPropertyInfo      ,
    constructSettingsDefaultCharset         ,
    getSettingsDefaultCharset               ,
    setSettingsDefaultCharset               ,
    settingsDefaultCharset                  ,


-- ** DefaultFontFamily
    SettingsDefaultFontFamilyPropertyInfo   ,
    constructSettingsDefaultFontFamily      ,
    getSettingsDefaultFontFamily            ,
    setSettingsDefaultFontFamily            ,
    settingsDefaultFontFamily               ,


-- ** DefaultFontSize
    SettingsDefaultFontSizePropertyInfo     ,
    constructSettingsDefaultFontSize        ,
    getSettingsDefaultFontSize              ,
    setSettingsDefaultFontSize              ,
    settingsDefaultFontSize                 ,


-- ** DefaultMonospaceFontSize
    SettingsDefaultMonospaceFontSizePropertyInfo,
    constructSettingsDefaultMonospaceFontSize,
    getSettingsDefaultMonospaceFontSize     ,
    setSettingsDefaultMonospaceFontSize     ,
    settingsDefaultMonospaceFontSize        ,


-- ** DrawCompositingIndicators
    SettingsDrawCompositingIndicatorsPropertyInfo,
    constructSettingsDrawCompositingIndicators,
    getSettingsDrawCompositingIndicators    ,
    setSettingsDrawCompositingIndicators    ,
    settingsDrawCompositingIndicators       ,


-- ** EnableAccelerated2dCanvas
    SettingsEnableAccelerated2dCanvasPropertyInfo,
    constructSettingsEnableAccelerated2dCanvas,
    getSettingsEnableAccelerated2dCanvas    ,
    setSettingsEnableAccelerated2dCanvas    ,
    settingsEnableAccelerated2dCanvas       ,


-- ** EnableCaretBrowsing
    SettingsEnableCaretBrowsingPropertyInfo ,
    constructSettingsEnableCaretBrowsing    ,
    getSettingsEnableCaretBrowsing          ,
    setSettingsEnableCaretBrowsing          ,
    settingsEnableCaretBrowsing             ,


-- ** EnableDeveloperExtras
    SettingsEnableDeveloperExtrasPropertyInfo,
    constructSettingsEnableDeveloperExtras  ,
    getSettingsEnableDeveloperExtras        ,
    setSettingsEnableDeveloperExtras        ,
    settingsEnableDeveloperExtras           ,


-- ** EnableDnsPrefetching
    SettingsEnableDnsPrefetchingPropertyInfo,
    constructSettingsEnableDnsPrefetching   ,
    getSettingsEnableDnsPrefetching         ,
    setSettingsEnableDnsPrefetching         ,
    settingsEnableDnsPrefetching            ,


-- ** EnableFrameFlattening
    SettingsEnableFrameFlatteningPropertyInfo,
    constructSettingsEnableFrameFlattening  ,
    getSettingsEnableFrameFlattening        ,
    setSettingsEnableFrameFlattening        ,
    settingsEnableFrameFlattening           ,


-- ** EnableFullscreen
    SettingsEnableFullscreenPropertyInfo    ,
    constructSettingsEnableFullscreen       ,
    getSettingsEnableFullscreen             ,
    setSettingsEnableFullscreen             ,
    settingsEnableFullscreen                ,


-- ** EnableHtml5Database
    SettingsEnableHtml5DatabasePropertyInfo ,
    constructSettingsEnableHtml5Database    ,
    getSettingsEnableHtml5Database          ,
    setSettingsEnableHtml5Database          ,
    settingsEnableHtml5Database             ,


-- ** EnableHtml5LocalStorage
    SettingsEnableHtml5LocalStoragePropertyInfo,
    constructSettingsEnableHtml5LocalStorage,
    getSettingsEnableHtml5LocalStorage      ,
    setSettingsEnableHtml5LocalStorage      ,
    settingsEnableHtml5LocalStorage         ,


-- ** EnableHyperlinkAuditing
    SettingsEnableHyperlinkAuditingPropertyInfo,
    constructSettingsEnableHyperlinkAuditing,
    getSettingsEnableHyperlinkAuditing      ,
    setSettingsEnableHyperlinkAuditing      ,
    settingsEnableHyperlinkAuditing         ,


-- ** EnableJava
    SettingsEnableJavaPropertyInfo          ,
    constructSettingsEnableJava             ,
    getSettingsEnableJava                   ,
    setSettingsEnableJava                   ,
    settingsEnableJava                      ,


-- ** EnableJavascript
    SettingsEnableJavascriptPropertyInfo    ,
    constructSettingsEnableJavascript       ,
    getSettingsEnableJavascript             ,
    setSettingsEnableJavascript             ,
    settingsEnableJavascript                ,


-- ** EnableMediaStream
    SettingsEnableMediaStreamPropertyInfo   ,
    constructSettingsEnableMediaStream      ,
    getSettingsEnableMediaStream            ,
    setSettingsEnableMediaStream            ,
    settingsEnableMediaStream               ,


-- ** EnableMediasource
    SettingsEnableMediasourcePropertyInfo   ,
    constructSettingsEnableMediasource      ,
    getSettingsEnableMediasource            ,
    setSettingsEnableMediasource            ,
    settingsEnableMediasource               ,


-- ** EnableOfflineWebApplicationCache
    SettingsEnableOfflineWebApplicationCachePropertyInfo,
    constructSettingsEnableOfflineWebApplicationCache,
    getSettingsEnableOfflineWebApplicationCache,
    setSettingsEnableOfflineWebApplicationCache,
    settingsEnableOfflineWebApplicationCache,


-- ** EnablePageCache
    SettingsEnablePageCachePropertyInfo     ,
    constructSettingsEnablePageCache        ,
    getSettingsEnablePageCache              ,
    setSettingsEnablePageCache              ,
    settingsEnablePageCache                 ,


-- ** EnablePlugins
    SettingsEnablePluginsPropertyInfo       ,
    constructSettingsEnablePlugins          ,
    getSettingsEnablePlugins                ,
    setSettingsEnablePlugins                ,
    settingsEnablePlugins                   ,


-- ** EnablePrivateBrowsing
    SettingsEnablePrivateBrowsingPropertyInfo,
    constructSettingsEnablePrivateBrowsing  ,
    getSettingsEnablePrivateBrowsing        ,
    setSettingsEnablePrivateBrowsing        ,
    settingsEnablePrivateBrowsing           ,


-- ** EnableResizableTextAreas
    SettingsEnableResizableTextAreasPropertyInfo,
    constructSettingsEnableResizableTextAreas,
    getSettingsEnableResizableTextAreas     ,
    setSettingsEnableResizableTextAreas     ,
    settingsEnableResizableTextAreas        ,


-- ** EnableSiteSpecificQuirks
    SettingsEnableSiteSpecificQuirksPropertyInfo,
    constructSettingsEnableSiteSpecificQuirks,
    getSettingsEnableSiteSpecificQuirks     ,
    setSettingsEnableSiteSpecificQuirks     ,
    settingsEnableSiteSpecificQuirks        ,


-- ** EnableSmoothScrolling
    SettingsEnableSmoothScrollingPropertyInfo,
    constructSettingsEnableSmoothScrolling  ,
    getSettingsEnableSmoothScrolling        ,
    setSettingsEnableSmoothScrolling        ,
    settingsEnableSmoothScrolling           ,


-- ** EnableSpatialNavigation
    SettingsEnableSpatialNavigationPropertyInfo,
    constructSettingsEnableSpatialNavigation,
    getSettingsEnableSpatialNavigation      ,
    setSettingsEnableSpatialNavigation      ,
    settingsEnableSpatialNavigation         ,


-- ** EnableTabsToLinks
    SettingsEnableTabsToLinksPropertyInfo   ,
    constructSettingsEnableTabsToLinks      ,
    getSettingsEnableTabsToLinks            ,
    setSettingsEnableTabsToLinks            ,
    settingsEnableTabsToLinks               ,


-- ** EnableWebaudio
    SettingsEnableWebaudioPropertyInfo      ,
    constructSettingsEnableWebaudio         ,
    getSettingsEnableWebaudio               ,
    setSettingsEnableWebaudio               ,
    settingsEnableWebaudio                  ,


-- ** EnableWebgl
    SettingsEnableWebglPropertyInfo         ,
    constructSettingsEnableWebgl            ,
    getSettingsEnableWebgl                  ,
    setSettingsEnableWebgl                  ,
    settingsEnableWebgl                     ,


-- ** EnableWriteConsoleMessagesToStdout
    SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo,
    constructSettingsEnableWriteConsoleMessagesToStdout,
    getSettingsEnableWriteConsoleMessagesToStdout,
    setSettingsEnableWriteConsoleMessagesToStdout,
    settingsEnableWriteConsoleMessagesToStdout,


-- ** EnableXssAuditor
    SettingsEnableXssAuditorPropertyInfo    ,
    constructSettingsEnableXssAuditor       ,
    getSettingsEnableXssAuditor             ,
    setSettingsEnableXssAuditor             ,
    settingsEnableXssAuditor                ,


-- ** FantasyFontFamily
    SettingsFantasyFontFamilyPropertyInfo   ,
    constructSettingsFantasyFontFamily      ,
    getSettingsFantasyFontFamily            ,
    setSettingsFantasyFontFamily            ,
    settingsFantasyFontFamily               ,


-- ** JavascriptCanAccessClipboard
    SettingsJavascriptCanAccessClipboardPropertyInfo,
    constructSettingsJavascriptCanAccessClipboard,
    getSettingsJavascriptCanAccessClipboard ,
    setSettingsJavascriptCanAccessClipboard ,
    settingsJavascriptCanAccessClipboard    ,


-- ** JavascriptCanOpenWindowsAutomatically
    SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo,
    constructSettingsJavascriptCanOpenWindowsAutomatically,
    getSettingsJavascriptCanOpenWindowsAutomatically,
    setSettingsJavascriptCanOpenWindowsAutomatically,
    settingsJavascriptCanOpenWindowsAutomatically,


-- ** LoadIconsIgnoringImageLoadSetting
    SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo,
    constructSettingsLoadIconsIgnoringImageLoadSetting,
    getSettingsLoadIconsIgnoringImageLoadSetting,
    setSettingsLoadIconsIgnoringImageLoadSetting,
    settingsLoadIconsIgnoringImageLoadSetting,


-- ** MediaPlaybackAllowsInline
    SettingsMediaPlaybackAllowsInlinePropertyInfo,
    constructSettingsMediaPlaybackAllowsInline,
    getSettingsMediaPlaybackAllowsInline    ,
    setSettingsMediaPlaybackAllowsInline    ,
    settingsMediaPlaybackAllowsInline       ,


-- ** MediaPlaybackRequiresUserGesture
    SettingsMediaPlaybackRequiresUserGesturePropertyInfo,
    constructSettingsMediaPlaybackRequiresUserGesture,
    getSettingsMediaPlaybackRequiresUserGesture,
    setSettingsMediaPlaybackRequiresUserGesture,
    settingsMediaPlaybackRequiresUserGesture,


-- ** MinimumFontSize
    SettingsMinimumFontSizePropertyInfo     ,
    constructSettingsMinimumFontSize        ,
    getSettingsMinimumFontSize              ,
    setSettingsMinimumFontSize              ,
    settingsMinimumFontSize                 ,


-- ** MonospaceFontFamily
    SettingsMonospaceFontFamilyPropertyInfo ,
    constructSettingsMonospaceFontFamily    ,
    getSettingsMonospaceFontFamily          ,
    setSettingsMonospaceFontFamily          ,
    settingsMonospaceFontFamily             ,


-- ** PictographFontFamily
    SettingsPictographFontFamilyPropertyInfo,
    constructSettingsPictographFontFamily   ,
    getSettingsPictographFontFamily         ,
    setSettingsPictographFontFamily         ,
    settingsPictographFontFamily            ,


-- ** PrintBackgrounds
    SettingsPrintBackgroundsPropertyInfo    ,
    constructSettingsPrintBackgrounds       ,
    getSettingsPrintBackgrounds             ,
    setSettingsPrintBackgrounds             ,
    settingsPrintBackgrounds                ,


-- ** SansSerifFontFamily
    SettingsSansSerifFontFamilyPropertyInfo ,
    constructSettingsSansSerifFontFamily    ,
    getSettingsSansSerifFontFamily          ,
    setSettingsSansSerifFontFamily          ,
    settingsSansSerifFontFamily             ,


-- ** SerifFontFamily
    SettingsSerifFontFamilyPropertyInfo     ,
    constructSettingsSerifFontFamily        ,
    getSettingsSerifFontFamily              ,
    setSettingsSerifFontFamily              ,
    settingsSerifFontFamily                 ,


-- ** UserAgent
    SettingsUserAgentPropertyInfo           ,
    clearSettingsUserAgent                  ,
    constructSettingsUserAgent              ,
    getSettingsUserAgent                    ,
    setSettingsUserAgent                    ,
    settingsUserAgent                       ,


-- ** ZoomTextOnly
    SettingsZoomTextOnlyPropertyInfo        ,
    constructSettingsZoomTextOnly           ,
    getSettingsZoomTextOnly                 ,
    setSettingsZoomTextOnly                 ,
    settingsZoomTextOnly                    ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype Settings = Settings (ForeignPtr Settings)
foreign import ccall "webkit_settings_get_type"
    c_webkit_settings_get_type :: IO GType

type instance ParentTypes Settings = SettingsParentTypes
type SettingsParentTypes = '[GObject.Object]

instance GObject Settings where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_settings_get_type
    

class GObject o => SettingsK o
instance (GObject o, IsDescendantOf Settings o) => SettingsK o

toSettings :: SettingsK o => o -> IO Settings
toSettings = unsafeCastTo Settings

noSettings :: Maybe Settings
noSettings = Nothing

type family ResolveSettingsMethod (t :: Symbol) (o :: *) :: * where
    ResolveSettingsMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveSettingsMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveSettingsMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveSettingsMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveSettingsMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveSettingsMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveSettingsMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveSettingsMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveSettingsMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveSettingsMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveSettingsMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveSettingsMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveSettingsMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveSettingsMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveSettingsMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveSettingsMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveSettingsMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveSettingsMethod "getAllowFileAccessFromFileUrls" o = SettingsGetAllowFileAccessFromFileUrlsMethodInfo
    ResolveSettingsMethod "getAllowModalDialogs" o = SettingsGetAllowModalDialogsMethodInfo
    ResolveSettingsMethod "getAutoLoadImages" o = SettingsGetAutoLoadImagesMethodInfo
    ResolveSettingsMethod "getCursiveFontFamily" o = SettingsGetCursiveFontFamilyMethodInfo
    ResolveSettingsMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveSettingsMethod "getDefaultCharset" o = SettingsGetDefaultCharsetMethodInfo
    ResolveSettingsMethod "getDefaultFontFamily" o = SettingsGetDefaultFontFamilyMethodInfo
    ResolveSettingsMethod "getDefaultFontSize" o = SettingsGetDefaultFontSizeMethodInfo
    ResolveSettingsMethod "getDefaultMonospaceFontSize" o = SettingsGetDefaultMonospaceFontSizeMethodInfo
    ResolveSettingsMethod "getDrawCompositingIndicators" o = SettingsGetDrawCompositingIndicatorsMethodInfo
    ResolveSettingsMethod "getEnableAccelerated2dCanvas" o = SettingsGetEnableAccelerated2dCanvasMethodInfo
    ResolveSettingsMethod "getEnableCaretBrowsing" o = SettingsGetEnableCaretBrowsingMethodInfo
    ResolveSettingsMethod "getEnableDeveloperExtras" o = SettingsGetEnableDeveloperExtrasMethodInfo
    ResolveSettingsMethod "getEnableDnsPrefetching" o = SettingsGetEnableDnsPrefetchingMethodInfo
    ResolveSettingsMethod "getEnableFrameFlattening" o = SettingsGetEnableFrameFlatteningMethodInfo
    ResolveSettingsMethod "getEnableFullscreen" o = SettingsGetEnableFullscreenMethodInfo
    ResolveSettingsMethod "getEnableHtml5Database" o = SettingsGetEnableHtml5DatabaseMethodInfo
    ResolveSettingsMethod "getEnableHtml5LocalStorage" o = SettingsGetEnableHtml5LocalStorageMethodInfo
    ResolveSettingsMethod "getEnableHyperlinkAuditing" o = SettingsGetEnableHyperlinkAuditingMethodInfo
    ResolveSettingsMethod "getEnableJava" o = SettingsGetEnableJavaMethodInfo
    ResolveSettingsMethod "getEnableJavascript" o = SettingsGetEnableJavascriptMethodInfo
    ResolveSettingsMethod "getEnableMediaStream" o = SettingsGetEnableMediaStreamMethodInfo
    ResolveSettingsMethod "getEnableMediasource" o = SettingsGetEnableMediasourceMethodInfo
    ResolveSettingsMethod "getEnableOfflineWebApplicationCache" o = SettingsGetEnableOfflineWebApplicationCacheMethodInfo
    ResolveSettingsMethod "getEnablePageCache" o = SettingsGetEnablePageCacheMethodInfo
    ResolveSettingsMethod "getEnablePlugins" o = SettingsGetEnablePluginsMethodInfo
    ResolveSettingsMethod "getEnablePrivateBrowsing" o = SettingsGetEnablePrivateBrowsingMethodInfo
    ResolveSettingsMethod "getEnableResizableTextAreas" o = SettingsGetEnableResizableTextAreasMethodInfo
    ResolveSettingsMethod "getEnableSiteSpecificQuirks" o = SettingsGetEnableSiteSpecificQuirksMethodInfo
    ResolveSettingsMethod "getEnableSmoothScrolling" o = SettingsGetEnableSmoothScrollingMethodInfo
    ResolveSettingsMethod "getEnableSpatialNavigation" o = SettingsGetEnableSpatialNavigationMethodInfo
    ResolveSettingsMethod "getEnableTabsToLinks" o = SettingsGetEnableTabsToLinksMethodInfo
    ResolveSettingsMethod "getEnableWebaudio" o = SettingsGetEnableWebaudioMethodInfo
    ResolveSettingsMethod "getEnableWebgl" o = SettingsGetEnableWebglMethodInfo
    ResolveSettingsMethod "getEnableWriteConsoleMessagesToStdout" o = SettingsGetEnableWriteConsoleMessagesToStdoutMethodInfo
    ResolveSettingsMethod "getEnableXssAuditor" o = SettingsGetEnableXssAuditorMethodInfo
    ResolveSettingsMethod "getFantasyFontFamily" o = SettingsGetFantasyFontFamilyMethodInfo
    ResolveSettingsMethod "getJavascriptCanAccessClipboard" o = SettingsGetJavascriptCanAccessClipboardMethodInfo
    ResolveSettingsMethod "getJavascriptCanOpenWindowsAutomatically" o = SettingsGetJavascriptCanOpenWindowsAutomaticallyMethodInfo
    ResolveSettingsMethod "getLoadIconsIgnoringImageLoadSetting" o = SettingsGetLoadIconsIgnoringImageLoadSettingMethodInfo
    ResolveSettingsMethod "getMediaPlaybackAllowsInline" o = SettingsGetMediaPlaybackAllowsInlineMethodInfo
    ResolveSettingsMethod "getMediaPlaybackRequiresUserGesture" o = SettingsGetMediaPlaybackRequiresUserGestureMethodInfo
    ResolveSettingsMethod "getMinimumFontSize" o = SettingsGetMinimumFontSizeMethodInfo
    ResolveSettingsMethod "getMonospaceFontFamily" o = SettingsGetMonospaceFontFamilyMethodInfo
    ResolveSettingsMethod "getPictographFontFamily" o = SettingsGetPictographFontFamilyMethodInfo
    ResolveSettingsMethod "getPrintBackgrounds" o = SettingsGetPrintBackgroundsMethodInfo
    ResolveSettingsMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveSettingsMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveSettingsMethod "getSansSerifFontFamily" o = SettingsGetSansSerifFontFamilyMethodInfo
    ResolveSettingsMethod "getSerifFontFamily" o = SettingsGetSerifFontFamilyMethodInfo
    ResolveSettingsMethod "getUserAgent" o = SettingsGetUserAgentMethodInfo
    ResolveSettingsMethod "getZoomTextOnly" o = SettingsGetZoomTextOnlyMethodInfo
    ResolveSettingsMethod "setAllowFileAccessFromFileUrls" o = SettingsSetAllowFileAccessFromFileUrlsMethodInfo
    ResolveSettingsMethod "setAllowModalDialogs" o = SettingsSetAllowModalDialogsMethodInfo
    ResolveSettingsMethod "setAutoLoadImages" o = SettingsSetAutoLoadImagesMethodInfo
    ResolveSettingsMethod "setCursiveFontFamily" o = SettingsSetCursiveFontFamilyMethodInfo
    ResolveSettingsMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveSettingsMethod "setDefaultCharset" o = SettingsSetDefaultCharsetMethodInfo
    ResolveSettingsMethod "setDefaultFontFamily" o = SettingsSetDefaultFontFamilyMethodInfo
    ResolveSettingsMethod "setDefaultFontSize" o = SettingsSetDefaultFontSizeMethodInfo
    ResolveSettingsMethod "setDefaultMonospaceFontSize" o = SettingsSetDefaultMonospaceFontSizeMethodInfo
    ResolveSettingsMethod "setDrawCompositingIndicators" o = SettingsSetDrawCompositingIndicatorsMethodInfo
    ResolveSettingsMethod "setEnableAccelerated2dCanvas" o = SettingsSetEnableAccelerated2dCanvasMethodInfo
    ResolveSettingsMethod "setEnableCaretBrowsing" o = SettingsSetEnableCaretBrowsingMethodInfo
    ResolveSettingsMethod "setEnableDeveloperExtras" o = SettingsSetEnableDeveloperExtrasMethodInfo
    ResolveSettingsMethod "setEnableDnsPrefetching" o = SettingsSetEnableDnsPrefetchingMethodInfo
    ResolveSettingsMethod "setEnableFrameFlattening" o = SettingsSetEnableFrameFlatteningMethodInfo
    ResolveSettingsMethod "setEnableFullscreen" o = SettingsSetEnableFullscreenMethodInfo
    ResolveSettingsMethod "setEnableHtml5Database" o = SettingsSetEnableHtml5DatabaseMethodInfo
    ResolveSettingsMethod "setEnableHtml5LocalStorage" o = SettingsSetEnableHtml5LocalStorageMethodInfo
    ResolveSettingsMethod "setEnableHyperlinkAuditing" o = SettingsSetEnableHyperlinkAuditingMethodInfo
    ResolveSettingsMethod "setEnableJava" o = SettingsSetEnableJavaMethodInfo
    ResolveSettingsMethod "setEnableJavascript" o = SettingsSetEnableJavascriptMethodInfo
    ResolveSettingsMethod "setEnableMediaStream" o = SettingsSetEnableMediaStreamMethodInfo
    ResolveSettingsMethod "setEnableMediasource" o = SettingsSetEnableMediasourceMethodInfo
    ResolveSettingsMethod "setEnableOfflineWebApplicationCache" o = SettingsSetEnableOfflineWebApplicationCacheMethodInfo
    ResolveSettingsMethod "setEnablePageCache" o = SettingsSetEnablePageCacheMethodInfo
    ResolveSettingsMethod "setEnablePlugins" o = SettingsSetEnablePluginsMethodInfo
    ResolveSettingsMethod "setEnablePrivateBrowsing" o = SettingsSetEnablePrivateBrowsingMethodInfo
    ResolveSettingsMethod "setEnableResizableTextAreas" o = SettingsSetEnableResizableTextAreasMethodInfo
    ResolveSettingsMethod "setEnableSiteSpecificQuirks" o = SettingsSetEnableSiteSpecificQuirksMethodInfo
    ResolveSettingsMethod "setEnableSmoothScrolling" o = SettingsSetEnableSmoothScrollingMethodInfo
    ResolveSettingsMethod "setEnableSpatialNavigation" o = SettingsSetEnableSpatialNavigationMethodInfo
    ResolveSettingsMethod "setEnableTabsToLinks" o = SettingsSetEnableTabsToLinksMethodInfo
    ResolveSettingsMethod "setEnableWebaudio" o = SettingsSetEnableWebaudioMethodInfo
    ResolveSettingsMethod "setEnableWebgl" o = SettingsSetEnableWebglMethodInfo
    ResolveSettingsMethod "setEnableWriteConsoleMessagesToStdout" o = SettingsSetEnableWriteConsoleMessagesToStdoutMethodInfo
    ResolveSettingsMethod "setEnableXssAuditor" o = SettingsSetEnableXssAuditorMethodInfo
    ResolveSettingsMethod "setFantasyFontFamily" o = SettingsSetFantasyFontFamilyMethodInfo
    ResolveSettingsMethod "setJavascriptCanAccessClipboard" o = SettingsSetJavascriptCanAccessClipboardMethodInfo
    ResolveSettingsMethod "setJavascriptCanOpenWindowsAutomatically" o = SettingsSetJavascriptCanOpenWindowsAutomaticallyMethodInfo
    ResolveSettingsMethod "setLoadIconsIgnoringImageLoadSetting" o = SettingsSetLoadIconsIgnoringImageLoadSettingMethodInfo
    ResolveSettingsMethod "setMediaPlaybackAllowsInline" o = SettingsSetMediaPlaybackAllowsInlineMethodInfo
    ResolveSettingsMethod "setMediaPlaybackRequiresUserGesture" o = SettingsSetMediaPlaybackRequiresUserGestureMethodInfo
    ResolveSettingsMethod "setMinimumFontSize" o = SettingsSetMinimumFontSizeMethodInfo
    ResolveSettingsMethod "setMonospaceFontFamily" o = SettingsSetMonospaceFontFamilyMethodInfo
    ResolveSettingsMethod "setPictographFontFamily" o = SettingsSetPictographFontFamilyMethodInfo
    ResolveSettingsMethod "setPrintBackgrounds" o = SettingsSetPrintBackgroundsMethodInfo
    ResolveSettingsMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveSettingsMethod "setSansSerifFontFamily" o = SettingsSetSansSerifFontFamilyMethodInfo
    ResolveSettingsMethod "setSerifFontFamily" o = SettingsSetSerifFontFamilyMethodInfo
    ResolveSettingsMethod "setUserAgent" o = SettingsSetUserAgentMethodInfo
    ResolveSettingsMethod "setUserAgentWithApplicationDetails" o = SettingsSetUserAgentWithApplicationDetailsMethodInfo
    ResolveSettingsMethod "setZoomTextOnly" o = SettingsSetZoomTextOnlyMethodInfo
    ResolveSettingsMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveSettingsMethod t Settings, MethodInfo info Settings p) => IsLabelProxy t (Settings -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveSettingsMethod t Settings, MethodInfo info Settings p) => IsLabel t (Settings -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "allow-file-access-from-file-urls"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsAllowFileAccessFromFileUrls :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsAllowFileAccessFromFileUrls obj = liftIO $ getObjectPropertyBool obj "allow-file-access-from-file-urls"

setSettingsAllowFileAccessFromFileUrls :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsAllowFileAccessFromFileUrls obj val = liftIO $ setObjectPropertyBool obj "allow-file-access-from-file-urls" val

constructSettingsAllowFileAccessFromFileUrls :: Bool -> IO ([Char], GValue)
constructSettingsAllowFileAccessFromFileUrls val = constructObjectPropertyBool "allow-file-access-from-file-urls" val

data SettingsAllowFileAccessFromFileUrlsPropertyInfo
instance AttrInfo SettingsAllowFileAccessFromFileUrlsPropertyInfo where
    type AttrAllowedOps SettingsAllowFileAccessFromFileUrlsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsAllowFileAccessFromFileUrlsPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsAllowFileAccessFromFileUrlsPropertyInfo = SettingsK
    type AttrGetType SettingsAllowFileAccessFromFileUrlsPropertyInfo = Bool
    type AttrLabel SettingsAllowFileAccessFromFileUrlsPropertyInfo = "allow-file-access-from-file-urls"
    attrGet _ = getSettingsAllowFileAccessFromFileUrls
    attrSet _ = setSettingsAllowFileAccessFromFileUrls
    attrConstruct _ = constructSettingsAllowFileAccessFromFileUrls
    attrClear _ = undefined

-- VVV Prop "allow-modal-dialogs"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsAllowModalDialogs :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsAllowModalDialogs obj = liftIO $ getObjectPropertyBool obj "allow-modal-dialogs"

setSettingsAllowModalDialogs :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsAllowModalDialogs obj val = liftIO $ setObjectPropertyBool obj "allow-modal-dialogs" val

constructSettingsAllowModalDialogs :: Bool -> IO ([Char], GValue)
constructSettingsAllowModalDialogs val = constructObjectPropertyBool "allow-modal-dialogs" val

data SettingsAllowModalDialogsPropertyInfo
instance AttrInfo SettingsAllowModalDialogsPropertyInfo where
    type AttrAllowedOps SettingsAllowModalDialogsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsAllowModalDialogsPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsAllowModalDialogsPropertyInfo = SettingsK
    type AttrGetType SettingsAllowModalDialogsPropertyInfo = Bool
    type AttrLabel SettingsAllowModalDialogsPropertyInfo = "allow-modal-dialogs"
    attrGet _ = getSettingsAllowModalDialogs
    attrSet _ = setSettingsAllowModalDialogs
    attrConstruct _ = constructSettingsAllowModalDialogs
    attrClear _ = undefined

-- VVV Prop "auto-load-images"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsAutoLoadImages :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsAutoLoadImages obj = liftIO $ getObjectPropertyBool obj "auto-load-images"

setSettingsAutoLoadImages :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsAutoLoadImages obj val = liftIO $ setObjectPropertyBool obj "auto-load-images" val

constructSettingsAutoLoadImages :: Bool -> IO ([Char], GValue)
constructSettingsAutoLoadImages val = constructObjectPropertyBool "auto-load-images" val

data SettingsAutoLoadImagesPropertyInfo
instance AttrInfo SettingsAutoLoadImagesPropertyInfo where
    type AttrAllowedOps SettingsAutoLoadImagesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsAutoLoadImagesPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsAutoLoadImagesPropertyInfo = SettingsK
    type AttrGetType SettingsAutoLoadImagesPropertyInfo = Bool
    type AttrLabel SettingsAutoLoadImagesPropertyInfo = "auto-load-images"
    attrGet _ = getSettingsAutoLoadImages
    attrSet _ = setSettingsAutoLoadImages
    attrConstruct _ = constructSettingsAutoLoadImages
    attrClear _ = undefined

-- VVV Prop "cursive-font-family"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsCursiveFontFamily :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsCursiveFontFamily obj = liftIO $ checkUnexpectedNothing "getSettingsCursiveFontFamily" $ getObjectPropertyString obj "cursive-font-family"

setSettingsCursiveFontFamily :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsCursiveFontFamily obj val = liftIO $ setObjectPropertyString obj "cursive-font-family" (Just val)

constructSettingsCursiveFontFamily :: T.Text -> IO ([Char], GValue)
constructSettingsCursiveFontFamily val = constructObjectPropertyString "cursive-font-family" (Just val)

data SettingsCursiveFontFamilyPropertyInfo
instance AttrInfo SettingsCursiveFontFamilyPropertyInfo where
    type AttrAllowedOps SettingsCursiveFontFamilyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsCursiveFontFamilyPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsCursiveFontFamilyPropertyInfo = SettingsK
    type AttrGetType SettingsCursiveFontFamilyPropertyInfo = T.Text
    type AttrLabel SettingsCursiveFontFamilyPropertyInfo = "cursive-font-family"
    attrGet _ = getSettingsCursiveFontFamily
    attrSet _ = setSettingsCursiveFontFamily
    attrConstruct _ = constructSettingsCursiveFontFamily
    attrClear _ = undefined

-- VVV Prop "default-charset"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsDefaultCharset :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsDefaultCharset obj = liftIO $ checkUnexpectedNothing "getSettingsDefaultCharset" $ getObjectPropertyString obj "default-charset"

setSettingsDefaultCharset :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsDefaultCharset obj val = liftIO $ setObjectPropertyString obj "default-charset" (Just val)

constructSettingsDefaultCharset :: T.Text -> IO ([Char], GValue)
constructSettingsDefaultCharset val = constructObjectPropertyString "default-charset" (Just val)

data SettingsDefaultCharsetPropertyInfo
instance AttrInfo SettingsDefaultCharsetPropertyInfo where
    type AttrAllowedOps SettingsDefaultCharsetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsDefaultCharsetPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsDefaultCharsetPropertyInfo = SettingsK
    type AttrGetType SettingsDefaultCharsetPropertyInfo = T.Text
    type AttrLabel SettingsDefaultCharsetPropertyInfo = "default-charset"
    attrGet _ = getSettingsDefaultCharset
    attrSet _ = setSettingsDefaultCharset
    attrConstruct _ = constructSettingsDefaultCharset
    attrClear _ = undefined

-- VVV Prop "default-font-family"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsDefaultFontFamily :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsDefaultFontFamily obj = liftIO $ checkUnexpectedNothing "getSettingsDefaultFontFamily" $ getObjectPropertyString obj "default-font-family"

setSettingsDefaultFontFamily :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsDefaultFontFamily obj val = liftIO $ setObjectPropertyString obj "default-font-family" (Just val)

constructSettingsDefaultFontFamily :: T.Text -> IO ([Char], GValue)
constructSettingsDefaultFontFamily val = constructObjectPropertyString "default-font-family" (Just val)

data SettingsDefaultFontFamilyPropertyInfo
instance AttrInfo SettingsDefaultFontFamilyPropertyInfo where
    type AttrAllowedOps SettingsDefaultFontFamilyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsDefaultFontFamilyPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsDefaultFontFamilyPropertyInfo = SettingsK
    type AttrGetType SettingsDefaultFontFamilyPropertyInfo = T.Text
    type AttrLabel SettingsDefaultFontFamilyPropertyInfo = "default-font-family"
    attrGet _ = getSettingsDefaultFontFamily
    attrSet _ = setSettingsDefaultFontFamily
    attrConstruct _ = constructSettingsDefaultFontFamily
    attrClear _ = undefined

-- VVV Prop "default-font-size"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

getSettingsDefaultFontSize :: (MonadIO m, SettingsK o) => o -> m Word32
getSettingsDefaultFontSize obj = liftIO $ getObjectPropertyUInt32 obj "default-font-size"

setSettingsDefaultFontSize :: (MonadIO m, SettingsK o) => o -> Word32 -> m ()
setSettingsDefaultFontSize obj val = liftIO $ setObjectPropertyUInt32 obj "default-font-size" val

constructSettingsDefaultFontSize :: Word32 -> IO ([Char], GValue)
constructSettingsDefaultFontSize val = constructObjectPropertyUInt32 "default-font-size" val

data SettingsDefaultFontSizePropertyInfo
instance AttrInfo SettingsDefaultFontSizePropertyInfo where
    type AttrAllowedOps SettingsDefaultFontSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsDefaultFontSizePropertyInfo = (~) Word32
    type AttrBaseTypeConstraint SettingsDefaultFontSizePropertyInfo = SettingsK
    type AttrGetType SettingsDefaultFontSizePropertyInfo = Word32
    type AttrLabel SettingsDefaultFontSizePropertyInfo = "default-font-size"
    attrGet _ = getSettingsDefaultFontSize
    attrSet _ = setSettingsDefaultFontSize
    attrConstruct _ = constructSettingsDefaultFontSize
    attrClear _ = undefined

-- VVV Prop "default-monospace-font-size"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

getSettingsDefaultMonospaceFontSize :: (MonadIO m, SettingsK o) => o -> m Word32
getSettingsDefaultMonospaceFontSize obj = liftIO $ getObjectPropertyUInt32 obj "default-monospace-font-size"

setSettingsDefaultMonospaceFontSize :: (MonadIO m, SettingsK o) => o -> Word32 -> m ()
setSettingsDefaultMonospaceFontSize obj val = liftIO $ setObjectPropertyUInt32 obj "default-monospace-font-size" val

constructSettingsDefaultMonospaceFontSize :: Word32 -> IO ([Char], GValue)
constructSettingsDefaultMonospaceFontSize val = constructObjectPropertyUInt32 "default-monospace-font-size" val

data SettingsDefaultMonospaceFontSizePropertyInfo
instance AttrInfo SettingsDefaultMonospaceFontSizePropertyInfo where
    type AttrAllowedOps SettingsDefaultMonospaceFontSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsDefaultMonospaceFontSizePropertyInfo = (~) Word32
    type AttrBaseTypeConstraint SettingsDefaultMonospaceFontSizePropertyInfo = SettingsK
    type AttrGetType SettingsDefaultMonospaceFontSizePropertyInfo = Word32
    type AttrLabel SettingsDefaultMonospaceFontSizePropertyInfo = "default-monospace-font-size"
    attrGet _ = getSettingsDefaultMonospaceFontSize
    attrSet _ = setSettingsDefaultMonospaceFontSize
    attrConstruct _ = constructSettingsDefaultMonospaceFontSize
    attrClear _ = undefined

-- VVV Prop "draw-compositing-indicators"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsDrawCompositingIndicators :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsDrawCompositingIndicators obj = liftIO $ getObjectPropertyBool obj "draw-compositing-indicators"

setSettingsDrawCompositingIndicators :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsDrawCompositingIndicators obj val = liftIO $ setObjectPropertyBool obj "draw-compositing-indicators" val

constructSettingsDrawCompositingIndicators :: Bool -> IO ([Char], GValue)
constructSettingsDrawCompositingIndicators val = constructObjectPropertyBool "draw-compositing-indicators" val

data SettingsDrawCompositingIndicatorsPropertyInfo
instance AttrInfo SettingsDrawCompositingIndicatorsPropertyInfo where
    type AttrAllowedOps SettingsDrawCompositingIndicatorsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsDrawCompositingIndicatorsPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsDrawCompositingIndicatorsPropertyInfo = SettingsK
    type AttrGetType SettingsDrawCompositingIndicatorsPropertyInfo = Bool
    type AttrLabel SettingsDrawCompositingIndicatorsPropertyInfo = "draw-compositing-indicators"
    attrGet _ = getSettingsDrawCompositingIndicators
    attrSet _ = setSettingsDrawCompositingIndicators
    attrConstruct _ = constructSettingsDrawCompositingIndicators
    attrClear _ = undefined

-- VVV Prop "enable-accelerated-2d-canvas"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableAccelerated2dCanvas :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableAccelerated2dCanvas obj = liftIO $ getObjectPropertyBool obj "enable-accelerated-2d-canvas"

setSettingsEnableAccelerated2dCanvas :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableAccelerated2dCanvas obj val = liftIO $ setObjectPropertyBool obj "enable-accelerated-2d-canvas" val

constructSettingsEnableAccelerated2dCanvas :: Bool -> IO ([Char], GValue)
constructSettingsEnableAccelerated2dCanvas val = constructObjectPropertyBool "enable-accelerated-2d-canvas" val

data SettingsEnableAccelerated2dCanvasPropertyInfo
instance AttrInfo SettingsEnableAccelerated2dCanvasPropertyInfo where
    type AttrAllowedOps SettingsEnableAccelerated2dCanvasPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableAccelerated2dCanvasPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableAccelerated2dCanvasPropertyInfo = SettingsK
    type AttrGetType SettingsEnableAccelerated2dCanvasPropertyInfo = Bool
    type AttrLabel SettingsEnableAccelerated2dCanvasPropertyInfo = "enable-accelerated-2d-canvas"
    attrGet _ = getSettingsEnableAccelerated2dCanvas
    attrSet _ = setSettingsEnableAccelerated2dCanvas
    attrConstruct _ = constructSettingsEnableAccelerated2dCanvas
    attrClear _ = undefined

-- VVV Prop "enable-caret-browsing"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableCaretBrowsing :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableCaretBrowsing obj = liftIO $ getObjectPropertyBool obj "enable-caret-browsing"

setSettingsEnableCaretBrowsing :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableCaretBrowsing obj val = liftIO $ setObjectPropertyBool obj "enable-caret-browsing" val

constructSettingsEnableCaretBrowsing :: Bool -> IO ([Char], GValue)
constructSettingsEnableCaretBrowsing val = constructObjectPropertyBool "enable-caret-browsing" val

data SettingsEnableCaretBrowsingPropertyInfo
instance AttrInfo SettingsEnableCaretBrowsingPropertyInfo where
    type AttrAllowedOps SettingsEnableCaretBrowsingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableCaretBrowsingPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableCaretBrowsingPropertyInfo = SettingsK
    type AttrGetType SettingsEnableCaretBrowsingPropertyInfo = Bool
    type AttrLabel SettingsEnableCaretBrowsingPropertyInfo = "enable-caret-browsing"
    attrGet _ = getSettingsEnableCaretBrowsing
    attrSet _ = setSettingsEnableCaretBrowsing
    attrConstruct _ = constructSettingsEnableCaretBrowsing
    attrClear _ = undefined

-- VVV Prop "enable-developer-extras"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableDeveloperExtras :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableDeveloperExtras obj = liftIO $ getObjectPropertyBool obj "enable-developer-extras"

setSettingsEnableDeveloperExtras :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableDeveloperExtras obj val = liftIO $ setObjectPropertyBool obj "enable-developer-extras" val

constructSettingsEnableDeveloperExtras :: Bool -> IO ([Char], GValue)
constructSettingsEnableDeveloperExtras val = constructObjectPropertyBool "enable-developer-extras" val

data SettingsEnableDeveloperExtrasPropertyInfo
instance AttrInfo SettingsEnableDeveloperExtrasPropertyInfo where
    type AttrAllowedOps SettingsEnableDeveloperExtrasPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableDeveloperExtrasPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableDeveloperExtrasPropertyInfo = SettingsK
    type AttrGetType SettingsEnableDeveloperExtrasPropertyInfo = Bool
    type AttrLabel SettingsEnableDeveloperExtrasPropertyInfo = "enable-developer-extras"
    attrGet _ = getSettingsEnableDeveloperExtras
    attrSet _ = setSettingsEnableDeveloperExtras
    attrConstruct _ = constructSettingsEnableDeveloperExtras
    attrClear _ = undefined

-- VVV Prop "enable-dns-prefetching"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableDnsPrefetching :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableDnsPrefetching obj = liftIO $ getObjectPropertyBool obj "enable-dns-prefetching"

setSettingsEnableDnsPrefetching :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableDnsPrefetching obj val = liftIO $ setObjectPropertyBool obj "enable-dns-prefetching" val

constructSettingsEnableDnsPrefetching :: Bool -> IO ([Char], GValue)
constructSettingsEnableDnsPrefetching val = constructObjectPropertyBool "enable-dns-prefetching" val

data SettingsEnableDnsPrefetchingPropertyInfo
instance AttrInfo SettingsEnableDnsPrefetchingPropertyInfo where
    type AttrAllowedOps SettingsEnableDnsPrefetchingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableDnsPrefetchingPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableDnsPrefetchingPropertyInfo = SettingsK
    type AttrGetType SettingsEnableDnsPrefetchingPropertyInfo = Bool
    type AttrLabel SettingsEnableDnsPrefetchingPropertyInfo = "enable-dns-prefetching"
    attrGet _ = getSettingsEnableDnsPrefetching
    attrSet _ = setSettingsEnableDnsPrefetching
    attrConstruct _ = constructSettingsEnableDnsPrefetching
    attrClear _ = undefined

-- VVV Prop "enable-frame-flattening"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableFrameFlattening :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableFrameFlattening obj = liftIO $ getObjectPropertyBool obj "enable-frame-flattening"

setSettingsEnableFrameFlattening :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableFrameFlattening obj val = liftIO $ setObjectPropertyBool obj "enable-frame-flattening" val

constructSettingsEnableFrameFlattening :: Bool -> IO ([Char], GValue)
constructSettingsEnableFrameFlattening val = constructObjectPropertyBool "enable-frame-flattening" val

data SettingsEnableFrameFlatteningPropertyInfo
instance AttrInfo SettingsEnableFrameFlatteningPropertyInfo where
    type AttrAllowedOps SettingsEnableFrameFlatteningPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableFrameFlatteningPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableFrameFlatteningPropertyInfo = SettingsK
    type AttrGetType SettingsEnableFrameFlatteningPropertyInfo = Bool
    type AttrLabel SettingsEnableFrameFlatteningPropertyInfo = "enable-frame-flattening"
    attrGet _ = getSettingsEnableFrameFlattening
    attrSet _ = setSettingsEnableFrameFlattening
    attrConstruct _ = constructSettingsEnableFrameFlattening
    attrClear _ = undefined

-- VVV Prop "enable-fullscreen"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableFullscreen :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableFullscreen obj = liftIO $ getObjectPropertyBool obj "enable-fullscreen"

setSettingsEnableFullscreen :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableFullscreen obj val = liftIO $ setObjectPropertyBool obj "enable-fullscreen" val

constructSettingsEnableFullscreen :: Bool -> IO ([Char], GValue)
constructSettingsEnableFullscreen val = constructObjectPropertyBool "enable-fullscreen" val

data SettingsEnableFullscreenPropertyInfo
instance AttrInfo SettingsEnableFullscreenPropertyInfo where
    type AttrAllowedOps SettingsEnableFullscreenPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableFullscreenPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableFullscreenPropertyInfo = SettingsK
    type AttrGetType SettingsEnableFullscreenPropertyInfo = Bool
    type AttrLabel SettingsEnableFullscreenPropertyInfo = "enable-fullscreen"
    attrGet _ = getSettingsEnableFullscreen
    attrSet _ = setSettingsEnableFullscreen
    attrConstruct _ = constructSettingsEnableFullscreen
    attrClear _ = undefined

-- VVV Prop "enable-html5-database"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableHtml5Database :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableHtml5Database obj = liftIO $ getObjectPropertyBool obj "enable-html5-database"

setSettingsEnableHtml5Database :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableHtml5Database obj val = liftIO $ setObjectPropertyBool obj "enable-html5-database" val

constructSettingsEnableHtml5Database :: Bool -> IO ([Char], GValue)
constructSettingsEnableHtml5Database val = constructObjectPropertyBool "enable-html5-database" val

data SettingsEnableHtml5DatabasePropertyInfo
instance AttrInfo SettingsEnableHtml5DatabasePropertyInfo where
    type AttrAllowedOps SettingsEnableHtml5DatabasePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableHtml5DatabasePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableHtml5DatabasePropertyInfo = SettingsK
    type AttrGetType SettingsEnableHtml5DatabasePropertyInfo = Bool
    type AttrLabel SettingsEnableHtml5DatabasePropertyInfo = "enable-html5-database"
    attrGet _ = getSettingsEnableHtml5Database
    attrSet _ = setSettingsEnableHtml5Database
    attrConstruct _ = constructSettingsEnableHtml5Database
    attrClear _ = undefined

-- VVV Prop "enable-html5-local-storage"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableHtml5LocalStorage :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableHtml5LocalStorage obj = liftIO $ getObjectPropertyBool obj "enable-html5-local-storage"

setSettingsEnableHtml5LocalStorage :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableHtml5LocalStorage obj val = liftIO $ setObjectPropertyBool obj "enable-html5-local-storage" val

constructSettingsEnableHtml5LocalStorage :: Bool -> IO ([Char], GValue)
constructSettingsEnableHtml5LocalStorage val = constructObjectPropertyBool "enable-html5-local-storage" val

data SettingsEnableHtml5LocalStoragePropertyInfo
instance AttrInfo SettingsEnableHtml5LocalStoragePropertyInfo where
    type AttrAllowedOps SettingsEnableHtml5LocalStoragePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableHtml5LocalStoragePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableHtml5LocalStoragePropertyInfo = SettingsK
    type AttrGetType SettingsEnableHtml5LocalStoragePropertyInfo = Bool
    type AttrLabel SettingsEnableHtml5LocalStoragePropertyInfo = "enable-html5-local-storage"
    attrGet _ = getSettingsEnableHtml5LocalStorage
    attrSet _ = setSettingsEnableHtml5LocalStorage
    attrConstruct _ = constructSettingsEnableHtml5LocalStorage
    attrClear _ = undefined

-- VVV Prop "enable-hyperlink-auditing"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableHyperlinkAuditing :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableHyperlinkAuditing obj = liftIO $ getObjectPropertyBool obj "enable-hyperlink-auditing"

setSettingsEnableHyperlinkAuditing :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableHyperlinkAuditing obj val = liftIO $ setObjectPropertyBool obj "enable-hyperlink-auditing" val

constructSettingsEnableHyperlinkAuditing :: Bool -> IO ([Char], GValue)
constructSettingsEnableHyperlinkAuditing val = constructObjectPropertyBool "enable-hyperlink-auditing" val

data SettingsEnableHyperlinkAuditingPropertyInfo
instance AttrInfo SettingsEnableHyperlinkAuditingPropertyInfo where
    type AttrAllowedOps SettingsEnableHyperlinkAuditingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableHyperlinkAuditingPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableHyperlinkAuditingPropertyInfo = SettingsK
    type AttrGetType SettingsEnableHyperlinkAuditingPropertyInfo = Bool
    type AttrLabel SettingsEnableHyperlinkAuditingPropertyInfo = "enable-hyperlink-auditing"
    attrGet _ = getSettingsEnableHyperlinkAuditing
    attrSet _ = setSettingsEnableHyperlinkAuditing
    attrConstruct _ = constructSettingsEnableHyperlinkAuditing
    attrClear _ = undefined

-- VVV Prop "enable-java"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableJava :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableJava obj = liftIO $ getObjectPropertyBool obj "enable-java"

setSettingsEnableJava :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableJava obj val = liftIO $ setObjectPropertyBool obj "enable-java" val

constructSettingsEnableJava :: Bool -> IO ([Char], GValue)
constructSettingsEnableJava val = constructObjectPropertyBool "enable-java" val

data SettingsEnableJavaPropertyInfo
instance AttrInfo SettingsEnableJavaPropertyInfo where
    type AttrAllowedOps SettingsEnableJavaPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableJavaPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableJavaPropertyInfo = SettingsK
    type AttrGetType SettingsEnableJavaPropertyInfo = Bool
    type AttrLabel SettingsEnableJavaPropertyInfo = "enable-java"
    attrGet _ = getSettingsEnableJava
    attrSet _ = setSettingsEnableJava
    attrConstruct _ = constructSettingsEnableJava
    attrClear _ = undefined

-- VVV Prop "enable-javascript"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableJavascript :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableJavascript obj = liftIO $ getObjectPropertyBool obj "enable-javascript"

setSettingsEnableJavascript :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableJavascript obj val = liftIO $ setObjectPropertyBool obj "enable-javascript" val

constructSettingsEnableJavascript :: Bool -> IO ([Char], GValue)
constructSettingsEnableJavascript val = constructObjectPropertyBool "enable-javascript" val

data SettingsEnableJavascriptPropertyInfo
instance AttrInfo SettingsEnableJavascriptPropertyInfo where
    type AttrAllowedOps SettingsEnableJavascriptPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableJavascriptPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableJavascriptPropertyInfo = SettingsK
    type AttrGetType SettingsEnableJavascriptPropertyInfo = Bool
    type AttrLabel SettingsEnableJavascriptPropertyInfo = "enable-javascript"
    attrGet _ = getSettingsEnableJavascript
    attrSet _ = setSettingsEnableJavascript
    attrConstruct _ = constructSettingsEnableJavascript
    attrClear _ = undefined

-- VVV Prop "enable-media-stream"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableMediaStream :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableMediaStream obj = liftIO $ getObjectPropertyBool obj "enable-media-stream"

setSettingsEnableMediaStream :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableMediaStream obj val = liftIO $ setObjectPropertyBool obj "enable-media-stream" val

constructSettingsEnableMediaStream :: Bool -> IO ([Char], GValue)
constructSettingsEnableMediaStream val = constructObjectPropertyBool "enable-media-stream" val

data SettingsEnableMediaStreamPropertyInfo
instance AttrInfo SettingsEnableMediaStreamPropertyInfo where
    type AttrAllowedOps SettingsEnableMediaStreamPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableMediaStreamPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableMediaStreamPropertyInfo = SettingsK
    type AttrGetType SettingsEnableMediaStreamPropertyInfo = Bool
    type AttrLabel SettingsEnableMediaStreamPropertyInfo = "enable-media-stream"
    attrGet _ = getSettingsEnableMediaStream
    attrSet _ = setSettingsEnableMediaStream
    attrConstruct _ = constructSettingsEnableMediaStream
    attrClear _ = undefined

-- VVV Prop "enable-mediasource"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableMediasource :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableMediasource obj = liftIO $ getObjectPropertyBool obj "enable-mediasource"

setSettingsEnableMediasource :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableMediasource obj val = liftIO $ setObjectPropertyBool obj "enable-mediasource" val

constructSettingsEnableMediasource :: Bool -> IO ([Char], GValue)
constructSettingsEnableMediasource val = constructObjectPropertyBool "enable-mediasource" val

data SettingsEnableMediasourcePropertyInfo
instance AttrInfo SettingsEnableMediasourcePropertyInfo where
    type AttrAllowedOps SettingsEnableMediasourcePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableMediasourcePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableMediasourcePropertyInfo = SettingsK
    type AttrGetType SettingsEnableMediasourcePropertyInfo = Bool
    type AttrLabel SettingsEnableMediasourcePropertyInfo = "enable-mediasource"
    attrGet _ = getSettingsEnableMediasource
    attrSet _ = setSettingsEnableMediasource
    attrConstruct _ = constructSettingsEnableMediasource
    attrClear _ = undefined

-- VVV Prop "enable-offline-web-application-cache"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableOfflineWebApplicationCache :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableOfflineWebApplicationCache obj = liftIO $ getObjectPropertyBool obj "enable-offline-web-application-cache"

setSettingsEnableOfflineWebApplicationCache :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableOfflineWebApplicationCache obj val = liftIO $ setObjectPropertyBool obj "enable-offline-web-application-cache" val

constructSettingsEnableOfflineWebApplicationCache :: Bool -> IO ([Char], GValue)
constructSettingsEnableOfflineWebApplicationCache val = constructObjectPropertyBool "enable-offline-web-application-cache" val

data SettingsEnableOfflineWebApplicationCachePropertyInfo
instance AttrInfo SettingsEnableOfflineWebApplicationCachePropertyInfo where
    type AttrAllowedOps SettingsEnableOfflineWebApplicationCachePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableOfflineWebApplicationCachePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableOfflineWebApplicationCachePropertyInfo = SettingsK
    type AttrGetType SettingsEnableOfflineWebApplicationCachePropertyInfo = Bool
    type AttrLabel SettingsEnableOfflineWebApplicationCachePropertyInfo = "enable-offline-web-application-cache"
    attrGet _ = getSettingsEnableOfflineWebApplicationCache
    attrSet _ = setSettingsEnableOfflineWebApplicationCache
    attrConstruct _ = constructSettingsEnableOfflineWebApplicationCache
    attrClear _ = undefined

-- VVV Prop "enable-page-cache"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnablePageCache :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnablePageCache obj = liftIO $ getObjectPropertyBool obj "enable-page-cache"

setSettingsEnablePageCache :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnablePageCache obj val = liftIO $ setObjectPropertyBool obj "enable-page-cache" val

constructSettingsEnablePageCache :: Bool -> IO ([Char], GValue)
constructSettingsEnablePageCache val = constructObjectPropertyBool "enable-page-cache" val

data SettingsEnablePageCachePropertyInfo
instance AttrInfo SettingsEnablePageCachePropertyInfo where
    type AttrAllowedOps SettingsEnablePageCachePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnablePageCachePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnablePageCachePropertyInfo = SettingsK
    type AttrGetType SettingsEnablePageCachePropertyInfo = Bool
    type AttrLabel SettingsEnablePageCachePropertyInfo = "enable-page-cache"
    attrGet _ = getSettingsEnablePageCache
    attrSet _ = setSettingsEnablePageCache
    attrConstruct _ = constructSettingsEnablePageCache
    attrClear _ = undefined

-- VVV Prop "enable-plugins"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnablePlugins :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnablePlugins obj = liftIO $ getObjectPropertyBool obj "enable-plugins"

setSettingsEnablePlugins :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnablePlugins obj val = liftIO $ setObjectPropertyBool obj "enable-plugins" val

constructSettingsEnablePlugins :: Bool -> IO ([Char], GValue)
constructSettingsEnablePlugins val = constructObjectPropertyBool "enable-plugins" val

data SettingsEnablePluginsPropertyInfo
instance AttrInfo SettingsEnablePluginsPropertyInfo where
    type AttrAllowedOps SettingsEnablePluginsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnablePluginsPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnablePluginsPropertyInfo = SettingsK
    type AttrGetType SettingsEnablePluginsPropertyInfo = Bool
    type AttrLabel SettingsEnablePluginsPropertyInfo = "enable-plugins"
    attrGet _ = getSettingsEnablePlugins
    attrSet _ = setSettingsEnablePlugins
    attrConstruct _ = constructSettingsEnablePlugins
    attrClear _ = undefined

-- VVV Prop "enable-private-browsing"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnablePrivateBrowsing :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnablePrivateBrowsing obj = liftIO $ getObjectPropertyBool obj "enable-private-browsing"

setSettingsEnablePrivateBrowsing :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnablePrivateBrowsing obj val = liftIO $ setObjectPropertyBool obj "enable-private-browsing" val

constructSettingsEnablePrivateBrowsing :: Bool -> IO ([Char], GValue)
constructSettingsEnablePrivateBrowsing val = constructObjectPropertyBool "enable-private-browsing" val

data SettingsEnablePrivateBrowsingPropertyInfo
instance AttrInfo SettingsEnablePrivateBrowsingPropertyInfo where
    type AttrAllowedOps SettingsEnablePrivateBrowsingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnablePrivateBrowsingPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnablePrivateBrowsingPropertyInfo = SettingsK
    type AttrGetType SettingsEnablePrivateBrowsingPropertyInfo = Bool
    type AttrLabel SettingsEnablePrivateBrowsingPropertyInfo = "enable-private-browsing"
    attrGet _ = getSettingsEnablePrivateBrowsing
    attrSet _ = setSettingsEnablePrivateBrowsing
    attrConstruct _ = constructSettingsEnablePrivateBrowsing
    attrClear _ = undefined

-- VVV Prop "enable-resizable-text-areas"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableResizableTextAreas :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableResizableTextAreas obj = liftIO $ getObjectPropertyBool obj "enable-resizable-text-areas"

setSettingsEnableResizableTextAreas :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableResizableTextAreas obj val = liftIO $ setObjectPropertyBool obj "enable-resizable-text-areas" val

constructSettingsEnableResizableTextAreas :: Bool -> IO ([Char], GValue)
constructSettingsEnableResizableTextAreas val = constructObjectPropertyBool "enable-resizable-text-areas" val

data SettingsEnableResizableTextAreasPropertyInfo
instance AttrInfo SettingsEnableResizableTextAreasPropertyInfo where
    type AttrAllowedOps SettingsEnableResizableTextAreasPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableResizableTextAreasPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableResizableTextAreasPropertyInfo = SettingsK
    type AttrGetType SettingsEnableResizableTextAreasPropertyInfo = Bool
    type AttrLabel SettingsEnableResizableTextAreasPropertyInfo = "enable-resizable-text-areas"
    attrGet _ = getSettingsEnableResizableTextAreas
    attrSet _ = setSettingsEnableResizableTextAreas
    attrConstruct _ = constructSettingsEnableResizableTextAreas
    attrClear _ = undefined

-- VVV Prop "enable-site-specific-quirks"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableSiteSpecificQuirks :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableSiteSpecificQuirks obj = liftIO $ getObjectPropertyBool obj "enable-site-specific-quirks"

setSettingsEnableSiteSpecificQuirks :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableSiteSpecificQuirks obj val = liftIO $ setObjectPropertyBool obj "enable-site-specific-quirks" val

constructSettingsEnableSiteSpecificQuirks :: Bool -> IO ([Char], GValue)
constructSettingsEnableSiteSpecificQuirks val = constructObjectPropertyBool "enable-site-specific-quirks" val

data SettingsEnableSiteSpecificQuirksPropertyInfo
instance AttrInfo SettingsEnableSiteSpecificQuirksPropertyInfo where
    type AttrAllowedOps SettingsEnableSiteSpecificQuirksPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableSiteSpecificQuirksPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableSiteSpecificQuirksPropertyInfo = SettingsK
    type AttrGetType SettingsEnableSiteSpecificQuirksPropertyInfo = Bool
    type AttrLabel SettingsEnableSiteSpecificQuirksPropertyInfo = "enable-site-specific-quirks"
    attrGet _ = getSettingsEnableSiteSpecificQuirks
    attrSet _ = setSettingsEnableSiteSpecificQuirks
    attrConstruct _ = constructSettingsEnableSiteSpecificQuirks
    attrClear _ = undefined

-- VVV Prop "enable-smooth-scrolling"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableSmoothScrolling :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableSmoothScrolling obj = liftIO $ getObjectPropertyBool obj "enable-smooth-scrolling"

setSettingsEnableSmoothScrolling :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableSmoothScrolling obj val = liftIO $ setObjectPropertyBool obj "enable-smooth-scrolling" val

constructSettingsEnableSmoothScrolling :: Bool -> IO ([Char], GValue)
constructSettingsEnableSmoothScrolling val = constructObjectPropertyBool "enable-smooth-scrolling" val

data SettingsEnableSmoothScrollingPropertyInfo
instance AttrInfo SettingsEnableSmoothScrollingPropertyInfo where
    type AttrAllowedOps SettingsEnableSmoothScrollingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableSmoothScrollingPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableSmoothScrollingPropertyInfo = SettingsK
    type AttrGetType SettingsEnableSmoothScrollingPropertyInfo = Bool
    type AttrLabel SettingsEnableSmoothScrollingPropertyInfo = "enable-smooth-scrolling"
    attrGet _ = getSettingsEnableSmoothScrolling
    attrSet _ = setSettingsEnableSmoothScrolling
    attrConstruct _ = constructSettingsEnableSmoothScrolling
    attrClear _ = undefined

-- VVV Prop "enable-spatial-navigation"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableSpatialNavigation :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableSpatialNavigation obj = liftIO $ getObjectPropertyBool obj "enable-spatial-navigation"

setSettingsEnableSpatialNavigation :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableSpatialNavigation obj val = liftIO $ setObjectPropertyBool obj "enable-spatial-navigation" val

constructSettingsEnableSpatialNavigation :: Bool -> IO ([Char], GValue)
constructSettingsEnableSpatialNavigation val = constructObjectPropertyBool "enable-spatial-navigation" val

data SettingsEnableSpatialNavigationPropertyInfo
instance AttrInfo SettingsEnableSpatialNavigationPropertyInfo where
    type AttrAllowedOps SettingsEnableSpatialNavigationPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableSpatialNavigationPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableSpatialNavigationPropertyInfo = SettingsK
    type AttrGetType SettingsEnableSpatialNavigationPropertyInfo = Bool
    type AttrLabel SettingsEnableSpatialNavigationPropertyInfo = "enable-spatial-navigation"
    attrGet _ = getSettingsEnableSpatialNavigation
    attrSet _ = setSettingsEnableSpatialNavigation
    attrConstruct _ = constructSettingsEnableSpatialNavigation
    attrClear _ = undefined

-- VVV Prop "enable-tabs-to-links"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableTabsToLinks :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableTabsToLinks obj = liftIO $ getObjectPropertyBool obj "enable-tabs-to-links"

setSettingsEnableTabsToLinks :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableTabsToLinks obj val = liftIO $ setObjectPropertyBool obj "enable-tabs-to-links" val

constructSettingsEnableTabsToLinks :: Bool -> IO ([Char], GValue)
constructSettingsEnableTabsToLinks val = constructObjectPropertyBool "enable-tabs-to-links" val

data SettingsEnableTabsToLinksPropertyInfo
instance AttrInfo SettingsEnableTabsToLinksPropertyInfo where
    type AttrAllowedOps SettingsEnableTabsToLinksPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableTabsToLinksPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableTabsToLinksPropertyInfo = SettingsK
    type AttrGetType SettingsEnableTabsToLinksPropertyInfo = Bool
    type AttrLabel SettingsEnableTabsToLinksPropertyInfo = "enable-tabs-to-links"
    attrGet _ = getSettingsEnableTabsToLinks
    attrSet _ = setSettingsEnableTabsToLinks
    attrConstruct _ = constructSettingsEnableTabsToLinks
    attrClear _ = undefined

-- VVV Prop "enable-webaudio"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableWebaudio :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableWebaudio obj = liftIO $ getObjectPropertyBool obj "enable-webaudio"

setSettingsEnableWebaudio :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableWebaudio obj val = liftIO $ setObjectPropertyBool obj "enable-webaudio" val

constructSettingsEnableWebaudio :: Bool -> IO ([Char], GValue)
constructSettingsEnableWebaudio val = constructObjectPropertyBool "enable-webaudio" val

data SettingsEnableWebaudioPropertyInfo
instance AttrInfo SettingsEnableWebaudioPropertyInfo where
    type AttrAllowedOps SettingsEnableWebaudioPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableWebaudioPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableWebaudioPropertyInfo = SettingsK
    type AttrGetType SettingsEnableWebaudioPropertyInfo = Bool
    type AttrLabel SettingsEnableWebaudioPropertyInfo = "enable-webaudio"
    attrGet _ = getSettingsEnableWebaudio
    attrSet _ = setSettingsEnableWebaudio
    attrConstruct _ = constructSettingsEnableWebaudio
    attrClear _ = undefined

-- VVV Prop "enable-webgl"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableWebgl :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableWebgl obj = liftIO $ getObjectPropertyBool obj "enable-webgl"

setSettingsEnableWebgl :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableWebgl obj val = liftIO $ setObjectPropertyBool obj "enable-webgl" val

constructSettingsEnableWebgl :: Bool -> IO ([Char], GValue)
constructSettingsEnableWebgl val = constructObjectPropertyBool "enable-webgl" val

data SettingsEnableWebglPropertyInfo
instance AttrInfo SettingsEnableWebglPropertyInfo where
    type AttrAllowedOps SettingsEnableWebglPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableWebglPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableWebglPropertyInfo = SettingsK
    type AttrGetType SettingsEnableWebglPropertyInfo = Bool
    type AttrLabel SettingsEnableWebglPropertyInfo = "enable-webgl"
    attrGet _ = getSettingsEnableWebgl
    attrSet _ = setSettingsEnableWebgl
    attrConstruct _ = constructSettingsEnableWebgl
    attrClear _ = undefined

-- VVV Prop "enable-write-console-messages-to-stdout"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableWriteConsoleMessagesToStdout :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableWriteConsoleMessagesToStdout obj = liftIO $ getObjectPropertyBool obj "enable-write-console-messages-to-stdout"

setSettingsEnableWriteConsoleMessagesToStdout :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableWriteConsoleMessagesToStdout obj val = liftIO $ setObjectPropertyBool obj "enable-write-console-messages-to-stdout" val

constructSettingsEnableWriteConsoleMessagesToStdout :: Bool -> IO ([Char], GValue)
constructSettingsEnableWriteConsoleMessagesToStdout val = constructObjectPropertyBool "enable-write-console-messages-to-stdout" val

data SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo
instance AttrInfo SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo where
    type AttrAllowedOps SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo = SettingsK
    type AttrGetType SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo = Bool
    type AttrLabel SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo = "enable-write-console-messages-to-stdout"
    attrGet _ = getSettingsEnableWriteConsoleMessagesToStdout
    attrSet _ = setSettingsEnableWriteConsoleMessagesToStdout
    attrConstruct _ = constructSettingsEnableWriteConsoleMessagesToStdout
    attrClear _ = undefined

-- VVV Prop "enable-xss-auditor"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsEnableXssAuditor :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsEnableXssAuditor obj = liftIO $ getObjectPropertyBool obj "enable-xss-auditor"

setSettingsEnableXssAuditor :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsEnableXssAuditor obj val = liftIO $ setObjectPropertyBool obj "enable-xss-auditor" val

constructSettingsEnableXssAuditor :: Bool -> IO ([Char], GValue)
constructSettingsEnableXssAuditor val = constructObjectPropertyBool "enable-xss-auditor" val

data SettingsEnableXssAuditorPropertyInfo
instance AttrInfo SettingsEnableXssAuditorPropertyInfo where
    type AttrAllowedOps SettingsEnableXssAuditorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsEnableXssAuditorPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsEnableXssAuditorPropertyInfo = SettingsK
    type AttrGetType SettingsEnableXssAuditorPropertyInfo = Bool
    type AttrLabel SettingsEnableXssAuditorPropertyInfo = "enable-xss-auditor"
    attrGet _ = getSettingsEnableXssAuditor
    attrSet _ = setSettingsEnableXssAuditor
    attrConstruct _ = constructSettingsEnableXssAuditor
    attrClear _ = undefined

-- VVV Prop "fantasy-font-family"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsFantasyFontFamily :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsFantasyFontFamily obj = liftIO $ checkUnexpectedNothing "getSettingsFantasyFontFamily" $ getObjectPropertyString obj "fantasy-font-family"

setSettingsFantasyFontFamily :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsFantasyFontFamily obj val = liftIO $ setObjectPropertyString obj "fantasy-font-family" (Just val)

constructSettingsFantasyFontFamily :: T.Text -> IO ([Char], GValue)
constructSettingsFantasyFontFamily val = constructObjectPropertyString "fantasy-font-family" (Just val)

data SettingsFantasyFontFamilyPropertyInfo
instance AttrInfo SettingsFantasyFontFamilyPropertyInfo where
    type AttrAllowedOps SettingsFantasyFontFamilyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsFantasyFontFamilyPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsFantasyFontFamilyPropertyInfo = SettingsK
    type AttrGetType SettingsFantasyFontFamilyPropertyInfo = T.Text
    type AttrLabel SettingsFantasyFontFamilyPropertyInfo = "fantasy-font-family"
    attrGet _ = getSettingsFantasyFontFamily
    attrSet _ = setSettingsFantasyFontFamily
    attrConstruct _ = constructSettingsFantasyFontFamily
    attrClear _ = undefined

-- VVV Prop "javascript-can-access-clipboard"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsJavascriptCanAccessClipboard :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsJavascriptCanAccessClipboard obj = liftIO $ getObjectPropertyBool obj "javascript-can-access-clipboard"

setSettingsJavascriptCanAccessClipboard :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsJavascriptCanAccessClipboard obj val = liftIO $ setObjectPropertyBool obj "javascript-can-access-clipboard" val

constructSettingsJavascriptCanAccessClipboard :: Bool -> IO ([Char], GValue)
constructSettingsJavascriptCanAccessClipboard val = constructObjectPropertyBool "javascript-can-access-clipboard" val

data SettingsJavascriptCanAccessClipboardPropertyInfo
instance AttrInfo SettingsJavascriptCanAccessClipboardPropertyInfo where
    type AttrAllowedOps SettingsJavascriptCanAccessClipboardPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsJavascriptCanAccessClipboardPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsJavascriptCanAccessClipboardPropertyInfo = SettingsK
    type AttrGetType SettingsJavascriptCanAccessClipboardPropertyInfo = Bool
    type AttrLabel SettingsJavascriptCanAccessClipboardPropertyInfo = "javascript-can-access-clipboard"
    attrGet _ = getSettingsJavascriptCanAccessClipboard
    attrSet _ = setSettingsJavascriptCanAccessClipboard
    attrConstruct _ = constructSettingsJavascriptCanAccessClipboard
    attrClear _ = undefined

-- VVV Prop "javascript-can-open-windows-automatically"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsJavascriptCanOpenWindowsAutomatically :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsJavascriptCanOpenWindowsAutomatically obj = liftIO $ getObjectPropertyBool obj "javascript-can-open-windows-automatically"

setSettingsJavascriptCanOpenWindowsAutomatically :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsJavascriptCanOpenWindowsAutomatically obj val = liftIO $ setObjectPropertyBool obj "javascript-can-open-windows-automatically" val

constructSettingsJavascriptCanOpenWindowsAutomatically :: Bool -> IO ([Char], GValue)
constructSettingsJavascriptCanOpenWindowsAutomatically val = constructObjectPropertyBool "javascript-can-open-windows-automatically" val

data SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo
instance AttrInfo SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo where
    type AttrAllowedOps SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo = SettingsK
    type AttrGetType SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo = Bool
    type AttrLabel SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo = "javascript-can-open-windows-automatically"
    attrGet _ = getSettingsJavascriptCanOpenWindowsAutomatically
    attrSet _ = setSettingsJavascriptCanOpenWindowsAutomatically
    attrConstruct _ = constructSettingsJavascriptCanOpenWindowsAutomatically
    attrClear _ = undefined

-- VVV Prop "load-icons-ignoring-image-load-setting"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsLoadIconsIgnoringImageLoadSetting :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsLoadIconsIgnoringImageLoadSetting obj = liftIO $ getObjectPropertyBool obj "load-icons-ignoring-image-load-setting"

setSettingsLoadIconsIgnoringImageLoadSetting :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsLoadIconsIgnoringImageLoadSetting obj val = liftIO $ setObjectPropertyBool obj "load-icons-ignoring-image-load-setting" val

constructSettingsLoadIconsIgnoringImageLoadSetting :: Bool -> IO ([Char], GValue)
constructSettingsLoadIconsIgnoringImageLoadSetting val = constructObjectPropertyBool "load-icons-ignoring-image-load-setting" val

data SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo
instance AttrInfo SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo where
    type AttrAllowedOps SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo = SettingsK
    type AttrGetType SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo = Bool
    type AttrLabel SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo = "load-icons-ignoring-image-load-setting"
    attrGet _ = getSettingsLoadIconsIgnoringImageLoadSetting
    attrSet _ = setSettingsLoadIconsIgnoringImageLoadSetting
    attrConstruct _ = constructSettingsLoadIconsIgnoringImageLoadSetting
    attrClear _ = undefined

-- VVV Prop "media-playback-allows-inline"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsMediaPlaybackAllowsInline :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsMediaPlaybackAllowsInline obj = liftIO $ getObjectPropertyBool obj "media-playback-allows-inline"

setSettingsMediaPlaybackAllowsInline :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsMediaPlaybackAllowsInline obj val = liftIO $ setObjectPropertyBool obj "media-playback-allows-inline" val

constructSettingsMediaPlaybackAllowsInline :: Bool -> IO ([Char], GValue)
constructSettingsMediaPlaybackAllowsInline val = constructObjectPropertyBool "media-playback-allows-inline" val

data SettingsMediaPlaybackAllowsInlinePropertyInfo
instance AttrInfo SettingsMediaPlaybackAllowsInlinePropertyInfo where
    type AttrAllowedOps SettingsMediaPlaybackAllowsInlinePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsMediaPlaybackAllowsInlinePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsMediaPlaybackAllowsInlinePropertyInfo = SettingsK
    type AttrGetType SettingsMediaPlaybackAllowsInlinePropertyInfo = Bool
    type AttrLabel SettingsMediaPlaybackAllowsInlinePropertyInfo = "media-playback-allows-inline"
    attrGet _ = getSettingsMediaPlaybackAllowsInline
    attrSet _ = setSettingsMediaPlaybackAllowsInline
    attrConstruct _ = constructSettingsMediaPlaybackAllowsInline
    attrClear _ = undefined

-- VVV Prop "media-playback-requires-user-gesture"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsMediaPlaybackRequiresUserGesture :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsMediaPlaybackRequiresUserGesture obj = liftIO $ getObjectPropertyBool obj "media-playback-requires-user-gesture"

setSettingsMediaPlaybackRequiresUserGesture :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsMediaPlaybackRequiresUserGesture obj val = liftIO $ setObjectPropertyBool obj "media-playback-requires-user-gesture" val

constructSettingsMediaPlaybackRequiresUserGesture :: Bool -> IO ([Char], GValue)
constructSettingsMediaPlaybackRequiresUserGesture val = constructObjectPropertyBool "media-playback-requires-user-gesture" val

data SettingsMediaPlaybackRequiresUserGesturePropertyInfo
instance AttrInfo SettingsMediaPlaybackRequiresUserGesturePropertyInfo where
    type AttrAllowedOps SettingsMediaPlaybackRequiresUserGesturePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsMediaPlaybackRequiresUserGesturePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsMediaPlaybackRequiresUserGesturePropertyInfo = SettingsK
    type AttrGetType SettingsMediaPlaybackRequiresUserGesturePropertyInfo = Bool
    type AttrLabel SettingsMediaPlaybackRequiresUserGesturePropertyInfo = "media-playback-requires-user-gesture"
    attrGet _ = getSettingsMediaPlaybackRequiresUserGesture
    attrSet _ = setSettingsMediaPlaybackRequiresUserGesture
    attrConstruct _ = constructSettingsMediaPlaybackRequiresUserGesture
    attrClear _ = undefined

-- VVV Prop "minimum-font-size"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

getSettingsMinimumFontSize :: (MonadIO m, SettingsK o) => o -> m Word32
getSettingsMinimumFontSize obj = liftIO $ getObjectPropertyUInt32 obj "minimum-font-size"

setSettingsMinimumFontSize :: (MonadIO m, SettingsK o) => o -> Word32 -> m ()
setSettingsMinimumFontSize obj val = liftIO $ setObjectPropertyUInt32 obj "minimum-font-size" val

constructSettingsMinimumFontSize :: Word32 -> IO ([Char], GValue)
constructSettingsMinimumFontSize val = constructObjectPropertyUInt32 "minimum-font-size" val

data SettingsMinimumFontSizePropertyInfo
instance AttrInfo SettingsMinimumFontSizePropertyInfo where
    type AttrAllowedOps SettingsMinimumFontSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsMinimumFontSizePropertyInfo = (~) Word32
    type AttrBaseTypeConstraint SettingsMinimumFontSizePropertyInfo = SettingsK
    type AttrGetType SettingsMinimumFontSizePropertyInfo = Word32
    type AttrLabel SettingsMinimumFontSizePropertyInfo = "minimum-font-size"
    attrGet _ = getSettingsMinimumFontSize
    attrSet _ = setSettingsMinimumFontSize
    attrConstruct _ = constructSettingsMinimumFontSize
    attrClear _ = undefined

-- VVV Prop "monospace-font-family"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsMonospaceFontFamily :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsMonospaceFontFamily obj = liftIO $ checkUnexpectedNothing "getSettingsMonospaceFontFamily" $ getObjectPropertyString obj "monospace-font-family"

setSettingsMonospaceFontFamily :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsMonospaceFontFamily obj val = liftIO $ setObjectPropertyString obj "monospace-font-family" (Just val)

constructSettingsMonospaceFontFamily :: T.Text -> IO ([Char], GValue)
constructSettingsMonospaceFontFamily val = constructObjectPropertyString "monospace-font-family" (Just val)

data SettingsMonospaceFontFamilyPropertyInfo
instance AttrInfo SettingsMonospaceFontFamilyPropertyInfo where
    type AttrAllowedOps SettingsMonospaceFontFamilyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsMonospaceFontFamilyPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsMonospaceFontFamilyPropertyInfo = SettingsK
    type AttrGetType SettingsMonospaceFontFamilyPropertyInfo = T.Text
    type AttrLabel SettingsMonospaceFontFamilyPropertyInfo = "monospace-font-family"
    attrGet _ = getSettingsMonospaceFontFamily
    attrSet _ = setSettingsMonospaceFontFamily
    attrConstruct _ = constructSettingsMonospaceFontFamily
    attrClear _ = undefined

-- VVV Prop "pictograph-font-family"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsPictographFontFamily :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsPictographFontFamily obj = liftIO $ checkUnexpectedNothing "getSettingsPictographFontFamily" $ getObjectPropertyString obj "pictograph-font-family"

setSettingsPictographFontFamily :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsPictographFontFamily obj val = liftIO $ setObjectPropertyString obj "pictograph-font-family" (Just val)

constructSettingsPictographFontFamily :: T.Text -> IO ([Char], GValue)
constructSettingsPictographFontFamily val = constructObjectPropertyString "pictograph-font-family" (Just val)

data SettingsPictographFontFamilyPropertyInfo
instance AttrInfo SettingsPictographFontFamilyPropertyInfo where
    type AttrAllowedOps SettingsPictographFontFamilyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsPictographFontFamilyPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsPictographFontFamilyPropertyInfo = SettingsK
    type AttrGetType SettingsPictographFontFamilyPropertyInfo = T.Text
    type AttrLabel SettingsPictographFontFamilyPropertyInfo = "pictograph-font-family"
    attrGet _ = getSettingsPictographFontFamily
    attrSet _ = setSettingsPictographFontFamily
    attrConstruct _ = constructSettingsPictographFontFamily
    attrClear _ = undefined

-- VVV Prop "print-backgrounds"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsPrintBackgrounds :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsPrintBackgrounds obj = liftIO $ getObjectPropertyBool obj "print-backgrounds"

setSettingsPrintBackgrounds :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsPrintBackgrounds obj val = liftIO $ setObjectPropertyBool obj "print-backgrounds" val

constructSettingsPrintBackgrounds :: Bool -> IO ([Char], GValue)
constructSettingsPrintBackgrounds val = constructObjectPropertyBool "print-backgrounds" val

data SettingsPrintBackgroundsPropertyInfo
instance AttrInfo SettingsPrintBackgroundsPropertyInfo where
    type AttrAllowedOps SettingsPrintBackgroundsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsPrintBackgroundsPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsPrintBackgroundsPropertyInfo = SettingsK
    type AttrGetType SettingsPrintBackgroundsPropertyInfo = Bool
    type AttrLabel SettingsPrintBackgroundsPropertyInfo = "print-backgrounds"
    attrGet _ = getSettingsPrintBackgrounds
    attrSet _ = setSettingsPrintBackgrounds
    attrConstruct _ = constructSettingsPrintBackgrounds
    attrClear _ = undefined

-- VVV Prop "sans-serif-font-family"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsSansSerifFontFamily :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsSansSerifFontFamily obj = liftIO $ checkUnexpectedNothing "getSettingsSansSerifFontFamily" $ getObjectPropertyString obj "sans-serif-font-family"

setSettingsSansSerifFontFamily :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsSansSerifFontFamily obj val = liftIO $ setObjectPropertyString obj "sans-serif-font-family" (Just val)

constructSettingsSansSerifFontFamily :: T.Text -> IO ([Char], GValue)
constructSettingsSansSerifFontFamily val = constructObjectPropertyString "sans-serif-font-family" (Just val)

data SettingsSansSerifFontFamilyPropertyInfo
instance AttrInfo SettingsSansSerifFontFamilyPropertyInfo where
    type AttrAllowedOps SettingsSansSerifFontFamilyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsSansSerifFontFamilyPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsSansSerifFontFamilyPropertyInfo = SettingsK
    type AttrGetType SettingsSansSerifFontFamilyPropertyInfo = T.Text
    type AttrLabel SettingsSansSerifFontFamilyPropertyInfo = "sans-serif-font-family"
    attrGet _ = getSettingsSansSerifFontFamily
    attrSet _ = setSettingsSansSerifFontFamily
    attrConstruct _ = constructSettingsSansSerifFontFamily
    attrClear _ = undefined

-- VVV Prop "serif-font-family"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsSerifFontFamily :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsSerifFontFamily obj = liftIO $ checkUnexpectedNothing "getSettingsSerifFontFamily" $ getObjectPropertyString obj "serif-font-family"

setSettingsSerifFontFamily :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsSerifFontFamily obj val = liftIO $ setObjectPropertyString obj "serif-font-family" (Just val)

constructSettingsSerifFontFamily :: T.Text -> IO ([Char], GValue)
constructSettingsSerifFontFamily val = constructObjectPropertyString "serif-font-family" (Just val)

data SettingsSerifFontFamilyPropertyInfo
instance AttrInfo SettingsSerifFontFamilyPropertyInfo where
    type AttrAllowedOps SettingsSerifFontFamilyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsSerifFontFamilyPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsSerifFontFamilyPropertyInfo = SettingsK
    type AttrGetType SettingsSerifFontFamilyPropertyInfo = T.Text
    type AttrLabel SettingsSerifFontFamilyPropertyInfo = "serif-font-family"
    attrGet _ = getSettingsSerifFontFamily
    attrSet _ = setSettingsSerifFontFamily
    attrConstruct _ = constructSettingsSerifFontFamily
    attrClear _ = undefined

-- VVV Prop "user-agent"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just True)

getSettingsUserAgent :: (MonadIO m, SettingsK o) => o -> m T.Text
getSettingsUserAgent obj = liftIO $ checkUnexpectedNothing "getSettingsUserAgent" $ getObjectPropertyString obj "user-agent"

setSettingsUserAgent :: (MonadIO m, SettingsK o) => o -> T.Text -> m ()
setSettingsUserAgent obj val = liftIO $ setObjectPropertyString obj "user-agent" (Just val)

constructSettingsUserAgent :: T.Text -> IO ([Char], GValue)
constructSettingsUserAgent val = constructObjectPropertyString "user-agent" (Just val)

clearSettingsUserAgent :: (MonadIO m, SettingsK o) => o -> m ()
clearSettingsUserAgent obj = liftIO $ setObjectPropertyString obj "user-agent" (Nothing :: Maybe T.Text)

data SettingsUserAgentPropertyInfo
instance AttrInfo SettingsUserAgentPropertyInfo where
    type AttrAllowedOps SettingsUserAgentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SettingsUserAgentPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint SettingsUserAgentPropertyInfo = SettingsK
    type AttrGetType SettingsUserAgentPropertyInfo = T.Text
    type AttrLabel SettingsUserAgentPropertyInfo = "user-agent"
    attrGet _ = getSettingsUserAgent
    attrSet _ = setSettingsUserAgent
    attrConstruct _ = constructSettingsUserAgent
    attrClear _ = clearSettingsUserAgent

-- VVV Prop "zoom-text-only"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getSettingsZoomTextOnly :: (MonadIO m, SettingsK o) => o -> m Bool
getSettingsZoomTextOnly obj = liftIO $ getObjectPropertyBool obj "zoom-text-only"

setSettingsZoomTextOnly :: (MonadIO m, SettingsK o) => o -> Bool -> m ()
setSettingsZoomTextOnly obj val = liftIO $ setObjectPropertyBool obj "zoom-text-only" val

constructSettingsZoomTextOnly :: Bool -> IO ([Char], GValue)
constructSettingsZoomTextOnly val = constructObjectPropertyBool "zoom-text-only" val

data SettingsZoomTextOnlyPropertyInfo
instance AttrInfo SettingsZoomTextOnlyPropertyInfo where
    type AttrAllowedOps SettingsZoomTextOnlyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint SettingsZoomTextOnlyPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint SettingsZoomTextOnlyPropertyInfo = SettingsK
    type AttrGetType SettingsZoomTextOnlyPropertyInfo = Bool
    type AttrLabel SettingsZoomTextOnlyPropertyInfo = "zoom-text-only"
    attrGet _ = getSettingsZoomTextOnly
    attrSet _ = setSettingsZoomTextOnly
    attrConstruct _ = constructSettingsZoomTextOnly
    attrClear _ = undefined

type instance AttributeList Settings = SettingsAttributeList
type SettingsAttributeList = ('[ '("allowFileAccessFromFileUrls", SettingsAllowFileAccessFromFileUrlsPropertyInfo), '("allowModalDialogs", SettingsAllowModalDialogsPropertyInfo), '("autoLoadImages", SettingsAutoLoadImagesPropertyInfo), '("cursiveFontFamily", SettingsCursiveFontFamilyPropertyInfo), '("defaultCharset", SettingsDefaultCharsetPropertyInfo), '("defaultFontFamily", SettingsDefaultFontFamilyPropertyInfo), '("defaultFontSize", SettingsDefaultFontSizePropertyInfo), '("defaultMonospaceFontSize", SettingsDefaultMonospaceFontSizePropertyInfo), '("drawCompositingIndicators", SettingsDrawCompositingIndicatorsPropertyInfo), '("enableAccelerated2dCanvas", SettingsEnableAccelerated2dCanvasPropertyInfo), '("enableCaretBrowsing", SettingsEnableCaretBrowsingPropertyInfo), '("enableDeveloperExtras", SettingsEnableDeveloperExtrasPropertyInfo), '("enableDnsPrefetching", SettingsEnableDnsPrefetchingPropertyInfo), '("enableFrameFlattening", SettingsEnableFrameFlatteningPropertyInfo), '("enableFullscreen", SettingsEnableFullscreenPropertyInfo), '("enableHtml5Database", SettingsEnableHtml5DatabasePropertyInfo), '("enableHtml5LocalStorage", SettingsEnableHtml5LocalStoragePropertyInfo), '("enableHyperlinkAuditing", SettingsEnableHyperlinkAuditingPropertyInfo), '("enableJava", SettingsEnableJavaPropertyInfo), '("enableJavascript", SettingsEnableJavascriptPropertyInfo), '("enableMediaStream", SettingsEnableMediaStreamPropertyInfo), '("enableMediasource", SettingsEnableMediasourcePropertyInfo), '("enableOfflineWebApplicationCache", SettingsEnableOfflineWebApplicationCachePropertyInfo), '("enablePageCache", SettingsEnablePageCachePropertyInfo), '("enablePlugins", SettingsEnablePluginsPropertyInfo), '("enablePrivateBrowsing", SettingsEnablePrivateBrowsingPropertyInfo), '("enableResizableTextAreas", SettingsEnableResizableTextAreasPropertyInfo), '("enableSiteSpecificQuirks", SettingsEnableSiteSpecificQuirksPropertyInfo), '("enableSmoothScrolling", SettingsEnableSmoothScrollingPropertyInfo), '("enableSpatialNavigation", SettingsEnableSpatialNavigationPropertyInfo), '("enableTabsToLinks", SettingsEnableTabsToLinksPropertyInfo), '("enableWebaudio", SettingsEnableWebaudioPropertyInfo), '("enableWebgl", SettingsEnableWebglPropertyInfo), '("enableWriteConsoleMessagesToStdout", SettingsEnableWriteConsoleMessagesToStdoutPropertyInfo), '("enableXssAuditor", SettingsEnableXssAuditorPropertyInfo), '("fantasyFontFamily", SettingsFantasyFontFamilyPropertyInfo), '("javascriptCanAccessClipboard", SettingsJavascriptCanAccessClipboardPropertyInfo), '("javascriptCanOpenWindowsAutomatically", SettingsJavascriptCanOpenWindowsAutomaticallyPropertyInfo), '("loadIconsIgnoringImageLoadSetting", SettingsLoadIconsIgnoringImageLoadSettingPropertyInfo), '("mediaPlaybackAllowsInline", SettingsMediaPlaybackAllowsInlinePropertyInfo), '("mediaPlaybackRequiresUserGesture", SettingsMediaPlaybackRequiresUserGesturePropertyInfo), '("minimumFontSize", SettingsMinimumFontSizePropertyInfo), '("monospaceFontFamily", SettingsMonospaceFontFamilyPropertyInfo), '("pictographFontFamily", SettingsPictographFontFamilyPropertyInfo), '("printBackgrounds", SettingsPrintBackgroundsPropertyInfo), '("sansSerifFontFamily", SettingsSansSerifFontFamilyPropertyInfo), '("serifFontFamily", SettingsSerifFontFamilyPropertyInfo), '("userAgent", SettingsUserAgentPropertyInfo), '("zoomTextOnly", SettingsZoomTextOnlyPropertyInfo)] :: [(Symbol, *)])

settingsAllowFileAccessFromFileUrls :: AttrLabelProxy "allowFileAccessFromFileUrls"
settingsAllowFileAccessFromFileUrls = AttrLabelProxy

settingsAllowModalDialogs :: AttrLabelProxy "allowModalDialogs"
settingsAllowModalDialogs = AttrLabelProxy

settingsAutoLoadImages :: AttrLabelProxy "autoLoadImages"
settingsAutoLoadImages = AttrLabelProxy

settingsCursiveFontFamily :: AttrLabelProxy "cursiveFontFamily"
settingsCursiveFontFamily = AttrLabelProxy

settingsDefaultCharset :: AttrLabelProxy "defaultCharset"
settingsDefaultCharset = AttrLabelProxy

settingsDefaultFontFamily :: AttrLabelProxy "defaultFontFamily"
settingsDefaultFontFamily = AttrLabelProxy

settingsDefaultFontSize :: AttrLabelProxy "defaultFontSize"
settingsDefaultFontSize = AttrLabelProxy

settingsDefaultMonospaceFontSize :: AttrLabelProxy "defaultMonospaceFontSize"
settingsDefaultMonospaceFontSize = AttrLabelProxy

settingsDrawCompositingIndicators :: AttrLabelProxy "drawCompositingIndicators"
settingsDrawCompositingIndicators = AttrLabelProxy

settingsEnableAccelerated2dCanvas :: AttrLabelProxy "enableAccelerated2dCanvas"
settingsEnableAccelerated2dCanvas = AttrLabelProxy

settingsEnableCaretBrowsing :: AttrLabelProxy "enableCaretBrowsing"
settingsEnableCaretBrowsing = AttrLabelProxy

settingsEnableDeveloperExtras :: AttrLabelProxy "enableDeveloperExtras"
settingsEnableDeveloperExtras = AttrLabelProxy

settingsEnableDnsPrefetching :: AttrLabelProxy "enableDnsPrefetching"
settingsEnableDnsPrefetching = AttrLabelProxy

settingsEnableFrameFlattening :: AttrLabelProxy "enableFrameFlattening"
settingsEnableFrameFlattening = AttrLabelProxy

settingsEnableFullscreen :: AttrLabelProxy "enableFullscreen"
settingsEnableFullscreen = AttrLabelProxy

settingsEnableHtml5Database :: AttrLabelProxy "enableHtml5Database"
settingsEnableHtml5Database = AttrLabelProxy

settingsEnableHtml5LocalStorage :: AttrLabelProxy "enableHtml5LocalStorage"
settingsEnableHtml5LocalStorage = AttrLabelProxy

settingsEnableHyperlinkAuditing :: AttrLabelProxy "enableHyperlinkAuditing"
settingsEnableHyperlinkAuditing = AttrLabelProxy

settingsEnableJava :: AttrLabelProxy "enableJava"
settingsEnableJava = AttrLabelProxy

settingsEnableJavascript :: AttrLabelProxy "enableJavascript"
settingsEnableJavascript = AttrLabelProxy

settingsEnableMediaStream :: AttrLabelProxy "enableMediaStream"
settingsEnableMediaStream = AttrLabelProxy

settingsEnableMediasource :: AttrLabelProxy "enableMediasource"
settingsEnableMediasource = AttrLabelProxy

settingsEnableOfflineWebApplicationCache :: AttrLabelProxy "enableOfflineWebApplicationCache"
settingsEnableOfflineWebApplicationCache = AttrLabelProxy

settingsEnablePageCache :: AttrLabelProxy "enablePageCache"
settingsEnablePageCache = AttrLabelProxy

settingsEnablePlugins :: AttrLabelProxy "enablePlugins"
settingsEnablePlugins = AttrLabelProxy

settingsEnablePrivateBrowsing :: AttrLabelProxy "enablePrivateBrowsing"
settingsEnablePrivateBrowsing = AttrLabelProxy

settingsEnableResizableTextAreas :: AttrLabelProxy "enableResizableTextAreas"
settingsEnableResizableTextAreas = AttrLabelProxy

settingsEnableSiteSpecificQuirks :: AttrLabelProxy "enableSiteSpecificQuirks"
settingsEnableSiteSpecificQuirks = AttrLabelProxy

settingsEnableSmoothScrolling :: AttrLabelProxy "enableSmoothScrolling"
settingsEnableSmoothScrolling = AttrLabelProxy

settingsEnableSpatialNavigation :: AttrLabelProxy "enableSpatialNavigation"
settingsEnableSpatialNavigation = AttrLabelProxy

settingsEnableTabsToLinks :: AttrLabelProxy "enableTabsToLinks"
settingsEnableTabsToLinks = AttrLabelProxy

settingsEnableWebaudio :: AttrLabelProxy "enableWebaudio"
settingsEnableWebaudio = AttrLabelProxy

settingsEnableWebgl :: AttrLabelProxy "enableWebgl"
settingsEnableWebgl = AttrLabelProxy

settingsEnableWriteConsoleMessagesToStdout :: AttrLabelProxy "enableWriteConsoleMessagesToStdout"
settingsEnableWriteConsoleMessagesToStdout = AttrLabelProxy

settingsEnableXssAuditor :: AttrLabelProxy "enableXssAuditor"
settingsEnableXssAuditor = AttrLabelProxy

settingsFantasyFontFamily :: AttrLabelProxy "fantasyFontFamily"
settingsFantasyFontFamily = AttrLabelProxy

settingsJavascriptCanAccessClipboard :: AttrLabelProxy "javascriptCanAccessClipboard"
settingsJavascriptCanAccessClipboard = AttrLabelProxy

settingsJavascriptCanOpenWindowsAutomatically :: AttrLabelProxy "javascriptCanOpenWindowsAutomatically"
settingsJavascriptCanOpenWindowsAutomatically = AttrLabelProxy

settingsLoadIconsIgnoringImageLoadSetting :: AttrLabelProxy "loadIconsIgnoringImageLoadSetting"
settingsLoadIconsIgnoringImageLoadSetting = AttrLabelProxy

settingsMediaPlaybackAllowsInline :: AttrLabelProxy "mediaPlaybackAllowsInline"
settingsMediaPlaybackAllowsInline = AttrLabelProxy

settingsMediaPlaybackRequiresUserGesture :: AttrLabelProxy "mediaPlaybackRequiresUserGesture"
settingsMediaPlaybackRequiresUserGesture = AttrLabelProxy

settingsMinimumFontSize :: AttrLabelProxy "minimumFontSize"
settingsMinimumFontSize = AttrLabelProxy

settingsMonospaceFontFamily :: AttrLabelProxy "monospaceFontFamily"
settingsMonospaceFontFamily = AttrLabelProxy

settingsPictographFontFamily :: AttrLabelProxy "pictographFontFamily"
settingsPictographFontFamily = AttrLabelProxy

settingsPrintBackgrounds :: AttrLabelProxy "printBackgrounds"
settingsPrintBackgrounds = AttrLabelProxy

settingsSansSerifFontFamily :: AttrLabelProxy "sansSerifFontFamily"
settingsSansSerifFontFamily = AttrLabelProxy

settingsSerifFontFamily :: AttrLabelProxy "serifFontFamily"
settingsSerifFontFamily = AttrLabelProxy

settingsUserAgent :: AttrLabelProxy "userAgent"
settingsUserAgent = AttrLabelProxy

settingsZoomTextOnly :: AttrLabelProxy "zoomTextOnly"
settingsZoomTextOnly = AttrLabelProxy

type instance SignalList Settings = SettingsSignalList
type SettingsSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method Settings::new
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "Settings")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_new" webkit_settings_new :: 
    IO (Ptr Settings)


settingsNew ::
    (MonadIO m) =>
    m Settings                              -- result
settingsNew  = liftIO $ do
    result <- webkit_settings_new
    checkUnexpectedReturnNULL "webkit_settings_new" result
    result' <- (wrapObject Settings) result
    return result'

-- method Settings::get_allow_file_access_from_file_urls
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_allow_file_access_from_file_urls" webkit_settings_get_allow_file_access_from_file_urls :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetAllowFileAccessFromFileUrls ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetAllowFileAccessFromFileUrls _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_allow_file_access_from_file_urls _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetAllowFileAccessFromFileUrlsMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetAllowFileAccessFromFileUrlsMethodInfo a signature where
    overloadedMethod _ = settingsGetAllowFileAccessFromFileUrls

-- method Settings::get_allow_modal_dialogs
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_allow_modal_dialogs" webkit_settings_get_allow_modal_dialogs :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetAllowModalDialogs ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetAllowModalDialogs _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_allow_modal_dialogs _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetAllowModalDialogsMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetAllowModalDialogsMethodInfo a signature where
    overloadedMethod _ = settingsGetAllowModalDialogs

-- method Settings::get_auto_load_images
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_auto_load_images" webkit_settings_get_auto_load_images :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetAutoLoadImages ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetAutoLoadImages _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_auto_load_images _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetAutoLoadImagesMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetAutoLoadImagesMethodInfo a signature where
    overloadedMethod _ = settingsGetAutoLoadImages

-- method Settings::get_cursive_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_cursive_font_family" webkit_settings_get_cursive_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetCursiveFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetCursiveFontFamily _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_cursive_font_family _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_cursive_font_family" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetCursiveFontFamilyMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetCursiveFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsGetCursiveFontFamily

-- method Settings::get_default_charset
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_default_charset" webkit_settings_get_default_charset :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetDefaultCharset ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetDefaultCharset _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_default_charset _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_default_charset" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetDefaultCharsetMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetDefaultCharsetMethodInfo a signature where
    overloadedMethod _ = settingsGetDefaultCharset

-- method Settings::get_default_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_default_font_family" webkit_settings_get_default_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetDefaultFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetDefaultFontFamily _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_default_font_family _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_default_font_family" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetDefaultFontFamilyMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetDefaultFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsGetDefaultFontFamily

-- method Settings::get_default_font_size
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_default_font_size" webkit_settings_get_default_font_size :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO Word32


settingsGetDefaultFontSize ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
settingsGetDefaultFontSize _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_default_font_size _obj'
    touchManagedPtr _obj
    return result

data SettingsGetDefaultFontSizeMethodInfo
instance (signature ~ (m Word32), MonadIO m, SettingsK a) => MethodInfo SettingsGetDefaultFontSizeMethodInfo a signature where
    overloadedMethod _ = settingsGetDefaultFontSize

-- method Settings::get_default_monospace_font_size
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_default_monospace_font_size" webkit_settings_get_default_monospace_font_size :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO Word32


settingsGetDefaultMonospaceFontSize ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
settingsGetDefaultMonospaceFontSize _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_default_monospace_font_size _obj'
    touchManagedPtr _obj
    return result

data SettingsGetDefaultMonospaceFontSizeMethodInfo
instance (signature ~ (m Word32), MonadIO m, SettingsK a) => MethodInfo SettingsGetDefaultMonospaceFontSizeMethodInfo a signature where
    overloadedMethod _ = settingsGetDefaultMonospaceFontSize

-- method Settings::get_draw_compositing_indicators
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_draw_compositing_indicators" webkit_settings_get_draw_compositing_indicators :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetDrawCompositingIndicators ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetDrawCompositingIndicators _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_draw_compositing_indicators _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetDrawCompositingIndicatorsMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetDrawCompositingIndicatorsMethodInfo a signature where
    overloadedMethod _ = settingsGetDrawCompositingIndicators

-- method Settings::get_enable_accelerated_2d_canvas
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_accelerated_2d_canvas" webkit_settings_get_enable_accelerated_2d_canvas :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableAccelerated2dCanvas ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableAccelerated2dCanvas _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_accelerated_2d_canvas _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableAccelerated2dCanvasMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableAccelerated2dCanvasMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableAccelerated2dCanvas

-- method Settings::get_enable_caret_browsing
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_caret_browsing" webkit_settings_get_enable_caret_browsing :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableCaretBrowsing ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableCaretBrowsing _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_caret_browsing _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableCaretBrowsingMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableCaretBrowsingMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableCaretBrowsing

-- method Settings::get_enable_developer_extras
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_developer_extras" webkit_settings_get_enable_developer_extras :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableDeveloperExtras ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableDeveloperExtras _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_developer_extras _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableDeveloperExtrasMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableDeveloperExtrasMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableDeveloperExtras

-- method Settings::get_enable_dns_prefetching
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_dns_prefetching" webkit_settings_get_enable_dns_prefetching :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableDnsPrefetching ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableDnsPrefetching _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_dns_prefetching _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableDnsPrefetchingMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableDnsPrefetchingMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableDnsPrefetching

-- method Settings::get_enable_frame_flattening
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_frame_flattening" webkit_settings_get_enable_frame_flattening :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableFrameFlattening ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableFrameFlattening _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_frame_flattening _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableFrameFlatteningMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableFrameFlatteningMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableFrameFlattening

-- method Settings::get_enable_fullscreen
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_fullscreen" webkit_settings_get_enable_fullscreen :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableFullscreen ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableFullscreen _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_fullscreen _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableFullscreenMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableFullscreenMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableFullscreen

-- method Settings::get_enable_html5_database
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_html5_database" webkit_settings_get_enable_html5_database :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableHtml5Database ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableHtml5Database _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_html5_database _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableHtml5DatabaseMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableHtml5DatabaseMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableHtml5Database

-- method Settings::get_enable_html5_local_storage
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_html5_local_storage" webkit_settings_get_enable_html5_local_storage :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableHtml5LocalStorage ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableHtml5LocalStorage _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_html5_local_storage _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableHtml5LocalStorageMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableHtml5LocalStorageMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableHtml5LocalStorage

-- method Settings::get_enable_hyperlink_auditing
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_hyperlink_auditing" webkit_settings_get_enable_hyperlink_auditing :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableHyperlinkAuditing ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableHyperlinkAuditing _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_hyperlink_auditing _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableHyperlinkAuditingMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableHyperlinkAuditingMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableHyperlinkAuditing

-- method Settings::get_enable_java
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_java" webkit_settings_get_enable_java :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableJava ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableJava _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_java _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableJavaMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableJavaMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableJava

-- method Settings::get_enable_javascript
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_javascript" webkit_settings_get_enable_javascript :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableJavascript ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableJavascript _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_javascript _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableJavascriptMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableJavascriptMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableJavascript

-- method Settings::get_enable_media_stream
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_media_stream" webkit_settings_get_enable_media_stream :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableMediaStream ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableMediaStream _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_media_stream _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableMediaStreamMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableMediaStreamMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableMediaStream

-- method Settings::get_enable_mediasource
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_mediasource" webkit_settings_get_enable_mediasource :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableMediasource ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableMediasource _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_mediasource _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableMediasourceMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableMediasourceMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableMediasource

-- method Settings::get_enable_offline_web_application_cache
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_offline_web_application_cache" webkit_settings_get_enable_offline_web_application_cache :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableOfflineWebApplicationCache ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableOfflineWebApplicationCache _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_offline_web_application_cache _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableOfflineWebApplicationCacheMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableOfflineWebApplicationCacheMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableOfflineWebApplicationCache

-- method Settings::get_enable_page_cache
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_page_cache" webkit_settings_get_enable_page_cache :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnablePageCache ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnablePageCache _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_page_cache _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnablePageCacheMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnablePageCacheMethodInfo a signature where
    overloadedMethod _ = settingsGetEnablePageCache

-- method Settings::get_enable_plugins
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_plugins" webkit_settings_get_enable_plugins :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnablePlugins ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnablePlugins _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_plugins _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnablePluginsMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnablePluginsMethodInfo a signature where
    overloadedMethod _ = settingsGetEnablePlugins

-- method Settings::get_enable_private_browsing
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_private_browsing" webkit_settings_get_enable_private_browsing :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnablePrivateBrowsing ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnablePrivateBrowsing _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_private_browsing _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnablePrivateBrowsingMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnablePrivateBrowsingMethodInfo a signature where
    overloadedMethod _ = settingsGetEnablePrivateBrowsing

-- method Settings::get_enable_resizable_text_areas
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_resizable_text_areas" webkit_settings_get_enable_resizable_text_areas :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableResizableTextAreas ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableResizableTextAreas _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_resizable_text_areas _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableResizableTextAreasMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableResizableTextAreasMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableResizableTextAreas

-- method Settings::get_enable_site_specific_quirks
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_site_specific_quirks" webkit_settings_get_enable_site_specific_quirks :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableSiteSpecificQuirks ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableSiteSpecificQuirks _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_site_specific_quirks _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableSiteSpecificQuirksMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableSiteSpecificQuirksMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableSiteSpecificQuirks

-- method Settings::get_enable_smooth_scrolling
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_smooth_scrolling" webkit_settings_get_enable_smooth_scrolling :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableSmoothScrolling ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableSmoothScrolling _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_smooth_scrolling _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableSmoothScrollingMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableSmoothScrollingMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableSmoothScrolling

-- method Settings::get_enable_spatial_navigation
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_spatial_navigation" webkit_settings_get_enable_spatial_navigation :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableSpatialNavigation ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableSpatialNavigation _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_spatial_navigation _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableSpatialNavigationMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableSpatialNavigationMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableSpatialNavigation

-- method Settings::get_enable_tabs_to_links
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_tabs_to_links" webkit_settings_get_enable_tabs_to_links :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableTabsToLinks ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableTabsToLinks _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_tabs_to_links _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableTabsToLinksMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableTabsToLinksMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableTabsToLinks

-- method Settings::get_enable_webaudio
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_webaudio" webkit_settings_get_enable_webaudio :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableWebaudio ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableWebaudio _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_webaudio _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableWebaudioMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableWebaudioMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableWebaudio

-- method Settings::get_enable_webgl
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_webgl" webkit_settings_get_enable_webgl :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableWebgl ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableWebgl _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_webgl _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableWebglMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableWebglMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableWebgl

-- method Settings::get_enable_write_console_messages_to_stdout
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_write_console_messages_to_stdout" webkit_settings_get_enable_write_console_messages_to_stdout :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableWriteConsoleMessagesToStdout ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableWriteConsoleMessagesToStdout _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_write_console_messages_to_stdout _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableWriteConsoleMessagesToStdoutMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableWriteConsoleMessagesToStdoutMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableWriteConsoleMessagesToStdout

-- method Settings::get_enable_xss_auditor
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_enable_xss_auditor" webkit_settings_get_enable_xss_auditor :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetEnableXssAuditor ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetEnableXssAuditor _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_enable_xss_auditor _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetEnableXssAuditorMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetEnableXssAuditorMethodInfo a signature where
    overloadedMethod _ = settingsGetEnableXssAuditor

-- method Settings::get_fantasy_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_fantasy_font_family" webkit_settings_get_fantasy_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetFantasyFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetFantasyFontFamily _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_fantasy_font_family _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_fantasy_font_family" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetFantasyFontFamilyMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetFantasyFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsGetFantasyFontFamily

-- method Settings::get_javascript_can_access_clipboard
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_javascript_can_access_clipboard" webkit_settings_get_javascript_can_access_clipboard :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetJavascriptCanAccessClipboard ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetJavascriptCanAccessClipboard _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_javascript_can_access_clipboard _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetJavascriptCanAccessClipboardMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetJavascriptCanAccessClipboardMethodInfo a signature where
    overloadedMethod _ = settingsGetJavascriptCanAccessClipboard

-- method Settings::get_javascript_can_open_windows_automatically
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_javascript_can_open_windows_automatically" webkit_settings_get_javascript_can_open_windows_automatically :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetJavascriptCanOpenWindowsAutomatically ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetJavascriptCanOpenWindowsAutomatically _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_javascript_can_open_windows_automatically _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetJavascriptCanOpenWindowsAutomaticallyMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetJavascriptCanOpenWindowsAutomaticallyMethodInfo a signature where
    overloadedMethod _ = settingsGetJavascriptCanOpenWindowsAutomatically

-- method Settings::get_load_icons_ignoring_image_load_setting
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_load_icons_ignoring_image_load_setting" webkit_settings_get_load_icons_ignoring_image_load_setting :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetLoadIconsIgnoringImageLoadSetting ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetLoadIconsIgnoringImageLoadSetting _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_load_icons_ignoring_image_load_setting _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetLoadIconsIgnoringImageLoadSettingMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetLoadIconsIgnoringImageLoadSettingMethodInfo a signature where
    overloadedMethod _ = settingsGetLoadIconsIgnoringImageLoadSetting

-- method Settings::get_media_playback_allows_inline
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_media_playback_allows_inline" webkit_settings_get_media_playback_allows_inline :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetMediaPlaybackAllowsInline ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetMediaPlaybackAllowsInline _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_media_playback_allows_inline _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetMediaPlaybackAllowsInlineMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetMediaPlaybackAllowsInlineMethodInfo a signature where
    overloadedMethod _ = settingsGetMediaPlaybackAllowsInline

-- method Settings::get_media_playback_requires_user_gesture
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_media_playback_requires_user_gesture" webkit_settings_get_media_playback_requires_user_gesture :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetMediaPlaybackRequiresUserGesture ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetMediaPlaybackRequiresUserGesture _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_media_playback_requires_user_gesture _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetMediaPlaybackRequiresUserGestureMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetMediaPlaybackRequiresUserGestureMethodInfo a signature where
    overloadedMethod _ = settingsGetMediaPlaybackRequiresUserGesture

-- method Settings::get_minimum_font_size
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_minimum_font_size" webkit_settings_get_minimum_font_size :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO Word32


settingsGetMinimumFontSize ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
settingsGetMinimumFontSize _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_minimum_font_size _obj'
    touchManagedPtr _obj
    return result

data SettingsGetMinimumFontSizeMethodInfo
instance (signature ~ (m Word32), MonadIO m, SettingsK a) => MethodInfo SettingsGetMinimumFontSizeMethodInfo a signature where
    overloadedMethod _ = settingsGetMinimumFontSize

-- method Settings::get_monospace_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_monospace_font_family" webkit_settings_get_monospace_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetMonospaceFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetMonospaceFontFamily _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_monospace_font_family _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_monospace_font_family" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetMonospaceFontFamilyMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetMonospaceFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsGetMonospaceFontFamily

-- method Settings::get_pictograph_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_pictograph_font_family" webkit_settings_get_pictograph_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetPictographFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetPictographFontFamily _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_pictograph_font_family _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_pictograph_font_family" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetPictographFontFamilyMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetPictographFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsGetPictographFontFamily

-- method Settings::get_print_backgrounds
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_print_backgrounds" webkit_settings_get_print_backgrounds :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetPrintBackgrounds ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetPrintBackgrounds _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_print_backgrounds _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetPrintBackgroundsMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetPrintBackgroundsMethodInfo a signature where
    overloadedMethod _ = settingsGetPrintBackgrounds

-- method Settings::get_sans_serif_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_sans_serif_font_family" webkit_settings_get_sans_serif_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetSansSerifFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetSansSerifFontFamily _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_sans_serif_font_family _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_sans_serif_font_family" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetSansSerifFontFamilyMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetSansSerifFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsGetSansSerifFontFamily

-- method Settings::get_serif_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_serif_font_family" webkit_settings_get_serif_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetSerifFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetSerifFontFamily _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_serif_font_family _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_serif_font_family" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetSerifFontFamilyMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetSerifFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsGetSerifFontFamily

-- method Settings::get_user_agent
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_user_agent" webkit_settings_get_user_agent :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CString


settingsGetUserAgent ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
settingsGetUserAgent _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_user_agent _obj'
    checkUnexpectedReturnNULL "webkit_settings_get_user_agent" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data SettingsGetUserAgentMethodInfo
instance (signature ~ (m T.Text), MonadIO m, SettingsK a) => MethodInfo SettingsGetUserAgentMethodInfo a signature where
    overloadedMethod _ = settingsGetUserAgent

-- method Settings::get_zoom_text_only
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_get_zoom_text_only" webkit_settings_get_zoom_text_only :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    IO CInt


settingsGetZoomTextOnly ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
settingsGetZoomTextOnly _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_settings_get_zoom_text_only _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data SettingsGetZoomTextOnlyMethodInfo
instance (signature ~ (m Bool), MonadIO m, SettingsK a) => MethodInfo SettingsGetZoomTextOnlyMethodInfo a signature where
    overloadedMethod _ = settingsGetZoomTextOnly

-- method Settings::set_allow_file_access_from_file_urls
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "allowed", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_allow_file_access_from_file_urls" webkit_settings_set_allow_file_access_from_file_urls :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- allowed : TBasicType TBoolean
    IO ()


settingsSetAllowFileAccessFromFileUrls ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- allowed
    -> m ()                                 -- result
settingsSetAllowFileAccessFromFileUrls _obj allowed = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let allowed' = (fromIntegral . fromEnum) allowed
    webkit_settings_set_allow_file_access_from_file_urls _obj' allowed'
    touchManagedPtr _obj
    return ()

data SettingsSetAllowFileAccessFromFileUrlsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetAllowFileAccessFromFileUrlsMethodInfo a signature where
    overloadedMethod _ = settingsSetAllowFileAccessFromFileUrls

-- method Settings::set_allow_modal_dialogs
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "allowed", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_allow_modal_dialogs" webkit_settings_set_allow_modal_dialogs :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- allowed : TBasicType TBoolean
    IO ()


settingsSetAllowModalDialogs ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- allowed
    -> m ()                                 -- result
settingsSetAllowModalDialogs _obj allowed = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let allowed' = (fromIntegral . fromEnum) allowed
    webkit_settings_set_allow_modal_dialogs _obj' allowed'
    touchManagedPtr _obj
    return ()

data SettingsSetAllowModalDialogsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetAllowModalDialogsMethodInfo a signature where
    overloadedMethod _ = settingsSetAllowModalDialogs

-- method Settings::set_auto_load_images
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_auto_load_images" webkit_settings_set_auto_load_images :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetAutoLoadImages ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetAutoLoadImages _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_auto_load_images _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetAutoLoadImagesMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetAutoLoadImagesMethodInfo a signature where
    overloadedMethod _ = settingsSetAutoLoadImages

-- method Settings::set_cursive_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cursive_font_family", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_cursive_font_family" webkit_settings_set_cursive_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- cursive_font_family : TBasicType TUTF8
    IO ()


settingsSetCursiveFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> T.Text                               -- cursiveFontFamily
    -> m ()                                 -- result
settingsSetCursiveFontFamily _obj cursiveFontFamily = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    cursiveFontFamily' <- textToCString cursiveFontFamily
    webkit_settings_set_cursive_font_family _obj' cursiveFontFamily'
    touchManagedPtr _obj
    freeMem cursiveFontFamily'
    return ()

data SettingsSetCursiveFontFamilyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetCursiveFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsSetCursiveFontFamily

-- method Settings::set_default_charset
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "default_charset", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_default_charset" webkit_settings_set_default_charset :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- default_charset : TBasicType TUTF8
    IO ()


settingsSetDefaultCharset ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> T.Text                               -- defaultCharset
    -> m ()                                 -- result
settingsSetDefaultCharset _obj defaultCharset = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    defaultCharset' <- textToCString defaultCharset
    webkit_settings_set_default_charset _obj' defaultCharset'
    touchManagedPtr _obj
    freeMem defaultCharset'
    return ()

data SettingsSetDefaultCharsetMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetDefaultCharsetMethodInfo a signature where
    overloadedMethod _ = settingsSetDefaultCharset

-- method Settings::set_default_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "default_font_family", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_default_font_family" webkit_settings_set_default_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- default_font_family : TBasicType TUTF8
    IO ()


settingsSetDefaultFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> T.Text                               -- defaultFontFamily
    -> m ()                                 -- result
settingsSetDefaultFontFamily _obj defaultFontFamily = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    defaultFontFamily' <- textToCString defaultFontFamily
    webkit_settings_set_default_font_family _obj' defaultFontFamily'
    touchManagedPtr _obj
    freeMem defaultFontFamily'
    return ()

data SettingsSetDefaultFontFamilyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetDefaultFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsSetDefaultFontFamily

-- method Settings::set_default_font_size
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "font_size", argType = TBasicType TUInt32, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_default_font_size" webkit_settings_set_default_font_size :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    Word32 ->                               -- font_size : TBasicType TUInt32
    IO ()


settingsSetDefaultFontSize ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Word32                               -- fontSize
    -> m ()                                 -- result
settingsSetDefaultFontSize _obj fontSize = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_settings_set_default_font_size _obj' fontSize
    touchManagedPtr _obj
    return ()

data SettingsSetDefaultFontSizeMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetDefaultFontSizeMethodInfo a signature where
    overloadedMethod _ = settingsSetDefaultFontSize

-- method Settings::set_default_monospace_font_size
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "font_size", argType = TBasicType TUInt32, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_default_monospace_font_size" webkit_settings_set_default_monospace_font_size :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    Word32 ->                               -- font_size : TBasicType TUInt32
    IO ()


settingsSetDefaultMonospaceFontSize ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Word32                               -- fontSize
    -> m ()                                 -- result
settingsSetDefaultMonospaceFontSize _obj fontSize = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_settings_set_default_monospace_font_size _obj' fontSize
    touchManagedPtr _obj
    return ()

data SettingsSetDefaultMonospaceFontSizeMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetDefaultMonospaceFontSizeMethodInfo a signature where
    overloadedMethod _ = settingsSetDefaultMonospaceFontSize

-- method Settings::set_draw_compositing_indicators
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_draw_compositing_indicators" webkit_settings_set_draw_compositing_indicators :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetDrawCompositingIndicators ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetDrawCompositingIndicators _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_draw_compositing_indicators _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetDrawCompositingIndicatorsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetDrawCompositingIndicatorsMethodInfo a signature where
    overloadedMethod _ = settingsSetDrawCompositingIndicators

-- method Settings::set_enable_accelerated_2d_canvas
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_accelerated_2d_canvas" webkit_settings_set_enable_accelerated_2d_canvas :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableAccelerated2dCanvas ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableAccelerated2dCanvas _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_accelerated_2d_canvas _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableAccelerated2dCanvasMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableAccelerated2dCanvasMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableAccelerated2dCanvas

-- method Settings::set_enable_caret_browsing
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_caret_browsing" webkit_settings_set_enable_caret_browsing :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableCaretBrowsing ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableCaretBrowsing _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_caret_browsing _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableCaretBrowsingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableCaretBrowsingMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableCaretBrowsing

-- method Settings::set_enable_developer_extras
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_developer_extras" webkit_settings_set_enable_developer_extras :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableDeveloperExtras ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableDeveloperExtras _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_developer_extras _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableDeveloperExtrasMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableDeveloperExtrasMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableDeveloperExtras

-- method Settings::set_enable_dns_prefetching
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_dns_prefetching" webkit_settings_set_enable_dns_prefetching :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableDnsPrefetching ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableDnsPrefetching _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_dns_prefetching _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableDnsPrefetchingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableDnsPrefetchingMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableDnsPrefetching

-- method Settings::set_enable_frame_flattening
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_frame_flattening" webkit_settings_set_enable_frame_flattening :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableFrameFlattening ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableFrameFlattening _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_frame_flattening _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableFrameFlatteningMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableFrameFlatteningMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableFrameFlattening

-- method Settings::set_enable_fullscreen
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_fullscreen" webkit_settings_set_enable_fullscreen :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableFullscreen ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableFullscreen _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_fullscreen _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableFullscreenMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableFullscreenMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableFullscreen

-- method Settings::set_enable_html5_database
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_html5_database" webkit_settings_set_enable_html5_database :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableHtml5Database ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableHtml5Database _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_html5_database _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableHtml5DatabaseMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableHtml5DatabaseMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableHtml5Database

-- method Settings::set_enable_html5_local_storage
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_html5_local_storage" webkit_settings_set_enable_html5_local_storage :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableHtml5LocalStorage ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableHtml5LocalStorage _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_html5_local_storage _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableHtml5LocalStorageMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableHtml5LocalStorageMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableHtml5LocalStorage

-- method Settings::set_enable_hyperlink_auditing
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_hyperlink_auditing" webkit_settings_set_enable_hyperlink_auditing :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableHyperlinkAuditing ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableHyperlinkAuditing _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_hyperlink_auditing _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableHyperlinkAuditingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableHyperlinkAuditingMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableHyperlinkAuditing

-- method Settings::set_enable_java
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_java" webkit_settings_set_enable_java :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableJava ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableJava _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_java _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableJavaMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableJavaMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableJava

-- method Settings::set_enable_javascript
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_javascript" webkit_settings_set_enable_javascript :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableJavascript ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableJavascript _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_javascript _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableJavascriptMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableJavascriptMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableJavascript

-- method Settings::set_enable_media_stream
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_media_stream" webkit_settings_set_enable_media_stream :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableMediaStream ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableMediaStream _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_media_stream _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableMediaStreamMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableMediaStreamMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableMediaStream

-- method Settings::set_enable_mediasource
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_mediasource" webkit_settings_set_enable_mediasource :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableMediasource ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableMediasource _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_mediasource _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableMediasourceMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableMediasourceMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableMediasource

-- method Settings::set_enable_offline_web_application_cache
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_offline_web_application_cache" webkit_settings_set_enable_offline_web_application_cache :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableOfflineWebApplicationCache ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableOfflineWebApplicationCache _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_offline_web_application_cache _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableOfflineWebApplicationCacheMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableOfflineWebApplicationCacheMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableOfflineWebApplicationCache

-- method Settings::set_enable_page_cache
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_page_cache" webkit_settings_set_enable_page_cache :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnablePageCache ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnablePageCache _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_page_cache _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnablePageCacheMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnablePageCacheMethodInfo a signature where
    overloadedMethod _ = settingsSetEnablePageCache

-- method Settings::set_enable_plugins
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_plugins" webkit_settings_set_enable_plugins :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnablePlugins ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnablePlugins _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_plugins _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnablePluginsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnablePluginsMethodInfo a signature where
    overloadedMethod _ = settingsSetEnablePlugins

-- method Settings::set_enable_private_browsing
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_private_browsing" webkit_settings_set_enable_private_browsing :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnablePrivateBrowsing ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnablePrivateBrowsing _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_private_browsing _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnablePrivateBrowsingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnablePrivateBrowsingMethodInfo a signature where
    overloadedMethod _ = settingsSetEnablePrivateBrowsing

-- method Settings::set_enable_resizable_text_areas
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_resizable_text_areas" webkit_settings_set_enable_resizable_text_areas :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableResizableTextAreas ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableResizableTextAreas _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_resizable_text_areas _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableResizableTextAreasMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableResizableTextAreasMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableResizableTextAreas

-- method Settings::set_enable_site_specific_quirks
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_site_specific_quirks" webkit_settings_set_enable_site_specific_quirks :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableSiteSpecificQuirks ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableSiteSpecificQuirks _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_site_specific_quirks _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableSiteSpecificQuirksMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableSiteSpecificQuirksMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableSiteSpecificQuirks

-- method Settings::set_enable_smooth_scrolling
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_smooth_scrolling" webkit_settings_set_enable_smooth_scrolling :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableSmoothScrolling ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableSmoothScrolling _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_smooth_scrolling _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableSmoothScrollingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableSmoothScrollingMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableSmoothScrolling

-- method Settings::set_enable_spatial_navigation
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_spatial_navigation" webkit_settings_set_enable_spatial_navigation :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableSpatialNavigation ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableSpatialNavigation _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_spatial_navigation _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableSpatialNavigationMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableSpatialNavigationMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableSpatialNavigation

-- method Settings::set_enable_tabs_to_links
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_tabs_to_links" webkit_settings_set_enable_tabs_to_links :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableTabsToLinks ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableTabsToLinks _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_tabs_to_links _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableTabsToLinksMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableTabsToLinksMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableTabsToLinks

-- method Settings::set_enable_webaudio
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_webaudio" webkit_settings_set_enable_webaudio :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableWebaudio ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableWebaudio _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_webaudio _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableWebaudioMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableWebaudioMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableWebaudio

-- method Settings::set_enable_webgl
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_webgl" webkit_settings_set_enable_webgl :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableWebgl ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableWebgl _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_webgl _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableWebglMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableWebglMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableWebgl

-- method Settings::set_enable_write_console_messages_to_stdout
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_write_console_messages_to_stdout" webkit_settings_set_enable_write_console_messages_to_stdout :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableWriteConsoleMessagesToStdout ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableWriteConsoleMessagesToStdout _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_write_console_messages_to_stdout _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableWriteConsoleMessagesToStdoutMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableWriteConsoleMessagesToStdoutMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableWriteConsoleMessagesToStdout

-- method Settings::set_enable_xss_auditor
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_enable_xss_auditor" webkit_settings_set_enable_xss_auditor :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetEnableXssAuditor ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetEnableXssAuditor _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_enable_xss_auditor _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetEnableXssAuditorMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetEnableXssAuditorMethodInfo a signature where
    overloadedMethod _ = settingsSetEnableXssAuditor

-- method Settings::set_fantasy_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "fantasy_font_family", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_fantasy_font_family" webkit_settings_set_fantasy_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- fantasy_font_family : TBasicType TUTF8
    IO ()


settingsSetFantasyFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> T.Text                               -- fantasyFontFamily
    -> m ()                                 -- result
settingsSetFantasyFontFamily _obj fantasyFontFamily = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    fantasyFontFamily' <- textToCString fantasyFontFamily
    webkit_settings_set_fantasy_font_family _obj' fantasyFontFamily'
    touchManagedPtr _obj
    freeMem fantasyFontFamily'
    return ()

data SettingsSetFantasyFontFamilyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetFantasyFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsSetFantasyFontFamily

-- method Settings::set_javascript_can_access_clipboard
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_javascript_can_access_clipboard" webkit_settings_set_javascript_can_access_clipboard :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetJavascriptCanAccessClipboard ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetJavascriptCanAccessClipboard _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_javascript_can_access_clipboard _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetJavascriptCanAccessClipboardMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetJavascriptCanAccessClipboardMethodInfo a signature where
    overloadedMethod _ = settingsSetJavascriptCanAccessClipboard

-- method Settings::set_javascript_can_open_windows_automatically
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_javascript_can_open_windows_automatically" webkit_settings_set_javascript_can_open_windows_automatically :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetJavascriptCanOpenWindowsAutomatically ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetJavascriptCanOpenWindowsAutomatically _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_javascript_can_open_windows_automatically _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetJavascriptCanOpenWindowsAutomaticallyMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetJavascriptCanOpenWindowsAutomaticallyMethodInfo a signature where
    overloadedMethod _ = settingsSetJavascriptCanOpenWindowsAutomatically

-- method Settings::set_load_icons_ignoring_image_load_setting
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_load_icons_ignoring_image_load_setting" webkit_settings_set_load_icons_ignoring_image_load_setting :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetLoadIconsIgnoringImageLoadSetting ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetLoadIconsIgnoringImageLoadSetting _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_load_icons_ignoring_image_load_setting _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetLoadIconsIgnoringImageLoadSettingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetLoadIconsIgnoringImageLoadSettingMethodInfo a signature where
    overloadedMethod _ = settingsSetLoadIconsIgnoringImageLoadSetting

-- method Settings::set_media_playback_allows_inline
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_media_playback_allows_inline" webkit_settings_set_media_playback_allows_inline :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetMediaPlaybackAllowsInline ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetMediaPlaybackAllowsInline _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_media_playback_allows_inline _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetMediaPlaybackAllowsInlineMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetMediaPlaybackAllowsInlineMethodInfo a signature where
    overloadedMethod _ = settingsSetMediaPlaybackAllowsInline

-- method Settings::set_media_playback_requires_user_gesture
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_media_playback_requires_user_gesture" webkit_settings_set_media_playback_requires_user_gesture :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


settingsSetMediaPlaybackRequiresUserGesture ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
settingsSetMediaPlaybackRequiresUserGesture _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_settings_set_media_playback_requires_user_gesture _obj' enabled'
    touchManagedPtr _obj
    return ()

data SettingsSetMediaPlaybackRequiresUserGestureMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetMediaPlaybackRequiresUserGestureMethodInfo a signature where
    overloadedMethod _ = settingsSetMediaPlaybackRequiresUserGesture

-- method Settings::set_minimum_font_size
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "font_size", argType = TBasicType TUInt32, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_minimum_font_size" webkit_settings_set_minimum_font_size :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    Word32 ->                               -- font_size : TBasicType TUInt32
    IO ()


settingsSetMinimumFontSize ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Word32                               -- fontSize
    -> m ()                                 -- result
settingsSetMinimumFontSize _obj fontSize = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_settings_set_minimum_font_size _obj' fontSize
    touchManagedPtr _obj
    return ()

data SettingsSetMinimumFontSizeMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetMinimumFontSizeMethodInfo a signature where
    overloadedMethod _ = settingsSetMinimumFontSize

-- method Settings::set_monospace_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "monospace_font_family", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_monospace_font_family" webkit_settings_set_monospace_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- monospace_font_family : TBasicType TUTF8
    IO ()


settingsSetMonospaceFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> T.Text                               -- monospaceFontFamily
    -> m ()                                 -- result
settingsSetMonospaceFontFamily _obj monospaceFontFamily = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    monospaceFontFamily' <- textToCString monospaceFontFamily
    webkit_settings_set_monospace_font_family _obj' monospaceFontFamily'
    touchManagedPtr _obj
    freeMem monospaceFontFamily'
    return ()

data SettingsSetMonospaceFontFamilyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetMonospaceFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsSetMonospaceFontFamily

-- method Settings::set_pictograph_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "pictograph_font_family", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_pictograph_font_family" webkit_settings_set_pictograph_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- pictograph_font_family : TBasicType TUTF8
    IO ()


settingsSetPictographFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> T.Text                               -- pictographFontFamily
    -> m ()                                 -- result
settingsSetPictographFontFamily _obj pictographFontFamily = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    pictographFontFamily' <- textToCString pictographFontFamily
    webkit_settings_set_pictograph_font_family _obj' pictographFontFamily'
    touchManagedPtr _obj
    freeMem pictographFontFamily'
    return ()

data SettingsSetPictographFontFamilyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetPictographFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsSetPictographFontFamily

-- method Settings::set_print_backgrounds
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "print_backgrounds", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_print_backgrounds" webkit_settings_set_print_backgrounds :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- print_backgrounds : TBasicType TBoolean
    IO ()


settingsSetPrintBackgrounds ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- printBackgrounds
    -> m ()                                 -- result
settingsSetPrintBackgrounds _obj printBackgrounds = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let printBackgrounds' = (fromIntegral . fromEnum) printBackgrounds
    webkit_settings_set_print_backgrounds _obj' printBackgrounds'
    touchManagedPtr _obj
    return ()

data SettingsSetPrintBackgroundsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetPrintBackgroundsMethodInfo a signature where
    overloadedMethod _ = settingsSetPrintBackgrounds

-- method Settings::set_sans_serif_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "sans_serif_font_family", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_sans_serif_font_family" webkit_settings_set_sans_serif_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- sans_serif_font_family : TBasicType TUTF8
    IO ()


settingsSetSansSerifFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> T.Text                               -- sansSerifFontFamily
    -> m ()                                 -- result
settingsSetSansSerifFontFamily _obj sansSerifFontFamily = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    sansSerifFontFamily' <- textToCString sansSerifFontFamily
    webkit_settings_set_sans_serif_font_family _obj' sansSerifFontFamily'
    touchManagedPtr _obj
    freeMem sansSerifFontFamily'
    return ()

data SettingsSetSansSerifFontFamilyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetSansSerifFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsSetSansSerifFontFamily

-- method Settings::set_serif_font_family
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "serif_font_family", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_serif_font_family" webkit_settings_set_serif_font_family :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- serif_font_family : TBasicType TUTF8
    IO ()


settingsSetSerifFontFamily ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> T.Text                               -- serifFontFamily
    -> m ()                                 -- result
settingsSetSerifFontFamily _obj serifFontFamily = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    serifFontFamily' <- textToCString serifFontFamily
    webkit_settings_set_serif_font_family _obj' serifFontFamily'
    touchManagedPtr _obj
    freeMem serifFontFamily'
    return ()

data SettingsSetSerifFontFamilyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetSerifFontFamilyMethodInfo a signature where
    overloadedMethod _ = settingsSetSerifFontFamily

-- method Settings::set_user_agent
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_agent", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_user_agent" webkit_settings_set_user_agent :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- user_agent : TBasicType TUTF8
    IO ()


settingsSetUserAgent ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Maybe (T.Text)                       -- userAgent
    -> m ()                                 -- result
settingsSetUserAgent _obj userAgent = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeUserAgent <- case userAgent of
        Nothing -> return nullPtr
        Just jUserAgent -> do
            jUserAgent' <- textToCString jUserAgent
            return jUserAgent'
    webkit_settings_set_user_agent _obj' maybeUserAgent
    touchManagedPtr _obj
    freeMem maybeUserAgent
    return ()

data SettingsSetUserAgentMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetUserAgentMethodInfo a signature where
    overloadedMethod _ = settingsSetUserAgent

-- method Settings::set_user_agent_with_application_details
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "application_name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "application_version", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_user_agent_with_application_details" webkit_settings_set_user_agent_with_application_details :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CString ->                              -- application_name : TBasicType TUTF8
    CString ->                              -- application_version : TBasicType TUTF8
    IO ()


settingsSetUserAgentWithApplicationDetails ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Maybe (T.Text)                       -- applicationName
    -> Maybe (T.Text)                       -- applicationVersion
    -> m ()                                 -- result
settingsSetUserAgentWithApplicationDetails _obj applicationName applicationVersion = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeApplicationName <- case applicationName of
        Nothing -> return nullPtr
        Just jApplicationName -> do
            jApplicationName' <- textToCString jApplicationName
            return jApplicationName'
    maybeApplicationVersion <- case applicationVersion of
        Nothing -> return nullPtr
        Just jApplicationVersion -> do
            jApplicationVersion' <- textToCString jApplicationVersion
            return jApplicationVersion'
    webkit_settings_set_user_agent_with_application_details _obj' maybeApplicationName maybeApplicationVersion
    touchManagedPtr _obj
    freeMem maybeApplicationName
    freeMem maybeApplicationVersion
    return ()

data SettingsSetUserAgentWithApplicationDetailsMethodInfo
instance (signature ~ (Maybe (T.Text) -> Maybe (T.Text) -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetUserAgentWithApplicationDetailsMethodInfo a signature where
    overloadedMethod _ = settingsSetUserAgentWithApplicationDetails

-- method Settings::set_zoom_text_only
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "zoom_text_only", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_settings_set_zoom_text_only" webkit_settings_set_zoom_text_only :: 
    Ptr Settings ->                         -- _obj : TInterface "WebKit2" "Settings"
    CInt ->                                 -- zoom_text_only : TBasicType TBoolean
    IO ()


settingsSetZoomTextOnly ::
    (MonadIO m, SettingsK a) =>
    a                                       -- _obj
    -> Bool                                 -- zoomTextOnly
    -> m ()                                 -- result
settingsSetZoomTextOnly _obj zoomTextOnly = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let zoomTextOnly' = (fromIntegral . fromEnum) zoomTextOnly
    webkit_settings_set_zoom_text_only _obj' zoomTextOnly'
    touchManagedPtr _obj
    return ()

data SettingsSetZoomTextOnlyMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, SettingsK a) => MethodInfo SettingsSetZoomTextOnlyMethodInfo a signature where
    overloadedMethod _ = settingsSetZoomTextOnly


