

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.URIRequest
    ( 

-- * Exported types
    URIRequest(..)                          ,
    URIRequestK                             ,
    toURIRequest                            ,
    noURIRequest                            ,


 -- * Methods
-- ** uRIRequestGetHttpHeaders
    URIRequestGetHttpHeadersMethodInfo      ,
    uRIRequestGetHttpHeaders                ,


-- ** uRIRequestGetHttpMethod
    URIRequestGetHttpMethodMethodInfo       ,
    uRIRequestGetHttpMethod                 ,


-- ** uRIRequestGetUri
    URIRequestGetUriMethodInfo              ,
    uRIRequestGetUri                        ,


-- ** uRIRequestNew
    uRIRequestNew                           ,


-- ** uRIRequestSetUri
    URIRequestSetUriMethodInfo              ,
    uRIRequestSetUri                        ,




 -- * Properties
-- ** Uri
    URIRequestUriPropertyInfo               ,
    constructURIRequestUri                  ,
    getURIRequestUri                        ,
    setURIRequestUri                        ,
    uRIRequestUri                           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Soup as Soup

newtype URIRequest = URIRequest (ForeignPtr URIRequest)
foreign import ccall "webkit_uri_request_get_type"
    c_webkit_uri_request_get_type :: IO GType

type instance ParentTypes URIRequest = URIRequestParentTypes
type URIRequestParentTypes = '[GObject.Object]

instance GObject URIRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_uri_request_get_type
    

class GObject o => URIRequestK o
instance (GObject o, IsDescendantOf URIRequest o) => URIRequestK o

toURIRequest :: URIRequestK o => o -> IO URIRequest
toURIRequest = unsafeCastTo URIRequest

noURIRequest :: Maybe URIRequest
noURIRequest = Nothing

type family ResolveURIRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveURIRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveURIRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveURIRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveURIRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveURIRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveURIRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveURIRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveURIRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveURIRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveURIRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveURIRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveURIRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveURIRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveURIRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveURIRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveURIRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveURIRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveURIRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveURIRequestMethod "getHttpHeaders" o = URIRequestGetHttpHeadersMethodInfo
    ResolveURIRequestMethod "getHttpMethod" o = URIRequestGetHttpMethodMethodInfo
    ResolveURIRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveURIRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveURIRequestMethod "getUri" o = URIRequestGetUriMethodInfo
    ResolveURIRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveURIRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveURIRequestMethod "setUri" o = URIRequestSetUriMethodInfo
    ResolveURIRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveURIRequestMethod t URIRequest, MethodInfo info URIRequest p) => IsLabelProxy t (URIRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveURIRequestMethod t URIRequest, MethodInfo info URIRequest p) => IsLabel t (URIRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

getURIRequestUri :: (MonadIO m, URIRequestK o) => o -> m T.Text
getURIRequestUri obj = liftIO $ checkUnexpectedNothing "getURIRequestUri" $ getObjectPropertyString obj "uri"

setURIRequestUri :: (MonadIO m, URIRequestK o) => o -> T.Text -> m ()
setURIRequestUri obj val = liftIO $ setObjectPropertyString obj "uri" (Just val)

constructURIRequestUri :: T.Text -> IO ([Char], GValue)
constructURIRequestUri val = constructObjectPropertyString "uri" (Just val)

data URIRequestUriPropertyInfo
instance AttrInfo URIRequestUriPropertyInfo where
    type AttrAllowedOps URIRequestUriPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint URIRequestUriPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint URIRequestUriPropertyInfo = URIRequestK
    type AttrGetType URIRequestUriPropertyInfo = T.Text
    type AttrLabel URIRequestUriPropertyInfo = "uri"
    attrGet _ = getURIRequestUri
    attrSet _ = setURIRequestUri
    attrConstruct _ = constructURIRequestUri
    attrClear _ = undefined

type instance AttributeList URIRequest = URIRequestAttributeList
type URIRequestAttributeList = ('[ '("uri", URIRequestUriPropertyInfo)] :: [(Symbol, *)])

uRIRequestUri :: AttrLabelProxy "uri"
uRIRequestUri = AttrLabelProxy

type instance SignalList URIRequest = URIRequestSignalList
type URIRequestSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method URIRequest::new
-- method type : Constructor
-- Args : [Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "URIRequest")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_request_new" webkit_uri_request_new :: 
    CString ->                              -- uri : TBasicType TUTF8
    IO (Ptr URIRequest)


uRIRequestNew ::
    (MonadIO m) =>
    T.Text                                  -- uri
    -> m URIRequest                         -- result
uRIRequestNew uri = liftIO $ do
    uri' <- textToCString uri
    result <- webkit_uri_request_new uri'
    checkUnexpectedReturnNULL "webkit_uri_request_new" result
    result' <- (wrapObject URIRequest) result
    freeMem uri'
    return result'

-- method URIRequest::get_http_headers
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URIRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "Soup" "MessageHeaders")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_request_get_http_headers" webkit_uri_request_get_http_headers :: 
    Ptr URIRequest ->                       -- _obj : TInterface "WebKit2" "URIRequest"
    IO (Ptr Soup.MessageHeaders)


uRIRequestGetHttpHeaders ::
    (MonadIO m, URIRequestK a) =>
    a                                       -- _obj
    -> m Soup.MessageHeaders                -- result
uRIRequestGetHttpHeaders _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_request_get_http_headers _obj'
    checkUnexpectedReturnNULL "webkit_uri_request_get_http_headers" result
    result' <- (newBoxed Soup.MessageHeaders) result
    touchManagedPtr _obj
    return result'

data URIRequestGetHttpHeadersMethodInfo
instance (signature ~ (m Soup.MessageHeaders), MonadIO m, URIRequestK a) => MethodInfo URIRequestGetHttpHeadersMethodInfo a signature where
    overloadedMethod _ = uRIRequestGetHttpHeaders

-- method URIRequest::get_http_method
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URIRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_request_get_http_method" webkit_uri_request_get_http_method :: 
    Ptr URIRequest ->                       -- _obj : TInterface "WebKit2" "URIRequest"
    IO CString


uRIRequestGetHttpMethod ::
    (MonadIO m, URIRequestK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
uRIRequestGetHttpMethod _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_request_get_http_method _obj'
    checkUnexpectedReturnNULL "webkit_uri_request_get_http_method" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data URIRequestGetHttpMethodMethodInfo
instance (signature ~ (m T.Text), MonadIO m, URIRequestK a) => MethodInfo URIRequestGetHttpMethodMethodInfo a signature where
    overloadedMethod _ = uRIRequestGetHttpMethod

-- method URIRequest::get_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URIRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_request_get_uri" webkit_uri_request_get_uri :: 
    Ptr URIRequest ->                       -- _obj : TInterface "WebKit2" "URIRequest"
    IO CString


uRIRequestGetUri ::
    (MonadIO m, URIRequestK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
uRIRequestGetUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_request_get_uri _obj'
    checkUnexpectedReturnNULL "webkit_uri_request_get_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data URIRequestGetUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, URIRequestK a) => MethodInfo URIRequestGetUriMethodInfo a signature where
    overloadedMethod _ = uRIRequestGetUri

-- method URIRequest::set_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URIRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_request_set_uri" webkit_uri_request_set_uri :: 
    Ptr URIRequest ->                       -- _obj : TInterface "WebKit2" "URIRequest"
    CString ->                              -- uri : TBasicType TUTF8
    IO ()


uRIRequestSetUri ::
    (MonadIO m, URIRequestK a) =>
    a                                       -- _obj
    -> T.Text                               -- uri
    -> m ()                                 -- result
uRIRequestSetUri _obj uri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    uri' <- textToCString uri
    webkit_uri_request_set_uri _obj' uri'
    touchManagedPtr _obj
    freeMem uri'
    return ()

data URIRequestSetUriMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, URIRequestK a) => MethodInfo URIRequestSetUriMethodInfo a signature where
    overloadedMethod _ = uRIRequestSetUri


