

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.URISchemeRequest
    ( 

-- * Exported types
    URISchemeRequest(..)                    ,
    URISchemeRequestK                       ,
    toURISchemeRequest                      ,
    noURISchemeRequest                      ,


 -- * Methods
-- ** uRISchemeRequestFinish
    URISchemeRequestFinishMethodInfo        ,
    uRISchemeRequestFinish                  ,


-- ** uRISchemeRequestFinishError
    URISchemeRequestFinishErrorMethodInfo   ,
    uRISchemeRequestFinishError             ,


-- ** uRISchemeRequestGetPath
    URISchemeRequestGetPathMethodInfo       ,
    uRISchemeRequestGetPath                 ,


-- ** uRISchemeRequestGetScheme
    URISchemeRequestGetSchemeMethodInfo     ,
    uRISchemeRequestGetScheme               ,


-- ** uRISchemeRequestGetUri
    URISchemeRequestGetUriMethodInfo        ,
    uRISchemeRequestGetUri                  ,


-- ** uRISchemeRequestGetWebView
    URISchemeRequestGetWebViewMethodInfo    ,
    uRISchemeRequestGetWebView              ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Gio as Gio

newtype URISchemeRequest = URISchemeRequest (ForeignPtr URISchemeRequest)
foreign import ccall "webkit_uri_scheme_request_get_type"
    c_webkit_uri_scheme_request_get_type :: IO GType

type instance ParentTypes URISchemeRequest = URISchemeRequestParentTypes
type URISchemeRequestParentTypes = '[GObject.Object]

instance GObject URISchemeRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_uri_scheme_request_get_type
    

class GObject o => URISchemeRequestK o
instance (GObject o, IsDescendantOf URISchemeRequest o) => URISchemeRequestK o

toURISchemeRequest :: URISchemeRequestK o => o -> IO URISchemeRequest
toURISchemeRequest = unsafeCastTo URISchemeRequest

noURISchemeRequest :: Maybe URISchemeRequest
noURISchemeRequest = Nothing

type family ResolveURISchemeRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveURISchemeRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveURISchemeRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveURISchemeRequestMethod "finish" o = URISchemeRequestFinishMethodInfo
    ResolveURISchemeRequestMethod "finishError" o = URISchemeRequestFinishErrorMethodInfo
    ResolveURISchemeRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveURISchemeRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveURISchemeRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveURISchemeRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveURISchemeRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveURISchemeRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveURISchemeRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveURISchemeRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveURISchemeRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveURISchemeRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveURISchemeRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveURISchemeRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveURISchemeRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveURISchemeRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveURISchemeRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveURISchemeRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveURISchemeRequestMethod "getPath" o = URISchemeRequestGetPathMethodInfo
    ResolveURISchemeRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveURISchemeRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveURISchemeRequestMethod "getScheme" o = URISchemeRequestGetSchemeMethodInfo
    ResolveURISchemeRequestMethod "getUri" o = URISchemeRequestGetUriMethodInfo
    ResolveURISchemeRequestMethod "getWebView" o = URISchemeRequestGetWebViewMethodInfo
    ResolveURISchemeRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveURISchemeRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveURISchemeRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveURISchemeRequestMethod t URISchemeRequest, MethodInfo info URISchemeRequest p) => IsLabelProxy t (URISchemeRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveURISchemeRequestMethod t URISchemeRequest, MethodInfo info URISchemeRequest p) => IsLabel t (URISchemeRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList URISchemeRequest = URISchemeRequestAttributeList
type URISchemeRequestAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList URISchemeRequest = URISchemeRequestSignalList
type URISchemeRequestSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method URISchemeRequest::finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URISchemeRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "stream", argType = TInterface "Gio" "InputStream", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "stream_length", argType = TBasicType TInt64, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "mime_type", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_scheme_request_finish" webkit_uri_scheme_request_finish :: 
    Ptr URISchemeRequest ->                 -- _obj : TInterface "WebKit2" "URISchemeRequest"
    Ptr Gio.InputStream ->                  -- stream : TInterface "Gio" "InputStream"
    Int64 ->                                -- stream_length : TBasicType TInt64
    CString ->                              -- mime_type : TBasicType TUTF8
    IO ()


uRISchemeRequestFinish ::
    (MonadIO m, URISchemeRequestK a, Gio.InputStreamK b) =>
    a                                       -- _obj
    -> b                                    -- stream
    -> Int64                                -- streamLength
    -> Maybe (T.Text)                       -- mimeType
    -> m ()                                 -- result
uRISchemeRequestFinish _obj stream streamLength mimeType = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let stream' = unsafeManagedPtrCastPtr stream
    maybeMimeType <- case mimeType of
        Nothing -> return nullPtr
        Just jMimeType -> do
            jMimeType' <- textToCString jMimeType
            return jMimeType'
    webkit_uri_scheme_request_finish _obj' stream' streamLength maybeMimeType
    touchManagedPtr _obj
    touchManagedPtr stream
    freeMem maybeMimeType
    return ()

data URISchemeRequestFinishMethodInfo
instance (signature ~ (b -> Int64 -> Maybe (T.Text) -> m ()), MonadIO m, URISchemeRequestK a, Gio.InputStreamK b) => MethodInfo URISchemeRequestFinishMethodInfo a signature where
    overloadedMethod _ = uRISchemeRequestFinish

-- method URISchemeRequest::finish_error
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URISchemeRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "error", argType = TError, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_scheme_request_finish_error" webkit_uri_scheme_request_finish_error :: 
    Ptr URISchemeRequest ->                 -- _obj : TInterface "WebKit2" "URISchemeRequest"
    Ptr GError ->                           -- error : TError
    IO ()


uRISchemeRequestFinishError ::
    (MonadIO m, URISchemeRequestK a) =>
    a                                       -- _obj
    -> GError                               -- error_
    -> m ()                                 -- result
uRISchemeRequestFinishError _obj error_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let error_' = unsafeManagedPtrGetPtr error_
    webkit_uri_scheme_request_finish_error _obj' error_'
    touchManagedPtr _obj
    touchManagedPtr error_
    return ()

data URISchemeRequestFinishErrorMethodInfo
instance (signature ~ (GError -> m ()), MonadIO m, URISchemeRequestK a) => MethodInfo URISchemeRequestFinishErrorMethodInfo a signature where
    overloadedMethod _ = uRISchemeRequestFinishError

-- method URISchemeRequest::get_path
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URISchemeRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_scheme_request_get_path" webkit_uri_scheme_request_get_path :: 
    Ptr URISchemeRequest ->                 -- _obj : TInterface "WebKit2" "URISchemeRequest"
    IO CString


uRISchemeRequestGetPath ::
    (MonadIO m, URISchemeRequestK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
uRISchemeRequestGetPath _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_scheme_request_get_path _obj'
    checkUnexpectedReturnNULL "webkit_uri_scheme_request_get_path" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data URISchemeRequestGetPathMethodInfo
instance (signature ~ (m T.Text), MonadIO m, URISchemeRequestK a) => MethodInfo URISchemeRequestGetPathMethodInfo a signature where
    overloadedMethod _ = uRISchemeRequestGetPath

-- method URISchemeRequest::get_scheme
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URISchemeRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_scheme_request_get_scheme" webkit_uri_scheme_request_get_scheme :: 
    Ptr URISchemeRequest ->                 -- _obj : TInterface "WebKit2" "URISchemeRequest"
    IO CString


uRISchemeRequestGetScheme ::
    (MonadIO m, URISchemeRequestK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
uRISchemeRequestGetScheme _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_scheme_request_get_scheme _obj'
    checkUnexpectedReturnNULL "webkit_uri_scheme_request_get_scheme" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data URISchemeRequestGetSchemeMethodInfo
instance (signature ~ (m T.Text), MonadIO m, URISchemeRequestK a) => MethodInfo URISchemeRequestGetSchemeMethodInfo a signature where
    overloadedMethod _ = uRISchemeRequestGetScheme

-- method URISchemeRequest::get_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URISchemeRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_scheme_request_get_uri" webkit_uri_scheme_request_get_uri :: 
    Ptr URISchemeRequest ->                 -- _obj : TInterface "WebKit2" "URISchemeRequest"
    IO CString


uRISchemeRequestGetUri ::
    (MonadIO m, URISchemeRequestK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
uRISchemeRequestGetUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_scheme_request_get_uri _obj'
    checkUnexpectedReturnNULL "webkit_uri_scheme_request_get_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data URISchemeRequestGetUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, URISchemeRequestK a) => MethodInfo URISchemeRequestGetUriMethodInfo a signature where
    overloadedMethod _ = uRISchemeRequestGetUri

-- method URISchemeRequest::get_web_view
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "URISchemeRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebView")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_scheme_request_get_web_view" webkit_uri_scheme_request_get_web_view :: 
    Ptr URISchemeRequest ->                 -- _obj : TInterface "WebKit2" "URISchemeRequest"
    IO (Ptr WebView)


uRISchemeRequestGetWebView ::
    (MonadIO m, URISchemeRequestK a) =>
    a                                       -- _obj
    -> m WebView                            -- result
uRISchemeRequestGetWebView _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_scheme_request_get_web_view _obj'
    checkUnexpectedReturnNULL "webkit_uri_scheme_request_get_web_view" result
    result' <- (newObject WebView) result
    touchManagedPtr _obj
    return result'

data URISchemeRequestGetWebViewMethodInfo
instance (signature ~ (m WebView), MonadIO m, URISchemeRequestK a) => MethodInfo URISchemeRequestGetWebViewMethodInfo a signature where
    overloadedMethod _ = uRISchemeRequestGetWebView


