

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.UserContentManager
    ( 

-- * Exported types
    UserContentManager(..)                  ,
    UserContentManagerK                     ,
    toUserContentManager                    ,
    noUserContentManager                    ,


 -- * Methods
-- ** userContentManagerAddScript
    UserContentManagerAddScriptMethodInfo   ,
    userContentManagerAddScript             ,


-- ** userContentManagerAddStyleSheet
    UserContentManagerAddStyleSheetMethodInfo,
    userContentManagerAddStyleSheet         ,


-- ** userContentManagerNew
    userContentManagerNew                   ,


-- ** userContentManagerRegisterScriptMessageHandler
    UserContentManagerRegisterScriptMessageHandlerMethodInfo,
    userContentManagerRegisterScriptMessageHandler,


-- ** userContentManagerRemoveAllScripts
    UserContentManagerRemoveAllScriptsMethodInfo,
    userContentManagerRemoveAllScripts      ,


-- ** userContentManagerRemoveAllStyleSheets
    UserContentManagerRemoveAllStyleSheetsMethodInfo,
    userContentManagerRemoveAllStyleSheets  ,


-- ** userContentManagerUnregisterScriptMessageHandler
    UserContentManagerUnregisterScriptMessageHandlerMethodInfo,
    userContentManagerUnregisterScriptMessageHandler,




 -- * Signals
-- ** ScriptMessageReceived
    UserContentManagerScriptMessageReceivedCallback,
    UserContentManagerScriptMessageReceivedCallbackC,
    UserContentManagerScriptMessageReceivedSignalInfo,
    afterUserContentManagerScriptMessageReceived,
    mkUserContentManagerScriptMessageReceivedCallback,
    noUserContentManagerScriptMessageReceivedCallback,
    onUserContentManagerScriptMessageReceived,
    userContentManagerScriptMessageReceivedCallbackWrapper,
    userContentManagerScriptMessageReceivedClosure,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype UserContentManager = UserContentManager (ForeignPtr UserContentManager)
foreign import ccall "webkit_user_content_manager_get_type"
    c_webkit_user_content_manager_get_type :: IO GType

type instance ParentTypes UserContentManager = UserContentManagerParentTypes
type UserContentManagerParentTypes = '[GObject.Object]

instance GObject UserContentManager where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_user_content_manager_get_type
    

class GObject o => UserContentManagerK o
instance (GObject o, IsDescendantOf UserContentManager o) => UserContentManagerK o

toUserContentManager :: UserContentManagerK o => o -> IO UserContentManager
toUserContentManager = unsafeCastTo UserContentManager

noUserContentManager :: Maybe UserContentManager
noUserContentManager = Nothing

type family ResolveUserContentManagerMethod (t :: Symbol) (o :: *) :: * where
    ResolveUserContentManagerMethod "addScript" o = UserContentManagerAddScriptMethodInfo
    ResolveUserContentManagerMethod "addStyleSheet" o = UserContentManagerAddStyleSheetMethodInfo
    ResolveUserContentManagerMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveUserContentManagerMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveUserContentManagerMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveUserContentManagerMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveUserContentManagerMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveUserContentManagerMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveUserContentManagerMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveUserContentManagerMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveUserContentManagerMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveUserContentManagerMethod "registerScriptMessageHandler" o = UserContentManagerRegisterScriptMessageHandlerMethodInfo
    ResolveUserContentManagerMethod "removeAllScripts" o = UserContentManagerRemoveAllScriptsMethodInfo
    ResolveUserContentManagerMethod "removeAllStyleSheets" o = UserContentManagerRemoveAllStyleSheetsMethodInfo
    ResolveUserContentManagerMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveUserContentManagerMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveUserContentManagerMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveUserContentManagerMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveUserContentManagerMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveUserContentManagerMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveUserContentManagerMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveUserContentManagerMethod "unregisterScriptMessageHandler" o = UserContentManagerUnregisterScriptMessageHandlerMethodInfo
    ResolveUserContentManagerMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveUserContentManagerMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveUserContentManagerMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveUserContentManagerMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveUserContentManagerMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveUserContentManagerMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveUserContentManagerMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveUserContentManagerMethod t UserContentManager, MethodInfo info UserContentManager p) => IsLabelProxy t (UserContentManager -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveUserContentManagerMethod t UserContentManager, MethodInfo info UserContentManager p) => IsLabel t (UserContentManager -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal UserContentManager::script-message-received
type UserContentManagerScriptMessageReceivedCallback =
    JavascriptResult ->
    IO ()

noUserContentManagerScriptMessageReceivedCallback :: Maybe UserContentManagerScriptMessageReceivedCallback
noUserContentManagerScriptMessageReceivedCallback = Nothing

type UserContentManagerScriptMessageReceivedCallbackC =
    Ptr () ->                               -- object
    Ptr JavascriptResult ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkUserContentManagerScriptMessageReceivedCallback :: UserContentManagerScriptMessageReceivedCallbackC -> IO (FunPtr UserContentManagerScriptMessageReceivedCallbackC)

userContentManagerScriptMessageReceivedClosure :: UserContentManagerScriptMessageReceivedCallback -> IO Closure
userContentManagerScriptMessageReceivedClosure cb = newCClosure =<< mkUserContentManagerScriptMessageReceivedCallback wrapped
    where wrapped = userContentManagerScriptMessageReceivedCallbackWrapper cb

userContentManagerScriptMessageReceivedCallbackWrapper ::
    UserContentManagerScriptMessageReceivedCallback ->
    Ptr () ->
    Ptr JavascriptResult ->
    Ptr () ->
    IO ()
userContentManagerScriptMessageReceivedCallbackWrapper _cb _ jsResult _ = do
    jsResult' <- (newBoxed JavascriptResult) jsResult
    _cb  jsResult'

onUserContentManagerScriptMessageReceived :: (GObject a, MonadIO m) => a -> UserContentManagerScriptMessageReceivedCallback -> m SignalHandlerId
onUserContentManagerScriptMessageReceived obj cb = liftIO $ connectUserContentManagerScriptMessageReceived obj cb SignalConnectBefore
afterUserContentManagerScriptMessageReceived :: (GObject a, MonadIO m) => a -> UserContentManagerScriptMessageReceivedCallback -> m SignalHandlerId
afterUserContentManagerScriptMessageReceived obj cb = connectUserContentManagerScriptMessageReceived obj cb SignalConnectAfter

connectUserContentManagerScriptMessageReceived :: (GObject a, MonadIO m) =>
                                                  a -> UserContentManagerScriptMessageReceivedCallback -> SignalConnectMode -> m SignalHandlerId
connectUserContentManagerScriptMessageReceived obj cb after = liftIO $ do
    cb' <- mkUserContentManagerScriptMessageReceivedCallback (userContentManagerScriptMessageReceivedCallbackWrapper cb)
    connectSignalFunPtr obj "script-message-received" cb' after

type instance AttributeList UserContentManager = UserContentManagerAttributeList
type UserContentManagerAttributeList = ('[ ] :: [(Symbol, *)])

data UserContentManagerScriptMessageReceivedSignalInfo
instance SignalInfo UserContentManagerScriptMessageReceivedSignalInfo where
    type HaskellCallbackType UserContentManagerScriptMessageReceivedSignalInfo = UserContentManagerScriptMessageReceivedCallback
    connectSignal _ = connectUserContentManagerScriptMessageReceived

type instance SignalList UserContentManager = UserContentManagerSignalList
type UserContentManagerSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo), '("scriptMessageReceived", UserContentManagerScriptMessageReceivedSignalInfo)] :: [(Symbol, *)])

-- method UserContentManager::new
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "UserContentManager")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_content_manager_new" webkit_user_content_manager_new :: 
    IO (Ptr UserContentManager)


userContentManagerNew ::
    (MonadIO m) =>
    m UserContentManager                    -- result
userContentManagerNew  = liftIO $ do
    result <- webkit_user_content_manager_new
    checkUnexpectedReturnNULL "webkit_user_content_manager_new" result
    result' <- (wrapObject UserContentManager) result
    return result'

-- method UserContentManager::add_script
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserContentManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "script", argType = TInterface "WebKit2" "UserScript", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_content_manager_add_script" webkit_user_content_manager_add_script :: 
    Ptr UserContentManager ->               -- _obj : TInterface "WebKit2" "UserContentManager"
    Ptr UserScript ->                       -- script : TInterface "WebKit2" "UserScript"
    IO ()


userContentManagerAddScript ::
    (MonadIO m, UserContentManagerK a) =>
    a                                       -- _obj
    -> UserScript                           -- script
    -> m ()                                 -- result
userContentManagerAddScript _obj script = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let script' = unsafeManagedPtrGetPtr script
    webkit_user_content_manager_add_script _obj' script'
    touchManagedPtr _obj
    touchManagedPtr script
    return ()

data UserContentManagerAddScriptMethodInfo
instance (signature ~ (UserScript -> m ()), MonadIO m, UserContentManagerK a) => MethodInfo UserContentManagerAddScriptMethodInfo a signature where
    overloadedMethod _ = userContentManagerAddScript

-- method UserContentManager::add_style_sheet
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserContentManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "stylesheet", argType = TInterface "WebKit2" "UserStyleSheet", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_content_manager_add_style_sheet" webkit_user_content_manager_add_style_sheet :: 
    Ptr UserContentManager ->               -- _obj : TInterface "WebKit2" "UserContentManager"
    Ptr UserStyleSheet ->                   -- stylesheet : TInterface "WebKit2" "UserStyleSheet"
    IO ()


userContentManagerAddStyleSheet ::
    (MonadIO m, UserContentManagerK a) =>
    a                                       -- _obj
    -> UserStyleSheet                       -- stylesheet
    -> m ()                                 -- result
userContentManagerAddStyleSheet _obj stylesheet = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let stylesheet' = unsafeManagedPtrGetPtr stylesheet
    webkit_user_content_manager_add_style_sheet _obj' stylesheet'
    touchManagedPtr _obj
    touchManagedPtr stylesheet
    return ()

data UserContentManagerAddStyleSheetMethodInfo
instance (signature ~ (UserStyleSheet -> m ()), MonadIO m, UserContentManagerK a) => MethodInfo UserContentManagerAddStyleSheetMethodInfo a signature where
    overloadedMethod _ = userContentManagerAddStyleSheet

-- method UserContentManager::register_script_message_handler
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserContentManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_content_manager_register_script_message_handler" webkit_user_content_manager_register_script_message_handler :: 
    Ptr UserContentManager ->               -- _obj : TInterface "WebKit2" "UserContentManager"
    CString ->                              -- name : TBasicType TUTF8
    IO CInt


userContentManagerRegisterScriptMessageHandler ::
    (MonadIO m, UserContentManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- name
    -> m Bool                               -- result
userContentManagerRegisterScriptMessageHandler _obj name = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    name' <- textToCString name
    result <- webkit_user_content_manager_register_script_message_handler _obj' name'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem name'
    return result'

data UserContentManagerRegisterScriptMessageHandlerMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, UserContentManagerK a) => MethodInfo UserContentManagerRegisterScriptMessageHandlerMethodInfo a signature where
    overloadedMethod _ = userContentManagerRegisterScriptMessageHandler

-- method UserContentManager::remove_all_scripts
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserContentManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_content_manager_remove_all_scripts" webkit_user_content_manager_remove_all_scripts :: 
    Ptr UserContentManager ->               -- _obj : TInterface "WebKit2" "UserContentManager"
    IO ()


userContentManagerRemoveAllScripts ::
    (MonadIO m, UserContentManagerK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
userContentManagerRemoveAllScripts _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_user_content_manager_remove_all_scripts _obj'
    touchManagedPtr _obj
    return ()

data UserContentManagerRemoveAllScriptsMethodInfo
instance (signature ~ (m ()), MonadIO m, UserContentManagerK a) => MethodInfo UserContentManagerRemoveAllScriptsMethodInfo a signature where
    overloadedMethod _ = userContentManagerRemoveAllScripts

-- method UserContentManager::remove_all_style_sheets
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserContentManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_content_manager_remove_all_style_sheets" webkit_user_content_manager_remove_all_style_sheets :: 
    Ptr UserContentManager ->               -- _obj : TInterface "WebKit2" "UserContentManager"
    IO ()


userContentManagerRemoveAllStyleSheets ::
    (MonadIO m, UserContentManagerK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
userContentManagerRemoveAllStyleSheets _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_user_content_manager_remove_all_style_sheets _obj'
    touchManagedPtr _obj
    return ()

data UserContentManagerRemoveAllStyleSheetsMethodInfo
instance (signature ~ (m ()), MonadIO m, UserContentManagerK a) => MethodInfo UserContentManagerRemoveAllStyleSheetsMethodInfo a signature where
    overloadedMethod _ = userContentManagerRemoveAllStyleSheets

-- method UserContentManager::unregister_script_message_handler
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserContentManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_content_manager_unregister_script_message_handler" webkit_user_content_manager_unregister_script_message_handler :: 
    Ptr UserContentManager ->               -- _obj : TInterface "WebKit2" "UserContentManager"
    CString ->                              -- name : TBasicType TUTF8
    IO ()


userContentManagerUnregisterScriptMessageHandler ::
    (MonadIO m, UserContentManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- name
    -> m ()                                 -- result
userContentManagerUnregisterScriptMessageHandler _obj name = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    name' <- textToCString name
    webkit_user_content_manager_unregister_script_message_handler _obj' name'
    touchManagedPtr _obj
    freeMem name'
    return ()

data UserContentManagerUnregisterScriptMessageHandlerMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, UserContentManagerK a) => MethodInfo UserContentManagerUnregisterScriptMessageHandlerMethodInfo a signature where
    overloadedMethod _ = userContentManagerUnregisterScriptMessageHandler


