

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.UserMediaPermissionRequest
    ( 

-- * Exported types
    UserMediaPermissionRequest(..)          ,
    UserMediaPermissionRequestK             ,
    toUserMediaPermissionRequest            ,
    noUserMediaPermissionRequest            ,


 -- * Properties
-- ** IsForAudioDevice
    UserMediaPermissionRequestIsForAudioDevicePropertyInfo,
    getUserMediaPermissionRequestIsForAudioDevice,
    userMediaPermissionRequestIsForAudioDevice,


-- ** IsForVideoDevice
    UserMediaPermissionRequestIsForVideoDevicePropertyInfo,
    getUserMediaPermissionRequestIsForVideoDevice,
    userMediaPermissionRequestIsForVideoDevice,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype UserMediaPermissionRequest = UserMediaPermissionRequest (ForeignPtr UserMediaPermissionRequest)
foreign import ccall "webkit_user_media_permission_request_get_type"
    c_webkit_user_media_permission_request_get_type :: IO GType

type instance ParentTypes UserMediaPermissionRequest = UserMediaPermissionRequestParentTypes
type UserMediaPermissionRequestParentTypes = '[GObject.Object, PermissionRequest]

instance GObject UserMediaPermissionRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_user_media_permission_request_get_type
    

class GObject o => UserMediaPermissionRequestK o
instance (GObject o, IsDescendantOf UserMediaPermissionRequest o) => UserMediaPermissionRequestK o

toUserMediaPermissionRequest :: UserMediaPermissionRequestK o => o -> IO UserMediaPermissionRequest
toUserMediaPermissionRequest = unsafeCastTo UserMediaPermissionRequest

noUserMediaPermissionRequest :: Maybe UserMediaPermissionRequest
noUserMediaPermissionRequest = Nothing

type family ResolveUserMediaPermissionRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveUserMediaPermissionRequestMethod "allow" o = PermissionRequestAllowMethodInfo
    ResolveUserMediaPermissionRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveUserMediaPermissionRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveUserMediaPermissionRequestMethod "deny" o = PermissionRequestDenyMethodInfo
    ResolveUserMediaPermissionRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveUserMediaPermissionRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveUserMediaPermissionRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveUserMediaPermissionRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveUserMediaPermissionRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveUserMediaPermissionRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveUserMediaPermissionRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveUserMediaPermissionRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveUserMediaPermissionRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveUserMediaPermissionRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveUserMediaPermissionRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveUserMediaPermissionRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveUserMediaPermissionRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveUserMediaPermissionRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveUserMediaPermissionRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveUserMediaPermissionRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveUserMediaPermissionRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveUserMediaPermissionRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveUserMediaPermissionRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveUserMediaPermissionRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveUserMediaPermissionRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveUserMediaPermissionRequestMethod t UserMediaPermissionRequest, MethodInfo info UserMediaPermissionRequest p) => IsLabelProxy t (UserMediaPermissionRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveUserMediaPermissionRequestMethod t UserMediaPermissionRequest, MethodInfo info UserMediaPermissionRequest p) => IsLabel t (UserMediaPermissionRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "is-for-audio-device"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getUserMediaPermissionRequestIsForAudioDevice :: (MonadIO m, UserMediaPermissionRequestK o) => o -> m Bool
getUserMediaPermissionRequestIsForAudioDevice obj = liftIO $ getObjectPropertyBool obj "is-for-audio-device"

data UserMediaPermissionRequestIsForAudioDevicePropertyInfo
instance AttrInfo UserMediaPermissionRequestIsForAudioDevicePropertyInfo where
    type AttrAllowedOps UserMediaPermissionRequestIsForAudioDevicePropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint UserMediaPermissionRequestIsForAudioDevicePropertyInfo = (~) ()
    type AttrBaseTypeConstraint UserMediaPermissionRequestIsForAudioDevicePropertyInfo = UserMediaPermissionRequestK
    type AttrGetType UserMediaPermissionRequestIsForAudioDevicePropertyInfo = Bool
    type AttrLabel UserMediaPermissionRequestIsForAudioDevicePropertyInfo = "is-for-audio-device"
    attrGet _ = getUserMediaPermissionRequestIsForAudioDevice
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "is-for-video-device"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getUserMediaPermissionRequestIsForVideoDevice :: (MonadIO m, UserMediaPermissionRequestK o) => o -> m Bool
getUserMediaPermissionRequestIsForVideoDevice obj = liftIO $ getObjectPropertyBool obj "is-for-video-device"

data UserMediaPermissionRequestIsForVideoDevicePropertyInfo
instance AttrInfo UserMediaPermissionRequestIsForVideoDevicePropertyInfo where
    type AttrAllowedOps UserMediaPermissionRequestIsForVideoDevicePropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint UserMediaPermissionRequestIsForVideoDevicePropertyInfo = (~) ()
    type AttrBaseTypeConstraint UserMediaPermissionRequestIsForVideoDevicePropertyInfo = UserMediaPermissionRequestK
    type AttrGetType UserMediaPermissionRequestIsForVideoDevicePropertyInfo = Bool
    type AttrLabel UserMediaPermissionRequestIsForVideoDevicePropertyInfo = "is-for-video-device"
    attrGet _ = getUserMediaPermissionRequestIsForVideoDevice
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList UserMediaPermissionRequest = UserMediaPermissionRequestAttributeList
type UserMediaPermissionRequestAttributeList = ('[ '("isForAudioDevice", UserMediaPermissionRequestIsForAudioDevicePropertyInfo), '("isForVideoDevice", UserMediaPermissionRequestIsForVideoDevicePropertyInfo)] :: [(Symbol, *)])

userMediaPermissionRequestIsForAudioDevice :: AttrLabelProxy "isForAudioDevice"
userMediaPermissionRequestIsForAudioDevice = AttrLabelProxy

userMediaPermissionRequestIsForVideoDevice :: AttrLabelProxy "isForVideoDevice"
userMediaPermissionRequestIsForVideoDevice = AttrLabelProxy

type instance SignalList UserMediaPermissionRequest = UserMediaPermissionRequestSignalList
type UserMediaPermissionRequestSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])


