

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.WebContext
    ( 

-- * Exported types
    WebContext(..)                          ,
    WebContextK                             ,
    toWebContext                            ,
    noWebContext                            ,


 -- * Methods
-- ** webContextAllowTlsCertificateForHost
    WebContextAllowTlsCertificateForHostMethodInfo,
    webContextAllowTlsCertificateForHost    ,


-- ** webContextClearCache
    WebContextClearCacheMethodInfo          ,
    webContextClearCache                    ,


-- ** webContextDownloadUri
    WebContextDownloadUriMethodInfo         ,
    webContextDownloadUri                   ,


-- ** webContextGetCacheModel
    WebContextGetCacheModelMethodInfo       ,
    webContextGetCacheModel                 ,


-- ** webContextGetCookieManager
    WebContextGetCookieManagerMethodInfo    ,
    webContextGetCookieManager              ,


-- ** webContextGetDefault
    webContextGetDefault                    ,


-- ** webContextGetFaviconDatabase
    WebContextGetFaviconDatabaseMethodInfo  ,
    webContextGetFaviconDatabase            ,


-- ** webContextGetFaviconDatabaseDirectory
    WebContextGetFaviconDatabaseDirectoryMethodInfo,
    webContextGetFaviconDatabaseDirectory   ,


-- ** webContextGetPlugins
    WebContextGetPluginsMethodInfo          ,
    webContextGetPlugins                    ,


-- ** webContextGetPluginsFinish
    WebContextGetPluginsFinishMethodInfo    ,
    webContextGetPluginsFinish              ,


-- ** webContextGetProcessModel
    WebContextGetProcessModelMethodInfo     ,
    webContextGetProcessModel               ,


-- ** webContextGetSecurityManager
    WebContextGetSecurityManagerMethodInfo  ,
    webContextGetSecurityManager            ,


-- ** webContextGetSpellCheckingEnabled
    WebContextGetSpellCheckingEnabledMethodInfo,
    webContextGetSpellCheckingEnabled       ,


-- ** webContextGetSpellCheckingLanguages
    WebContextGetSpellCheckingLanguagesMethodInfo,
    webContextGetSpellCheckingLanguages     ,


-- ** webContextGetTlsErrorsPolicy
    WebContextGetTlsErrorsPolicyMethodInfo  ,
    webContextGetTlsErrorsPolicy            ,


-- ** webContextGetWebProcessCountLimit
    WebContextGetWebProcessCountLimitMethodInfo,
    webContextGetWebProcessCountLimit       ,


-- ** webContextGetWebsiteDataManager
    WebContextGetWebsiteDataManagerMethodInfo,
    webContextGetWebsiteDataManager         ,


-- ** webContextNew
    webContextNew                           ,


-- ** webContextNewWithWebsiteDataManager
    webContextNewWithWebsiteDataManager     ,


-- ** webContextPrefetchDns
    WebContextPrefetchDnsMethodInfo         ,
    webContextPrefetchDns                   ,


-- ** webContextRegisterUriScheme
    WebContextRegisterUriSchemeMethodInfo   ,
    webContextRegisterUriScheme             ,


-- ** webContextSetAdditionalPluginsDirectory
    WebContextSetAdditionalPluginsDirectoryMethodInfo,
    webContextSetAdditionalPluginsDirectory ,


-- ** webContextSetCacheModel
    WebContextSetCacheModelMethodInfo       ,
    webContextSetCacheModel                 ,


-- ** webContextSetDiskCacheDirectory
    WebContextSetDiskCacheDirectoryMethodInfo,
    webContextSetDiskCacheDirectory         ,


-- ** webContextSetFaviconDatabaseDirectory
    WebContextSetFaviconDatabaseDirectoryMethodInfo,
    webContextSetFaviconDatabaseDirectory   ,


-- ** webContextSetPreferredLanguages
    WebContextSetPreferredLanguagesMethodInfo,
    webContextSetPreferredLanguages         ,


-- ** webContextSetProcessModel
    WebContextSetProcessModelMethodInfo     ,
    webContextSetProcessModel               ,


-- ** webContextSetSpellCheckingEnabled
    WebContextSetSpellCheckingEnabledMethodInfo,
    webContextSetSpellCheckingEnabled       ,


-- ** webContextSetSpellCheckingLanguages
    WebContextSetSpellCheckingLanguagesMethodInfo,
    webContextSetSpellCheckingLanguages     ,


-- ** webContextSetTlsErrorsPolicy
    WebContextSetTlsErrorsPolicyMethodInfo  ,
    webContextSetTlsErrorsPolicy            ,


-- ** webContextSetWebExtensionsDirectory
    WebContextSetWebExtensionsDirectoryMethodInfo,
    webContextSetWebExtensionsDirectory     ,


-- ** webContextSetWebExtensionsInitializationUserData
    WebContextSetWebExtensionsInitializationUserDataMethodInfo,
    webContextSetWebExtensionsInitializationUserData,


-- ** webContextSetWebProcessCountLimit
    WebContextSetWebProcessCountLimitMethodInfo,
    webContextSetWebProcessCountLimit       ,




 -- * Properties
-- ** LocalStorageDirectory
    WebContextLocalStorageDirectoryPropertyInfo,
    constructWebContextLocalStorageDirectory,
    getWebContextLocalStorageDirectory      ,
    webContextLocalStorageDirectory         ,


-- ** WebsiteDataManager
    WebContextWebsiteDataManagerPropertyInfo,
    constructWebContextWebsiteDataManager   ,
    getWebContextWebsiteDataManager         ,
    webContextWebsiteDataManager            ,




 -- * Signals
-- ** DownloadStarted
    WebContextDownloadStartedCallback       ,
    WebContextDownloadStartedCallbackC      ,
    WebContextDownloadStartedSignalInfo     ,
    afterWebContextDownloadStarted          ,
    mkWebContextDownloadStartedCallback     ,
    noWebContextDownloadStartedCallback     ,
    onWebContextDownloadStarted             ,
    webContextDownloadStartedCallbackWrapper,
    webContextDownloadStartedClosure        ,


-- ** InitializeWebExtensions
    WebContextInitializeWebExtensionsCallback,
    WebContextInitializeWebExtensionsCallbackC,
    WebContextInitializeWebExtensionsSignalInfo,
    afterWebContextInitializeWebExtensions  ,
    mkWebContextInitializeWebExtensionsCallback,
    noWebContextInitializeWebExtensionsCallback,
    onWebContextInitializeWebExtensions     ,
    webContextInitializeWebExtensionsCallbackWrapper,
    webContextInitializeWebExtensionsClosure,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GLib as GLib
import qualified GI.GObject as GObject
import qualified GI.Gio as Gio

newtype WebContext = WebContext (ForeignPtr WebContext)
foreign import ccall "webkit_web_context_get_type"
    c_webkit_web_context_get_type :: IO GType

type instance ParentTypes WebContext = WebContextParentTypes
type WebContextParentTypes = '[GObject.Object]

instance GObject WebContext where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_web_context_get_type
    

class GObject o => WebContextK o
instance (GObject o, IsDescendantOf WebContext o) => WebContextK o

toWebContext :: WebContextK o => o -> IO WebContext
toWebContext = unsafeCastTo WebContext

noWebContext :: Maybe WebContext
noWebContext = Nothing

type family ResolveWebContextMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebContextMethod "allowTlsCertificateForHost" o = WebContextAllowTlsCertificateForHostMethodInfo
    ResolveWebContextMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebContextMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebContextMethod "clearCache" o = WebContextClearCacheMethodInfo
    ResolveWebContextMethod "downloadUri" o = WebContextDownloadUriMethodInfo
    ResolveWebContextMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebContextMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebContextMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebContextMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebContextMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebContextMethod "prefetchDns" o = WebContextPrefetchDnsMethodInfo
    ResolveWebContextMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebContextMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebContextMethod "registerUriScheme" o = WebContextRegisterUriSchemeMethodInfo
    ResolveWebContextMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebContextMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebContextMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebContextMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebContextMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebContextMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebContextMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebContextMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebContextMethod "getCacheModel" o = WebContextGetCacheModelMethodInfo
    ResolveWebContextMethod "getCookieManager" o = WebContextGetCookieManagerMethodInfo
    ResolveWebContextMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebContextMethod "getFaviconDatabase" o = WebContextGetFaviconDatabaseMethodInfo
    ResolveWebContextMethod "getFaviconDatabaseDirectory" o = WebContextGetFaviconDatabaseDirectoryMethodInfo
    ResolveWebContextMethod "getPlugins" o = WebContextGetPluginsMethodInfo
    ResolveWebContextMethod "getPluginsFinish" o = WebContextGetPluginsFinishMethodInfo
    ResolveWebContextMethod "getProcessModel" o = WebContextGetProcessModelMethodInfo
    ResolveWebContextMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebContextMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebContextMethod "getSecurityManager" o = WebContextGetSecurityManagerMethodInfo
    ResolveWebContextMethod "getSpellCheckingEnabled" o = WebContextGetSpellCheckingEnabledMethodInfo
    ResolveWebContextMethod "getSpellCheckingLanguages" o = WebContextGetSpellCheckingLanguagesMethodInfo
    ResolveWebContextMethod "getTlsErrorsPolicy" o = WebContextGetTlsErrorsPolicyMethodInfo
    ResolveWebContextMethod "getWebProcessCountLimit" o = WebContextGetWebProcessCountLimitMethodInfo
    ResolveWebContextMethod "getWebsiteDataManager" o = WebContextGetWebsiteDataManagerMethodInfo
    ResolveWebContextMethod "setAdditionalPluginsDirectory" o = WebContextSetAdditionalPluginsDirectoryMethodInfo
    ResolveWebContextMethod "setCacheModel" o = WebContextSetCacheModelMethodInfo
    ResolveWebContextMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebContextMethod "setDiskCacheDirectory" o = WebContextSetDiskCacheDirectoryMethodInfo
    ResolveWebContextMethod "setFaviconDatabaseDirectory" o = WebContextSetFaviconDatabaseDirectoryMethodInfo
    ResolveWebContextMethod "setPreferredLanguages" o = WebContextSetPreferredLanguagesMethodInfo
    ResolveWebContextMethod "setProcessModel" o = WebContextSetProcessModelMethodInfo
    ResolveWebContextMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebContextMethod "setSpellCheckingEnabled" o = WebContextSetSpellCheckingEnabledMethodInfo
    ResolveWebContextMethod "setSpellCheckingLanguages" o = WebContextSetSpellCheckingLanguagesMethodInfo
    ResolveWebContextMethod "setTlsErrorsPolicy" o = WebContextSetTlsErrorsPolicyMethodInfo
    ResolveWebContextMethod "setWebExtensionsDirectory" o = WebContextSetWebExtensionsDirectoryMethodInfo
    ResolveWebContextMethod "setWebExtensionsInitializationUserData" o = WebContextSetWebExtensionsInitializationUserDataMethodInfo
    ResolveWebContextMethod "setWebProcessCountLimit" o = WebContextSetWebProcessCountLimitMethodInfo
    ResolveWebContextMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebContextMethod t WebContext, MethodInfo info WebContext p) => IsLabelProxy t (WebContext -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebContextMethod t WebContext, MethodInfo info WebContext p) => IsLabel t (WebContext -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal WebContext::download-started
type WebContextDownloadStartedCallback =
    Download ->
    IO ()

noWebContextDownloadStartedCallback :: Maybe WebContextDownloadStartedCallback
noWebContextDownloadStartedCallback = Nothing

type WebContextDownloadStartedCallbackC =
    Ptr () ->                               -- object
    Ptr Download ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebContextDownloadStartedCallback :: WebContextDownloadStartedCallbackC -> IO (FunPtr WebContextDownloadStartedCallbackC)

webContextDownloadStartedClosure :: WebContextDownloadStartedCallback -> IO Closure
webContextDownloadStartedClosure cb = newCClosure =<< mkWebContextDownloadStartedCallback wrapped
    where wrapped = webContextDownloadStartedCallbackWrapper cb

webContextDownloadStartedCallbackWrapper ::
    WebContextDownloadStartedCallback ->
    Ptr () ->
    Ptr Download ->
    Ptr () ->
    IO ()
webContextDownloadStartedCallbackWrapper _cb _ download _ = do
    download' <- (newObject Download) download
    _cb  download'

onWebContextDownloadStarted :: (GObject a, MonadIO m) => a -> WebContextDownloadStartedCallback -> m SignalHandlerId
onWebContextDownloadStarted obj cb = liftIO $ connectWebContextDownloadStarted obj cb SignalConnectBefore
afterWebContextDownloadStarted :: (GObject a, MonadIO m) => a -> WebContextDownloadStartedCallback -> m SignalHandlerId
afterWebContextDownloadStarted obj cb = connectWebContextDownloadStarted obj cb SignalConnectAfter

connectWebContextDownloadStarted :: (GObject a, MonadIO m) =>
                                    a -> WebContextDownloadStartedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebContextDownloadStarted obj cb after = liftIO $ do
    cb' <- mkWebContextDownloadStartedCallback (webContextDownloadStartedCallbackWrapper cb)
    connectSignalFunPtr obj "download-started" cb' after

-- signal WebContext::initialize-web-extensions
type WebContextInitializeWebExtensionsCallback =
    IO ()

noWebContextInitializeWebExtensionsCallback :: Maybe WebContextInitializeWebExtensionsCallback
noWebContextInitializeWebExtensionsCallback = Nothing

type WebContextInitializeWebExtensionsCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebContextInitializeWebExtensionsCallback :: WebContextInitializeWebExtensionsCallbackC -> IO (FunPtr WebContextInitializeWebExtensionsCallbackC)

webContextInitializeWebExtensionsClosure :: WebContextInitializeWebExtensionsCallback -> IO Closure
webContextInitializeWebExtensionsClosure cb = newCClosure =<< mkWebContextInitializeWebExtensionsCallback wrapped
    where wrapped = webContextInitializeWebExtensionsCallbackWrapper cb

webContextInitializeWebExtensionsCallbackWrapper ::
    WebContextInitializeWebExtensionsCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webContextInitializeWebExtensionsCallbackWrapper _cb _ _ = do
    _cb 

onWebContextInitializeWebExtensions :: (GObject a, MonadIO m) => a -> WebContextInitializeWebExtensionsCallback -> m SignalHandlerId
onWebContextInitializeWebExtensions obj cb = liftIO $ connectWebContextInitializeWebExtensions obj cb SignalConnectBefore
afterWebContextInitializeWebExtensions :: (GObject a, MonadIO m) => a -> WebContextInitializeWebExtensionsCallback -> m SignalHandlerId
afterWebContextInitializeWebExtensions obj cb = connectWebContextInitializeWebExtensions obj cb SignalConnectAfter

connectWebContextInitializeWebExtensions :: (GObject a, MonadIO m) =>
                                            a -> WebContextInitializeWebExtensionsCallback -> SignalConnectMode -> m SignalHandlerId
connectWebContextInitializeWebExtensions obj cb after = liftIO $ do
    cb' <- mkWebContextInitializeWebExtensionsCallback (webContextInitializeWebExtensionsCallbackWrapper cb)
    connectSignalFunPtr obj "initialize-web-extensions" cb' after

-- VVV Prop "local-storage-directory"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

getWebContextLocalStorageDirectory :: (MonadIO m, WebContextK o) => o -> m (Maybe T.Text)
getWebContextLocalStorageDirectory obj = liftIO $ getObjectPropertyString obj "local-storage-directory"

constructWebContextLocalStorageDirectory :: T.Text -> IO ([Char], GValue)
constructWebContextLocalStorageDirectory val = constructObjectPropertyString "local-storage-directory" (Just val)

data WebContextLocalStorageDirectoryPropertyInfo
instance AttrInfo WebContextLocalStorageDirectoryPropertyInfo where
    type AttrAllowedOps WebContextLocalStorageDirectoryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebContextLocalStorageDirectoryPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint WebContextLocalStorageDirectoryPropertyInfo = WebContextK
    type AttrGetType WebContextLocalStorageDirectoryPropertyInfo = (Maybe T.Text)
    type AttrLabel WebContextLocalStorageDirectoryPropertyInfo = "local-storage-directory"
    attrGet _ = getWebContextLocalStorageDirectory
    attrSet _ = undefined
    attrConstruct _ = constructWebContextLocalStorageDirectory
    attrClear _ = undefined

-- VVV Prop "website-data-manager"
   -- Type: TInterface "WebKit2" "WebsiteDataManager"
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebContextWebsiteDataManager :: (MonadIO m, WebContextK o) => o -> m WebsiteDataManager
getWebContextWebsiteDataManager obj = liftIO $ checkUnexpectedNothing "getWebContextWebsiteDataManager" $ getObjectPropertyObject obj "website-data-manager" WebsiteDataManager

constructWebContextWebsiteDataManager :: (WebsiteDataManagerK a) => a -> IO ([Char], GValue)
constructWebContextWebsiteDataManager val = constructObjectPropertyObject "website-data-manager" (Just val)

data WebContextWebsiteDataManagerPropertyInfo
instance AttrInfo WebContextWebsiteDataManagerPropertyInfo where
    type AttrAllowedOps WebContextWebsiteDataManagerPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebContextWebsiteDataManagerPropertyInfo = WebsiteDataManagerK
    type AttrBaseTypeConstraint WebContextWebsiteDataManagerPropertyInfo = WebContextK
    type AttrGetType WebContextWebsiteDataManagerPropertyInfo = WebsiteDataManager
    type AttrLabel WebContextWebsiteDataManagerPropertyInfo = "website-data-manager"
    attrGet _ = getWebContextWebsiteDataManager
    attrSet _ = undefined
    attrConstruct _ = constructWebContextWebsiteDataManager
    attrClear _ = undefined

type instance AttributeList WebContext = WebContextAttributeList
type WebContextAttributeList = ('[ '("localStorageDirectory", WebContextLocalStorageDirectoryPropertyInfo), '("websiteDataManager", WebContextWebsiteDataManagerPropertyInfo)] :: [(Symbol, *)])

webContextLocalStorageDirectory :: AttrLabelProxy "localStorageDirectory"
webContextLocalStorageDirectory = AttrLabelProxy

webContextWebsiteDataManager :: AttrLabelProxy "websiteDataManager"
webContextWebsiteDataManager = AttrLabelProxy

data WebContextDownloadStartedSignalInfo
instance SignalInfo WebContextDownloadStartedSignalInfo where
    type HaskellCallbackType WebContextDownloadStartedSignalInfo = WebContextDownloadStartedCallback
    connectSignal _ = connectWebContextDownloadStarted

data WebContextInitializeWebExtensionsSignalInfo
instance SignalInfo WebContextInitializeWebExtensionsSignalInfo where
    type HaskellCallbackType WebContextInitializeWebExtensionsSignalInfo = WebContextInitializeWebExtensionsCallback
    connectSignal _ = connectWebContextInitializeWebExtensions

type instance SignalList WebContext = WebContextSignalList
type WebContextSignalList = ('[ '("downloadStarted", WebContextDownloadStartedSignalInfo), '("initializeWebExtensions", WebContextInitializeWebExtensionsSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method WebContext::new
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebContext")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_new" webkit_web_context_new :: 
    IO (Ptr WebContext)


webContextNew ::
    (MonadIO m) =>
    m WebContext                            -- result
webContextNew  = liftIO $ do
    result <- webkit_web_context_new
    checkUnexpectedReturnNULL "webkit_web_context_new" result
    result' <- (wrapObject WebContext) result
    return result'

-- method WebContext::new_with_website_data_manager
-- method type : Constructor
-- Args : [Arg {argCName = "manager", argType = TInterface "WebKit2" "WebsiteDataManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebContext")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_new_with_website_data_manager" webkit_web_context_new_with_website_data_manager :: 
    Ptr WebsiteDataManager ->               -- manager : TInterface "WebKit2" "WebsiteDataManager"
    IO (Ptr WebContext)


webContextNewWithWebsiteDataManager ::
    (MonadIO m, WebsiteDataManagerK a) =>
    a                                       -- manager
    -> m WebContext                         -- result
webContextNewWithWebsiteDataManager manager = liftIO $ do
    let manager' = unsafeManagedPtrCastPtr manager
    result <- webkit_web_context_new_with_website_data_manager manager'
    checkUnexpectedReturnNULL "webkit_web_context_new_with_website_data_manager" result
    result' <- (wrapObject WebContext) result
    touchManagedPtr manager
    return result'

-- method WebContext::allow_tls_certificate_for_host
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "certificate", argType = TInterface "Gio" "TlsCertificate", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "host", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_allow_tls_certificate_for_host" webkit_web_context_allow_tls_certificate_for_host :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    Ptr Gio.TlsCertificate ->               -- certificate : TInterface "Gio" "TlsCertificate"
    CString ->                              -- host : TBasicType TUTF8
    IO ()


webContextAllowTlsCertificateForHost ::
    (MonadIO m, WebContextK a, Gio.TlsCertificateK b) =>
    a                                       -- _obj
    -> b                                    -- certificate
    -> T.Text                               -- host
    -> m ()                                 -- result
webContextAllowTlsCertificateForHost _obj certificate host = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let certificate' = unsafeManagedPtrCastPtr certificate
    host' <- textToCString host
    webkit_web_context_allow_tls_certificate_for_host _obj' certificate' host'
    touchManagedPtr _obj
    touchManagedPtr certificate
    freeMem host'
    return ()

data WebContextAllowTlsCertificateForHostMethodInfo
instance (signature ~ (b -> T.Text -> m ()), MonadIO m, WebContextK a, Gio.TlsCertificateK b) => MethodInfo WebContextAllowTlsCertificateForHostMethodInfo a signature where
    overloadedMethod _ = webContextAllowTlsCertificateForHost

-- method WebContext::clear_cache
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_clear_cache" webkit_web_context_clear_cache :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO ()


webContextClearCache ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webContextClearCache _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_context_clear_cache _obj'
    touchManagedPtr _obj
    return ()

data WebContextClearCacheMethodInfo
instance (signature ~ (m ()), MonadIO m, WebContextK a) => MethodInfo WebContextClearCacheMethodInfo a signature where
    overloadedMethod _ = webContextClearCache

-- method WebContext::download_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "Download")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_download_uri" webkit_web_context_download_uri :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CString ->                              -- uri : TBasicType TUTF8
    IO (Ptr Download)


webContextDownloadUri ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> T.Text                               -- uri
    -> m Download                           -- result
webContextDownloadUri _obj uri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    uri' <- textToCString uri
    result <- webkit_web_context_download_uri _obj' uri'
    checkUnexpectedReturnNULL "webkit_web_context_download_uri" result
    result' <- (wrapObject Download) result
    touchManagedPtr _obj
    freeMem uri'
    return result'

data WebContextDownloadUriMethodInfo
instance (signature ~ (T.Text -> m Download), MonadIO m, WebContextK a) => MethodInfo WebContextDownloadUriMethodInfo a signature where
    overloadedMethod _ = webContextDownloadUri

-- method WebContext::get_cache_model
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "CacheModel")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_cache_model" webkit_web_context_get_cache_model :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO CUInt


webContextGetCacheModel ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m CacheModel                         -- result
webContextGetCacheModel _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_cache_model _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data WebContextGetCacheModelMethodInfo
instance (signature ~ (m CacheModel), MonadIO m, WebContextK a) => MethodInfo WebContextGetCacheModelMethodInfo a signature where
    overloadedMethod _ = webContextGetCacheModel

-- method WebContext::get_cookie_manager
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "CookieManager")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_cookie_manager" webkit_web_context_get_cookie_manager :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO (Ptr CookieManager)


webContextGetCookieManager ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m CookieManager                      -- result
webContextGetCookieManager _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_cookie_manager _obj'
    checkUnexpectedReturnNULL "webkit_web_context_get_cookie_manager" result
    result' <- (newObject CookieManager) result
    touchManagedPtr _obj
    return result'

data WebContextGetCookieManagerMethodInfo
instance (signature ~ (m CookieManager), MonadIO m, WebContextK a) => MethodInfo WebContextGetCookieManagerMethodInfo a signature where
    overloadedMethod _ = webContextGetCookieManager

-- method WebContext::get_favicon_database
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "FaviconDatabase")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_favicon_database" webkit_web_context_get_favicon_database :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO (Ptr FaviconDatabase)


webContextGetFaviconDatabase ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m FaviconDatabase                    -- result
webContextGetFaviconDatabase _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_favicon_database _obj'
    checkUnexpectedReturnNULL "webkit_web_context_get_favicon_database" result
    result' <- (newObject FaviconDatabase) result
    touchManagedPtr _obj
    return result'

data WebContextGetFaviconDatabaseMethodInfo
instance (signature ~ (m FaviconDatabase), MonadIO m, WebContextK a) => MethodInfo WebContextGetFaviconDatabaseMethodInfo a signature where
    overloadedMethod _ = webContextGetFaviconDatabase

-- method WebContext::get_favicon_database_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_favicon_database_directory" webkit_web_context_get_favicon_database_directory :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO CString


webContextGetFaviconDatabaseDirectory ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
webContextGetFaviconDatabaseDirectory _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_favicon_database_directory _obj'
    checkUnexpectedReturnNULL "webkit_web_context_get_favicon_database_directory" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebContextGetFaviconDatabaseDirectoryMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebContextK a) => MethodInfo WebContextGetFaviconDatabaseDirectoryMethodInfo a signature where
    overloadedMethod _ = webContextGetFaviconDatabaseDirectory

-- method WebContext::get_plugins
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 3, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_plugins" webkit_web_context_get_plugins :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


webContextGetPlugins ::
    (MonadIO m, WebContextK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
webContextGetPlugins _obj cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_web_context_get_plugins _obj' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    return ()

data WebContextGetPluginsMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, WebContextK a, Gio.CancellableK b) => MethodInfo WebContextGetPluginsMethodInfo a signature where
    overloadedMethod _ = webContextGetPlugins

-- method WebContext::get_plugins_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TGList (TInterface "WebKit2" "Plugin"))
-- throws : True
-- Skip return : False

foreign import ccall "webkit_web_context_get_plugins_finish" webkit_web_context_get_plugins_finish :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr (GList (Ptr Plugin)))


webContextGetPluginsFinish ::
    (MonadIO m, WebContextK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m [Plugin]                           -- result
webContextGetPluginsFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ webkit_web_context_get_plugins_finish _obj' result_'
        result' <- unpackGList result
        result'' <- mapM (wrapObject Plugin) result'
        g_list_free result
        touchManagedPtr _obj
        touchManagedPtr result_
        return result''
     ) (do
        return ()
     )

data WebContextGetPluginsFinishMethodInfo
instance (signature ~ (b -> m [Plugin]), MonadIO m, WebContextK a, Gio.AsyncResultK b) => MethodInfo WebContextGetPluginsFinishMethodInfo a signature where
    overloadedMethod _ = webContextGetPluginsFinish

-- method WebContext::get_process_model
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ProcessModel")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_process_model" webkit_web_context_get_process_model :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO CUInt


webContextGetProcessModel ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m ProcessModel                       -- result
webContextGetProcessModel _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_process_model _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data WebContextGetProcessModelMethodInfo
instance (signature ~ (m ProcessModel), MonadIO m, WebContextK a) => MethodInfo WebContextGetProcessModelMethodInfo a signature where
    overloadedMethod _ = webContextGetProcessModel

-- method WebContext::get_security_manager
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "SecurityManager")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_security_manager" webkit_web_context_get_security_manager :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO (Ptr SecurityManager)


webContextGetSecurityManager ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m SecurityManager                    -- result
webContextGetSecurityManager _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_security_manager _obj'
    checkUnexpectedReturnNULL "webkit_web_context_get_security_manager" result
    result' <- (newObject SecurityManager) result
    touchManagedPtr _obj
    return result'

data WebContextGetSecurityManagerMethodInfo
instance (signature ~ (m SecurityManager), MonadIO m, WebContextK a) => MethodInfo WebContextGetSecurityManagerMethodInfo a signature where
    overloadedMethod _ = webContextGetSecurityManager

-- method WebContext::get_spell_checking_enabled
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_spell_checking_enabled" webkit_web_context_get_spell_checking_enabled :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO CInt


webContextGetSpellCheckingEnabled ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
webContextGetSpellCheckingEnabled _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_spell_checking_enabled _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WebContextGetSpellCheckingEnabledMethodInfo
instance (signature ~ (m Bool), MonadIO m, WebContextK a) => MethodInfo WebContextGetSpellCheckingEnabledMethodInfo a signature where
    overloadedMethod _ = webContextGetSpellCheckingEnabled

-- method WebContext::get_spell_checking_languages
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_spell_checking_languages" webkit_web_context_get_spell_checking_languages :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO (Ptr CString)


webContextGetSpellCheckingLanguages ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m [T.Text]                           -- result
webContextGetSpellCheckingLanguages _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_spell_checking_languages _obj'
    checkUnexpectedReturnNULL "webkit_web_context_get_spell_checking_languages" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr _obj
    return result'

data WebContextGetSpellCheckingLanguagesMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, WebContextK a) => MethodInfo WebContextGetSpellCheckingLanguagesMethodInfo a signature where
    overloadedMethod _ = webContextGetSpellCheckingLanguages

-- method WebContext::get_tls_errors_policy
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "TLSErrorsPolicy")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_tls_errors_policy" webkit_web_context_get_tls_errors_policy :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO CUInt


webContextGetTlsErrorsPolicy ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m TLSErrorsPolicy                    -- result
webContextGetTlsErrorsPolicy _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_tls_errors_policy _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data WebContextGetTlsErrorsPolicyMethodInfo
instance (signature ~ (m TLSErrorsPolicy), MonadIO m, WebContextK a) => MethodInfo WebContextGetTlsErrorsPolicyMethodInfo a signature where
    overloadedMethod _ = webContextGetTlsErrorsPolicy

-- method WebContext::get_web_process_count_limit
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_web_process_count_limit" webkit_web_context_get_web_process_count_limit :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO Word32


webContextGetWebProcessCountLimit ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
webContextGetWebProcessCountLimit _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_web_process_count_limit _obj'
    touchManagedPtr _obj
    return result

data WebContextGetWebProcessCountLimitMethodInfo
instance (signature ~ (m Word32), MonadIO m, WebContextK a) => MethodInfo WebContextGetWebProcessCountLimitMethodInfo a signature where
    overloadedMethod _ = webContextGetWebProcessCountLimit

-- method WebContext::get_website_data_manager
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebsiteDataManager")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_website_data_manager" webkit_web_context_get_website_data_manager :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    IO (Ptr WebsiteDataManager)


webContextGetWebsiteDataManager ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> m WebsiteDataManager                 -- result
webContextGetWebsiteDataManager _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_context_get_website_data_manager _obj'
    checkUnexpectedReturnNULL "webkit_web_context_get_website_data_manager" result
    result' <- (newObject WebsiteDataManager) result
    touchManagedPtr _obj
    return result'

data WebContextGetWebsiteDataManagerMethodInfo
instance (signature ~ (m WebsiteDataManager), MonadIO m, WebContextK a) => MethodInfo WebContextGetWebsiteDataManagerMethodInfo a signature where
    overloadedMethod _ = webContextGetWebsiteDataManager

-- method WebContext::prefetch_dns
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "hostname", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_prefetch_dns" webkit_web_context_prefetch_dns :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CString ->                              -- hostname : TBasicType TUTF8
    IO ()


webContextPrefetchDns ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> T.Text                               -- hostname
    -> m ()                                 -- result
webContextPrefetchDns _obj hostname = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    hostname' <- textToCString hostname
    webkit_web_context_prefetch_dns _obj' hostname'
    touchManagedPtr _obj
    freeMem hostname'
    return ()

data WebContextPrefetchDnsMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextPrefetchDnsMethodInfo a signature where
    overloadedMethod _ = webContextPrefetchDns

-- method WebContext::register_uri_scheme
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "WebKit2" "URISchemeRequestCallback", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeNotified, argClosure = 3, argDestroy = 4, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data_destroy_func", argType = TInterface "GLib" "DestroyNotify", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_register_uri_scheme" webkit_web_context_register_uri_scheme :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CString ->                              -- scheme : TBasicType TUTF8
    FunPtr URISchemeRequestCallbackC ->     -- callback : TInterface "WebKit2" "URISchemeRequestCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.DestroyNotifyC ->           -- user_data_destroy_func : TInterface "GLib" "DestroyNotify"
    IO ()


webContextRegisterUriScheme ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> URISchemeRequestCallback             -- callback
    -> m ()                                 -- result
webContextRegisterUriScheme _obj scheme callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    callback' <- mkURISchemeRequestCallback (uRISchemeRequestCallbackWrapper Nothing callback)
    let userData = castFunPtrToPtr callback'
    let userDataDestroyFunc = safeFreeFunPtrPtr
    webkit_web_context_register_uri_scheme _obj' scheme' callback' userData userDataDestroyFunc
    touchManagedPtr _obj
    freeMem scheme'
    return ()

data WebContextRegisterUriSchemeMethodInfo
instance (signature ~ (T.Text -> URISchemeRequestCallback -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextRegisterUriSchemeMethodInfo a signature where
    overloadedMethod _ = webContextRegisterUriScheme

-- method WebContext::set_additional_plugins_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "directory", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_additional_plugins_directory" webkit_web_context_set_additional_plugins_directory :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CString ->                              -- directory : TBasicType TUTF8
    IO ()


webContextSetAdditionalPluginsDirectory ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> T.Text                               -- directory
    -> m ()                                 -- result
webContextSetAdditionalPluginsDirectory _obj directory = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    directory' <- textToCString directory
    webkit_web_context_set_additional_plugins_directory _obj' directory'
    touchManagedPtr _obj
    freeMem directory'
    return ()

data WebContextSetAdditionalPluginsDirectoryMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetAdditionalPluginsDirectoryMethodInfo a signature where
    overloadedMethod _ = webContextSetAdditionalPluginsDirectory

-- method WebContext::set_cache_model
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cache_model", argType = TInterface "WebKit2" "CacheModel", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_cache_model" webkit_web_context_set_cache_model :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CUInt ->                                -- cache_model : TInterface "WebKit2" "CacheModel"
    IO ()


webContextSetCacheModel ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> CacheModel                           -- cacheModel
    -> m ()                                 -- result
webContextSetCacheModel _obj cacheModel = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let cacheModel' = (fromIntegral . fromEnum) cacheModel
    webkit_web_context_set_cache_model _obj' cacheModel'
    touchManagedPtr _obj
    return ()

data WebContextSetCacheModelMethodInfo
instance (signature ~ (CacheModel -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetCacheModelMethodInfo a signature where
    overloadedMethod _ = webContextSetCacheModel

-- method WebContext::set_disk_cache_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "directory", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_disk_cache_directory" webkit_web_context_set_disk_cache_directory :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CString ->                              -- directory : TBasicType TUTF8
    IO ()

{-# DEPRECATED webContextSetDiskCacheDirectory ["(Since version 2.10.)","Use webkit_web_context_new_with_website_data_manager() instead."]#-}
webContextSetDiskCacheDirectory ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> T.Text                               -- directory
    -> m ()                                 -- result
webContextSetDiskCacheDirectory _obj directory = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    directory' <- textToCString directory
    webkit_web_context_set_disk_cache_directory _obj' directory'
    touchManagedPtr _obj
    freeMem directory'
    return ()

data WebContextSetDiskCacheDirectoryMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetDiskCacheDirectoryMethodInfo a signature where
    overloadedMethod _ = webContextSetDiskCacheDirectory

-- method WebContext::set_favicon_database_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "path", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_favicon_database_directory" webkit_web_context_set_favicon_database_directory :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CString ->                              -- path : TBasicType TUTF8
    IO ()


webContextSetFaviconDatabaseDirectory ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> Maybe (T.Text)                       -- path
    -> m ()                                 -- result
webContextSetFaviconDatabaseDirectory _obj path = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybePath <- case path of
        Nothing -> return nullPtr
        Just jPath -> do
            jPath' <- textToCString jPath
            return jPath'
    webkit_web_context_set_favicon_database_directory _obj' maybePath
    touchManagedPtr _obj
    freeMem maybePath
    return ()

data WebContextSetFaviconDatabaseDirectoryMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetFaviconDatabaseDirectoryMethodInfo a signature where
    overloadedMethod _ = webContextSetFaviconDatabaseDirectory

-- method WebContext::set_preferred_languages
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "languages", argType = TCArray True (-1) (-1) (TBasicType TUTF8), direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_preferred_languages" webkit_web_context_set_preferred_languages :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    Ptr CString ->                          -- languages : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()


webContextSetPreferredLanguages ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> Maybe ([T.Text])                     -- languages
    -> m ()                                 -- result
webContextSetPreferredLanguages _obj languages = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeLanguages <- case languages of
        Nothing -> return nullPtr
        Just jLanguages -> do
            jLanguages' <- packZeroTerminatedUTF8CArray jLanguages
            return jLanguages'
    webkit_web_context_set_preferred_languages _obj' maybeLanguages
    touchManagedPtr _obj
    mapZeroTerminatedCArray freeMem maybeLanguages
    freeMem maybeLanguages
    return ()

data WebContextSetPreferredLanguagesMethodInfo
instance (signature ~ (Maybe ([T.Text]) -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetPreferredLanguagesMethodInfo a signature where
    overloadedMethod _ = webContextSetPreferredLanguages

-- method WebContext::set_process_model
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "process_model", argType = TInterface "WebKit2" "ProcessModel", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_process_model" webkit_web_context_set_process_model :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CUInt ->                                -- process_model : TInterface "WebKit2" "ProcessModel"
    IO ()


webContextSetProcessModel ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> ProcessModel                         -- processModel
    -> m ()                                 -- result
webContextSetProcessModel _obj processModel = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let processModel' = (fromIntegral . fromEnum) processModel
    webkit_web_context_set_process_model _obj' processModel'
    touchManagedPtr _obj
    return ()

data WebContextSetProcessModelMethodInfo
instance (signature ~ (ProcessModel -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetProcessModelMethodInfo a signature where
    overloadedMethod _ = webContextSetProcessModel

-- method WebContext::set_spell_checking_enabled
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "enabled", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_spell_checking_enabled" webkit_web_context_set_spell_checking_enabled :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()


webContextSetSpellCheckingEnabled ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> Bool                                 -- enabled
    -> m ()                                 -- result
webContextSetSpellCheckingEnabled _obj enabled = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let enabled' = (fromIntegral . fromEnum) enabled
    webkit_web_context_set_spell_checking_enabled _obj' enabled'
    touchManagedPtr _obj
    return ()

data WebContextSetSpellCheckingEnabledMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetSpellCheckingEnabledMethodInfo a signature where
    overloadedMethod _ = webContextSetSpellCheckingEnabled

-- method WebContext::set_spell_checking_languages
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "languages", argType = TCArray True (-1) (-1) (TBasicType TUTF8), direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_spell_checking_languages" webkit_web_context_set_spell_checking_languages :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    Ptr CString ->                          -- languages : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()


webContextSetSpellCheckingLanguages ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> [T.Text]                             -- languages
    -> m ()                                 -- result
webContextSetSpellCheckingLanguages _obj languages = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    languages' <- packZeroTerminatedUTF8CArray languages
    webkit_web_context_set_spell_checking_languages _obj' languages'
    touchManagedPtr _obj
    mapZeroTerminatedCArray freeMem languages'
    freeMem languages'
    return ()

data WebContextSetSpellCheckingLanguagesMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetSpellCheckingLanguagesMethodInfo a signature where
    overloadedMethod _ = webContextSetSpellCheckingLanguages

-- method WebContext::set_tls_errors_policy
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "policy", argType = TInterface "WebKit2" "TLSErrorsPolicy", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_tls_errors_policy" webkit_web_context_set_tls_errors_policy :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CUInt ->                                -- policy : TInterface "WebKit2" "TLSErrorsPolicy"
    IO ()


webContextSetTlsErrorsPolicy ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> TLSErrorsPolicy                      -- policy
    -> m ()                                 -- result
webContextSetTlsErrorsPolicy _obj policy = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let policy' = (fromIntegral . fromEnum) policy
    webkit_web_context_set_tls_errors_policy _obj' policy'
    touchManagedPtr _obj
    return ()

data WebContextSetTlsErrorsPolicyMethodInfo
instance (signature ~ (TLSErrorsPolicy -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetTlsErrorsPolicyMethodInfo a signature where
    overloadedMethod _ = webContextSetTlsErrorsPolicy

-- method WebContext::set_web_extensions_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "directory", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_web_extensions_directory" webkit_web_context_set_web_extensions_directory :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    CString ->                              -- directory : TBasicType TUTF8
    IO ()


webContextSetWebExtensionsDirectory ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> T.Text                               -- directory
    -> m ()                                 -- result
webContextSetWebExtensionsDirectory _obj directory = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    directory' <- textToCString directory
    webkit_web_context_set_web_extensions_directory _obj' directory'
    touchManagedPtr _obj
    freeMem directory'
    return ()

data WebContextSetWebExtensionsDirectoryMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetWebExtensionsDirectoryMethodInfo a signature where
    overloadedMethod _ = webContextSetWebExtensionsDirectory

-- method WebContext::set_web_extensions_initialization_user_data
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TVariant, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_web_extensions_initialization_user_data" webkit_web_context_set_web_extensions_initialization_user_data :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    Ptr GVariant ->                         -- user_data : TVariant
    IO ()


webContextSetWebExtensionsInitializationUserData ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> GVariant                             -- userData
    -> m ()                                 -- result
webContextSetWebExtensionsInitializationUserData _obj userData = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let userData' = unsafeManagedPtrGetPtr userData
    webkit_web_context_set_web_extensions_initialization_user_data _obj' userData'
    touchManagedPtr _obj
    return ()

data WebContextSetWebExtensionsInitializationUserDataMethodInfo
instance (signature ~ (GVariant -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetWebExtensionsInitializationUserDataMethodInfo a signature where
    overloadedMethod _ = webContextSetWebExtensionsInitializationUserData

-- method WebContext::set_web_process_count_limit
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "limit", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_set_web_process_count_limit" webkit_web_context_set_web_process_count_limit :: 
    Ptr WebContext ->                       -- _obj : TInterface "WebKit2" "WebContext"
    Word32 ->                               -- limit : TBasicType TUInt
    IO ()


webContextSetWebProcessCountLimit ::
    (MonadIO m, WebContextK a) =>
    a                                       -- _obj
    -> Word32                               -- limit
    -> m ()                                 -- result
webContextSetWebProcessCountLimit _obj limit = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_context_set_web_process_count_limit _obj' limit
    touchManagedPtr _obj
    return ()

data WebContextSetWebProcessCountLimitMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, WebContextK a) => MethodInfo WebContextSetWebProcessCountLimitMethodInfo a signature where
    overloadedMethod _ = webContextSetWebProcessCountLimit

-- method WebContext::get_default
-- method type : MemberFunction
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebContext")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_context_get_default" webkit_web_context_get_default :: 
    IO (Ptr WebContext)


webContextGetDefault ::
    (MonadIO m) =>
    m WebContext                            -- result
webContextGetDefault  = liftIO $ do
    result <- webkit_web_context_get_default
    checkUnexpectedReturnNULL "webkit_web_context_get_default" result
    result' <- (newObject WebContext) result
    return result'


