

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.WebInspector
    ( 

-- * Exported types
    WebInspector(..)                        ,
    WebInspectorK                           ,
    toWebInspector                          ,
    noWebInspector                          ,


 -- * Methods
-- ** webInspectorAttach
    WebInspectorAttachMethodInfo            ,
    webInspectorAttach                      ,


-- ** webInspectorClose
    WebInspectorCloseMethodInfo             ,
    webInspectorClose                       ,


-- ** webInspectorDetach
    WebInspectorDetachMethodInfo            ,
    webInspectorDetach                      ,


-- ** webInspectorGetAttachedHeight
    WebInspectorGetAttachedHeightMethodInfo ,
    webInspectorGetAttachedHeight           ,


-- ** webInspectorGetCanAttach
    WebInspectorGetCanAttachMethodInfo      ,
    webInspectorGetCanAttach                ,


-- ** webInspectorGetInspectedUri
    WebInspectorGetInspectedUriMethodInfo   ,
    webInspectorGetInspectedUri             ,


-- ** webInspectorGetWebView
    WebInspectorGetWebViewMethodInfo        ,
    webInspectorGetWebView                  ,


-- ** webInspectorIsAttached
    WebInspectorIsAttachedMethodInfo        ,
    webInspectorIsAttached                  ,


-- ** webInspectorShow
    WebInspectorShowMethodInfo              ,
    webInspectorShow                        ,




 -- * Properties
-- ** AttachedHeight
    WebInspectorAttachedHeightPropertyInfo  ,
    getWebInspectorAttachedHeight           ,
    webInspectorAttachedHeight              ,


-- ** CanAttach
    WebInspectorCanAttachPropertyInfo       ,
    getWebInspectorCanAttach                ,
    webInspectorCanAttach                   ,


-- ** InspectedUri
    WebInspectorInspectedUriPropertyInfo    ,
    getWebInspectorInspectedUri             ,
    webInspectorInspectedUri                ,




 -- * Signals
-- ** Attach
    WebInspectorAttachCallback              ,
    WebInspectorAttachCallbackC             ,
    WebInspectorAttachSignalInfo            ,
    afterWebInspectorAttach                 ,
    mkWebInspectorAttachCallback            ,
    noWebInspectorAttachCallback            ,
    onWebInspectorAttach                    ,
    webInspectorAttachCallbackWrapper       ,
    webInspectorAttachClosure               ,


-- ** BringToFront
    WebInspectorBringToFrontCallback        ,
    WebInspectorBringToFrontCallbackC       ,
    WebInspectorBringToFrontSignalInfo      ,
    afterWebInspectorBringToFront           ,
    mkWebInspectorBringToFrontCallback      ,
    noWebInspectorBringToFrontCallback      ,
    onWebInspectorBringToFront              ,
    webInspectorBringToFrontCallbackWrapper ,
    webInspectorBringToFrontClosure         ,


-- ** Closed
    WebInspectorClosedCallback              ,
    WebInspectorClosedCallbackC             ,
    WebInspectorClosedSignalInfo            ,
    afterWebInspectorClosed                 ,
    mkWebInspectorClosedCallback            ,
    noWebInspectorClosedCallback            ,
    onWebInspectorClosed                    ,
    webInspectorClosedCallbackWrapper       ,
    webInspectorClosedClosure               ,


-- ** Detach
    WebInspectorDetachCallback              ,
    WebInspectorDetachCallbackC             ,
    WebInspectorDetachSignalInfo            ,
    afterWebInspectorDetach                 ,
    mkWebInspectorDetachCallback            ,
    noWebInspectorDetachCallback            ,
    onWebInspectorDetach                    ,
    webInspectorDetachCallbackWrapper       ,
    webInspectorDetachClosure               ,


-- ** OpenWindow
    WebInspectorOpenWindowCallback          ,
    WebInspectorOpenWindowCallbackC         ,
    WebInspectorOpenWindowSignalInfo        ,
    afterWebInspectorOpenWindow             ,
    mkWebInspectorOpenWindowCallback        ,
    noWebInspectorOpenWindowCallback        ,
    onWebInspectorOpenWindow                ,
    webInspectorOpenWindowCallbackWrapper   ,
    webInspectorOpenWindowClosure           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype WebInspector = WebInspector (ForeignPtr WebInspector)
foreign import ccall "webkit_web_inspector_get_type"
    c_webkit_web_inspector_get_type :: IO GType

type instance ParentTypes WebInspector = WebInspectorParentTypes
type WebInspectorParentTypes = '[GObject.Object]

instance GObject WebInspector where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_web_inspector_get_type
    

class GObject o => WebInspectorK o
instance (GObject o, IsDescendantOf WebInspector o) => WebInspectorK o

toWebInspector :: WebInspectorK o => o -> IO WebInspector
toWebInspector = unsafeCastTo WebInspector

noWebInspector :: Maybe WebInspector
noWebInspector = Nothing

type family ResolveWebInspectorMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebInspectorMethod "attach" o = WebInspectorAttachMethodInfo
    ResolveWebInspectorMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebInspectorMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebInspectorMethod "close" o = WebInspectorCloseMethodInfo
    ResolveWebInspectorMethod "detach" o = WebInspectorDetachMethodInfo
    ResolveWebInspectorMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebInspectorMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebInspectorMethod "isAttached" o = WebInspectorIsAttachedMethodInfo
    ResolveWebInspectorMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebInspectorMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebInspectorMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebInspectorMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebInspectorMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebInspectorMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebInspectorMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebInspectorMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebInspectorMethod "show" o = WebInspectorShowMethodInfo
    ResolveWebInspectorMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebInspectorMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebInspectorMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebInspectorMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebInspectorMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebInspectorMethod "getAttachedHeight" o = WebInspectorGetAttachedHeightMethodInfo
    ResolveWebInspectorMethod "getCanAttach" o = WebInspectorGetCanAttachMethodInfo
    ResolveWebInspectorMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebInspectorMethod "getInspectedUri" o = WebInspectorGetInspectedUriMethodInfo
    ResolveWebInspectorMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebInspectorMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebInspectorMethod "getWebView" o = WebInspectorGetWebViewMethodInfo
    ResolveWebInspectorMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebInspectorMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebInspectorMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebInspectorMethod t WebInspector, MethodInfo info WebInspector p) => IsLabelProxy t (WebInspector -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebInspectorMethod t WebInspector, MethodInfo info WebInspector p) => IsLabel t (WebInspector -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal WebInspector::attach
type WebInspectorAttachCallback =
    IO Bool

noWebInspectorAttachCallback :: Maybe WebInspectorAttachCallback
noWebInspectorAttachCallback = Nothing

type WebInspectorAttachCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebInspectorAttachCallback :: WebInspectorAttachCallbackC -> IO (FunPtr WebInspectorAttachCallbackC)

webInspectorAttachClosure :: WebInspectorAttachCallback -> IO Closure
webInspectorAttachClosure cb = newCClosure =<< mkWebInspectorAttachCallback wrapped
    where wrapped = webInspectorAttachCallbackWrapper cb

webInspectorAttachCallbackWrapper ::
    WebInspectorAttachCallback ->
    Ptr () ->
    Ptr () ->
    IO CInt
webInspectorAttachCallbackWrapper _cb _ _ = do
    result <- _cb 
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebInspectorAttach :: (GObject a, MonadIO m) => a -> WebInspectorAttachCallback -> m SignalHandlerId
onWebInspectorAttach obj cb = liftIO $ connectWebInspectorAttach obj cb SignalConnectBefore
afterWebInspectorAttach :: (GObject a, MonadIO m) => a -> WebInspectorAttachCallback -> m SignalHandlerId
afterWebInspectorAttach obj cb = connectWebInspectorAttach obj cb SignalConnectAfter

connectWebInspectorAttach :: (GObject a, MonadIO m) =>
                             a -> WebInspectorAttachCallback -> SignalConnectMode -> m SignalHandlerId
connectWebInspectorAttach obj cb after = liftIO $ do
    cb' <- mkWebInspectorAttachCallback (webInspectorAttachCallbackWrapper cb)
    connectSignalFunPtr obj "attach" cb' after

-- signal WebInspector::bring-to-front
type WebInspectorBringToFrontCallback =
    IO Bool

noWebInspectorBringToFrontCallback :: Maybe WebInspectorBringToFrontCallback
noWebInspectorBringToFrontCallback = Nothing

type WebInspectorBringToFrontCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebInspectorBringToFrontCallback :: WebInspectorBringToFrontCallbackC -> IO (FunPtr WebInspectorBringToFrontCallbackC)

webInspectorBringToFrontClosure :: WebInspectorBringToFrontCallback -> IO Closure
webInspectorBringToFrontClosure cb = newCClosure =<< mkWebInspectorBringToFrontCallback wrapped
    where wrapped = webInspectorBringToFrontCallbackWrapper cb

webInspectorBringToFrontCallbackWrapper ::
    WebInspectorBringToFrontCallback ->
    Ptr () ->
    Ptr () ->
    IO CInt
webInspectorBringToFrontCallbackWrapper _cb _ _ = do
    result <- _cb 
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebInspectorBringToFront :: (GObject a, MonadIO m) => a -> WebInspectorBringToFrontCallback -> m SignalHandlerId
onWebInspectorBringToFront obj cb = liftIO $ connectWebInspectorBringToFront obj cb SignalConnectBefore
afterWebInspectorBringToFront :: (GObject a, MonadIO m) => a -> WebInspectorBringToFrontCallback -> m SignalHandlerId
afterWebInspectorBringToFront obj cb = connectWebInspectorBringToFront obj cb SignalConnectAfter

connectWebInspectorBringToFront :: (GObject a, MonadIO m) =>
                                   a -> WebInspectorBringToFrontCallback -> SignalConnectMode -> m SignalHandlerId
connectWebInspectorBringToFront obj cb after = liftIO $ do
    cb' <- mkWebInspectorBringToFrontCallback (webInspectorBringToFrontCallbackWrapper cb)
    connectSignalFunPtr obj "bring-to-front" cb' after

-- signal WebInspector::closed
type WebInspectorClosedCallback =
    IO ()

noWebInspectorClosedCallback :: Maybe WebInspectorClosedCallback
noWebInspectorClosedCallback = Nothing

type WebInspectorClosedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebInspectorClosedCallback :: WebInspectorClosedCallbackC -> IO (FunPtr WebInspectorClosedCallbackC)

webInspectorClosedClosure :: WebInspectorClosedCallback -> IO Closure
webInspectorClosedClosure cb = newCClosure =<< mkWebInspectorClosedCallback wrapped
    where wrapped = webInspectorClosedCallbackWrapper cb

webInspectorClosedCallbackWrapper ::
    WebInspectorClosedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webInspectorClosedCallbackWrapper _cb _ _ = do
    _cb 

onWebInspectorClosed :: (GObject a, MonadIO m) => a -> WebInspectorClosedCallback -> m SignalHandlerId
onWebInspectorClosed obj cb = liftIO $ connectWebInspectorClosed obj cb SignalConnectBefore
afterWebInspectorClosed :: (GObject a, MonadIO m) => a -> WebInspectorClosedCallback -> m SignalHandlerId
afterWebInspectorClosed obj cb = connectWebInspectorClosed obj cb SignalConnectAfter

connectWebInspectorClosed :: (GObject a, MonadIO m) =>
                             a -> WebInspectorClosedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebInspectorClosed obj cb after = liftIO $ do
    cb' <- mkWebInspectorClosedCallback (webInspectorClosedCallbackWrapper cb)
    connectSignalFunPtr obj "closed" cb' after

-- signal WebInspector::detach
type WebInspectorDetachCallback =
    IO Bool

noWebInspectorDetachCallback :: Maybe WebInspectorDetachCallback
noWebInspectorDetachCallback = Nothing

type WebInspectorDetachCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebInspectorDetachCallback :: WebInspectorDetachCallbackC -> IO (FunPtr WebInspectorDetachCallbackC)

webInspectorDetachClosure :: WebInspectorDetachCallback -> IO Closure
webInspectorDetachClosure cb = newCClosure =<< mkWebInspectorDetachCallback wrapped
    where wrapped = webInspectorDetachCallbackWrapper cb

webInspectorDetachCallbackWrapper ::
    WebInspectorDetachCallback ->
    Ptr () ->
    Ptr () ->
    IO CInt
webInspectorDetachCallbackWrapper _cb _ _ = do
    result <- _cb 
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebInspectorDetach :: (GObject a, MonadIO m) => a -> WebInspectorDetachCallback -> m SignalHandlerId
onWebInspectorDetach obj cb = liftIO $ connectWebInspectorDetach obj cb SignalConnectBefore
afterWebInspectorDetach :: (GObject a, MonadIO m) => a -> WebInspectorDetachCallback -> m SignalHandlerId
afterWebInspectorDetach obj cb = connectWebInspectorDetach obj cb SignalConnectAfter

connectWebInspectorDetach :: (GObject a, MonadIO m) =>
                             a -> WebInspectorDetachCallback -> SignalConnectMode -> m SignalHandlerId
connectWebInspectorDetach obj cb after = liftIO $ do
    cb' <- mkWebInspectorDetachCallback (webInspectorDetachCallbackWrapper cb)
    connectSignalFunPtr obj "detach" cb' after

-- signal WebInspector::open-window
type WebInspectorOpenWindowCallback =
    IO Bool

noWebInspectorOpenWindowCallback :: Maybe WebInspectorOpenWindowCallback
noWebInspectorOpenWindowCallback = Nothing

type WebInspectorOpenWindowCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebInspectorOpenWindowCallback :: WebInspectorOpenWindowCallbackC -> IO (FunPtr WebInspectorOpenWindowCallbackC)

webInspectorOpenWindowClosure :: WebInspectorOpenWindowCallback -> IO Closure
webInspectorOpenWindowClosure cb = newCClosure =<< mkWebInspectorOpenWindowCallback wrapped
    where wrapped = webInspectorOpenWindowCallbackWrapper cb

webInspectorOpenWindowCallbackWrapper ::
    WebInspectorOpenWindowCallback ->
    Ptr () ->
    Ptr () ->
    IO CInt
webInspectorOpenWindowCallbackWrapper _cb _ _ = do
    result <- _cb 
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebInspectorOpenWindow :: (GObject a, MonadIO m) => a -> WebInspectorOpenWindowCallback -> m SignalHandlerId
onWebInspectorOpenWindow obj cb = liftIO $ connectWebInspectorOpenWindow obj cb SignalConnectBefore
afterWebInspectorOpenWindow :: (GObject a, MonadIO m) => a -> WebInspectorOpenWindowCallback -> m SignalHandlerId
afterWebInspectorOpenWindow obj cb = connectWebInspectorOpenWindow obj cb SignalConnectAfter

connectWebInspectorOpenWindow :: (GObject a, MonadIO m) =>
                                 a -> WebInspectorOpenWindowCallback -> SignalConnectMode -> m SignalHandlerId
connectWebInspectorOpenWindow obj cb after = liftIO $ do
    cb' <- mkWebInspectorOpenWindowCallback (webInspectorOpenWindowCallbackWrapper cb)
    connectSignalFunPtr obj "open-window" cb' after

-- VVV Prop "attached-height"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getWebInspectorAttachedHeight :: (MonadIO m, WebInspectorK o) => o -> m Word32
getWebInspectorAttachedHeight obj = liftIO $ getObjectPropertyUInt32 obj "attached-height"

data WebInspectorAttachedHeightPropertyInfo
instance AttrInfo WebInspectorAttachedHeightPropertyInfo where
    type AttrAllowedOps WebInspectorAttachedHeightPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint WebInspectorAttachedHeightPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebInspectorAttachedHeightPropertyInfo = WebInspectorK
    type AttrGetType WebInspectorAttachedHeightPropertyInfo = Word32
    type AttrLabel WebInspectorAttachedHeightPropertyInfo = "attached-height"
    attrGet _ = getWebInspectorAttachedHeight
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "can-attach"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getWebInspectorCanAttach :: (MonadIO m, WebInspectorK o) => o -> m Bool
getWebInspectorCanAttach obj = liftIO $ getObjectPropertyBool obj "can-attach"

data WebInspectorCanAttachPropertyInfo
instance AttrInfo WebInspectorCanAttachPropertyInfo where
    type AttrAllowedOps WebInspectorCanAttachPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint WebInspectorCanAttachPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebInspectorCanAttachPropertyInfo = WebInspectorK
    type AttrGetType WebInspectorCanAttachPropertyInfo = Bool
    type AttrLabel WebInspectorCanAttachPropertyInfo = "can-attach"
    attrGet _ = getWebInspectorCanAttach
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "inspected-uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getWebInspectorInspectedUri :: (MonadIO m, WebInspectorK o) => o -> m T.Text
getWebInspectorInspectedUri obj = liftIO $ checkUnexpectedNothing "getWebInspectorInspectedUri" $ getObjectPropertyString obj "inspected-uri"

data WebInspectorInspectedUriPropertyInfo
instance AttrInfo WebInspectorInspectedUriPropertyInfo where
    type AttrAllowedOps WebInspectorInspectedUriPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebInspectorInspectedUriPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebInspectorInspectedUriPropertyInfo = WebInspectorK
    type AttrGetType WebInspectorInspectedUriPropertyInfo = T.Text
    type AttrLabel WebInspectorInspectedUriPropertyInfo = "inspected-uri"
    attrGet _ = getWebInspectorInspectedUri
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList WebInspector = WebInspectorAttributeList
type WebInspectorAttributeList = ('[ '("attachedHeight", WebInspectorAttachedHeightPropertyInfo), '("canAttach", WebInspectorCanAttachPropertyInfo), '("inspectedUri", WebInspectorInspectedUriPropertyInfo)] :: [(Symbol, *)])

webInspectorAttachedHeight :: AttrLabelProxy "attachedHeight"
webInspectorAttachedHeight = AttrLabelProxy

webInspectorCanAttach :: AttrLabelProxy "canAttach"
webInspectorCanAttach = AttrLabelProxy

webInspectorInspectedUri :: AttrLabelProxy "inspectedUri"
webInspectorInspectedUri = AttrLabelProxy

data WebInspectorAttachSignalInfo
instance SignalInfo WebInspectorAttachSignalInfo where
    type HaskellCallbackType WebInspectorAttachSignalInfo = WebInspectorAttachCallback
    connectSignal _ = connectWebInspectorAttach

data WebInspectorBringToFrontSignalInfo
instance SignalInfo WebInspectorBringToFrontSignalInfo where
    type HaskellCallbackType WebInspectorBringToFrontSignalInfo = WebInspectorBringToFrontCallback
    connectSignal _ = connectWebInspectorBringToFront

data WebInspectorClosedSignalInfo
instance SignalInfo WebInspectorClosedSignalInfo where
    type HaskellCallbackType WebInspectorClosedSignalInfo = WebInspectorClosedCallback
    connectSignal _ = connectWebInspectorClosed

data WebInspectorDetachSignalInfo
instance SignalInfo WebInspectorDetachSignalInfo where
    type HaskellCallbackType WebInspectorDetachSignalInfo = WebInspectorDetachCallback
    connectSignal _ = connectWebInspectorDetach

data WebInspectorOpenWindowSignalInfo
instance SignalInfo WebInspectorOpenWindowSignalInfo where
    type HaskellCallbackType WebInspectorOpenWindowSignalInfo = WebInspectorOpenWindowCallback
    connectSignal _ = connectWebInspectorOpenWindow

type instance SignalList WebInspector = WebInspectorSignalList
type WebInspectorSignalList = ('[ '("attach", WebInspectorAttachSignalInfo), '("bringToFront", WebInspectorBringToFrontSignalInfo), '("closed", WebInspectorClosedSignalInfo), '("detach", WebInspectorDetachSignalInfo), '("notify", GObject.ObjectNotifySignalInfo), '("openWindow", WebInspectorOpenWindowSignalInfo)] :: [(Symbol, *)])

-- method WebInspector::attach
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_attach" webkit_web_inspector_attach :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO ()


webInspectorAttach ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webInspectorAttach _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_inspector_attach _obj'
    touchManagedPtr _obj
    return ()

data WebInspectorAttachMethodInfo
instance (signature ~ (m ()), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorAttachMethodInfo a signature where
    overloadedMethod _ = webInspectorAttach

-- method WebInspector::close
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_close" webkit_web_inspector_close :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO ()


webInspectorClose ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webInspectorClose _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_inspector_close _obj'
    touchManagedPtr _obj
    return ()

data WebInspectorCloseMethodInfo
instance (signature ~ (m ()), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorCloseMethodInfo a signature where
    overloadedMethod _ = webInspectorClose

-- method WebInspector::detach
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_detach" webkit_web_inspector_detach :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO ()


webInspectorDetach ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webInspectorDetach _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_inspector_detach _obj'
    touchManagedPtr _obj
    return ()

data WebInspectorDetachMethodInfo
instance (signature ~ (m ()), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorDetachMethodInfo a signature where
    overloadedMethod _ = webInspectorDetach

-- method WebInspector::get_attached_height
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_get_attached_height" webkit_web_inspector_get_attached_height :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO Word32


webInspectorGetAttachedHeight ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
webInspectorGetAttachedHeight _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_inspector_get_attached_height _obj'
    touchManagedPtr _obj
    return result

data WebInspectorGetAttachedHeightMethodInfo
instance (signature ~ (m Word32), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorGetAttachedHeightMethodInfo a signature where
    overloadedMethod _ = webInspectorGetAttachedHeight

-- method WebInspector::get_can_attach
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_get_can_attach" webkit_web_inspector_get_can_attach :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO CInt


webInspectorGetCanAttach ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
webInspectorGetCanAttach _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_inspector_get_can_attach _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WebInspectorGetCanAttachMethodInfo
instance (signature ~ (m Bool), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorGetCanAttachMethodInfo a signature where
    overloadedMethod _ = webInspectorGetCanAttach

-- method WebInspector::get_inspected_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_get_inspected_uri" webkit_web_inspector_get_inspected_uri :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO CString


webInspectorGetInspectedUri ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
webInspectorGetInspectedUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_inspector_get_inspected_uri _obj'
    checkUnexpectedReturnNULL "webkit_web_inspector_get_inspected_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebInspectorGetInspectedUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorGetInspectedUriMethodInfo a signature where
    overloadedMethod _ = webInspectorGetInspectedUri

-- method WebInspector::get_web_view
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebViewBase")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_get_web_view" webkit_web_inspector_get_web_view :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO (Ptr WebViewBase)


webInspectorGetWebView ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m WebViewBase                        -- result
webInspectorGetWebView _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_inspector_get_web_view _obj'
    checkUnexpectedReturnNULL "webkit_web_inspector_get_web_view" result
    result' <- (newObject WebViewBase) result
    touchManagedPtr _obj
    return result'

data WebInspectorGetWebViewMethodInfo
instance (signature ~ (m WebViewBase), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorGetWebViewMethodInfo a signature where
    overloadedMethod _ = webInspectorGetWebView

-- method WebInspector::is_attached
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_is_attached" webkit_web_inspector_is_attached :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO CInt


webInspectorIsAttached ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
webInspectorIsAttached _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_inspector_is_attached _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WebInspectorIsAttachedMethodInfo
instance (signature ~ (m Bool), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorIsAttachedMethodInfo a signature where
    overloadedMethod _ = webInspectorIsAttached

-- method WebInspector::show
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebInspector", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_inspector_show" webkit_web_inspector_show :: 
    Ptr WebInspector ->                     -- _obj : TInterface "WebKit2" "WebInspector"
    IO ()


webInspectorShow ::
    (MonadIO m, WebInspectorK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webInspectorShow _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_inspector_show _obj'
    touchManagedPtr _obj
    return ()

data WebInspectorShowMethodInfo
instance (signature ~ (m ()), MonadIO m, WebInspectorK a) => MethodInfo WebInspectorShowMethodInfo a signature where
    overloadedMethod _ = webInspectorShow


