

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.WebResource
    ( 

-- * Exported types
    WebResource(..)                         ,
    WebResourceK                            ,
    toWebResource                           ,
    noWebResource                           ,


 -- * Methods
-- ** webResourceGetData
    WebResourceGetDataMethodInfo            ,
    webResourceGetData                      ,


-- ** webResourceGetDataFinish
    WebResourceGetDataFinishMethodInfo      ,
    webResourceGetDataFinish                ,


-- ** webResourceGetResponse
    WebResourceGetResponseMethodInfo        ,
    webResourceGetResponse                  ,


-- ** webResourceGetUri
    WebResourceGetUriMethodInfo             ,
    webResourceGetUri                       ,




 -- * Properties
-- ** Response
    WebResourceResponsePropertyInfo         ,
    getWebResourceResponse                  ,
    webResourceResponse                     ,


-- ** Uri
    WebResourceUriPropertyInfo              ,
    getWebResourceUri                       ,
    webResourceUri                          ,




 -- * Signals
-- ** Failed
    WebResourceFailedCallback               ,
    WebResourceFailedCallbackC              ,
    WebResourceFailedSignalInfo             ,
    afterWebResourceFailed                  ,
    mkWebResourceFailedCallback             ,
    noWebResourceFailedCallback             ,
    onWebResourceFailed                     ,
    webResourceFailedCallbackWrapper        ,
    webResourceFailedClosure                ,


-- ** FailedWithTlsErrors
    WebResourceFailedWithTlsErrorsCallback  ,
    WebResourceFailedWithTlsErrorsCallbackC ,
    WebResourceFailedWithTlsErrorsSignalInfo,
    afterWebResourceFailedWithTlsErrors     ,
    mkWebResourceFailedWithTlsErrorsCallback,
    noWebResourceFailedWithTlsErrorsCallback,
    onWebResourceFailedWithTlsErrors        ,
    webResourceFailedWithTlsErrorsCallbackWrapper,
    webResourceFailedWithTlsErrorsClosure   ,


-- ** Finished
    WebResourceFinishedCallback             ,
    WebResourceFinishedCallbackC            ,
    WebResourceFinishedSignalInfo           ,
    afterWebResourceFinished                ,
    mkWebResourceFinishedCallback           ,
    noWebResourceFinishedCallback           ,
    onWebResourceFinished                   ,
    webResourceFinishedCallbackWrapper      ,
    webResourceFinishedClosure              ,


-- ** ReceivedData
    WebResourceReceivedDataCallback         ,
    WebResourceReceivedDataCallbackC        ,
    WebResourceReceivedDataSignalInfo       ,
    afterWebResourceReceivedData            ,
    mkWebResourceReceivedDataCallback       ,
    noWebResourceReceivedDataCallback       ,
    onWebResourceReceivedData               ,
    webResourceReceivedDataCallbackWrapper  ,
    webResourceReceivedDataClosure          ,


-- ** SentRequest
    WebResourceSentRequestCallback          ,
    WebResourceSentRequestCallbackC         ,
    WebResourceSentRequestSignalInfo        ,
    afterWebResourceSentRequest             ,
    mkWebResourceSentRequestCallback        ,
    noWebResourceSentRequestCallback        ,
    onWebResourceSentRequest                ,
    webResourceSentRequestCallbackWrapper   ,
    webResourceSentRequestClosure           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Gio as Gio

newtype WebResource = WebResource (ForeignPtr WebResource)
foreign import ccall "webkit_web_resource_get_type"
    c_webkit_web_resource_get_type :: IO GType

type instance ParentTypes WebResource = WebResourceParentTypes
type WebResourceParentTypes = '[GObject.Object]

instance GObject WebResource where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_web_resource_get_type
    

class GObject o => WebResourceK o
instance (GObject o, IsDescendantOf WebResource o) => WebResourceK o

toWebResource :: WebResourceK o => o -> IO WebResource
toWebResource = unsafeCastTo WebResource

noWebResource :: Maybe WebResource
noWebResource = Nothing

type family ResolveWebResourceMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebResourceMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebResourceMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebResourceMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebResourceMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebResourceMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebResourceMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebResourceMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebResourceMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebResourceMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebResourceMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebResourceMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebResourceMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebResourceMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebResourceMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebResourceMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebResourceMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebResourceMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebResourceMethod "getDataFinish" o = WebResourceGetDataFinishMethodInfo
    ResolveWebResourceMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebResourceMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebResourceMethod "getResponse" o = WebResourceGetResponseMethodInfo
    ResolveWebResourceMethod "getUri" o = WebResourceGetUriMethodInfo
    ResolveWebResourceMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebResourceMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebResourceMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebResourceMethod t WebResource, MethodInfo info WebResource p) => IsLabelProxy t (WebResource -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebResourceMethod t WebResource, MethodInfo info WebResource p) => IsLabel t (WebResource -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal WebResource::failed
type WebResourceFailedCallback =
    GError ->
    IO ()

noWebResourceFailedCallback :: Maybe WebResourceFailedCallback
noWebResourceFailedCallback = Nothing

type WebResourceFailedCallbackC =
    Ptr () ->                               -- object
    Ptr GError ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebResourceFailedCallback :: WebResourceFailedCallbackC -> IO (FunPtr WebResourceFailedCallbackC)

webResourceFailedClosure :: WebResourceFailedCallback -> IO Closure
webResourceFailedClosure cb = newCClosure =<< mkWebResourceFailedCallback wrapped
    where wrapped = webResourceFailedCallbackWrapper cb

webResourceFailedCallbackWrapper ::
    WebResourceFailedCallback ->
    Ptr () ->
    Ptr GError ->
    Ptr () ->
    IO ()
webResourceFailedCallbackWrapper _cb _ error_ _ = do
    error_' <- (newBoxed GError) error_
    _cb  error_'

onWebResourceFailed :: (GObject a, MonadIO m) => a -> WebResourceFailedCallback -> m SignalHandlerId
onWebResourceFailed obj cb = liftIO $ connectWebResourceFailed obj cb SignalConnectBefore
afterWebResourceFailed :: (GObject a, MonadIO m) => a -> WebResourceFailedCallback -> m SignalHandlerId
afterWebResourceFailed obj cb = connectWebResourceFailed obj cb SignalConnectAfter

connectWebResourceFailed :: (GObject a, MonadIO m) =>
                            a -> WebResourceFailedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebResourceFailed obj cb after = liftIO $ do
    cb' <- mkWebResourceFailedCallback (webResourceFailedCallbackWrapper cb)
    connectSignalFunPtr obj "failed" cb' after

-- signal WebResource::failed-with-tls-errors
type WebResourceFailedWithTlsErrorsCallback =
    Gio.TlsCertificate ->
    [Gio.TlsCertificateFlags] ->
    IO ()

noWebResourceFailedWithTlsErrorsCallback :: Maybe WebResourceFailedWithTlsErrorsCallback
noWebResourceFailedWithTlsErrorsCallback = Nothing

type WebResourceFailedWithTlsErrorsCallbackC =
    Ptr () ->                               -- object
    Ptr Gio.TlsCertificate ->
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebResourceFailedWithTlsErrorsCallback :: WebResourceFailedWithTlsErrorsCallbackC -> IO (FunPtr WebResourceFailedWithTlsErrorsCallbackC)

webResourceFailedWithTlsErrorsClosure :: WebResourceFailedWithTlsErrorsCallback -> IO Closure
webResourceFailedWithTlsErrorsClosure cb = newCClosure =<< mkWebResourceFailedWithTlsErrorsCallback wrapped
    where wrapped = webResourceFailedWithTlsErrorsCallbackWrapper cb

webResourceFailedWithTlsErrorsCallbackWrapper ::
    WebResourceFailedWithTlsErrorsCallback ->
    Ptr () ->
    Ptr Gio.TlsCertificate ->
    CUInt ->
    Ptr () ->
    IO ()
webResourceFailedWithTlsErrorsCallbackWrapper _cb _ certificate errors _ = do
    certificate' <- (newObject Gio.TlsCertificate) certificate
    let errors' = wordToGFlags errors
    _cb  certificate' errors'

onWebResourceFailedWithTlsErrors :: (GObject a, MonadIO m) => a -> WebResourceFailedWithTlsErrorsCallback -> m SignalHandlerId
onWebResourceFailedWithTlsErrors obj cb = liftIO $ connectWebResourceFailedWithTlsErrors obj cb SignalConnectBefore
afterWebResourceFailedWithTlsErrors :: (GObject a, MonadIO m) => a -> WebResourceFailedWithTlsErrorsCallback -> m SignalHandlerId
afterWebResourceFailedWithTlsErrors obj cb = connectWebResourceFailedWithTlsErrors obj cb SignalConnectAfter

connectWebResourceFailedWithTlsErrors :: (GObject a, MonadIO m) =>
                                         a -> WebResourceFailedWithTlsErrorsCallback -> SignalConnectMode -> m SignalHandlerId
connectWebResourceFailedWithTlsErrors obj cb after = liftIO $ do
    cb' <- mkWebResourceFailedWithTlsErrorsCallback (webResourceFailedWithTlsErrorsCallbackWrapper cb)
    connectSignalFunPtr obj "failed-with-tls-errors" cb' after

-- signal WebResource::finished
type WebResourceFinishedCallback =
    IO ()

noWebResourceFinishedCallback :: Maybe WebResourceFinishedCallback
noWebResourceFinishedCallback = Nothing

type WebResourceFinishedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebResourceFinishedCallback :: WebResourceFinishedCallbackC -> IO (FunPtr WebResourceFinishedCallbackC)

webResourceFinishedClosure :: WebResourceFinishedCallback -> IO Closure
webResourceFinishedClosure cb = newCClosure =<< mkWebResourceFinishedCallback wrapped
    where wrapped = webResourceFinishedCallbackWrapper cb

webResourceFinishedCallbackWrapper ::
    WebResourceFinishedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webResourceFinishedCallbackWrapper _cb _ _ = do
    _cb 

onWebResourceFinished :: (GObject a, MonadIO m) => a -> WebResourceFinishedCallback -> m SignalHandlerId
onWebResourceFinished obj cb = liftIO $ connectWebResourceFinished obj cb SignalConnectBefore
afterWebResourceFinished :: (GObject a, MonadIO m) => a -> WebResourceFinishedCallback -> m SignalHandlerId
afterWebResourceFinished obj cb = connectWebResourceFinished obj cb SignalConnectAfter

connectWebResourceFinished :: (GObject a, MonadIO m) =>
                              a -> WebResourceFinishedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebResourceFinished obj cb after = liftIO $ do
    cb' <- mkWebResourceFinishedCallback (webResourceFinishedCallbackWrapper cb)
    connectSignalFunPtr obj "finished" cb' after

-- signal WebResource::received-data
type WebResourceReceivedDataCallback =
    Word64 ->
    IO ()

noWebResourceReceivedDataCallback :: Maybe WebResourceReceivedDataCallback
noWebResourceReceivedDataCallback = Nothing

type WebResourceReceivedDataCallbackC =
    Ptr () ->                               -- object
    Word64 ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebResourceReceivedDataCallback :: WebResourceReceivedDataCallbackC -> IO (FunPtr WebResourceReceivedDataCallbackC)

webResourceReceivedDataClosure :: WebResourceReceivedDataCallback -> IO Closure
webResourceReceivedDataClosure cb = newCClosure =<< mkWebResourceReceivedDataCallback wrapped
    where wrapped = webResourceReceivedDataCallbackWrapper cb

webResourceReceivedDataCallbackWrapper ::
    WebResourceReceivedDataCallback ->
    Ptr () ->
    Word64 ->
    Ptr () ->
    IO ()
webResourceReceivedDataCallbackWrapper _cb _ dataLength _ = do
    _cb  dataLength

onWebResourceReceivedData :: (GObject a, MonadIO m) => a -> WebResourceReceivedDataCallback -> m SignalHandlerId
onWebResourceReceivedData obj cb = liftIO $ connectWebResourceReceivedData obj cb SignalConnectBefore
afterWebResourceReceivedData :: (GObject a, MonadIO m) => a -> WebResourceReceivedDataCallback -> m SignalHandlerId
afterWebResourceReceivedData obj cb = connectWebResourceReceivedData obj cb SignalConnectAfter

connectWebResourceReceivedData :: (GObject a, MonadIO m) =>
                                  a -> WebResourceReceivedDataCallback -> SignalConnectMode -> m SignalHandlerId
connectWebResourceReceivedData obj cb after = liftIO $ do
    cb' <- mkWebResourceReceivedDataCallback (webResourceReceivedDataCallbackWrapper cb)
    connectSignalFunPtr obj "received-data" cb' after

-- signal WebResource::sent-request
type WebResourceSentRequestCallback =
    URIRequest ->
    URIResponse ->
    IO ()

noWebResourceSentRequestCallback :: Maybe WebResourceSentRequestCallback
noWebResourceSentRequestCallback = Nothing

type WebResourceSentRequestCallbackC =
    Ptr () ->                               -- object
    Ptr URIRequest ->
    Ptr URIResponse ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebResourceSentRequestCallback :: WebResourceSentRequestCallbackC -> IO (FunPtr WebResourceSentRequestCallbackC)

webResourceSentRequestClosure :: WebResourceSentRequestCallback -> IO Closure
webResourceSentRequestClosure cb = newCClosure =<< mkWebResourceSentRequestCallback wrapped
    where wrapped = webResourceSentRequestCallbackWrapper cb

webResourceSentRequestCallbackWrapper ::
    WebResourceSentRequestCallback ->
    Ptr () ->
    Ptr URIRequest ->
    Ptr URIResponse ->
    Ptr () ->
    IO ()
webResourceSentRequestCallbackWrapper _cb _ request redirectedResponse _ = do
    request' <- (newObject URIRequest) request
    redirectedResponse' <- (newObject URIResponse) redirectedResponse
    _cb  request' redirectedResponse'

onWebResourceSentRequest :: (GObject a, MonadIO m) => a -> WebResourceSentRequestCallback -> m SignalHandlerId
onWebResourceSentRequest obj cb = liftIO $ connectWebResourceSentRequest obj cb SignalConnectBefore
afterWebResourceSentRequest :: (GObject a, MonadIO m) => a -> WebResourceSentRequestCallback -> m SignalHandlerId
afterWebResourceSentRequest obj cb = connectWebResourceSentRequest obj cb SignalConnectAfter

connectWebResourceSentRequest :: (GObject a, MonadIO m) =>
                                 a -> WebResourceSentRequestCallback -> SignalConnectMode -> m SignalHandlerId
connectWebResourceSentRequest obj cb after = liftIO $ do
    cb' <- mkWebResourceSentRequestCallback (webResourceSentRequestCallbackWrapper cb)
    connectSignalFunPtr obj "sent-request" cb' after

-- VVV Prop "response"
   -- Type: TInterface "WebKit2" "URIResponse"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getWebResourceResponse :: (MonadIO m, WebResourceK o) => o -> m URIResponse
getWebResourceResponse obj = liftIO $ checkUnexpectedNothing "getWebResourceResponse" $ getObjectPropertyObject obj "response" URIResponse

data WebResourceResponsePropertyInfo
instance AttrInfo WebResourceResponsePropertyInfo where
    type AttrAllowedOps WebResourceResponsePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebResourceResponsePropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebResourceResponsePropertyInfo = WebResourceK
    type AttrGetType WebResourceResponsePropertyInfo = URIResponse
    type AttrLabel WebResourceResponsePropertyInfo = "response"
    attrGet _ = getWebResourceResponse
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getWebResourceUri :: (MonadIO m, WebResourceK o) => o -> m T.Text
getWebResourceUri obj = liftIO $ checkUnexpectedNothing "getWebResourceUri" $ getObjectPropertyString obj "uri"

data WebResourceUriPropertyInfo
instance AttrInfo WebResourceUriPropertyInfo where
    type AttrAllowedOps WebResourceUriPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebResourceUriPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebResourceUriPropertyInfo = WebResourceK
    type AttrGetType WebResourceUriPropertyInfo = T.Text
    type AttrLabel WebResourceUriPropertyInfo = "uri"
    attrGet _ = getWebResourceUri
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList WebResource = WebResourceAttributeList
type WebResourceAttributeList = ('[ '("response", WebResourceResponsePropertyInfo), '("uri", WebResourceUriPropertyInfo)] :: [(Symbol, *)])

webResourceResponse :: AttrLabelProxy "response"
webResourceResponse = AttrLabelProxy

webResourceUri :: AttrLabelProxy "uri"
webResourceUri = AttrLabelProxy

data WebResourceFailedSignalInfo
instance SignalInfo WebResourceFailedSignalInfo where
    type HaskellCallbackType WebResourceFailedSignalInfo = WebResourceFailedCallback
    connectSignal _ = connectWebResourceFailed

data WebResourceFailedWithTlsErrorsSignalInfo
instance SignalInfo WebResourceFailedWithTlsErrorsSignalInfo where
    type HaskellCallbackType WebResourceFailedWithTlsErrorsSignalInfo = WebResourceFailedWithTlsErrorsCallback
    connectSignal _ = connectWebResourceFailedWithTlsErrors

data WebResourceFinishedSignalInfo
instance SignalInfo WebResourceFinishedSignalInfo where
    type HaskellCallbackType WebResourceFinishedSignalInfo = WebResourceFinishedCallback
    connectSignal _ = connectWebResourceFinished

data WebResourceReceivedDataSignalInfo
instance SignalInfo WebResourceReceivedDataSignalInfo where
    type HaskellCallbackType WebResourceReceivedDataSignalInfo = WebResourceReceivedDataCallback
    connectSignal _ = connectWebResourceReceivedData

data WebResourceSentRequestSignalInfo
instance SignalInfo WebResourceSentRequestSignalInfo where
    type HaskellCallbackType WebResourceSentRequestSignalInfo = WebResourceSentRequestCallback
    connectSignal _ = connectWebResourceSentRequest

type instance SignalList WebResource = WebResourceSignalList
type WebResourceSignalList = ('[ '("failed", WebResourceFailedSignalInfo), '("failedWithTlsErrors", WebResourceFailedWithTlsErrorsSignalInfo), '("finished", WebResourceFinishedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo), '("receivedData", WebResourceReceivedDataSignalInfo), '("sentRequest", WebResourceSentRequestSignalInfo)] :: [(Symbol, *)])

-- method WebResource::get_data
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebResource", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 3, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_resource_get_data" webkit_web_resource_get_data :: 
    Ptr WebResource ->                      -- _obj : TInterface "WebKit2" "WebResource"
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


webResourceGetData ::
    (MonadIO m, WebResourceK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
webResourceGetData _obj cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_web_resource_get_data _obj' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    return ()

data WebResourceGetDataMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, WebResourceK a, Gio.CancellableK b) => MethodInfo WebResourceGetDataMethodInfo a signature where
    overloadedMethod _ = webResourceGetData

-- method WebResource::get_data_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebResource", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "length", argType = TBasicType TUInt64, direction = DirectionOut, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferEverything}]
-- Lengths : [Arg {argCName = "length", argType = TBasicType TUInt64, direction = DirectionOut, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferEverything}]
-- returnType : Just (TCArray False (-1) 2 (TBasicType TUInt8))
-- throws : True
-- Skip return : False

foreign import ccall "webkit_web_resource_get_data_finish" webkit_web_resource_get_data_finish :: 
    Ptr WebResource ->                      -- _obj : TInterface "WebKit2" "WebResource"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr Word64 ->                           -- length : TBasicType TUInt64
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Word8)


webResourceGetDataFinish ::
    (MonadIO m, WebResourceK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m ByteString                         -- result
webResourceGetDataFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    length_ <- allocMem :: IO (Ptr Word64)
    onException (do
        result <- propagateGError $ webkit_web_resource_get_data_finish _obj' result_' length_
        length_' <- peek length_
        checkUnexpectedReturnNULL "webkit_web_resource_get_data_finish" result
        result' <- (unpackByteStringWithLength length_') result
        freeMem result
        touchManagedPtr _obj
        touchManagedPtr result_
        freeMem length_
        return result'
     ) (do
        freeMem length_
     )

data WebResourceGetDataFinishMethodInfo
instance (signature ~ (b -> m ByteString), MonadIO m, WebResourceK a, Gio.AsyncResultK b) => MethodInfo WebResourceGetDataFinishMethodInfo a signature where
    overloadedMethod _ = webResourceGetDataFinish

-- method WebResource::get_response
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebResource", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "URIResponse")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_resource_get_response" webkit_web_resource_get_response :: 
    Ptr WebResource ->                      -- _obj : TInterface "WebKit2" "WebResource"
    IO (Ptr URIResponse)


webResourceGetResponse ::
    (MonadIO m, WebResourceK a) =>
    a                                       -- _obj
    -> m URIResponse                        -- result
webResourceGetResponse _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_resource_get_response _obj'
    checkUnexpectedReturnNULL "webkit_web_resource_get_response" result
    result' <- (newObject URIResponse) result
    touchManagedPtr _obj
    return result'

data WebResourceGetResponseMethodInfo
instance (signature ~ (m URIResponse), MonadIO m, WebResourceK a) => MethodInfo WebResourceGetResponseMethodInfo a signature where
    overloadedMethod _ = webResourceGetResponse

-- method WebResource::get_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebResource", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_resource_get_uri" webkit_web_resource_get_uri :: 
    Ptr WebResource ->                      -- _obj : TInterface "WebKit2" "WebResource"
    IO CString


webResourceGetUri ::
    (MonadIO m, WebResourceK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
webResourceGetUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_resource_get_uri _obj'
    checkUnexpectedReturnNULL "webkit_web_resource_get_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebResourceGetUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebResourceK a) => MethodInfo WebResourceGetUriMethodInfo a signature where
    overloadedMethod _ = webResourceGetUri


