

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.WebView
    ( 

-- * Exported types
    WebView(..)                             ,
    WebViewK                                ,
    toWebView                               ,
    noWebView                               ,


 -- * Methods
-- ** webViewCanExecuteEditingCommand
    WebViewCanExecuteEditingCommandMethodInfo,
    webViewCanExecuteEditingCommand         ,


-- ** webViewCanExecuteEditingCommandFinish
    WebViewCanExecuteEditingCommandFinishMethodInfo,
    webViewCanExecuteEditingCommandFinish   ,


-- ** webViewCanGoBack
    WebViewCanGoBackMethodInfo              ,
    webViewCanGoBack                        ,


-- ** webViewCanGoForward
    WebViewCanGoForwardMethodInfo           ,
    webViewCanGoForward                     ,


-- ** webViewCanShowMimeType
    WebViewCanShowMimeTypeMethodInfo        ,
    webViewCanShowMimeType                  ,


-- ** webViewDownloadUri
    WebViewDownloadUriMethodInfo            ,
    webViewDownloadUri                      ,


-- ** webViewExecuteEditingCommand
    WebViewExecuteEditingCommandMethodInfo  ,
    webViewExecuteEditingCommand            ,


-- ** webViewExecuteEditingCommandWithArgument
    WebViewExecuteEditingCommandWithArgumentMethodInfo,
    webViewExecuteEditingCommandWithArgument,


-- ** webViewGetBackForwardList
    WebViewGetBackForwardListMethodInfo     ,
    webViewGetBackForwardList               ,


-- ** webViewGetBackgroundColor
    WebViewGetBackgroundColorMethodInfo     ,
    webViewGetBackgroundColor               ,


-- ** webViewGetContext
    WebViewGetContextMethodInfo             ,
    webViewGetContext                       ,


-- ** webViewGetCustomCharset
    WebViewGetCustomCharsetMethodInfo       ,
    webViewGetCustomCharset                 ,


-- ** webViewGetEditorState
    WebViewGetEditorStateMethodInfo         ,
    webViewGetEditorState                   ,


-- ** webViewGetEstimatedLoadProgress
    WebViewGetEstimatedLoadProgressMethodInfo,
    webViewGetEstimatedLoadProgress         ,


-- ** webViewGetFavicon
    WebViewGetFaviconMethodInfo             ,
    webViewGetFavicon                       ,


-- ** webViewGetFindController
    WebViewGetFindControllerMethodInfo      ,
    webViewGetFindController                ,


-- ** webViewGetInspector
    WebViewGetInspectorMethodInfo           ,
    webViewGetInspector                     ,


-- ** webViewGetJavascriptGlobalContext
    WebViewGetJavascriptGlobalContextMethodInfo,
    webViewGetJavascriptGlobalContext       ,


-- ** webViewGetMainResource
    WebViewGetMainResourceMethodInfo        ,
    webViewGetMainResource                  ,


-- ** webViewGetPageId
    WebViewGetPageIdMethodInfo              ,
    webViewGetPageId                        ,


-- ** webViewGetSessionState
    WebViewGetSessionStateMethodInfo        ,
    webViewGetSessionState                  ,


-- ** webViewGetSettings
    WebViewGetSettingsMethodInfo            ,
    webViewGetSettings                      ,


-- ** webViewGetSnapshot
    WebViewGetSnapshotMethodInfo            ,
    webViewGetSnapshot                      ,


-- ** webViewGetSnapshotFinish
    WebViewGetSnapshotFinishMethodInfo      ,
    webViewGetSnapshotFinish                ,


-- ** webViewGetTitle
    WebViewGetTitleMethodInfo               ,
    webViewGetTitle                         ,


-- ** webViewGetTlsInfo
    WebViewGetTlsInfoMethodInfo             ,
    webViewGetTlsInfo                       ,


-- ** webViewGetUri
    WebViewGetUriMethodInfo                 ,
    webViewGetUri                           ,


-- ** webViewGetUserContentManager
    WebViewGetUserContentManagerMethodInfo  ,
    webViewGetUserContentManager            ,


-- ** webViewGetWindowProperties
    WebViewGetWindowPropertiesMethodInfo    ,
    webViewGetWindowProperties              ,


-- ** webViewGetZoomLevel
    WebViewGetZoomLevelMethodInfo           ,
    webViewGetZoomLevel                     ,


-- ** webViewGoBack
    WebViewGoBackMethodInfo                 ,
    webViewGoBack                           ,


-- ** webViewGoForward
    WebViewGoForwardMethodInfo              ,
    webViewGoForward                        ,


-- ** webViewGoToBackForwardListItem
    WebViewGoToBackForwardListItemMethodInfo,
    webViewGoToBackForwardListItem          ,


-- ** webViewIsEditable
    WebViewIsEditableMethodInfo             ,
    webViewIsEditable                       ,


-- ** webViewIsLoading
    WebViewIsLoadingMethodInfo              ,
    webViewIsLoading                        ,


-- ** webViewIsPlayingAudio
    WebViewIsPlayingAudioMethodInfo         ,
    webViewIsPlayingAudio                   ,


-- ** webViewLoadAlternateHtml
    WebViewLoadAlternateHtmlMethodInfo      ,
    webViewLoadAlternateHtml                ,


-- ** webViewLoadBytes
    WebViewLoadBytesMethodInfo              ,
    webViewLoadBytes                        ,


-- ** webViewLoadHtml
    WebViewLoadHtmlMethodInfo               ,
    webViewLoadHtml                         ,


-- ** webViewLoadPlainText
    WebViewLoadPlainTextMethodInfo          ,
    webViewLoadPlainText                    ,


-- ** webViewLoadRequest
    WebViewLoadRequestMethodInfo            ,
    webViewLoadRequest                      ,


-- ** webViewLoadUri
    WebViewLoadUriMethodInfo                ,
    webViewLoadUri                          ,


-- ** webViewNew
    webViewNew                              ,


-- ** webViewNewWithContext
    webViewNewWithContext                   ,


-- ** webViewNewWithRelatedView
    WebViewNewWithRelatedViewMethodInfo     ,
    webViewNewWithRelatedView               ,


-- ** webViewNewWithSettings
    webViewNewWithSettings                  ,


-- ** webViewNewWithUserContentManager
    webViewNewWithUserContentManager        ,


-- ** webViewReload
    WebViewReloadMethodInfo                 ,
    webViewReload                           ,


-- ** webViewReloadBypassCache
    WebViewReloadBypassCacheMethodInfo      ,
    webViewReloadBypassCache                ,


-- ** webViewRestoreSessionState
    WebViewRestoreSessionStateMethodInfo    ,
    webViewRestoreSessionState              ,


-- ** webViewRunJavascript
    WebViewRunJavascriptMethodInfo          ,
    webViewRunJavascript                    ,


-- ** webViewRunJavascriptFinish
    WebViewRunJavascriptFinishMethodInfo    ,
    webViewRunJavascriptFinish              ,


-- ** webViewRunJavascriptFromGresource
    WebViewRunJavascriptFromGresourceMethodInfo,
    webViewRunJavascriptFromGresource       ,


-- ** webViewRunJavascriptFromGresourceFinish
    WebViewRunJavascriptFromGresourceFinishMethodInfo,
    webViewRunJavascriptFromGresourceFinish ,


-- ** webViewSave
    WebViewSaveMethodInfo                   ,
    webViewSave                             ,


-- ** webViewSaveFinish
    WebViewSaveFinishMethodInfo             ,
    webViewSaveFinish                       ,


-- ** webViewSaveToFile
    WebViewSaveToFileMethodInfo             ,
    webViewSaveToFile                       ,


-- ** webViewSaveToFileFinish
    WebViewSaveToFileFinishMethodInfo       ,
    webViewSaveToFileFinish                 ,


-- ** webViewSetBackgroundColor
    WebViewSetBackgroundColorMethodInfo     ,
    webViewSetBackgroundColor               ,


-- ** webViewSetCustomCharset
    WebViewSetCustomCharsetMethodInfo       ,
    webViewSetCustomCharset                 ,


-- ** webViewSetEditable
    WebViewSetEditableMethodInfo            ,
    webViewSetEditable                      ,


-- ** webViewSetSettings
    WebViewSetSettingsMethodInfo            ,
    webViewSetSettings                      ,


-- ** webViewSetZoomLevel
    WebViewSetZoomLevelMethodInfo           ,
    webViewSetZoomLevel                     ,


-- ** webViewStopLoading
    WebViewStopLoadingMethodInfo            ,
    webViewStopLoading                      ,


-- ** webViewTryClose
    WebViewTryCloseMethodInfo               ,
    webViewTryClose                         ,




 -- * Properties
-- ** Editable
    WebViewEditablePropertyInfo             ,
    constructWebViewEditable                ,
    getWebViewEditable                      ,
    setWebViewEditable                      ,
    webViewEditable                         ,


-- ** EstimatedLoadProgress
    WebViewEstimatedLoadProgressPropertyInfo,
    getWebViewEstimatedLoadProgress         ,
    webViewEstimatedLoadProgress            ,


-- ** Favicon
    WebViewFaviconPropertyInfo              ,
    getWebViewFavicon                       ,
    webViewFavicon                          ,


-- ** IsLoading
    WebViewIsLoadingPropertyInfo            ,
    getWebViewIsLoading                     ,


-- ** IsPlayingAudio
    WebViewIsPlayingAudioPropertyInfo       ,
    getWebViewIsPlayingAudio                ,


-- ** RelatedView
    WebViewRelatedViewPropertyInfo          ,
    constructWebViewRelatedView             ,
    webViewRelatedView                      ,


-- ** Settings
    WebViewSettingsPropertyInfo             ,
    constructWebViewSettings                ,
    setWebViewSettings                      ,
    webViewSettings                         ,


-- ** Title
    WebViewTitlePropertyInfo                ,
    getWebViewTitle                         ,
    webViewTitle                            ,


-- ** Uri
    WebViewUriPropertyInfo                  ,
    getWebViewUri                           ,
    webViewUri                              ,


-- ** UserContentManager
    WebViewUserContentManagerPropertyInfo   ,
    constructWebViewUserContentManager      ,
    getWebViewUserContentManager            ,
    webViewUserContentManager               ,


-- ** WebContext
    WebViewWebContextPropertyInfo           ,
    constructWebViewWebContext              ,
    getWebViewWebContext                    ,
    webViewWebContext                       ,


-- ** ZoomLevel
    WebViewZoomLevelPropertyInfo            ,
    constructWebViewZoomLevel               ,
    getWebViewZoomLevel                     ,
    setWebViewZoomLevel                     ,
    webViewZoomLevel                        ,




 -- * Signals
-- ** Authenticate
    WebViewAuthenticateCallback             ,
    WebViewAuthenticateCallbackC            ,
    WebViewAuthenticateSignalInfo           ,
    afterWebViewAuthenticate                ,
    mkWebViewAuthenticateCallback           ,
    noWebViewAuthenticateCallback           ,
    onWebViewAuthenticate                   ,
    webViewAuthenticateCallbackWrapper      ,
    webViewAuthenticateClosure              ,


-- ** Close
    WebViewCloseCallback                    ,
    WebViewCloseCallbackC                   ,
    WebViewCloseSignalInfo                  ,
    afterWebViewClose                       ,
    mkWebViewCloseCallback                  ,
    noWebViewCloseCallback                  ,
    onWebViewClose                          ,
    webViewCloseCallbackWrapper             ,
    webViewCloseClosure                     ,


-- ** ContextMenu
    WebViewContextMenuCallback              ,
    WebViewContextMenuCallbackC             ,
    WebViewContextMenuSignalInfo            ,
    afterWebViewContextMenu                 ,
    mkWebViewContextMenuCallback            ,
    noWebViewContextMenuCallback            ,
    onWebViewContextMenu                    ,
    webViewContextMenuCallbackWrapper       ,
    webViewContextMenuClosure               ,


-- ** ContextMenuDismissed
    WebViewContextMenuDismissedCallback     ,
    WebViewContextMenuDismissedCallbackC    ,
    WebViewContextMenuDismissedSignalInfo   ,
    afterWebViewContextMenuDismissed        ,
    mkWebViewContextMenuDismissedCallback   ,
    noWebViewContextMenuDismissedCallback   ,
    onWebViewContextMenuDismissed           ,
    webViewContextMenuDismissedCallbackWrapper,
    webViewContextMenuDismissedClosure      ,


-- ** Create
    WebViewCreateCallback                   ,
    WebViewCreateCallbackC                  ,
    WebViewCreateSignalInfo                 ,
    afterWebViewCreate                      ,
    mkWebViewCreateCallback                 ,
    noWebViewCreateCallback                 ,
    onWebViewCreate                         ,
    webViewCreateCallbackWrapper            ,
    webViewCreateClosure                    ,


-- ** DecidePolicy
    WebViewDecidePolicyCallback             ,
    WebViewDecidePolicyCallbackC            ,
    WebViewDecidePolicySignalInfo           ,
    afterWebViewDecidePolicy                ,
    mkWebViewDecidePolicyCallback           ,
    noWebViewDecidePolicyCallback           ,
    onWebViewDecidePolicy                   ,
    webViewDecidePolicyCallbackWrapper      ,
    webViewDecidePolicyClosure              ,


-- ** EnterFullscreen
    WebViewEnterFullscreenCallback          ,
    WebViewEnterFullscreenCallbackC         ,
    WebViewEnterFullscreenSignalInfo        ,
    afterWebViewEnterFullscreen             ,
    mkWebViewEnterFullscreenCallback        ,
    noWebViewEnterFullscreenCallback        ,
    onWebViewEnterFullscreen                ,
    webViewEnterFullscreenCallbackWrapper   ,
    webViewEnterFullscreenClosure           ,


-- ** InsecureContentDetected
    WebViewInsecureContentDetectedCallback  ,
    WebViewInsecureContentDetectedCallbackC ,
    WebViewInsecureContentDetectedSignalInfo,
    afterWebViewInsecureContentDetected     ,
    mkWebViewInsecureContentDetectedCallback,
    noWebViewInsecureContentDetectedCallback,
    onWebViewInsecureContentDetected        ,
    webViewInsecureContentDetectedCallbackWrapper,
    webViewInsecureContentDetectedClosure   ,


-- ** LeaveFullscreen
    WebViewLeaveFullscreenCallback          ,
    WebViewLeaveFullscreenCallbackC         ,
    WebViewLeaveFullscreenSignalInfo        ,
    afterWebViewLeaveFullscreen             ,
    mkWebViewLeaveFullscreenCallback        ,
    noWebViewLeaveFullscreenCallback        ,
    onWebViewLeaveFullscreen                ,
    webViewLeaveFullscreenCallbackWrapper   ,
    webViewLeaveFullscreenClosure           ,


-- ** LoadChanged
    WebViewLoadChangedCallback              ,
    WebViewLoadChangedCallbackC             ,
    WebViewLoadChangedSignalInfo            ,
    afterWebViewLoadChanged                 ,
    mkWebViewLoadChangedCallback            ,
    noWebViewLoadChangedCallback            ,
    onWebViewLoadChanged                    ,
    webViewLoadChangedCallbackWrapper       ,
    webViewLoadChangedClosure               ,


-- ** LoadFailed
    WebViewLoadFailedCallback               ,
    WebViewLoadFailedCallbackC              ,
    WebViewLoadFailedSignalInfo             ,
    afterWebViewLoadFailed                  ,
    mkWebViewLoadFailedCallback             ,
    noWebViewLoadFailedCallback             ,
    onWebViewLoadFailed                     ,
    webViewLoadFailedCallbackWrapper        ,
    webViewLoadFailedClosure                ,


-- ** LoadFailedWithTlsErrors
    WebViewLoadFailedWithTlsErrorsCallback  ,
    WebViewLoadFailedWithTlsErrorsCallbackC ,
    WebViewLoadFailedWithTlsErrorsSignalInfo,
    afterWebViewLoadFailedWithTlsErrors     ,
    mkWebViewLoadFailedWithTlsErrorsCallback,
    noWebViewLoadFailedWithTlsErrorsCallback,
    onWebViewLoadFailedWithTlsErrors        ,
    webViewLoadFailedWithTlsErrorsCallbackWrapper,
    webViewLoadFailedWithTlsErrorsClosure   ,


-- ** MouseTargetChanged
    WebViewMouseTargetChangedCallback       ,
    WebViewMouseTargetChangedCallbackC      ,
    WebViewMouseTargetChangedSignalInfo     ,
    afterWebViewMouseTargetChanged          ,
    mkWebViewMouseTargetChangedCallback     ,
    noWebViewMouseTargetChangedCallback     ,
    onWebViewMouseTargetChanged             ,
    webViewMouseTargetChangedCallbackWrapper,
    webViewMouseTargetChangedClosure        ,


-- ** PermissionRequest
    WebViewPermissionRequestCallback        ,
    WebViewPermissionRequestCallbackC       ,
    WebViewPermissionRequestSignalInfo      ,
    afterWebViewPermissionRequest           ,
    mkWebViewPermissionRequestCallback      ,
    noWebViewPermissionRequestCallback      ,
    onWebViewPermissionRequest              ,
    webViewPermissionRequestCallbackWrapper ,
    webViewPermissionRequestClosure         ,


-- ** Print
    WebViewPrintCallback                    ,
    WebViewPrintCallbackC                   ,
    WebViewPrintSignalInfo                  ,
    afterWebViewPrint                       ,
    mkWebViewPrintCallback                  ,
    noWebViewPrintCallback                  ,
    onWebViewPrint                          ,
    webViewPrintCallbackWrapper             ,
    webViewPrintClosure                     ,


-- ** ReadyToShow
    WebViewReadyToShowCallback              ,
    WebViewReadyToShowCallbackC             ,
    WebViewReadyToShowSignalInfo            ,
    afterWebViewReadyToShow                 ,
    mkWebViewReadyToShowCallback            ,
    noWebViewReadyToShowCallback            ,
    onWebViewReadyToShow                    ,
    webViewReadyToShowCallbackWrapper       ,
    webViewReadyToShowClosure               ,


-- ** ResourceLoadStarted
    WebViewResourceLoadStartedCallback      ,
    WebViewResourceLoadStartedCallbackC     ,
    WebViewResourceLoadStartedSignalInfo    ,
    afterWebViewResourceLoadStarted         ,
    mkWebViewResourceLoadStartedCallback    ,
    noWebViewResourceLoadStartedCallback    ,
    onWebViewResourceLoadStarted            ,
    webViewResourceLoadStartedCallbackWrapper,
    webViewResourceLoadStartedClosure       ,


-- ** RunAsModal
    WebViewRunAsModalCallback               ,
    WebViewRunAsModalCallbackC              ,
    WebViewRunAsModalSignalInfo             ,
    afterWebViewRunAsModal                  ,
    mkWebViewRunAsModalCallback             ,
    noWebViewRunAsModalCallback             ,
    onWebViewRunAsModal                     ,
    webViewRunAsModalCallbackWrapper        ,
    webViewRunAsModalClosure                ,


-- ** RunColorChooser
    WebViewRunColorChooserCallback          ,
    WebViewRunColorChooserCallbackC         ,
    WebViewRunColorChooserSignalInfo        ,
    afterWebViewRunColorChooser             ,
    mkWebViewRunColorChooserCallback        ,
    noWebViewRunColorChooserCallback        ,
    onWebViewRunColorChooser                ,
    webViewRunColorChooserCallbackWrapper   ,
    webViewRunColorChooserClosure           ,


-- ** RunFileChooser
    WebViewRunFileChooserCallback           ,
    WebViewRunFileChooserCallbackC          ,
    WebViewRunFileChooserSignalInfo         ,
    afterWebViewRunFileChooser              ,
    mkWebViewRunFileChooserCallback         ,
    noWebViewRunFileChooserCallback         ,
    onWebViewRunFileChooser                 ,
    webViewRunFileChooserCallbackWrapper    ,
    webViewRunFileChooserClosure            ,


-- ** ScriptDialog
    WebViewScriptDialogCallback             ,
    WebViewScriptDialogCallbackC            ,
    WebViewScriptDialogSignalInfo           ,
    afterWebViewScriptDialog                ,
    mkWebViewScriptDialogCallback           ,
    noWebViewScriptDialogCallback           ,
    onWebViewScriptDialog                   ,
    webViewScriptDialogCallbackWrapper      ,
    webViewScriptDialogClosure              ,


-- ** ShowNotification
    WebViewShowNotificationCallback         ,
    WebViewShowNotificationCallbackC        ,
    WebViewShowNotificationSignalInfo       ,
    afterWebViewShowNotification            ,
    mkWebViewShowNotificationCallback       ,
    noWebViewShowNotificationCallback       ,
    onWebViewShowNotification               ,
    webViewShowNotificationCallbackWrapper  ,
    webViewShowNotificationClosure          ,


-- ** SubmitForm
    WebViewSubmitFormCallback               ,
    WebViewSubmitFormCallbackC              ,
    WebViewSubmitFormSignalInfo             ,
    afterWebViewSubmitForm                  ,
    mkWebViewSubmitFormCallback             ,
    noWebViewSubmitFormCallback             ,
    onWebViewSubmitForm                     ,
    webViewSubmitFormCallbackWrapper        ,
    webViewSubmitFormClosure                ,


-- ** WebProcessCrashed
    WebViewWebProcessCrashedCallback        ,
    WebViewWebProcessCrashedCallbackC       ,
    WebViewWebProcessCrashedSignalInfo      ,
    afterWebViewWebProcessCrashed           ,
    mkWebViewWebProcessCrashedCallback      ,
    noWebViewWebProcessCrashedCallback      ,
    onWebViewWebProcessCrashed              ,
    webViewWebProcessCrashedCallbackWrapper ,
    webViewWebProcessCrashedClosure         ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.Atk as Atk
import qualified GI.GLib as GLib
import qualified GI.GObject as GObject
import qualified GI.Gdk as Gdk
import qualified GI.Gio as Gio
import qualified GI.Gtk as Gtk
import qualified GI.JavaScriptCore as JavaScriptCore
import qualified GI.Cairo as Cairo

newtype WebView = WebView (ForeignPtr WebView)
foreign import ccall "webkit_web_view_get_type"
    c_webkit_web_view_get_type :: IO GType

type instance ParentTypes WebView = WebViewParentTypes
type WebViewParentTypes = '[WebViewBase, Gtk.Container, Gtk.Widget, GObject.Object, Atk.ImplementorIface, Gtk.Buildable]

instance GObject WebView where
    gobjectIsInitiallyUnowned _ = True
    gobjectType _ = c_webkit_web_view_get_type
    

class GObject o => WebViewK o
instance (GObject o, IsDescendantOf WebView o) => WebViewK o

toWebView :: WebViewK o => o -> IO WebView
toWebView = unsafeCastTo WebView

noWebView :: Maybe WebView
noWebView = Nothing

type family ResolveWebViewMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebViewMethod "activate" o = Gtk.WidgetActivateMethodInfo
    ResolveWebViewMethod "add" o = Gtk.ContainerAddMethodInfo
    ResolveWebViewMethod "addAccelerator" o = Gtk.WidgetAddAcceleratorMethodInfo
    ResolveWebViewMethod "addChild" o = Gtk.BuildableAddChildMethodInfo
    ResolveWebViewMethod "addDeviceEvents" o = Gtk.WidgetAddDeviceEventsMethodInfo
    ResolveWebViewMethod "addEvents" o = Gtk.WidgetAddEventsMethodInfo
    ResolveWebViewMethod "addMnemonicLabel" o = Gtk.WidgetAddMnemonicLabelMethodInfo
    ResolveWebViewMethod "addTickCallback" o = Gtk.WidgetAddTickCallbackMethodInfo
    ResolveWebViewMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebViewMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebViewMethod "canActivateAccel" o = Gtk.WidgetCanActivateAccelMethodInfo
    ResolveWebViewMethod "canExecuteEditingCommand" o = WebViewCanExecuteEditingCommandMethodInfo
    ResolveWebViewMethod "canExecuteEditingCommandFinish" o = WebViewCanExecuteEditingCommandFinishMethodInfo
    ResolveWebViewMethod "canGoBack" o = WebViewCanGoBackMethodInfo
    ResolveWebViewMethod "canGoForward" o = WebViewCanGoForwardMethodInfo
    ResolveWebViewMethod "canShowMimeType" o = WebViewCanShowMimeTypeMethodInfo
    ResolveWebViewMethod "checkResize" o = Gtk.ContainerCheckResizeMethodInfo
    ResolveWebViewMethod "childFocus" o = Gtk.WidgetChildFocusMethodInfo
    ResolveWebViewMethod "childGetProperty" o = Gtk.ContainerChildGetPropertyMethodInfo
    ResolveWebViewMethod "childNotifyByPspec" o = Gtk.ContainerChildNotifyByPspecMethodInfo
    ResolveWebViewMethod "childSetProperty" o = Gtk.ContainerChildSetPropertyMethodInfo
    ResolveWebViewMethod "childType" o = Gtk.ContainerChildTypeMethodInfo
    ResolveWebViewMethod "classPath" o = Gtk.WidgetClassPathMethodInfo
    ResolveWebViewMethod "computeExpand" o = Gtk.WidgetComputeExpandMethodInfo
    ResolveWebViewMethod "constructChild" o = Gtk.BuildableConstructChildMethodInfo
    ResolveWebViewMethod "createPangoContext" o = Gtk.WidgetCreatePangoContextMethodInfo
    ResolveWebViewMethod "createPangoLayout" o = Gtk.WidgetCreatePangoLayoutMethodInfo
    ResolveWebViewMethod "customFinished" o = Gtk.BuildableCustomFinishedMethodInfo
    ResolveWebViewMethod "customTagEnd" o = Gtk.BuildableCustomTagEndMethodInfo
    ResolveWebViewMethod "customTagStart" o = Gtk.BuildableCustomTagStartMethodInfo
    ResolveWebViewMethod "destroy" o = Gtk.WidgetDestroyMethodInfo
    ResolveWebViewMethod "destroyed" o = Gtk.WidgetDestroyedMethodInfo
    ResolveWebViewMethod "deviceIsShadowed" o = Gtk.WidgetDeviceIsShadowedMethodInfo
    ResolveWebViewMethod "downloadUri" o = WebViewDownloadUriMethodInfo
    ResolveWebViewMethod "dragBegin" o = Gtk.WidgetDragBeginMethodInfo
    ResolveWebViewMethod "dragBeginWithCoordinates" o = Gtk.WidgetDragBeginWithCoordinatesMethodInfo
    ResolveWebViewMethod "dragCheckThreshold" o = Gtk.WidgetDragCheckThresholdMethodInfo
    ResolveWebViewMethod "dragDestAddImageTargets" o = Gtk.WidgetDragDestAddImageTargetsMethodInfo
    ResolveWebViewMethod "dragDestAddTextTargets" o = Gtk.WidgetDragDestAddTextTargetsMethodInfo
    ResolveWebViewMethod "dragDestAddUriTargets" o = Gtk.WidgetDragDestAddUriTargetsMethodInfo
    ResolveWebViewMethod "dragDestFindTarget" o = Gtk.WidgetDragDestFindTargetMethodInfo
    ResolveWebViewMethod "dragDestGetTargetList" o = Gtk.WidgetDragDestGetTargetListMethodInfo
    ResolveWebViewMethod "dragDestGetTrackMotion" o = Gtk.WidgetDragDestGetTrackMotionMethodInfo
    ResolveWebViewMethod "dragDestSet" o = Gtk.WidgetDragDestSetMethodInfo
    ResolveWebViewMethod "dragDestSetProxy" o = Gtk.WidgetDragDestSetProxyMethodInfo
    ResolveWebViewMethod "dragDestSetTargetList" o = Gtk.WidgetDragDestSetTargetListMethodInfo
    ResolveWebViewMethod "dragDestSetTrackMotion" o = Gtk.WidgetDragDestSetTrackMotionMethodInfo
    ResolveWebViewMethod "dragDestUnset" o = Gtk.WidgetDragDestUnsetMethodInfo
    ResolveWebViewMethod "dragGetData" o = Gtk.WidgetDragGetDataMethodInfo
    ResolveWebViewMethod "dragHighlight" o = Gtk.WidgetDragHighlightMethodInfo
    ResolveWebViewMethod "dragSourceAddImageTargets" o = Gtk.WidgetDragSourceAddImageTargetsMethodInfo
    ResolveWebViewMethod "dragSourceAddTextTargets" o = Gtk.WidgetDragSourceAddTextTargetsMethodInfo
    ResolveWebViewMethod "dragSourceAddUriTargets" o = Gtk.WidgetDragSourceAddUriTargetsMethodInfo
    ResolveWebViewMethod "dragSourceGetTargetList" o = Gtk.WidgetDragSourceGetTargetListMethodInfo
    ResolveWebViewMethod "dragSourceSet" o = Gtk.WidgetDragSourceSetMethodInfo
    ResolveWebViewMethod "dragSourceSetIconGicon" o = Gtk.WidgetDragSourceSetIconGiconMethodInfo
    ResolveWebViewMethod "dragSourceSetIconName" o = Gtk.WidgetDragSourceSetIconNameMethodInfo
    ResolveWebViewMethod "dragSourceSetIconPixbuf" o = Gtk.WidgetDragSourceSetIconPixbufMethodInfo
    ResolveWebViewMethod "dragSourceSetIconStock" o = Gtk.WidgetDragSourceSetIconStockMethodInfo
    ResolveWebViewMethod "dragSourceSetTargetList" o = Gtk.WidgetDragSourceSetTargetListMethodInfo
    ResolveWebViewMethod "dragSourceUnset" o = Gtk.WidgetDragSourceUnsetMethodInfo
    ResolveWebViewMethod "dragUnhighlight" o = Gtk.WidgetDragUnhighlightMethodInfo
    ResolveWebViewMethod "draw" o = Gtk.WidgetDrawMethodInfo
    ResolveWebViewMethod "ensureStyle" o = Gtk.WidgetEnsureStyleMethodInfo
    ResolveWebViewMethod "errorBell" o = Gtk.WidgetErrorBellMethodInfo
    ResolveWebViewMethod "event" o = Gtk.WidgetEventMethodInfo
    ResolveWebViewMethod "executeEditingCommand" o = WebViewExecuteEditingCommandMethodInfo
    ResolveWebViewMethod "executeEditingCommandWithArgument" o = WebViewExecuteEditingCommandWithArgumentMethodInfo
    ResolveWebViewMethod "forall" o = Gtk.ContainerForallMethodInfo
    ResolveWebViewMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebViewMethod "foreach" o = Gtk.ContainerForeachMethodInfo
    ResolveWebViewMethod "freezeChildNotify" o = Gtk.WidgetFreezeChildNotifyMethodInfo
    ResolveWebViewMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebViewMethod "goBack" o = WebViewGoBackMethodInfo
    ResolveWebViewMethod "goForward" o = WebViewGoForwardMethodInfo
    ResolveWebViewMethod "goToBackForwardListItem" o = WebViewGoToBackForwardListItemMethodInfo
    ResolveWebViewMethod "grabAdd" o = Gtk.WidgetGrabAddMethodInfo
    ResolveWebViewMethod "grabDefault" o = Gtk.WidgetGrabDefaultMethodInfo
    ResolveWebViewMethod "grabFocus" o = Gtk.WidgetGrabFocusMethodInfo
    ResolveWebViewMethod "grabRemove" o = Gtk.WidgetGrabRemoveMethodInfo
    ResolveWebViewMethod "hasDefault" o = Gtk.WidgetHasDefaultMethodInfo
    ResolveWebViewMethod "hasFocus" o = Gtk.WidgetHasFocusMethodInfo
    ResolveWebViewMethod "hasGrab" o = Gtk.WidgetHasGrabMethodInfo
    ResolveWebViewMethod "hasRcStyle" o = Gtk.WidgetHasRcStyleMethodInfo
    ResolveWebViewMethod "hasScreen" o = Gtk.WidgetHasScreenMethodInfo
    ResolveWebViewMethod "hasVisibleFocus" o = Gtk.WidgetHasVisibleFocusMethodInfo
    ResolveWebViewMethod "hide" o = Gtk.WidgetHideMethodInfo
    ResolveWebViewMethod "hideOnDelete" o = Gtk.WidgetHideOnDeleteMethodInfo
    ResolveWebViewMethod "inDestruction" o = Gtk.WidgetInDestructionMethodInfo
    ResolveWebViewMethod "initTemplate" o = Gtk.WidgetInitTemplateMethodInfo
    ResolveWebViewMethod "inputShapeCombineRegion" o = Gtk.WidgetInputShapeCombineRegionMethodInfo
    ResolveWebViewMethod "insertActionGroup" o = Gtk.WidgetInsertActionGroupMethodInfo
    ResolveWebViewMethod "intersect" o = Gtk.WidgetIntersectMethodInfo
    ResolveWebViewMethod "isAncestor" o = Gtk.WidgetIsAncestorMethodInfo
    ResolveWebViewMethod "isComposited" o = Gtk.WidgetIsCompositedMethodInfo
    ResolveWebViewMethod "isDrawable" o = Gtk.WidgetIsDrawableMethodInfo
    ResolveWebViewMethod "isEditable" o = WebViewIsEditableMethodInfo
    ResolveWebViewMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebViewMethod "isFocus" o = Gtk.WidgetIsFocusMethodInfo
    ResolveWebViewMethod "isLoading" o = WebViewIsLoadingMethodInfo
    ResolveWebViewMethod "isPlayingAudio" o = WebViewIsPlayingAudioMethodInfo
    ResolveWebViewMethod "isSensitive" o = Gtk.WidgetIsSensitiveMethodInfo
    ResolveWebViewMethod "isToplevel" o = Gtk.WidgetIsToplevelMethodInfo
    ResolveWebViewMethod "isVisible" o = Gtk.WidgetIsVisibleMethodInfo
    ResolveWebViewMethod "keynavFailed" o = Gtk.WidgetKeynavFailedMethodInfo
    ResolveWebViewMethod "listAccelClosures" o = Gtk.WidgetListAccelClosuresMethodInfo
    ResolveWebViewMethod "listActionPrefixes" o = Gtk.WidgetListActionPrefixesMethodInfo
    ResolveWebViewMethod "listMnemonicLabels" o = Gtk.WidgetListMnemonicLabelsMethodInfo
    ResolveWebViewMethod "loadAlternateHtml" o = WebViewLoadAlternateHtmlMethodInfo
    ResolveWebViewMethod "loadBytes" o = WebViewLoadBytesMethodInfo
    ResolveWebViewMethod "loadHtml" o = WebViewLoadHtmlMethodInfo
    ResolveWebViewMethod "loadPlainText" o = WebViewLoadPlainTextMethodInfo
    ResolveWebViewMethod "loadRequest" o = WebViewLoadRequestMethodInfo
    ResolveWebViewMethod "loadUri" o = WebViewLoadUriMethodInfo
    ResolveWebViewMethod "map" o = Gtk.WidgetMapMethodInfo
    ResolveWebViewMethod "mnemonicActivate" o = Gtk.WidgetMnemonicActivateMethodInfo
    ResolveWebViewMethod "modifyBase" o = Gtk.WidgetModifyBaseMethodInfo
    ResolveWebViewMethod "modifyBg" o = Gtk.WidgetModifyBgMethodInfo
    ResolveWebViewMethod "modifyCursor" o = Gtk.WidgetModifyCursorMethodInfo
    ResolveWebViewMethod "modifyFg" o = Gtk.WidgetModifyFgMethodInfo
    ResolveWebViewMethod "modifyFont" o = Gtk.WidgetModifyFontMethodInfo
    ResolveWebViewMethod "modifyStyle" o = Gtk.WidgetModifyStyleMethodInfo
    ResolveWebViewMethod "modifyText" o = Gtk.WidgetModifyTextMethodInfo
    ResolveWebViewMethod "newWithRelatedView" o = WebViewNewWithRelatedViewMethodInfo
    ResolveWebViewMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebViewMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebViewMethod "overrideBackgroundColor" o = Gtk.WidgetOverrideBackgroundColorMethodInfo
    ResolveWebViewMethod "overrideColor" o = Gtk.WidgetOverrideColorMethodInfo
    ResolveWebViewMethod "overrideCursor" o = Gtk.WidgetOverrideCursorMethodInfo
    ResolveWebViewMethod "overrideFont" o = Gtk.WidgetOverrideFontMethodInfo
    ResolveWebViewMethod "overrideSymbolicColor" o = Gtk.WidgetOverrideSymbolicColorMethodInfo
    ResolveWebViewMethod "parserFinished" o = Gtk.BuildableParserFinishedMethodInfo
    ResolveWebViewMethod "path" o = Gtk.WidgetPathMethodInfo
    ResolveWebViewMethod "propagateDraw" o = Gtk.ContainerPropagateDrawMethodInfo
    ResolveWebViewMethod "queueComputeExpand" o = Gtk.WidgetQueueComputeExpandMethodInfo
    ResolveWebViewMethod "queueDraw" o = Gtk.WidgetQueueDrawMethodInfo
    ResolveWebViewMethod "queueDrawArea" o = Gtk.WidgetQueueDrawAreaMethodInfo
    ResolveWebViewMethod "queueDrawRegion" o = Gtk.WidgetQueueDrawRegionMethodInfo
    ResolveWebViewMethod "queueResize" o = Gtk.WidgetQueueResizeMethodInfo
    ResolveWebViewMethod "queueResizeNoRedraw" o = Gtk.WidgetQueueResizeNoRedrawMethodInfo
    ResolveWebViewMethod "realize" o = Gtk.WidgetRealizeMethodInfo
    ResolveWebViewMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebViewMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebViewMethod "regionIntersect" o = Gtk.WidgetRegionIntersectMethodInfo
    ResolveWebViewMethod "registerWindow" o = Gtk.WidgetRegisterWindowMethodInfo
    ResolveWebViewMethod "reload" o = WebViewReloadMethodInfo
    ResolveWebViewMethod "reloadBypassCache" o = WebViewReloadBypassCacheMethodInfo
    ResolveWebViewMethod "remove" o = Gtk.ContainerRemoveMethodInfo
    ResolveWebViewMethod "removeAccelerator" o = Gtk.WidgetRemoveAcceleratorMethodInfo
    ResolveWebViewMethod "removeMnemonicLabel" o = Gtk.WidgetRemoveMnemonicLabelMethodInfo
    ResolveWebViewMethod "removeTickCallback" o = Gtk.WidgetRemoveTickCallbackMethodInfo
    ResolveWebViewMethod "renderIcon" o = Gtk.WidgetRenderIconMethodInfo
    ResolveWebViewMethod "renderIconPixbuf" o = Gtk.WidgetRenderIconPixbufMethodInfo
    ResolveWebViewMethod "reparent" o = Gtk.WidgetReparentMethodInfo
    ResolveWebViewMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebViewMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebViewMethod "resetRcStyles" o = Gtk.WidgetResetRcStylesMethodInfo
    ResolveWebViewMethod "resetStyle" o = Gtk.WidgetResetStyleMethodInfo
    ResolveWebViewMethod "resizeChildren" o = Gtk.ContainerResizeChildrenMethodInfo
    ResolveWebViewMethod "restoreSessionState" o = WebViewRestoreSessionStateMethodInfo
    ResolveWebViewMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebViewMethod "runJavascript" o = WebViewRunJavascriptMethodInfo
    ResolveWebViewMethod "runJavascriptFinish" o = WebViewRunJavascriptFinishMethodInfo
    ResolveWebViewMethod "runJavascriptFromGresource" o = WebViewRunJavascriptFromGresourceMethodInfo
    ResolveWebViewMethod "runJavascriptFromGresourceFinish" o = WebViewRunJavascriptFromGresourceFinishMethodInfo
    ResolveWebViewMethod "save" o = WebViewSaveMethodInfo
    ResolveWebViewMethod "saveFinish" o = WebViewSaveFinishMethodInfo
    ResolveWebViewMethod "saveToFile" o = WebViewSaveToFileMethodInfo
    ResolveWebViewMethod "saveToFileFinish" o = WebViewSaveToFileFinishMethodInfo
    ResolveWebViewMethod "sendExpose" o = Gtk.WidgetSendExposeMethodInfo
    ResolveWebViewMethod "sendFocusChange" o = Gtk.WidgetSendFocusChangeMethodInfo
    ResolveWebViewMethod "shapeCombineRegion" o = Gtk.WidgetShapeCombineRegionMethodInfo
    ResolveWebViewMethod "show" o = Gtk.WidgetShowMethodInfo
    ResolveWebViewMethod "showAll" o = Gtk.WidgetShowAllMethodInfo
    ResolveWebViewMethod "showNow" o = Gtk.WidgetShowNowMethodInfo
    ResolveWebViewMethod "sizeAllocate" o = Gtk.WidgetSizeAllocateMethodInfo
    ResolveWebViewMethod "sizeAllocateWithBaseline" o = Gtk.WidgetSizeAllocateWithBaselineMethodInfo
    ResolveWebViewMethod "sizeRequest" o = Gtk.WidgetSizeRequestMethodInfo
    ResolveWebViewMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebViewMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebViewMethod "stopLoading" o = WebViewStopLoadingMethodInfo
    ResolveWebViewMethod "styleAttach" o = Gtk.WidgetStyleAttachMethodInfo
    ResolveWebViewMethod "styleGetProperty" o = Gtk.WidgetStyleGetPropertyMethodInfo
    ResolveWebViewMethod "thawChildNotify" o = Gtk.WidgetThawChildNotifyMethodInfo
    ResolveWebViewMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebViewMethod "translateCoordinates" o = Gtk.WidgetTranslateCoordinatesMethodInfo
    ResolveWebViewMethod "triggerTooltipQuery" o = Gtk.WidgetTriggerTooltipQueryMethodInfo
    ResolveWebViewMethod "tryClose" o = WebViewTryCloseMethodInfo
    ResolveWebViewMethod "unmap" o = Gtk.WidgetUnmapMethodInfo
    ResolveWebViewMethod "unparent" o = Gtk.WidgetUnparentMethodInfo
    ResolveWebViewMethod "unrealize" o = Gtk.WidgetUnrealizeMethodInfo
    ResolveWebViewMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebViewMethod "unregisterWindow" o = Gtk.WidgetUnregisterWindowMethodInfo
    ResolveWebViewMethod "unsetFocusChain" o = Gtk.ContainerUnsetFocusChainMethodInfo
    ResolveWebViewMethod "unsetStateFlags" o = Gtk.WidgetUnsetStateFlagsMethodInfo
    ResolveWebViewMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebViewMethod "getAccessible" o = Gtk.WidgetGetAccessibleMethodInfo
    ResolveWebViewMethod "getActionGroup" o = Gtk.WidgetGetActionGroupMethodInfo
    ResolveWebViewMethod "getAllocatedBaseline" o = Gtk.WidgetGetAllocatedBaselineMethodInfo
    ResolveWebViewMethod "getAllocatedHeight" o = Gtk.WidgetGetAllocatedHeightMethodInfo
    ResolveWebViewMethod "getAllocatedWidth" o = Gtk.WidgetGetAllocatedWidthMethodInfo
    ResolveWebViewMethod "getAllocation" o = Gtk.WidgetGetAllocationMethodInfo
    ResolveWebViewMethod "getAncestor" o = Gtk.WidgetGetAncestorMethodInfo
    ResolveWebViewMethod "getAppPaintable" o = Gtk.WidgetGetAppPaintableMethodInfo
    ResolveWebViewMethod "getBackForwardList" o = WebViewGetBackForwardListMethodInfo
    ResolveWebViewMethod "getBackgroundColor" o = WebViewGetBackgroundColorMethodInfo
    ResolveWebViewMethod "getBorderWidth" o = Gtk.ContainerGetBorderWidthMethodInfo
    ResolveWebViewMethod "getCanDefault" o = Gtk.WidgetGetCanDefaultMethodInfo
    ResolveWebViewMethod "getCanFocus" o = Gtk.WidgetGetCanFocusMethodInfo
    ResolveWebViewMethod "getChildRequisition" o = Gtk.WidgetGetChildRequisitionMethodInfo
    ResolveWebViewMethod "getChildVisible" o = Gtk.WidgetGetChildVisibleMethodInfo
    ResolveWebViewMethod "getChildren" o = Gtk.ContainerGetChildrenMethodInfo
    ResolveWebViewMethod "getClip" o = Gtk.WidgetGetClipMethodInfo
    ResolveWebViewMethod "getClipboard" o = Gtk.WidgetGetClipboardMethodInfo
    ResolveWebViewMethod "getCompositeName" o = Gtk.WidgetGetCompositeNameMethodInfo
    ResolveWebViewMethod "getContext" o = WebViewGetContextMethodInfo
    ResolveWebViewMethod "getCustomCharset" o = WebViewGetCustomCharsetMethodInfo
    ResolveWebViewMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebViewMethod "getDeviceEnabled" o = Gtk.WidgetGetDeviceEnabledMethodInfo
    ResolveWebViewMethod "getDeviceEvents" o = Gtk.WidgetGetDeviceEventsMethodInfo
    ResolveWebViewMethod "getDirection" o = Gtk.WidgetGetDirectionMethodInfo
    ResolveWebViewMethod "getDisplay" o = Gtk.WidgetGetDisplayMethodInfo
    ResolveWebViewMethod "getDoubleBuffered" o = Gtk.WidgetGetDoubleBufferedMethodInfo
    ResolveWebViewMethod "getEditorState" o = WebViewGetEditorStateMethodInfo
    ResolveWebViewMethod "getEstimatedLoadProgress" o = WebViewGetEstimatedLoadProgressMethodInfo
    ResolveWebViewMethod "getEvents" o = Gtk.WidgetGetEventsMethodInfo
    ResolveWebViewMethod "getFavicon" o = WebViewGetFaviconMethodInfo
    ResolveWebViewMethod "getFindController" o = WebViewGetFindControllerMethodInfo
    ResolveWebViewMethod "getFocusChain" o = Gtk.ContainerGetFocusChainMethodInfo
    ResolveWebViewMethod "getFocusChild" o = Gtk.ContainerGetFocusChildMethodInfo
    ResolveWebViewMethod "getFocusHadjustment" o = Gtk.ContainerGetFocusHadjustmentMethodInfo
    ResolveWebViewMethod "getFocusVadjustment" o = Gtk.ContainerGetFocusVadjustmentMethodInfo
    ResolveWebViewMethod "getFontMap" o = Gtk.WidgetGetFontMapMethodInfo
    ResolveWebViewMethod "getFontOptions" o = Gtk.WidgetGetFontOptionsMethodInfo
    ResolveWebViewMethod "getFrameClock" o = Gtk.WidgetGetFrameClockMethodInfo
    ResolveWebViewMethod "getHalign" o = Gtk.WidgetGetHalignMethodInfo
    ResolveWebViewMethod "getHasTooltip" o = Gtk.WidgetGetHasTooltipMethodInfo
    ResolveWebViewMethod "getHasWindow" o = Gtk.WidgetGetHasWindowMethodInfo
    ResolveWebViewMethod "getHexpand" o = Gtk.WidgetGetHexpandMethodInfo
    ResolveWebViewMethod "getHexpandSet" o = Gtk.WidgetGetHexpandSetMethodInfo
    ResolveWebViewMethod "getInspector" o = WebViewGetInspectorMethodInfo
    ResolveWebViewMethod "getInternalChild" o = Gtk.BuildableGetInternalChildMethodInfo
    ResolveWebViewMethod "getJavascriptGlobalContext" o = WebViewGetJavascriptGlobalContextMethodInfo
    ResolveWebViewMethod "getMainResource" o = WebViewGetMainResourceMethodInfo
    ResolveWebViewMethod "getMapped" o = Gtk.WidgetGetMappedMethodInfo
    ResolveWebViewMethod "getMarginBottom" o = Gtk.WidgetGetMarginBottomMethodInfo
    ResolveWebViewMethod "getMarginEnd" o = Gtk.WidgetGetMarginEndMethodInfo
    ResolveWebViewMethod "getMarginLeft" o = Gtk.WidgetGetMarginLeftMethodInfo
    ResolveWebViewMethod "getMarginRight" o = Gtk.WidgetGetMarginRightMethodInfo
    ResolveWebViewMethod "getMarginStart" o = Gtk.WidgetGetMarginStartMethodInfo
    ResolveWebViewMethod "getMarginTop" o = Gtk.WidgetGetMarginTopMethodInfo
    ResolveWebViewMethod "getModifierMask" o = Gtk.WidgetGetModifierMaskMethodInfo
    ResolveWebViewMethod "getModifierStyle" o = Gtk.WidgetGetModifierStyleMethodInfo
    ResolveWebViewMethod "getNoShowAll" o = Gtk.WidgetGetNoShowAllMethodInfo
    ResolveWebViewMethod "getOpacity" o = Gtk.WidgetGetOpacityMethodInfo
    ResolveWebViewMethod "getPageId" o = WebViewGetPageIdMethodInfo
    ResolveWebViewMethod "getPangoContext" o = Gtk.WidgetGetPangoContextMethodInfo
    ResolveWebViewMethod "getParent" o = Gtk.WidgetGetParentMethodInfo
    ResolveWebViewMethod "getParentWindow" o = Gtk.WidgetGetParentWindowMethodInfo
    ResolveWebViewMethod "getPath" o = Gtk.WidgetGetPathMethodInfo
    ResolveWebViewMethod "getPathForChild" o = Gtk.ContainerGetPathForChildMethodInfo
    ResolveWebViewMethod "getPointer" o = Gtk.WidgetGetPointerMethodInfo
    ResolveWebViewMethod "getPreferredHeight" o = Gtk.WidgetGetPreferredHeightMethodInfo
    ResolveWebViewMethod "getPreferredHeightAndBaselineForWidth" o = Gtk.WidgetGetPreferredHeightAndBaselineForWidthMethodInfo
    ResolveWebViewMethod "getPreferredHeightForWidth" o = Gtk.WidgetGetPreferredHeightForWidthMethodInfo
    ResolveWebViewMethod "getPreferredSize" o = Gtk.WidgetGetPreferredSizeMethodInfo
    ResolveWebViewMethod "getPreferredWidth" o = Gtk.WidgetGetPreferredWidthMethodInfo
    ResolveWebViewMethod "getPreferredWidthForHeight" o = Gtk.WidgetGetPreferredWidthForHeightMethodInfo
    ResolveWebViewMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebViewMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebViewMethod "getRealized" o = Gtk.WidgetGetRealizedMethodInfo
    ResolveWebViewMethod "getReceivesDefault" o = Gtk.WidgetGetReceivesDefaultMethodInfo
    ResolveWebViewMethod "getRequestMode" o = Gtk.WidgetGetRequestModeMethodInfo
    ResolveWebViewMethod "getRequisition" o = Gtk.WidgetGetRequisitionMethodInfo
    ResolveWebViewMethod "getResizeMode" o = Gtk.ContainerGetResizeModeMethodInfo
    ResolveWebViewMethod "getRootWindow" o = Gtk.WidgetGetRootWindowMethodInfo
    ResolveWebViewMethod "getScaleFactor" o = Gtk.WidgetGetScaleFactorMethodInfo
    ResolveWebViewMethod "getScreen" o = Gtk.WidgetGetScreenMethodInfo
    ResolveWebViewMethod "getSensitive" o = Gtk.WidgetGetSensitiveMethodInfo
    ResolveWebViewMethod "getSessionState" o = WebViewGetSessionStateMethodInfo
    ResolveWebViewMethod "getSizeRequest" o = Gtk.WidgetGetSizeRequestMethodInfo
    ResolveWebViewMethod "getSnapshot" o = WebViewGetSnapshotMethodInfo
    ResolveWebViewMethod "getSnapshotFinish" o = WebViewGetSnapshotFinishMethodInfo
    ResolveWebViewMethod "getState" o = Gtk.WidgetGetStateMethodInfo
    ResolveWebViewMethod "getStateFlags" o = Gtk.WidgetGetStateFlagsMethodInfo
    ResolveWebViewMethod "getStyle" o = Gtk.WidgetGetStyleMethodInfo
    ResolveWebViewMethod "getStyleContext" o = Gtk.WidgetGetStyleContextMethodInfo
    ResolveWebViewMethod "getSupportMultidevice" o = Gtk.WidgetGetSupportMultideviceMethodInfo
    ResolveWebViewMethod "getTemplateChild" o = Gtk.WidgetGetTemplateChildMethodInfo
    ResolveWebViewMethod "getTitle" o = WebViewGetTitleMethodInfo
    ResolveWebViewMethod "getTlsInfo" o = WebViewGetTlsInfoMethodInfo
    ResolveWebViewMethod "getTooltipMarkup" o = Gtk.WidgetGetTooltipMarkupMethodInfo
    ResolveWebViewMethod "getTooltipText" o = Gtk.WidgetGetTooltipTextMethodInfo
    ResolveWebViewMethod "getTooltipWindow" o = Gtk.WidgetGetTooltipWindowMethodInfo
    ResolveWebViewMethod "getToplevel" o = Gtk.WidgetGetToplevelMethodInfo
    ResolveWebViewMethod "getUri" o = WebViewGetUriMethodInfo
    ResolveWebViewMethod "getUserContentManager" o = WebViewGetUserContentManagerMethodInfo
    ResolveWebViewMethod "getValign" o = Gtk.WidgetGetValignMethodInfo
    ResolveWebViewMethod "getValignWithBaseline" o = Gtk.WidgetGetValignWithBaselineMethodInfo
    ResolveWebViewMethod "getVexpand" o = Gtk.WidgetGetVexpandMethodInfo
    ResolveWebViewMethod "getVexpandSet" o = Gtk.WidgetGetVexpandSetMethodInfo
    ResolveWebViewMethod "getVisible" o = Gtk.WidgetGetVisibleMethodInfo
    ResolveWebViewMethod "getVisual" o = Gtk.WidgetGetVisualMethodInfo
    ResolveWebViewMethod "getWindow" o = Gtk.WidgetGetWindowMethodInfo
    ResolveWebViewMethod "getWindowProperties" o = WebViewGetWindowPropertiesMethodInfo
    ResolveWebViewMethod "getZoomLevel" o = WebViewGetZoomLevelMethodInfo
    ResolveWebViewMethod "setAccelPath" o = Gtk.WidgetSetAccelPathMethodInfo
    ResolveWebViewMethod "setAllocation" o = Gtk.WidgetSetAllocationMethodInfo
    ResolveWebViewMethod "setAppPaintable" o = Gtk.WidgetSetAppPaintableMethodInfo
    ResolveWebViewMethod "setBackgroundColor" o = WebViewSetBackgroundColorMethodInfo
    ResolveWebViewMethod "setBorderWidth" o = Gtk.ContainerSetBorderWidthMethodInfo
    ResolveWebViewMethod "setBuildableProperty" o = Gtk.BuildableSetBuildablePropertyMethodInfo
    ResolveWebViewMethod "setCanDefault" o = Gtk.WidgetSetCanDefaultMethodInfo
    ResolveWebViewMethod "setCanFocus" o = Gtk.WidgetSetCanFocusMethodInfo
    ResolveWebViewMethod "setChildVisible" o = Gtk.WidgetSetChildVisibleMethodInfo
    ResolveWebViewMethod "setClip" o = Gtk.WidgetSetClipMethodInfo
    ResolveWebViewMethod "setCompositeName" o = Gtk.WidgetSetCompositeNameMethodInfo
    ResolveWebViewMethod "setCustomCharset" o = WebViewSetCustomCharsetMethodInfo
    ResolveWebViewMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebViewMethod "setDeviceEnabled" o = Gtk.WidgetSetDeviceEnabledMethodInfo
    ResolveWebViewMethod "setDeviceEvents" o = Gtk.WidgetSetDeviceEventsMethodInfo
    ResolveWebViewMethod "setDirection" o = Gtk.WidgetSetDirectionMethodInfo
    ResolveWebViewMethod "setDoubleBuffered" o = Gtk.WidgetSetDoubleBufferedMethodInfo
    ResolveWebViewMethod "setEditable" o = WebViewSetEditableMethodInfo
    ResolveWebViewMethod "setEvents" o = Gtk.WidgetSetEventsMethodInfo
    ResolveWebViewMethod "setFocusChain" o = Gtk.ContainerSetFocusChainMethodInfo
    ResolveWebViewMethod "setFocusChild" o = Gtk.ContainerSetFocusChildMethodInfo
    ResolveWebViewMethod "setFocusHadjustment" o = Gtk.ContainerSetFocusHadjustmentMethodInfo
    ResolveWebViewMethod "setFocusVadjustment" o = Gtk.ContainerSetFocusVadjustmentMethodInfo
    ResolveWebViewMethod "setFontMap" o = Gtk.WidgetSetFontMapMethodInfo
    ResolveWebViewMethod "setFontOptions" o = Gtk.WidgetSetFontOptionsMethodInfo
    ResolveWebViewMethod "setHalign" o = Gtk.WidgetSetHalignMethodInfo
    ResolveWebViewMethod "setHasTooltip" o = Gtk.WidgetSetHasTooltipMethodInfo
    ResolveWebViewMethod "setHasWindow" o = Gtk.WidgetSetHasWindowMethodInfo
    ResolveWebViewMethod "setHexpand" o = Gtk.WidgetSetHexpandMethodInfo
    ResolveWebViewMethod "setHexpandSet" o = Gtk.WidgetSetHexpandSetMethodInfo
    ResolveWebViewMethod "setMapped" o = Gtk.WidgetSetMappedMethodInfo
    ResolveWebViewMethod "setMarginBottom" o = Gtk.WidgetSetMarginBottomMethodInfo
    ResolveWebViewMethod "setMarginEnd" o = Gtk.WidgetSetMarginEndMethodInfo
    ResolveWebViewMethod "setMarginLeft" o = Gtk.WidgetSetMarginLeftMethodInfo
    ResolveWebViewMethod "setMarginRight" o = Gtk.WidgetSetMarginRightMethodInfo
    ResolveWebViewMethod "setMarginStart" o = Gtk.WidgetSetMarginStartMethodInfo
    ResolveWebViewMethod "setMarginTop" o = Gtk.WidgetSetMarginTopMethodInfo
    ResolveWebViewMethod "setNoShowAll" o = Gtk.WidgetSetNoShowAllMethodInfo
    ResolveWebViewMethod "setOpacity" o = Gtk.WidgetSetOpacityMethodInfo
    ResolveWebViewMethod "setParent" o = Gtk.WidgetSetParentMethodInfo
    ResolveWebViewMethod "setParentWindow" o = Gtk.WidgetSetParentWindowMethodInfo
    ResolveWebViewMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebViewMethod "setRealized" o = Gtk.WidgetSetRealizedMethodInfo
    ResolveWebViewMethod "setReallocateRedraws" o = Gtk.ContainerSetReallocateRedrawsMethodInfo
    ResolveWebViewMethod "setReceivesDefault" o = Gtk.WidgetSetReceivesDefaultMethodInfo
    ResolveWebViewMethod "setRedrawOnAllocate" o = Gtk.WidgetSetRedrawOnAllocateMethodInfo
    ResolveWebViewMethod "setResizeMode" o = Gtk.ContainerSetResizeModeMethodInfo
    ResolveWebViewMethod "setSensitive" o = Gtk.WidgetSetSensitiveMethodInfo
    ResolveWebViewMethod "setSettings" o = WebViewSetSettingsMethodInfo
    ResolveWebViewMethod "setSizeRequest" o = Gtk.WidgetSetSizeRequestMethodInfo
    ResolveWebViewMethod "setState" o = Gtk.WidgetSetStateMethodInfo
    ResolveWebViewMethod "setStateFlags" o = Gtk.WidgetSetStateFlagsMethodInfo
    ResolveWebViewMethod "setStyle" o = Gtk.WidgetSetStyleMethodInfo
    ResolveWebViewMethod "setSupportMultidevice" o = Gtk.WidgetSetSupportMultideviceMethodInfo
    ResolveWebViewMethod "setTooltipMarkup" o = Gtk.WidgetSetTooltipMarkupMethodInfo
    ResolveWebViewMethod "setTooltipText" o = Gtk.WidgetSetTooltipTextMethodInfo
    ResolveWebViewMethod "setTooltipWindow" o = Gtk.WidgetSetTooltipWindowMethodInfo
    ResolveWebViewMethod "setValign" o = Gtk.WidgetSetValignMethodInfo
    ResolveWebViewMethod "setVexpand" o = Gtk.WidgetSetVexpandMethodInfo
    ResolveWebViewMethod "setVexpandSet" o = Gtk.WidgetSetVexpandSetMethodInfo
    ResolveWebViewMethod "setVisible" o = Gtk.WidgetSetVisibleMethodInfo
    ResolveWebViewMethod "setVisual" o = Gtk.WidgetSetVisualMethodInfo
    ResolveWebViewMethod "setWindow" o = Gtk.WidgetSetWindowMethodInfo
    ResolveWebViewMethod "setZoomLevel" o = WebViewSetZoomLevelMethodInfo
    ResolveWebViewMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebViewMethod t WebView, MethodInfo info WebView p) => IsLabelProxy t (WebView -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebViewMethod t WebView, MethodInfo info WebView p) => IsLabel t (WebView -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal WebView::authenticate
type WebViewAuthenticateCallback =
    AuthenticationRequest ->
    IO Bool

noWebViewAuthenticateCallback :: Maybe WebViewAuthenticateCallback
noWebViewAuthenticateCallback = Nothing

type WebViewAuthenticateCallbackC =
    Ptr () ->                               -- object
    Ptr AuthenticationRequest ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewAuthenticateCallback :: WebViewAuthenticateCallbackC -> IO (FunPtr WebViewAuthenticateCallbackC)

webViewAuthenticateClosure :: WebViewAuthenticateCallback -> IO Closure
webViewAuthenticateClosure cb = newCClosure =<< mkWebViewAuthenticateCallback wrapped
    where wrapped = webViewAuthenticateCallbackWrapper cb

webViewAuthenticateCallbackWrapper ::
    WebViewAuthenticateCallback ->
    Ptr () ->
    Ptr AuthenticationRequest ->
    Ptr () ->
    IO CInt
webViewAuthenticateCallbackWrapper _cb _ request _ = do
    request' <- (newObject AuthenticationRequest) request
    result <- _cb  request'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewAuthenticate :: (GObject a, MonadIO m) => a -> WebViewAuthenticateCallback -> m SignalHandlerId
onWebViewAuthenticate obj cb = liftIO $ connectWebViewAuthenticate obj cb SignalConnectBefore
afterWebViewAuthenticate :: (GObject a, MonadIO m) => a -> WebViewAuthenticateCallback -> m SignalHandlerId
afterWebViewAuthenticate obj cb = connectWebViewAuthenticate obj cb SignalConnectAfter

connectWebViewAuthenticate :: (GObject a, MonadIO m) =>
                              a -> WebViewAuthenticateCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewAuthenticate obj cb after = liftIO $ do
    cb' <- mkWebViewAuthenticateCallback (webViewAuthenticateCallbackWrapper cb)
    connectSignalFunPtr obj "authenticate" cb' after

-- signal WebView::close
type WebViewCloseCallback =
    IO ()

noWebViewCloseCallback :: Maybe WebViewCloseCallback
noWebViewCloseCallback = Nothing

type WebViewCloseCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewCloseCallback :: WebViewCloseCallbackC -> IO (FunPtr WebViewCloseCallbackC)

webViewCloseClosure :: WebViewCloseCallback -> IO Closure
webViewCloseClosure cb = newCClosure =<< mkWebViewCloseCallback wrapped
    where wrapped = webViewCloseCallbackWrapper cb

webViewCloseCallbackWrapper ::
    WebViewCloseCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webViewCloseCallbackWrapper _cb _ _ = do
    _cb 

onWebViewClose :: (GObject a, MonadIO m) => a -> WebViewCloseCallback -> m SignalHandlerId
onWebViewClose obj cb = liftIO $ connectWebViewClose obj cb SignalConnectBefore
afterWebViewClose :: (GObject a, MonadIO m) => a -> WebViewCloseCallback -> m SignalHandlerId
afterWebViewClose obj cb = connectWebViewClose obj cb SignalConnectAfter

connectWebViewClose :: (GObject a, MonadIO m) =>
                       a -> WebViewCloseCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewClose obj cb after = liftIO $ do
    cb' <- mkWebViewCloseCallback (webViewCloseCallbackWrapper cb)
    connectSignalFunPtr obj "close" cb' after

-- signal WebView::context-menu
type WebViewContextMenuCallback =
    ContextMenu ->
    Gdk.Event ->
    HitTestResult ->
    IO Bool

noWebViewContextMenuCallback :: Maybe WebViewContextMenuCallback
noWebViewContextMenuCallback = Nothing

type WebViewContextMenuCallbackC =
    Ptr () ->                               -- object
    Ptr ContextMenu ->
    Ptr Gdk.Event ->
    Ptr HitTestResult ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewContextMenuCallback :: WebViewContextMenuCallbackC -> IO (FunPtr WebViewContextMenuCallbackC)

webViewContextMenuClosure :: WebViewContextMenuCallback -> IO Closure
webViewContextMenuClosure cb = newCClosure =<< mkWebViewContextMenuCallback wrapped
    where wrapped = webViewContextMenuCallbackWrapper cb

webViewContextMenuCallbackWrapper ::
    WebViewContextMenuCallback ->
    Ptr () ->
    Ptr ContextMenu ->
    Ptr Gdk.Event ->
    Ptr HitTestResult ->
    Ptr () ->
    IO CInt
webViewContextMenuCallbackWrapper _cb _ contextMenu event hitTestResult _ = do
    contextMenu' <- (newObject ContextMenu) contextMenu
    event' <- (newBoxed Gdk.Event) event
    hitTestResult' <- (newObject HitTestResult) hitTestResult
    result <- _cb  contextMenu' event' hitTestResult'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewContextMenu :: (GObject a, MonadIO m) => a -> WebViewContextMenuCallback -> m SignalHandlerId
onWebViewContextMenu obj cb = liftIO $ connectWebViewContextMenu obj cb SignalConnectBefore
afterWebViewContextMenu :: (GObject a, MonadIO m) => a -> WebViewContextMenuCallback -> m SignalHandlerId
afterWebViewContextMenu obj cb = connectWebViewContextMenu obj cb SignalConnectAfter

connectWebViewContextMenu :: (GObject a, MonadIO m) =>
                             a -> WebViewContextMenuCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewContextMenu obj cb after = liftIO $ do
    cb' <- mkWebViewContextMenuCallback (webViewContextMenuCallbackWrapper cb)
    connectSignalFunPtr obj "context-menu" cb' after

-- signal WebView::context-menu-dismissed
type WebViewContextMenuDismissedCallback =
    IO ()

noWebViewContextMenuDismissedCallback :: Maybe WebViewContextMenuDismissedCallback
noWebViewContextMenuDismissedCallback = Nothing

type WebViewContextMenuDismissedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewContextMenuDismissedCallback :: WebViewContextMenuDismissedCallbackC -> IO (FunPtr WebViewContextMenuDismissedCallbackC)

webViewContextMenuDismissedClosure :: WebViewContextMenuDismissedCallback -> IO Closure
webViewContextMenuDismissedClosure cb = newCClosure =<< mkWebViewContextMenuDismissedCallback wrapped
    where wrapped = webViewContextMenuDismissedCallbackWrapper cb

webViewContextMenuDismissedCallbackWrapper ::
    WebViewContextMenuDismissedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webViewContextMenuDismissedCallbackWrapper _cb _ _ = do
    _cb 

onWebViewContextMenuDismissed :: (GObject a, MonadIO m) => a -> WebViewContextMenuDismissedCallback -> m SignalHandlerId
onWebViewContextMenuDismissed obj cb = liftIO $ connectWebViewContextMenuDismissed obj cb SignalConnectBefore
afterWebViewContextMenuDismissed :: (GObject a, MonadIO m) => a -> WebViewContextMenuDismissedCallback -> m SignalHandlerId
afterWebViewContextMenuDismissed obj cb = connectWebViewContextMenuDismissed obj cb SignalConnectAfter

connectWebViewContextMenuDismissed :: (GObject a, MonadIO m) =>
                                      a -> WebViewContextMenuDismissedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewContextMenuDismissed obj cb after = liftIO $ do
    cb' <- mkWebViewContextMenuDismissedCallback (webViewContextMenuDismissedCallbackWrapper cb)
    connectSignalFunPtr obj "context-menu-dismissed" cb' after

-- signal WebView::create
type WebViewCreateCallback =
    NavigationAction ->
    IO Gtk.Widget

noWebViewCreateCallback :: Maybe WebViewCreateCallback
noWebViewCreateCallback = Nothing

type WebViewCreateCallbackC =
    Ptr () ->                               -- object
    Ptr NavigationAction ->
    Ptr () ->                               -- user_data
    IO (Ptr Gtk.Widget)

foreign import ccall "wrapper"
    mkWebViewCreateCallback :: WebViewCreateCallbackC -> IO (FunPtr WebViewCreateCallbackC)

webViewCreateClosure :: WebViewCreateCallback -> IO Closure
webViewCreateClosure cb = newCClosure =<< mkWebViewCreateCallback wrapped
    where wrapped = webViewCreateCallbackWrapper cb

webViewCreateCallbackWrapper ::
    WebViewCreateCallback ->
    Ptr () ->
    Ptr NavigationAction ->
    Ptr () ->
    IO (Ptr Gtk.Widget)
webViewCreateCallbackWrapper _cb _ navigationAction _ = do
    navigationAction' <- (newBoxed NavigationAction) navigationAction
    result <- _cb  navigationAction'
    result' <- refObject result
    return result'

onWebViewCreate :: (GObject a, MonadIO m) => a -> WebViewCreateCallback -> m SignalHandlerId
onWebViewCreate obj cb = liftIO $ connectWebViewCreate obj cb SignalConnectBefore
afterWebViewCreate :: (GObject a, MonadIO m) => a -> WebViewCreateCallback -> m SignalHandlerId
afterWebViewCreate obj cb = connectWebViewCreate obj cb SignalConnectAfter

connectWebViewCreate :: (GObject a, MonadIO m) =>
                        a -> WebViewCreateCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewCreate obj cb after = liftIO $ do
    cb' <- mkWebViewCreateCallback (webViewCreateCallbackWrapper cb)
    connectSignalFunPtr obj "create" cb' after

-- signal WebView::decide-policy
type WebViewDecidePolicyCallback =
    PolicyDecision ->
    PolicyDecisionType ->
    IO Bool

noWebViewDecidePolicyCallback :: Maybe WebViewDecidePolicyCallback
noWebViewDecidePolicyCallback = Nothing

type WebViewDecidePolicyCallbackC =
    Ptr () ->                               -- object
    Ptr PolicyDecision ->
    CUInt ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewDecidePolicyCallback :: WebViewDecidePolicyCallbackC -> IO (FunPtr WebViewDecidePolicyCallbackC)

webViewDecidePolicyClosure :: WebViewDecidePolicyCallback -> IO Closure
webViewDecidePolicyClosure cb = newCClosure =<< mkWebViewDecidePolicyCallback wrapped
    where wrapped = webViewDecidePolicyCallbackWrapper cb

webViewDecidePolicyCallbackWrapper ::
    WebViewDecidePolicyCallback ->
    Ptr () ->
    Ptr PolicyDecision ->
    CUInt ->
    Ptr () ->
    IO CInt
webViewDecidePolicyCallbackWrapper _cb _ decision decisionType _ = do
    decision' <- (newObject PolicyDecision) decision
    let decisionType' = (toEnum . fromIntegral) decisionType
    result <- _cb  decision' decisionType'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewDecidePolicy :: (GObject a, MonadIO m) => a -> WebViewDecidePolicyCallback -> m SignalHandlerId
onWebViewDecidePolicy obj cb = liftIO $ connectWebViewDecidePolicy obj cb SignalConnectBefore
afterWebViewDecidePolicy :: (GObject a, MonadIO m) => a -> WebViewDecidePolicyCallback -> m SignalHandlerId
afterWebViewDecidePolicy obj cb = connectWebViewDecidePolicy obj cb SignalConnectAfter

connectWebViewDecidePolicy :: (GObject a, MonadIO m) =>
                              a -> WebViewDecidePolicyCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewDecidePolicy obj cb after = liftIO $ do
    cb' <- mkWebViewDecidePolicyCallback (webViewDecidePolicyCallbackWrapper cb)
    connectSignalFunPtr obj "decide-policy" cb' after

-- signal WebView::enter-fullscreen
type WebViewEnterFullscreenCallback =
    IO Bool

noWebViewEnterFullscreenCallback :: Maybe WebViewEnterFullscreenCallback
noWebViewEnterFullscreenCallback = Nothing

type WebViewEnterFullscreenCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewEnterFullscreenCallback :: WebViewEnterFullscreenCallbackC -> IO (FunPtr WebViewEnterFullscreenCallbackC)

webViewEnterFullscreenClosure :: WebViewEnterFullscreenCallback -> IO Closure
webViewEnterFullscreenClosure cb = newCClosure =<< mkWebViewEnterFullscreenCallback wrapped
    where wrapped = webViewEnterFullscreenCallbackWrapper cb

webViewEnterFullscreenCallbackWrapper ::
    WebViewEnterFullscreenCallback ->
    Ptr () ->
    Ptr () ->
    IO CInt
webViewEnterFullscreenCallbackWrapper _cb _ _ = do
    result <- _cb 
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewEnterFullscreen :: (GObject a, MonadIO m) => a -> WebViewEnterFullscreenCallback -> m SignalHandlerId
onWebViewEnterFullscreen obj cb = liftIO $ connectWebViewEnterFullscreen obj cb SignalConnectBefore
afterWebViewEnterFullscreen :: (GObject a, MonadIO m) => a -> WebViewEnterFullscreenCallback -> m SignalHandlerId
afterWebViewEnterFullscreen obj cb = connectWebViewEnterFullscreen obj cb SignalConnectAfter

connectWebViewEnterFullscreen :: (GObject a, MonadIO m) =>
                                 a -> WebViewEnterFullscreenCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewEnterFullscreen obj cb after = liftIO $ do
    cb' <- mkWebViewEnterFullscreenCallback (webViewEnterFullscreenCallbackWrapper cb)
    connectSignalFunPtr obj "enter-fullscreen" cb' after

-- signal WebView::insecure-content-detected
type WebViewInsecureContentDetectedCallback =
    InsecureContentEvent ->
    IO ()

noWebViewInsecureContentDetectedCallback :: Maybe WebViewInsecureContentDetectedCallback
noWebViewInsecureContentDetectedCallback = Nothing

type WebViewInsecureContentDetectedCallbackC =
    Ptr () ->                               -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewInsecureContentDetectedCallback :: WebViewInsecureContentDetectedCallbackC -> IO (FunPtr WebViewInsecureContentDetectedCallbackC)

webViewInsecureContentDetectedClosure :: WebViewInsecureContentDetectedCallback -> IO Closure
webViewInsecureContentDetectedClosure cb = newCClosure =<< mkWebViewInsecureContentDetectedCallback wrapped
    where wrapped = webViewInsecureContentDetectedCallbackWrapper cb

webViewInsecureContentDetectedCallbackWrapper ::
    WebViewInsecureContentDetectedCallback ->
    Ptr () ->
    CUInt ->
    Ptr () ->
    IO ()
webViewInsecureContentDetectedCallbackWrapper _cb _ event _ = do
    let event' = (toEnum . fromIntegral) event
    _cb  event'

onWebViewInsecureContentDetected :: (GObject a, MonadIO m) => a -> WebViewInsecureContentDetectedCallback -> m SignalHandlerId
onWebViewInsecureContentDetected obj cb = liftIO $ connectWebViewInsecureContentDetected obj cb SignalConnectBefore
afterWebViewInsecureContentDetected :: (GObject a, MonadIO m) => a -> WebViewInsecureContentDetectedCallback -> m SignalHandlerId
afterWebViewInsecureContentDetected obj cb = connectWebViewInsecureContentDetected obj cb SignalConnectAfter

connectWebViewInsecureContentDetected :: (GObject a, MonadIO m) =>
                                         a -> WebViewInsecureContentDetectedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewInsecureContentDetected obj cb after = liftIO $ do
    cb' <- mkWebViewInsecureContentDetectedCallback (webViewInsecureContentDetectedCallbackWrapper cb)
    connectSignalFunPtr obj "insecure-content-detected" cb' after

-- signal WebView::leave-fullscreen
type WebViewLeaveFullscreenCallback =
    IO Bool

noWebViewLeaveFullscreenCallback :: Maybe WebViewLeaveFullscreenCallback
noWebViewLeaveFullscreenCallback = Nothing

type WebViewLeaveFullscreenCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewLeaveFullscreenCallback :: WebViewLeaveFullscreenCallbackC -> IO (FunPtr WebViewLeaveFullscreenCallbackC)

webViewLeaveFullscreenClosure :: WebViewLeaveFullscreenCallback -> IO Closure
webViewLeaveFullscreenClosure cb = newCClosure =<< mkWebViewLeaveFullscreenCallback wrapped
    where wrapped = webViewLeaveFullscreenCallbackWrapper cb

webViewLeaveFullscreenCallbackWrapper ::
    WebViewLeaveFullscreenCallback ->
    Ptr () ->
    Ptr () ->
    IO CInt
webViewLeaveFullscreenCallbackWrapper _cb _ _ = do
    result <- _cb 
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewLeaveFullscreen :: (GObject a, MonadIO m) => a -> WebViewLeaveFullscreenCallback -> m SignalHandlerId
onWebViewLeaveFullscreen obj cb = liftIO $ connectWebViewLeaveFullscreen obj cb SignalConnectBefore
afterWebViewLeaveFullscreen :: (GObject a, MonadIO m) => a -> WebViewLeaveFullscreenCallback -> m SignalHandlerId
afterWebViewLeaveFullscreen obj cb = connectWebViewLeaveFullscreen obj cb SignalConnectAfter

connectWebViewLeaveFullscreen :: (GObject a, MonadIO m) =>
                                 a -> WebViewLeaveFullscreenCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewLeaveFullscreen obj cb after = liftIO $ do
    cb' <- mkWebViewLeaveFullscreenCallback (webViewLeaveFullscreenCallbackWrapper cb)
    connectSignalFunPtr obj "leave-fullscreen" cb' after

-- signal WebView::load-changed
type WebViewLoadChangedCallback =
    LoadEvent ->
    IO ()

noWebViewLoadChangedCallback :: Maybe WebViewLoadChangedCallback
noWebViewLoadChangedCallback = Nothing

type WebViewLoadChangedCallbackC =
    Ptr () ->                               -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewLoadChangedCallback :: WebViewLoadChangedCallbackC -> IO (FunPtr WebViewLoadChangedCallbackC)

webViewLoadChangedClosure :: WebViewLoadChangedCallback -> IO Closure
webViewLoadChangedClosure cb = newCClosure =<< mkWebViewLoadChangedCallback wrapped
    where wrapped = webViewLoadChangedCallbackWrapper cb

webViewLoadChangedCallbackWrapper ::
    WebViewLoadChangedCallback ->
    Ptr () ->
    CUInt ->
    Ptr () ->
    IO ()
webViewLoadChangedCallbackWrapper _cb _ loadEvent _ = do
    let loadEvent' = (toEnum . fromIntegral) loadEvent
    _cb  loadEvent'

onWebViewLoadChanged :: (GObject a, MonadIO m) => a -> WebViewLoadChangedCallback -> m SignalHandlerId
onWebViewLoadChanged obj cb = liftIO $ connectWebViewLoadChanged obj cb SignalConnectBefore
afterWebViewLoadChanged :: (GObject a, MonadIO m) => a -> WebViewLoadChangedCallback -> m SignalHandlerId
afterWebViewLoadChanged obj cb = connectWebViewLoadChanged obj cb SignalConnectAfter

connectWebViewLoadChanged :: (GObject a, MonadIO m) =>
                             a -> WebViewLoadChangedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewLoadChanged obj cb after = liftIO $ do
    cb' <- mkWebViewLoadChangedCallback (webViewLoadChangedCallbackWrapper cb)
    connectSignalFunPtr obj "load-changed" cb' after

-- signal WebView::load-failed
type WebViewLoadFailedCallback =
    LoadEvent ->
    T.Text ->
    GError ->
    IO Bool

noWebViewLoadFailedCallback :: Maybe WebViewLoadFailedCallback
noWebViewLoadFailedCallback = Nothing

type WebViewLoadFailedCallbackC =
    Ptr () ->                               -- object
    CUInt ->
    CString ->
    Ptr GError ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewLoadFailedCallback :: WebViewLoadFailedCallbackC -> IO (FunPtr WebViewLoadFailedCallbackC)

webViewLoadFailedClosure :: WebViewLoadFailedCallback -> IO Closure
webViewLoadFailedClosure cb = newCClosure =<< mkWebViewLoadFailedCallback wrapped
    where wrapped = webViewLoadFailedCallbackWrapper cb

webViewLoadFailedCallbackWrapper ::
    WebViewLoadFailedCallback ->
    Ptr () ->
    CUInt ->
    CString ->
    Ptr GError ->
    Ptr () ->
    IO CInt
webViewLoadFailedCallbackWrapper _cb _ loadEvent failingUri error_ _ = do
    let loadEvent' = (toEnum . fromIntegral) loadEvent
    failingUri' <- cstringToText failingUri
    error_' <- (newBoxed GError) error_
    result <- _cb  loadEvent' failingUri' error_'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewLoadFailed :: (GObject a, MonadIO m) => a -> WebViewLoadFailedCallback -> m SignalHandlerId
onWebViewLoadFailed obj cb = liftIO $ connectWebViewLoadFailed obj cb SignalConnectBefore
afterWebViewLoadFailed :: (GObject a, MonadIO m) => a -> WebViewLoadFailedCallback -> m SignalHandlerId
afterWebViewLoadFailed obj cb = connectWebViewLoadFailed obj cb SignalConnectAfter

connectWebViewLoadFailed :: (GObject a, MonadIO m) =>
                            a -> WebViewLoadFailedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewLoadFailed obj cb after = liftIO $ do
    cb' <- mkWebViewLoadFailedCallback (webViewLoadFailedCallbackWrapper cb)
    connectSignalFunPtr obj "load-failed" cb' after

-- signal WebView::load-failed-with-tls-errors
type WebViewLoadFailedWithTlsErrorsCallback =
    T.Text ->
    Gio.TlsCertificate ->
    [Gio.TlsCertificateFlags] ->
    IO Bool

noWebViewLoadFailedWithTlsErrorsCallback :: Maybe WebViewLoadFailedWithTlsErrorsCallback
noWebViewLoadFailedWithTlsErrorsCallback = Nothing

type WebViewLoadFailedWithTlsErrorsCallbackC =
    Ptr () ->                               -- object
    CString ->
    Ptr Gio.TlsCertificate ->
    CUInt ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewLoadFailedWithTlsErrorsCallback :: WebViewLoadFailedWithTlsErrorsCallbackC -> IO (FunPtr WebViewLoadFailedWithTlsErrorsCallbackC)

webViewLoadFailedWithTlsErrorsClosure :: WebViewLoadFailedWithTlsErrorsCallback -> IO Closure
webViewLoadFailedWithTlsErrorsClosure cb = newCClosure =<< mkWebViewLoadFailedWithTlsErrorsCallback wrapped
    where wrapped = webViewLoadFailedWithTlsErrorsCallbackWrapper cb

webViewLoadFailedWithTlsErrorsCallbackWrapper ::
    WebViewLoadFailedWithTlsErrorsCallback ->
    Ptr () ->
    CString ->
    Ptr Gio.TlsCertificate ->
    CUInt ->
    Ptr () ->
    IO CInt
webViewLoadFailedWithTlsErrorsCallbackWrapper _cb _ failingUri certificate errors _ = do
    failingUri' <- cstringToText failingUri
    certificate' <- (newObject Gio.TlsCertificate) certificate
    let errors' = wordToGFlags errors
    result <- _cb  failingUri' certificate' errors'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewLoadFailedWithTlsErrors :: (GObject a, MonadIO m) => a -> WebViewLoadFailedWithTlsErrorsCallback -> m SignalHandlerId
onWebViewLoadFailedWithTlsErrors obj cb = liftIO $ connectWebViewLoadFailedWithTlsErrors obj cb SignalConnectBefore
afterWebViewLoadFailedWithTlsErrors :: (GObject a, MonadIO m) => a -> WebViewLoadFailedWithTlsErrorsCallback -> m SignalHandlerId
afterWebViewLoadFailedWithTlsErrors obj cb = connectWebViewLoadFailedWithTlsErrors obj cb SignalConnectAfter

connectWebViewLoadFailedWithTlsErrors :: (GObject a, MonadIO m) =>
                                         a -> WebViewLoadFailedWithTlsErrorsCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewLoadFailedWithTlsErrors obj cb after = liftIO $ do
    cb' <- mkWebViewLoadFailedWithTlsErrorsCallback (webViewLoadFailedWithTlsErrorsCallbackWrapper cb)
    connectSignalFunPtr obj "load-failed-with-tls-errors" cb' after

-- signal WebView::mouse-target-changed
type WebViewMouseTargetChangedCallback =
    HitTestResult ->
    Word32 ->
    IO ()

noWebViewMouseTargetChangedCallback :: Maybe WebViewMouseTargetChangedCallback
noWebViewMouseTargetChangedCallback = Nothing

type WebViewMouseTargetChangedCallbackC =
    Ptr () ->                               -- object
    Ptr HitTestResult ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewMouseTargetChangedCallback :: WebViewMouseTargetChangedCallbackC -> IO (FunPtr WebViewMouseTargetChangedCallbackC)

webViewMouseTargetChangedClosure :: WebViewMouseTargetChangedCallback -> IO Closure
webViewMouseTargetChangedClosure cb = newCClosure =<< mkWebViewMouseTargetChangedCallback wrapped
    where wrapped = webViewMouseTargetChangedCallbackWrapper cb

webViewMouseTargetChangedCallbackWrapper ::
    WebViewMouseTargetChangedCallback ->
    Ptr () ->
    Ptr HitTestResult ->
    Word32 ->
    Ptr () ->
    IO ()
webViewMouseTargetChangedCallbackWrapper _cb _ hitTestResult modifiers _ = do
    hitTestResult' <- (newObject HitTestResult) hitTestResult
    _cb  hitTestResult' modifiers

onWebViewMouseTargetChanged :: (GObject a, MonadIO m) => a -> WebViewMouseTargetChangedCallback -> m SignalHandlerId
onWebViewMouseTargetChanged obj cb = liftIO $ connectWebViewMouseTargetChanged obj cb SignalConnectBefore
afterWebViewMouseTargetChanged :: (GObject a, MonadIO m) => a -> WebViewMouseTargetChangedCallback -> m SignalHandlerId
afterWebViewMouseTargetChanged obj cb = connectWebViewMouseTargetChanged obj cb SignalConnectAfter

connectWebViewMouseTargetChanged :: (GObject a, MonadIO m) =>
                                    a -> WebViewMouseTargetChangedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewMouseTargetChanged obj cb after = liftIO $ do
    cb' <- mkWebViewMouseTargetChangedCallback (webViewMouseTargetChangedCallbackWrapper cb)
    connectSignalFunPtr obj "mouse-target-changed" cb' after

-- signal WebView::permission-request
type WebViewPermissionRequestCallback =
    PermissionRequest ->
    IO Bool

noWebViewPermissionRequestCallback :: Maybe WebViewPermissionRequestCallback
noWebViewPermissionRequestCallback = Nothing

type WebViewPermissionRequestCallbackC =
    Ptr () ->                               -- object
    Ptr PermissionRequest ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewPermissionRequestCallback :: WebViewPermissionRequestCallbackC -> IO (FunPtr WebViewPermissionRequestCallbackC)

webViewPermissionRequestClosure :: WebViewPermissionRequestCallback -> IO Closure
webViewPermissionRequestClosure cb = newCClosure =<< mkWebViewPermissionRequestCallback wrapped
    where wrapped = webViewPermissionRequestCallbackWrapper cb

webViewPermissionRequestCallbackWrapper ::
    WebViewPermissionRequestCallback ->
    Ptr () ->
    Ptr PermissionRequest ->
    Ptr () ->
    IO CInt
webViewPermissionRequestCallbackWrapper _cb _ request _ = do
    request' <- (newObject PermissionRequest) request
    result <- _cb  request'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewPermissionRequest :: (GObject a, MonadIO m) => a -> WebViewPermissionRequestCallback -> m SignalHandlerId
onWebViewPermissionRequest obj cb = liftIO $ connectWebViewPermissionRequest obj cb SignalConnectBefore
afterWebViewPermissionRequest :: (GObject a, MonadIO m) => a -> WebViewPermissionRequestCallback -> m SignalHandlerId
afterWebViewPermissionRequest obj cb = connectWebViewPermissionRequest obj cb SignalConnectAfter

connectWebViewPermissionRequest :: (GObject a, MonadIO m) =>
                                   a -> WebViewPermissionRequestCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewPermissionRequest obj cb after = liftIO $ do
    cb' <- mkWebViewPermissionRequestCallback (webViewPermissionRequestCallbackWrapper cb)
    connectSignalFunPtr obj "permission-request" cb' after

-- signal WebView::print
type WebViewPrintCallback =
    PrintOperation ->
    IO Bool

noWebViewPrintCallback :: Maybe WebViewPrintCallback
noWebViewPrintCallback = Nothing

type WebViewPrintCallbackC =
    Ptr () ->                               -- object
    Ptr PrintOperation ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewPrintCallback :: WebViewPrintCallbackC -> IO (FunPtr WebViewPrintCallbackC)

webViewPrintClosure :: WebViewPrintCallback -> IO Closure
webViewPrintClosure cb = newCClosure =<< mkWebViewPrintCallback wrapped
    where wrapped = webViewPrintCallbackWrapper cb

webViewPrintCallbackWrapper ::
    WebViewPrintCallback ->
    Ptr () ->
    Ptr PrintOperation ->
    Ptr () ->
    IO CInt
webViewPrintCallbackWrapper _cb _ printOperation _ = do
    printOperation' <- (newObject PrintOperation) printOperation
    result <- _cb  printOperation'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewPrint :: (GObject a, MonadIO m) => a -> WebViewPrintCallback -> m SignalHandlerId
onWebViewPrint obj cb = liftIO $ connectWebViewPrint obj cb SignalConnectBefore
afterWebViewPrint :: (GObject a, MonadIO m) => a -> WebViewPrintCallback -> m SignalHandlerId
afterWebViewPrint obj cb = connectWebViewPrint obj cb SignalConnectAfter

connectWebViewPrint :: (GObject a, MonadIO m) =>
                       a -> WebViewPrintCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewPrint obj cb after = liftIO $ do
    cb' <- mkWebViewPrintCallback (webViewPrintCallbackWrapper cb)
    connectSignalFunPtr obj "print" cb' after

-- signal WebView::ready-to-show
type WebViewReadyToShowCallback =
    IO ()

noWebViewReadyToShowCallback :: Maybe WebViewReadyToShowCallback
noWebViewReadyToShowCallback = Nothing

type WebViewReadyToShowCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewReadyToShowCallback :: WebViewReadyToShowCallbackC -> IO (FunPtr WebViewReadyToShowCallbackC)

webViewReadyToShowClosure :: WebViewReadyToShowCallback -> IO Closure
webViewReadyToShowClosure cb = newCClosure =<< mkWebViewReadyToShowCallback wrapped
    where wrapped = webViewReadyToShowCallbackWrapper cb

webViewReadyToShowCallbackWrapper ::
    WebViewReadyToShowCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webViewReadyToShowCallbackWrapper _cb _ _ = do
    _cb 

onWebViewReadyToShow :: (GObject a, MonadIO m) => a -> WebViewReadyToShowCallback -> m SignalHandlerId
onWebViewReadyToShow obj cb = liftIO $ connectWebViewReadyToShow obj cb SignalConnectBefore
afterWebViewReadyToShow :: (GObject a, MonadIO m) => a -> WebViewReadyToShowCallback -> m SignalHandlerId
afterWebViewReadyToShow obj cb = connectWebViewReadyToShow obj cb SignalConnectAfter

connectWebViewReadyToShow :: (GObject a, MonadIO m) =>
                             a -> WebViewReadyToShowCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewReadyToShow obj cb after = liftIO $ do
    cb' <- mkWebViewReadyToShowCallback (webViewReadyToShowCallbackWrapper cb)
    connectSignalFunPtr obj "ready-to-show" cb' after

-- signal WebView::resource-load-started
type WebViewResourceLoadStartedCallback =
    WebResource ->
    URIRequest ->
    IO ()

noWebViewResourceLoadStartedCallback :: Maybe WebViewResourceLoadStartedCallback
noWebViewResourceLoadStartedCallback = Nothing

type WebViewResourceLoadStartedCallbackC =
    Ptr () ->                               -- object
    Ptr WebResource ->
    Ptr URIRequest ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewResourceLoadStartedCallback :: WebViewResourceLoadStartedCallbackC -> IO (FunPtr WebViewResourceLoadStartedCallbackC)

webViewResourceLoadStartedClosure :: WebViewResourceLoadStartedCallback -> IO Closure
webViewResourceLoadStartedClosure cb = newCClosure =<< mkWebViewResourceLoadStartedCallback wrapped
    where wrapped = webViewResourceLoadStartedCallbackWrapper cb

webViewResourceLoadStartedCallbackWrapper ::
    WebViewResourceLoadStartedCallback ->
    Ptr () ->
    Ptr WebResource ->
    Ptr URIRequest ->
    Ptr () ->
    IO ()
webViewResourceLoadStartedCallbackWrapper _cb _ resource request _ = do
    resource' <- (newObject WebResource) resource
    request' <- (newObject URIRequest) request
    _cb  resource' request'

onWebViewResourceLoadStarted :: (GObject a, MonadIO m) => a -> WebViewResourceLoadStartedCallback -> m SignalHandlerId
onWebViewResourceLoadStarted obj cb = liftIO $ connectWebViewResourceLoadStarted obj cb SignalConnectBefore
afterWebViewResourceLoadStarted :: (GObject a, MonadIO m) => a -> WebViewResourceLoadStartedCallback -> m SignalHandlerId
afterWebViewResourceLoadStarted obj cb = connectWebViewResourceLoadStarted obj cb SignalConnectAfter

connectWebViewResourceLoadStarted :: (GObject a, MonadIO m) =>
                                     a -> WebViewResourceLoadStartedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewResourceLoadStarted obj cb after = liftIO $ do
    cb' <- mkWebViewResourceLoadStartedCallback (webViewResourceLoadStartedCallbackWrapper cb)
    connectSignalFunPtr obj "resource-load-started" cb' after

-- signal WebView::run-as-modal
type WebViewRunAsModalCallback =
    IO ()

noWebViewRunAsModalCallback :: Maybe WebViewRunAsModalCallback
noWebViewRunAsModalCallback = Nothing

type WebViewRunAsModalCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewRunAsModalCallback :: WebViewRunAsModalCallbackC -> IO (FunPtr WebViewRunAsModalCallbackC)

webViewRunAsModalClosure :: WebViewRunAsModalCallback -> IO Closure
webViewRunAsModalClosure cb = newCClosure =<< mkWebViewRunAsModalCallback wrapped
    where wrapped = webViewRunAsModalCallbackWrapper cb

webViewRunAsModalCallbackWrapper ::
    WebViewRunAsModalCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webViewRunAsModalCallbackWrapper _cb _ _ = do
    _cb 

onWebViewRunAsModal :: (GObject a, MonadIO m) => a -> WebViewRunAsModalCallback -> m SignalHandlerId
onWebViewRunAsModal obj cb = liftIO $ connectWebViewRunAsModal obj cb SignalConnectBefore
afterWebViewRunAsModal :: (GObject a, MonadIO m) => a -> WebViewRunAsModalCallback -> m SignalHandlerId
afterWebViewRunAsModal obj cb = connectWebViewRunAsModal obj cb SignalConnectAfter

connectWebViewRunAsModal :: (GObject a, MonadIO m) =>
                            a -> WebViewRunAsModalCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewRunAsModal obj cb after = liftIO $ do
    cb' <- mkWebViewRunAsModalCallback (webViewRunAsModalCallbackWrapper cb)
    connectSignalFunPtr obj "run-as-modal" cb' after

-- signal WebView::run-color-chooser
type WebViewRunColorChooserCallback =
    ColorChooserRequest ->
    IO Bool

noWebViewRunColorChooserCallback :: Maybe WebViewRunColorChooserCallback
noWebViewRunColorChooserCallback = Nothing

type WebViewRunColorChooserCallbackC =
    Ptr () ->                               -- object
    Ptr ColorChooserRequest ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewRunColorChooserCallback :: WebViewRunColorChooserCallbackC -> IO (FunPtr WebViewRunColorChooserCallbackC)

webViewRunColorChooserClosure :: WebViewRunColorChooserCallback -> IO Closure
webViewRunColorChooserClosure cb = newCClosure =<< mkWebViewRunColorChooserCallback wrapped
    where wrapped = webViewRunColorChooserCallbackWrapper cb

webViewRunColorChooserCallbackWrapper ::
    WebViewRunColorChooserCallback ->
    Ptr () ->
    Ptr ColorChooserRequest ->
    Ptr () ->
    IO CInt
webViewRunColorChooserCallbackWrapper _cb _ request _ = do
    request' <- (newObject ColorChooserRequest) request
    result <- _cb  request'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewRunColorChooser :: (GObject a, MonadIO m) => a -> WebViewRunColorChooserCallback -> m SignalHandlerId
onWebViewRunColorChooser obj cb = liftIO $ connectWebViewRunColorChooser obj cb SignalConnectBefore
afterWebViewRunColorChooser :: (GObject a, MonadIO m) => a -> WebViewRunColorChooserCallback -> m SignalHandlerId
afterWebViewRunColorChooser obj cb = connectWebViewRunColorChooser obj cb SignalConnectAfter

connectWebViewRunColorChooser :: (GObject a, MonadIO m) =>
                                 a -> WebViewRunColorChooserCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewRunColorChooser obj cb after = liftIO $ do
    cb' <- mkWebViewRunColorChooserCallback (webViewRunColorChooserCallbackWrapper cb)
    connectSignalFunPtr obj "run-color-chooser" cb' after

-- signal WebView::run-file-chooser
type WebViewRunFileChooserCallback =
    FileChooserRequest ->
    IO Bool

noWebViewRunFileChooserCallback :: Maybe WebViewRunFileChooserCallback
noWebViewRunFileChooserCallback = Nothing

type WebViewRunFileChooserCallbackC =
    Ptr () ->                               -- object
    Ptr FileChooserRequest ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewRunFileChooserCallback :: WebViewRunFileChooserCallbackC -> IO (FunPtr WebViewRunFileChooserCallbackC)

webViewRunFileChooserClosure :: WebViewRunFileChooserCallback -> IO Closure
webViewRunFileChooserClosure cb = newCClosure =<< mkWebViewRunFileChooserCallback wrapped
    where wrapped = webViewRunFileChooserCallbackWrapper cb

webViewRunFileChooserCallbackWrapper ::
    WebViewRunFileChooserCallback ->
    Ptr () ->
    Ptr FileChooserRequest ->
    Ptr () ->
    IO CInt
webViewRunFileChooserCallbackWrapper _cb _ request _ = do
    request' <- (newObject FileChooserRequest) request
    result <- _cb  request'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewRunFileChooser :: (GObject a, MonadIO m) => a -> WebViewRunFileChooserCallback -> m SignalHandlerId
onWebViewRunFileChooser obj cb = liftIO $ connectWebViewRunFileChooser obj cb SignalConnectBefore
afterWebViewRunFileChooser :: (GObject a, MonadIO m) => a -> WebViewRunFileChooserCallback -> m SignalHandlerId
afterWebViewRunFileChooser obj cb = connectWebViewRunFileChooser obj cb SignalConnectAfter

connectWebViewRunFileChooser :: (GObject a, MonadIO m) =>
                                a -> WebViewRunFileChooserCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewRunFileChooser obj cb after = liftIO $ do
    cb' <- mkWebViewRunFileChooserCallback (webViewRunFileChooserCallbackWrapper cb)
    connectSignalFunPtr obj "run-file-chooser" cb' after

-- signal WebView::script-dialog
type WebViewScriptDialogCallback =
    ScriptDialog ->
    IO Bool

noWebViewScriptDialogCallback :: Maybe WebViewScriptDialogCallback
noWebViewScriptDialogCallback = Nothing

type WebViewScriptDialogCallbackC =
    Ptr () ->                               -- object
    Ptr ScriptDialog ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewScriptDialogCallback :: WebViewScriptDialogCallbackC -> IO (FunPtr WebViewScriptDialogCallbackC)

webViewScriptDialogClosure :: WebViewScriptDialogCallback -> IO Closure
webViewScriptDialogClosure cb = newCClosure =<< mkWebViewScriptDialogCallback wrapped
    where wrapped = webViewScriptDialogCallbackWrapper cb

webViewScriptDialogCallbackWrapper ::
    WebViewScriptDialogCallback ->
    Ptr () ->
    Ptr ScriptDialog ->
    Ptr () ->
    IO CInt
webViewScriptDialogCallbackWrapper _cb _ dialog _ = do
    dialog' <- (newBoxed ScriptDialog) dialog
    result <- _cb  dialog'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewScriptDialog :: (GObject a, MonadIO m) => a -> WebViewScriptDialogCallback -> m SignalHandlerId
onWebViewScriptDialog obj cb = liftIO $ connectWebViewScriptDialog obj cb SignalConnectBefore
afterWebViewScriptDialog :: (GObject a, MonadIO m) => a -> WebViewScriptDialogCallback -> m SignalHandlerId
afterWebViewScriptDialog obj cb = connectWebViewScriptDialog obj cb SignalConnectAfter

connectWebViewScriptDialog :: (GObject a, MonadIO m) =>
                              a -> WebViewScriptDialogCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewScriptDialog obj cb after = liftIO $ do
    cb' <- mkWebViewScriptDialogCallback (webViewScriptDialogCallbackWrapper cb)
    connectSignalFunPtr obj "script-dialog" cb' after

-- signal WebView::show-notification
type WebViewShowNotificationCallback =
    Notification ->
    IO Bool

noWebViewShowNotificationCallback :: Maybe WebViewShowNotificationCallback
noWebViewShowNotificationCallback = Nothing

type WebViewShowNotificationCallbackC =
    Ptr () ->                               -- object
    Ptr Notification ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewShowNotificationCallback :: WebViewShowNotificationCallbackC -> IO (FunPtr WebViewShowNotificationCallbackC)

webViewShowNotificationClosure :: WebViewShowNotificationCallback -> IO Closure
webViewShowNotificationClosure cb = newCClosure =<< mkWebViewShowNotificationCallback wrapped
    where wrapped = webViewShowNotificationCallbackWrapper cb

webViewShowNotificationCallbackWrapper ::
    WebViewShowNotificationCallback ->
    Ptr () ->
    Ptr Notification ->
    Ptr () ->
    IO CInt
webViewShowNotificationCallbackWrapper _cb _ notification _ = do
    notification' <- (newObject Notification) notification
    result <- _cb  notification'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewShowNotification :: (GObject a, MonadIO m) => a -> WebViewShowNotificationCallback -> m SignalHandlerId
onWebViewShowNotification obj cb = liftIO $ connectWebViewShowNotification obj cb SignalConnectBefore
afterWebViewShowNotification :: (GObject a, MonadIO m) => a -> WebViewShowNotificationCallback -> m SignalHandlerId
afterWebViewShowNotification obj cb = connectWebViewShowNotification obj cb SignalConnectAfter

connectWebViewShowNotification :: (GObject a, MonadIO m) =>
                                  a -> WebViewShowNotificationCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewShowNotification obj cb after = liftIO $ do
    cb' <- mkWebViewShowNotificationCallback (webViewShowNotificationCallbackWrapper cb)
    connectSignalFunPtr obj "show-notification" cb' after

-- signal WebView::submit-form
type WebViewSubmitFormCallback =
    FormSubmissionRequest ->
    IO ()

noWebViewSubmitFormCallback :: Maybe WebViewSubmitFormCallback
noWebViewSubmitFormCallback = Nothing

type WebViewSubmitFormCallbackC =
    Ptr () ->                               -- object
    Ptr FormSubmissionRequest ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebViewSubmitFormCallback :: WebViewSubmitFormCallbackC -> IO (FunPtr WebViewSubmitFormCallbackC)

webViewSubmitFormClosure :: WebViewSubmitFormCallback -> IO Closure
webViewSubmitFormClosure cb = newCClosure =<< mkWebViewSubmitFormCallback wrapped
    where wrapped = webViewSubmitFormCallbackWrapper cb

webViewSubmitFormCallbackWrapper ::
    WebViewSubmitFormCallback ->
    Ptr () ->
    Ptr FormSubmissionRequest ->
    Ptr () ->
    IO ()
webViewSubmitFormCallbackWrapper _cb _ request _ = do
    request' <- (newObject FormSubmissionRequest) request
    _cb  request'

onWebViewSubmitForm :: (GObject a, MonadIO m) => a -> WebViewSubmitFormCallback -> m SignalHandlerId
onWebViewSubmitForm obj cb = liftIO $ connectWebViewSubmitForm obj cb SignalConnectBefore
afterWebViewSubmitForm :: (GObject a, MonadIO m) => a -> WebViewSubmitFormCallback -> m SignalHandlerId
afterWebViewSubmitForm obj cb = connectWebViewSubmitForm obj cb SignalConnectAfter

connectWebViewSubmitForm :: (GObject a, MonadIO m) =>
                            a -> WebViewSubmitFormCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewSubmitForm obj cb after = liftIO $ do
    cb' <- mkWebViewSubmitFormCallback (webViewSubmitFormCallbackWrapper cb)
    connectSignalFunPtr obj "submit-form" cb' after

-- signal WebView::web-process-crashed
type WebViewWebProcessCrashedCallback =
    IO Bool

noWebViewWebProcessCrashedCallback :: Maybe WebViewWebProcessCrashedCallback
noWebViewWebProcessCrashedCallback = Nothing

type WebViewWebProcessCrashedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebViewWebProcessCrashedCallback :: WebViewWebProcessCrashedCallbackC -> IO (FunPtr WebViewWebProcessCrashedCallbackC)

webViewWebProcessCrashedClosure :: WebViewWebProcessCrashedCallback -> IO Closure
webViewWebProcessCrashedClosure cb = newCClosure =<< mkWebViewWebProcessCrashedCallback wrapped
    where wrapped = webViewWebProcessCrashedCallbackWrapper cb

webViewWebProcessCrashedCallbackWrapper ::
    WebViewWebProcessCrashedCallback ->
    Ptr () ->
    Ptr () ->
    IO CInt
webViewWebProcessCrashedCallbackWrapper _cb _ _ = do
    result <- _cb 
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebViewWebProcessCrashed :: (GObject a, MonadIO m) => a -> WebViewWebProcessCrashedCallback -> m SignalHandlerId
onWebViewWebProcessCrashed obj cb = liftIO $ connectWebViewWebProcessCrashed obj cb SignalConnectBefore
afterWebViewWebProcessCrashed :: (GObject a, MonadIO m) => a -> WebViewWebProcessCrashedCallback -> m SignalHandlerId
afterWebViewWebProcessCrashed obj cb = connectWebViewWebProcessCrashed obj cb SignalConnectAfter

connectWebViewWebProcessCrashed :: (GObject a, MonadIO m) =>
                                   a -> WebViewWebProcessCrashedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebViewWebProcessCrashed obj cb after = liftIO $ do
    cb' <- mkWebViewWebProcessCrashedCallback (webViewWebProcessCrashedCallbackWrapper cb)
    connectSignalFunPtr obj "web-process-crashed" cb' after

-- VVV Prop "editable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getWebViewEditable :: (MonadIO m, WebViewK o) => o -> m Bool
getWebViewEditable obj = liftIO $ getObjectPropertyBool obj "editable"

setWebViewEditable :: (MonadIO m, WebViewK o) => o -> Bool -> m ()
setWebViewEditable obj val = liftIO $ setObjectPropertyBool obj "editable" val

constructWebViewEditable :: Bool -> IO ([Char], GValue)
constructWebViewEditable val = constructObjectPropertyBool "editable" val

data WebViewEditablePropertyInfo
instance AttrInfo WebViewEditablePropertyInfo where
    type AttrAllowedOps WebViewEditablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WebViewEditablePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint WebViewEditablePropertyInfo = WebViewK
    type AttrGetType WebViewEditablePropertyInfo = Bool
    type AttrLabel WebViewEditablePropertyInfo = "editable"
    attrGet _ = getWebViewEditable
    attrSet _ = setWebViewEditable
    attrConstruct _ = constructWebViewEditable
    attrClear _ = undefined

-- VVV Prop "estimated-load-progress"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getWebViewEstimatedLoadProgress :: (MonadIO m, WebViewK o) => o -> m Double
getWebViewEstimatedLoadProgress obj = liftIO $ getObjectPropertyDouble obj "estimated-load-progress"

data WebViewEstimatedLoadProgressPropertyInfo
instance AttrInfo WebViewEstimatedLoadProgressPropertyInfo where
    type AttrAllowedOps WebViewEstimatedLoadProgressPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint WebViewEstimatedLoadProgressPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebViewEstimatedLoadProgressPropertyInfo = WebViewK
    type AttrGetType WebViewEstimatedLoadProgressPropertyInfo = Double
    type AttrLabel WebViewEstimatedLoadProgressPropertyInfo = "estimated-load-progress"
    attrGet _ = getWebViewEstimatedLoadProgress
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "favicon"
   -- Type: TBasicType TPtr
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getWebViewFavicon :: (MonadIO m, WebViewK o) => o -> m (Ptr ())
getWebViewFavicon obj = liftIO $ getObjectPropertyPtr obj "favicon"

data WebViewFaviconPropertyInfo
instance AttrInfo WebViewFaviconPropertyInfo where
    type AttrAllowedOps WebViewFaviconPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint WebViewFaviconPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebViewFaviconPropertyInfo = WebViewK
    type AttrGetType WebViewFaviconPropertyInfo = (Ptr ())
    type AttrLabel WebViewFaviconPropertyInfo = "favicon"
    attrGet _ = getWebViewFavicon
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "is-loading"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getWebViewIsLoading :: (MonadIO m, WebViewK o) => o -> m Bool
getWebViewIsLoading obj = liftIO $ getObjectPropertyBool obj "is-loading"

data WebViewIsLoadingPropertyInfo
instance AttrInfo WebViewIsLoadingPropertyInfo where
    type AttrAllowedOps WebViewIsLoadingPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint WebViewIsLoadingPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebViewIsLoadingPropertyInfo = WebViewK
    type AttrGetType WebViewIsLoadingPropertyInfo = Bool
    type AttrLabel WebViewIsLoadingPropertyInfo = "is-loading"
    attrGet _ = getWebViewIsLoading
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "is-playing-audio"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getWebViewIsPlayingAudio :: (MonadIO m, WebViewK o) => o -> m Bool
getWebViewIsPlayingAudio obj = liftIO $ getObjectPropertyBool obj "is-playing-audio"

data WebViewIsPlayingAudioPropertyInfo
instance AttrInfo WebViewIsPlayingAudioPropertyInfo where
    type AttrAllowedOps WebViewIsPlayingAudioPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint WebViewIsPlayingAudioPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebViewIsPlayingAudioPropertyInfo = WebViewK
    type AttrGetType WebViewIsPlayingAudioPropertyInfo = Bool
    type AttrLabel WebViewIsPlayingAudioPropertyInfo = "is-playing-audio"
    attrGet _ = getWebViewIsPlayingAudio
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "related-view"
   -- Type: TInterface "WebKit2" "WebView"
   -- Flags: [PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

constructWebViewRelatedView :: (WebViewK a) => a -> IO ([Char], GValue)
constructWebViewRelatedView val = constructObjectPropertyObject "related-view" (Just val)

data WebViewRelatedViewPropertyInfo
instance AttrInfo WebViewRelatedViewPropertyInfo where
    type AttrAllowedOps WebViewRelatedViewPropertyInfo = '[ 'AttrConstruct, 'AttrClear]
    type AttrSetTypeConstraint WebViewRelatedViewPropertyInfo = WebViewK
    type AttrBaseTypeConstraint WebViewRelatedViewPropertyInfo = WebViewK
    type AttrGetType WebViewRelatedViewPropertyInfo = ()
    type AttrLabel WebViewRelatedViewPropertyInfo = "related-view"
    attrGet _ = undefined
    attrSet _ = undefined
    attrConstruct _ = constructWebViewRelatedView
    attrClear _ = undefined

-- VVV Prop "settings"
   -- Type: TInterface "WebKit2" "Settings"
   -- Flags: [PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

setWebViewSettings :: (MonadIO m, WebViewK o, SettingsK a) => o -> a -> m ()
setWebViewSettings obj val = liftIO $ setObjectPropertyObject obj "settings" (Just val)

constructWebViewSettings :: (SettingsK a) => a -> IO ([Char], GValue)
constructWebViewSettings val = constructObjectPropertyObject "settings" (Just val)

data WebViewSettingsPropertyInfo
instance AttrInfo WebViewSettingsPropertyInfo where
    type AttrAllowedOps WebViewSettingsPropertyInfo = '[ 'AttrSet, 'AttrConstruct]
    type AttrSetTypeConstraint WebViewSettingsPropertyInfo = SettingsK
    type AttrBaseTypeConstraint WebViewSettingsPropertyInfo = WebViewK
    type AttrGetType WebViewSettingsPropertyInfo = ()
    type AttrLabel WebViewSettingsPropertyInfo = "settings"
    attrGet _ = undefined
    attrSet _ = setWebViewSettings
    attrConstruct _ = constructWebViewSettings
    attrClear _ = undefined

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getWebViewTitle :: (MonadIO m, WebViewK o) => o -> m T.Text
getWebViewTitle obj = liftIO $ checkUnexpectedNothing "getWebViewTitle" $ getObjectPropertyString obj "title"

data WebViewTitlePropertyInfo
instance AttrInfo WebViewTitlePropertyInfo where
    type AttrAllowedOps WebViewTitlePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebViewTitlePropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebViewTitlePropertyInfo = WebViewK
    type AttrGetType WebViewTitlePropertyInfo = T.Text
    type AttrLabel WebViewTitlePropertyInfo = "title"
    attrGet _ = getWebViewTitle
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

getWebViewUri :: (MonadIO m, WebViewK o) => o -> m (Maybe T.Text)
getWebViewUri obj = liftIO $ getObjectPropertyString obj "uri"

data WebViewUriPropertyInfo
instance AttrInfo WebViewUriPropertyInfo where
    type AttrAllowedOps WebViewUriPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebViewUriPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebViewUriPropertyInfo = WebViewK
    type AttrGetType WebViewUriPropertyInfo = (Maybe T.Text)
    type AttrLabel WebViewUriPropertyInfo = "uri"
    attrGet _ = getWebViewUri
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "user-content-manager"
   -- Type: TInterface "WebKit2" "UserContentManager"
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebViewUserContentManager :: (MonadIO m, WebViewK o) => o -> m UserContentManager
getWebViewUserContentManager obj = liftIO $ checkUnexpectedNothing "getWebViewUserContentManager" $ getObjectPropertyObject obj "user-content-manager" UserContentManager

constructWebViewUserContentManager :: (UserContentManagerK a) => a -> IO ([Char], GValue)
constructWebViewUserContentManager val = constructObjectPropertyObject "user-content-manager" (Just val)

data WebViewUserContentManagerPropertyInfo
instance AttrInfo WebViewUserContentManagerPropertyInfo where
    type AttrAllowedOps WebViewUserContentManagerPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebViewUserContentManagerPropertyInfo = UserContentManagerK
    type AttrBaseTypeConstraint WebViewUserContentManagerPropertyInfo = WebViewK
    type AttrGetType WebViewUserContentManagerPropertyInfo = UserContentManager
    type AttrLabel WebViewUserContentManagerPropertyInfo = "user-content-manager"
    attrGet _ = getWebViewUserContentManager
    attrSet _ = undefined
    attrConstruct _ = constructWebViewUserContentManager
    attrClear _ = undefined

-- VVV Prop "web-context"
   -- Type: TInterface "WebKit2" "WebContext"
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

getWebViewWebContext :: (MonadIO m, WebViewK o) => o -> m (Maybe WebContext)
getWebViewWebContext obj = liftIO $ getObjectPropertyObject obj "web-context" WebContext

constructWebViewWebContext :: (WebContextK a) => a -> IO ([Char], GValue)
constructWebViewWebContext val = constructObjectPropertyObject "web-context" (Just val)

data WebViewWebContextPropertyInfo
instance AttrInfo WebViewWebContextPropertyInfo where
    type AttrAllowedOps WebViewWebContextPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebViewWebContextPropertyInfo = WebContextK
    type AttrBaseTypeConstraint WebViewWebContextPropertyInfo = WebViewK
    type AttrGetType WebViewWebContextPropertyInfo = (Maybe WebContext)
    type AttrLabel WebViewWebContextPropertyInfo = "web-context"
    attrGet _ = getWebViewWebContext
    attrSet _ = undefined
    attrConstruct _ = constructWebViewWebContext
    attrClear _ = undefined

-- VVV Prop "zoom-level"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getWebViewZoomLevel :: (MonadIO m, WebViewK o) => o -> m Double
getWebViewZoomLevel obj = liftIO $ getObjectPropertyDouble obj "zoom-level"

setWebViewZoomLevel :: (MonadIO m, WebViewK o) => o -> Double -> m ()
setWebViewZoomLevel obj val = liftIO $ setObjectPropertyDouble obj "zoom-level" val

constructWebViewZoomLevel :: Double -> IO ([Char], GValue)
constructWebViewZoomLevel val = constructObjectPropertyDouble "zoom-level" val

data WebViewZoomLevelPropertyInfo
instance AttrInfo WebViewZoomLevelPropertyInfo where
    type AttrAllowedOps WebViewZoomLevelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WebViewZoomLevelPropertyInfo = (~) Double
    type AttrBaseTypeConstraint WebViewZoomLevelPropertyInfo = WebViewK
    type AttrGetType WebViewZoomLevelPropertyInfo = Double
    type AttrLabel WebViewZoomLevelPropertyInfo = "zoom-level"
    attrGet _ = getWebViewZoomLevel
    attrSet _ = setWebViewZoomLevel
    attrConstruct _ = constructWebViewZoomLevel
    attrClear _ = undefined

type instance AttributeList WebView = WebViewAttributeList
type WebViewAttributeList = ('[ '("appPaintable", Gtk.WidgetAppPaintablePropertyInfo), '("borderWidth", Gtk.ContainerBorderWidthPropertyInfo), '("canDefault", Gtk.WidgetCanDefaultPropertyInfo), '("canFocus", Gtk.WidgetCanFocusPropertyInfo), '("child", Gtk.ContainerChildPropertyInfo), '("compositeChild", Gtk.WidgetCompositeChildPropertyInfo), '("doubleBuffered", Gtk.WidgetDoubleBufferedPropertyInfo), '("editable", WebViewEditablePropertyInfo), '("estimatedLoadProgress", WebViewEstimatedLoadProgressPropertyInfo), '("events", Gtk.WidgetEventsPropertyInfo), '("expand", Gtk.WidgetExpandPropertyInfo), '("favicon", WebViewFaviconPropertyInfo), '("halign", Gtk.WidgetHalignPropertyInfo), '("hasDefault", Gtk.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.WidgetHexpandSetPropertyInfo), '("isFocus", Gtk.WidgetIsFocusPropertyInfo), '("isLoading", WebViewIsLoadingPropertyInfo), '("isPlayingAudio", WebViewIsPlayingAudioPropertyInfo), '("margin", Gtk.WidgetMarginPropertyInfo), '("marginBottom", Gtk.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.WidgetMarginEndPropertyInfo), '("marginLeft", Gtk.WidgetMarginLeftPropertyInfo), '("marginRight", Gtk.WidgetMarginRightPropertyInfo), '("marginStart", Gtk.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.WidgetMarginTopPropertyInfo), '("name", Gtk.WidgetNamePropertyInfo), '("noShowAll", Gtk.WidgetNoShowAllPropertyInfo), '("opacity", Gtk.WidgetOpacityPropertyInfo), '("parent", Gtk.WidgetParentPropertyInfo), '("receivesDefault", Gtk.WidgetReceivesDefaultPropertyInfo), '("relatedView", WebViewRelatedViewPropertyInfo), '("resizeMode", Gtk.ContainerResizeModePropertyInfo), '("scaleFactor", Gtk.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.WidgetSensitivePropertyInfo), '("settings", WebViewSettingsPropertyInfo), '("style", Gtk.WidgetStylePropertyInfo), '("title", WebViewTitlePropertyInfo), '("tooltipMarkup", Gtk.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.WidgetTooltipTextPropertyInfo), '("uri", WebViewUriPropertyInfo), '("userContentManager", WebViewUserContentManagerPropertyInfo), '("valign", Gtk.WidgetValignPropertyInfo), '("vexpand", Gtk.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.WidgetVexpandSetPropertyInfo), '("visible", Gtk.WidgetVisiblePropertyInfo), '("webContext", WebViewWebContextPropertyInfo), '("widthRequest", Gtk.WidgetWidthRequestPropertyInfo), '("window", Gtk.WidgetWindowPropertyInfo), '("zoomLevel", WebViewZoomLevelPropertyInfo)] :: [(Symbol, *)])

webViewEditable :: AttrLabelProxy "editable"
webViewEditable = AttrLabelProxy

webViewEstimatedLoadProgress :: AttrLabelProxy "estimatedLoadProgress"
webViewEstimatedLoadProgress = AttrLabelProxy

webViewFavicon :: AttrLabelProxy "favicon"
webViewFavicon = AttrLabelProxy

webViewRelatedView :: AttrLabelProxy "relatedView"
webViewRelatedView = AttrLabelProxy

webViewSettings :: AttrLabelProxy "settings"
webViewSettings = AttrLabelProxy

webViewTitle :: AttrLabelProxy "title"
webViewTitle = AttrLabelProxy

webViewUri :: AttrLabelProxy "uri"
webViewUri = AttrLabelProxy

webViewUserContentManager :: AttrLabelProxy "userContentManager"
webViewUserContentManager = AttrLabelProxy

webViewWebContext :: AttrLabelProxy "webContext"
webViewWebContext = AttrLabelProxy

webViewZoomLevel :: AttrLabelProxy "zoomLevel"
webViewZoomLevel = AttrLabelProxy

data WebViewAuthenticateSignalInfo
instance SignalInfo WebViewAuthenticateSignalInfo where
    type HaskellCallbackType WebViewAuthenticateSignalInfo = WebViewAuthenticateCallback
    connectSignal _ = connectWebViewAuthenticate

data WebViewCloseSignalInfo
instance SignalInfo WebViewCloseSignalInfo where
    type HaskellCallbackType WebViewCloseSignalInfo = WebViewCloseCallback
    connectSignal _ = connectWebViewClose

data WebViewContextMenuSignalInfo
instance SignalInfo WebViewContextMenuSignalInfo where
    type HaskellCallbackType WebViewContextMenuSignalInfo = WebViewContextMenuCallback
    connectSignal _ = connectWebViewContextMenu

data WebViewContextMenuDismissedSignalInfo
instance SignalInfo WebViewContextMenuDismissedSignalInfo where
    type HaskellCallbackType WebViewContextMenuDismissedSignalInfo = WebViewContextMenuDismissedCallback
    connectSignal _ = connectWebViewContextMenuDismissed

data WebViewCreateSignalInfo
instance SignalInfo WebViewCreateSignalInfo where
    type HaskellCallbackType WebViewCreateSignalInfo = WebViewCreateCallback
    connectSignal _ = connectWebViewCreate

data WebViewDecidePolicySignalInfo
instance SignalInfo WebViewDecidePolicySignalInfo where
    type HaskellCallbackType WebViewDecidePolicySignalInfo = WebViewDecidePolicyCallback
    connectSignal _ = connectWebViewDecidePolicy

data WebViewEnterFullscreenSignalInfo
instance SignalInfo WebViewEnterFullscreenSignalInfo where
    type HaskellCallbackType WebViewEnterFullscreenSignalInfo = WebViewEnterFullscreenCallback
    connectSignal _ = connectWebViewEnterFullscreen

data WebViewInsecureContentDetectedSignalInfo
instance SignalInfo WebViewInsecureContentDetectedSignalInfo where
    type HaskellCallbackType WebViewInsecureContentDetectedSignalInfo = WebViewInsecureContentDetectedCallback
    connectSignal _ = connectWebViewInsecureContentDetected

data WebViewLeaveFullscreenSignalInfo
instance SignalInfo WebViewLeaveFullscreenSignalInfo where
    type HaskellCallbackType WebViewLeaveFullscreenSignalInfo = WebViewLeaveFullscreenCallback
    connectSignal _ = connectWebViewLeaveFullscreen

data WebViewLoadChangedSignalInfo
instance SignalInfo WebViewLoadChangedSignalInfo where
    type HaskellCallbackType WebViewLoadChangedSignalInfo = WebViewLoadChangedCallback
    connectSignal _ = connectWebViewLoadChanged

data WebViewLoadFailedSignalInfo
instance SignalInfo WebViewLoadFailedSignalInfo where
    type HaskellCallbackType WebViewLoadFailedSignalInfo = WebViewLoadFailedCallback
    connectSignal _ = connectWebViewLoadFailed

data WebViewLoadFailedWithTlsErrorsSignalInfo
instance SignalInfo WebViewLoadFailedWithTlsErrorsSignalInfo where
    type HaskellCallbackType WebViewLoadFailedWithTlsErrorsSignalInfo = WebViewLoadFailedWithTlsErrorsCallback
    connectSignal _ = connectWebViewLoadFailedWithTlsErrors

data WebViewMouseTargetChangedSignalInfo
instance SignalInfo WebViewMouseTargetChangedSignalInfo where
    type HaskellCallbackType WebViewMouseTargetChangedSignalInfo = WebViewMouseTargetChangedCallback
    connectSignal _ = connectWebViewMouseTargetChanged

data WebViewPermissionRequestSignalInfo
instance SignalInfo WebViewPermissionRequestSignalInfo where
    type HaskellCallbackType WebViewPermissionRequestSignalInfo = WebViewPermissionRequestCallback
    connectSignal _ = connectWebViewPermissionRequest

data WebViewPrintSignalInfo
instance SignalInfo WebViewPrintSignalInfo where
    type HaskellCallbackType WebViewPrintSignalInfo = WebViewPrintCallback
    connectSignal _ = connectWebViewPrint

data WebViewReadyToShowSignalInfo
instance SignalInfo WebViewReadyToShowSignalInfo where
    type HaskellCallbackType WebViewReadyToShowSignalInfo = WebViewReadyToShowCallback
    connectSignal _ = connectWebViewReadyToShow

data WebViewResourceLoadStartedSignalInfo
instance SignalInfo WebViewResourceLoadStartedSignalInfo where
    type HaskellCallbackType WebViewResourceLoadStartedSignalInfo = WebViewResourceLoadStartedCallback
    connectSignal _ = connectWebViewResourceLoadStarted

data WebViewRunAsModalSignalInfo
instance SignalInfo WebViewRunAsModalSignalInfo where
    type HaskellCallbackType WebViewRunAsModalSignalInfo = WebViewRunAsModalCallback
    connectSignal _ = connectWebViewRunAsModal

data WebViewRunColorChooserSignalInfo
instance SignalInfo WebViewRunColorChooserSignalInfo where
    type HaskellCallbackType WebViewRunColorChooserSignalInfo = WebViewRunColorChooserCallback
    connectSignal _ = connectWebViewRunColorChooser

data WebViewRunFileChooserSignalInfo
instance SignalInfo WebViewRunFileChooserSignalInfo where
    type HaskellCallbackType WebViewRunFileChooserSignalInfo = WebViewRunFileChooserCallback
    connectSignal _ = connectWebViewRunFileChooser

data WebViewScriptDialogSignalInfo
instance SignalInfo WebViewScriptDialogSignalInfo where
    type HaskellCallbackType WebViewScriptDialogSignalInfo = WebViewScriptDialogCallback
    connectSignal _ = connectWebViewScriptDialog

data WebViewShowNotificationSignalInfo
instance SignalInfo WebViewShowNotificationSignalInfo where
    type HaskellCallbackType WebViewShowNotificationSignalInfo = WebViewShowNotificationCallback
    connectSignal _ = connectWebViewShowNotification

data WebViewSubmitFormSignalInfo
instance SignalInfo WebViewSubmitFormSignalInfo where
    type HaskellCallbackType WebViewSubmitFormSignalInfo = WebViewSubmitFormCallback
    connectSignal _ = connectWebViewSubmitForm

data WebViewWebProcessCrashedSignalInfo
instance SignalInfo WebViewWebProcessCrashedSignalInfo where
    type HaskellCallbackType WebViewWebProcessCrashedSignalInfo = WebViewWebProcessCrashedCallback
    connectSignal _ = connectWebViewWebProcessCrashed

type instance SignalList WebView = WebViewSignalList
type WebViewSignalList = ('[ '("accelClosuresChanged", Gtk.WidgetAccelClosuresChangedSignalInfo), '("add", Gtk.ContainerAddSignalInfo), '("authenticate", WebViewAuthenticateSignalInfo), '("buttonPressEvent", Gtk.WidgetButtonPressEventSignalInfo), '("buttonReleaseEvent", Gtk.WidgetButtonReleaseEventSignalInfo), '("canActivateAccel", Gtk.WidgetCanActivateAccelSignalInfo), '("checkResize", Gtk.ContainerCheckResizeSignalInfo), '("childNotify", Gtk.WidgetChildNotifySignalInfo), '("close", WebViewCloseSignalInfo), '("compositedChanged", Gtk.WidgetCompositedChangedSignalInfo), '("configureEvent", Gtk.WidgetConfigureEventSignalInfo), '("contextMenu", WebViewContextMenuSignalInfo), '("contextMenuDismissed", WebViewContextMenuDismissedSignalInfo), '("create", WebViewCreateSignalInfo), '("damageEvent", Gtk.WidgetDamageEventSignalInfo), '("decidePolicy", WebViewDecidePolicySignalInfo), '("deleteEvent", Gtk.WidgetDeleteEventSignalInfo), '("destroy", Gtk.WidgetDestroySignalInfo), '("destroyEvent", Gtk.WidgetDestroyEventSignalInfo), '("directionChanged", Gtk.WidgetDirectionChangedSignalInfo), '("dragBegin", Gtk.WidgetDragBeginSignalInfo), '("dragDataDelete", Gtk.WidgetDragDataDeleteSignalInfo), '("dragDataGet", Gtk.WidgetDragDataGetSignalInfo), '("dragDataReceived", Gtk.WidgetDragDataReceivedSignalInfo), '("dragDrop", Gtk.WidgetDragDropSignalInfo), '("dragEnd", Gtk.WidgetDragEndSignalInfo), '("dragFailed", Gtk.WidgetDragFailedSignalInfo), '("dragLeave", Gtk.WidgetDragLeaveSignalInfo), '("dragMotion", Gtk.WidgetDragMotionSignalInfo), '("draw", Gtk.WidgetDrawSignalInfo), '("enterFullscreen", WebViewEnterFullscreenSignalInfo), '("enterNotifyEvent", Gtk.WidgetEnterNotifyEventSignalInfo), '("event", Gtk.WidgetEventSignalInfo), '("eventAfter", Gtk.WidgetEventAfterSignalInfo), '("focus", Gtk.WidgetFocusSignalInfo), '("focusInEvent", Gtk.WidgetFocusInEventSignalInfo), '("focusOutEvent", Gtk.WidgetFocusOutEventSignalInfo), '("grabBrokenEvent", Gtk.WidgetGrabBrokenEventSignalInfo), '("grabFocus", Gtk.WidgetGrabFocusSignalInfo), '("grabNotify", Gtk.WidgetGrabNotifySignalInfo), '("hide", Gtk.WidgetHideSignalInfo), '("hierarchyChanged", Gtk.WidgetHierarchyChangedSignalInfo), '("insecureContentDetected", WebViewInsecureContentDetectedSignalInfo), '("keyPressEvent", Gtk.WidgetKeyPressEventSignalInfo), '("keyReleaseEvent", Gtk.WidgetKeyReleaseEventSignalInfo), '("keynavFailed", Gtk.WidgetKeynavFailedSignalInfo), '("leaveFullscreen", WebViewLeaveFullscreenSignalInfo), '("leaveNotifyEvent", Gtk.WidgetLeaveNotifyEventSignalInfo), '("loadChanged", WebViewLoadChangedSignalInfo), '("loadFailed", WebViewLoadFailedSignalInfo), '("loadFailedWithTlsErrors", WebViewLoadFailedWithTlsErrorsSignalInfo), '("map", Gtk.WidgetMapSignalInfo), '("mapEvent", Gtk.WidgetMapEventSignalInfo), '("mnemonicActivate", Gtk.WidgetMnemonicActivateSignalInfo), '("motionNotifyEvent", Gtk.WidgetMotionNotifyEventSignalInfo), '("mouseTargetChanged", WebViewMouseTargetChangedSignalInfo), '("moveFocus", Gtk.WidgetMoveFocusSignalInfo), '("notify", GObject.ObjectNotifySignalInfo), '("parentSet", Gtk.WidgetParentSetSignalInfo), '("permissionRequest", WebViewPermissionRequestSignalInfo), '("popupMenu", Gtk.WidgetPopupMenuSignalInfo), '("print", WebViewPrintSignalInfo), '("propertyNotifyEvent", Gtk.WidgetPropertyNotifyEventSignalInfo), '("proximityInEvent", Gtk.WidgetProximityInEventSignalInfo), '("proximityOutEvent", Gtk.WidgetProximityOutEventSignalInfo), '("queryTooltip", Gtk.WidgetQueryTooltipSignalInfo), '("readyToShow", WebViewReadyToShowSignalInfo), '("realize", Gtk.WidgetRealizeSignalInfo), '("remove", Gtk.ContainerRemoveSignalInfo), '("resourceLoadStarted", WebViewResourceLoadStartedSignalInfo), '("runAsModal", WebViewRunAsModalSignalInfo), '("runColorChooser", WebViewRunColorChooserSignalInfo), '("runFileChooser", WebViewRunFileChooserSignalInfo), '("screenChanged", Gtk.WidgetScreenChangedSignalInfo), '("scriptDialog", WebViewScriptDialogSignalInfo), '("scrollEvent", Gtk.WidgetScrollEventSignalInfo), '("selectionClearEvent", Gtk.WidgetSelectionClearEventSignalInfo), '("selectionGet", Gtk.WidgetSelectionGetSignalInfo), '("selectionNotifyEvent", Gtk.WidgetSelectionNotifyEventSignalInfo), '("selectionReceived", Gtk.WidgetSelectionReceivedSignalInfo), '("selectionRequestEvent", Gtk.WidgetSelectionRequestEventSignalInfo), '("setFocusChild", Gtk.ContainerSetFocusChildSignalInfo), '("show", Gtk.WidgetShowSignalInfo), '("showHelp", Gtk.WidgetShowHelpSignalInfo), '("showNotification", WebViewShowNotificationSignalInfo), '("sizeAllocate", Gtk.WidgetSizeAllocateSignalInfo), '("stateChanged", Gtk.WidgetStateChangedSignalInfo), '("stateFlagsChanged", Gtk.WidgetStateFlagsChangedSignalInfo), '("styleSet", Gtk.WidgetStyleSetSignalInfo), '("styleUpdated", Gtk.WidgetStyleUpdatedSignalInfo), '("submitForm", WebViewSubmitFormSignalInfo), '("touchEvent", Gtk.WidgetTouchEventSignalInfo), '("unmap", Gtk.WidgetUnmapSignalInfo), '("unmapEvent", Gtk.WidgetUnmapEventSignalInfo), '("unrealize", Gtk.WidgetUnrealizeSignalInfo), '("visibilityNotifyEvent", Gtk.WidgetVisibilityNotifyEventSignalInfo), '("webProcessCrashed", WebViewWebProcessCrashedSignalInfo), '("windowStateEvent", Gtk.WidgetWindowStateEventSignalInfo)] :: [(Symbol, *)])

-- method WebView::new
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebView")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_new" webkit_web_view_new :: 
    IO (Ptr WebView)


webViewNew ::
    (MonadIO m) =>
    m WebView                               -- result
webViewNew  = liftIO $ do
    result <- webkit_web_view_new
    checkUnexpectedReturnNULL "webkit_web_view_new" result
    result' <- (newObject WebView) result
    return result'

-- method WebView::new_with_context
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface "WebKit2" "WebContext", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebView")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_new_with_context" webkit_web_view_new_with_context :: 
    Ptr WebContext ->                       -- context : TInterface "WebKit2" "WebContext"
    IO (Ptr WebView)


webViewNewWithContext ::
    (MonadIO m, WebContextK a) =>
    a                                       -- context
    -> m WebView                            -- result
webViewNewWithContext context = liftIO $ do
    let context' = unsafeManagedPtrCastPtr context
    result <- webkit_web_view_new_with_context context'
    checkUnexpectedReturnNULL "webkit_web_view_new_with_context" result
    result' <- (newObject WebView) result
    touchManagedPtr context
    return result'

-- method WebView::new_with_settings
-- method type : Constructor
-- Args : [Arg {argCName = "settings", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebView")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_new_with_settings" webkit_web_view_new_with_settings :: 
    Ptr Settings ->                         -- settings : TInterface "WebKit2" "Settings"
    IO (Ptr WebView)


webViewNewWithSettings ::
    (MonadIO m, SettingsK a) =>
    a                                       -- settings
    -> m WebView                            -- result
webViewNewWithSettings settings = liftIO $ do
    let settings' = unsafeManagedPtrCastPtr settings
    result <- webkit_web_view_new_with_settings settings'
    checkUnexpectedReturnNULL "webkit_web_view_new_with_settings" result
    result' <- (newObject WebView) result
    touchManagedPtr settings
    return result'

-- method WebView::new_with_user_content_manager
-- method type : Constructor
-- Args : [Arg {argCName = "user_content_manager", argType = TInterface "WebKit2" "UserContentManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebView")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_new_with_user_content_manager" webkit_web_view_new_with_user_content_manager :: 
    Ptr UserContentManager ->               -- user_content_manager : TInterface "WebKit2" "UserContentManager"
    IO (Ptr WebView)


webViewNewWithUserContentManager ::
    (MonadIO m, UserContentManagerK a) =>
    a                                       -- userContentManager
    -> m WebView                            -- result
webViewNewWithUserContentManager userContentManager = liftIO $ do
    let userContentManager' = unsafeManagedPtrCastPtr userContentManager
    result <- webkit_web_view_new_with_user_content_manager userContentManager'
    checkUnexpectedReturnNULL "webkit_web_view_new_with_user_content_manager" result
    result' <- (newObject WebView) result
    touchManagedPtr userContentManager
    return result'

-- method WebView::can_execute_editing_command
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "command", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 4, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_can_execute_editing_command" webkit_web_view_can_execute_editing_command :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- command : TBasicType TUTF8
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


webViewCanExecuteEditingCommand ::
    (MonadIO m, WebViewK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> T.Text                               -- command
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
webViewCanExecuteEditingCommand _obj command cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    command' <- textToCString command
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_web_view_can_execute_editing_command _obj' command' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    freeMem command'
    return ()

data WebViewCanExecuteEditingCommandMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, WebViewK a, Gio.CancellableK b) => MethodInfo WebViewCanExecuteEditingCommandMethodInfo a signature where
    overloadedMethod _ = webViewCanExecuteEditingCommand

-- method WebView::can_execute_editing_command_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "webkit_web_view_can_execute_editing_command_finish" webkit_web_view_can_execute_editing_command_finish :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO CInt


webViewCanExecuteEditingCommandFinish ::
    (MonadIO m, WebViewK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m ()                                 -- result
webViewCanExecuteEditingCommandFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ webkit_web_view_can_execute_editing_command_finish _obj' result_'
        touchManagedPtr _obj
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

data WebViewCanExecuteEditingCommandFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, WebViewK a, Gio.AsyncResultK b) => MethodInfo WebViewCanExecuteEditingCommandFinishMethodInfo a signature where
    overloadedMethod _ = webViewCanExecuteEditingCommandFinish

-- method WebView::can_go_back
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_can_go_back" webkit_web_view_can_go_back :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CInt


webViewCanGoBack ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
webViewCanGoBack _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_can_go_back _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WebViewCanGoBackMethodInfo
instance (signature ~ (m Bool), MonadIO m, WebViewK a) => MethodInfo WebViewCanGoBackMethodInfo a signature where
    overloadedMethod _ = webViewCanGoBack

-- method WebView::can_go_forward
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_can_go_forward" webkit_web_view_can_go_forward :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CInt


webViewCanGoForward ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
webViewCanGoForward _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_can_go_forward _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WebViewCanGoForwardMethodInfo
instance (signature ~ (m Bool), MonadIO m, WebViewK a) => MethodInfo WebViewCanGoForwardMethodInfo a signature where
    overloadedMethod _ = webViewCanGoForward

-- method WebView::can_show_mime_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "mime_type", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_can_show_mime_type" webkit_web_view_can_show_mime_type :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- mime_type : TBasicType TUTF8
    IO CInt


webViewCanShowMimeType ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> T.Text                               -- mimeType
    -> m Bool                               -- result
webViewCanShowMimeType _obj mimeType = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    mimeType' <- textToCString mimeType
    result <- webkit_web_view_can_show_mime_type _obj' mimeType'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem mimeType'
    return result'

data WebViewCanShowMimeTypeMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, WebViewK a) => MethodInfo WebViewCanShowMimeTypeMethodInfo a signature where
    overloadedMethod _ = webViewCanShowMimeType

-- method WebView::download_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "Download")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_download_uri" webkit_web_view_download_uri :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- uri : TBasicType TUTF8
    IO (Ptr Download)


webViewDownloadUri ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> T.Text                               -- uri
    -> m Download                           -- result
webViewDownloadUri _obj uri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    uri' <- textToCString uri
    result <- webkit_web_view_download_uri _obj' uri'
    checkUnexpectedReturnNULL "webkit_web_view_download_uri" result
    result' <- (wrapObject Download) result
    touchManagedPtr _obj
    freeMem uri'
    return result'

data WebViewDownloadUriMethodInfo
instance (signature ~ (T.Text -> m Download), MonadIO m, WebViewK a) => MethodInfo WebViewDownloadUriMethodInfo a signature where
    overloadedMethod _ = webViewDownloadUri

-- method WebView::execute_editing_command
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "command", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_execute_editing_command" webkit_web_view_execute_editing_command :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- command : TBasicType TUTF8
    IO ()


webViewExecuteEditingCommand ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> T.Text                               -- command
    -> m ()                                 -- result
webViewExecuteEditingCommand _obj command = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    command' <- textToCString command
    webkit_web_view_execute_editing_command _obj' command'
    touchManagedPtr _obj
    freeMem command'
    return ()

data WebViewExecuteEditingCommandMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewExecuteEditingCommandMethodInfo a signature where
    overloadedMethod _ = webViewExecuteEditingCommand

-- method WebView::execute_editing_command_with_argument
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "command", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "argument", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_execute_editing_command_with_argument" webkit_web_view_execute_editing_command_with_argument :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- command : TBasicType TUTF8
    CString ->                              -- argument : TBasicType TUTF8
    IO ()


webViewExecuteEditingCommandWithArgument ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> T.Text                               -- command
    -> T.Text                               -- argument
    -> m ()                                 -- result
webViewExecuteEditingCommandWithArgument _obj command argument = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    command' <- textToCString command
    argument' <- textToCString argument
    webkit_web_view_execute_editing_command_with_argument _obj' command' argument'
    touchManagedPtr _obj
    freeMem command'
    freeMem argument'
    return ()

data WebViewExecuteEditingCommandWithArgumentMethodInfo
instance (signature ~ (T.Text -> T.Text -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewExecuteEditingCommandWithArgumentMethodInfo a signature where
    overloadedMethod _ = webViewExecuteEditingCommandWithArgument

-- method WebView::get_back_forward_list
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "BackForwardList")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_back_forward_list" webkit_web_view_get_back_forward_list :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr BackForwardList)


webViewGetBackForwardList ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m BackForwardList                    -- result
webViewGetBackForwardList _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_back_forward_list _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_back_forward_list" result
    result' <- (newObject BackForwardList) result
    touchManagedPtr _obj
    return result'

data WebViewGetBackForwardListMethodInfo
instance (signature ~ (m BackForwardList), MonadIO m, WebViewK a) => MethodInfo WebViewGetBackForwardListMethodInfo a signature where
    overloadedMethod _ = webViewGetBackForwardList

-- method WebView::get_background_color
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "rgba", argType = TInterface "Gdk" "RGBA", direction = DirectionOut, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = True, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_background_color" webkit_web_view_get_background_color :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gdk.RGBA ->                         -- rgba : TInterface "Gdk" "RGBA"
    IO ()


webViewGetBackgroundColor ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m (Gdk.RGBA)                         -- result
webViewGetBackgroundColor _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    rgba <- callocBoxedBytes 32 :: IO (Ptr Gdk.RGBA)
    webkit_web_view_get_background_color _obj' rgba
    rgba' <- (wrapBoxed Gdk.RGBA) rgba
    touchManagedPtr _obj
    return rgba'

data WebViewGetBackgroundColorMethodInfo
instance (signature ~ (m (Gdk.RGBA)), MonadIO m, WebViewK a) => MethodInfo WebViewGetBackgroundColorMethodInfo a signature where
    overloadedMethod _ = webViewGetBackgroundColor

-- method WebView::get_context
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebContext")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_context" webkit_web_view_get_context :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr WebContext)


webViewGetContext ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m WebContext                         -- result
webViewGetContext _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_context _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_context" result
    result' <- (newObject WebContext) result
    touchManagedPtr _obj
    return result'

data WebViewGetContextMethodInfo
instance (signature ~ (m WebContext), MonadIO m, WebViewK a) => MethodInfo WebViewGetContextMethodInfo a signature where
    overloadedMethod _ = webViewGetContext

-- method WebView::get_custom_charset
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_custom_charset" webkit_web_view_get_custom_charset :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CString


webViewGetCustomCharset ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
webViewGetCustomCharset _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_custom_charset _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_custom_charset" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebViewGetCustomCharsetMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebViewK a) => MethodInfo WebViewGetCustomCharsetMethodInfo a signature where
    overloadedMethod _ = webViewGetCustomCharset

-- method WebView::get_editor_state
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "EditorState")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_editor_state" webkit_web_view_get_editor_state :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr EditorState)


webViewGetEditorState ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m EditorState                        -- result
webViewGetEditorState _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_editor_state _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_editor_state" result
    result' <- (newObject EditorState) result
    touchManagedPtr _obj
    return result'

data WebViewGetEditorStateMethodInfo
instance (signature ~ (m EditorState), MonadIO m, WebViewK a) => MethodInfo WebViewGetEditorStateMethodInfo a signature where
    overloadedMethod _ = webViewGetEditorState

-- method WebView::get_estimated_load_progress
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_estimated_load_progress" webkit_web_view_get_estimated_load_progress :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CDouble


webViewGetEstimatedLoadProgress ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Double                             -- result
webViewGetEstimatedLoadProgress _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_estimated_load_progress _obj'
    let result' = realToFrac result
    touchManagedPtr _obj
    return result'

data WebViewGetEstimatedLoadProgressMethodInfo
instance (signature ~ (m Double), MonadIO m, WebViewK a) => MethodInfo WebViewGetEstimatedLoadProgressMethodInfo a signature where
    overloadedMethod _ = webViewGetEstimatedLoadProgress

-- method WebView::get_favicon
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "cairo" "Surface")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_favicon" webkit_web_view_get_favicon :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr Cairo.Surface)


webViewGetFavicon ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Cairo.Surface                      -- result
webViewGetFavicon _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_favicon _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_favicon" result
    result' <- (newBoxed Cairo.Surface) result
    touchManagedPtr _obj
    return result'

data WebViewGetFaviconMethodInfo
instance (signature ~ (m Cairo.Surface), MonadIO m, WebViewK a) => MethodInfo WebViewGetFaviconMethodInfo a signature where
    overloadedMethod _ = webViewGetFavicon

-- method WebView::get_find_controller
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "FindController")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_find_controller" webkit_web_view_get_find_controller :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr FindController)


webViewGetFindController ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m FindController                     -- result
webViewGetFindController _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_find_controller _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_find_controller" result
    result' <- (newObject FindController) result
    touchManagedPtr _obj
    return result'

data WebViewGetFindControllerMethodInfo
instance (signature ~ (m FindController), MonadIO m, WebViewK a) => MethodInfo WebViewGetFindControllerMethodInfo a signature where
    overloadedMethod _ = webViewGetFindController

-- method WebView::get_inspector
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebInspector")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_inspector" webkit_web_view_get_inspector :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr WebInspector)


webViewGetInspector ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m WebInspector                       -- result
webViewGetInspector _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_inspector _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_inspector" result
    result' <- (newObject WebInspector) result
    touchManagedPtr _obj
    return result'

data WebViewGetInspectorMethodInfo
instance (signature ~ (m WebInspector), MonadIO m, WebViewK a) => MethodInfo WebViewGetInspectorMethodInfo a signature where
    overloadedMethod _ = webViewGetInspector

-- method WebView::get_javascript_global_context
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "JavaScriptCore" "GlobalContext")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_javascript_global_context" webkit_web_view_get_javascript_global_context :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr JavaScriptCore.GlobalContext)


webViewGetJavascriptGlobalContext ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m JavaScriptCore.GlobalContext       -- result
webViewGetJavascriptGlobalContext _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_javascript_global_context _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_javascript_global_context" result
    -- XXX Wrapping a foreign struct/union with no known destructor, leak?
    result' <- (\x -> JavaScriptCore.GlobalContext <$> newForeignPtr_ x) result
    touchManagedPtr _obj
    return result'

data WebViewGetJavascriptGlobalContextMethodInfo
instance (signature ~ (m JavaScriptCore.GlobalContext), MonadIO m, WebViewK a) => MethodInfo WebViewGetJavascriptGlobalContextMethodInfo a signature where
    overloadedMethod _ = webViewGetJavascriptGlobalContext

-- method WebView::get_main_resource
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebResource")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_main_resource" webkit_web_view_get_main_resource :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr WebResource)


webViewGetMainResource ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m WebResource                        -- result
webViewGetMainResource _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_main_resource _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_main_resource" result
    result' <- (newObject WebResource) result
    touchManagedPtr _obj
    return result'

data WebViewGetMainResourceMethodInfo
instance (signature ~ (m WebResource), MonadIO m, WebViewK a) => MethodInfo WebViewGetMainResourceMethodInfo a signature where
    overloadedMethod _ = webViewGetMainResource

-- method WebView::get_page_id
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt64)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_page_id" webkit_web_view_get_page_id :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO Word64


webViewGetPageId ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Word64                             -- result
webViewGetPageId _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_page_id _obj'
    touchManagedPtr _obj
    return result

data WebViewGetPageIdMethodInfo
instance (signature ~ (m Word64), MonadIO m, WebViewK a) => MethodInfo WebViewGetPageIdMethodInfo a signature where
    overloadedMethod _ = webViewGetPageId

-- method WebView::get_session_state
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebViewSessionState")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_session_state" webkit_web_view_get_session_state :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr WebViewSessionState)


webViewGetSessionState ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m WebViewSessionState                -- result
webViewGetSessionState _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_session_state _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_session_state" result
    result' <- (wrapBoxed WebViewSessionState) result
    touchManagedPtr _obj
    return result'

data WebViewGetSessionStateMethodInfo
instance (signature ~ (m WebViewSessionState), MonadIO m, WebViewK a) => MethodInfo WebViewGetSessionStateMethodInfo a signature where
    overloadedMethod _ = webViewGetSessionState

-- method WebView::get_settings
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "Settings")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_settings" webkit_web_view_get_settings :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr Settings)


webViewGetSettings ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Settings                           -- result
webViewGetSettings _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_settings _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_settings" result
    result' <- (newObject Settings) result
    touchManagedPtr _obj
    return result'

data WebViewGetSettingsMethodInfo
instance (signature ~ (m Settings), MonadIO m, WebViewK a) => MethodInfo WebViewGetSettingsMethodInfo a signature where
    overloadedMethod _ = webViewGetSettings

-- method WebView::get_snapshot
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "region", argType = TInterface "WebKit2" "SnapshotRegion", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "options", argType = TInterface "WebKit2" "SnapshotOptions", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 5, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_snapshot" webkit_web_view_get_snapshot :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CUInt ->                                -- region : TInterface "WebKit2" "SnapshotRegion"
    CUInt ->                                -- options : TInterface "WebKit2" "SnapshotOptions"
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


webViewGetSnapshot ::
    (MonadIO m, WebViewK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> SnapshotRegion                       -- region
    -> [SnapshotOptions]                    -- options
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
webViewGetSnapshot _obj region options cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let region' = (fromIntegral . fromEnum) region
    let options' = gflagsToWord options
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_web_view_get_snapshot _obj' region' options' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    return ()

data WebViewGetSnapshotMethodInfo
instance (signature ~ (SnapshotRegion -> [SnapshotOptions] -> Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, WebViewK a, Gio.CancellableK b) => MethodInfo WebViewGetSnapshotMethodInfo a signature where
    overloadedMethod _ = webViewGetSnapshot

-- method WebView::get_snapshot_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "cairo" "Surface")
-- throws : True
-- Skip return : False

foreign import ccall "webkit_web_view_get_snapshot_finish" webkit_web_view_get_snapshot_finish :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Cairo.Surface)


webViewGetSnapshotFinish ::
    (MonadIO m, WebViewK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m Cairo.Surface                      -- result
webViewGetSnapshotFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ webkit_web_view_get_snapshot_finish _obj' result_'
        checkUnexpectedReturnNULL "webkit_web_view_get_snapshot_finish" result
        result' <- (wrapBoxed Cairo.Surface) result
        touchManagedPtr _obj
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

data WebViewGetSnapshotFinishMethodInfo
instance (signature ~ (b -> m Cairo.Surface), MonadIO m, WebViewK a, Gio.AsyncResultK b) => MethodInfo WebViewGetSnapshotFinishMethodInfo a signature where
    overloadedMethod _ = webViewGetSnapshotFinish

-- method WebView::get_title
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_title" webkit_web_view_get_title :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CString


webViewGetTitle ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
webViewGetTitle _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_title _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_title" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebViewGetTitleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebViewK a) => MethodInfo WebViewGetTitleMethodInfo a signature where
    overloadedMethod _ = webViewGetTitle

-- method WebView::get_tls_info
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "certificate", argType = TInterface "Gio" "TlsCertificate", direction = DirectionOut, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "errors", argType = TInterface "Gio" "TlsCertificateFlags", direction = DirectionOut, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferEverything}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_tls_info" webkit_web_view_get_tls_info :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr (Ptr Gio.TlsCertificate) ->         -- certificate : TInterface "Gio" "TlsCertificate"
    Ptr CUInt ->                            -- errors : TInterface "Gio" "TlsCertificateFlags"
    IO CInt


webViewGetTlsInfo ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m (Bool,Gio.TlsCertificate,[Gio.TlsCertificateFlags])-- result
webViewGetTlsInfo _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    certificate <- allocMem :: IO (Ptr (Ptr Gio.TlsCertificate))
    errors <- allocMem :: IO (Ptr CUInt)
    result <- webkit_web_view_get_tls_info _obj' certificate errors
    let result' = (/= 0) result
    certificate' <- peek certificate
    certificate'' <- (newObject Gio.TlsCertificate) certificate'
    errors' <- peek errors
    let errors'' = wordToGFlags errors'
    touchManagedPtr _obj
    freeMem certificate
    freeMem errors
    return (result', certificate'', errors'')

data WebViewGetTlsInfoMethodInfo
instance (signature ~ (m (Bool,Gio.TlsCertificate,[Gio.TlsCertificateFlags])), MonadIO m, WebViewK a) => MethodInfo WebViewGetTlsInfoMethodInfo a signature where
    overloadedMethod _ = webViewGetTlsInfo

-- method WebView::get_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_uri" webkit_web_view_get_uri :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CString


webViewGetUri ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m (Maybe T.Text)                     -- result
webViewGetUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_uri _obj'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr _obj
    return maybeResult

data WebViewGetUriMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, WebViewK a) => MethodInfo WebViewGetUriMethodInfo a signature where
    overloadedMethod _ = webViewGetUri

-- method WebView::get_user_content_manager
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "UserContentManager")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_user_content_manager" webkit_web_view_get_user_content_manager :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr UserContentManager)


webViewGetUserContentManager ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m UserContentManager                 -- result
webViewGetUserContentManager _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_user_content_manager _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_user_content_manager" result
    result' <- (newObject UserContentManager) result
    touchManagedPtr _obj
    return result'

data WebViewGetUserContentManagerMethodInfo
instance (signature ~ (m UserContentManager), MonadIO m, WebViewK a) => MethodInfo WebViewGetUserContentManagerMethodInfo a signature where
    overloadedMethod _ = webViewGetUserContentManager

-- method WebView::get_window_properties
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WindowProperties")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_window_properties" webkit_web_view_get_window_properties :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr WindowProperties)


webViewGetWindowProperties ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m WindowProperties                   -- result
webViewGetWindowProperties _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_window_properties _obj'
    checkUnexpectedReturnNULL "webkit_web_view_get_window_properties" result
    result' <- (newObject WindowProperties) result
    touchManagedPtr _obj
    return result'

data WebViewGetWindowPropertiesMethodInfo
instance (signature ~ (m WindowProperties), MonadIO m, WebViewK a) => MethodInfo WebViewGetWindowPropertiesMethodInfo a signature where
    overloadedMethod _ = webViewGetWindowProperties

-- method WebView::get_zoom_level
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_get_zoom_level" webkit_web_view_get_zoom_level :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CDouble


webViewGetZoomLevel ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Double                             -- result
webViewGetZoomLevel _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_get_zoom_level _obj'
    let result' = realToFrac result
    touchManagedPtr _obj
    return result'

data WebViewGetZoomLevelMethodInfo
instance (signature ~ (m Double), MonadIO m, WebViewK a) => MethodInfo WebViewGetZoomLevelMethodInfo a signature where
    overloadedMethod _ = webViewGetZoomLevel

-- method WebView::go_back
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_go_back" webkit_web_view_go_back :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO ()


webViewGoBack ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webViewGoBack _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_view_go_back _obj'
    touchManagedPtr _obj
    return ()

data WebViewGoBackMethodInfo
instance (signature ~ (m ()), MonadIO m, WebViewK a) => MethodInfo WebViewGoBackMethodInfo a signature where
    overloadedMethod _ = webViewGoBack

-- method WebView::go_forward
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_go_forward" webkit_web_view_go_forward :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO ()


webViewGoForward ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webViewGoForward _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_view_go_forward _obj'
    touchManagedPtr _obj
    return ()

data WebViewGoForwardMethodInfo
instance (signature ~ (m ()), MonadIO m, WebViewK a) => MethodInfo WebViewGoForwardMethodInfo a signature where
    overloadedMethod _ = webViewGoForward

-- method WebView::go_to_back_forward_list_item
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "list_item", argType = TInterface "WebKit2" "BackForwardListItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_go_to_back_forward_list_item" webkit_web_view_go_to_back_forward_list_item :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr BackForwardListItem ->              -- list_item : TInterface "WebKit2" "BackForwardListItem"
    IO ()


webViewGoToBackForwardListItem ::
    (MonadIO m, WebViewK a, BackForwardListItemK b) =>
    a                                       -- _obj
    -> b                                    -- listItem
    -> m ()                                 -- result
webViewGoToBackForwardListItem _obj listItem = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let listItem' = unsafeManagedPtrCastPtr listItem
    webkit_web_view_go_to_back_forward_list_item _obj' listItem'
    touchManagedPtr _obj
    touchManagedPtr listItem
    return ()

data WebViewGoToBackForwardListItemMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, WebViewK a, BackForwardListItemK b) => MethodInfo WebViewGoToBackForwardListItemMethodInfo a signature where
    overloadedMethod _ = webViewGoToBackForwardListItem

-- method WebView::is_editable
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_is_editable" webkit_web_view_is_editable :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CInt


webViewIsEditable ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
webViewIsEditable _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_is_editable _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WebViewIsEditableMethodInfo
instance (signature ~ (m Bool), MonadIO m, WebViewK a) => MethodInfo WebViewIsEditableMethodInfo a signature where
    overloadedMethod _ = webViewIsEditable

-- method WebView::is_loading
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_is_loading" webkit_web_view_is_loading :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CInt


webViewIsLoading ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
webViewIsLoading _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_is_loading _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WebViewIsLoadingMethodInfo
instance (signature ~ (m Bool), MonadIO m, WebViewK a) => MethodInfo WebViewIsLoadingMethodInfo a signature where
    overloadedMethod _ = webViewIsLoading

-- method WebView::is_playing_audio
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_is_playing_audio" webkit_web_view_is_playing_audio :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO CInt


webViewIsPlayingAudio ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
webViewIsPlayingAudio _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_is_playing_audio _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WebViewIsPlayingAudioMethodInfo
instance (signature ~ (m Bool), MonadIO m, WebViewK a) => MethodInfo WebViewIsPlayingAudioMethodInfo a signature where
    overloadedMethod _ = webViewIsPlayingAudio

-- method WebView::load_alternate_html
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "content", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "content_uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "base_uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_load_alternate_html" webkit_web_view_load_alternate_html :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- content : TBasicType TUTF8
    CString ->                              -- content_uri : TBasicType TUTF8
    CString ->                              -- base_uri : TBasicType TUTF8
    IO ()


webViewLoadAlternateHtml ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> T.Text                               -- content
    -> T.Text                               -- contentUri
    -> Maybe (T.Text)                       -- baseUri
    -> m ()                                 -- result
webViewLoadAlternateHtml _obj content contentUri baseUri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    content' <- textToCString content
    contentUri' <- textToCString contentUri
    maybeBaseUri <- case baseUri of
        Nothing -> return nullPtr
        Just jBaseUri -> do
            jBaseUri' <- textToCString jBaseUri
            return jBaseUri'
    webkit_web_view_load_alternate_html _obj' content' contentUri' maybeBaseUri
    touchManagedPtr _obj
    freeMem content'
    freeMem contentUri'
    freeMem maybeBaseUri
    return ()

data WebViewLoadAlternateHtmlMethodInfo
instance (signature ~ (T.Text -> T.Text -> Maybe (T.Text) -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewLoadAlternateHtmlMethodInfo a signature where
    overloadedMethod _ = webViewLoadAlternateHtml

-- method WebView::load_bytes
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "bytes", argType = TInterface "GLib" "Bytes", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "mime_type", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "encoding", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "base_uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_load_bytes" webkit_web_view_load_bytes :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr GLib.Bytes ->                       -- bytes : TInterface "GLib" "Bytes"
    CString ->                              -- mime_type : TBasicType TUTF8
    CString ->                              -- encoding : TBasicType TUTF8
    CString ->                              -- base_uri : TBasicType TUTF8
    IO ()


webViewLoadBytes ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> GLib.Bytes                           -- bytes
    -> Maybe (T.Text)                       -- mimeType
    -> Maybe (T.Text)                       -- encoding
    -> Maybe (T.Text)                       -- baseUri
    -> m ()                                 -- result
webViewLoadBytes _obj bytes mimeType encoding baseUri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let bytes' = unsafeManagedPtrGetPtr bytes
    maybeMimeType <- case mimeType of
        Nothing -> return nullPtr
        Just jMimeType -> do
            jMimeType' <- textToCString jMimeType
            return jMimeType'
    maybeEncoding <- case encoding of
        Nothing -> return nullPtr
        Just jEncoding -> do
            jEncoding' <- textToCString jEncoding
            return jEncoding'
    maybeBaseUri <- case baseUri of
        Nothing -> return nullPtr
        Just jBaseUri -> do
            jBaseUri' <- textToCString jBaseUri
            return jBaseUri'
    webkit_web_view_load_bytes _obj' bytes' maybeMimeType maybeEncoding maybeBaseUri
    touchManagedPtr _obj
    touchManagedPtr bytes
    freeMem maybeMimeType
    freeMem maybeEncoding
    freeMem maybeBaseUri
    return ()

data WebViewLoadBytesMethodInfo
instance (signature ~ (GLib.Bytes -> Maybe (T.Text) -> Maybe (T.Text) -> Maybe (T.Text) -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewLoadBytesMethodInfo a signature where
    overloadedMethod _ = webViewLoadBytes

-- method WebView::load_html
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "content", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "base_uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_load_html" webkit_web_view_load_html :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- content : TBasicType TUTF8
    CString ->                              -- base_uri : TBasicType TUTF8
    IO ()


webViewLoadHtml ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> T.Text                               -- content
    -> Maybe (T.Text)                       -- baseUri
    -> m ()                                 -- result
webViewLoadHtml _obj content baseUri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    content' <- textToCString content
    maybeBaseUri <- case baseUri of
        Nothing -> return nullPtr
        Just jBaseUri -> do
            jBaseUri' <- textToCString jBaseUri
            return jBaseUri'
    webkit_web_view_load_html _obj' content' maybeBaseUri
    touchManagedPtr _obj
    freeMem content'
    freeMem maybeBaseUri
    return ()

data WebViewLoadHtmlMethodInfo
instance (signature ~ (T.Text -> Maybe (T.Text) -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewLoadHtmlMethodInfo a signature where
    overloadedMethod _ = webViewLoadHtml

-- method WebView::load_plain_text
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "plain_text", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_load_plain_text" webkit_web_view_load_plain_text :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- plain_text : TBasicType TUTF8
    IO ()


webViewLoadPlainText ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> T.Text                               -- plainText
    -> m ()                                 -- result
webViewLoadPlainText _obj plainText = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    plainText' <- textToCString plainText
    webkit_web_view_load_plain_text _obj' plainText'
    touchManagedPtr _obj
    freeMem plainText'
    return ()

data WebViewLoadPlainTextMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewLoadPlainTextMethodInfo a signature where
    overloadedMethod _ = webViewLoadPlainText

-- method WebView::load_request
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "request", argType = TInterface "WebKit2" "URIRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_load_request" webkit_web_view_load_request :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr URIRequest ->                       -- request : TInterface "WebKit2" "URIRequest"
    IO ()


webViewLoadRequest ::
    (MonadIO m, WebViewK a, URIRequestK b) =>
    a                                       -- _obj
    -> b                                    -- request
    -> m ()                                 -- result
webViewLoadRequest _obj request = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let request' = unsafeManagedPtrCastPtr request
    webkit_web_view_load_request _obj' request'
    touchManagedPtr _obj
    touchManagedPtr request
    return ()

data WebViewLoadRequestMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, WebViewK a, URIRequestK b) => MethodInfo WebViewLoadRequestMethodInfo a signature where
    overloadedMethod _ = webViewLoadRequest

-- method WebView::load_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_load_uri" webkit_web_view_load_uri :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- uri : TBasicType TUTF8
    IO ()


webViewLoadUri ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> T.Text                               -- uri
    -> m ()                                 -- result
webViewLoadUri _obj uri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    uri' <- textToCString uri
    webkit_web_view_load_uri _obj' uri'
    touchManagedPtr _obj
    freeMem uri'
    return ()

data WebViewLoadUriMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewLoadUriMethodInfo a signature where
    overloadedMethod _ = webViewLoadUri

-- method WebView::new_with_related_view
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "Gtk" "Widget")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_new_with_related_view" webkit_web_view_new_with_related_view :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO (Ptr Gtk.Widget)


webViewNewWithRelatedView ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m Gtk.Widget                         -- result
webViewNewWithRelatedView _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_view_new_with_related_view _obj'
    checkUnexpectedReturnNULL "webkit_web_view_new_with_related_view" result
    result' <- (wrapObject Gtk.Widget) result
    touchManagedPtr _obj
    return result'

data WebViewNewWithRelatedViewMethodInfo
instance (signature ~ (m Gtk.Widget), MonadIO m, WebViewK a) => MethodInfo WebViewNewWithRelatedViewMethodInfo a signature where
    overloadedMethod _ = webViewNewWithRelatedView

-- method WebView::reload
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_reload" webkit_web_view_reload :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO ()


webViewReload ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webViewReload _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_view_reload _obj'
    touchManagedPtr _obj
    return ()

data WebViewReloadMethodInfo
instance (signature ~ (m ()), MonadIO m, WebViewK a) => MethodInfo WebViewReloadMethodInfo a signature where
    overloadedMethod _ = webViewReload

-- method WebView::reload_bypass_cache
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_reload_bypass_cache" webkit_web_view_reload_bypass_cache :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO ()


webViewReloadBypassCache ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webViewReloadBypassCache _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_view_reload_bypass_cache _obj'
    touchManagedPtr _obj
    return ()

data WebViewReloadBypassCacheMethodInfo
instance (signature ~ (m ()), MonadIO m, WebViewK a) => MethodInfo WebViewReloadBypassCacheMethodInfo a signature where
    overloadedMethod _ = webViewReloadBypassCache

-- method WebView::restore_session_state
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "state", argType = TInterface "WebKit2" "WebViewSessionState", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_restore_session_state" webkit_web_view_restore_session_state :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr WebViewSessionState ->              -- state : TInterface "WebKit2" "WebViewSessionState"
    IO ()


webViewRestoreSessionState ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> WebViewSessionState                  -- state
    -> m ()                                 -- result
webViewRestoreSessionState _obj state = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let state' = unsafeManagedPtrGetPtr state
    webkit_web_view_restore_session_state _obj' state'
    touchManagedPtr _obj
    touchManagedPtr state
    return ()

data WebViewRestoreSessionStateMethodInfo
instance (signature ~ (WebViewSessionState -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewRestoreSessionStateMethodInfo a signature where
    overloadedMethod _ = webViewRestoreSessionState

-- method WebView::run_javascript
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "script", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 4, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_run_javascript" webkit_web_view_run_javascript :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- script : TBasicType TUTF8
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


webViewRunJavascript ::
    (MonadIO m, WebViewK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> T.Text                               -- script
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
webViewRunJavascript _obj script cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    script' <- textToCString script
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_web_view_run_javascript _obj' script' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    freeMem script'
    return ()

data WebViewRunJavascriptMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, WebViewK a, Gio.CancellableK b) => MethodInfo WebViewRunJavascriptMethodInfo a signature where
    overloadedMethod _ = webViewRunJavascript

-- method WebView::run_javascript_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "JavascriptResult")
-- throws : True
-- Skip return : False

foreign import ccall "webkit_web_view_run_javascript_finish" webkit_web_view_run_javascript_finish :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr JavascriptResult)


webViewRunJavascriptFinish ::
    (MonadIO m, WebViewK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m JavascriptResult                   -- result
webViewRunJavascriptFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ webkit_web_view_run_javascript_finish _obj' result_'
        checkUnexpectedReturnNULL "webkit_web_view_run_javascript_finish" result
        result' <- (wrapBoxed JavascriptResult) result
        touchManagedPtr _obj
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

data WebViewRunJavascriptFinishMethodInfo
instance (signature ~ (b -> m JavascriptResult), MonadIO m, WebViewK a, Gio.AsyncResultK b) => MethodInfo WebViewRunJavascriptFinishMethodInfo a signature where
    overloadedMethod _ = webViewRunJavascriptFinish

-- method WebView::run_javascript_from_gresource
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "resource", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 4, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_run_javascript_from_gresource" webkit_web_view_run_javascript_from_gresource :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- resource : TBasicType TUTF8
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


webViewRunJavascriptFromGresource ::
    (MonadIO m, WebViewK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> T.Text                               -- resource
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
webViewRunJavascriptFromGresource _obj resource cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    resource' <- textToCString resource
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_web_view_run_javascript_from_gresource _obj' resource' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    freeMem resource'
    return ()

data WebViewRunJavascriptFromGresourceMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, WebViewK a, Gio.CancellableK b) => MethodInfo WebViewRunJavascriptFromGresourceMethodInfo a signature where
    overloadedMethod _ = webViewRunJavascriptFromGresource

-- method WebView::run_javascript_from_gresource_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "JavascriptResult")
-- throws : True
-- Skip return : False

foreign import ccall "webkit_web_view_run_javascript_from_gresource_finish" webkit_web_view_run_javascript_from_gresource_finish :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr JavascriptResult)


webViewRunJavascriptFromGresourceFinish ::
    (MonadIO m, WebViewK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m JavascriptResult                   -- result
webViewRunJavascriptFromGresourceFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ webkit_web_view_run_javascript_from_gresource_finish _obj' result_'
        checkUnexpectedReturnNULL "webkit_web_view_run_javascript_from_gresource_finish" result
        result' <- (wrapBoxed JavascriptResult) result
        touchManagedPtr _obj
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

data WebViewRunJavascriptFromGresourceFinishMethodInfo
instance (signature ~ (b -> m JavascriptResult), MonadIO m, WebViewK a, Gio.AsyncResultK b) => MethodInfo WebViewRunJavascriptFromGresourceFinishMethodInfo a signature where
    overloadedMethod _ = webViewRunJavascriptFromGresourceFinish

-- method WebView::save
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "save_mode", argType = TInterface "WebKit2" "SaveMode", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 4, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_save" webkit_web_view_save :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CUInt ->                                -- save_mode : TInterface "WebKit2" "SaveMode"
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


webViewSave ::
    (MonadIO m, WebViewK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> SaveMode                             -- saveMode
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
webViewSave _obj saveMode cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let saveMode' = (fromIntegral . fromEnum) saveMode
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_web_view_save _obj' saveMode' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    return ()

data WebViewSaveMethodInfo
instance (signature ~ (SaveMode -> Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, WebViewK a, Gio.CancellableK b) => MethodInfo WebViewSaveMethodInfo a signature where
    overloadedMethod _ = webViewSave

-- method WebView::save_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "Gio" "InputStream")
-- throws : True
-- Skip return : False

foreign import ccall "webkit_web_view_save_finish" webkit_web_view_save_finish :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.InputStream)


webViewSaveFinish ::
    (MonadIO m, WebViewK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m Gio.InputStream                    -- result
webViewSaveFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ webkit_web_view_save_finish _obj' result_'
        checkUnexpectedReturnNULL "webkit_web_view_save_finish" result
        result' <- (wrapObject Gio.InputStream) result
        touchManagedPtr _obj
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

data WebViewSaveFinishMethodInfo
instance (signature ~ (b -> m Gio.InputStream), MonadIO m, WebViewK a, Gio.AsyncResultK b) => MethodInfo WebViewSaveFinishMethodInfo a signature where
    overloadedMethod _ = webViewSaveFinish

-- method WebView::save_to_file
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "file", argType = TInterface "Gio" "File", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "save_mode", argType = TInterface "WebKit2" "SaveMode", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 5, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_save_to_file" webkit_web_view_save_to_file :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gio.File ->                         -- file : TInterface "Gio" "File"
    CUInt ->                                -- save_mode : TInterface "WebKit2" "SaveMode"
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


webViewSaveToFile ::
    (MonadIO m, WebViewK a, Gio.FileK b, Gio.CancellableK c) =>
    a                                       -- _obj
    -> b                                    -- file
    -> SaveMode                             -- saveMode
    -> Maybe (c)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
webViewSaveToFile _obj file saveMode cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let file' = unsafeManagedPtrCastPtr file
    let saveMode' = (fromIntegral . fromEnum) saveMode
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_web_view_save_to_file _obj' file' saveMode' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    touchManagedPtr file
    whenJust cancellable touchManagedPtr
    return ()

data WebViewSaveToFileMethodInfo
instance (signature ~ (b -> SaveMode -> Maybe (c) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, WebViewK a, Gio.FileK b, Gio.CancellableK c) => MethodInfo WebViewSaveToFileMethodInfo a signature where
    overloadedMethod _ = webViewSaveToFile

-- method WebView::save_to_file_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "webkit_web_view_save_to_file_finish" webkit_web_view_save_to_file_finish :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO CInt


webViewSaveToFileFinish ::
    (MonadIO m, WebViewK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m ()                                 -- result
webViewSaveToFileFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ webkit_web_view_save_to_file_finish _obj' result_'
        touchManagedPtr _obj
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

data WebViewSaveToFileFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, WebViewK a, Gio.AsyncResultK b) => MethodInfo WebViewSaveToFileFinishMethodInfo a signature where
    overloadedMethod _ = webViewSaveToFileFinish

-- method WebView::set_background_color
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "rgba", argType = TInterface "Gdk" "RGBA", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_set_background_color" webkit_web_view_set_background_color :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Gdk.RGBA ->                         -- rgba : TInterface "Gdk" "RGBA"
    IO ()


webViewSetBackgroundColor ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> Gdk.RGBA                             -- rgba
    -> m ()                                 -- result
webViewSetBackgroundColor _obj rgba = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let rgba' = unsafeManagedPtrGetPtr rgba
    webkit_web_view_set_background_color _obj' rgba'
    touchManagedPtr _obj
    touchManagedPtr rgba
    return ()

data WebViewSetBackgroundColorMethodInfo
instance (signature ~ (Gdk.RGBA -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewSetBackgroundColorMethodInfo a signature where
    overloadedMethod _ = webViewSetBackgroundColor

-- method WebView::set_custom_charset
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "charset", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_set_custom_charset" webkit_web_view_set_custom_charset :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CString ->                              -- charset : TBasicType TUTF8
    IO ()


webViewSetCustomCharset ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> Maybe (T.Text)                       -- charset
    -> m ()                                 -- result
webViewSetCustomCharset _obj charset = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeCharset <- case charset of
        Nothing -> return nullPtr
        Just jCharset -> do
            jCharset' <- textToCString jCharset
            return jCharset'
    webkit_web_view_set_custom_charset _obj' maybeCharset
    touchManagedPtr _obj
    freeMem maybeCharset
    return ()

data WebViewSetCustomCharsetMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewSetCustomCharsetMethodInfo a signature where
    overloadedMethod _ = webViewSetCustomCharset

-- method WebView::set_editable
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "editable", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_set_editable" webkit_web_view_set_editable :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CInt ->                                 -- editable : TBasicType TBoolean
    IO ()


webViewSetEditable ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> Bool                                 -- editable
    -> m ()                                 -- result
webViewSetEditable _obj editable = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let editable' = (fromIntegral . fromEnum) editable
    webkit_web_view_set_editable _obj' editable'
    touchManagedPtr _obj
    return ()

data WebViewSetEditableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewSetEditableMethodInfo a signature where
    overloadedMethod _ = webViewSetEditable

-- method WebView::set_settings
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "settings", argType = TInterface "WebKit2" "Settings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_set_settings" webkit_web_view_set_settings :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    Ptr Settings ->                         -- settings : TInterface "WebKit2" "Settings"
    IO ()


webViewSetSettings ::
    (MonadIO m, WebViewK a, SettingsK b) =>
    a                                       -- _obj
    -> b                                    -- settings
    -> m ()                                 -- result
webViewSetSettings _obj settings = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let settings' = unsafeManagedPtrCastPtr settings
    webkit_web_view_set_settings _obj' settings'
    touchManagedPtr _obj
    touchManagedPtr settings
    return ()

data WebViewSetSettingsMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, WebViewK a, SettingsK b) => MethodInfo WebViewSetSettingsMethodInfo a signature where
    overloadedMethod _ = webViewSetSettings

-- method WebView::set_zoom_level
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "zoom_level", argType = TBasicType TDouble, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_set_zoom_level" webkit_web_view_set_zoom_level :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    CDouble ->                              -- zoom_level : TBasicType TDouble
    IO ()


webViewSetZoomLevel ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> Double                               -- zoomLevel
    -> m ()                                 -- result
webViewSetZoomLevel _obj zoomLevel = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let zoomLevel' = realToFrac zoomLevel
    webkit_web_view_set_zoom_level _obj' zoomLevel'
    touchManagedPtr _obj
    return ()

data WebViewSetZoomLevelMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, WebViewK a) => MethodInfo WebViewSetZoomLevelMethodInfo a signature where
    overloadedMethod _ = webViewSetZoomLevel

-- method WebView::stop_loading
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_stop_loading" webkit_web_view_stop_loading :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO ()


webViewStopLoading ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webViewStopLoading _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_view_stop_loading _obj'
    touchManagedPtr _obj
    return ()

data WebViewStopLoadingMethodInfo
instance (signature ~ (m ()), MonadIO m, WebViewK a) => MethodInfo WebViewStopLoadingMethodInfo a signature where
    overloadedMethod _ = webViewStopLoading

-- method WebView::try_close
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_try_close" webkit_web_view_try_close :: 
    Ptr WebView ->                          -- _obj : TInterface "WebKit2" "WebView"
    IO ()


webViewTryClose ::
    (MonadIO m, WebViewK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
webViewTryClose _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_web_view_try_close _obj'
    touchManagedPtr _obj
    return ()

data WebViewTryCloseMethodInfo
instance (signature ~ (m ()), MonadIO m, WebViewK a) => MethodInfo WebViewTryCloseMethodInfo a signature where
    overloadedMethod _ = webViewTryClose


