

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.WebViewBase
    ( 

-- * Exported types
    WebViewBase(..)                         ,
    WebViewBaseK                            ,
    toWebViewBase                           ,
    noWebViewBase                           ,


    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.Atk as Atk
import qualified GI.GObject as GObject
import qualified GI.Gtk as Gtk

newtype WebViewBase = WebViewBase (ForeignPtr WebViewBase)
foreign import ccall "webkit_web_view_base_get_type"
    c_webkit_web_view_base_get_type :: IO GType

type instance ParentTypes WebViewBase = WebViewBaseParentTypes
type WebViewBaseParentTypes = '[Gtk.Container, Gtk.Widget, GObject.Object, Atk.ImplementorIface, Gtk.Buildable]

instance GObject WebViewBase where
    gobjectIsInitiallyUnowned _ = True
    gobjectType _ = c_webkit_web_view_base_get_type
    

class GObject o => WebViewBaseK o
instance (GObject o, IsDescendantOf WebViewBase o) => WebViewBaseK o

toWebViewBase :: WebViewBaseK o => o -> IO WebViewBase
toWebViewBase = unsafeCastTo WebViewBase

noWebViewBase :: Maybe WebViewBase
noWebViewBase = Nothing

type family ResolveWebViewBaseMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebViewBaseMethod "activate" o = Gtk.WidgetActivateMethodInfo
    ResolveWebViewBaseMethod "add" o = Gtk.ContainerAddMethodInfo
    ResolveWebViewBaseMethod "addAccelerator" o = Gtk.WidgetAddAcceleratorMethodInfo
    ResolveWebViewBaseMethod "addChild" o = Gtk.BuildableAddChildMethodInfo
    ResolveWebViewBaseMethod "addDeviceEvents" o = Gtk.WidgetAddDeviceEventsMethodInfo
    ResolveWebViewBaseMethod "addEvents" o = Gtk.WidgetAddEventsMethodInfo
    ResolveWebViewBaseMethod "addMnemonicLabel" o = Gtk.WidgetAddMnemonicLabelMethodInfo
    ResolveWebViewBaseMethod "addTickCallback" o = Gtk.WidgetAddTickCallbackMethodInfo
    ResolveWebViewBaseMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebViewBaseMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebViewBaseMethod "canActivateAccel" o = Gtk.WidgetCanActivateAccelMethodInfo
    ResolveWebViewBaseMethod "checkResize" o = Gtk.ContainerCheckResizeMethodInfo
    ResolveWebViewBaseMethod "childFocus" o = Gtk.WidgetChildFocusMethodInfo
    ResolveWebViewBaseMethod "childGetProperty" o = Gtk.ContainerChildGetPropertyMethodInfo
    ResolveWebViewBaseMethod "childNotifyByPspec" o = Gtk.ContainerChildNotifyByPspecMethodInfo
    ResolveWebViewBaseMethod "childSetProperty" o = Gtk.ContainerChildSetPropertyMethodInfo
    ResolveWebViewBaseMethod "childType" o = Gtk.ContainerChildTypeMethodInfo
    ResolveWebViewBaseMethod "classPath" o = Gtk.WidgetClassPathMethodInfo
    ResolveWebViewBaseMethod "computeExpand" o = Gtk.WidgetComputeExpandMethodInfo
    ResolveWebViewBaseMethod "constructChild" o = Gtk.BuildableConstructChildMethodInfo
    ResolveWebViewBaseMethod "createPangoContext" o = Gtk.WidgetCreatePangoContextMethodInfo
    ResolveWebViewBaseMethod "createPangoLayout" o = Gtk.WidgetCreatePangoLayoutMethodInfo
    ResolveWebViewBaseMethod "customFinished" o = Gtk.BuildableCustomFinishedMethodInfo
    ResolveWebViewBaseMethod "customTagEnd" o = Gtk.BuildableCustomTagEndMethodInfo
    ResolveWebViewBaseMethod "customTagStart" o = Gtk.BuildableCustomTagStartMethodInfo
    ResolveWebViewBaseMethod "destroy" o = Gtk.WidgetDestroyMethodInfo
    ResolveWebViewBaseMethod "destroyed" o = Gtk.WidgetDestroyedMethodInfo
    ResolveWebViewBaseMethod "deviceIsShadowed" o = Gtk.WidgetDeviceIsShadowedMethodInfo
    ResolveWebViewBaseMethod "dragBegin" o = Gtk.WidgetDragBeginMethodInfo
    ResolveWebViewBaseMethod "dragBeginWithCoordinates" o = Gtk.WidgetDragBeginWithCoordinatesMethodInfo
    ResolveWebViewBaseMethod "dragCheckThreshold" o = Gtk.WidgetDragCheckThresholdMethodInfo
    ResolveWebViewBaseMethod "dragDestAddImageTargets" o = Gtk.WidgetDragDestAddImageTargetsMethodInfo
    ResolveWebViewBaseMethod "dragDestAddTextTargets" o = Gtk.WidgetDragDestAddTextTargetsMethodInfo
    ResolveWebViewBaseMethod "dragDestAddUriTargets" o = Gtk.WidgetDragDestAddUriTargetsMethodInfo
    ResolveWebViewBaseMethod "dragDestFindTarget" o = Gtk.WidgetDragDestFindTargetMethodInfo
    ResolveWebViewBaseMethod "dragDestGetTargetList" o = Gtk.WidgetDragDestGetTargetListMethodInfo
    ResolveWebViewBaseMethod "dragDestGetTrackMotion" o = Gtk.WidgetDragDestGetTrackMotionMethodInfo
    ResolveWebViewBaseMethod "dragDestSet" o = Gtk.WidgetDragDestSetMethodInfo
    ResolveWebViewBaseMethod "dragDestSetProxy" o = Gtk.WidgetDragDestSetProxyMethodInfo
    ResolveWebViewBaseMethod "dragDestSetTargetList" o = Gtk.WidgetDragDestSetTargetListMethodInfo
    ResolveWebViewBaseMethod "dragDestSetTrackMotion" o = Gtk.WidgetDragDestSetTrackMotionMethodInfo
    ResolveWebViewBaseMethod "dragDestUnset" o = Gtk.WidgetDragDestUnsetMethodInfo
    ResolveWebViewBaseMethod "dragGetData" o = Gtk.WidgetDragGetDataMethodInfo
    ResolveWebViewBaseMethod "dragHighlight" o = Gtk.WidgetDragHighlightMethodInfo
    ResolveWebViewBaseMethod "dragSourceAddImageTargets" o = Gtk.WidgetDragSourceAddImageTargetsMethodInfo
    ResolveWebViewBaseMethod "dragSourceAddTextTargets" o = Gtk.WidgetDragSourceAddTextTargetsMethodInfo
    ResolveWebViewBaseMethod "dragSourceAddUriTargets" o = Gtk.WidgetDragSourceAddUriTargetsMethodInfo
    ResolveWebViewBaseMethod "dragSourceGetTargetList" o = Gtk.WidgetDragSourceGetTargetListMethodInfo
    ResolveWebViewBaseMethod "dragSourceSet" o = Gtk.WidgetDragSourceSetMethodInfo
    ResolveWebViewBaseMethod "dragSourceSetIconGicon" o = Gtk.WidgetDragSourceSetIconGiconMethodInfo
    ResolveWebViewBaseMethod "dragSourceSetIconName" o = Gtk.WidgetDragSourceSetIconNameMethodInfo
    ResolveWebViewBaseMethod "dragSourceSetIconPixbuf" o = Gtk.WidgetDragSourceSetIconPixbufMethodInfo
    ResolveWebViewBaseMethod "dragSourceSetIconStock" o = Gtk.WidgetDragSourceSetIconStockMethodInfo
    ResolveWebViewBaseMethod "dragSourceSetTargetList" o = Gtk.WidgetDragSourceSetTargetListMethodInfo
    ResolveWebViewBaseMethod "dragSourceUnset" o = Gtk.WidgetDragSourceUnsetMethodInfo
    ResolveWebViewBaseMethod "dragUnhighlight" o = Gtk.WidgetDragUnhighlightMethodInfo
    ResolveWebViewBaseMethod "draw" o = Gtk.WidgetDrawMethodInfo
    ResolveWebViewBaseMethod "ensureStyle" o = Gtk.WidgetEnsureStyleMethodInfo
    ResolveWebViewBaseMethod "errorBell" o = Gtk.WidgetErrorBellMethodInfo
    ResolveWebViewBaseMethod "event" o = Gtk.WidgetEventMethodInfo
    ResolveWebViewBaseMethod "forall" o = Gtk.ContainerForallMethodInfo
    ResolveWebViewBaseMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebViewBaseMethod "foreach" o = Gtk.ContainerForeachMethodInfo
    ResolveWebViewBaseMethod "freezeChildNotify" o = Gtk.WidgetFreezeChildNotifyMethodInfo
    ResolveWebViewBaseMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebViewBaseMethod "grabAdd" o = Gtk.WidgetGrabAddMethodInfo
    ResolveWebViewBaseMethod "grabDefault" o = Gtk.WidgetGrabDefaultMethodInfo
    ResolveWebViewBaseMethod "grabFocus" o = Gtk.WidgetGrabFocusMethodInfo
    ResolveWebViewBaseMethod "grabRemove" o = Gtk.WidgetGrabRemoveMethodInfo
    ResolveWebViewBaseMethod "hasDefault" o = Gtk.WidgetHasDefaultMethodInfo
    ResolveWebViewBaseMethod "hasFocus" o = Gtk.WidgetHasFocusMethodInfo
    ResolveWebViewBaseMethod "hasGrab" o = Gtk.WidgetHasGrabMethodInfo
    ResolveWebViewBaseMethod "hasRcStyle" o = Gtk.WidgetHasRcStyleMethodInfo
    ResolveWebViewBaseMethod "hasScreen" o = Gtk.WidgetHasScreenMethodInfo
    ResolveWebViewBaseMethod "hasVisibleFocus" o = Gtk.WidgetHasVisibleFocusMethodInfo
    ResolveWebViewBaseMethod "hide" o = Gtk.WidgetHideMethodInfo
    ResolveWebViewBaseMethod "hideOnDelete" o = Gtk.WidgetHideOnDeleteMethodInfo
    ResolveWebViewBaseMethod "inDestruction" o = Gtk.WidgetInDestructionMethodInfo
    ResolveWebViewBaseMethod "initTemplate" o = Gtk.WidgetInitTemplateMethodInfo
    ResolveWebViewBaseMethod "inputShapeCombineRegion" o = Gtk.WidgetInputShapeCombineRegionMethodInfo
    ResolveWebViewBaseMethod "insertActionGroup" o = Gtk.WidgetInsertActionGroupMethodInfo
    ResolveWebViewBaseMethod "intersect" o = Gtk.WidgetIntersectMethodInfo
    ResolveWebViewBaseMethod "isAncestor" o = Gtk.WidgetIsAncestorMethodInfo
    ResolveWebViewBaseMethod "isComposited" o = Gtk.WidgetIsCompositedMethodInfo
    ResolveWebViewBaseMethod "isDrawable" o = Gtk.WidgetIsDrawableMethodInfo
    ResolveWebViewBaseMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebViewBaseMethod "isFocus" o = Gtk.WidgetIsFocusMethodInfo
    ResolveWebViewBaseMethod "isSensitive" o = Gtk.WidgetIsSensitiveMethodInfo
    ResolveWebViewBaseMethod "isToplevel" o = Gtk.WidgetIsToplevelMethodInfo
    ResolveWebViewBaseMethod "isVisible" o = Gtk.WidgetIsVisibleMethodInfo
    ResolveWebViewBaseMethod "keynavFailed" o = Gtk.WidgetKeynavFailedMethodInfo
    ResolveWebViewBaseMethod "listAccelClosures" o = Gtk.WidgetListAccelClosuresMethodInfo
    ResolveWebViewBaseMethod "listActionPrefixes" o = Gtk.WidgetListActionPrefixesMethodInfo
    ResolveWebViewBaseMethod "listMnemonicLabels" o = Gtk.WidgetListMnemonicLabelsMethodInfo
    ResolveWebViewBaseMethod "map" o = Gtk.WidgetMapMethodInfo
    ResolveWebViewBaseMethod "mnemonicActivate" o = Gtk.WidgetMnemonicActivateMethodInfo
    ResolveWebViewBaseMethod "modifyBase" o = Gtk.WidgetModifyBaseMethodInfo
    ResolveWebViewBaseMethod "modifyBg" o = Gtk.WidgetModifyBgMethodInfo
    ResolveWebViewBaseMethod "modifyCursor" o = Gtk.WidgetModifyCursorMethodInfo
    ResolveWebViewBaseMethod "modifyFg" o = Gtk.WidgetModifyFgMethodInfo
    ResolveWebViewBaseMethod "modifyFont" o = Gtk.WidgetModifyFontMethodInfo
    ResolveWebViewBaseMethod "modifyStyle" o = Gtk.WidgetModifyStyleMethodInfo
    ResolveWebViewBaseMethod "modifyText" o = Gtk.WidgetModifyTextMethodInfo
    ResolveWebViewBaseMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebViewBaseMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebViewBaseMethod "overrideBackgroundColor" o = Gtk.WidgetOverrideBackgroundColorMethodInfo
    ResolveWebViewBaseMethod "overrideColor" o = Gtk.WidgetOverrideColorMethodInfo
    ResolveWebViewBaseMethod "overrideCursor" o = Gtk.WidgetOverrideCursorMethodInfo
    ResolveWebViewBaseMethod "overrideFont" o = Gtk.WidgetOverrideFontMethodInfo
    ResolveWebViewBaseMethod "overrideSymbolicColor" o = Gtk.WidgetOverrideSymbolicColorMethodInfo
    ResolveWebViewBaseMethod "parserFinished" o = Gtk.BuildableParserFinishedMethodInfo
    ResolveWebViewBaseMethod "path" o = Gtk.WidgetPathMethodInfo
    ResolveWebViewBaseMethod "propagateDraw" o = Gtk.ContainerPropagateDrawMethodInfo
    ResolveWebViewBaseMethod "queueComputeExpand" o = Gtk.WidgetQueueComputeExpandMethodInfo
    ResolveWebViewBaseMethod "queueDraw" o = Gtk.WidgetQueueDrawMethodInfo
    ResolveWebViewBaseMethod "queueDrawArea" o = Gtk.WidgetQueueDrawAreaMethodInfo
    ResolveWebViewBaseMethod "queueDrawRegion" o = Gtk.WidgetQueueDrawRegionMethodInfo
    ResolveWebViewBaseMethod "queueResize" o = Gtk.WidgetQueueResizeMethodInfo
    ResolveWebViewBaseMethod "queueResizeNoRedraw" o = Gtk.WidgetQueueResizeNoRedrawMethodInfo
    ResolveWebViewBaseMethod "realize" o = Gtk.WidgetRealizeMethodInfo
    ResolveWebViewBaseMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebViewBaseMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebViewBaseMethod "regionIntersect" o = Gtk.WidgetRegionIntersectMethodInfo
    ResolveWebViewBaseMethod "registerWindow" o = Gtk.WidgetRegisterWindowMethodInfo
    ResolveWebViewBaseMethod "remove" o = Gtk.ContainerRemoveMethodInfo
    ResolveWebViewBaseMethod "removeAccelerator" o = Gtk.WidgetRemoveAcceleratorMethodInfo
    ResolveWebViewBaseMethod "removeMnemonicLabel" o = Gtk.WidgetRemoveMnemonicLabelMethodInfo
    ResolveWebViewBaseMethod "removeTickCallback" o = Gtk.WidgetRemoveTickCallbackMethodInfo
    ResolveWebViewBaseMethod "renderIcon" o = Gtk.WidgetRenderIconMethodInfo
    ResolveWebViewBaseMethod "renderIconPixbuf" o = Gtk.WidgetRenderIconPixbufMethodInfo
    ResolveWebViewBaseMethod "reparent" o = Gtk.WidgetReparentMethodInfo
    ResolveWebViewBaseMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebViewBaseMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebViewBaseMethod "resetRcStyles" o = Gtk.WidgetResetRcStylesMethodInfo
    ResolveWebViewBaseMethod "resetStyle" o = Gtk.WidgetResetStyleMethodInfo
    ResolveWebViewBaseMethod "resizeChildren" o = Gtk.ContainerResizeChildrenMethodInfo
    ResolveWebViewBaseMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebViewBaseMethod "sendExpose" o = Gtk.WidgetSendExposeMethodInfo
    ResolveWebViewBaseMethod "sendFocusChange" o = Gtk.WidgetSendFocusChangeMethodInfo
    ResolveWebViewBaseMethod "shapeCombineRegion" o = Gtk.WidgetShapeCombineRegionMethodInfo
    ResolveWebViewBaseMethod "show" o = Gtk.WidgetShowMethodInfo
    ResolveWebViewBaseMethod "showAll" o = Gtk.WidgetShowAllMethodInfo
    ResolveWebViewBaseMethod "showNow" o = Gtk.WidgetShowNowMethodInfo
    ResolveWebViewBaseMethod "sizeAllocate" o = Gtk.WidgetSizeAllocateMethodInfo
    ResolveWebViewBaseMethod "sizeAllocateWithBaseline" o = Gtk.WidgetSizeAllocateWithBaselineMethodInfo
    ResolveWebViewBaseMethod "sizeRequest" o = Gtk.WidgetSizeRequestMethodInfo
    ResolveWebViewBaseMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebViewBaseMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebViewBaseMethod "styleAttach" o = Gtk.WidgetStyleAttachMethodInfo
    ResolveWebViewBaseMethod "styleGetProperty" o = Gtk.WidgetStyleGetPropertyMethodInfo
    ResolveWebViewBaseMethod "thawChildNotify" o = Gtk.WidgetThawChildNotifyMethodInfo
    ResolveWebViewBaseMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebViewBaseMethod "translateCoordinates" o = Gtk.WidgetTranslateCoordinatesMethodInfo
    ResolveWebViewBaseMethod "triggerTooltipQuery" o = Gtk.WidgetTriggerTooltipQueryMethodInfo
    ResolveWebViewBaseMethod "unmap" o = Gtk.WidgetUnmapMethodInfo
    ResolveWebViewBaseMethod "unparent" o = Gtk.WidgetUnparentMethodInfo
    ResolveWebViewBaseMethod "unrealize" o = Gtk.WidgetUnrealizeMethodInfo
    ResolveWebViewBaseMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebViewBaseMethod "unregisterWindow" o = Gtk.WidgetUnregisterWindowMethodInfo
    ResolveWebViewBaseMethod "unsetFocusChain" o = Gtk.ContainerUnsetFocusChainMethodInfo
    ResolveWebViewBaseMethod "unsetStateFlags" o = Gtk.WidgetUnsetStateFlagsMethodInfo
    ResolveWebViewBaseMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebViewBaseMethod "getAccessible" o = Gtk.WidgetGetAccessibleMethodInfo
    ResolveWebViewBaseMethod "getActionGroup" o = Gtk.WidgetGetActionGroupMethodInfo
    ResolveWebViewBaseMethod "getAllocatedBaseline" o = Gtk.WidgetGetAllocatedBaselineMethodInfo
    ResolveWebViewBaseMethod "getAllocatedHeight" o = Gtk.WidgetGetAllocatedHeightMethodInfo
    ResolveWebViewBaseMethod "getAllocatedWidth" o = Gtk.WidgetGetAllocatedWidthMethodInfo
    ResolveWebViewBaseMethod "getAllocation" o = Gtk.WidgetGetAllocationMethodInfo
    ResolveWebViewBaseMethod "getAncestor" o = Gtk.WidgetGetAncestorMethodInfo
    ResolveWebViewBaseMethod "getAppPaintable" o = Gtk.WidgetGetAppPaintableMethodInfo
    ResolveWebViewBaseMethod "getBorderWidth" o = Gtk.ContainerGetBorderWidthMethodInfo
    ResolveWebViewBaseMethod "getCanDefault" o = Gtk.WidgetGetCanDefaultMethodInfo
    ResolveWebViewBaseMethod "getCanFocus" o = Gtk.WidgetGetCanFocusMethodInfo
    ResolveWebViewBaseMethod "getChildRequisition" o = Gtk.WidgetGetChildRequisitionMethodInfo
    ResolveWebViewBaseMethod "getChildVisible" o = Gtk.WidgetGetChildVisibleMethodInfo
    ResolveWebViewBaseMethod "getChildren" o = Gtk.ContainerGetChildrenMethodInfo
    ResolveWebViewBaseMethod "getClip" o = Gtk.WidgetGetClipMethodInfo
    ResolveWebViewBaseMethod "getClipboard" o = Gtk.WidgetGetClipboardMethodInfo
    ResolveWebViewBaseMethod "getCompositeName" o = Gtk.WidgetGetCompositeNameMethodInfo
    ResolveWebViewBaseMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebViewBaseMethod "getDeviceEnabled" o = Gtk.WidgetGetDeviceEnabledMethodInfo
    ResolveWebViewBaseMethod "getDeviceEvents" o = Gtk.WidgetGetDeviceEventsMethodInfo
    ResolveWebViewBaseMethod "getDirection" o = Gtk.WidgetGetDirectionMethodInfo
    ResolveWebViewBaseMethod "getDisplay" o = Gtk.WidgetGetDisplayMethodInfo
    ResolveWebViewBaseMethod "getDoubleBuffered" o = Gtk.WidgetGetDoubleBufferedMethodInfo
    ResolveWebViewBaseMethod "getEvents" o = Gtk.WidgetGetEventsMethodInfo
    ResolveWebViewBaseMethod "getFocusChain" o = Gtk.ContainerGetFocusChainMethodInfo
    ResolveWebViewBaseMethod "getFocusChild" o = Gtk.ContainerGetFocusChildMethodInfo
    ResolveWebViewBaseMethod "getFocusHadjustment" o = Gtk.ContainerGetFocusHadjustmentMethodInfo
    ResolveWebViewBaseMethod "getFocusVadjustment" o = Gtk.ContainerGetFocusVadjustmentMethodInfo
    ResolveWebViewBaseMethod "getFontMap" o = Gtk.WidgetGetFontMapMethodInfo
    ResolveWebViewBaseMethod "getFontOptions" o = Gtk.WidgetGetFontOptionsMethodInfo
    ResolveWebViewBaseMethod "getFrameClock" o = Gtk.WidgetGetFrameClockMethodInfo
    ResolveWebViewBaseMethod "getHalign" o = Gtk.WidgetGetHalignMethodInfo
    ResolveWebViewBaseMethod "getHasTooltip" o = Gtk.WidgetGetHasTooltipMethodInfo
    ResolveWebViewBaseMethod "getHasWindow" o = Gtk.WidgetGetHasWindowMethodInfo
    ResolveWebViewBaseMethod "getHexpand" o = Gtk.WidgetGetHexpandMethodInfo
    ResolveWebViewBaseMethod "getHexpandSet" o = Gtk.WidgetGetHexpandSetMethodInfo
    ResolveWebViewBaseMethod "getInternalChild" o = Gtk.BuildableGetInternalChildMethodInfo
    ResolveWebViewBaseMethod "getMapped" o = Gtk.WidgetGetMappedMethodInfo
    ResolveWebViewBaseMethod "getMarginBottom" o = Gtk.WidgetGetMarginBottomMethodInfo
    ResolveWebViewBaseMethod "getMarginEnd" o = Gtk.WidgetGetMarginEndMethodInfo
    ResolveWebViewBaseMethod "getMarginLeft" o = Gtk.WidgetGetMarginLeftMethodInfo
    ResolveWebViewBaseMethod "getMarginRight" o = Gtk.WidgetGetMarginRightMethodInfo
    ResolveWebViewBaseMethod "getMarginStart" o = Gtk.WidgetGetMarginStartMethodInfo
    ResolveWebViewBaseMethod "getMarginTop" o = Gtk.WidgetGetMarginTopMethodInfo
    ResolveWebViewBaseMethod "getModifierMask" o = Gtk.WidgetGetModifierMaskMethodInfo
    ResolveWebViewBaseMethod "getModifierStyle" o = Gtk.WidgetGetModifierStyleMethodInfo
    ResolveWebViewBaseMethod "getNoShowAll" o = Gtk.WidgetGetNoShowAllMethodInfo
    ResolveWebViewBaseMethod "getOpacity" o = Gtk.WidgetGetOpacityMethodInfo
    ResolveWebViewBaseMethod "getPangoContext" o = Gtk.WidgetGetPangoContextMethodInfo
    ResolveWebViewBaseMethod "getParent" o = Gtk.WidgetGetParentMethodInfo
    ResolveWebViewBaseMethod "getParentWindow" o = Gtk.WidgetGetParentWindowMethodInfo
    ResolveWebViewBaseMethod "getPath" o = Gtk.WidgetGetPathMethodInfo
    ResolveWebViewBaseMethod "getPathForChild" o = Gtk.ContainerGetPathForChildMethodInfo
    ResolveWebViewBaseMethod "getPointer" o = Gtk.WidgetGetPointerMethodInfo
    ResolveWebViewBaseMethod "getPreferredHeight" o = Gtk.WidgetGetPreferredHeightMethodInfo
    ResolveWebViewBaseMethod "getPreferredHeightAndBaselineForWidth" o = Gtk.WidgetGetPreferredHeightAndBaselineForWidthMethodInfo
    ResolveWebViewBaseMethod "getPreferredHeightForWidth" o = Gtk.WidgetGetPreferredHeightForWidthMethodInfo
    ResolveWebViewBaseMethod "getPreferredSize" o = Gtk.WidgetGetPreferredSizeMethodInfo
    ResolveWebViewBaseMethod "getPreferredWidth" o = Gtk.WidgetGetPreferredWidthMethodInfo
    ResolveWebViewBaseMethod "getPreferredWidthForHeight" o = Gtk.WidgetGetPreferredWidthForHeightMethodInfo
    ResolveWebViewBaseMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebViewBaseMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebViewBaseMethod "getRealized" o = Gtk.WidgetGetRealizedMethodInfo
    ResolveWebViewBaseMethod "getReceivesDefault" o = Gtk.WidgetGetReceivesDefaultMethodInfo
    ResolveWebViewBaseMethod "getRequestMode" o = Gtk.WidgetGetRequestModeMethodInfo
    ResolveWebViewBaseMethod "getRequisition" o = Gtk.WidgetGetRequisitionMethodInfo
    ResolveWebViewBaseMethod "getResizeMode" o = Gtk.ContainerGetResizeModeMethodInfo
    ResolveWebViewBaseMethod "getRootWindow" o = Gtk.WidgetGetRootWindowMethodInfo
    ResolveWebViewBaseMethod "getScaleFactor" o = Gtk.WidgetGetScaleFactorMethodInfo
    ResolveWebViewBaseMethod "getScreen" o = Gtk.WidgetGetScreenMethodInfo
    ResolveWebViewBaseMethod "getSensitive" o = Gtk.WidgetGetSensitiveMethodInfo
    ResolveWebViewBaseMethod "getSettings" o = Gtk.WidgetGetSettingsMethodInfo
    ResolveWebViewBaseMethod "getSizeRequest" o = Gtk.WidgetGetSizeRequestMethodInfo
    ResolveWebViewBaseMethod "getState" o = Gtk.WidgetGetStateMethodInfo
    ResolveWebViewBaseMethod "getStateFlags" o = Gtk.WidgetGetStateFlagsMethodInfo
    ResolveWebViewBaseMethod "getStyle" o = Gtk.WidgetGetStyleMethodInfo
    ResolveWebViewBaseMethod "getStyleContext" o = Gtk.WidgetGetStyleContextMethodInfo
    ResolveWebViewBaseMethod "getSupportMultidevice" o = Gtk.WidgetGetSupportMultideviceMethodInfo
    ResolveWebViewBaseMethod "getTemplateChild" o = Gtk.WidgetGetTemplateChildMethodInfo
    ResolveWebViewBaseMethod "getTooltipMarkup" o = Gtk.WidgetGetTooltipMarkupMethodInfo
    ResolveWebViewBaseMethod "getTooltipText" o = Gtk.WidgetGetTooltipTextMethodInfo
    ResolveWebViewBaseMethod "getTooltipWindow" o = Gtk.WidgetGetTooltipWindowMethodInfo
    ResolveWebViewBaseMethod "getToplevel" o = Gtk.WidgetGetToplevelMethodInfo
    ResolveWebViewBaseMethod "getValign" o = Gtk.WidgetGetValignMethodInfo
    ResolveWebViewBaseMethod "getValignWithBaseline" o = Gtk.WidgetGetValignWithBaselineMethodInfo
    ResolveWebViewBaseMethod "getVexpand" o = Gtk.WidgetGetVexpandMethodInfo
    ResolveWebViewBaseMethod "getVexpandSet" o = Gtk.WidgetGetVexpandSetMethodInfo
    ResolveWebViewBaseMethod "getVisible" o = Gtk.WidgetGetVisibleMethodInfo
    ResolveWebViewBaseMethod "getVisual" o = Gtk.WidgetGetVisualMethodInfo
    ResolveWebViewBaseMethod "getWindow" o = Gtk.WidgetGetWindowMethodInfo
    ResolveWebViewBaseMethod "setAccelPath" o = Gtk.WidgetSetAccelPathMethodInfo
    ResolveWebViewBaseMethod "setAllocation" o = Gtk.WidgetSetAllocationMethodInfo
    ResolveWebViewBaseMethod "setAppPaintable" o = Gtk.WidgetSetAppPaintableMethodInfo
    ResolveWebViewBaseMethod "setBorderWidth" o = Gtk.ContainerSetBorderWidthMethodInfo
    ResolveWebViewBaseMethod "setBuildableProperty" o = Gtk.BuildableSetBuildablePropertyMethodInfo
    ResolveWebViewBaseMethod "setCanDefault" o = Gtk.WidgetSetCanDefaultMethodInfo
    ResolveWebViewBaseMethod "setCanFocus" o = Gtk.WidgetSetCanFocusMethodInfo
    ResolveWebViewBaseMethod "setChildVisible" o = Gtk.WidgetSetChildVisibleMethodInfo
    ResolveWebViewBaseMethod "setClip" o = Gtk.WidgetSetClipMethodInfo
    ResolveWebViewBaseMethod "setCompositeName" o = Gtk.WidgetSetCompositeNameMethodInfo
    ResolveWebViewBaseMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebViewBaseMethod "setDeviceEnabled" o = Gtk.WidgetSetDeviceEnabledMethodInfo
    ResolveWebViewBaseMethod "setDeviceEvents" o = Gtk.WidgetSetDeviceEventsMethodInfo
    ResolveWebViewBaseMethod "setDirection" o = Gtk.WidgetSetDirectionMethodInfo
    ResolveWebViewBaseMethod "setDoubleBuffered" o = Gtk.WidgetSetDoubleBufferedMethodInfo
    ResolveWebViewBaseMethod "setEvents" o = Gtk.WidgetSetEventsMethodInfo
    ResolveWebViewBaseMethod "setFocusChain" o = Gtk.ContainerSetFocusChainMethodInfo
    ResolveWebViewBaseMethod "setFocusChild" o = Gtk.ContainerSetFocusChildMethodInfo
    ResolveWebViewBaseMethod "setFocusHadjustment" o = Gtk.ContainerSetFocusHadjustmentMethodInfo
    ResolveWebViewBaseMethod "setFocusVadjustment" o = Gtk.ContainerSetFocusVadjustmentMethodInfo
    ResolveWebViewBaseMethod "setFontMap" o = Gtk.WidgetSetFontMapMethodInfo
    ResolveWebViewBaseMethod "setFontOptions" o = Gtk.WidgetSetFontOptionsMethodInfo
    ResolveWebViewBaseMethod "setHalign" o = Gtk.WidgetSetHalignMethodInfo
    ResolveWebViewBaseMethod "setHasTooltip" o = Gtk.WidgetSetHasTooltipMethodInfo
    ResolveWebViewBaseMethod "setHasWindow" o = Gtk.WidgetSetHasWindowMethodInfo
    ResolveWebViewBaseMethod "setHexpand" o = Gtk.WidgetSetHexpandMethodInfo
    ResolveWebViewBaseMethod "setHexpandSet" o = Gtk.WidgetSetHexpandSetMethodInfo
    ResolveWebViewBaseMethod "setMapped" o = Gtk.WidgetSetMappedMethodInfo
    ResolveWebViewBaseMethod "setMarginBottom" o = Gtk.WidgetSetMarginBottomMethodInfo
    ResolveWebViewBaseMethod "setMarginEnd" o = Gtk.WidgetSetMarginEndMethodInfo
    ResolveWebViewBaseMethod "setMarginLeft" o = Gtk.WidgetSetMarginLeftMethodInfo
    ResolveWebViewBaseMethod "setMarginRight" o = Gtk.WidgetSetMarginRightMethodInfo
    ResolveWebViewBaseMethod "setMarginStart" o = Gtk.WidgetSetMarginStartMethodInfo
    ResolveWebViewBaseMethod "setMarginTop" o = Gtk.WidgetSetMarginTopMethodInfo
    ResolveWebViewBaseMethod "setNoShowAll" o = Gtk.WidgetSetNoShowAllMethodInfo
    ResolveWebViewBaseMethod "setOpacity" o = Gtk.WidgetSetOpacityMethodInfo
    ResolveWebViewBaseMethod "setParent" o = Gtk.WidgetSetParentMethodInfo
    ResolveWebViewBaseMethod "setParentWindow" o = Gtk.WidgetSetParentWindowMethodInfo
    ResolveWebViewBaseMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebViewBaseMethod "setRealized" o = Gtk.WidgetSetRealizedMethodInfo
    ResolveWebViewBaseMethod "setReallocateRedraws" o = Gtk.ContainerSetReallocateRedrawsMethodInfo
    ResolveWebViewBaseMethod "setReceivesDefault" o = Gtk.WidgetSetReceivesDefaultMethodInfo
    ResolveWebViewBaseMethod "setRedrawOnAllocate" o = Gtk.WidgetSetRedrawOnAllocateMethodInfo
    ResolveWebViewBaseMethod "setResizeMode" o = Gtk.ContainerSetResizeModeMethodInfo
    ResolveWebViewBaseMethod "setSensitive" o = Gtk.WidgetSetSensitiveMethodInfo
    ResolveWebViewBaseMethod "setSizeRequest" o = Gtk.WidgetSetSizeRequestMethodInfo
    ResolveWebViewBaseMethod "setState" o = Gtk.WidgetSetStateMethodInfo
    ResolveWebViewBaseMethod "setStateFlags" o = Gtk.WidgetSetStateFlagsMethodInfo
    ResolveWebViewBaseMethod "setStyle" o = Gtk.WidgetSetStyleMethodInfo
    ResolveWebViewBaseMethod "setSupportMultidevice" o = Gtk.WidgetSetSupportMultideviceMethodInfo
    ResolveWebViewBaseMethod "setTooltipMarkup" o = Gtk.WidgetSetTooltipMarkupMethodInfo
    ResolveWebViewBaseMethod "setTooltipText" o = Gtk.WidgetSetTooltipTextMethodInfo
    ResolveWebViewBaseMethod "setTooltipWindow" o = Gtk.WidgetSetTooltipWindowMethodInfo
    ResolveWebViewBaseMethod "setValign" o = Gtk.WidgetSetValignMethodInfo
    ResolveWebViewBaseMethod "setVexpand" o = Gtk.WidgetSetVexpandMethodInfo
    ResolveWebViewBaseMethod "setVexpandSet" o = Gtk.WidgetSetVexpandSetMethodInfo
    ResolveWebViewBaseMethod "setVisible" o = Gtk.WidgetSetVisibleMethodInfo
    ResolveWebViewBaseMethod "setVisual" o = Gtk.WidgetSetVisualMethodInfo
    ResolveWebViewBaseMethod "setWindow" o = Gtk.WidgetSetWindowMethodInfo
    ResolveWebViewBaseMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebViewBaseMethod t WebViewBase, MethodInfo info WebViewBase p) => IsLabelProxy t (WebViewBase -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebViewBaseMethod t WebViewBase, MethodInfo info WebViewBase p) => IsLabel t (WebViewBase -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList WebViewBase = WebViewBaseAttributeList
type WebViewBaseAttributeList = ('[ '("appPaintable", Gtk.WidgetAppPaintablePropertyInfo), '("borderWidth", Gtk.ContainerBorderWidthPropertyInfo), '("canDefault", Gtk.WidgetCanDefaultPropertyInfo), '("canFocus", Gtk.WidgetCanFocusPropertyInfo), '("child", Gtk.ContainerChildPropertyInfo), '("compositeChild", Gtk.WidgetCompositeChildPropertyInfo), '("doubleBuffered", Gtk.WidgetDoubleBufferedPropertyInfo), '("events", Gtk.WidgetEventsPropertyInfo), '("expand", Gtk.WidgetExpandPropertyInfo), '("halign", Gtk.WidgetHalignPropertyInfo), '("hasDefault", Gtk.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.WidgetHexpandSetPropertyInfo), '("isFocus", Gtk.WidgetIsFocusPropertyInfo), '("margin", Gtk.WidgetMarginPropertyInfo), '("marginBottom", Gtk.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.WidgetMarginEndPropertyInfo), '("marginLeft", Gtk.WidgetMarginLeftPropertyInfo), '("marginRight", Gtk.WidgetMarginRightPropertyInfo), '("marginStart", Gtk.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.WidgetMarginTopPropertyInfo), '("name", Gtk.WidgetNamePropertyInfo), '("noShowAll", Gtk.WidgetNoShowAllPropertyInfo), '("opacity", Gtk.WidgetOpacityPropertyInfo), '("parent", Gtk.WidgetParentPropertyInfo), '("receivesDefault", Gtk.WidgetReceivesDefaultPropertyInfo), '("resizeMode", Gtk.ContainerResizeModePropertyInfo), '("scaleFactor", Gtk.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.WidgetSensitivePropertyInfo), '("style", Gtk.WidgetStylePropertyInfo), '("tooltipMarkup", Gtk.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.WidgetTooltipTextPropertyInfo), '("valign", Gtk.WidgetValignPropertyInfo), '("vexpand", Gtk.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.WidgetVexpandSetPropertyInfo), '("visible", Gtk.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.WidgetWidthRequestPropertyInfo), '("window", Gtk.WidgetWindowPropertyInfo)] :: [(Symbol, *)])

type instance SignalList WebViewBase = WebViewBaseSignalList
type WebViewBaseSignalList = ('[ '("accelClosuresChanged", Gtk.WidgetAccelClosuresChangedSignalInfo), '("add", Gtk.ContainerAddSignalInfo), '("buttonPressEvent", Gtk.WidgetButtonPressEventSignalInfo), '("buttonReleaseEvent", Gtk.WidgetButtonReleaseEventSignalInfo), '("canActivateAccel", Gtk.WidgetCanActivateAccelSignalInfo), '("checkResize", Gtk.ContainerCheckResizeSignalInfo), '("childNotify", Gtk.WidgetChildNotifySignalInfo), '("compositedChanged", Gtk.WidgetCompositedChangedSignalInfo), '("configureEvent", Gtk.WidgetConfigureEventSignalInfo), '("damageEvent", Gtk.WidgetDamageEventSignalInfo), '("deleteEvent", Gtk.WidgetDeleteEventSignalInfo), '("destroy", Gtk.WidgetDestroySignalInfo), '("destroyEvent", Gtk.WidgetDestroyEventSignalInfo), '("directionChanged", Gtk.WidgetDirectionChangedSignalInfo), '("dragBegin", Gtk.WidgetDragBeginSignalInfo), '("dragDataDelete", Gtk.WidgetDragDataDeleteSignalInfo), '("dragDataGet", Gtk.WidgetDragDataGetSignalInfo), '("dragDataReceived", Gtk.WidgetDragDataReceivedSignalInfo), '("dragDrop", Gtk.WidgetDragDropSignalInfo), '("dragEnd", Gtk.WidgetDragEndSignalInfo), '("dragFailed", Gtk.WidgetDragFailedSignalInfo), '("dragLeave", Gtk.WidgetDragLeaveSignalInfo), '("dragMotion", Gtk.WidgetDragMotionSignalInfo), '("draw", Gtk.WidgetDrawSignalInfo), '("enterNotifyEvent", Gtk.WidgetEnterNotifyEventSignalInfo), '("event", Gtk.WidgetEventSignalInfo), '("eventAfter", Gtk.WidgetEventAfterSignalInfo), '("focus", Gtk.WidgetFocusSignalInfo), '("focusInEvent", Gtk.WidgetFocusInEventSignalInfo), '("focusOutEvent", Gtk.WidgetFocusOutEventSignalInfo), '("grabBrokenEvent", Gtk.WidgetGrabBrokenEventSignalInfo), '("grabFocus", Gtk.WidgetGrabFocusSignalInfo), '("grabNotify", Gtk.WidgetGrabNotifySignalInfo), '("hide", Gtk.WidgetHideSignalInfo), '("hierarchyChanged", Gtk.WidgetHierarchyChangedSignalInfo), '("keyPressEvent", Gtk.WidgetKeyPressEventSignalInfo), '("keyReleaseEvent", Gtk.WidgetKeyReleaseEventSignalInfo), '("keynavFailed", Gtk.WidgetKeynavFailedSignalInfo), '("leaveNotifyEvent", Gtk.WidgetLeaveNotifyEventSignalInfo), '("map", Gtk.WidgetMapSignalInfo), '("mapEvent", Gtk.WidgetMapEventSignalInfo), '("mnemonicActivate", Gtk.WidgetMnemonicActivateSignalInfo), '("motionNotifyEvent", Gtk.WidgetMotionNotifyEventSignalInfo), '("moveFocus", Gtk.WidgetMoveFocusSignalInfo), '("notify", GObject.ObjectNotifySignalInfo), '("parentSet", Gtk.WidgetParentSetSignalInfo), '("popupMenu", Gtk.WidgetPopupMenuSignalInfo), '("propertyNotifyEvent", Gtk.WidgetPropertyNotifyEventSignalInfo), '("proximityInEvent", Gtk.WidgetProximityInEventSignalInfo), '("proximityOutEvent", Gtk.WidgetProximityOutEventSignalInfo), '("queryTooltip", Gtk.WidgetQueryTooltipSignalInfo), '("realize", Gtk.WidgetRealizeSignalInfo), '("remove", Gtk.ContainerRemoveSignalInfo), '("screenChanged", Gtk.WidgetScreenChangedSignalInfo), '("scrollEvent", Gtk.WidgetScrollEventSignalInfo), '("selectionClearEvent", Gtk.WidgetSelectionClearEventSignalInfo), '("selectionGet", Gtk.WidgetSelectionGetSignalInfo), '("selectionNotifyEvent", Gtk.WidgetSelectionNotifyEventSignalInfo), '("selectionReceived", Gtk.WidgetSelectionReceivedSignalInfo), '("selectionRequestEvent", Gtk.WidgetSelectionRequestEventSignalInfo), '("setFocusChild", Gtk.ContainerSetFocusChildSignalInfo), '("show", Gtk.WidgetShowSignalInfo), '("showHelp", Gtk.WidgetShowHelpSignalInfo), '("sizeAllocate", Gtk.WidgetSizeAllocateSignalInfo), '("stateChanged", Gtk.WidgetStateChangedSignalInfo), '("stateFlagsChanged", Gtk.WidgetStateFlagsChangedSignalInfo), '("styleSet", Gtk.WidgetStyleSetSignalInfo), '("styleUpdated", Gtk.WidgetStyleUpdatedSignalInfo), '("touchEvent", Gtk.WidgetTouchEventSignalInfo), '("unmap", Gtk.WidgetUnmapSignalInfo), '("unmapEvent", Gtk.WidgetUnmapEventSignalInfo), '("unrealize", Gtk.WidgetUnrealizeSignalInfo), '("visibilityNotifyEvent", Gtk.WidgetVisibilityNotifyEventSignalInfo), '("windowStateEvent", Gtk.WidgetWindowStateEventSignalInfo)] :: [(Symbol, *)])


