

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.WebsiteDataManager
    ( 

-- * Exported types
    WebsiteDataManager(..)                  ,
    WebsiteDataManagerK                     ,
    toWebsiteDataManager                    ,
    noWebsiteDataManager                    ,


 -- * Methods
-- ** websiteDataManagerGetBaseCacheDirectory
    WebsiteDataManagerGetBaseCacheDirectoryMethodInfo,
    websiteDataManagerGetBaseCacheDirectory ,


-- ** websiteDataManagerGetBaseDataDirectory
    WebsiteDataManagerGetBaseDataDirectoryMethodInfo,
    websiteDataManagerGetBaseDataDirectory  ,


-- ** websiteDataManagerGetDiskCacheDirectory
    WebsiteDataManagerGetDiskCacheDirectoryMethodInfo,
    websiteDataManagerGetDiskCacheDirectory ,


-- ** websiteDataManagerGetIndexeddbDirectory
    WebsiteDataManagerGetIndexeddbDirectoryMethodInfo,
    websiteDataManagerGetIndexeddbDirectory ,


-- ** websiteDataManagerGetLocalStorageDirectory
    WebsiteDataManagerGetLocalStorageDirectoryMethodInfo,
    websiteDataManagerGetLocalStorageDirectory,


-- ** websiteDataManagerGetOfflineApplicationCacheDirectory
    WebsiteDataManagerGetOfflineApplicationCacheDirectoryMethodInfo,
    websiteDataManagerGetOfflineApplicationCacheDirectory,


-- ** websiteDataManagerGetWebsqlDirectory
    WebsiteDataManagerGetWebsqlDirectoryMethodInfo,
    websiteDataManagerGetWebsqlDirectory    ,




 -- * Properties
-- ** BaseCacheDirectory
    WebsiteDataManagerBaseCacheDirectoryPropertyInfo,
    constructWebsiteDataManagerBaseCacheDirectory,
    getWebsiteDataManagerBaseCacheDirectory ,
    websiteDataManagerBaseCacheDirectory    ,


-- ** BaseDataDirectory
    WebsiteDataManagerBaseDataDirectoryPropertyInfo,
    constructWebsiteDataManagerBaseDataDirectory,
    getWebsiteDataManagerBaseDataDirectory  ,
    websiteDataManagerBaseDataDirectory     ,


-- ** DiskCacheDirectory
    WebsiteDataManagerDiskCacheDirectoryPropertyInfo,
    constructWebsiteDataManagerDiskCacheDirectory,
    getWebsiteDataManagerDiskCacheDirectory ,
    websiteDataManagerDiskCacheDirectory    ,


-- ** IndexeddbDirectory
    WebsiteDataManagerIndexeddbDirectoryPropertyInfo,
    constructWebsiteDataManagerIndexeddbDirectory,
    getWebsiteDataManagerIndexeddbDirectory ,
    websiteDataManagerIndexeddbDirectory    ,


-- ** LocalStorageDirectory
    WebsiteDataManagerLocalStorageDirectoryPropertyInfo,
    constructWebsiteDataManagerLocalStorageDirectory,
    getWebsiteDataManagerLocalStorageDirectory,
    websiteDataManagerLocalStorageDirectory ,


-- ** OfflineApplicationCacheDirectory
    WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo,
    constructWebsiteDataManagerOfflineApplicationCacheDirectory,
    getWebsiteDataManagerOfflineApplicationCacheDirectory,
    websiteDataManagerOfflineApplicationCacheDirectory,


-- ** WebsqlDirectory
    WebsiteDataManagerWebsqlDirectoryPropertyInfo,
    constructWebsiteDataManagerWebsqlDirectory,
    getWebsiteDataManagerWebsqlDirectory    ,
    websiteDataManagerWebsqlDirectory       ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype WebsiteDataManager = WebsiteDataManager (ForeignPtr WebsiteDataManager)
foreign import ccall "webkit_website_data_manager_get_type"
    c_webkit_website_data_manager_get_type :: IO GType

type instance ParentTypes WebsiteDataManager = WebsiteDataManagerParentTypes
type WebsiteDataManagerParentTypes = '[GObject.Object]

instance GObject WebsiteDataManager where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_website_data_manager_get_type
    

class GObject o => WebsiteDataManagerK o
instance (GObject o, IsDescendantOf WebsiteDataManager o) => WebsiteDataManagerK o

toWebsiteDataManager :: WebsiteDataManagerK o => o -> IO WebsiteDataManager
toWebsiteDataManager = unsafeCastTo WebsiteDataManager

noWebsiteDataManager :: Maybe WebsiteDataManager
noWebsiteDataManager = Nothing

type family ResolveWebsiteDataManagerMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebsiteDataManagerMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebsiteDataManagerMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebsiteDataManagerMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebsiteDataManagerMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebsiteDataManagerMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebsiteDataManagerMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebsiteDataManagerMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebsiteDataManagerMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebsiteDataManagerMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebsiteDataManagerMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebsiteDataManagerMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebsiteDataManagerMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebsiteDataManagerMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebsiteDataManagerMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebsiteDataManagerMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebsiteDataManagerMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebsiteDataManagerMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebsiteDataManagerMethod "getBaseCacheDirectory" o = WebsiteDataManagerGetBaseCacheDirectoryMethodInfo
    ResolveWebsiteDataManagerMethod "getBaseDataDirectory" o = WebsiteDataManagerGetBaseDataDirectoryMethodInfo
    ResolveWebsiteDataManagerMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebsiteDataManagerMethod "getDiskCacheDirectory" o = WebsiteDataManagerGetDiskCacheDirectoryMethodInfo
    ResolveWebsiteDataManagerMethod "getIndexeddbDirectory" o = WebsiteDataManagerGetIndexeddbDirectoryMethodInfo
    ResolveWebsiteDataManagerMethod "getLocalStorageDirectory" o = WebsiteDataManagerGetLocalStorageDirectoryMethodInfo
    ResolveWebsiteDataManagerMethod "getOfflineApplicationCacheDirectory" o = WebsiteDataManagerGetOfflineApplicationCacheDirectoryMethodInfo
    ResolveWebsiteDataManagerMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebsiteDataManagerMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebsiteDataManagerMethod "getWebsqlDirectory" o = WebsiteDataManagerGetWebsqlDirectoryMethodInfo
    ResolveWebsiteDataManagerMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebsiteDataManagerMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebsiteDataManagerMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebsiteDataManagerMethod t WebsiteDataManager, MethodInfo info WebsiteDataManager p) => IsLabelProxy t (WebsiteDataManager -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebsiteDataManagerMethod t WebsiteDataManager, MethodInfo info WebsiteDataManager p) => IsLabel t (WebsiteDataManager -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "base-cache-directory"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebsiteDataManagerBaseCacheDirectory :: (MonadIO m, WebsiteDataManagerK o) => o -> m T.Text
getWebsiteDataManagerBaseCacheDirectory obj = liftIO $ checkUnexpectedNothing "getWebsiteDataManagerBaseCacheDirectory" $ getObjectPropertyString obj "base-cache-directory"

constructWebsiteDataManagerBaseCacheDirectory :: T.Text -> IO ([Char], GValue)
constructWebsiteDataManagerBaseCacheDirectory val = constructObjectPropertyString "base-cache-directory" (Just val)

data WebsiteDataManagerBaseCacheDirectoryPropertyInfo
instance AttrInfo WebsiteDataManagerBaseCacheDirectoryPropertyInfo where
    type AttrAllowedOps WebsiteDataManagerBaseCacheDirectoryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebsiteDataManagerBaseCacheDirectoryPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint WebsiteDataManagerBaseCacheDirectoryPropertyInfo = WebsiteDataManagerK
    type AttrGetType WebsiteDataManagerBaseCacheDirectoryPropertyInfo = T.Text
    type AttrLabel WebsiteDataManagerBaseCacheDirectoryPropertyInfo = "base-cache-directory"
    attrGet _ = getWebsiteDataManagerBaseCacheDirectory
    attrSet _ = undefined
    attrConstruct _ = constructWebsiteDataManagerBaseCacheDirectory
    attrClear _ = undefined

-- VVV Prop "base-data-directory"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebsiteDataManagerBaseDataDirectory :: (MonadIO m, WebsiteDataManagerK o) => o -> m T.Text
getWebsiteDataManagerBaseDataDirectory obj = liftIO $ checkUnexpectedNothing "getWebsiteDataManagerBaseDataDirectory" $ getObjectPropertyString obj "base-data-directory"

constructWebsiteDataManagerBaseDataDirectory :: T.Text -> IO ([Char], GValue)
constructWebsiteDataManagerBaseDataDirectory val = constructObjectPropertyString "base-data-directory" (Just val)

data WebsiteDataManagerBaseDataDirectoryPropertyInfo
instance AttrInfo WebsiteDataManagerBaseDataDirectoryPropertyInfo where
    type AttrAllowedOps WebsiteDataManagerBaseDataDirectoryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebsiteDataManagerBaseDataDirectoryPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint WebsiteDataManagerBaseDataDirectoryPropertyInfo = WebsiteDataManagerK
    type AttrGetType WebsiteDataManagerBaseDataDirectoryPropertyInfo = T.Text
    type AttrLabel WebsiteDataManagerBaseDataDirectoryPropertyInfo = "base-data-directory"
    attrGet _ = getWebsiteDataManagerBaseDataDirectory
    attrSet _ = undefined
    attrConstruct _ = constructWebsiteDataManagerBaseDataDirectory
    attrClear _ = undefined

-- VVV Prop "disk-cache-directory"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebsiteDataManagerDiskCacheDirectory :: (MonadIO m, WebsiteDataManagerK o) => o -> m T.Text
getWebsiteDataManagerDiskCacheDirectory obj = liftIO $ checkUnexpectedNothing "getWebsiteDataManagerDiskCacheDirectory" $ getObjectPropertyString obj "disk-cache-directory"

constructWebsiteDataManagerDiskCacheDirectory :: T.Text -> IO ([Char], GValue)
constructWebsiteDataManagerDiskCacheDirectory val = constructObjectPropertyString "disk-cache-directory" (Just val)

data WebsiteDataManagerDiskCacheDirectoryPropertyInfo
instance AttrInfo WebsiteDataManagerDiskCacheDirectoryPropertyInfo where
    type AttrAllowedOps WebsiteDataManagerDiskCacheDirectoryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebsiteDataManagerDiskCacheDirectoryPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint WebsiteDataManagerDiskCacheDirectoryPropertyInfo = WebsiteDataManagerK
    type AttrGetType WebsiteDataManagerDiskCacheDirectoryPropertyInfo = T.Text
    type AttrLabel WebsiteDataManagerDiskCacheDirectoryPropertyInfo = "disk-cache-directory"
    attrGet _ = getWebsiteDataManagerDiskCacheDirectory
    attrSet _ = undefined
    attrConstruct _ = constructWebsiteDataManagerDiskCacheDirectory
    attrClear _ = undefined

-- VVV Prop "indexeddb-directory"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebsiteDataManagerIndexeddbDirectory :: (MonadIO m, WebsiteDataManagerK o) => o -> m T.Text
getWebsiteDataManagerIndexeddbDirectory obj = liftIO $ checkUnexpectedNothing "getWebsiteDataManagerIndexeddbDirectory" $ getObjectPropertyString obj "indexeddb-directory"

constructWebsiteDataManagerIndexeddbDirectory :: T.Text -> IO ([Char], GValue)
constructWebsiteDataManagerIndexeddbDirectory val = constructObjectPropertyString "indexeddb-directory" (Just val)

data WebsiteDataManagerIndexeddbDirectoryPropertyInfo
instance AttrInfo WebsiteDataManagerIndexeddbDirectoryPropertyInfo where
    type AttrAllowedOps WebsiteDataManagerIndexeddbDirectoryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebsiteDataManagerIndexeddbDirectoryPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint WebsiteDataManagerIndexeddbDirectoryPropertyInfo = WebsiteDataManagerK
    type AttrGetType WebsiteDataManagerIndexeddbDirectoryPropertyInfo = T.Text
    type AttrLabel WebsiteDataManagerIndexeddbDirectoryPropertyInfo = "indexeddb-directory"
    attrGet _ = getWebsiteDataManagerIndexeddbDirectory
    attrSet _ = undefined
    attrConstruct _ = constructWebsiteDataManagerIndexeddbDirectory
    attrClear _ = undefined

-- VVV Prop "local-storage-directory"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebsiteDataManagerLocalStorageDirectory :: (MonadIO m, WebsiteDataManagerK o) => o -> m T.Text
getWebsiteDataManagerLocalStorageDirectory obj = liftIO $ checkUnexpectedNothing "getWebsiteDataManagerLocalStorageDirectory" $ getObjectPropertyString obj "local-storage-directory"

constructWebsiteDataManagerLocalStorageDirectory :: T.Text -> IO ([Char], GValue)
constructWebsiteDataManagerLocalStorageDirectory val = constructObjectPropertyString "local-storage-directory" (Just val)

data WebsiteDataManagerLocalStorageDirectoryPropertyInfo
instance AttrInfo WebsiteDataManagerLocalStorageDirectoryPropertyInfo where
    type AttrAllowedOps WebsiteDataManagerLocalStorageDirectoryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebsiteDataManagerLocalStorageDirectoryPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint WebsiteDataManagerLocalStorageDirectoryPropertyInfo = WebsiteDataManagerK
    type AttrGetType WebsiteDataManagerLocalStorageDirectoryPropertyInfo = T.Text
    type AttrLabel WebsiteDataManagerLocalStorageDirectoryPropertyInfo = "local-storage-directory"
    attrGet _ = getWebsiteDataManagerLocalStorageDirectory
    attrSet _ = undefined
    attrConstruct _ = constructWebsiteDataManagerLocalStorageDirectory
    attrClear _ = undefined

-- VVV Prop "offline-application-cache-directory"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebsiteDataManagerOfflineApplicationCacheDirectory :: (MonadIO m, WebsiteDataManagerK o) => o -> m T.Text
getWebsiteDataManagerOfflineApplicationCacheDirectory obj = liftIO $ checkUnexpectedNothing "getWebsiteDataManagerOfflineApplicationCacheDirectory" $ getObjectPropertyString obj "offline-application-cache-directory"

constructWebsiteDataManagerOfflineApplicationCacheDirectory :: T.Text -> IO ([Char], GValue)
constructWebsiteDataManagerOfflineApplicationCacheDirectory val = constructObjectPropertyString "offline-application-cache-directory" (Just val)

data WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo
instance AttrInfo WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo where
    type AttrAllowedOps WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo = WebsiteDataManagerK
    type AttrGetType WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo = T.Text
    type AttrLabel WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo = "offline-application-cache-directory"
    attrGet _ = getWebsiteDataManagerOfflineApplicationCacheDirectory
    attrSet _ = undefined
    attrConstruct _ = constructWebsiteDataManagerOfflineApplicationCacheDirectory
    attrClear _ = undefined

-- VVV Prop "websql-directory"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebsiteDataManagerWebsqlDirectory :: (MonadIO m, WebsiteDataManagerK o) => o -> m T.Text
getWebsiteDataManagerWebsqlDirectory obj = liftIO $ checkUnexpectedNothing "getWebsiteDataManagerWebsqlDirectory" $ getObjectPropertyString obj "websql-directory"

constructWebsiteDataManagerWebsqlDirectory :: T.Text -> IO ([Char], GValue)
constructWebsiteDataManagerWebsqlDirectory val = constructObjectPropertyString "websql-directory" (Just val)

data WebsiteDataManagerWebsqlDirectoryPropertyInfo
instance AttrInfo WebsiteDataManagerWebsqlDirectoryPropertyInfo where
    type AttrAllowedOps WebsiteDataManagerWebsqlDirectoryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebsiteDataManagerWebsqlDirectoryPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint WebsiteDataManagerWebsqlDirectoryPropertyInfo = WebsiteDataManagerK
    type AttrGetType WebsiteDataManagerWebsqlDirectoryPropertyInfo = T.Text
    type AttrLabel WebsiteDataManagerWebsqlDirectoryPropertyInfo = "websql-directory"
    attrGet _ = getWebsiteDataManagerWebsqlDirectory
    attrSet _ = undefined
    attrConstruct _ = constructWebsiteDataManagerWebsqlDirectory
    attrClear _ = undefined

type instance AttributeList WebsiteDataManager = WebsiteDataManagerAttributeList
type WebsiteDataManagerAttributeList = ('[ '("baseCacheDirectory", WebsiteDataManagerBaseCacheDirectoryPropertyInfo), '("baseDataDirectory", WebsiteDataManagerBaseDataDirectoryPropertyInfo), '("diskCacheDirectory", WebsiteDataManagerDiskCacheDirectoryPropertyInfo), '("indexeddbDirectory", WebsiteDataManagerIndexeddbDirectoryPropertyInfo), '("localStorageDirectory", WebsiteDataManagerLocalStorageDirectoryPropertyInfo), '("offlineApplicationCacheDirectory", WebsiteDataManagerOfflineApplicationCacheDirectoryPropertyInfo), '("websqlDirectory", WebsiteDataManagerWebsqlDirectoryPropertyInfo)] :: [(Symbol, *)])

websiteDataManagerBaseCacheDirectory :: AttrLabelProxy "baseCacheDirectory"
websiteDataManagerBaseCacheDirectory = AttrLabelProxy

websiteDataManagerBaseDataDirectory :: AttrLabelProxy "baseDataDirectory"
websiteDataManagerBaseDataDirectory = AttrLabelProxy

websiteDataManagerDiskCacheDirectory :: AttrLabelProxy "diskCacheDirectory"
websiteDataManagerDiskCacheDirectory = AttrLabelProxy

websiteDataManagerIndexeddbDirectory :: AttrLabelProxy "indexeddbDirectory"
websiteDataManagerIndexeddbDirectory = AttrLabelProxy

websiteDataManagerLocalStorageDirectory :: AttrLabelProxy "localStorageDirectory"
websiteDataManagerLocalStorageDirectory = AttrLabelProxy

websiteDataManagerOfflineApplicationCacheDirectory :: AttrLabelProxy "offlineApplicationCacheDirectory"
websiteDataManagerOfflineApplicationCacheDirectory = AttrLabelProxy

websiteDataManagerWebsqlDirectory :: AttrLabelProxy "websqlDirectory"
websiteDataManagerWebsqlDirectory = AttrLabelProxy

type instance SignalList WebsiteDataManager = WebsiteDataManagerSignalList
type WebsiteDataManagerSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method WebsiteDataManager::get_base_cache_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebsiteDataManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_website_data_manager_get_base_cache_directory" webkit_website_data_manager_get_base_cache_directory :: 
    Ptr WebsiteDataManager ->               -- _obj : TInterface "WebKit2" "WebsiteDataManager"
    IO CString


websiteDataManagerGetBaseCacheDirectory ::
    (MonadIO m, WebsiteDataManagerK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
websiteDataManagerGetBaseCacheDirectory _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_website_data_manager_get_base_cache_directory _obj'
    checkUnexpectedReturnNULL "webkit_website_data_manager_get_base_cache_directory" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebsiteDataManagerGetBaseCacheDirectoryMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebsiteDataManagerK a) => MethodInfo WebsiteDataManagerGetBaseCacheDirectoryMethodInfo a signature where
    overloadedMethod _ = websiteDataManagerGetBaseCacheDirectory

-- method WebsiteDataManager::get_base_data_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebsiteDataManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_website_data_manager_get_base_data_directory" webkit_website_data_manager_get_base_data_directory :: 
    Ptr WebsiteDataManager ->               -- _obj : TInterface "WebKit2" "WebsiteDataManager"
    IO CString


websiteDataManagerGetBaseDataDirectory ::
    (MonadIO m, WebsiteDataManagerK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
websiteDataManagerGetBaseDataDirectory _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_website_data_manager_get_base_data_directory _obj'
    checkUnexpectedReturnNULL "webkit_website_data_manager_get_base_data_directory" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebsiteDataManagerGetBaseDataDirectoryMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebsiteDataManagerK a) => MethodInfo WebsiteDataManagerGetBaseDataDirectoryMethodInfo a signature where
    overloadedMethod _ = websiteDataManagerGetBaseDataDirectory

-- method WebsiteDataManager::get_disk_cache_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebsiteDataManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_website_data_manager_get_disk_cache_directory" webkit_website_data_manager_get_disk_cache_directory :: 
    Ptr WebsiteDataManager ->               -- _obj : TInterface "WebKit2" "WebsiteDataManager"
    IO CString


websiteDataManagerGetDiskCacheDirectory ::
    (MonadIO m, WebsiteDataManagerK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
websiteDataManagerGetDiskCacheDirectory _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_website_data_manager_get_disk_cache_directory _obj'
    checkUnexpectedReturnNULL "webkit_website_data_manager_get_disk_cache_directory" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebsiteDataManagerGetDiskCacheDirectoryMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebsiteDataManagerK a) => MethodInfo WebsiteDataManagerGetDiskCacheDirectoryMethodInfo a signature where
    overloadedMethod _ = websiteDataManagerGetDiskCacheDirectory

-- method WebsiteDataManager::get_indexeddb_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebsiteDataManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_website_data_manager_get_indexeddb_directory" webkit_website_data_manager_get_indexeddb_directory :: 
    Ptr WebsiteDataManager ->               -- _obj : TInterface "WebKit2" "WebsiteDataManager"
    IO CString


websiteDataManagerGetIndexeddbDirectory ::
    (MonadIO m, WebsiteDataManagerK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
websiteDataManagerGetIndexeddbDirectory _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_website_data_manager_get_indexeddb_directory _obj'
    checkUnexpectedReturnNULL "webkit_website_data_manager_get_indexeddb_directory" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebsiteDataManagerGetIndexeddbDirectoryMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebsiteDataManagerK a) => MethodInfo WebsiteDataManagerGetIndexeddbDirectoryMethodInfo a signature where
    overloadedMethod _ = websiteDataManagerGetIndexeddbDirectory

-- method WebsiteDataManager::get_local_storage_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebsiteDataManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_website_data_manager_get_local_storage_directory" webkit_website_data_manager_get_local_storage_directory :: 
    Ptr WebsiteDataManager ->               -- _obj : TInterface "WebKit2" "WebsiteDataManager"
    IO CString


websiteDataManagerGetLocalStorageDirectory ::
    (MonadIO m, WebsiteDataManagerK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
websiteDataManagerGetLocalStorageDirectory _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_website_data_manager_get_local_storage_directory _obj'
    checkUnexpectedReturnNULL "webkit_website_data_manager_get_local_storage_directory" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebsiteDataManagerGetLocalStorageDirectoryMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebsiteDataManagerK a) => MethodInfo WebsiteDataManagerGetLocalStorageDirectoryMethodInfo a signature where
    overloadedMethod _ = websiteDataManagerGetLocalStorageDirectory

-- method WebsiteDataManager::get_offline_application_cache_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebsiteDataManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_website_data_manager_get_offline_application_cache_directory" webkit_website_data_manager_get_offline_application_cache_directory :: 
    Ptr WebsiteDataManager ->               -- _obj : TInterface "WebKit2" "WebsiteDataManager"
    IO CString


websiteDataManagerGetOfflineApplicationCacheDirectory ::
    (MonadIO m, WebsiteDataManagerK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
websiteDataManagerGetOfflineApplicationCacheDirectory _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_website_data_manager_get_offline_application_cache_directory _obj'
    checkUnexpectedReturnNULL "webkit_website_data_manager_get_offline_application_cache_directory" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebsiteDataManagerGetOfflineApplicationCacheDirectoryMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebsiteDataManagerK a) => MethodInfo WebsiteDataManagerGetOfflineApplicationCacheDirectoryMethodInfo a signature where
    overloadedMethod _ = websiteDataManagerGetOfflineApplicationCacheDirectory

-- method WebsiteDataManager::get_websql_directory
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebsiteDataManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_website_data_manager_get_websql_directory" webkit_website_data_manager_get_websql_directory :: 
    Ptr WebsiteDataManager ->               -- _obj : TInterface "WebKit2" "WebsiteDataManager"
    IO CString


websiteDataManagerGetWebsqlDirectory ::
    (MonadIO m, WebsiteDataManagerK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
websiteDataManagerGetWebsqlDirectory _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_website_data_manager_get_websql_directory _obj'
    checkUnexpectedReturnNULL "webkit_website_data_manager_get_websql_directory" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebsiteDataManagerGetWebsqlDirectoryMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebsiteDataManagerK a) => MethodInfo WebsiteDataManagerGetWebsqlDirectoryMethodInfo a signature where
    overloadedMethod _ = websiteDataManagerGetWebsqlDirectory


