

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.WindowProperties
    ( 

-- * Exported types
    WindowProperties(..)                    ,
    WindowPropertiesK                       ,
    toWindowProperties                      ,
    noWindowProperties                      ,


 -- * Methods
-- ** windowPropertiesGetFullscreen
    WindowPropertiesGetFullscreenMethodInfo ,
    windowPropertiesGetFullscreen           ,


-- ** windowPropertiesGetGeometry
    WindowPropertiesGetGeometryMethodInfo   ,
    windowPropertiesGetGeometry             ,


-- ** windowPropertiesGetLocationbarVisible
    WindowPropertiesGetLocationbarVisibleMethodInfo,
    windowPropertiesGetLocationbarVisible   ,


-- ** windowPropertiesGetMenubarVisible
    WindowPropertiesGetMenubarVisibleMethodInfo,
    windowPropertiesGetMenubarVisible       ,


-- ** windowPropertiesGetResizable
    WindowPropertiesGetResizableMethodInfo  ,
    windowPropertiesGetResizable            ,


-- ** windowPropertiesGetScrollbarsVisible
    WindowPropertiesGetScrollbarsVisibleMethodInfo,
    windowPropertiesGetScrollbarsVisible    ,


-- ** windowPropertiesGetStatusbarVisible
    WindowPropertiesGetStatusbarVisibleMethodInfo,
    windowPropertiesGetStatusbarVisible     ,


-- ** windowPropertiesGetToolbarVisible
    WindowPropertiesGetToolbarVisibleMethodInfo,
    windowPropertiesGetToolbarVisible       ,




 -- * Properties
-- ** Fullscreen
    WindowPropertiesFullscreenPropertyInfo  ,
    constructWindowPropertiesFullscreen     ,
    getWindowPropertiesFullscreen           ,
    windowPropertiesFullscreen              ,


-- ** Geometry
    WindowPropertiesGeometryPropertyInfo    ,
    constructWindowPropertiesGeometry       ,
    getWindowPropertiesGeometry             ,
    windowPropertiesGeometry                ,


-- ** LocationbarVisible
    WindowPropertiesLocationbarVisiblePropertyInfo,
    constructWindowPropertiesLocationbarVisible,
    getWindowPropertiesLocationbarVisible   ,
    windowPropertiesLocationbarVisible      ,


-- ** MenubarVisible
    WindowPropertiesMenubarVisiblePropertyInfo,
    constructWindowPropertiesMenubarVisible ,
    getWindowPropertiesMenubarVisible       ,
    windowPropertiesMenubarVisible          ,


-- ** Resizable
    WindowPropertiesResizablePropertyInfo   ,
    constructWindowPropertiesResizable      ,
    getWindowPropertiesResizable            ,
    windowPropertiesResizable               ,


-- ** ScrollbarsVisible
    WindowPropertiesScrollbarsVisiblePropertyInfo,
    constructWindowPropertiesScrollbarsVisible,
    getWindowPropertiesScrollbarsVisible    ,
    windowPropertiesScrollbarsVisible       ,


-- ** StatusbarVisible
    WindowPropertiesStatusbarVisiblePropertyInfo,
    constructWindowPropertiesStatusbarVisible,
    getWindowPropertiesStatusbarVisible     ,
    windowPropertiesStatusbarVisible        ,


-- ** ToolbarVisible
    WindowPropertiesToolbarVisiblePropertyInfo,
    constructWindowPropertiesToolbarVisible ,
    getWindowPropertiesToolbarVisible       ,
    windowPropertiesToolbarVisible          ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Gdk as Gdk

newtype WindowProperties = WindowProperties (ForeignPtr WindowProperties)
foreign import ccall "webkit_window_properties_get_type"
    c_webkit_window_properties_get_type :: IO GType

type instance ParentTypes WindowProperties = WindowPropertiesParentTypes
type WindowPropertiesParentTypes = '[GObject.Object]

instance GObject WindowProperties where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_window_properties_get_type
    

class GObject o => WindowPropertiesK o
instance (GObject o, IsDescendantOf WindowProperties o) => WindowPropertiesK o

toWindowProperties :: WindowPropertiesK o => o -> IO WindowProperties
toWindowProperties = unsafeCastTo WindowProperties

noWindowProperties :: Maybe WindowProperties
noWindowProperties = Nothing

type family ResolveWindowPropertiesMethod (t :: Symbol) (o :: *) :: * where
    ResolveWindowPropertiesMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWindowPropertiesMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWindowPropertiesMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWindowPropertiesMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWindowPropertiesMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWindowPropertiesMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWindowPropertiesMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWindowPropertiesMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWindowPropertiesMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWindowPropertiesMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWindowPropertiesMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWindowPropertiesMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWindowPropertiesMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWindowPropertiesMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWindowPropertiesMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWindowPropertiesMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWindowPropertiesMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWindowPropertiesMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWindowPropertiesMethod "getFullscreen" o = WindowPropertiesGetFullscreenMethodInfo
    ResolveWindowPropertiesMethod "getGeometry" o = WindowPropertiesGetGeometryMethodInfo
    ResolveWindowPropertiesMethod "getLocationbarVisible" o = WindowPropertiesGetLocationbarVisibleMethodInfo
    ResolveWindowPropertiesMethod "getMenubarVisible" o = WindowPropertiesGetMenubarVisibleMethodInfo
    ResolveWindowPropertiesMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWindowPropertiesMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWindowPropertiesMethod "getResizable" o = WindowPropertiesGetResizableMethodInfo
    ResolveWindowPropertiesMethod "getScrollbarsVisible" o = WindowPropertiesGetScrollbarsVisibleMethodInfo
    ResolveWindowPropertiesMethod "getStatusbarVisible" o = WindowPropertiesGetStatusbarVisibleMethodInfo
    ResolveWindowPropertiesMethod "getToolbarVisible" o = WindowPropertiesGetToolbarVisibleMethodInfo
    ResolveWindowPropertiesMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWindowPropertiesMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWindowPropertiesMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWindowPropertiesMethod t WindowProperties, MethodInfo info WindowProperties p) => IsLabelProxy t (WindowProperties -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWindowPropertiesMethod t WindowProperties, MethodInfo info WindowProperties p) => IsLabel t (WindowProperties -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "fullscreen"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWindowPropertiesFullscreen :: (MonadIO m, WindowPropertiesK o) => o -> m Bool
getWindowPropertiesFullscreen obj = liftIO $ getObjectPropertyBool obj "fullscreen"

constructWindowPropertiesFullscreen :: Bool -> IO ([Char], GValue)
constructWindowPropertiesFullscreen val = constructObjectPropertyBool "fullscreen" val

data WindowPropertiesFullscreenPropertyInfo
instance AttrInfo WindowPropertiesFullscreenPropertyInfo where
    type AttrAllowedOps WindowPropertiesFullscreenPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WindowPropertiesFullscreenPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint WindowPropertiesFullscreenPropertyInfo = WindowPropertiesK
    type AttrGetType WindowPropertiesFullscreenPropertyInfo = Bool
    type AttrLabel WindowPropertiesFullscreenPropertyInfo = "fullscreen"
    attrGet _ = getWindowPropertiesFullscreen
    attrSet _ = undefined
    attrConstruct _ = constructWindowPropertiesFullscreen
    attrClear _ = undefined

-- VVV Prop "geometry"
   -- Type: TInterface "Gdk" "Rectangle"
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

getWindowPropertiesGeometry :: (MonadIO m, WindowPropertiesK o) => o -> m (Maybe Gdk.Rectangle)
getWindowPropertiesGeometry obj = liftIO $ getObjectPropertyBoxed obj "geometry" Gdk.Rectangle

constructWindowPropertiesGeometry :: Gdk.Rectangle -> IO ([Char], GValue)
constructWindowPropertiesGeometry val = constructObjectPropertyBoxed "geometry" (Just val)

data WindowPropertiesGeometryPropertyInfo
instance AttrInfo WindowPropertiesGeometryPropertyInfo where
    type AttrAllowedOps WindowPropertiesGeometryPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WindowPropertiesGeometryPropertyInfo = (~) Gdk.Rectangle
    type AttrBaseTypeConstraint WindowPropertiesGeometryPropertyInfo = WindowPropertiesK
    type AttrGetType WindowPropertiesGeometryPropertyInfo = (Maybe Gdk.Rectangle)
    type AttrLabel WindowPropertiesGeometryPropertyInfo = "geometry"
    attrGet _ = getWindowPropertiesGeometry
    attrSet _ = undefined
    attrConstruct _ = constructWindowPropertiesGeometry
    attrClear _ = undefined

-- VVV Prop "locationbar-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWindowPropertiesLocationbarVisible :: (MonadIO m, WindowPropertiesK o) => o -> m Bool
getWindowPropertiesLocationbarVisible obj = liftIO $ getObjectPropertyBool obj "locationbar-visible"

constructWindowPropertiesLocationbarVisible :: Bool -> IO ([Char], GValue)
constructWindowPropertiesLocationbarVisible val = constructObjectPropertyBool "locationbar-visible" val

data WindowPropertiesLocationbarVisiblePropertyInfo
instance AttrInfo WindowPropertiesLocationbarVisiblePropertyInfo where
    type AttrAllowedOps WindowPropertiesLocationbarVisiblePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WindowPropertiesLocationbarVisiblePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint WindowPropertiesLocationbarVisiblePropertyInfo = WindowPropertiesK
    type AttrGetType WindowPropertiesLocationbarVisiblePropertyInfo = Bool
    type AttrLabel WindowPropertiesLocationbarVisiblePropertyInfo = "locationbar-visible"
    attrGet _ = getWindowPropertiesLocationbarVisible
    attrSet _ = undefined
    attrConstruct _ = constructWindowPropertiesLocationbarVisible
    attrClear _ = undefined

-- VVV Prop "menubar-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWindowPropertiesMenubarVisible :: (MonadIO m, WindowPropertiesK o) => o -> m Bool
getWindowPropertiesMenubarVisible obj = liftIO $ getObjectPropertyBool obj "menubar-visible"

constructWindowPropertiesMenubarVisible :: Bool -> IO ([Char], GValue)
constructWindowPropertiesMenubarVisible val = constructObjectPropertyBool "menubar-visible" val

data WindowPropertiesMenubarVisiblePropertyInfo
instance AttrInfo WindowPropertiesMenubarVisiblePropertyInfo where
    type AttrAllowedOps WindowPropertiesMenubarVisiblePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WindowPropertiesMenubarVisiblePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint WindowPropertiesMenubarVisiblePropertyInfo = WindowPropertiesK
    type AttrGetType WindowPropertiesMenubarVisiblePropertyInfo = Bool
    type AttrLabel WindowPropertiesMenubarVisiblePropertyInfo = "menubar-visible"
    attrGet _ = getWindowPropertiesMenubarVisible
    attrSet _ = undefined
    attrConstruct _ = constructWindowPropertiesMenubarVisible
    attrClear _ = undefined

-- VVV Prop "resizable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWindowPropertiesResizable :: (MonadIO m, WindowPropertiesK o) => o -> m Bool
getWindowPropertiesResizable obj = liftIO $ getObjectPropertyBool obj "resizable"

constructWindowPropertiesResizable :: Bool -> IO ([Char], GValue)
constructWindowPropertiesResizable val = constructObjectPropertyBool "resizable" val

data WindowPropertiesResizablePropertyInfo
instance AttrInfo WindowPropertiesResizablePropertyInfo where
    type AttrAllowedOps WindowPropertiesResizablePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WindowPropertiesResizablePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint WindowPropertiesResizablePropertyInfo = WindowPropertiesK
    type AttrGetType WindowPropertiesResizablePropertyInfo = Bool
    type AttrLabel WindowPropertiesResizablePropertyInfo = "resizable"
    attrGet _ = getWindowPropertiesResizable
    attrSet _ = undefined
    attrConstruct _ = constructWindowPropertiesResizable
    attrClear _ = undefined

-- VVV Prop "scrollbars-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWindowPropertiesScrollbarsVisible :: (MonadIO m, WindowPropertiesK o) => o -> m Bool
getWindowPropertiesScrollbarsVisible obj = liftIO $ getObjectPropertyBool obj "scrollbars-visible"

constructWindowPropertiesScrollbarsVisible :: Bool -> IO ([Char], GValue)
constructWindowPropertiesScrollbarsVisible val = constructObjectPropertyBool "scrollbars-visible" val

data WindowPropertiesScrollbarsVisiblePropertyInfo
instance AttrInfo WindowPropertiesScrollbarsVisiblePropertyInfo where
    type AttrAllowedOps WindowPropertiesScrollbarsVisiblePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WindowPropertiesScrollbarsVisiblePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint WindowPropertiesScrollbarsVisiblePropertyInfo = WindowPropertiesK
    type AttrGetType WindowPropertiesScrollbarsVisiblePropertyInfo = Bool
    type AttrLabel WindowPropertiesScrollbarsVisiblePropertyInfo = "scrollbars-visible"
    attrGet _ = getWindowPropertiesScrollbarsVisible
    attrSet _ = undefined
    attrConstruct _ = constructWindowPropertiesScrollbarsVisible
    attrClear _ = undefined

-- VVV Prop "statusbar-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWindowPropertiesStatusbarVisible :: (MonadIO m, WindowPropertiesK o) => o -> m Bool
getWindowPropertiesStatusbarVisible obj = liftIO $ getObjectPropertyBool obj "statusbar-visible"

constructWindowPropertiesStatusbarVisible :: Bool -> IO ([Char], GValue)
constructWindowPropertiesStatusbarVisible val = constructObjectPropertyBool "statusbar-visible" val

data WindowPropertiesStatusbarVisiblePropertyInfo
instance AttrInfo WindowPropertiesStatusbarVisiblePropertyInfo where
    type AttrAllowedOps WindowPropertiesStatusbarVisiblePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WindowPropertiesStatusbarVisiblePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint WindowPropertiesStatusbarVisiblePropertyInfo = WindowPropertiesK
    type AttrGetType WindowPropertiesStatusbarVisiblePropertyInfo = Bool
    type AttrLabel WindowPropertiesStatusbarVisiblePropertyInfo = "statusbar-visible"
    attrGet _ = getWindowPropertiesStatusbarVisible
    attrSet _ = undefined
    attrConstruct _ = constructWindowPropertiesStatusbarVisible
    attrClear _ = undefined

-- VVV Prop "toolbar-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWindowPropertiesToolbarVisible :: (MonadIO m, WindowPropertiesK o) => o -> m Bool
getWindowPropertiesToolbarVisible obj = liftIO $ getObjectPropertyBool obj "toolbar-visible"

constructWindowPropertiesToolbarVisible :: Bool -> IO ([Char], GValue)
constructWindowPropertiesToolbarVisible val = constructObjectPropertyBool "toolbar-visible" val

data WindowPropertiesToolbarVisiblePropertyInfo
instance AttrInfo WindowPropertiesToolbarVisiblePropertyInfo where
    type AttrAllowedOps WindowPropertiesToolbarVisiblePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint WindowPropertiesToolbarVisiblePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint WindowPropertiesToolbarVisiblePropertyInfo = WindowPropertiesK
    type AttrGetType WindowPropertiesToolbarVisiblePropertyInfo = Bool
    type AttrLabel WindowPropertiesToolbarVisiblePropertyInfo = "toolbar-visible"
    attrGet _ = getWindowPropertiesToolbarVisible
    attrSet _ = undefined
    attrConstruct _ = constructWindowPropertiesToolbarVisible
    attrClear _ = undefined

type instance AttributeList WindowProperties = WindowPropertiesAttributeList
type WindowPropertiesAttributeList = ('[ '("fullscreen", WindowPropertiesFullscreenPropertyInfo), '("geometry", WindowPropertiesGeometryPropertyInfo), '("locationbarVisible", WindowPropertiesLocationbarVisiblePropertyInfo), '("menubarVisible", WindowPropertiesMenubarVisiblePropertyInfo), '("resizable", WindowPropertiesResizablePropertyInfo), '("scrollbarsVisible", WindowPropertiesScrollbarsVisiblePropertyInfo), '("statusbarVisible", WindowPropertiesStatusbarVisiblePropertyInfo), '("toolbarVisible", WindowPropertiesToolbarVisiblePropertyInfo)] :: [(Symbol, *)])

windowPropertiesFullscreen :: AttrLabelProxy "fullscreen"
windowPropertiesFullscreen = AttrLabelProxy

windowPropertiesGeometry :: AttrLabelProxy "geometry"
windowPropertiesGeometry = AttrLabelProxy

windowPropertiesLocationbarVisible :: AttrLabelProxy "locationbarVisible"
windowPropertiesLocationbarVisible = AttrLabelProxy

windowPropertiesMenubarVisible :: AttrLabelProxy "menubarVisible"
windowPropertiesMenubarVisible = AttrLabelProxy

windowPropertiesResizable :: AttrLabelProxy "resizable"
windowPropertiesResizable = AttrLabelProxy

windowPropertiesScrollbarsVisible :: AttrLabelProxy "scrollbarsVisible"
windowPropertiesScrollbarsVisible = AttrLabelProxy

windowPropertiesStatusbarVisible :: AttrLabelProxy "statusbarVisible"
windowPropertiesStatusbarVisible = AttrLabelProxy

windowPropertiesToolbarVisible :: AttrLabelProxy "toolbarVisible"
windowPropertiesToolbarVisible = AttrLabelProxy

type instance SignalList WindowProperties = WindowPropertiesSignalList
type WindowPropertiesSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method WindowProperties::get_fullscreen
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WindowProperties", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_window_properties_get_fullscreen" webkit_window_properties_get_fullscreen :: 
    Ptr WindowProperties ->                 -- _obj : TInterface "WebKit2" "WindowProperties"
    IO CInt


windowPropertiesGetFullscreen ::
    (MonadIO m, WindowPropertiesK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
windowPropertiesGetFullscreen _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_window_properties_get_fullscreen _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WindowPropertiesGetFullscreenMethodInfo
instance (signature ~ (m Bool), MonadIO m, WindowPropertiesK a) => MethodInfo WindowPropertiesGetFullscreenMethodInfo a signature where
    overloadedMethod _ = windowPropertiesGetFullscreen

-- method WindowProperties::get_geometry
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WindowProperties", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "geometry", argType = TInterface "Gdk" "Rectangle", direction = DirectionOut, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = True, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_window_properties_get_geometry" webkit_window_properties_get_geometry :: 
    Ptr WindowProperties ->                 -- _obj : TInterface "WebKit2" "WindowProperties"
    Ptr Gdk.Rectangle ->                    -- geometry : TInterface "Gdk" "Rectangle"
    IO ()


windowPropertiesGetGeometry ::
    (MonadIO m, WindowPropertiesK a) =>
    a                                       -- _obj
    -> m (Gdk.Rectangle)                    -- result
windowPropertiesGetGeometry _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    geometry <- callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle)
    webkit_window_properties_get_geometry _obj' geometry
    geometry' <- (wrapBoxed Gdk.Rectangle) geometry
    touchManagedPtr _obj
    return geometry'

data WindowPropertiesGetGeometryMethodInfo
instance (signature ~ (m (Gdk.Rectangle)), MonadIO m, WindowPropertiesK a) => MethodInfo WindowPropertiesGetGeometryMethodInfo a signature where
    overloadedMethod _ = windowPropertiesGetGeometry

-- method WindowProperties::get_locationbar_visible
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WindowProperties", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_window_properties_get_locationbar_visible" webkit_window_properties_get_locationbar_visible :: 
    Ptr WindowProperties ->                 -- _obj : TInterface "WebKit2" "WindowProperties"
    IO CInt


windowPropertiesGetLocationbarVisible ::
    (MonadIO m, WindowPropertiesK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
windowPropertiesGetLocationbarVisible _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_window_properties_get_locationbar_visible _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WindowPropertiesGetLocationbarVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, WindowPropertiesK a) => MethodInfo WindowPropertiesGetLocationbarVisibleMethodInfo a signature where
    overloadedMethod _ = windowPropertiesGetLocationbarVisible

-- method WindowProperties::get_menubar_visible
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WindowProperties", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_window_properties_get_menubar_visible" webkit_window_properties_get_menubar_visible :: 
    Ptr WindowProperties ->                 -- _obj : TInterface "WebKit2" "WindowProperties"
    IO CInt


windowPropertiesGetMenubarVisible ::
    (MonadIO m, WindowPropertiesK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
windowPropertiesGetMenubarVisible _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_window_properties_get_menubar_visible _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WindowPropertiesGetMenubarVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, WindowPropertiesK a) => MethodInfo WindowPropertiesGetMenubarVisibleMethodInfo a signature where
    overloadedMethod _ = windowPropertiesGetMenubarVisible

-- method WindowProperties::get_resizable
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WindowProperties", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_window_properties_get_resizable" webkit_window_properties_get_resizable :: 
    Ptr WindowProperties ->                 -- _obj : TInterface "WebKit2" "WindowProperties"
    IO CInt


windowPropertiesGetResizable ::
    (MonadIO m, WindowPropertiesK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
windowPropertiesGetResizable _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_window_properties_get_resizable _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WindowPropertiesGetResizableMethodInfo
instance (signature ~ (m Bool), MonadIO m, WindowPropertiesK a) => MethodInfo WindowPropertiesGetResizableMethodInfo a signature where
    overloadedMethod _ = windowPropertiesGetResizable

-- method WindowProperties::get_scrollbars_visible
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WindowProperties", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_window_properties_get_scrollbars_visible" webkit_window_properties_get_scrollbars_visible :: 
    Ptr WindowProperties ->                 -- _obj : TInterface "WebKit2" "WindowProperties"
    IO CInt


windowPropertiesGetScrollbarsVisible ::
    (MonadIO m, WindowPropertiesK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
windowPropertiesGetScrollbarsVisible _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_window_properties_get_scrollbars_visible _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WindowPropertiesGetScrollbarsVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, WindowPropertiesK a) => MethodInfo WindowPropertiesGetScrollbarsVisibleMethodInfo a signature where
    overloadedMethod _ = windowPropertiesGetScrollbarsVisible

-- method WindowProperties::get_statusbar_visible
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WindowProperties", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_window_properties_get_statusbar_visible" webkit_window_properties_get_statusbar_visible :: 
    Ptr WindowProperties ->                 -- _obj : TInterface "WebKit2" "WindowProperties"
    IO CInt


windowPropertiesGetStatusbarVisible ::
    (MonadIO m, WindowPropertiesK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
windowPropertiesGetStatusbarVisible _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_window_properties_get_statusbar_visible _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WindowPropertiesGetStatusbarVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, WindowPropertiesK a) => MethodInfo WindowPropertiesGetStatusbarVisibleMethodInfo a signature where
    overloadedMethod _ = windowPropertiesGetStatusbarVisible

-- method WindowProperties::get_toolbar_visible
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WindowProperties", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_window_properties_get_toolbar_visible" webkit_window_properties_get_toolbar_visible :: 
    Ptr WindowProperties ->                 -- _obj : TInterface "WebKit2" "WindowProperties"
    IO CInt


windowPropertiesGetToolbarVisible ::
    (MonadIO m, WindowPropertiesK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
windowPropertiesGetToolbarVisible _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_window_properties_get_toolbar_visible _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data WindowPropertiesGetToolbarVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, WindowPropertiesK a) => MethodInfo WindowPropertiesGetToolbarVisibleMethodInfo a signature where
    overloadedMethod _ = windowPropertiesGetToolbarVisible


