

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Structs.Credential
    ( 

-- * Exported types
    Credential(..)                          ,
    noCredential                            ,


 -- * Methods
-- ** credentialCopy
    CredentialCopyMethodInfo                ,
    credentialCopy                          ,


-- ** credentialFree
    CredentialFreeMethodInfo                ,
    credentialFree                          ,


-- ** credentialGetPassword
    CredentialGetPasswordMethodInfo         ,
    credentialGetPassword                   ,


-- ** credentialGetPersistence
    CredentialGetPersistenceMethodInfo      ,
    credentialGetPersistence                ,


-- ** credentialGetUsername
    CredentialGetUsernameMethodInfo         ,
    credentialGetUsername                   ,


-- ** credentialHasPassword
    CredentialHasPasswordMethodInfo         ,
    credentialHasPassword                   ,


-- ** credentialNew
    credentialNew                           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks

newtype Credential = Credential (ForeignPtr Credential)
foreign import ccall "webkit_credential_get_type" c_webkit_credential_get_type :: 
    IO GType

instance BoxedObject Credential where
    boxedType _ = c_webkit_credential_get_type

noCredential :: Maybe Credential
noCredential = Nothing


type instance AttributeList Credential = CredentialAttributeList
type CredentialAttributeList = ('[ ] :: [(Symbol, *)])

-- method Credential::new
-- method type : Constructor
-- Args : [Arg {argCName = "username", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "password", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "persistence", argType = TInterface "WebKit2" "CredentialPersistence", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "Credential")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_credential_new" webkit_credential_new :: 
    CString ->                              -- username : TBasicType TUTF8
    CString ->                              -- password : TBasicType TUTF8
    CUInt ->                                -- persistence : TInterface "WebKit2" "CredentialPersistence"
    IO (Ptr Credential)


credentialNew ::
    (MonadIO m) =>
    T.Text                                  -- username
    -> T.Text                               -- password
    -> CredentialPersistence                -- persistence
    -> m Credential                         -- result
credentialNew username password persistence = liftIO $ do
    username' <- textToCString username
    password' <- textToCString password
    let persistence' = (fromIntegral . fromEnum) persistence
    result <- webkit_credential_new username' password' persistence'
    checkUnexpectedReturnNULL "webkit_credential_new" result
    result' <- (wrapBoxed Credential) result
    freeMem username'
    freeMem password'
    return result'

-- method Credential::copy
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Credential", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "Credential")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_credential_copy" webkit_credential_copy :: 
    Ptr Credential ->                       -- _obj : TInterface "WebKit2" "Credential"
    IO (Ptr Credential)


credentialCopy ::
    (MonadIO m) =>
    Credential                              -- _obj
    -> m Credential                         -- result
credentialCopy _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_credential_copy _obj'
    checkUnexpectedReturnNULL "webkit_credential_copy" result
    result' <- (wrapBoxed Credential) result
    touchManagedPtr _obj
    return result'

data CredentialCopyMethodInfo
instance (signature ~ (m Credential), MonadIO m) => MethodInfo CredentialCopyMethodInfo Credential signature where
    overloadedMethod _ = credentialCopy

-- method Credential::free
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Credential", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_credential_free" webkit_credential_free :: 
    Ptr Credential ->                       -- _obj : TInterface "WebKit2" "Credential"
    IO ()


credentialFree ::
    (MonadIO m) =>
    Credential                              -- _obj
    -> m ()                                 -- result
credentialFree _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    webkit_credential_free _obj'
    touchManagedPtr _obj
    return ()

data CredentialFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => MethodInfo CredentialFreeMethodInfo Credential signature where
    overloadedMethod _ = credentialFree

-- method Credential::get_password
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Credential", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_credential_get_password" webkit_credential_get_password :: 
    Ptr Credential ->                       -- _obj : TInterface "WebKit2" "Credential"
    IO CString


credentialGetPassword ::
    (MonadIO m) =>
    Credential                              -- _obj
    -> m T.Text                             -- result
credentialGetPassword _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_credential_get_password _obj'
    checkUnexpectedReturnNULL "webkit_credential_get_password" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data CredentialGetPasswordMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => MethodInfo CredentialGetPasswordMethodInfo Credential signature where
    overloadedMethod _ = credentialGetPassword

-- method Credential::get_persistence
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Credential", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "CredentialPersistence")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_credential_get_persistence" webkit_credential_get_persistence :: 
    Ptr Credential ->                       -- _obj : TInterface "WebKit2" "Credential"
    IO CUInt


credentialGetPersistence ::
    (MonadIO m) =>
    Credential                              -- _obj
    -> m CredentialPersistence              -- result
credentialGetPersistence _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_credential_get_persistence _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data CredentialGetPersistenceMethodInfo
instance (signature ~ (m CredentialPersistence), MonadIO m) => MethodInfo CredentialGetPersistenceMethodInfo Credential signature where
    overloadedMethod _ = credentialGetPersistence

-- method Credential::get_username
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Credential", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_credential_get_username" webkit_credential_get_username :: 
    Ptr Credential ->                       -- _obj : TInterface "WebKit2" "Credential"
    IO CString


credentialGetUsername ::
    (MonadIO m) =>
    Credential                              -- _obj
    -> m T.Text                             -- result
credentialGetUsername _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_credential_get_username _obj'
    checkUnexpectedReturnNULL "webkit_credential_get_username" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data CredentialGetUsernameMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => MethodInfo CredentialGetUsernameMethodInfo Credential signature where
    overloadedMethod _ = credentialGetUsername

-- method Credential::has_password
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Credential", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_credential_has_password" webkit_credential_has_password :: 
    Ptr Credential ->                       -- _obj : TInterface "WebKit2" "Credential"
    IO CInt


credentialHasPassword ::
    (MonadIO m) =>
    Credential                              -- _obj
    -> m Bool                               -- result
credentialHasPassword _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_credential_has_password _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data CredentialHasPasswordMethodInfo
instance (signature ~ (m Bool), MonadIO m) => MethodInfo CredentialHasPasswordMethodInfo Credential signature where
    overloadedMethod _ = credentialHasPassword

type family ResolveCredentialMethod (t :: Symbol) (o :: *) :: * where
    ResolveCredentialMethod "copy" o = CredentialCopyMethodInfo
    ResolveCredentialMethod "free" o = CredentialFreeMethodInfo
    ResolveCredentialMethod "hasPassword" o = CredentialHasPasswordMethodInfo
    ResolveCredentialMethod "getPassword" o = CredentialGetPasswordMethodInfo
    ResolveCredentialMethod "getPersistence" o = CredentialGetPersistenceMethodInfo
    ResolveCredentialMethod "getUsername" o = CredentialGetUsernameMethodInfo
    ResolveCredentialMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveCredentialMethod t Credential, MethodInfo info Credential p) => IsLabelProxy t (Credential -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveCredentialMethod t Credential, MethodInfo info Credential p) => IsLabel t (Credential -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


