

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Structs.JavascriptResult
    ( 

-- * Exported types
    JavascriptResult(..)                    ,
    noJavascriptResult                      ,


 -- * Methods
-- ** javascriptResultGetGlobalContext
    JavascriptResultGetGlobalContextMethodInfo,
    javascriptResultGetGlobalContext        ,


-- ** javascriptResultGetValue
    JavascriptResultGetValueMethodInfo      ,
    javascriptResultGetValue                ,


-- ** javascriptResultRef
    JavascriptResultRefMethodInfo           ,
    javascriptResultRef                     ,


-- ** javascriptResultUnref
    JavascriptResultUnrefMethodInfo         ,
    javascriptResultUnref                   ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.JavaScriptCore as JavaScriptCore

newtype JavascriptResult = JavascriptResult (ForeignPtr JavascriptResult)
foreign import ccall "webkit_javascript_result_get_type" c_webkit_javascript_result_get_type :: 
    IO GType

instance BoxedObject JavascriptResult where
    boxedType _ = c_webkit_javascript_result_get_type

noJavascriptResult :: Maybe JavascriptResult
noJavascriptResult = Nothing


type instance AttributeList JavascriptResult = JavascriptResultAttributeList
type JavascriptResultAttributeList = ('[ ] :: [(Symbol, *)])

-- method JavascriptResult::get_global_context
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "JavascriptResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "JavaScriptCore" "GlobalContext")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_javascript_result_get_global_context" webkit_javascript_result_get_global_context :: 
    Ptr JavascriptResult ->                 -- _obj : TInterface "WebKit2" "JavascriptResult"
    IO (Ptr JavaScriptCore.GlobalContext)


javascriptResultGetGlobalContext ::
    (MonadIO m) =>
    JavascriptResult                        -- _obj
    -> m JavaScriptCore.GlobalContext       -- result
javascriptResultGetGlobalContext _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_javascript_result_get_global_context _obj'
    checkUnexpectedReturnNULL "webkit_javascript_result_get_global_context" result
    -- XXX Wrapping a foreign struct/union with no known destructor, leak?
    result' <- (\x -> JavaScriptCore.GlobalContext <$> newForeignPtr_ x) result
    touchManagedPtr _obj
    return result'

data JavascriptResultGetGlobalContextMethodInfo
instance (signature ~ (m JavaScriptCore.GlobalContext), MonadIO m) => MethodInfo JavascriptResultGetGlobalContextMethodInfo JavascriptResult signature where
    overloadedMethod _ = javascriptResultGetGlobalContext

-- method JavascriptResult::get_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "JavascriptResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "JavaScriptCore" "Value")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_javascript_result_get_value" webkit_javascript_result_get_value :: 
    Ptr JavascriptResult ->                 -- _obj : TInterface "WebKit2" "JavascriptResult"
    IO (Ptr JavaScriptCore.Value)


javascriptResultGetValue ::
    (MonadIO m) =>
    JavascriptResult                        -- _obj
    -> m JavaScriptCore.Value               -- result
javascriptResultGetValue _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_javascript_result_get_value _obj'
    checkUnexpectedReturnNULL "webkit_javascript_result_get_value" result
    -- XXX Wrapping a foreign struct/union with no known destructor, leak?
    result' <- (\x -> JavaScriptCore.Value <$> newForeignPtr_ x) result
    touchManagedPtr _obj
    return result'

data JavascriptResultGetValueMethodInfo
instance (signature ~ (m JavaScriptCore.Value), MonadIO m) => MethodInfo JavascriptResultGetValueMethodInfo JavascriptResult signature where
    overloadedMethod _ = javascriptResultGetValue

-- method JavascriptResult::ref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "JavascriptResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "JavascriptResult")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_javascript_result_ref" webkit_javascript_result_ref :: 
    Ptr JavascriptResult ->                 -- _obj : TInterface "WebKit2" "JavascriptResult"
    IO (Ptr JavascriptResult)


javascriptResultRef ::
    (MonadIO m) =>
    JavascriptResult                        -- _obj
    -> m JavascriptResult                   -- result
javascriptResultRef _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_javascript_result_ref _obj'
    checkUnexpectedReturnNULL "webkit_javascript_result_ref" result
    result' <- (wrapBoxed JavascriptResult) result
    touchManagedPtr _obj
    return result'

data JavascriptResultRefMethodInfo
instance (signature ~ (m JavascriptResult), MonadIO m) => MethodInfo JavascriptResultRefMethodInfo JavascriptResult signature where
    overloadedMethod _ = javascriptResultRef

-- method JavascriptResult::unref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "JavascriptResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_javascript_result_unref" webkit_javascript_result_unref :: 
    Ptr JavascriptResult ->                 -- _obj : TInterface "WebKit2" "JavascriptResult"
    IO ()


javascriptResultUnref ::
    (MonadIO m) =>
    JavascriptResult                        -- _obj
    -> m ()                                 -- result
javascriptResultUnref _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    webkit_javascript_result_unref _obj'
    touchManagedPtr _obj
    return ()

data JavascriptResultUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => MethodInfo JavascriptResultUnrefMethodInfo JavascriptResult signature where
    overloadedMethod _ = javascriptResultUnref

type family ResolveJavascriptResultMethod (t :: Symbol) (o :: *) :: * where
    ResolveJavascriptResultMethod "ref" o = JavascriptResultRefMethodInfo
    ResolveJavascriptResultMethod "unref" o = JavascriptResultUnrefMethodInfo
    ResolveJavascriptResultMethod "getGlobalContext" o = JavascriptResultGetGlobalContextMethodInfo
    ResolveJavascriptResultMethod "getValue" o = JavascriptResultGetValueMethodInfo
    ResolveJavascriptResultMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveJavascriptResultMethod t JavascriptResult, MethodInfo info JavascriptResult p) => IsLabelProxy t (JavascriptResult -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveJavascriptResultMethod t JavascriptResult, MethodInfo info JavascriptResult p) => IsLabel t (JavascriptResult -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


