

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Structs.MimeInfo
    ( 

-- * Exported types
    MimeInfo(..)                            ,
    noMimeInfo                              ,


 -- * Methods
-- ** mimeInfoGetDescription
    MimeInfoGetDescriptionMethodInfo        ,
    mimeInfoGetDescription                  ,


-- ** mimeInfoGetExtensions
    MimeInfoGetExtensionsMethodInfo         ,
    mimeInfoGetExtensions                   ,


-- ** mimeInfoGetMimeType
    MimeInfoGetMimeTypeMethodInfo           ,
    mimeInfoGetMimeType                     ,


-- ** mimeInfoRef
    MimeInfoRefMethodInfo                   ,
    mimeInfoRef                             ,


-- ** mimeInfoUnref
    MimeInfoUnrefMethodInfo                 ,
    mimeInfoUnref                           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks

newtype MimeInfo = MimeInfo (ForeignPtr MimeInfo)
foreign import ccall "webkit_mime_info_get_type" c_webkit_mime_info_get_type :: 
    IO GType

instance BoxedObject MimeInfo where
    boxedType _ = c_webkit_mime_info_get_type

noMimeInfo :: Maybe MimeInfo
noMimeInfo = Nothing


type instance AttributeList MimeInfo = MimeInfoAttributeList
type MimeInfoAttributeList = ('[ ] :: [(Symbol, *)])

-- method MimeInfo::get_description
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "MimeInfo", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_mime_info_get_description" webkit_mime_info_get_description :: 
    Ptr MimeInfo ->                         -- _obj : TInterface "WebKit2" "MimeInfo"
    IO CString


mimeInfoGetDescription ::
    (MonadIO m) =>
    MimeInfo                                -- _obj
    -> m T.Text                             -- result
mimeInfoGetDescription _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_mime_info_get_description _obj'
    checkUnexpectedReturnNULL "webkit_mime_info_get_description" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data MimeInfoGetDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => MethodInfo MimeInfoGetDescriptionMethodInfo MimeInfo signature where
    overloadedMethod _ = mimeInfoGetDescription

-- method MimeInfo::get_extensions
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "MimeInfo", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_mime_info_get_extensions" webkit_mime_info_get_extensions :: 
    Ptr MimeInfo ->                         -- _obj : TInterface "WebKit2" "MimeInfo"
    IO (Ptr CString)


mimeInfoGetExtensions ::
    (MonadIO m) =>
    MimeInfo                                -- _obj
    -> m [T.Text]                           -- result
mimeInfoGetExtensions _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_mime_info_get_extensions _obj'
    checkUnexpectedReturnNULL "webkit_mime_info_get_extensions" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr _obj
    return result'

data MimeInfoGetExtensionsMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m) => MethodInfo MimeInfoGetExtensionsMethodInfo MimeInfo signature where
    overloadedMethod _ = mimeInfoGetExtensions

-- method MimeInfo::get_mime_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "MimeInfo", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_mime_info_get_mime_type" webkit_mime_info_get_mime_type :: 
    Ptr MimeInfo ->                         -- _obj : TInterface "WebKit2" "MimeInfo"
    IO CString


mimeInfoGetMimeType ::
    (MonadIO m) =>
    MimeInfo                                -- _obj
    -> m T.Text                             -- result
mimeInfoGetMimeType _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_mime_info_get_mime_type _obj'
    checkUnexpectedReturnNULL "webkit_mime_info_get_mime_type" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data MimeInfoGetMimeTypeMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => MethodInfo MimeInfoGetMimeTypeMethodInfo MimeInfo signature where
    overloadedMethod _ = mimeInfoGetMimeType

-- method MimeInfo::ref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "MimeInfo", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "MimeInfo")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_mime_info_ref" webkit_mime_info_ref :: 
    Ptr MimeInfo ->                         -- _obj : TInterface "WebKit2" "MimeInfo"
    IO (Ptr MimeInfo)


mimeInfoRef ::
    (MonadIO m) =>
    MimeInfo                                -- _obj
    -> m MimeInfo                           -- result
mimeInfoRef _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_mime_info_ref _obj'
    checkUnexpectedReturnNULL "webkit_mime_info_ref" result
    result' <- (wrapBoxed MimeInfo) result
    touchManagedPtr _obj
    return result'

data MimeInfoRefMethodInfo
instance (signature ~ (m MimeInfo), MonadIO m) => MethodInfo MimeInfoRefMethodInfo MimeInfo signature where
    overloadedMethod _ = mimeInfoRef

-- method MimeInfo::unref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "MimeInfo", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_mime_info_unref" webkit_mime_info_unref :: 
    Ptr MimeInfo ->                         -- _obj : TInterface "WebKit2" "MimeInfo"
    IO ()


mimeInfoUnref ::
    (MonadIO m) =>
    MimeInfo                                -- _obj
    -> m ()                                 -- result
mimeInfoUnref _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    webkit_mime_info_unref _obj'
    touchManagedPtr _obj
    return ()

data MimeInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => MethodInfo MimeInfoUnrefMethodInfo MimeInfo signature where
    overloadedMethod _ = mimeInfoUnref

type family ResolveMimeInfoMethod (t :: Symbol) (o :: *) :: * where
    ResolveMimeInfoMethod "ref" o = MimeInfoRefMethodInfo
    ResolveMimeInfoMethod "unref" o = MimeInfoUnrefMethodInfo
    ResolveMimeInfoMethod "getDescription" o = MimeInfoGetDescriptionMethodInfo
    ResolveMimeInfoMethod "getExtensions" o = MimeInfoGetExtensionsMethodInfo
    ResolveMimeInfoMethod "getMimeType" o = MimeInfoGetMimeTypeMethodInfo
    ResolveMimeInfoMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveMimeInfoMethod t MimeInfo, MethodInfo info MimeInfo p) => IsLabelProxy t (MimeInfo -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveMimeInfoMethod t MimeInfo, MethodInfo info MimeInfo p) => IsLabel t (MimeInfo -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


