

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Structs.NavigationAction
    ( 

-- * Exported types
    NavigationAction(..)                    ,
    noNavigationAction                      ,


 -- * Methods
-- ** navigationActionCopy
    NavigationActionCopyMethodInfo          ,
    navigationActionCopy                    ,


-- ** navigationActionFree
    NavigationActionFreeMethodInfo          ,
    navigationActionFree                    ,


-- ** navigationActionGetModifiers
    NavigationActionGetModifiersMethodInfo  ,
    navigationActionGetModifiers            ,


-- ** navigationActionGetMouseButton
    NavigationActionGetMouseButtonMethodInfo,
    navigationActionGetMouseButton          ,


-- ** navigationActionGetNavigationType
    NavigationActionGetNavigationTypeMethodInfo,
    navigationActionGetNavigationType       ,


-- ** navigationActionGetRequest
    NavigationActionGetRequestMethodInfo    ,
    navigationActionGetRequest              ,


-- ** navigationActionIsUserGesture
    NavigationActionIsUserGestureMethodInfo ,
    navigationActionIsUserGesture           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks

newtype NavigationAction = NavigationAction (ForeignPtr NavigationAction)
foreign import ccall "webkit_navigation_action_get_type" c_webkit_navigation_action_get_type :: 
    IO GType

instance BoxedObject NavigationAction where
    boxedType _ = c_webkit_navigation_action_get_type

noNavigationAction :: Maybe NavigationAction
noNavigationAction = Nothing


type instance AttributeList NavigationAction = NavigationActionAttributeList
type NavigationActionAttributeList = ('[ ] :: [(Symbol, *)])

-- method NavigationAction::copy
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "NavigationAction")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_action_copy" webkit_navigation_action_copy :: 
    Ptr NavigationAction ->                 -- _obj : TInterface "WebKit2" "NavigationAction"
    IO (Ptr NavigationAction)


navigationActionCopy ::
    (MonadIO m) =>
    NavigationAction                        -- _obj
    -> m NavigationAction                   -- result
navigationActionCopy _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_navigation_action_copy _obj'
    checkUnexpectedReturnNULL "webkit_navigation_action_copy" result
    result' <- (wrapBoxed NavigationAction) result
    touchManagedPtr _obj
    return result'

data NavigationActionCopyMethodInfo
instance (signature ~ (m NavigationAction), MonadIO m) => MethodInfo NavigationActionCopyMethodInfo NavigationAction signature where
    overloadedMethod _ = navigationActionCopy

-- method NavigationAction::free
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_action_free" webkit_navigation_action_free :: 
    Ptr NavigationAction ->                 -- _obj : TInterface "WebKit2" "NavigationAction"
    IO ()


navigationActionFree ::
    (MonadIO m) =>
    NavigationAction                        -- _obj
    -> m ()                                 -- result
navigationActionFree _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    webkit_navigation_action_free _obj'
    touchManagedPtr _obj
    return ()

data NavigationActionFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => MethodInfo NavigationActionFreeMethodInfo NavigationAction signature where
    overloadedMethod _ = navigationActionFree

-- method NavigationAction::get_modifiers
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_action_get_modifiers" webkit_navigation_action_get_modifiers :: 
    Ptr NavigationAction ->                 -- _obj : TInterface "WebKit2" "NavigationAction"
    IO Word32


navigationActionGetModifiers ::
    (MonadIO m) =>
    NavigationAction                        -- _obj
    -> m Word32                             -- result
navigationActionGetModifiers _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_navigation_action_get_modifiers _obj'
    touchManagedPtr _obj
    return result

data NavigationActionGetModifiersMethodInfo
instance (signature ~ (m Word32), MonadIO m) => MethodInfo NavigationActionGetModifiersMethodInfo NavigationAction signature where
    overloadedMethod _ = navigationActionGetModifiers

-- method NavigationAction::get_mouse_button
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_action_get_mouse_button" webkit_navigation_action_get_mouse_button :: 
    Ptr NavigationAction ->                 -- _obj : TInterface "WebKit2" "NavigationAction"
    IO Word32


navigationActionGetMouseButton ::
    (MonadIO m) =>
    NavigationAction                        -- _obj
    -> m Word32                             -- result
navigationActionGetMouseButton _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_navigation_action_get_mouse_button _obj'
    touchManagedPtr _obj
    return result

data NavigationActionGetMouseButtonMethodInfo
instance (signature ~ (m Word32), MonadIO m) => MethodInfo NavigationActionGetMouseButtonMethodInfo NavigationAction signature where
    overloadedMethod _ = navigationActionGetMouseButton

-- method NavigationAction::get_navigation_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "NavigationType")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_action_get_navigation_type" webkit_navigation_action_get_navigation_type :: 
    Ptr NavigationAction ->                 -- _obj : TInterface "WebKit2" "NavigationAction"
    IO CUInt


navigationActionGetNavigationType ::
    (MonadIO m) =>
    NavigationAction                        -- _obj
    -> m NavigationType                     -- result
navigationActionGetNavigationType _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_navigation_action_get_navigation_type _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data NavigationActionGetNavigationTypeMethodInfo
instance (signature ~ (m NavigationType), MonadIO m) => MethodInfo NavigationActionGetNavigationTypeMethodInfo NavigationAction signature where
    overloadedMethod _ = navigationActionGetNavigationType

-- method NavigationAction::get_request
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "URIRequest")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_action_get_request" webkit_navigation_action_get_request :: 
    Ptr NavigationAction ->                 -- _obj : TInterface "WebKit2" "NavigationAction"
    IO (Ptr URIRequest)


navigationActionGetRequest ::
    (MonadIO m) =>
    NavigationAction                        -- _obj
    -> m URIRequest                         -- result
navigationActionGetRequest _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_navigation_action_get_request _obj'
    checkUnexpectedReturnNULL "webkit_navigation_action_get_request" result
    result' <- (newObject URIRequest) result
    touchManagedPtr _obj
    return result'

data NavigationActionGetRequestMethodInfo
instance (signature ~ (m URIRequest), MonadIO m) => MethodInfo NavigationActionGetRequestMethodInfo NavigationAction signature where
    overloadedMethod _ = navigationActionGetRequest

-- method NavigationAction::is_user_gesture
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_action_is_user_gesture" webkit_navigation_action_is_user_gesture :: 
    Ptr NavigationAction ->                 -- _obj : TInterface "WebKit2" "NavigationAction"
    IO CInt


navigationActionIsUserGesture ::
    (MonadIO m) =>
    NavigationAction                        -- _obj
    -> m Bool                               -- result
navigationActionIsUserGesture _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_navigation_action_is_user_gesture _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data NavigationActionIsUserGestureMethodInfo
instance (signature ~ (m Bool), MonadIO m) => MethodInfo NavigationActionIsUserGestureMethodInfo NavigationAction signature where
    overloadedMethod _ = navigationActionIsUserGesture

type family ResolveNavigationActionMethod (t :: Symbol) (o :: *) :: * where
    ResolveNavigationActionMethod "copy" o = NavigationActionCopyMethodInfo
    ResolveNavigationActionMethod "free" o = NavigationActionFreeMethodInfo
    ResolveNavigationActionMethod "isUserGesture" o = NavigationActionIsUserGestureMethodInfo
    ResolveNavigationActionMethod "getModifiers" o = NavigationActionGetModifiersMethodInfo
    ResolveNavigationActionMethod "getMouseButton" o = NavigationActionGetMouseButtonMethodInfo
    ResolveNavigationActionMethod "getNavigationType" o = NavigationActionGetNavigationTypeMethodInfo
    ResolveNavigationActionMethod "getRequest" o = NavigationActionGetRequestMethodInfo
    ResolveNavigationActionMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveNavigationActionMethod t NavigationAction, MethodInfo info NavigationAction p) => IsLabelProxy t (NavigationAction -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveNavigationActionMethod t NavigationAction, MethodInfo info NavigationAction p) => IsLabel t (NavigationAction -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


