

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Structs.ScriptDialog
    ( 

-- * Exported types
    ScriptDialog(..)                        ,
    noScriptDialog                          ,


 -- * Methods
-- ** scriptDialogConfirmSetConfirmed
    ScriptDialogConfirmSetConfirmedMethodInfo,
    scriptDialogConfirmSetConfirmed         ,


-- ** scriptDialogGetDialogType
    ScriptDialogGetDialogTypeMethodInfo     ,
    scriptDialogGetDialogType               ,


-- ** scriptDialogGetMessage
    ScriptDialogGetMessageMethodInfo        ,
    scriptDialogGetMessage                  ,


-- ** scriptDialogPromptGetDefaultText
    ScriptDialogPromptGetDefaultTextMethodInfo,
    scriptDialogPromptGetDefaultText        ,


-- ** scriptDialogPromptSetText
    ScriptDialogPromptSetTextMethodInfo     ,
    scriptDialogPromptSetText               ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks

newtype ScriptDialog = ScriptDialog (ForeignPtr ScriptDialog)
foreign import ccall "webkit_script_dialog_get_type" c_webkit_script_dialog_get_type :: 
    IO GType

instance BoxedObject ScriptDialog where
    boxedType _ = c_webkit_script_dialog_get_type

noScriptDialog :: Maybe ScriptDialog
noScriptDialog = Nothing


type instance AttributeList ScriptDialog = ScriptDialogAttributeList
type ScriptDialogAttributeList = ('[ ] :: [(Symbol, *)])

-- method ScriptDialog::confirm_set_confirmed
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ScriptDialog", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "confirmed", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_script_dialog_confirm_set_confirmed" webkit_script_dialog_confirm_set_confirmed :: 
    Ptr ScriptDialog ->                     -- _obj : TInterface "WebKit2" "ScriptDialog"
    CInt ->                                 -- confirmed : TBasicType TBoolean
    IO ()


scriptDialogConfirmSetConfirmed ::
    (MonadIO m) =>
    ScriptDialog                            -- _obj
    -> Bool                                 -- confirmed
    -> m ()                                 -- result
scriptDialogConfirmSetConfirmed _obj confirmed = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    let confirmed' = (fromIntegral . fromEnum) confirmed
    webkit_script_dialog_confirm_set_confirmed _obj' confirmed'
    touchManagedPtr _obj
    return ()

data ScriptDialogConfirmSetConfirmedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => MethodInfo ScriptDialogConfirmSetConfirmedMethodInfo ScriptDialog signature where
    overloadedMethod _ = scriptDialogConfirmSetConfirmed

-- method ScriptDialog::get_dialog_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ScriptDialog", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ScriptDialogType")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_script_dialog_get_dialog_type" webkit_script_dialog_get_dialog_type :: 
    Ptr ScriptDialog ->                     -- _obj : TInterface "WebKit2" "ScriptDialog"
    IO CUInt


scriptDialogGetDialogType ::
    (MonadIO m) =>
    ScriptDialog                            -- _obj
    -> m ScriptDialogType                   -- result
scriptDialogGetDialogType _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_script_dialog_get_dialog_type _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data ScriptDialogGetDialogTypeMethodInfo
instance (signature ~ (m ScriptDialogType), MonadIO m) => MethodInfo ScriptDialogGetDialogTypeMethodInfo ScriptDialog signature where
    overloadedMethod _ = scriptDialogGetDialogType

-- method ScriptDialog::get_message
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ScriptDialog", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_script_dialog_get_message" webkit_script_dialog_get_message :: 
    Ptr ScriptDialog ->                     -- _obj : TInterface "WebKit2" "ScriptDialog"
    IO CString


scriptDialogGetMessage ::
    (MonadIO m) =>
    ScriptDialog                            -- _obj
    -> m T.Text                             -- result
scriptDialogGetMessage _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_script_dialog_get_message _obj'
    checkUnexpectedReturnNULL "webkit_script_dialog_get_message" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data ScriptDialogGetMessageMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => MethodInfo ScriptDialogGetMessageMethodInfo ScriptDialog signature where
    overloadedMethod _ = scriptDialogGetMessage

-- method ScriptDialog::prompt_get_default_text
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ScriptDialog", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_script_dialog_prompt_get_default_text" webkit_script_dialog_prompt_get_default_text :: 
    Ptr ScriptDialog ->                     -- _obj : TInterface "WebKit2" "ScriptDialog"
    IO CString


scriptDialogPromptGetDefaultText ::
    (MonadIO m) =>
    ScriptDialog                            -- _obj
    -> m T.Text                             -- result
scriptDialogPromptGetDefaultText _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_script_dialog_prompt_get_default_text _obj'
    checkUnexpectedReturnNULL "webkit_script_dialog_prompt_get_default_text" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data ScriptDialogPromptGetDefaultTextMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => MethodInfo ScriptDialogPromptGetDefaultTextMethodInfo ScriptDialog signature where
    overloadedMethod _ = scriptDialogPromptGetDefaultText

-- method ScriptDialog::prompt_set_text
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ScriptDialog", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "text", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_script_dialog_prompt_set_text" webkit_script_dialog_prompt_set_text :: 
    Ptr ScriptDialog ->                     -- _obj : TInterface "WebKit2" "ScriptDialog"
    CString ->                              -- text : TBasicType TUTF8
    IO ()


scriptDialogPromptSetText ::
    (MonadIO m) =>
    ScriptDialog                            -- _obj
    -> T.Text                               -- text
    -> m ()                                 -- result
scriptDialogPromptSetText _obj text = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    text' <- textToCString text
    webkit_script_dialog_prompt_set_text _obj' text'
    touchManagedPtr _obj
    freeMem text'
    return ()

data ScriptDialogPromptSetTextMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => MethodInfo ScriptDialogPromptSetTextMethodInfo ScriptDialog signature where
    overloadedMethod _ = scriptDialogPromptSetText

type family ResolveScriptDialogMethod (t :: Symbol) (o :: *) :: * where
    ResolveScriptDialogMethod "confirmSetConfirmed" o = ScriptDialogConfirmSetConfirmedMethodInfo
    ResolveScriptDialogMethod "promptGetDefaultText" o = ScriptDialogPromptGetDefaultTextMethodInfo
    ResolveScriptDialogMethod "promptSetText" o = ScriptDialogPromptSetTextMethodInfo
    ResolveScriptDialogMethod "getDialogType" o = ScriptDialogGetDialogTypeMethodInfo
    ResolveScriptDialogMethod "getMessage" o = ScriptDialogGetMessageMethodInfo
    ResolveScriptDialogMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveScriptDialogMethod t ScriptDialog, MethodInfo info ScriptDialog p) => IsLabelProxy t (ScriptDialog -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveScriptDialogMethod t ScriptDialog, MethodInfo info ScriptDialog p) => IsLabel t (ScriptDialog -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


