

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Structs.UserScript
    ( 

-- * Exported types
    UserScript(..)                          ,
    noUserScript                            ,


 -- * Methods
-- ** userScriptNew
    userScriptNew                           ,


-- ** userScriptRef
    UserScriptRefMethodInfo                 ,
    userScriptRef                           ,


-- ** userScriptUnref
    UserScriptUnrefMethodInfo               ,
    userScriptUnref                         ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks

newtype UserScript = UserScript (ForeignPtr UserScript)
foreign import ccall "webkit_user_script_get_type" c_webkit_user_script_get_type :: 
    IO GType

instance BoxedObject UserScript where
    boxedType _ = c_webkit_user_script_get_type

noUserScript :: Maybe UserScript
noUserScript = Nothing


type instance AttributeList UserScript = UserScriptAttributeList
type UserScriptAttributeList = ('[ ] :: [(Symbol, *)])

-- method UserScript::new
-- method type : Constructor
-- Args : [Arg {argCName = "source", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "injected_frames", argType = TInterface "WebKit2" "UserContentInjectedFrames", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "injection_time", argType = TInterface "WebKit2" "UserScriptInjectionTime", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "whitelist", argType = TCArray True (-1) (-1) (TBasicType TUTF8), direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "blacklist", argType = TCArray True (-1) (-1) (TBasicType TUTF8), direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "UserScript")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_script_new" webkit_user_script_new :: 
    CString ->                              -- source : TBasicType TUTF8
    CUInt ->                                -- injected_frames : TInterface "WebKit2" "UserContentInjectedFrames"
    CUInt ->                                -- injection_time : TInterface "WebKit2" "UserScriptInjectionTime"
    Ptr CString ->                          -- whitelist : TCArray True (-1) (-1) (TBasicType TUTF8)
    Ptr CString ->                          -- blacklist : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr UserScript)


userScriptNew ::
    (MonadIO m) =>
    T.Text                                  -- source
    -> UserContentInjectedFrames            -- injectedFrames
    -> UserScriptInjectionTime              -- injectionTime
    -> Maybe ([T.Text])                     -- whitelist
    -> Maybe ([T.Text])                     -- blacklist
    -> m UserScript                         -- result
userScriptNew source injectedFrames injectionTime whitelist blacklist = liftIO $ do
    source' <- textToCString source
    let injectedFrames' = (fromIntegral . fromEnum) injectedFrames
    let injectionTime' = (fromIntegral . fromEnum) injectionTime
    maybeWhitelist <- case whitelist of
        Nothing -> return nullPtr
        Just jWhitelist -> do
            jWhitelist' <- packZeroTerminatedUTF8CArray jWhitelist
            return jWhitelist'
    maybeBlacklist <- case blacklist of
        Nothing -> return nullPtr
        Just jBlacklist -> do
            jBlacklist' <- packZeroTerminatedUTF8CArray jBlacklist
            return jBlacklist'
    result <- webkit_user_script_new source' injectedFrames' injectionTime' maybeWhitelist maybeBlacklist
    checkUnexpectedReturnNULL "webkit_user_script_new" result
    result' <- (wrapBoxed UserScript) result
    freeMem source'
    mapZeroTerminatedCArray freeMem maybeWhitelist
    freeMem maybeWhitelist
    mapZeroTerminatedCArray freeMem maybeBlacklist
    freeMem maybeBlacklist
    return result'

-- method UserScript::ref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserScript", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "UserScript")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_script_ref" webkit_user_script_ref :: 
    Ptr UserScript ->                       -- _obj : TInterface "WebKit2" "UserScript"
    IO (Ptr UserScript)


userScriptRef ::
    (MonadIO m) =>
    UserScript                              -- _obj
    -> m UserScript                         -- result
userScriptRef _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_user_script_ref _obj'
    checkUnexpectedReturnNULL "webkit_user_script_ref" result
    result' <- (wrapBoxed UserScript) result
    touchManagedPtr _obj
    return result'

data UserScriptRefMethodInfo
instance (signature ~ (m UserScript), MonadIO m) => MethodInfo UserScriptRefMethodInfo UserScript signature where
    overloadedMethod _ = userScriptRef

-- method UserScript::unref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserScript", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_script_unref" webkit_user_script_unref :: 
    Ptr UserScript ->                       -- _obj : TInterface "WebKit2" "UserScript"
    IO ()


userScriptUnref ::
    (MonadIO m) =>
    UserScript                              -- _obj
    -> m ()                                 -- result
userScriptUnref _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    webkit_user_script_unref _obj'
    touchManagedPtr _obj
    return ()

data UserScriptUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => MethodInfo UserScriptUnrefMethodInfo UserScript signature where
    overloadedMethod _ = userScriptUnref

type family ResolveUserScriptMethod (t :: Symbol) (o :: *) :: * where
    ResolveUserScriptMethod "ref" o = UserScriptRefMethodInfo
    ResolveUserScriptMethod "unref" o = UserScriptUnrefMethodInfo
    ResolveUserScriptMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveUserScriptMethod t UserScript, MethodInfo info UserScript p) => IsLabelProxy t (UserScript -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveUserScriptMethod t UserScript, MethodInfo info UserScript p) => IsLabel t (UserScript -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


