

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Structs.UserStyleSheet
    ( 

-- * Exported types
    UserStyleSheet(..)                      ,
    noUserStyleSheet                        ,


 -- * Methods
-- ** userStyleSheetNew
    userStyleSheetNew                       ,


-- ** userStyleSheetRef
    UserStyleSheetRefMethodInfo             ,
    userStyleSheetRef                       ,


-- ** userStyleSheetUnref
    UserStyleSheetUnrefMethodInfo           ,
    userStyleSheetUnref                     ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks

newtype UserStyleSheet = UserStyleSheet (ForeignPtr UserStyleSheet)
foreign import ccall "webkit_user_style_sheet_get_type" c_webkit_user_style_sheet_get_type :: 
    IO GType

instance BoxedObject UserStyleSheet where
    boxedType _ = c_webkit_user_style_sheet_get_type

noUserStyleSheet :: Maybe UserStyleSheet
noUserStyleSheet = Nothing


type instance AttributeList UserStyleSheet = UserStyleSheetAttributeList
type UserStyleSheetAttributeList = ('[ ] :: [(Symbol, *)])

-- method UserStyleSheet::new
-- method type : Constructor
-- Args : [Arg {argCName = "source", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "injected_frames", argType = TInterface "WebKit2" "UserContentInjectedFrames", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "level", argType = TInterface "WebKit2" "UserStyleLevel", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "whitelist", argType = TCArray True (-1) (-1) (TBasicType TUTF8), direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "blacklist", argType = TCArray True (-1) (-1) (TBasicType TUTF8), direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "UserStyleSheet")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_style_sheet_new" webkit_user_style_sheet_new :: 
    CString ->                              -- source : TBasicType TUTF8
    CUInt ->                                -- injected_frames : TInterface "WebKit2" "UserContentInjectedFrames"
    CUInt ->                                -- level : TInterface "WebKit2" "UserStyleLevel"
    Ptr CString ->                          -- whitelist : TCArray True (-1) (-1) (TBasicType TUTF8)
    Ptr CString ->                          -- blacklist : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr UserStyleSheet)


userStyleSheetNew ::
    (MonadIO m) =>
    T.Text                                  -- source
    -> UserContentInjectedFrames            -- injectedFrames
    -> UserStyleLevel                       -- level
    -> Maybe ([T.Text])                     -- whitelist
    -> Maybe ([T.Text])                     -- blacklist
    -> m UserStyleSheet                     -- result
userStyleSheetNew source injectedFrames level whitelist blacklist = liftIO $ do
    source' <- textToCString source
    let injectedFrames' = (fromIntegral . fromEnum) injectedFrames
    let level' = (fromIntegral . fromEnum) level
    maybeWhitelist <- case whitelist of
        Nothing -> return nullPtr
        Just jWhitelist -> do
            jWhitelist' <- packZeroTerminatedUTF8CArray jWhitelist
            return jWhitelist'
    maybeBlacklist <- case blacklist of
        Nothing -> return nullPtr
        Just jBlacklist -> do
            jBlacklist' <- packZeroTerminatedUTF8CArray jBlacklist
            return jBlacklist'
    result <- webkit_user_style_sheet_new source' injectedFrames' level' maybeWhitelist maybeBlacklist
    checkUnexpectedReturnNULL "webkit_user_style_sheet_new" result
    result' <- (wrapBoxed UserStyleSheet) result
    freeMem source'
    mapZeroTerminatedCArray freeMem maybeWhitelist
    freeMem maybeWhitelist
    mapZeroTerminatedCArray freeMem maybeBlacklist
    freeMem maybeBlacklist
    return result'

-- method UserStyleSheet::ref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserStyleSheet", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "UserStyleSheet")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_style_sheet_ref" webkit_user_style_sheet_ref :: 
    Ptr UserStyleSheet ->                   -- _obj : TInterface "WebKit2" "UserStyleSheet"
    IO (Ptr UserStyleSheet)


userStyleSheetRef ::
    (MonadIO m) =>
    UserStyleSheet                          -- _obj
    -> m UserStyleSheet                     -- result
userStyleSheetRef _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_user_style_sheet_ref _obj'
    checkUnexpectedReturnNULL "webkit_user_style_sheet_ref" result
    result' <- (wrapBoxed UserStyleSheet) result
    touchManagedPtr _obj
    return result'

data UserStyleSheetRefMethodInfo
instance (signature ~ (m UserStyleSheet), MonadIO m) => MethodInfo UserStyleSheetRefMethodInfo UserStyleSheet signature where
    overloadedMethod _ = userStyleSheetRef

-- method UserStyleSheet::unref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "UserStyleSheet", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_style_sheet_unref" webkit_user_style_sheet_unref :: 
    Ptr UserStyleSheet ->                   -- _obj : TInterface "WebKit2" "UserStyleSheet"
    IO ()


userStyleSheetUnref ::
    (MonadIO m) =>
    UserStyleSheet                          -- _obj
    -> m ()                                 -- result
userStyleSheetUnref _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    webkit_user_style_sheet_unref _obj'
    touchManagedPtr _obj
    return ()

data UserStyleSheetUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => MethodInfo UserStyleSheetUnrefMethodInfo UserStyleSheet signature where
    overloadedMethod _ = userStyleSheetUnref

type family ResolveUserStyleSheetMethod (t :: Symbol) (o :: *) :: * where
    ResolveUserStyleSheetMethod "ref" o = UserStyleSheetRefMethodInfo
    ResolveUserStyleSheetMethod "unref" o = UserStyleSheetUnrefMethodInfo
    ResolveUserStyleSheetMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveUserStyleSheetMethod t UserStyleSheet, MethodInfo info UserStyleSheet p) => IsLabelProxy t (UserStyleSheet -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveUserStyleSheetMethod t UserStyleSheet, MethodInfo info UserStyleSheet p) => IsLabel t (UserStyleSheet -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


