

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Structs.WebViewSessionState
    ( 

-- * Exported types
    WebViewSessionState(..)                 ,
    noWebViewSessionState                   ,


 -- * Methods
-- ** webViewSessionStateNew
    webViewSessionStateNew                  ,


-- ** webViewSessionStateRef
    WebViewSessionStateRefMethodInfo        ,
    webViewSessionStateRef                  ,


-- ** webViewSessionStateSerialize
    WebViewSessionStateSerializeMethodInfo  ,
    webViewSessionStateSerialize            ,


-- ** webViewSessionStateUnref
    WebViewSessionStateUnrefMethodInfo      ,
    webViewSessionStateUnref                ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GLib as GLib

newtype WebViewSessionState = WebViewSessionState (ForeignPtr WebViewSessionState)
foreign import ccall "webkit_web_view_session_state_get_type" c_webkit_web_view_session_state_get_type :: 
    IO GType

instance BoxedObject WebViewSessionState where
    boxedType _ = c_webkit_web_view_session_state_get_type

noWebViewSessionState :: Maybe WebViewSessionState
noWebViewSessionState = Nothing


type instance AttributeList WebViewSessionState = WebViewSessionStateAttributeList
type WebViewSessionStateAttributeList = ('[ ] :: [(Symbol, *)])

-- method WebViewSessionState::new
-- method type : Constructor
-- Args : [Arg {argCName = "data", argType = TInterface "GLib" "Bytes", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebViewSessionState")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_session_state_new" webkit_web_view_session_state_new :: 
    Ptr GLib.Bytes ->                       -- data : TInterface "GLib" "Bytes"
    IO (Ptr WebViewSessionState)


webViewSessionStateNew ::
    (MonadIO m) =>
    GLib.Bytes                              -- data_
    -> m WebViewSessionState                -- result
webViewSessionStateNew data_ = liftIO $ do
    let data_' = unsafeManagedPtrGetPtr data_
    result <- webkit_web_view_session_state_new data_'
    checkUnexpectedReturnNULL "webkit_web_view_session_state_new" result
    result' <- (wrapBoxed WebViewSessionState) result
    touchManagedPtr data_
    return result'

-- method WebViewSessionState::ref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebViewSessionState", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebViewSessionState")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_session_state_ref" webkit_web_view_session_state_ref :: 
    Ptr WebViewSessionState ->              -- _obj : TInterface "WebKit2" "WebViewSessionState"
    IO (Ptr WebViewSessionState)


webViewSessionStateRef ::
    (MonadIO m) =>
    WebViewSessionState                     -- _obj
    -> m WebViewSessionState                -- result
webViewSessionStateRef _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_web_view_session_state_ref _obj'
    checkUnexpectedReturnNULL "webkit_web_view_session_state_ref" result
    result' <- (wrapBoxed WebViewSessionState) result
    touchManagedPtr _obj
    return result'

data WebViewSessionStateRefMethodInfo
instance (signature ~ (m WebViewSessionState), MonadIO m) => MethodInfo WebViewSessionStateRefMethodInfo WebViewSessionState signature where
    overloadedMethod _ = webViewSessionStateRef

-- method WebViewSessionState::serialize
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebViewSessionState", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "GLib" "Bytes")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_session_state_serialize" webkit_web_view_session_state_serialize :: 
    Ptr WebViewSessionState ->              -- _obj : TInterface "WebKit2" "WebViewSessionState"
    IO (Ptr GLib.Bytes)


webViewSessionStateSerialize ::
    (MonadIO m) =>
    WebViewSessionState                     -- _obj
    -> m GLib.Bytes                         -- result
webViewSessionStateSerialize _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_web_view_session_state_serialize _obj'
    checkUnexpectedReturnNULL "webkit_web_view_session_state_serialize" result
    result' <- (wrapBoxed GLib.Bytes) result
    touchManagedPtr _obj
    return result'

data WebViewSessionStateSerializeMethodInfo
instance (signature ~ (m GLib.Bytes), MonadIO m) => MethodInfo WebViewSessionStateSerializeMethodInfo WebViewSessionState signature where
    overloadedMethod _ = webViewSessionStateSerialize

-- method WebViewSessionState::unref
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "WebViewSessionState", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_view_session_state_unref" webkit_web_view_session_state_unref :: 
    Ptr WebViewSessionState ->              -- _obj : TInterface "WebKit2" "WebViewSessionState"
    IO ()


webViewSessionStateUnref ::
    (MonadIO m) =>
    WebViewSessionState                     -- _obj
    -> m ()                                 -- result
webViewSessionStateUnref _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    webkit_web_view_session_state_unref _obj'
    touchManagedPtr _obj
    return ()

data WebViewSessionStateUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => MethodInfo WebViewSessionStateUnrefMethodInfo WebViewSessionState signature where
    overloadedMethod _ = webViewSessionStateUnref

type family ResolveWebViewSessionStateMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebViewSessionStateMethod "ref" o = WebViewSessionStateRefMethodInfo
    ResolveWebViewSessionStateMethod "serialize" o = WebViewSessionStateSerializeMethodInfo
    ResolveWebViewSessionStateMethod "unref" o = WebViewSessionStateUnrefMethodInfo
    ResolveWebViewSessionStateMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebViewSessionStateMethod t WebViewSessionState, MethodInfo info WebViewSessionState p) => IsLabelProxy t (WebViewSessionState -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebViewSessionStateMethod t WebViewSessionState, MethodInfo info WebViewSessionState p) => IsLabel t (WebViewSessionState -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


