

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Callbacks
    ( 

 -- * Signals
-- ** WebExtensionInitializeFunction
    WebExtensionInitializeFunction          ,
    WebExtensionInitializeFunctionC         ,
    mkWebExtensionInitializeFunction        ,
    noWebExtensionInitializeFunction        ,
    webExtensionInitializeFunctionClosure   ,
    webExtensionInitializeFunctionWrapper   ,


-- ** WebExtensionInitializeWithUserDataFunction
    WebExtensionInitializeWithUserDataFunction,
    WebExtensionInitializeWithUserDataFunctionC,
    mkWebExtensionInitializeWithUserDataFunction,
    noWebExtensionInitializeWithUserDataFunction,
    webExtensionInitializeWithUserDataFunctionClosure,
    webExtensionInitializeWithUserDataFunctionWrapper,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types


-- callback WebExtensionInitializeWithUserDataFunction
webExtensionInitializeWithUserDataFunctionClosure :: WebExtensionInitializeWithUserDataFunction -> IO Closure
webExtensionInitializeWithUserDataFunctionClosure cb = newCClosure =<< mkWebExtensionInitializeWithUserDataFunction wrapped
    where wrapped = webExtensionInitializeWithUserDataFunctionWrapper Nothing cb

type WebExtensionInitializeWithUserDataFunctionC =
    Ptr WebExtension ->
    Ptr GVariant ->
    IO ()

foreign import ccall "wrapper"
    mkWebExtensionInitializeWithUserDataFunction :: WebExtensionInitializeWithUserDataFunctionC -> IO (FunPtr WebExtensionInitializeWithUserDataFunctionC)

type WebExtensionInitializeWithUserDataFunction =
    WebExtension ->
    GVariant ->
    IO ()

noWebExtensionInitializeWithUserDataFunction :: Maybe WebExtensionInitializeWithUserDataFunction
noWebExtensionInitializeWithUserDataFunction = Nothing

webExtensionInitializeWithUserDataFunctionWrapper ::
    Maybe (Ptr (FunPtr (WebExtensionInitializeWithUserDataFunctionC))) ->
    WebExtensionInitializeWithUserDataFunction ->
    Ptr WebExtension ->
    Ptr GVariant ->
    IO ()
webExtensionInitializeWithUserDataFunctionWrapper funptrptr _cb extension userData = do
    extension' <- (newObject WebExtension) extension
    userData' <- newGVariantFromPtr userData
    _cb  extension' userData'
    maybeReleaseFunPtr funptrptr

-- callback WebExtensionInitializeFunction
webExtensionInitializeFunctionClosure :: WebExtensionInitializeFunction -> IO Closure
webExtensionInitializeFunctionClosure cb = newCClosure =<< mkWebExtensionInitializeFunction wrapped
    where wrapped = webExtensionInitializeFunctionWrapper Nothing cb

type WebExtensionInitializeFunctionC =
    Ptr WebExtension ->
    IO ()

foreign import ccall "wrapper"
    mkWebExtensionInitializeFunction :: WebExtensionInitializeFunctionC -> IO (FunPtr WebExtensionInitializeFunctionC)

type WebExtensionInitializeFunction =
    WebExtension ->
    IO ()

noWebExtensionInitializeFunction :: Maybe WebExtensionInitializeFunction
noWebExtensionInitializeFunction = Nothing

webExtensionInitializeFunctionWrapper ::
    Maybe (Ptr (FunPtr (WebExtensionInitializeFunctionC))) ->
    WebExtensionInitializeFunction ->
    Ptr WebExtension ->
    IO ()
webExtensionInitializeFunctionWrapper funptrptr _cb extension = do
    extension' <- (newObject WebExtension) extension
    _cb  extension'
    maybeReleaseFunPtr funptrptr


