{-# LANGUAGE PatternSynonyms, ScopedTypeVariables, ViewPatterns #-}


{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Constants
    ( 
    pattern DOM_XPATH_RESULT_UNORDERED_NODE_SNAPSHOT_TYPE,
    pattern DOM_XPATH_RESULT_UNORDERED_NODE_ITERATOR_TYPE,
    pattern DOM_XPATH_RESULT_STRING_TYPE    ,
    pattern DOM_XPATH_RESULT_ORDERED_NODE_SNAPSHOT_TYPE,
    pattern DOM_XPATH_RESULT_ORDERED_NODE_ITERATOR_TYPE,
    pattern DOM_XPATH_RESULT_NUMBER_TYPE    ,
    pattern DOM_XPATH_RESULT_FIRST_ORDERED_NODE_TYPE,
    pattern DOM_XPATH_RESULT_BOOLEAN_TYPE   ,
    pattern DOM_XPATH_RESULT_ANY_UNORDERED_NODE_TYPE,
    pattern DOM_XPATH_RESULT_ANY_TYPE       ,
    pattern DOM_RANGE_START_TO_START        ,
    pattern DOM_RANGE_START_TO_END          ,
    pattern DOM_RANGE_NODE_INSIDE           ,
    pattern DOM_RANGE_NODE_BEFORE_AND_AFTER ,
    pattern DOM_RANGE_NODE_BEFORE           ,
    pattern DOM_RANGE_NODE_AFTER            ,
    pattern DOM_RANGE_END_TO_START          ,
    pattern DOM_RANGE_END_TO_END            ,
    pattern DOM_NODE_TEXT_NODE              ,
    pattern DOM_NODE_PROCESSING_INSTRUCTION_NODE,
    pattern DOM_NODE_FILTER_SKIP            ,
    pattern DOM_NODE_FILTER_SHOW_TEXT       ,
    pattern DOM_NODE_FILTER_SHOW_PROCESSING_INSTRUCTION,
    pattern DOM_NODE_FILTER_SHOW_NOTATION   ,
    pattern DOM_NODE_FILTER_SHOW_ENTITY_REFERENCE,
    pattern DOM_NODE_FILTER_SHOW_ENTITY     ,
    pattern DOM_NODE_FILTER_SHOW_ELEMENT    ,
    pattern DOM_NODE_FILTER_SHOW_DOCUMENT_TYPE,
    pattern DOM_NODE_FILTER_SHOW_DOCUMENT_FRAGMENT,
    pattern DOM_NODE_FILTER_SHOW_DOCUMENT   ,
    pattern DOM_NODE_FILTER_SHOW_COMMENT    ,
    pattern DOM_NODE_FILTER_SHOW_CDATA_SECTION,
    pattern DOM_NODE_FILTER_SHOW_ATTRIBUTE  ,
    pattern DOM_NODE_FILTER_SHOW_ALL        ,
    pattern DOM_NODE_FILTER_REJECT          ,
    pattern DOM_NODE_FILTER_ACCEPT          ,
    pattern DOM_NODE_ENTITY_REFERENCE_NODE  ,
    pattern DOM_NODE_ENTITY_NODE            ,
    pattern DOM_NODE_ELEMENT_NODE           ,
    pattern DOM_NODE_DOCUMENT_TYPE_NODE     ,
    pattern DOM_NODE_DOCUMENT_POSITION_PRECEDING,
    pattern DOM_NODE_DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC,
    pattern DOM_NODE_DOCUMENT_POSITION_FOLLOWING,
    pattern DOM_NODE_DOCUMENT_POSITION_DISCONNECTED,
    pattern DOM_NODE_DOCUMENT_POSITION_CONTAINS,
    pattern DOM_NODE_DOCUMENT_POSITION_CONTAINED_BY,
    pattern DOM_NODE_DOCUMENT_NODE          ,
    pattern DOM_NODE_DOCUMENT_FRAGMENT_NODE ,
    pattern DOM_NODE_COMMENT_NODE           ,
    pattern DOM_NODE_CDATA_SECTION_NODE     ,
    pattern DOM_NODE_ATTRIBUTE_NODE         ,
    pattern DOM_KEYBOARD_EVENT_KEY_LOCATION_STANDARD,
    pattern DOM_KEYBOARD_EVENT_KEY_LOCATION_RIGHT,
    pattern DOM_KEYBOARD_EVENT_KEY_LOCATION_NUMPAD,
    pattern DOM_KEYBOARD_EVENT_KEY_LOCATION_LEFT,
    pattern DOM_EVENT_SELECT                ,
    pattern DOM_EVENT_NONE                  ,
    pattern DOM_EVENT_MOUSEUP               ,
    pattern DOM_EVENT_MOUSEOVER             ,
    pattern DOM_EVENT_MOUSEOUT              ,
    pattern DOM_EVENT_MOUSEMOVE             ,
    pattern DOM_EVENT_MOUSEDRAG             ,
    pattern DOM_EVENT_MOUSEDOWN             ,
    pattern DOM_EVENT_KEYUP                 ,
    pattern DOM_EVENT_KEYPRESS              ,
    pattern DOM_EVENT_KEYDOWN               ,
    pattern DOM_EVENT_FOCUS                 ,
    pattern DOM_EVENT_DRAGDROP              ,
    pattern DOM_EVENT_DBLCLICK              ,
    pattern DOM_EVENT_CLICK                 ,
    pattern DOM_EVENT_CHANGE                ,
    pattern DOM_EVENT_CAPTURING_PHASE       ,
    pattern DOM_EVENT_BUBBLING_PHASE        ,
    pattern DOM_EVENT_BLUR                  ,
    pattern DOM_EVENT_AT_TARGET             ,
    pattern DOM_CSS_VALUE_CSS_VALUE_LIST    ,
    pattern DOM_CSS_VALUE_CSS_PRIMITIVE_VALUE,
    pattern DOM_CSS_VALUE_CSS_INHERIT       ,
    pattern DOM_CSS_VALUE_CSS_CUSTOM        ,
    pattern DOM_CSS_RULE_UNKNOWN_RULE       ,
    pattern DOM_CSS_RULE_STYLE_RULE         ,
    pattern DOM_CSS_RULE_PAGE_RULE          ,
    pattern DOM_CSS_RULE_MEDIA_RULE         ,
    pattern DOM_CSS_RULE_IMPORT_RULE        ,
    pattern DOM_CSS_RULE_FONT_FACE_RULE     ,
    pattern DOM_CSS_RULE_CHARSET_RULE       ,

    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks


pattern DOM_XPATH_RESULT_UNORDERED_NODE_SNAPSHOT_TYPE = 6 :: Int32


pattern DOM_XPATH_RESULT_UNORDERED_NODE_ITERATOR_TYPE = 4 :: Int32


pattern DOM_XPATH_RESULT_STRING_TYPE = 2 :: Int32


pattern DOM_XPATH_RESULT_ORDERED_NODE_SNAPSHOT_TYPE = 7 :: Int32


pattern DOM_XPATH_RESULT_ORDERED_NODE_ITERATOR_TYPE = 5 :: Int32


pattern DOM_XPATH_RESULT_NUMBER_TYPE = 1 :: Int32


pattern DOM_XPATH_RESULT_FIRST_ORDERED_NODE_TYPE = 9 :: Int32


pattern DOM_XPATH_RESULT_BOOLEAN_TYPE = 3 :: Int32


pattern DOM_XPATH_RESULT_ANY_UNORDERED_NODE_TYPE = 8 :: Int32


pattern DOM_XPATH_RESULT_ANY_TYPE = 0 :: Int32


pattern DOM_RANGE_START_TO_START = 0 :: Int32


pattern DOM_RANGE_START_TO_END = 1 :: Int32


pattern DOM_RANGE_NODE_INSIDE = 3 :: Int32


pattern DOM_RANGE_NODE_BEFORE_AND_AFTER = 2 :: Int32


pattern DOM_RANGE_NODE_BEFORE = 0 :: Int32


pattern DOM_RANGE_NODE_AFTER = 1 :: Int32


pattern DOM_RANGE_END_TO_START = 3 :: Int32


pattern DOM_RANGE_END_TO_END = 2 :: Int32


pattern DOM_NODE_TEXT_NODE = 3 :: Int32


pattern DOM_NODE_PROCESSING_INSTRUCTION_NODE = 7 :: Int32


pattern DOM_NODE_FILTER_SKIP = 3 :: Int32


pattern DOM_NODE_FILTER_SHOW_TEXT = 4 :: Int32


pattern DOM_NODE_FILTER_SHOW_PROCESSING_INSTRUCTION = 64 :: Int32


pattern DOM_NODE_FILTER_SHOW_NOTATION = 2048 :: Int32


pattern DOM_NODE_FILTER_SHOW_ENTITY_REFERENCE = 16 :: Int32


pattern DOM_NODE_FILTER_SHOW_ENTITY = 32 :: Int32


pattern DOM_NODE_FILTER_SHOW_ELEMENT = 1 :: Int32


pattern DOM_NODE_FILTER_SHOW_DOCUMENT_TYPE = 512 :: Int32


pattern DOM_NODE_FILTER_SHOW_DOCUMENT_FRAGMENT = 1024 :: Int32


pattern DOM_NODE_FILTER_SHOW_DOCUMENT = 256 :: Int32


pattern DOM_NODE_FILTER_SHOW_COMMENT = 128 :: Int32


pattern DOM_NODE_FILTER_SHOW_CDATA_SECTION = 8 :: Int32


pattern DOM_NODE_FILTER_SHOW_ATTRIBUTE = 2 :: Int32


pattern DOM_NODE_FILTER_SHOW_ALL = 4294967295 :: Int32


pattern DOM_NODE_FILTER_REJECT = 2 :: Int32


pattern DOM_NODE_FILTER_ACCEPT = 1 :: Int32


pattern DOM_NODE_ENTITY_REFERENCE_NODE = 5 :: Int32


pattern DOM_NODE_ENTITY_NODE = 6 :: Int32


pattern DOM_NODE_ELEMENT_NODE = 1 :: Int32


pattern DOM_NODE_DOCUMENT_TYPE_NODE = 10 :: Int32


pattern DOM_NODE_DOCUMENT_POSITION_PRECEDING = 2 :: Int32


pattern DOM_NODE_DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32 :: Int32


pattern DOM_NODE_DOCUMENT_POSITION_FOLLOWING = 4 :: Int32


pattern DOM_NODE_DOCUMENT_POSITION_DISCONNECTED = 1 :: Int32


pattern DOM_NODE_DOCUMENT_POSITION_CONTAINS = 8 :: Int32


pattern DOM_NODE_DOCUMENT_POSITION_CONTAINED_BY = 16 :: Int32


pattern DOM_NODE_DOCUMENT_NODE = 9 :: Int32


pattern DOM_NODE_DOCUMENT_FRAGMENT_NODE = 11 :: Int32


pattern DOM_NODE_COMMENT_NODE = 8 :: Int32


pattern DOM_NODE_CDATA_SECTION_NODE = 4 :: Int32


pattern DOM_NODE_ATTRIBUTE_NODE = 2 :: Int32


pattern DOM_KEYBOARD_EVENT_KEY_LOCATION_STANDARD = 0 :: Int32


pattern DOM_KEYBOARD_EVENT_KEY_LOCATION_RIGHT = 2 :: Int32


pattern DOM_KEYBOARD_EVENT_KEY_LOCATION_NUMPAD = 3 :: Int32


pattern DOM_KEYBOARD_EVENT_KEY_LOCATION_LEFT = 1 :: Int32


pattern DOM_EVENT_SELECT = 16384 :: Int32


pattern DOM_EVENT_NONE = 0 :: Int32


pattern DOM_EVENT_MOUSEUP = 2 :: Int32


pattern DOM_EVENT_MOUSEOVER = 4 :: Int32


pattern DOM_EVENT_MOUSEOUT = 8 :: Int32


pattern DOM_EVENT_MOUSEMOVE = 16 :: Int32


pattern DOM_EVENT_MOUSEDRAG = 32 :: Int32


pattern DOM_EVENT_MOUSEDOWN = 1 :: Int32


pattern DOM_EVENT_KEYUP = 512 :: Int32


pattern DOM_EVENT_KEYPRESS = 1024 :: Int32


pattern DOM_EVENT_KEYDOWN = 256 :: Int32


pattern DOM_EVENT_FOCUS = 4096 :: Int32


pattern DOM_EVENT_DRAGDROP = 2048 :: Int32


pattern DOM_EVENT_DBLCLICK = 128 :: Int32


pattern DOM_EVENT_CLICK = 64 :: Int32


pattern DOM_EVENT_CHANGE = 32768 :: Int32


pattern DOM_EVENT_CAPTURING_PHASE = 1 :: Int32


pattern DOM_EVENT_BUBBLING_PHASE = 3 :: Int32


pattern DOM_EVENT_BLUR = 8192 :: Int32


pattern DOM_EVENT_AT_TARGET = 2 :: Int32


pattern DOM_CSS_VALUE_CSS_VALUE_LIST = 2 :: Int32


pattern DOM_CSS_VALUE_CSS_PRIMITIVE_VALUE = 1 :: Int32


pattern DOM_CSS_VALUE_CSS_INHERIT = 0 :: Int32


pattern DOM_CSS_VALUE_CSS_CUSTOM = 3 :: Int32


pattern DOM_CSS_RULE_UNKNOWN_RULE = 0 :: Int32


pattern DOM_CSS_RULE_STYLE_RULE = 1 :: Int32


pattern DOM_CSS_RULE_PAGE_RULE = 6 :: Int32


pattern DOM_CSS_RULE_MEDIA_RULE = 4 :: Int32


pattern DOM_CSS_RULE_IMPORT_RULE = 3 :: Int32


pattern DOM_CSS_RULE_FONT_FACE_RULE = 5 :: Int32


pattern DOM_CSS_RULE_CHARSET_RULE = 2 :: Int32


