

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Enums
    ( 

-- * Exported types
    ContextMenuAction(..)                   ,
    ConsoleMessageSource(..)                ,
    ConsoleMessageLevel(..)                 ,


    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map




-- Enum ContextMenuAction

data ContextMenuAction = 
      ContextMenuActionNoAction
    | ContextMenuActionOpenLink
    | ContextMenuActionOpenLinkInNewWindow
    | ContextMenuActionDownloadLinkToDisk
    | ContextMenuActionCopyLinkToClipboard
    | ContextMenuActionOpenImageInNewWindow
    | ContextMenuActionDownloadImageToDisk
    | ContextMenuActionCopyImageToClipboard
    | ContextMenuActionCopyImageUrlToClipboard
    | ContextMenuActionOpenFrameInNewWindow
    | ContextMenuActionGoBack
    | ContextMenuActionGoForward
    | ContextMenuActionStop
    | ContextMenuActionReload
    | ContextMenuActionCopy
    | ContextMenuActionCut
    | ContextMenuActionPaste
    | ContextMenuActionDelete
    | ContextMenuActionSelectAll
    | ContextMenuActionInputMethods
    | ContextMenuActionUnicode
    | ContextMenuActionSpellingGuess
    | ContextMenuActionNoGuessesFound
    | ContextMenuActionIgnoreSpelling
    | ContextMenuActionLearnSpelling
    | ContextMenuActionIgnoreGrammar
    | ContextMenuActionFontMenu
    | ContextMenuActionBold
    | ContextMenuActionItalic
    | ContextMenuActionUnderline
    | ContextMenuActionOutline
    | ContextMenuActionInspectElement
    | ContextMenuActionOpenVideoInNewWindow
    | ContextMenuActionOpenAudioInNewWindow
    | ContextMenuActionCopyVideoLinkToClipboard
    | ContextMenuActionCopyAudioLinkToClipboard
    | ContextMenuActionToggleMediaControls
    | ContextMenuActionToggleMediaLoop
    | ContextMenuActionEnterVideoFullscreen
    | ContextMenuActionMediaPlay
    | ContextMenuActionMediaPause
    | ContextMenuActionMediaMute
    | ContextMenuActionDownloadVideoToDisk
    | ContextMenuActionDownloadAudioToDisk
    | ContextMenuActionCustom
    | AnotherContextMenuAction Int
    deriving (Show, Eq)

instance Enum ContextMenuAction where
    fromEnum ContextMenuActionNoAction = 0
    fromEnum ContextMenuActionOpenLink = 1
    fromEnum ContextMenuActionOpenLinkInNewWindow = 2
    fromEnum ContextMenuActionDownloadLinkToDisk = 3
    fromEnum ContextMenuActionCopyLinkToClipboard = 4
    fromEnum ContextMenuActionOpenImageInNewWindow = 5
    fromEnum ContextMenuActionDownloadImageToDisk = 6
    fromEnum ContextMenuActionCopyImageToClipboard = 7
    fromEnum ContextMenuActionCopyImageUrlToClipboard = 8
    fromEnum ContextMenuActionOpenFrameInNewWindow = 9
    fromEnum ContextMenuActionGoBack = 10
    fromEnum ContextMenuActionGoForward = 11
    fromEnum ContextMenuActionStop = 12
    fromEnum ContextMenuActionReload = 13
    fromEnum ContextMenuActionCopy = 14
    fromEnum ContextMenuActionCut = 15
    fromEnum ContextMenuActionPaste = 16
    fromEnum ContextMenuActionDelete = 17
    fromEnum ContextMenuActionSelectAll = 18
    fromEnum ContextMenuActionInputMethods = 19
    fromEnum ContextMenuActionUnicode = 20
    fromEnum ContextMenuActionSpellingGuess = 21
    fromEnum ContextMenuActionNoGuessesFound = 22
    fromEnum ContextMenuActionIgnoreSpelling = 23
    fromEnum ContextMenuActionLearnSpelling = 24
    fromEnum ContextMenuActionIgnoreGrammar = 25
    fromEnum ContextMenuActionFontMenu = 26
    fromEnum ContextMenuActionBold = 27
    fromEnum ContextMenuActionItalic = 28
    fromEnum ContextMenuActionUnderline = 29
    fromEnum ContextMenuActionOutline = 30
    fromEnum ContextMenuActionInspectElement = 31
    fromEnum ContextMenuActionOpenVideoInNewWindow = 32
    fromEnum ContextMenuActionOpenAudioInNewWindow = 33
    fromEnum ContextMenuActionCopyVideoLinkToClipboard = 34
    fromEnum ContextMenuActionCopyAudioLinkToClipboard = 35
    fromEnum ContextMenuActionToggleMediaControls = 36
    fromEnum ContextMenuActionToggleMediaLoop = 37
    fromEnum ContextMenuActionEnterVideoFullscreen = 38
    fromEnum ContextMenuActionMediaPlay = 39
    fromEnum ContextMenuActionMediaPause = 40
    fromEnum ContextMenuActionMediaMute = 41
    fromEnum ContextMenuActionDownloadVideoToDisk = 42
    fromEnum ContextMenuActionDownloadAudioToDisk = 43
    fromEnum ContextMenuActionCustom = 10000
    fromEnum (AnotherContextMenuAction k) = k

    toEnum 0 = ContextMenuActionNoAction
    toEnum 1 = ContextMenuActionOpenLink
    toEnum 2 = ContextMenuActionOpenLinkInNewWindow
    toEnum 3 = ContextMenuActionDownloadLinkToDisk
    toEnum 4 = ContextMenuActionCopyLinkToClipboard
    toEnum 5 = ContextMenuActionOpenImageInNewWindow
    toEnum 6 = ContextMenuActionDownloadImageToDisk
    toEnum 7 = ContextMenuActionCopyImageToClipboard
    toEnum 8 = ContextMenuActionCopyImageUrlToClipboard
    toEnum 9 = ContextMenuActionOpenFrameInNewWindow
    toEnum 10 = ContextMenuActionGoBack
    toEnum 11 = ContextMenuActionGoForward
    toEnum 12 = ContextMenuActionStop
    toEnum 13 = ContextMenuActionReload
    toEnum 14 = ContextMenuActionCopy
    toEnum 15 = ContextMenuActionCut
    toEnum 16 = ContextMenuActionPaste
    toEnum 17 = ContextMenuActionDelete
    toEnum 18 = ContextMenuActionSelectAll
    toEnum 19 = ContextMenuActionInputMethods
    toEnum 20 = ContextMenuActionUnicode
    toEnum 21 = ContextMenuActionSpellingGuess
    toEnum 22 = ContextMenuActionNoGuessesFound
    toEnum 23 = ContextMenuActionIgnoreSpelling
    toEnum 24 = ContextMenuActionLearnSpelling
    toEnum 25 = ContextMenuActionIgnoreGrammar
    toEnum 26 = ContextMenuActionFontMenu
    toEnum 27 = ContextMenuActionBold
    toEnum 28 = ContextMenuActionItalic
    toEnum 29 = ContextMenuActionUnderline
    toEnum 30 = ContextMenuActionOutline
    toEnum 31 = ContextMenuActionInspectElement
    toEnum 32 = ContextMenuActionOpenVideoInNewWindow
    toEnum 33 = ContextMenuActionOpenAudioInNewWindow
    toEnum 34 = ContextMenuActionCopyVideoLinkToClipboard
    toEnum 35 = ContextMenuActionCopyAudioLinkToClipboard
    toEnum 36 = ContextMenuActionToggleMediaControls
    toEnum 37 = ContextMenuActionToggleMediaLoop
    toEnum 38 = ContextMenuActionEnterVideoFullscreen
    toEnum 39 = ContextMenuActionMediaPlay
    toEnum 40 = ContextMenuActionMediaPause
    toEnum 41 = ContextMenuActionMediaMute
    toEnum 42 = ContextMenuActionDownloadVideoToDisk
    toEnum 43 = ContextMenuActionDownloadAudioToDisk
    toEnum 10000 = ContextMenuActionCustom
    toEnum k = AnotherContextMenuAction k

-- Enum ConsoleMessageSource

data ConsoleMessageSource = 
      ConsoleMessageSourceJavascript
    | ConsoleMessageSourceNetwork
    | ConsoleMessageSourceConsoleApi
    | ConsoleMessageSourceSecurity
    | ConsoleMessageSourceOther
    | AnotherConsoleMessageSource Int
    deriving (Show, Eq)

instance Enum ConsoleMessageSource where
    fromEnum ConsoleMessageSourceJavascript = 0
    fromEnum ConsoleMessageSourceNetwork = 1
    fromEnum ConsoleMessageSourceConsoleApi = 2
    fromEnum ConsoleMessageSourceSecurity = 3
    fromEnum ConsoleMessageSourceOther = 4
    fromEnum (AnotherConsoleMessageSource k) = k

    toEnum 0 = ConsoleMessageSourceJavascript
    toEnum 1 = ConsoleMessageSourceNetwork
    toEnum 2 = ConsoleMessageSourceConsoleApi
    toEnum 3 = ConsoleMessageSourceSecurity
    toEnum 4 = ConsoleMessageSourceOther
    toEnum k = AnotherConsoleMessageSource k

-- Enum ConsoleMessageLevel

data ConsoleMessageLevel = 
      ConsoleMessageLevelInfo
    | ConsoleMessageLevelLog
    | ConsoleMessageLevelWarning
    | ConsoleMessageLevelError
    | ConsoleMessageLevelDebug
    | AnotherConsoleMessageLevel Int
    deriving (Show, Eq)

instance Enum ConsoleMessageLevel where
    fromEnum ConsoleMessageLevelInfo = 0
    fromEnum ConsoleMessageLevelLog = 1
    fromEnum ConsoleMessageLevelWarning = 2
    fromEnum ConsoleMessageLevelError = 3
    fromEnum ConsoleMessageLevelDebug = 4
    fromEnum (AnotherConsoleMessageLevel k) = k

    toEnum 0 = ConsoleMessageLevelInfo
    toEnum 1 = ConsoleMessageLevelLog
    toEnum 2 = ConsoleMessageLevelWarning
    toEnum 3 = ConsoleMessageLevelError
    toEnum 4 = ConsoleMessageLevelDebug
    toEnum k = AnotherConsoleMessageLevel k


