

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Flags
    ( 

-- * Exported types
    HitTestResultContext(..)                ,


    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map




-- Flags HitTestResultContext

data HitTestResultContext = 
      HitTestResultContextDocument
    | HitTestResultContextLink
    | HitTestResultContextImage
    | HitTestResultContextMedia
    | HitTestResultContextEditable
    | HitTestResultContextScrollbar
    | HitTestResultContextSelection
    | AnotherHitTestResultContext Int
    deriving (Show, Eq)

instance Enum HitTestResultContext where
    fromEnum HitTestResultContextDocument = 2
    fromEnum HitTestResultContextLink = 4
    fromEnum HitTestResultContextImage = 8
    fromEnum HitTestResultContextMedia = 16
    fromEnum HitTestResultContextEditable = 32
    fromEnum HitTestResultContextScrollbar = 64
    fromEnum HitTestResultContextSelection = 128
    fromEnum (AnotherHitTestResultContext k) = k

    toEnum 2 = HitTestResultContextDocument
    toEnum 4 = HitTestResultContextLink
    toEnum 8 = HitTestResultContextImage
    toEnum 16 = HitTestResultContextMedia
    toEnum 32 = HitTestResultContextEditable
    toEnum 64 = HitTestResultContextScrollbar
    toEnum 128 = HitTestResultContextSelection
    toEnum k = AnotherHitTestResultContext k

instance IsGFlag HitTestResultContext


