

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.ContextMenu
    ( 

-- * Exported types
    ContextMenu(..)                         ,
    ContextMenuK                            ,
    toContextMenu                           ,
    noContextMenu                           ,


 -- * Methods
-- ** contextMenuAppend
    ContextMenuAppendMethodInfo             ,
    contextMenuAppend                       ,


-- ** contextMenuFirst
    ContextMenuFirstMethodInfo              ,
    contextMenuFirst                        ,


-- ** contextMenuGetItemAtPosition
    ContextMenuGetItemAtPositionMethodInfo  ,
    contextMenuGetItemAtPosition            ,


-- ** contextMenuGetItems
    ContextMenuGetItemsMethodInfo           ,
    contextMenuGetItems                     ,


-- ** contextMenuGetNItems
    ContextMenuGetNItemsMethodInfo          ,
    contextMenuGetNItems                    ,


-- ** contextMenuGetUserData
    ContextMenuGetUserDataMethodInfo        ,
    contextMenuGetUserData                  ,


-- ** contextMenuInsert
    ContextMenuInsertMethodInfo             ,
    contextMenuInsert                       ,


-- ** contextMenuLast
    ContextMenuLastMethodInfo               ,
    contextMenuLast                         ,


-- ** contextMenuMoveItem
    ContextMenuMoveItemMethodInfo           ,
    contextMenuMoveItem                     ,


-- ** contextMenuNew
    contextMenuNew                          ,


-- ** contextMenuNewWithItems
    contextMenuNewWithItems                 ,


-- ** contextMenuPrepend
    ContextMenuPrependMethodInfo            ,
    contextMenuPrepend                      ,


-- ** contextMenuRemove
    ContextMenuRemoveMethodInfo             ,
    contextMenuRemove                       ,


-- ** contextMenuRemoveAll
    ContextMenuRemoveAllMethodInfo          ,
    contextMenuRemoveAll                    ,


-- ** contextMenuSetUserData
    ContextMenuSetUserDataMethodInfo        ,
    contextMenuSetUserData                  ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype ContextMenu = ContextMenu (ForeignPtr ContextMenu)
foreign import ccall "webkit_context_menu_get_type"
    c_webkit_context_menu_get_type :: IO GType

type instance ParentTypes ContextMenu = ContextMenuParentTypes
type ContextMenuParentTypes = '[GObject.Object]

instance GObject ContextMenu where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_context_menu_get_type
    

class GObject o => ContextMenuK o
instance (GObject o, IsDescendantOf ContextMenu o) => ContextMenuK o

toContextMenu :: ContextMenuK o => o -> IO ContextMenu
toContextMenu = unsafeCastTo ContextMenu

noContextMenu :: Maybe ContextMenu
noContextMenu = Nothing

type family ResolveContextMenuMethod (t :: Symbol) (o :: *) :: * where
    ResolveContextMenuMethod "append" o = ContextMenuAppendMethodInfo
    ResolveContextMenuMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveContextMenuMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveContextMenuMethod "first" o = ContextMenuFirstMethodInfo
    ResolveContextMenuMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveContextMenuMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveContextMenuMethod "insert" o = ContextMenuInsertMethodInfo
    ResolveContextMenuMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveContextMenuMethod "last" o = ContextMenuLastMethodInfo
    ResolveContextMenuMethod "moveItem" o = ContextMenuMoveItemMethodInfo
    ResolveContextMenuMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveContextMenuMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveContextMenuMethod "prepend" o = ContextMenuPrependMethodInfo
    ResolveContextMenuMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveContextMenuMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveContextMenuMethod "remove" o = ContextMenuRemoveMethodInfo
    ResolveContextMenuMethod "removeAll" o = ContextMenuRemoveAllMethodInfo
    ResolveContextMenuMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveContextMenuMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveContextMenuMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveContextMenuMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveContextMenuMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveContextMenuMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveContextMenuMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveContextMenuMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveContextMenuMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveContextMenuMethod "getItemAtPosition" o = ContextMenuGetItemAtPositionMethodInfo
    ResolveContextMenuMethod "getItems" o = ContextMenuGetItemsMethodInfo
    ResolveContextMenuMethod "getNItems" o = ContextMenuGetNItemsMethodInfo
    ResolveContextMenuMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveContextMenuMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveContextMenuMethod "getUserData" o = ContextMenuGetUserDataMethodInfo
    ResolveContextMenuMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveContextMenuMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveContextMenuMethod "setUserData" o = ContextMenuSetUserDataMethodInfo
    ResolveContextMenuMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveContextMenuMethod t ContextMenu, MethodInfo info ContextMenu p) => IsLabelProxy t (ContextMenu -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveContextMenuMethod t ContextMenu, MethodInfo info ContextMenu p) => IsLabel t (ContextMenu -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList ContextMenu = ContextMenuAttributeList
type ContextMenuAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList ContextMenu = ContextMenuSignalList
type ContextMenuSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method ContextMenu::new
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ContextMenu")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_new" webkit_context_menu_new :: 
    IO (Ptr ContextMenu)


contextMenuNew ::
    (MonadIO m) =>
    m ContextMenu                           -- result
contextMenuNew  = liftIO $ do
    result <- webkit_context_menu_new
    checkUnexpectedReturnNULL "webkit_context_menu_new" result
    result' <- (wrapObject ContextMenu) result
    return result'

-- method ContextMenu::new_with_items
-- method type : Constructor
-- Args : [Arg {argCName = "items", argType = TGList (TInterface "WebKit2WebExtension" "ContextMenuItem"), direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ContextMenu")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_new_with_items" webkit_context_menu_new_with_items :: 
    Ptr (GList (Ptr ContextMenuItem)) ->    -- items : TGList (TInterface "WebKit2WebExtension" "ContextMenuItem")
    IO (Ptr ContextMenu)


contextMenuNewWithItems ::
    (MonadIO m, ContextMenuItemK a) =>
    [a]                                     -- items
    -> m ContextMenu                        -- result
contextMenuNewWithItems items = liftIO $ do
    let items' = map unsafeManagedPtrCastPtr items
    items'' <- packGList items'
    result <- webkit_context_menu_new_with_items items''
    checkUnexpectedReturnNULL "webkit_context_menu_new_with_items" result
    result' <- (wrapObject ContextMenu) result
    mapM_ touchManagedPtr items
    g_list_free items''
    return result'

-- method ContextMenu::append
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "item", argType = TInterface "WebKit2WebExtension" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_append" webkit_context_menu_append :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    Ptr ContextMenuItem ->                  -- item : TInterface "WebKit2WebExtension" "ContextMenuItem"
    IO ()


contextMenuAppend ::
    (MonadIO m, ContextMenuK a, ContextMenuItemK b) =>
    a                                       -- _obj
    -> b                                    -- item
    -> m ()                                 -- result
contextMenuAppend _obj item = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let item' = unsafeManagedPtrCastPtr item
    webkit_context_menu_append _obj' item'
    touchManagedPtr _obj
    touchManagedPtr item
    return ()

data ContextMenuAppendMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, ContextMenuK a, ContextMenuItemK b) => MethodInfo ContextMenuAppendMethodInfo a signature where
    overloadedMethod _ = contextMenuAppend

-- method ContextMenu::first
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ContextMenuItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_first" webkit_context_menu_first :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    IO (Ptr ContextMenuItem)


contextMenuFirst ::
    (MonadIO m, ContextMenuK a) =>
    a                                       -- _obj
    -> m ContextMenuItem                    -- result
contextMenuFirst _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_first _obj'
    checkUnexpectedReturnNULL "webkit_context_menu_first" result
    result' <- (newObject ContextMenuItem) result
    touchManagedPtr _obj
    return result'

data ContextMenuFirstMethodInfo
instance (signature ~ (m ContextMenuItem), MonadIO m, ContextMenuK a) => MethodInfo ContextMenuFirstMethodInfo a signature where
    overloadedMethod _ = contextMenuFirst

-- method ContextMenu::get_item_at_position
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "position", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ContextMenuItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_get_item_at_position" webkit_context_menu_get_item_at_position :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    Word32 ->                               -- position : TBasicType TUInt
    IO (Ptr ContextMenuItem)


contextMenuGetItemAtPosition ::
    (MonadIO m, ContextMenuK a) =>
    a                                       -- _obj
    -> Word32                               -- position
    -> m ContextMenuItem                    -- result
contextMenuGetItemAtPosition _obj position = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_get_item_at_position _obj' position
    checkUnexpectedReturnNULL "webkit_context_menu_get_item_at_position" result
    result' <- (newObject ContextMenuItem) result
    touchManagedPtr _obj
    return result'

data ContextMenuGetItemAtPositionMethodInfo
instance (signature ~ (Word32 -> m ContextMenuItem), MonadIO m, ContextMenuK a) => MethodInfo ContextMenuGetItemAtPositionMethodInfo a signature where
    overloadedMethod _ = contextMenuGetItemAtPosition

-- method ContextMenu::get_items
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TGList (TInterface "WebKit2WebExtension" "ContextMenuItem"))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_get_items" webkit_context_menu_get_items :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    IO (Ptr (GList (Ptr ContextMenuItem)))


contextMenuGetItems ::
    (MonadIO m, ContextMenuK a) =>
    a                                       -- _obj
    -> m [ContextMenuItem]                  -- result
contextMenuGetItems _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_get_items _obj'
    result' <- unpackGList result
    result'' <- mapM (newObject ContextMenuItem) result'
    touchManagedPtr _obj
    return result''

data ContextMenuGetItemsMethodInfo
instance (signature ~ (m [ContextMenuItem]), MonadIO m, ContextMenuK a) => MethodInfo ContextMenuGetItemsMethodInfo a signature where
    overloadedMethod _ = contextMenuGetItems

-- method ContextMenu::get_n_items
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_get_n_items" webkit_context_menu_get_n_items :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    IO Word32


contextMenuGetNItems ::
    (MonadIO m, ContextMenuK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
contextMenuGetNItems _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_get_n_items _obj'
    touchManagedPtr _obj
    return result

data ContextMenuGetNItemsMethodInfo
instance (signature ~ (m Word32), MonadIO m, ContextMenuK a) => MethodInfo ContextMenuGetNItemsMethodInfo a signature where
    overloadedMethod _ = contextMenuGetNItems

-- method ContextMenu::get_user_data
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_get_user_data" webkit_context_menu_get_user_data :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    IO (Ptr GVariant)


contextMenuGetUserData ::
    (MonadIO m, ContextMenuK a) =>
    a                                       -- _obj
    -> m GVariant                           -- result
contextMenuGetUserData _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_get_user_data _obj'
    checkUnexpectedReturnNULL "webkit_context_menu_get_user_data" result
    result' <- newGVariantFromPtr result
    touchManagedPtr _obj
    return result'

data ContextMenuGetUserDataMethodInfo
instance (signature ~ (m GVariant), MonadIO m, ContextMenuK a) => MethodInfo ContextMenuGetUserDataMethodInfo a signature where
    overloadedMethod _ = contextMenuGetUserData

-- method ContextMenu::insert
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "item", argType = TInterface "WebKit2WebExtension" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "position", argType = TBasicType TInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_insert" webkit_context_menu_insert :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    Ptr ContextMenuItem ->                  -- item : TInterface "WebKit2WebExtension" "ContextMenuItem"
    Int32 ->                                -- position : TBasicType TInt
    IO ()


contextMenuInsert ::
    (MonadIO m, ContextMenuK a, ContextMenuItemK b) =>
    a                                       -- _obj
    -> b                                    -- item
    -> Int32                                -- position
    -> m ()                                 -- result
contextMenuInsert _obj item position = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let item' = unsafeManagedPtrCastPtr item
    webkit_context_menu_insert _obj' item' position
    touchManagedPtr _obj
    touchManagedPtr item
    return ()

data ContextMenuInsertMethodInfo
instance (signature ~ (b -> Int32 -> m ()), MonadIO m, ContextMenuK a, ContextMenuItemK b) => MethodInfo ContextMenuInsertMethodInfo a signature where
    overloadedMethod _ = contextMenuInsert

-- method ContextMenu::last
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ContextMenuItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_last" webkit_context_menu_last :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    IO (Ptr ContextMenuItem)


contextMenuLast ::
    (MonadIO m, ContextMenuK a) =>
    a                                       -- _obj
    -> m ContextMenuItem                    -- result
contextMenuLast _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_last _obj'
    checkUnexpectedReturnNULL "webkit_context_menu_last" result
    result' <- (newObject ContextMenuItem) result
    touchManagedPtr _obj
    return result'

data ContextMenuLastMethodInfo
instance (signature ~ (m ContextMenuItem), MonadIO m, ContextMenuK a) => MethodInfo ContextMenuLastMethodInfo a signature where
    overloadedMethod _ = contextMenuLast

-- method ContextMenu::move_item
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "item", argType = TInterface "WebKit2WebExtension" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "position", argType = TBasicType TInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_move_item" webkit_context_menu_move_item :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    Ptr ContextMenuItem ->                  -- item : TInterface "WebKit2WebExtension" "ContextMenuItem"
    Int32 ->                                -- position : TBasicType TInt
    IO ()


contextMenuMoveItem ::
    (MonadIO m, ContextMenuK a, ContextMenuItemK b) =>
    a                                       -- _obj
    -> b                                    -- item
    -> Int32                                -- position
    -> m ()                                 -- result
contextMenuMoveItem _obj item position = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let item' = unsafeManagedPtrCastPtr item
    webkit_context_menu_move_item _obj' item' position
    touchManagedPtr _obj
    touchManagedPtr item
    return ()

data ContextMenuMoveItemMethodInfo
instance (signature ~ (b -> Int32 -> m ()), MonadIO m, ContextMenuK a, ContextMenuItemK b) => MethodInfo ContextMenuMoveItemMethodInfo a signature where
    overloadedMethod _ = contextMenuMoveItem

-- method ContextMenu::prepend
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "item", argType = TInterface "WebKit2WebExtension" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_prepend" webkit_context_menu_prepend :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    Ptr ContextMenuItem ->                  -- item : TInterface "WebKit2WebExtension" "ContextMenuItem"
    IO ()


contextMenuPrepend ::
    (MonadIO m, ContextMenuK a, ContextMenuItemK b) =>
    a                                       -- _obj
    -> b                                    -- item
    -> m ()                                 -- result
contextMenuPrepend _obj item = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let item' = unsafeManagedPtrCastPtr item
    webkit_context_menu_prepend _obj' item'
    touchManagedPtr _obj
    touchManagedPtr item
    return ()

data ContextMenuPrependMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, ContextMenuK a, ContextMenuItemK b) => MethodInfo ContextMenuPrependMethodInfo a signature where
    overloadedMethod _ = contextMenuPrepend

-- method ContextMenu::remove
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "item", argType = TInterface "WebKit2WebExtension" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_remove" webkit_context_menu_remove :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    Ptr ContextMenuItem ->                  -- item : TInterface "WebKit2WebExtension" "ContextMenuItem"
    IO ()


contextMenuRemove ::
    (MonadIO m, ContextMenuK a, ContextMenuItemK b) =>
    a                                       -- _obj
    -> b                                    -- item
    -> m ()                                 -- result
contextMenuRemove _obj item = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let item' = unsafeManagedPtrCastPtr item
    webkit_context_menu_remove _obj' item'
    touchManagedPtr _obj
    touchManagedPtr item
    return ()

data ContextMenuRemoveMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, ContextMenuK a, ContextMenuItemK b) => MethodInfo ContextMenuRemoveMethodInfo a signature where
    overloadedMethod _ = contextMenuRemove

-- method ContextMenu::remove_all
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_remove_all" webkit_context_menu_remove_all :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    IO ()


contextMenuRemoveAll ::
    (MonadIO m, ContextMenuK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
contextMenuRemoveAll _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_context_menu_remove_all _obj'
    touchManagedPtr _obj
    return ()

data ContextMenuRemoveAllMethodInfo
instance (signature ~ (m ()), MonadIO m, ContextMenuK a) => MethodInfo ContextMenuRemoveAllMethodInfo a signature where
    overloadedMethod _ = contextMenuRemoveAll

-- method ContextMenu::set_user_data
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TVariant, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_set_user_data" webkit_context_menu_set_user_data :: 
    Ptr ContextMenu ->                      -- _obj : TInterface "WebKit2WebExtension" "ContextMenu"
    Ptr GVariant ->                         -- user_data : TVariant
    IO ()


contextMenuSetUserData ::
    (MonadIO m, ContextMenuK a) =>
    a                                       -- _obj
    -> GVariant                             -- userData
    -> m ()                                 -- result
contextMenuSetUserData _obj userData = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let userData' = unsafeManagedPtrGetPtr userData
    webkit_context_menu_set_user_data _obj' userData'
    touchManagedPtr _obj
    return ()

data ContextMenuSetUserDataMethodInfo
instance (signature ~ (GVariant -> m ()), MonadIO m, ContextMenuK a) => MethodInfo ContextMenuSetUserDataMethodInfo a signature where
    overloadedMethod _ = contextMenuSetUserData


