

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMDOMWindow
    ( 

-- * Exported types
    DOMDOMWindow(..)                        ,
    DOMDOMWindowK                           ,
    toDOMDOMWindow                          ,
    noDOMDOMWindow                          ,


 -- * Methods
-- ** dOMDOMWindowWebkitMessageHandlersPostMessage
    DOMDOMWindowWebkitMessageHandlersPostMessageMethodInfo,
    dOMDOMWindowWebkitMessageHandlersPostMessage,




 -- * Properties
-- ** Closed
    DOMDOMWindowClosedPropertyInfo          ,
    dOMDOMWindowClosed                      ,
    getDOMDOMWindowClosed                   ,


-- ** DefaultStatus
    DOMDOMWindowDefaultStatusPropertyInfo   ,
    clearDOMDOMWindowDefaultStatus          ,
    constructDOMDOMWindowDefaultStatus      ,
    dOMDOMWindowDefaultStatus               ,
    getDOMDOMWindowDefaultStatus            ,
    setDOMDOMWindowDefaultStatus            ,


-- ** DevicePixelRatio
    DOMDOMWindowDevicePixelRatioPropertyInfo,
    dOMDOMWindowDevicePixelRatio            ,
    getDOMDOMWindowDevicePixelRatio         ,


-- ** Document
    DOMDOMWindowDocumentPropertyInfo        ,
    dOMDOMWindowDocument                    ,
    getDOMDOMWindowDocument                 ,


-- ** FrameElement
    DOMDOMWindowFrameElementPropertyInfo    ,
    dOMDOMWindowFrameElement                ,
    getDOMDOMWindowFrameElement             ,


-- ** Frames
    DOMDOMWindowFramesPropertyInfo          ,
    dOMDOMWindowFrames                      ,
    getDOMDOMWindowFrames                   ,


-- ** InnerHeight
    DOMDOMWindowInnerHeightPropertyInfo     ,
    dOMDOMWindowInnerHeight                 ,
    getDOMDOMWindowInnerHeight              ,


-- ** InnerWidth
    DOMDOMWindowInnerWidthPropertyInfo      ,
    dOMDOMWindowInnerWidth                  ,
    getDOMDOMWindowInnerWidth               ,


-- ** Length
    DOMDOMWindowLengthPropertyInfo          ,
    dOMDOMWindowLength                      ,
    getDOMDOMWindowLength                   ,


-- ** Name
    DOMDOMWindowNamePropertyInfo            ,
    clearDOMDOMWindowName                   ,
    constructDOMDOMWindowName               ,
    dOMDOMWindowName                        ,
    getDOMDOMWindowName                     ,
    setDOMDOMWindowName                     ,


-- ** OffscreenBuffering
    DOMDOMWindowOffscreenBufferingPropertyInfo,
    dOMDOMWindowOffscreenBuffering          ,
    getDOMDOMWindowOffscreenBuffering       ,


-- ** Opener
    DOMDOMWindowOpenerPropertyInfo          ,
    dOMDOMWindowOpener                      ,
    getDOMDOMWindowOpener                   ,


-- ** Orientation
    DOMDOMWindowOrientationPropertyInfo     ,
    dOMDOMWindowOrientation                 ,
    getDOMDOMWindowOrientation              ,


-- ** OuterHeight
    DOMDOMWindowOuterHeightPropertyInfo     ,
    dOMDOMWindowOuterHeight                 ,
    getDOMDOMWindowOuterHeight              ,


-- ** OuterWidth
    DOMDOMWindowOuterWidthPropertyInfo      ,
    dOMDOMWindowOuterWidth                  ,
    getDOMDOMWindowOuterWidth               ,


-- ** PageXOffset
    DOMDOMWindowPageXOffsetPropertyInfo     ,
    dOMDOMWindowPageXOffset                 ,
    getDOMDOMWindowPageXOffset              ,


-- ** PageYOffset
    DOMDOMWindowPageYOffsetPropertyInfo     ,
    dOMDOMWindowPageYOffset                 ,
    getDOMDOMWindowPageYOffset              ,


-- ** Parent
    DOMDOMWindowParentPropertyInfo          ,
    dOMDOMWindowParent                      ,
    getDOMDOMWindowParent                   ,


-- ** ScreenLeft
    DOMDOMWindowScreenLeftPropertyInfo      ,
    dOMDOMWindowScreenLeft                  ,
    getDOMDOMWindowScreenLeft               ,


-- ** ScreenTop
    DOMDOMWindowScreenTopPropertyInfo       ,
    dOMDOMWindowScreenTop                   ,
    getDOMDOMWindowScreenTop                ,


-- ** ScreenX
    DOMDOMWindowScreenXPropertyInfo         ,
    dOMDOMWindowScreenX                     ,
    getDOMDOMWindowScreenX                  ,


-- ** ScreenY
    DOMDOMWindowScreenYPropertyInfo         ,
    dOMDOMWindowScreenY                     ,
    getDOMDOMWindowScreenY                  ,


-- ** ScrollX
    DOMDOMWindowScrollXPropertyInfo         ,
    dOMDOMWindowScrollX                     ,
    getDOMDOMWindowScrollX                  ,


-- ** ScrollY
    DOMDOMWindowScrollYPropertyInfo         ,
    dOMDOMWindowScrollY                     ,
    getDOMDOMWindowScrollY                  ,


-- ** Self
    DOMDOMWindowSelfPropertyInfo            ,
    dOMDOMWindowSelf                        ,
    getDOMDOMWindowSelf                     ,


-- ** Status
    DOMDOMWindowStatusPropertyInfo          ,
    clearDOMDOMWindowStatus                 ,
    constructDOMDOMWindowStatus             ,
    dOMDOMWindowStatus                      ,
    getDOMDOMWindowStatus                   ,
    setDOMDOMWindowStatus                   ,


-- ** Top
    DOMDOMWindowTopPropertyInfo             ,
    dOMDOMWindowTop                         ,
    getDOMDOMWindowTop                      ,


-- ** Window
    DOMDOMWindowWindowPropertyInfo          ,
    dOMDOMWindowWindow                      ,
    getDOMDOMWindowWindow                   ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMDOMWindow = DOMDOMWindow (ForeignPtr DOMDOMWindow)
foreign import ccall "webkit_dom_dom_window_get_type"
    c_webkit_dom_dom_window_get_type :: IO GType

type instance ParentTypes DOMDOMWindow = DOMDOMWindowParentTypes
type DOMDOMWindowParentTypes = '[DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMDOMWindow where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_dom_window_get_type
    

class GObject o => DOMDOMWindowK o
instance (GObject o, IsDescendantOf DOMDOMWindow o) => DOMDOMWindowK o

toDOMDOMWindow :: DOMDOMWindowK o => o -> IO DOMDOMWindow
toDOMDOMWindow = unsafeCastTo DOMDOMWindow

noDOMDOMWindow :: Maybe DOMDOMWindow
noDOMDOMWindow = Nothing

type family ResolveDOMDOMWindowMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMDOMWindowMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMDOMWindowMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMDOMWindowMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMDOMWindowMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMDOMWindowMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMDOMWindowMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMDOMWindowMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMDOMWindowMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMDOMWindowMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMDOMWindowMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMDOMWindowMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMDOMWindowMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMDOMWindowMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMDOMWindowMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMDOMWindowMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMDOMWindowMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMDOMWindowMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMDOMWindowMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMDOMWindowMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMDOMWindowMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMDOMWindowMethod "webkitMessageHandlersPostMessage" o = DOMDOMWindowWebkitMessageHandlersPostMessageMethodInfo
    ResolveDOMDOMWindowMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMDOMWindowMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMDOMWindowMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMDOMWindowMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMDOMWindowMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMDOMWindowMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMDOMWindowMethod t DOMDOMWindow, MethodInfo info DOMDOMWindow p) => IsLabelProxy t (DOMDOMWindow -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMDOMWindowMethod t DOMDOMWindow, MethodInfo info DOMDOMWindow p) => IsLabel t (DOMDOMWindow -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "closed"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowClosed :: (MonadIO m, DOMDOMWindowK o) => o -> m Bool
getDOMDOMWindowClosed obj = liftIO $ getObjectPropertyBool obj "closed"

data DOMDOMWindowClosedPropertyInfo
instance AttrInfo DOMDOMWindowClosedPropertyInfo where
    type AttrAllowedOps DOMDOMWindowClosedPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowClosedPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowClosedPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowClosedPropertyInfo = Bool
    type AttrLabel DOMDOMWindowClosedPropertyInfo = "closed"
    attrGet _ = getDOMDOMWindowClosed
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "default-status"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowDefaultStatus :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe T.Text)
getDOMDOMWindowDefaultStatus obj = liftIO $ getObjectPropertyString obj "default-status"

setDOMDOMWindowDefaultStatus :: (MonadIO m, DOMDOMWindowK o) => o -> T.Text -> m ()
setDOMDOMWindowDefaultStatus obj val = liftIO $ setObjectPropertyString obj "default-status" (Just val)

constructDOMDOMWindowDefaultStatus :: T.Text -> IO ([Char], GValue)
constructDOMDOMWindowDefaultStatus val = constructObjectPropertyString "default-status" (Just val)

clearDOMDOMWindowDefaultStatus :: (MonadIO m, DOMDOMWindowK o) => o -> m ()
clearDOMDOMWindowDefaultStatus obj = liftIO $ setObjectPropertyString obj "default-status" (Nothing :: Maybe T.Text)

data DOMDOMWindowDefaultStatusPropertyInfo
instance AttrInfo DOMDOMWindowDefaultStatusPropertyInfo where
    type AttrAllowedOps DOMDOMWindowDefaultStatusPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowDefaultStatusPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMDOMWindowDefaultStatusPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowDefaultStatusPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMDOMWindowDefaultStatusPropertyInfo = "default-status"
    attrGet _ = getDOMDOMWindowDefaultStatus
    attrSet _ = setDOMDOMWindowDefaultStatus
    attrConstruct _ = constructDOMDOMWindowDefaultStatus
    attrClear _ = clearDOMDOMWindowDefaultStatus

-- VVV Prop "device-pixel-ratio"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowDevicePixelRatio :: (MonadIO m, DOMDOMWindowK o) => o -> m Double
getDOMDOMWindowDevicePixelRatio obj = liftIO $ getObjectPropertyDouble obj "device-pixel-ratio"

data DOMDOMWindowDevicePixelRatioPropertyInfo
instance AttrInfo DOMDOMWindowDevicePixelRatioPropertyInfo where
    type AttrAllowedOps DOMDOMWindowDevicePixelRatioPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowDevicePixelRatioPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowDevicePixelRatioPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowDevicePixelRatioPropertyInfo = Double
    type AttrLabel DOMDOMWindowDevicePixelRatioPropertyInfo = "device-pixel-ratio"
    attrGet _ = getDOMDOMWindowDevicePixelRatio
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "document"
   -- Type: TInterface "WebKit2WebExtension" "DOMDocument"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowDocument :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe DOMDocument)
getDOMDOMWindowDocument obj = liftIO $ getObjectPropertyObject obj "document" DOMDocument

data DOMDOMWindowDocumentPropertyInfo
instance AttrInfo DOMDOMWindowDocumentPropertyInfo where
    type AttrAllowedOps DOMDOMWindowDocumentPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowDocumentPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowDocumentPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowDocumentPropertyInfo = (Maybe DOMDocument)
    type AttrLabel DOMDOMWindowDocumentPropertyInfo = "document"
    attrGet _ = getDOMDOMWindowDocument
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "frame-element"
   -- Type: TInterface "WebKit2WebExtension" "DOMElement"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowFrameElement :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe DOMElement)
getDOMDOMWindowFrameElement obj = liftIO $ getObjectPropertyObject obj "frame-element" DOMElement

data DOMDOMWindowFrameElementPropertyInfo
instance AttrInfo DOMDOMWindowFrameElementPropertyInfo where
    type AttrAllowedOps DOMDOMWindowFrameElementPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowFrameElementPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowFrameElementPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowFrameElementPropertyInfo = (Maybe DOMElement)
    type AttrLabel DOMDOMWindowFrameElementPropertyInfo = "frame-element"
    attrGet _ = getDOMDOMWindowFrameElement
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "frames"
   -- Type: TInterface "WebKit2WebExtension" "DOMDOMWindow"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowFrames :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe DOMDOMWindow)
getDOMDOMWindowFrames obj = liftIO $ getObjectPropertyObject obj "frames" DOMDOMWindow

data DOMDOMWindowFramesPropertyInfo
instance AttrInfo DOMDOMWindowFramesPropertyInfo where
    type AttrAllowedOps DOMDOMWindowFramesPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowFramesPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowFramesPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowFramesPropertyInfo = (Maybe DOMDOMWindow)
    type AttrLabel DOMDOMWindowFramesPropertyInfo = "frames"
    attrGet _ = getDOMDOMWindowFrames
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "inner-height"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowInnerHeight :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowInnerHeight obj = liftIO $ getObjectPropertyLong obj "inner-height"

data DOMDOMWindowInnerHeightPropertyInfo
instance AttrInfo DOMDOMWindowInnerHeightPropertyInfo where
    type AttrAllowedOps DOMDOMWindowInnerHeightPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowInnerHeightPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowInnerHeightPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowInnerHeightPropertyInfo = CLong
    type AttrLabel DOMDOMWindowInnerHeightPropertyInfo = "inner-height"
    attrGet _ = getDOMDOMWindowInnerHeight
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "inner-width"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowInnerWidth :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowInnerWidth obj = liftIO $ getObjectPropertyLong obj "inner-width"

data DOMDOMWindowInnerWidthPropertyInfo
instance AttrInfo DOMDOMWindowInnerWidthPropertyInfo where
    type AttrAllowedOps DOMDOMWindowInnerWidthPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowInnerWidthPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowInnerWidthPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowInnerWidthPropertyInfo = CLong
    type AttrLabel DOMDOMWindowInnerWidthPropertyInfo = "inner-width"
    attrGet _ = getDOMDOMWindowInnerWidth
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "length"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowLength :: (MonadIO m, DOMDOMWindowK o) => o -> m CULong
getDOMDOMWindowLength obj = liftIO $ getObjectPropertyULong obj "length"

data DOMDOMWindowLengthPropertyInfo
instance AttrInfo DOMDOMWindowLengthPropertyInfo where
    type AttrAllowedOps DOMDOMWindowLengthPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowLengthPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowLengthPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowLengthPropertyInfo = CULong
    type AttrLabel DOMDOMWindowLengthPropertyInfo = "length"
    attrGet _ = getDOMDOMWindowLength
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowName :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe T.Text)
getDOMDOMWindowName obj = liftIO $ getObjectPropertyString obj "name"

setDOMDOMWindowName :: (MonadIO m, DOMDOMWindowK o) => o -> T.Text -> m ()
setDOMDOMWindowName obj val = liftIO $ setObjectPropertyString obj "name" (Just val)

constructDOMDOMWindowName :: T.Text -> IO ([Char], GValue)
constructDOMDOMWindowName val = constructObjectPropertyString "name" (Just val)

clearDOMDOMWindowName :: (MonadIO m, DOMDOMWindowK o) => o -> m ()
clearDOMDOMWindowName obj = liftIO $ setObjectPropertyString obj "name" (Nothing :: Maybe T.Text)

data DOMDOMWindowNamePropertyInfo
instance AttrInfo DOMDOMWindowNamePropertyInfo where
    type AttrAllowedOps DOMDOMWindowNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowNamePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMDOMWindowNamePropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowNamePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMDOMWindowNamePropertyInfo = "name"
    attrGet _ = getDOMDOMWindowName
    attrSet _ = setDOMDOMWindowName
    attrConstruct _ = constructDOMDOMWindowName
    attrClear _ = clearDOMDOMWindowName

-- VVV Prop "offscreen-buffering"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowOffscreenBuffering :: (MonadIO m, DOMDOMWindowK o) => o -> m Bool
getDOMDOMWindowOffscreenBuffering obj = liftIO $ getObjectPropertyBool obj "offscreen-buffering"

data DOMDOMWindowOffscreenBufferingPropertyInfo
instance AttrInfo DOMDOMWindowOffscreenBufferingPropertyInfo where
    type AttrAllowedOps DOMDOMWindowOffscreenBufferingPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowOffscreenBufferingPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowOffscreenBufferingPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowOffscreenBufferingPropertyInfo = Bool
    type AttrLabel DOMDOMWindowOffscreenBufferingPropertyInfo = "offscreen-buffering"
    attrGet _ = getDOMDOMWindowOffscreenBuffering
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "opener"
   -- Type: TInterface "WebKit2WebExtension" "DOMDOMWindow"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowOpener :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe DOMDOMWindow)
getDOMDOMWindowOpener obj = liftIO $ getObjectPropertyObject obj "opener" DOMDOMWindow

data DOMDOMWindowOpenerPropertyInfo
instance AttrInfo DOMDOMWindowOpenerPropertyInfo where
    type AttrAllowedOps DOMDOMWindowOpenerPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowOpenerPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowOpenerPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowOpenerPropertyInfo = (Maybe DOMDOMWindow)
    type AttrLabel DOMDOMWindowOpenerPropertyInfo = "opener"
    attrGet _ = getDOMDOMWindowOpener
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "orientation"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowOrientation :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowOrientation obj = liftIO $ getObjectPropertyLong obj "orientation"

data DOMDOMWindowOrientationPropertyInfo
instance AttrInfo DOMDOMWindowOrientationPropertyInfo where
    type AttrAllowedOps DOMDOMWindowOrientationPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowOrientationPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowOrientationPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowOrientationPropertyInfo = CLong
    type AttrLabel DOMDOMWindowOrientationPropertyInfo = "orientation"
    attrGet _ = getDOMDOMWindowOrientation
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "outer-height"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowOuterHeight :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowOuterHeight obj = liftIO $ getObjectPropertyLong obj "outer-height"

data DOMDOMWindowOuterHeightPropertyInfo
instance AttrInfo DOMDOMWindowOuterHeightPropertyInfo where
    type AttrAllowedOps DOMDOMWindowOuterHeightPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowOuterHeightPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowOuterHeightPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowOuterHeightPropertyInfo = CLong
    type AttrLabel DOMDOMWindowOuterHeightPropertyInfo = "outer-height"
    attrGet _ = getDOMDOMWindowOuterHeight
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "outer-width"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowOuterWidth :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowOuterWidth obj = liftIO $ getObjectPropertyLong obj "outer-width"

data DOMDOMWindowOuterWidthPropertyInfo
instance AttrInfo DOMDOMWindowOuterWidthPropertyInfo where
    type AttrAllowedOps DOMDOMWindowOuterWidthPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowOuterWidthPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowOuterWidthPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowOuterWidthPropertyInfo = CLong
    type AttrLabel DOMDOMWindowOuterWidthPropertyInfo = "outer-width"
    attrGet _ = getDOMDOMWindowOuterWidth
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "page-x-offset"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowPageXOffset :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowPageXOffset obj = liftIO $ getObjectPropertyLong obj "page-x-offset"

data DOMDOMWindowPageXOffsetPropertyInfo
instance AttrInfo DOMDOMWindowPageXOffsetPropertyInfo where
    type AttrAllowedOps DOMDOMWindowPageXOffsetPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowPageXOffsetPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowPageXOffsetPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowPageXOffsetPropertyInfo = CLong
    type AttrLabel DOMDOMWindowPageXOffsetPropertyInfo = "page-x-offset"
    attrGet _ = getDOMDOMWindowPageXOffset
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "page-y-offset"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowPageYOffset :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowPageYOffset obj = liftIO $ getObjectPropertyLong obj "page-y-offset"

data DOMDOMWindowPageYOffsetPropertyInfo
instance AttrInfo DOMDOMWindowPageYOffsetPropertyInfo where
    type AttrAllowedOps DOMDOMWindowPageYOffsetPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowPageYOffsetPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowPageYOffsetPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowPageYOffsetPropertyInfo = CLong
    type AttrLabel DOMDOMWindowPageYOffsetPropertyInfo = "page-y-offset"
    attrGet _ = getDOMDOMWindowPageYOffset
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "parent"
   -- Type: TInterface "WebKit2WebExtension" "DOMDOMWindow"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowParent :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe DOMDOMWindow)
getDOMDOMWindowParent obj = liftIO $ getObjectPropertyObject obj "parent" DOMDOMWindow

data DOMDOMWindowParentPropertyInfo
instance AttrInfo DOMDOMWindowParentPropertyInfo where
    type AttrAllowedOps DOMDOMWindowParentPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowParentPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowParentPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowParentPropertyInfo = (Maybe DOMDOMWindow)
    type AttrLabel DOMDOMWindowParentPropertyInfo = "parent"
    attrGet _ = getDOMDOMWindowParent
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "screen-left"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowScreenLeft :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowScreenLeft obj = liftIO $ getObjectPropertyLong obj "screen-left"

data DOMDOMWindowScreenLeftPropertyInfo
instance AttrInfo DOMDOMWindowScreenLeftPropertyInfo where
    type AttrAllowedOps DOMDOMWindowScreenLeftPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowScreenLeftPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowScreenLeftPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowScreenLeftPropertyInfo = CLong
    type AttrLabel DOMDOMWindowScreenLeftPropertyInfo = "screen-left"
    attrGet _ = getDOMDOMWindowScreenLeft
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "screen-top"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowScreenTop :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowScreenTop obj = liftIO $ getObjectPropertyLong obj "screen-top"

data DOMDOMWindowScreenTopPropertyInfo
instance AttrInfo DOMDOMWindowScreenTopPropertyInfo where
    type AttrAllowedOps DOMDOMWindowScreenTopPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowScreenTopPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowScreenTopPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowScreenTopPropertyInfo = CLong
    type AttrLabel DOMDOMWindowScreenTopPropertyInfo = "screen-top"
    attrGet _ = getDOMDOMWindowScreenTop
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "screen-x"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowScreenX :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowScreenX obj = liftIO $ getObjectPropertyLong obj "screen-x"

data DOMDOMWindowScreenXPropertyInfo
instance AttrInfo DOMDOMWindowScreenXPropertyInfo where
    type AttrAllowedOps DOMDOMWindowScreenXPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowScreenXPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowScreenXPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowScreenXPropertyInfo = CLong
    type AttrLabel DOMDOMWindowScreenXPropertyInfo = "screen-x"
    attrGet _ = getDOMDOMWindowScreenX
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "screen-y"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowScreenY :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowScreenY obj = liftIO $ getObjectPropertyLong obj "screen-y"

data DOMDOMWindowScreenYPropertyInfo
instance AttrInfo DOMDOMWindowScreenYPropertyInfo where
    type AttrAllowedOps DOMDOMWindowScreenYPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowScreenYPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowScreenYPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowScreenYPropertyInfo = CLong
    type AttrLabel DOMDOMWindowScreenYPropertyInfo = "screen-y"
    attrGet _ = getDOMDOMWindowScreenY
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "scroll-x"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowScrollX :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowScrollX obj = liftIO $ getObjectPropertyLong obj "scroll-x"

data DOMDOMWindowScrollXPropertyInfo
instance AttrInfo DOMDOMWindowScrollXPropertyInfo where
    type AttrAllowedOps DOMDOMWindowScrollXPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowScrollXPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowScrollXPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowScrollXPropertyInfo = CLong
    type AttrLabel DOMDOMWindowScrollXPropertyInfo = "scroll-x"
    attrGet _ = getDOMDOMWindowScrollX
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "scroll-y"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowScrollY :: (MonadIO m, DOMDOMWindowK o) => o -> m CLong
getDOMDOMWindowScrollY obj = liftIO $ getObjectPropertyLong obj "scroll-y"

data DOMDOMWindowScrollYPropertyInfo
instance AttrInfo DOMDOMWindowScrollYPropertyInfo where
    type AttrAllowedOps DOMDOMWindowScrollYPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDOMWindowScrollYPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowScrollYPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowScrollYPropertyInfo = CLong
    type AttrLabel DOMDOMWindowScrollYPropertyInfo = "scroll-y"
    attrGet _ = getDOMDOMWindowScrollY
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "self"
   -- Type: TInterface "WebKit2WebExtension" "DOMDOMWindow"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowSelf :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe DOMDOMWindow)
getDOMDOMWindowSelf obj = liftIO $ getObjectPropertyObject obj "self" DOMDOMWindow

data DOMDOMWindowSelfPropertyInfo
instance AttrInfo DOMDOMWindowSelfPropertyInfo where
    type AttrAllowedOps DOMDOMWindowSelfPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowSelfPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowSelfPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowSelfPropertyInfo = (Maybe DOMDOMWindow)
    type AttrLabel DOMDOMWindowSelfPropertyInfo = "self"
    attrGet _ = getDOMDOMWindowSelf
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "status"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowStatus :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe T.Text)
getDOMDOMWindowStatus obj = liftIO $ getObjectPropertyString obj "status"

setDOMDOMWindowStatus :: (MonadIO m, DOMDOMWindowK o) => o -> T.Text -> m ()
setDOMDOMWindowStatus obj val = liftIO $ setObjectPropertyString obj "status" (Just val)

constructDOMDOMWindowStatus :: T.Text -> IO ([Char], GValue)
constructDOMDOMWindowStatus val = constructObjectPropertyString "status" (Just val)

clearDOMDOMWindowStatus :: (MonadIO m, DOMDOMWindowK o) => o -> m ()
clearDOMDOMWindowStatus obj = liftIO $ setObjectPropertyString obj "status" (Nothing :: Maybe T.Text)

data DOMDOMWindowStatusPropertyInfo
instance AttrInfo DOMDOMWindowStatusPropertyInfo where
    type AttrAllowedOps DOMDOMWindowStatusPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowStatusPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMDOMWindowStatusPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowStatusPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMDOMWindowStatusPropertyInfo = "status"
    attrGet _ = getDOMDOMWindowStatus
    attrSet _ = setDOMDOMWindowStatus
    attrConstruct _ = constructDOMDOMWindowStatus
    attrClear _ = clearDOMDOMWindowStatus

-- VVV Prop "top"
   -- Type: TInterface "WebKit2WebExtension" "DOMDOMWindow"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowTop :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe DOMDOMWindow)
getDOMDOMWindowTop obj = liftIO $ getObjectPropertyObject obj "top" DOMDOMWindow

data DOMDOMWindowTopPropertyInfo
instance AttrInfo DOMDOMWindowTopPropertyInfo where
    type AttrAllowedOps DOMDOMWindowTopPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowTopPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowTopPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowTopPropertyInfo = (Maybe DOMDOMWindow)
    type AttrLabel DOMDOMWindowTopPropertyInfo = "top"
    attrGet _ = getDOMDOMWindowTop
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "window"
   -- Type: TInterface "WebKit2WebExtension" "DOMDOMWindow"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDOMWindowWindow :: (MonadIO m, DOMDOMWindowK o) => o -> m (Maybe DOMDOMWindow)
getDOMDOMWindowWindow obj = liftIO $ getObjectPropertyObject obj "window" DOMDOMWindow

data DOMDOMWindowWindowPropertyInfo
instance AttrInfo DOMDOMWindowWindowPropertyInfo where
    type AttrAllowedOps DOMDOMWindowWindowPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDOMWindowWindowPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDOMWindowWindowPropertyInfo = DOMDOMWindowK
    type AttrGetType DOMDOMWindowWindowPropertyInfo = (Maybe DOMDOMWindow)
    type AttrLabel DOMDOMWindowWindowPropertyInfo = "window"
    attrGet _ = getDOMDOMWindowWindow
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList DOMDOMWindow = DOMDOMWindowAttributeList
type DOMDOMWindowAttributeList = ('[ '("closed", DOMDOMWindowClosedPropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("defaultStatus", DOMDOMWindowDefaultStatusPropertyInfo), '("devicePixelRatio", DOMDOMWindowDevicePixelRatioPropertyInfo), '("document", DOMDOMWindowDocumentPropertyInfo), '("frameElement", DOMDOMWindowFrameElementPropertyInfo), '("frames", DOMDOMWindowFramesPropertyInfo), '("innerHeight", DOMDOMWindowInnerHeightPropertyInfo), '("innerWidth", DOMDOMWindowInnerWidthPropertyInfo), '("length", DOMDOMWindowLengthPropertyInfo), '("name", DOMDOMWindowNamePropertyInfo), '("offscreenBuffering", DOMDOMWindowOffscreenBufferingPropertyInfo), '("opener", DOMDOMWindowOpenerPropertyInfo), '("orientation", DOMDOMWindowOrientationPropertyInfo), '("outerHeight", DOMDOMWindowOuterHeightPropertyInfo), '("outerWidth", DOMDOMWindowOuterWidthPropertyInfo), '("pageXOffset", DOMDOMWindowPageXOffsetPropertyInfo), '("pageYOffset", DOMDOMWindowPageYOffsetPropertyInfo), '("parent", DOMDOMWindowParentPropertyInfo), '("screenLeft", DOMDOMWindowScreenLeftPropertyInfo), '("screenTop", DOMDOMWindowScreenTopPropertyInfo), '("screenX", DOMDOMWindowScreenXPropertyInfo), '("screenY", DOMDOMWindowScreenYPropertyInfo), '("scrollX", DOMDOMWindowScrollXPropertyInfo), '("scrollY", DOMDOMWindowScrollYPropertyInfo), '("self", DOMDOMWindowSelfPropertyInfo), '("status", DOMDOMWindowStatusPropertyInfo), '("top", DOMDOMWindowTopPropertyInfo), '("window", DOMDOMWindowWindowPropertyInfo)] :: [(Symbol, *)])

dOMDOMWindowClosed :: AttrLabelProxy "closed"
dOMDOMWindowClosed = AttrLabelProxy

dOMDOMWindowDefaultStatus :: AttrLabelProxy "defaultStatus"
dOMDOMWindowDefaultStatus = AttrLabelProxy

dOMDOMWindowDevicePixelRatio :: AttrLabelProxy "devicePixelRatio"
dOMDOMWindowDevicePixelRatio = AttrLabelProxy

dOMDOMWindowDocument :: AttrLabelProxy "document"
dOMDOMWindowDocument = AttrLabelProxy

dOMDOMWindowFrameElement :: AttrLabelProxy "frameElement"
dOMDOMWindowFrameElement = AttrLabelProxy

dOMDOMWindowFrames :: AttrLabelProxy "frames"
dOMDOMWindowFrames = AttrLabelProxy

dOMDOMWindowInnerHeight :: AttrLabelProxy "innerHeight"
dOMDOMWindowInnerHeight = AttrLabelProxy

dOMDOMWindowInnerWidth :: AttrLabelProxy "innerWidth"
dOMDOMWindowInnerWidth = AttrLabelProxy

dOMDOMWindowLength :: AttrLabelProxy "length"
dOMDOMWindowLength = AttrLabelProxy

dOMDOMWindowName :: AttrLabelProxy "name"
dOMDOMWindowName = AttrLabelProxy

dOMDOMWindowOffscreenBuffering :: AttrLabelProxy "offscreenBuffering"
dOMDOMWindowOffscreenBuffering = AttrLabelProxy

dOMDOMWindowOpener :: AttrLabelProxy "opener"
dOMDOMWindowOpener = AttrLabelProxy

dOMDOMWindowOrientation :: AttrLabelProxy "orientation"
dOMDOMWindowOrientation = AttrLabelProxy

dOMDOMWindowOuterHeight :: AttrLabelProxy "outerHeight"
dOMDOMWindowOuterHeight = AttrLabelProxy

dOMDOMWindowOuterWidth :: AttrLabelProxy "outerWidth"
dOMDOMWindowOuterWidth = AttrLabelProxy

dOMDOMWindowPageXOffset :: AttrLabelProxy "pageXOffset"
dOMDOMWindowPageXOffset = AttrLabelProxy

dOMDOMWindowPageYOffset :: AttrLabelProxy "pageYOffset"
dOMDOMWindowPageYOffset = AttrLabelProxy

dOMDOMWindowParent :: AttrLabelProxy "parent"
dOMDOMWindowParent = AttrLabelProxy

dOMDOMWindowScreenLeft :: AttrLabelProxy "screenLeft"
dOMDOMWindowScreenLeft = AttrLabelProxy

dOMDOMWindowScreenTop :: AttrLabelProxy "screenTop"
dOMDOMWindowScreenTop = AttrLabelProxy

dOMDOMWindowScreenX :: AttrLabelProxy "screenX"
dOMDOMWindowScreenX = AttrLabelProxy

dOMDOMWindowScreenY :: AttrLabelProxy "screenY"
dOMDOMWindowScreenY = AttrLabelProxy

dOMDOMWindowScrollX :: AttrLabelProxy "scrollX"
dOMDOMWindowScrollX = AttrLabelProxy

dOMDOMWindowScrollY :: AttrLabelProxy "scrollY"
dOMDOMWindowScrollY = AttrLabelProxy

dOMDOMWindowSelf :: AttrLabelProxy "self"
dOMDOMWindowSelf = AttrLabelProxy

dOMDOMWindowStatus :: AttrLabelProxy "status"
dOMDOMWindowStatus = AttrLabelProxy

dOMDOMWindowTop :: AttrLabelProxy "top"
dOMDOMWindowTop = AttrLabelProxy

dOMDOMWindowWindow :: AttrLabelProxy "window"
dOMDOMWindowWindow = AttrLabelProxy

type instance SignalList DOMDOMWindow = DOMDOMWindowSignalList
type DOMDOMWindowSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMDOMWindow::webkit_message_handlers_post_message
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMDOMWindow", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "handler", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "message", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_dom_window_webkit_message_handlers_post_message" webkit_dom_dom_window_webkit_message_handlers_post_message :: 
    Ptr DOMDOMWindow ->                     -- _obj : TInterface "WebKit2WebExtension" "DOMDOMWindow"
    CString ->                              -- handler : TBasicType TUTF8
    CString ->                              -- message : TBasicType TUTF8
    IO CInt


dOMDOMWindowWebkitMessageHandlersPostMessage ::
    (MonadIO m, DOMDOMWindowK a) =>
    a                                       -- _obj
    -> T.Text                               -- handler
    -> T.Text                               -- message
    -> m Bool                               -- result
dOMDOMWindowWebkitMessageHandlersPostMessage _obj handler message = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    handler' <- textToCString handler
    message' <- textToCString message
    result <- webkit_dom_dom_window_webkit_message_handlers_post_message _obj' handler' message'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem handler'
    freeMem message'
    return result'

data DOMDOMWindowWebkitMessageHandlersPostMessageMethodInfo
instance (signature ~ (T.Text -> T.Text -> m Bool), MonadIO m, DOMDOMWindowK a) => MethodInfo DOMDOMWindowWebkitMessageHandlersPostMessageMethodInfo a signature where
    overloadedMethod _ = dOMDOMWindowWebkitMessageHandlersPostMessage


