

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMDocumentFragment
    ( 

-- * Exported types
    DOMDocumentFragment(..)                 ,
    DOMDocumentFragmentK                    ,
    toDOMDocumentFragment                   ,
    noDOMDocumentFragment                   ,


 -- * Properties
-- ** ChildElementCount
    DOMDocumentFragmentChildElementCountPropertyInfo,
    dOMDocumentFragmentChildElementCount    ,
    getDOMDocumentFragmentChildElementCount ,


-- ** Children
    DOMDocumentFragmentChildrenPropertyInfo ,
    dOMDocumentFragmentChildren             ,
    getDOMDocumentFragmentChildren          ,


-- ** FirstElementChild
    DOMDocumentFragmentFirstElementChildPropertyInfo,
    dOMDocumentFragmentFirstElementChild    ,
    getDOMDocumentFragmentFirstElementChild ,


-- ** LastElementChild
    DOMDocumentFragmentLastElementChildPropertyInfo,
    dOMDocumentFragmentLastElementChild     ,
    getDOMDocumentFragmentLastElementChild  ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMDocumentFragment = DOMDocumentFragment (ForeignPtr DOMDocumentFragment)
foreign import ccall "webkit_dom_document_fragment_get_type"
    c_webkit_dom_document_fragment_get_type :: IO GType

type instance ParentTypes DOMDocumentFragment = DOMDocumentFragmentParentTypes
type DOMDocumentFragmentParentTypes = '[DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMDocumentFragment where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_document_fragment_get_type
    

class GObject o => DOMDocumentFragmentK o
instance (GObject o, IsDescendantOf DOMDocumentFragment o) => DOMDocumentFragmentK o

toDOMDocumentFragment :: DOMDocumentFragmentK o => o -> IO DOMDocumentFragment
toDOMDocumentFragment = unsafeCastTo DOMDocumentFragment

noDOMDocumentFragment :: Maybe DOMDocumentFragment
noDOMDocumentFragment = Nothing

type family ResolveDOMDocumentFragmentMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMDocumentFragmentMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMDocumentFragmentMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMDocumentFragmentMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMDocumentFragmentMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMDocumentFragmentMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMDocumentFragmentMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMDocumentFragmentMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMDocumentFragmentMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMDocumentFragmentMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMDocumentFragmentMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMDocumentFragmentMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMDocumentFragmentMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMDocumentFragmentMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMDocumentFragmentMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMDocumentFragmentMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMDocumentFragmentMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMDocumentFragmentMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMDocumentFragmentMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMDocumentFragmentMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMDocumentFragmentMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMDocumentFragmentMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMDocumentFragmentMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMDocumentFragmentMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMDocumentFragmentMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMDocumentFragmentMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMDocumentFragmentMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMDocumentFragmentMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMDocumentFragmentMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMDocumentFragmentMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMDocumentFragmentMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMDocumentFragmentMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMDocumentFragmentMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMDocumentFragmentMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMDocumentFragmentMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMDocumentFragmentMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMDocumentFragmentMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMDocumentFragmentMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMDocumentFragmentMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMDocumentFragmentMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMDocumentFragmentMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMDocumentFragmentMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMDocumentFragmentMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMDocumentFragmentMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMDocumentFragmentMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMDocumentFragmentMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMDocumentFragmentMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMDocumentFragmentMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMDocumentFragmentMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMDocumentFragmentMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMDocumentFragmentMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMDocumentFragmentMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMDocumentFragmentMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMDocumentFragmentMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMDocumentFragmentMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMDocumentFragmentMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMDocumentFragmentMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMDocumentFragmentMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMDocumentFragmentMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMDocumentFragmentMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMDocumentFragmentMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMDocumentFragmentMethod t DOMDocumentFragment, MethodInfo info DOMDocumentFragment p) => IsLabelProxy t (DOMDocumentFragment -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMDocumentFragmentMethod t DOMDocumentFragment, MethodInfo info DOMDocumentFragment p) => IsLabel t (DOMDocumentFragment -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "child-element-count"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDocumentFragmentChildElementCount :: (MonadIO m, DOMDocumentFragmentK o) => o -> m CULong
getDOMDocumentFragmentChildElementCount obj = liftIO $ getObjectPropertyULong obj "child-element-count"

data DOMDocumentFragmentChildElementCountPropertyInfo
instance AttrInfo DOMDocumentFragmentChildElementCountPropertyInfo where
    type AttrAllowedOps DOMDocumentFragmentChildElementCountPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMDocumentFragmentChildElementCountPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDocumentFragmentChildElementCountPropertyInfo = DOMDocumentFragmentK
    type AttrGetType DOMDocumentFragmentChildElementCountPropertyInfo = CULong
    type AttrLabel DOMDocumentFragmentChildElementCountPropertyInfo = "child-element-count"
    attrGet _ = getDOMDocumentFragmentChildElementCount
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "children"
   -- Type: TInterface "WebKit2WebExtension" "DOMHTMLCollection"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDocumentFragmentChildren :: (MonadIO m, DOMDocumentFragmentK o) => o -> m (Maybe DOMHTMLCollection)
getDOMDocumentFragmentChildren obj = liftIO $ getObjectPropertyObject obj "children" DOMHTMLCollection

data DOMDocumentFragmentChildrenPropertyInfo
instance AttrInfo DOMDocumentFragmentChildrenPropertyInfo where
    type AttrAllowedOps DOMDocumentFragmentChildrenPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDocumentFragmentChildrenPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDocumentFragmentChildrenPropertyInfo = DOMDocumentFragmentK
    type AttrGetType DOMDocumentFragmentChildrenPropertyInfo = (Maybe DOMHTMLCollection)
    type AttrLabel DOMDocumentFragmentChildrenPropertyInfo = "children"
    attrGet _ = getDOMDocumentFragmentChildren
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "first-element-child"
   -- Type: TInterface "WebKit2WebExtension" "DOMElement"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDocumentFragmentFirstElementChild :: (MonadIO m, DOMDocumentFragmentK o) => o -> m (Maybe DOMElement)
getDOMDocumentFragmentFirstElementChild obj = liftIO $ getObjectPropertyObject obj "first-element-child" DOMElement

data DOMDocumentFragmentFirstElementChildPropertyInfo
instance AttrInfo DOMDocumentFragmentFirstElementChildPropertyInfo where
    type AttrAllowedOps DOMDocumentFragmentFirstElementChildPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDocumentFragmentFirstElementChildPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDocumentFragmentFirstElementChildPropertyInfo = DOMDocumentFragmentK
    type AttrGetType DOMDocumentFragmentFirstElementChildPropertyInfo = (Maybe DOMElement)
    type AttrLabel DOMDocumentFragmentFirstElementChildPropertyInfo = "first-element-child"
    attrGet _ = getDOMDocumentFragmentFirstElementChild
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "last-element-child"
   -- Type: TInterface "WebKit2WebExtension" "DOMElement"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMDocumentFragmentLastElementChild :: (MonadIO m, DOMDocumentFragmentK o) => o -> m (Maybe DOMElement)
getDOMDocumentFragmentLastElementChild obj = liftIO $ getObjectPropertyObject obj "last-element-child" DOMElement

data DOMDocumentFragmentLastElementChildPropertyInfo
instance AttrInfo DOMDocumentFragmentLastElementChildPropertyInfo where
    type AttrAllowedOps DOMDocumentFragmentLastElementChildPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMDocumentFragmentLastElementChildPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMDocumentFragmentLastElementChildPropertyInfo = DOMDocumentFragmentK
    type AttrGetType DOMDocumentFragmentLastElementChildPropertyInfo = (Maybe DOMElement)
    type AttrLabel DOMDocumentFragmentLastElementChildPropertyInfo = "last-element-child"
    attrGet _ = getDOMDocumentFragmentLastElementChild
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList DOMDocumentFragment = DOMDocumentFragmentAttributeList
type DOMDocumentFragmentAttributeList = ('[ '("baseUri", DOMNodeBaseUriPropertyInfo), '("childElementCount", DOMDocumentFragmentChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMDocumentFragmentChildrenPropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMDocumentFragmentFirstElementChildPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMDocumentFragmentLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo)] :: [(Symbol, *)])

dOMDocumentFragmentChildElementCount :: AttrLabelProxy "childElementCount"
dOMDocumentFragmentChildElementCount = AttrLabelProxy

dOMDocumentFragmentChildren :: AttrLabelProxy "children"
dOMDocumentFragmentChildren = AttrLabelProxy

dOMDocumentFragmentFirstElementChild :: AttrLabelProxy "firstElementChild"
dOMDocumentFragmentFirstElementChild = AttrLabelProxy

dOMDocumentFragmentLastElementChild :: AttrLabelProxy "lastElementChild"
dOMDocumentFragmentLastElementChild = AttrLabelProxy

type instance SignalList DOMDocumentFragment = DOMDocumentFragmentSignalList
type DOMDocumentFragmentSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])


