

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLButtonElement
    ( 

-- * Exported types
    DOMHTMLButtonElement(..)                ,
    DOMHTMLButtonElementK                   ,
    toDOMHTMLButtonElement                  ,
    noDOMHTMLButtonElement                  ,


 -- * Methods
-- ** dOMHTMLButtonElementGetAutofocus
    DOMHTMLButtonElementGetAutofocusMethodInfo,
    dOMHTMLButtonElementGetAutofocus        ,


-- ** dOMHTMLButtonElementGetButtonType
    DOMHTMLButtonElementGetButtonTypeMethodInfo,
    dOMHTMLButtonElementGetButtonType       ,


-- ** dOMHTMLButtonElementGetDisabled
    DOMHTMLButtonElementGetDisabledMethodInfo,
    dOMHTMLButtonElementGetDisabled         ,


-- ** dOMHTMLButtonElementGetForm
    DOMHTMLButtonElementGetFormMethodInfo   ,
    dOMHTMLButtonElementGetForm             ,


-- ** dOMHTMLButtonElementGetName
    DOMHTMLButtonElementGetNameMethodInfo   ,
    dOMHTMLButtonElementGetName             ,


-- ** dOMHTMLButtonElementGetValue
    DOMHTMLButtonElementGetValueMethodInfo  ,
    dOMHTMLButtonElementGetValue            ,


-- ** dOMHTMLButtonElementGetWillValidate
    DOMHTMLButtonElementGetWillValidateMethodInfo,
    dOMHTMLButtonElementGetWillValidate     ,


-- ** dOMHTMLButtonElementSetAutofocus
    DOMHTMLButtonElementSetAutofocusMethodInfo,
    dOMHTMLButtonElementSetAutofocus        ,


-- ** dOMHTMLButtonElementSetButtonType
    DOMHTMLButtonElementSetButtonTypeMethodInfo,
    dOMHTMLButtonElementSetButtonType       ,


-- ** dOMHTMLButtonElementSetDisabled
    DOMHTMLButtonElementSetDisabledMethodInfo,
    dOMHTMLButtonElementSetDisabled         ,


-- ** dOMHTMLButtonElementSetName
    DOMHTMLButtonElementSetNameMethodInfo   ,
    dOMHTMLButtonElementSetName             ,


-- ** dOMHTMLButtonElementSetValue
    DOMHTMLButtonElementSetValueMethodInfo  ,
    dOMHTMLButtonElementSetValue            ,




 -- * Properties
-- ** Autofocus
    DOMHTMLButtonElementAutofocusPropertyInfo,
    constructDOMHTMLButtonElementAutofocus  ,
    dOMHTMLButtonElementAutofocus           ,
    getDOMHTMLButtonElementAutofocus        ,
    setDOMHTMLButtonElementAutofocus        ,


-- ** Disabled
    DOMHTMLButtonElementDisabledPropertyInfo,
    constructDOMHTMLButtonElementDisabled   ,
    dOMHTMLButtonElementDisabled            ,
    getDOMHTMLButtonElementDisabled         ,
    setDOMHTMLButtonElementDisabled         ,


-- ** Form
    DOMHTMLButtonElementFormPropertyInfo    ,
    dOMHTMLButtonElementForm                ,
    getDOMHTMLButtonElementForm             ,


-- ** FormAction
    DOMHTMLButtonElementFormActionPropertyInfo,
    clearDOMHTMLButtonElementFormAction     ,
    constructDOMHTMLButtonElementFormAction ,
    dOMHTMLButtonElementFormAction          ,
    getDOMHTMLButtonElementFormAction       ,
    setDOMHTMLButtonElementFormAction       ,


-- ** FormEnctype
    DOMHTMLButtonElementFormEnctypePropertyInfo,
    clearDOMHTMLButtonElementFormEnctype    ,
    constructDOMHTMLButtonElementFormEnctype,
    dOMHTMLButtonElementFormEnctype         ,
    getDOMHTMLButtonElementFormEnctype      ,
    setDOMHTMLButtonElementFormEnctype      ,


-- ** FormMethod
    DOMHTMLButtonElementFormMethodPropertyInfo,
    clearDOMHTMLButtonElementFormMethod     ,
    constructDOMHTMLButtonElementFormMethod ,
    dOMHTMLButtonElementFormMethod          ,
    getDOMHTMLButtonElementFormMethod       ,
    setDOMHTMLButtonElementFormMethod       ,


-- ** FormNoValidate
    DOMHTMLButtonElementFormNoValidatePropertyInfo,
    constructDOMHTMLButtonElementFormNoValidate,
    dOMHTMLButtonElementFormNoValidate      ,
    getDOMHTMLButtonElementFormNoValidate   ,
    setDOMHTMLButtonElementFormNoValidate   ,


-- ** FormTarget
    DOMHTMLButtonElementFormTargetPropertyInfo,
    clearDOMHTMLButtonElementFormTarget     ,
    constructDOMHTMLButtonElementFormTarget ,
    dOMHTMLButtonElementFormTarget          ,
    getDOMHTMLButtonElementFormTarget       ,
    setDOMHTMLButtonElementFormTarget       ,


-- ** Labels
    DOMHTMLButtonElementLabelsPropertyInfo  ,
    dOMHTMLButtonElementLabels              ,
    getDOMHTMLButtonElementLabels           ,


-- ** Name
    DOMHTMLButtonElementNamePropertyInfo    ,
    constructDOMHTMLButtonElementName       ,
    dOMHTMLButtonElementName                ,
    getDOMHTMLButtonElementName             ,
    setDOMHTMLButtonElementName             ,


-- ** Type
    DOMHTMLButtonElementTypePropertyInfo    ,
    clearDOMHTMLButtonElementType           ,
    constructDOMHTMLButtonElementType       ,
    dOMHTMLButtonElementType                ,
    getDOMHTMLButtonElementType             ,
    setDOMHTMLButtonElementType             ,


-- ** ValidationMessage
    DOMHTMLButtonElementValidationMessagePropertyInfo,
    dOMHTMLButtonElementValidationMessage   ,
    getDOMHTMLButtonElementValidationMessage,


-- ** Value
    DOMHTMLButtonElementValuePropertyInfo   ,
    constructDOMHTMLButtonElementValue      ,
    dOMHTMLButtonElementValue               ,
    getDOMHTMLButtonElementValue            ,
    setDOMHTMLButtonElementValue            ,


-- ** WillValidate
    DOMHTMLButtonElementWillValidatePropertyInfo,
    dOMHTMLButtonElementWillValidate        ,
    getDOMHTMLButtonElementWillValidate     ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLButtonElement = DOMHTMLButtonElement (ForeignPtr DOMHTMLButtonElement)
foreign import ccall "webkit_dom_html_button_element_get_type"
    c_webkit_dom_html_button_element_get_type :: IO GType

type instance ParentTypes DOMHTMLButtonElement = DOMHTMLButtonElementParentTypes
type DOMHTMLButtonElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLButtonElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_button_element_get_type
    

class GObject o => DOMHTMLButtonElementK o
instance (GObject o, IsDescendantOf DOMHTMLButtonElement o) => DOMHTMLButtonElementK o

toDOMHTMLButtonElement :: DOMHTMLButtonElementK o => o -> IO DOMHTMLButtonElement
toDOMHTMLButtonElement = unsafeCastTo DOMHTMLButtonElement

noDOMHTMLButtonElement :: Maybe DOMHTMLButtonElement
noDOMHTMLButtonElement = Nothing

type family ResolveDOMHTMLButtonElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLButtonElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLButtonElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLButtonElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLButtonElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLButtonElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLButtonElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLButtonElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLButtonElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLButtonElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLButtonElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLButtonElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLButtonElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLButtonElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLButtonElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLButtonElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLButtonElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLButtonElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLButtonElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLButtonElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLButtonElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLButtonElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLButtonElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLButtonElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLButtonElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLButtonElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLButtonElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLButtonElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLButtonElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLButtonElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLButtonElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLButtonElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLButtonElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLButtonElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLButtonElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLButtonElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLButtonElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLButtonElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLButtonElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLButtonElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLButtonElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLButtonElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLButtonElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLButtonElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLButtonElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLButtonElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLButtonElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLButtonElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLButtonElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLButtonElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLButtonElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLButtonElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLButtonElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLButtonElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLButtonElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLButtonElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLButtonElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLButtonElementMethod "getAutofocus" o = DOMHTMLButtonElementGetAutofocusMethodInfo
    ResolveDOMHTMLButtonElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLButtonElementMethod "getButtonType" o = DOMHTMLButtonElementGetButtonTypeMethodInfo
    ResolveDOMHTMLButtonElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLButtonElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLButtonElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLButtonElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLButtonElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLButtonElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLButtonElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLButtonElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLButtonElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLButtonElementMethod "getDisabled" o = DOMHTMLButtonElementGetDisabledMethodInfo
    ResolveDOMHTMLButtonElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLButtonElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLButtonElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLButtonElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLButtonElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLButtonElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLButtonElementMethod "getForm" o = DOMHTMLButtonElementGetFormMethodInfo
    ResolveDOMHTMLButtonElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLButtonElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLButtonElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLButtonElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLButtonElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLButtonElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLButtonElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "getName" o = DOMHTMLButtonElementGetNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLButtonElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLButtonElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLButtonElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLButtonElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLButtonElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLButtonElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLButtonElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLButtonElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLButtonElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLButtonElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLButtonElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLButtonElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLButtonElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLButtonElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLButtonElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLButtonElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLButtonElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLButtonElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLButtonElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLButtonElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLButtonElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLButtonElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLButtonElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLButtonElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLButtonElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLButtonElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLButtonElementMethod "getValue" o = DOMHTMLButtonElementGetValueMethodInfo
    ResolveDOMHTMLButtonElementMethod "getWillValidate" o = DOMHTMLButtonElementGetWillValidateMethodInfo
    ResolveDOMHTMLButtonElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLButtonElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLButtonElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLButtonElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLButtonElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLButtonElementMethod "setAutofocus" o = DOMHTMLButtonElementSetAutofocusMethodInfo
    ResolveDOMHTMLButtonElementMethod "setButtonType" o = DOMHTMLButtonElementSetButtonTypeMethodInfo
    ResolveDOMHTMLButtonElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLButtonElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLButtonElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLButtonElementMethod "setDisabled" o = DOMHTMLButtonElementSetDisabledMethodInfo
    ResolveDOMHTMLButtonElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLButtonElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLButtonElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLButtonElementMethod "setName" o = DOMHTMLButtonElementSetNameMethodInfo
    ResolveDOMHTMLButtonElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLButtonElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLButtonElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLButtonElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLButtonElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLButtonElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLButtonElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLButtonElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLButtonElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLButtonElementMethod "setValue" o = DOMHTMLButtonElementSetValueMethodInfo
    ResolveDOMHTMLButtonElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLButtonElementMethod t DOMHTMLButtonElement, MethodInfo info DOMHTMLButtonElement p) => IsLabelProxy t (DOMHTMLButtonElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLButtonElementMethod t DOMHTMLButtonElement, MethodInfo info DOMHTMLButtonElement p) => IsLabel t (DOMHTMLButtonElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "autofocus"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLButtonElementAutofocus :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m Bool
getDOMHTMLButtonElementAutofocus obj = liftIO $ getObjectPropertyBool obj "autofocus"

setDOMHTMLButtonElementAutofocus :: (MonadIO m, DOMHTMLButtonElementK o) => o -> Bool -> m ()
setDOMHTMLButtonElementAutofocus obj val = liftIO $ setObjectPropertyBool obj "autofocus" val

constructDOMHTMLButtonElementAutofocus :: Bool -> IO ([Char], GValue)
constructDOMHTMLButtonElementAutofocus val = constructObjectPropertyBool "autofocus" val

data DOMHTMLButtonElementAutofocusPropertyInfo
instance AttrInfo DOMHTMLButtonElementAutofocusPropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementAutofocusPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLButtonElementAutofocusPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLButtonElementAutofocusPropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementAutofocusPropertyInfo = Bool
    type AttrLabel DOMHTMLButtonElementAutofocusPropertyInfo = "autofocus"
    attrGet _ = getDOMHTMLButtonElementAutofocus
    attrSet _ = setDOMHTMLButtonElementAutofocus
    attrConstruct _ = constructDOMHTMLButtonElementAutofocus
    attrClear _ = undefined

-- VVV Prop "disabled"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLButtonElementDisabled :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m Bool
getDOMHTMLButtonElementDisabled obj = liftIO $ getObjectPropertyBool obj "disabled"

setDOMHTMLButtonElementDisabled :: (MonadIO m, DOMHTMLButtonElementK o) => o -> Bool -> m ()
setDOMHTMLButtonElementDisabled obj val = liftIO $ setObjectPropertyBool obj "disabled" val

constructDOMHTMLButtonElementDisabled :: Bool -> IO ([Char], GValue)
constructDOMHTMLButtonElementDisabled val = constructObjectPropertyBool "disabled" val

data DOMHTMLButtonElementDisabledPropertyInfo
instance AttrInfo DOMHTMLButtonElementDisabledPropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementDisabledPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLButtonElementDisabledPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLButtonElementDisabledPropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementDisabledPropertyInfo = Bool
    type AttrLabel DOMHTMLButtonElementDisabledPropertyInfo = "disabled"
    attrGet _ = getDOMHTMLButtonElementDisabled
    attrSet _ = setDOMHTMLButtonElementDisabled
    attrConstruct _ = constructDOMHTMLButtonElementDisabled
    attrClear _ = undefined

-- VVV Prop "form"
   -- Type: TInterface "WebKit2WebExtension" "DOMHTMLFormElement"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLButtonElementForm :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m DOMHTMLFormElement
getDOMHTMLButtonElementForm obj = liftIO $ checkUnexpectedNothing "getDOMHTMLButtonElementForm" $ getObjectPropertyObject obj "form" DOMHTMLFormElement

data DOMHTMLButtonElementFormPropertyInfo
instance AttrInfo DOMHTMLButtonElementFormPropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementFormPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLButtonElementFormPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLButtonElementFormPropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementFormPropertyInfo = DOMHTMLFormElement
    type AttrLabel DOMHTMLButtonElementFormPropertyInfo = "form"
    attrGet _ = getDOMHTMLButtonElementForm
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "form-action"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLButtonElementFormAction :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe T.Text)
getDOMHTMLButtonElementFormAction obj = liftIO $ getObjectPropertyString obj "form-action"

setDOMHTMLButtonElementFormAction :: (MonadIO m, DOMHTMLButtonElementK o) => o -> T.Text -> m ()
setDOMHTMLButtonElementFormAction obj val = liftIO $ setObjectPropertyString obj "form-action" (Just val)

constructDOMHTMLButtonElementFormAction :: T.Text -> IO ([Char], GValue)
constructDOMHTMLButtonElementFormAction val = constructObjectPropertyString "form-action" (Just val)

clearDOMHTMLButtonElementFormAction :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m ()
clearDOMHTMLButtonElementFormAction obj = liftIO $ setObjectPropertyString obj "form-action" (Nothing :: Maybe T.Text)

data DOMHTMLButtonElementFormActionPropertyInfo
instance AttrInfo DOMHTMLButtonElementFormActionPropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementFormActionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLButtonElementFormActionPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLButtonElementFormActionPropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementFormActionPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLButtonElementFormActionPropertyInfo = "form-action"
    attrGet _ = getDOMHTMLButtonElementFormAction
    attrSet _ = setDOMHTMLButtonElementFormAction
    attrConstruct _ = constructDOMHTMLButtonElementFormAction
    attrClear _ = clearDOMHTMLButtonElementFormAction

-- VVV Prop "form-enctype"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLButtonElementFormEnctype :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe T.Text)
getDOMHTMLButtonElementFormEnctype obj = liftIO $ getObjectPropertyString obj "form-enctype"

setDOMHTMLButtonElementFormEnctype :: (MonadIO m, DOMHTMLButtonElementK o) => o -> T.Text -> m ()
setDOMHTMLButtonElementFormEnctype obj val = liftIO $ setObjectPropertyString obj "form-enctype" (Just val)

constructDOMHTMLButtonElementFormEnctype :: T.Text -> IO ([Char], GValue)
constructDOMHTMLButtonElementFormEnctype val = constructObjectPropertyString "form-enctype" (Just val)

clearDOMHTMLButtonElementFormEnctype :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m ()
clearDOMHTMLButtonElementFormEnctype obj = liftIO $ setObjectPropertyString obj "form-enctype" (Nothing :: Maybe T.Text)

data DOMHTMLButtonElementFormEnctypePropertyInfo
instance AttrInfo DOMHTMLButtonElementFormEnctypePropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementFormEnctypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLButtonElementFormEnctypePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLButtonElementFormEnctypePropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementFormEnctypePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLButtonElementFormEnctypePropertyInfo = "form-enctype"
    attrGet _ = getDOMHTMLButtonElementFormEnctype
    attrSet _ = setDOMHTMLButtonElementFormEnctype
    attrConstruct _ = constructDOMHTMLButtonElementFormEnctype
    attrClear _ = clearDOMHTMLButtonElementFormEnctype

-- VVV Prop "form-method"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLButtonElementFormMethod :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe T.Text)
getDOMHTMLButtonElementFormMethod obj = liftIO $ getObjectPropertyString obj "form-method"

setDOMHTMLButtonElementFormMethod :: (MonadIO m, DOMHTMLButtonElementK o) => o -> T.Text -> m ()
setDOMHTMLButtonElementFormMethod obj val = liftIO $ setObjectPropertyString obj "form-method" (Just val)

constructDOMHTMLButtonElementFormMethod :: T.Text -> IO ([Char], GValue)
constructDOMHTMLButtonElementFormMethod val = constructObjectPropertyString "form-method" (Just val)

clearDOMHTMLButtonElementFormMethod :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m ()
clearDOMHTMLButtonElementFormMethod obj = liftIO $ setObjectPropertyString obj "form-method" (Nothing :: Maybe T.Text)

data DOMHTMLButtonElementFormMethodPropertyInfo
instance AttrInfo DOMHTMLButtonElementFormMethodPropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementFormMethodPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLButtonElementFormMethodPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLButtonElementFormMethodPropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementFormMethodPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLButtonElementFormMethodPropertyInfo = "form-method"
    attrGet _ = getDOMHTMLButtonElementFormMethod
    attrSet _ = setDOMHTMLButtonElementFormMethod
    attrConstruct _ = constructDOMHTMLButtonElementFormMethod
    attrClear _ = clearDOMHTMLButtonElementFormMethod

-- VVV Prop "form-no-validate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLButtonElementFormNoValidate :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m Bool
getDOMHTMLButtonElementFormNoValidate obj = liftIO $ getObjectPropertyBool obj "form-no-validate"

setDOMHTMLButtonElementFormNoValidate :: (MonadIO m, DOMHTMLButtonElementK o) => o -> Bool -> m ()
setDOMHTMLButtonElementFormNoValidate obj val = liftIO $ setObjectPropertyBool obj "form-no-validate" val

constructDOMHTMLButtonElementFormNoValidate :: Bool -> IO ([Char], GValue)
constructDOMHTMLButtonElementFormNoValidate val = constructObjectPropertyBool "form-no-validate" val

data DOMHTMLButtonElementFormNoValidatePropertyInfo
instance AttrInfo DOMHTMLButtonElementFormNoValidatePropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementFormNoValidatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLButtonElementFormNoValidatePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLButtonElementFormNoValidatePropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementFormNoValidatePropertyInfo = Bool
    type AttrLabel DOMHTMLButtonElementFormNoValidatePropertyInfo = "form-no-validate"
    attrGet _ = getDOMHTMLButtonElementFormNoValidate
    attrSet _ = setDOMHTMLButtonElementFormNoValidate
    attrConstruct _ = constructDOMHTMLButtonElementFormNoValidate
    attrClear _ = undefined

-- VVV Prop "form-target"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLButtonElementFormTarget :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe T.Text)
getDOMHTMLButtonElementFormTarget obj = liftIO $ getObjectPropertyString obj "form-target"

setDOMHTMLButtonElementFormTarget :: (MonadIO m, DOMHTMLButtonElementK o) => o -> T.Text -> m ()
setDOMHTMLButtonElementFormTarget obj val = liftIO $ setObjectPropertyString obj "form-target" (Just val)

constructDOMHTMLButtonElementFormTarget :: T.Text -> IO ([Char], GValue)
constructDOMHTMLButtonElementFormTarget val = constructObjectPropertyString "form-target" (Just val)

clearDOMHTMLButtonElementFormTarget :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m ()
clearDOMHTMLButtonElementFormTarget obj = liftIO $ setObjectPropertyString obj "form-target" (Nothing :: Maybe T.Text)

data DOMHTMLButtonElementFormTargetPropertyInfo
instance AttrInfo DOMHTMLButtonElementFormTargetPropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementFormTargetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLButtonElementFormTargetPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLButtonElementFormTargetPropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementFormTargetPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLButtonElementFormTargetPropertyInfo = "form-target"
    attrGet _ = getDOMHTMLButtonElementFormTarget
    attrSet _ = setDOMHTMLButtonElementFormTarget
    attrConstruct _ = constructDOMHTMLButtonElementFormTarget
    attrClear _ = clearDOMHTMLButtonElementFormTarget

-- VVV Prop "labels"
   -- Type: TInterface "WebKit2WebExtension" "DOMNodeList"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLButtonElementLabels :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe DOMNodeList)
getDOMHTMLButtonElementLabels obj = liftIO $ getObjectPropertyObject obj "labels" DOMNodeList

data DOMHTMLButtonElementLabelsPropertyInfo
instance AttrInfo DOMHTMLButtonElementLabelsPropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementLabelsPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLButtonElementLabelsPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLButtonElementLabelsPropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementLabelsPropertyInfo = (Maybe DOMNodeList)
    type AttrLabel DOMHTMLButtonElementLabelsPropertyInfo = "labels"
    attrGet _ = getDOMHTMLButtonElementLabels
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLButtonElementName :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe T.Text)
getDOMHTMLButtonElementName obj = liftIO $ getObjectPropertyString obj "name"

setDOMHTMLButtonElementName :: (MonadIO m, DOMHTMLButtonElementK o) => o -> T.Text -> m ()
setDOMHTMLButtonElementName obj val = liftIO $ setObjectPropertyString obj "name" (Just val)

constructDOMHTMLButtonElementName :: T.Text -> IO ([Char], GValue)
constructDOMHTMLButtonElementName val = constructObjectPropertyString "name" (Just val)

data DOMHTMLButtonElementNamePropertyInfo
instance AttrInfo DOMHTMLButtonElementNamePropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLButtonElementNamePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLButtonElementNamePropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementNamePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLButtonElementNamePropertyInfo = "name"
    attrGet _ = getDOMHTMLButtonElementName
    attrSet _ = setDOMHTMLButtonElementName
    attrConstruct _ = constructDOMHTMLButtonElementName
    attrClear _ = undefined

-- VVV Prop "type"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLButtonElementType :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe T.Text)
getDOMHTMLButtonElementType obj = liftIO $ getObjectPropertyString obj "type"

setDOMHTMLButtonElementType :: (MonadIO m, DOMHTMLButtonElementK o) => o -> T.Text -> m ()
setDOMHTMLButtonElementType obj val = liftIO $ setObjectPropertyString obj "type" (Just val)

constructDOMHTMLButtonElementType :: T.Text -> IO ([Char], GValue)
constructDOMHTMLButtonElementType val = constructObjectPropertyString "type" (Just val)

clearDOMHTMLButtonElementType :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m ()
clearDOMHTMLButtonElementType obj = liftIO $ setObjectPropertyString obj "type" (Nothing :: Maybe T.Text)

data DOMHTMLButtonElementTypePropertyInfo
instance AttrInfo DOMHTMLButtonElementTypePropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLButtonElementTypePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLButtonElementTypePropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementTypePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLButtonElementTypePropertyInfo = "type"
    attrGet _ = getDOMHTMLButtonElementType
    attrSet _ = setDOMHTMLButtonElementType
    attrConstruct _ = constructDOMHTMLButtonElementType
    attrClear _ = clearDOMHTMLButtonElementType

-- VVV Prop "validation-message"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLButtonElementValidationMessage :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe T.Text)
getDOMHTMLButtonElementValidationMessage obj = liftIO $ getObjectPropertyString obj "validation-message"

data DOMHTMLButtonElementValidationMessagePropertyInfo
instance AttrInfo DOMHTMLButtonElementValidationMessagePropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementValidationMessagePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLButtonElementValidationMessagePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLButtonElementValidationMessagePropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementValidationMessagePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLButtonElementValidationMessagePropertyInfo = "validation-message"
    attrGet _ = getDOMHTMLButtonElementValidationMessage
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "value"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLButtonElementValue :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m (Maybe T.Text)
getDOMHTMLButtonElementValue obj = liftIO $ getObjectPropertyString obj "value"

setDOMHTMLButtonElementValue :: (MonadIO m, DOMHTMLButtonElementK o) => o -> T.Text -> m ()
setDOMHTMLButtonElementValue obj val = liftIO $ setObjectPropertyString obj "value" (Just val)

constructDOMHTMLButtonElementValue :: T.Text -> IO ([Char], GValue)
constructDOMHTMLButtonElementValue val = constructObjectPropertyString "value" (Just val)

data DOMHTMLButtonElementValuePropertyInfo
instance AttrInfo DOMHTMLButtonElementValuePropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLButtonElementValuePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLButtonElementValuePropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementValuePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLButtonElementValuePropertyInfo = "value"
    attrGet _ = getDOMHTMLButtonElementValue
    attrSet _ = setDOMHTMLButtonElementValue
    attrConstruct _ = constructDOMHTMLButtonElementValue
    attrClear _ = undefined

-- VVV Prop "will-validate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLButtonElementWillValidate :: (MonadIO m, DOMHTMLButtonElementK o) => o -> m Bool
getDOMHTMLButtonElementWillValidate obj = liftIO $ getObjectPropertyBool obj "will-validate"

data DOMHTMLButtonElementWillValidatePropertyInfo
instance AttrInfo DOMHTMLButtonElementWillValidatePropertyInfo where
    type AttrAllowedOps DOMHTMLButtonElementWillValidatePropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLButtonElementWillValidatePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLButtonElementWillValidatePropertyInfo = DOMHTMLButtonElementK
    type AttrGetType DOMHTMLButtonElementWillValidatePropertyInfo = Bool
    type AttrLabel DOMHTMLButtonElementWillValidatePropertyInfo = "will-validate"
    attrGet _ = getDOMHTMLButtonElementWillValidate
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList DOMHTMLButtonElement = DOMHTMLButtonElementAttributeList
type DOMHTMLButtonElementAttributeList = ('[ '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("autofocus", DOMHTMLButtonElementAutofocusPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("disabled", DOMHTMLButtonElementDisabledPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("form", DOMHTMLButtonElementFormPropertyInfo), '("formAction", DOMHTMLButtonElementFormActionPropertyInfo), '("formEnctype", DOMHTMLButtonElementFormEnctypePropertyInfo), '("formMethod", DOMHTMLButtonElementFormMethodPropertyInfo), '("formNoValidate", DOMHTMLButtonElementFormNoValidatePropertyInfo), '("formTarget", DOMHTMLButtonElementFormTargetPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("id", DOMElementIdPropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("labels", DOMHTMLButtonElementLabelsPropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("name", DOMHTMLButtonElementNamePropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("type", DOMHTMLButtonElementTypePropertyInfo), '("validationMessage", DOMHTMLButtonElementValidationMessagePropertyInfo), '("value", DOMHTMLButtonElementValuePropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo), '("willValidate", DOMHTMLButtonElementWillValidatePropertyInfo)] :: [(Symbol, *)])

dOMHTMLButtonElementAutofocus :: AttrLabelProxy "autofocus"
dOMHTMLButtonElementAutofocus = AttrLabelProxy

dOMHTMLButtonElementDisabled :: AttrLabelProxy "disabled"
dOMHTMLButtonElementDisabled = AttrLabelProxy

dOMHTMLButtonElementForm :: AttrLabelProxy "form"
dOMHTMLButtonElementForm = AttrLabelProxy

dOMHTMLButtonElementFormAction :: AttrLabelProxy "formAction"
dOMHTMLButtonElementFormAction = AttrLabelProxy

dOMHTMLButtonElementFormEnctype :: AttrLabelProxy "formEnctype"
dOMHTMLButtonElementFormEnctype = AttrLabelProxy

dOMHTMLButtonElementFormMethod :: AttrLabelProxy "formMethod"
dOMHTMLButtonElementFormMethod = AttrLabelProxy

dOMHTMLButtonElementFormNoValidate :: AttrLabelProxy "formNoValidate"
dOMHTMLButtonElementFormNoValidate = AttrLabelProxy

dOMHTMLButtonElementFormTarget :: AttrLabelProxy "formTarget"
dOMHTMLButtonElementFormTarget = AttrLabelProxy

dOMHTMLButtonElementLabels :: AttrLabelProxy "labels"
dOMHTMLButtonElementLabels = AttrLabelProxy

dOMHTMLButtonElementName :: AttrLabelProxy "name"
dOMHTMLButtonElementName = AttrLabelProxy

dOMHTMLButtonElementType :: AttrLabelProxy "type"
dOMHTMLButtonElementType = AttrLabelProxy

dOMHTMLButtonElementValidationMessage :: AttrLabelProxy "validationMessage"
dOMHTMLButtonElementValidationMessage = AttrLabelProxy

dOMHTMLButtonElementValue :: AttrLabelProxy "value"
dOMHTMLButtonElementValue = AttrLabelProxy

dOMHTMLButtonElementWillValidate :: AttrLabelProxy "willValidate"
dOMHTMLButtonElementWillValidate = AttrLabelProxy

type instance SignalList DOMHTMLButtonElement = DOMHTMLButtonElementSignalList
type DOMHTMLButtonElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLButtonElement::get_autofocus
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_get_autofocus" webkit_dom_html_button_element_get_autofocus :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    IO CInt


dOMHTMLButtonElementGetAutofocus ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLButtonElementGetAutofocus _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_button_element_get_autofocus _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLButtonElementGetAutofocusMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementGetAutofocusMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementGetAutofocus

-- method DOMHTMLButtonElement::get_button_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_get_button_type" webkit_dom_html_button_element_get_button_type :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    IO CString


dOMHTMLButtonElementGetButtonType ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLButtonElementGetButtonType _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_button_element_get_button_type _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_button_element_get_button_type" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLButtonElementGetButtonTypeMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementGetButtonTypeMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementGetButtonType

-- method DOMHTMLButtonElement::get_disabled
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_get_disabled" webkit_dom_html_button_element_get_disabled :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    IO CInt


dOMHTMLButtonElementGetDisabled ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLButtonElementGetDisabled _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_button_element_get_disabled _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLButtonElementGetDisabledMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementGetDisabledMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementGetDisabled

-- method DOMHTMLButtonElement::get_form
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "DOMHTMLFormElement")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_get_form" webkit_dom_html_button_element_get_form :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    IO (Ptr DOMHTMLFormElement)


dOMHTMLButtonElementGetForm ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> m DOMHTMLFormElement                 -- result
dOMHTMLButtonElementGetForm _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_button_element_get_form _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_button_element_get_form" result
    result' <- (newObject DOMHTMLFormElement) result
    touchManagedPtr _obj
    return result'

data DOMHTMLButtonElementGetFormMethodInfo
instance (signature ~ (m DOMHTMLFormElement), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementGetFormMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementGetForm

-- method DOMHTMLButtonElement::get_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_get_name" webkit_dom_html_button_element_get_name :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    IO CString


dOMHTMLButtonElementGetName ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLButtonElementGetName _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_button_element_get_name _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_button_element_get_name" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLButtonElementGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementGetNameMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementGetName

-- method DOMHTMLButtonElement::get_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_get_value" webkit_dom_html_button_element_get_value :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    IO CString


dOMHTMLButtonElementGetValue ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLButtonElementGetValue _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_button_element_get_value _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_button_element_get_value" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLButtonElementGetValueMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementGetValueMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementGetValue

-- method DOMHTMLButtonElement::get_will_validate
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_get_will_validate" webkit_dom_html_button_element_get_will_validate :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    IO CInt


dOMHTMLButtonElementGetWillValidate ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLButtonElementGetWillValidate _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_button_element_get_will_validate _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLButtonElementGetWillValidateMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementGetWillValidateMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementGetWillValidate

-- method DOMHTMLButtonElement::set_autofocus
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_set_autofocus" webkit_dom_html_button_element_set_autofocus :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLButtonElementSetAutofocus ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLButtonElementSetAutofocus _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_button_element_set_autofocus _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLButtonElementSetAutofocusMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementSetAutofocusMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementSetAutofocus

-- method DOMHTMLButtonElement::set_button_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_set_button_type" webkit_dom_html_button_element_set_button_type :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLButtonElementSetButtonType ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLButtonElementSetButtonType _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_button_element_set_button_type _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLButtonElementSetButtonTypeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementSetButtonTypeMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementSetButtonType

-- method DOMHTMLButtonElement::set_disabled
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_set_disabled" webkit_dom_html_button_element_set_disabled :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLButtonElementSetDisabled ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLButtonElementSetDisabled _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_button_element_set_disabled _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLButtonElementSetDisabledMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementSetDisabledMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementSetDisabled

-- method DOMHTMLButtonElement::set_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_set_name" webkit_dom_html_button_element_set_name :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLButtonElementSetName ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLButtonElementSetName _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_button_element_set_name _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLButtonElementSetNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementSetNameMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementSetName

-- method DOMHTMLButtonElement::set_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLButtonElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_button_element_set_value" webkit_dom_html_button_element_set_value :: 
    Ptr DOMHTMLButtonElement ->             -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLButtonElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLButtonElementSetValue ::
    (MonadIO m, DOMHTMLButtonElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLButtonElementSetValue _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_button_element_set_value _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLButtonElementSetValueMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLButtonElementK a) => MethodInfo DOMHTMLButtonElementSetValueMethodInfo a signature where
    overloadedMethod _ = dOMHTMLButtonElementSetValue


