

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLFieldSetElement
    ( 

-- * Exported types
    DOMHTMLFieldSetElement(..)              ,
    DOMHTMLFieldSetElementK                 ,
    toDOMHTMLFieldSetElement                ,
    noDOMHTMLFieldSetElement                ,


 -- * Methods
-- ** dOMHTMLFieldSetElementGetForm
    DOMHTMLFieldSetElementGetFormMethodInfo ,
    dOMHTMLFieldSetElementGetForm           ,




 -- * Properties
-- ** Disabled
    DOMHTMLFieldSetElementDisabledPropertyInfo,
    constructDOMHTMLFieldSetElementDisabled ,
    dOMHTMLFieldSetElementDisabled          ,
    getDOMHTMLFieldSetElementDisabled       ,
    setDOMHTMLFieldSetElementDisabled       ,


-- ** Elements
    DOMHTMLFieldSetElementElementsPropertyInfo,
    dOMHTMLFieldSetElementElements          ,
    getDOMHTMLFieldSetElementElements       ,


-- ** Form
    DOMHTMLFieldSetElementFormPropertyInfo  ,
    dOMHTMLFieldSetElementForm              ,
    getDOMHTMLFieldSetElementForm           ,


-- ** Name
    DOMHTMLFieldSetElementNamePropertyInfo  ,
    clearDOMHTMLFieldSetElementName         ,
    constructDOMHTMLFieldSetElementName     ,
    dOMHTMLFieldSetElementName              ,
    getDOMHTMLFieldSetElementName           ,
    setDOMHTMLFieldSetElementName           ,


-- ** Type
    DOMHTMLFieldSetElementTypePropertyInfo  ,
    dOMHTMLFieldSetElementType              ,
    getDOMHTMLFieldSetElementType           ,


-- ** ValidationMessage
    DOMHTMLFieldSetElementValidationMessagePropertyInfo,
    dOMHTMLFieldSetElementValidationMessage ,
    getDOMHTMLFieldSetElementValidationMessage,


-- ** WillValidate
    DOMHTMLFieldSetElementWillValidatePropertyInfo,
    dOMHTMLFieldSetElementWillValidate      ,
    getDOMHTMLFieldSetElementWillValidate   ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLFieldSetElement = DOMHTMLFieldSetElement (ForeignPtr DOMHTMLFieldSetElement)
foreign import ccall "webkit_dom_html_field_set_element_get_type"
    c_webkit_dom_html_field_set_element_get_type :: IO GType

type instance ParentTypes DOMHTMLFieldSetElement = DOMHTMLFieldSetElementParentTypes
type DOMHTMLFieldSetElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLFieldSetElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_field_set_element_get_type
    

class GObject o => DOMHTMLFieldSetElementK o
instance (GObject o, IsDescendantOf DOMHTMLFieldSetElement o) => DOMHTMLFieldSetElementK o

toDOMHTMLFieldSetElement :: DOMHTMLFieldSetElementK o => o -> IO DOMHTMLFieldSetElement
toDOMHTMLFieldSetElement = unsafeCastTo DOMHTMLFieldSetElement

noDOMHTMLFieldSetElement :: Maybe DOMHTMLFieldSetElement
noDOMHTMLFieldSetElement = Nothing

type family ResolveDOMHTMLFieldSetElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLFieldSetElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getForm" o = DOMHTMLFieldSetElementGetFormMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLFieldSetElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLFieldSetElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLFieldSetElementMethod t DOMHTMLFieldSetElement, MethodInfo info DOMHTMLFieldSetElement p) => IsLabelProxy t (DOMHTMLFieldSetElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLFieldSetElementMethod t DOMHTMLFieldSetElement, MethodInfo info DOMHTMLFieldSetElement p) => IsLabel t (DOMHTMLFieldSetElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "disabled"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLFieldSetElementDisabled :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> m Bool
getDOMHTMLFieldSetElementDisabled obj = liftIO $ getObjectPropertyBool obj "disabled"

setDOMHTMLFieldSetElementDisabled :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> Bool -> m ()
setDOMHTMLFieldSetElementDisabled obj val = liftIO $ setObjectPropertyBool obj "disabled" val

constructDOMHTMLFieldSetElementDisabled :: Bool -> IO ([Char], GValue)
constructDOMHTMLFieldSetElementDisabled val = constructObjectPropertyBool "disabled" val

data DOMHTMLFieldSetElementDisabledPropertyInfo
instance AttrInfo DOMHTMLFieldSetElementDisabledPropertyInfo where
    type AttrAllowedOps DOMHTMLFieldSetElementDisabledPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLFieldSetElementDisabledPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLFieldSetElementDisabledPropertyInfo = DOMHTMLFieldSetElementK
    type AttrGetType DOMHTMLFieldSetElementDisabledPropertyInfo = Bool
    type AttrLabel DOMHTMLFieldSetElementDisabledPropertyInfo = "disabled"
    attrGet _ = getDOMHTMLFieldSetElementDisabled
    attrSet _ = setDOMHTMLFieldSetElementDisabled
    attrConstruct _ = constructDOMHTMLFieldSetElementDisabled
    attrClear _ = undefined

-- VVV Prop "elements"
   -- Type: TInterface "WebKit2WebExtension" "DOMHTMLCollection"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLFieldSetElementElements :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> m (Maybe DOMHTMLCollection)
getDOMHTMLFieldSetElementElements obj = liftIO $ getObjectPropertyObject obj "elements" DOMHTMLCollection

data DOMHTMLFieldSetElementElementsPropertyInfo
instance AttrInfo DOMHTMLFieldSetElementElementsPropertyInfo where
    type AttrAllowedOps DOMHTMLFieldSetElementElementsPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLFieldSetElementElementsPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLFieldSetElementElementsPropertyInfo = DOMHTMLFieldSetElementK
    type AttrGetType DOMHTMLFieldSetElementElementsPropertyInfo = (Maybe DOMHTMLCollection)
    type AttrLabel DOMHTMLFieldSetElementElementsPropertyInfo = "elements"
    attrGet _ = getDOMHTMLFieldSetElementElements
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "form"
   -- Type: TInterface "WebKit2WebExtension" "DOMHTMLFormElement"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLFieldSetElementForm :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> m DOMHTMLFormElement
getDOMHTMLFieldSetElementForm obj = liftIO $ checkUnexpectedNothing "getDOMHTMLFieldSetElementForm" $ getObjectPropertyObject obj "form" DOMHTMLFormElement

data DOMHTMLFieldSetElementFormPropertyInfo
instance AttrInfo DOMHTMLFieldSetElementFormPropertyInfo where
    type AttrAllowedOps DOMHTMLFieldSetElementFormPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLFieldSetElementFormPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLFieldSetElementFormPropertyInfo = DOMHTMLFieldSetElementK
    type AttrGetType DOMHTMLFieldSetElementFormPropertyInfo = DOMHTMLFormElement
    type AttrLabel DOMHTMLFieldSetElementFormPropertyInfo = "form"
    attrGet _ = getDOMHTMLFieldSetElementForm
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLFieldSetElementName :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> m (Maybe T.Text)
getDOMHTMLFieldSetElementName obj = liftIO $ getObjectPropertyString obj "name"

setDOMHTMLFieldSetElementName :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> T.Text -> m ()
setDOMHTMLFieldSetElementName obj val = liftIO $ setObjectPropertyString obj "name" (Just val)

constructDOMHTMLFieldSetElementName :: T.Text -> IO ([Char], GValue)
constructDOMHTMLFieldSetElementName val = constructObjectPropertyString "name" (Just val)

clearDOMHTMLFieldSetElementName :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> m ()
clearDOMHTMLFieldSetElementName obj = liftIO $ setObjectPropertyString obj "name" (Nothing :: Maybe T.Text)

data DOMHTMLFieldSetElementNamePropertyInfo
instance AttrInfo DOMHTMLFieldSetElementNamePropertyInfo where
    type AttrAllowedOps DOMHTMLFieldSetElementNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLFieldSetElementNamePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLFieldSetElementNamePropertyInfo = DOMHTMLFieldSetElementK
    type AttrGetType DOMHTMLFieldSetElementNamePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLFieldSetElementNamePropertyInfo = "name"
    attrGet _ = getDOMHTMLFieldSetElementName
    attrSet _ = setDOMHTMLFieldSetElementName
    attrConstruct _ = constructDOMHTMLFieldSetElementName
    attrClear _ = clearDOMHTMLFieldSetElementName

-- VVV Prop "type"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLFieldSetElementType :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> m (Maybe T.Text)
getDOMHTMLFieldSetElementType obj = liftIO $ getObjectPropertyString obj "type"

data DOMHTMLFieldSetElementTypePropertyInfo
instance AttrInfo DOMHTMLFieldSetElementTypePropertyInfo where
    type AttrAllowedOps DOMHTMLFieldSetElementTypePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLFieldSetElementTypePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLFieldSetElementTypePropertyInfo = DOMHTMLFieldSetElementK
    type AttrGetType DOMHTMLFieldSetElementTypePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLFieldSetElementTypePropertyInfo = "type"
    attrGet _ = getDOMHTMLFieldSetElementType
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "validation-message"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLFieldSetElementValidationMessage :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> m (Maybe T.Text)
getDOMHTMLFieldSetElementValidationMessage obj = liftIO $ getObjectPropertyString obj "validation-message"

data DOMHTMLFieldSetElementValidationMessagePropertyInfo
instance AttrInfo DOMHTMLFieldSetElementValidationMessagePropertyInfo where
    type AttrAllowedOps DOMHTMLFieldSetElementValidationMessagePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLFieldSetElementValidationMessagePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLFieldSetElementValidationMessagePropertyInfo = DOMHTMLFieldSetElementK
    type AttrGetType DOMHTMLFieldSetElementValidationMessagePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLFieldSetElementValidationMessagePropertyInfo = "validation-message"
    attrGet _ = getDOMHTMLFieldSetElementValidationMessage
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "will-validate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLFieldSetElementWillValidate :: (MonadIO m, DOMHTMLFieldSetElementK o) => o -> m Bool
getDOMHTMLFieldSetElementWillValidate obj = liftIO $ getObjectPropertyBool obj "will-validate"

data DOMHTMLFieldSetElementWillValidatePropertyInfo
instance AttrInfo DOMHTMLFieldSetElementWillValidatePropertyInfo where
    type AttrAllowedOps DOMHTMLFieldSetElementWillValidatePropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLFieldSetElementWillValidatePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLFieldSetElementWillValidatePropertyInfo = DOMHTMLFieldSetElementK
    type AttrGetType DOMHTMLFieldSetElementWillValidatePropertyInfo = Bool
    type AttrLabel DOMHTMLFieldSetElementWillValidatePropertyInfo = "will-validate"
    attrGet _ = getDOMHTMLFieldSetElementWillValidate
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList DOMHTMLFieldSetElement = DOMHTMLFieldSetElementAttributeList
type DOMHTMLFieldSetElementAttributeList = ('[ '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("disabled", DOMHTMLFieldSetElementDisabledPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("elements", DOMHTMLFieldSetElementElementsPropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("form", DOMHTMLFieldSetElementFormPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("id", DOMElementIdPropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("name", DOMHTMLFieldSetElementNamePropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("type", DOMHTMLFieldSetElementTypePropertyInfo), '("validationMessage", DOMHTMLFieldSetElementValidationMessagePropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo), '("willValidate", DOMHTMLFieldSetElementWillValidatePropertyInfo)] :: [(Symbol, *)])

dOMHTMLFieldSetElementDisabled :: AttrLabelProxy "disabled"
dOMHTMLFieldSetElementDisabled = AttrLabelProxy

dOMHTMLFieldSetElementElements :: AttrLabelProxy "elements"
dOMHTMLFieldSetElementElements = AttrLabelProxy

dOMHTMLFieldSetElementForm :: AttrLabelProxy "form"
dOMHTMLFieldSetElementForm = AttrLabelProxy

dOMHTMLFieldSetElementName :: AttrLabelProxy "name"
dOMHTMLFieldSetElementName = AttrLabelProxy

dOMHTMLFieldSetElementType :: AttrLabelProxy "type"
dOMHTMLFieldSetElementType = AttrLabelProxy

dOMHTMLFieldSetElementValidationMessage :: AttrLabelProxy "validationMessage"
dOMHTMLFieldSetElementValidationMessage = AttrLabelProxy

dOMHTMLFieldSetElementWillValidate :: AttrLabelProxy "willValidate"
dOMHTMLFieldSetElementWillValidate = AttrLabelProxy

type instance SignalList DOMHTMLFieldSetElement = DOMHTMLFieldSetElementSignalList
type DOMHTMLFieldSetElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLFieldSetElement::get_form
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLFieldSetElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "DOMHTMLFormElement")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_field_set_element_get_form" webkit_dom_html_field_set_element_get_form :: 
    Ptr DOMHTMLFieldSetElement ->           -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLFieldSetElement"
    IO (Ptr DOMHTMLFormElement)


dOMHTMLFieldSetElementGetForm ::
    (MonadIO m, DOMHTMLFieldSetElementK a) =>
    a                                       -- _obj
    -> m DOMHTMLFormElement                 -- result
dOMHTMLFieldSetElementGetForm _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_field_set_element_get_form _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_field_set_element_get_form" result
    result' <- (newObject DOMHTMLFormElement) result
    touchManagedPtr _obj
    return result'

data DOMHTMLFieldSetElementGetFormMethodInfo
instance (signature ~ (m DOMHTMLFormElement), MonadIO m, DOMHTMLFieldSetElementK a) => MethodInfo DOMHTMLFieldSetElementGetFormMethodInfo a signature where
    overloadedMethod _ = dOMHTMLFieldSetElementGetForm


