

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLHtmlElement
    ( 

-- * Exported types
    DOMHTMLHtmlElement(..)                  ,
    DOMHTMLHtmlElementK                     ,
    toDOMHTMLHtmlElement                    ,
    noDOMHTMLHtmlElement                    ,


 -- * Methods
-- ** dOMHTMLHtmlElementGetVersion
    DOMHTMLHtmlElementGetVersionMethodInfo  ,
    dOMHTMLHtmlElementGetVersion            ,


-- ** dOMHTMLHtmlElementSetVersion
    DOMHTMLHtmlElementSetVersionMethodInfo  ,
    dOMHTMLHtmlElementSetVersion            ,




 -- * Properties
-- ** Manifest
    DOMHTMLHtmlElementManifestPropertyInfo  ,
    clearDOMHTMLHtmlElementManifest         ,
    constructDOMHTMLHtmlElementManifest     ,
    dOMHTMLHtmlElementManifest              ,
    getDOMHTMLHtmlElementManifest           ,
    setDOMHTMLHtmlElementManifest           ,


-- ** Version
    DOMHTMLHtmlElementVersionPropertyInfo   ,
    constructDOMHTMLHtmlElementVersion      ,
    dOMHTMLHtmlElementVersion               ,
    getDOMHTMLHtmlElementVersion            ,
    setDOMHTMLHtmlElementVersion            ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLHtmlElement = DOMHTMLHtmlElement (ForeignPtr DOMHTMLHtmlElement)
foreign import ccall "webkit_dom_html_html_element_get_type"
    c_webkit_dom_html_html_element_get_type :: IO GType

type instance ParentTypes DOMHTMLHtmlElement = DOMHTMLHtmlElementParentTypes
type DOMHTMLHtmlElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLHtmlElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_html_element_get_type
    

class GObject o => DOMHTMLHtmlElementK o
instance (GObject o, IsDescendantOf DOMHTMLHtmlElement o) => DOMHTMLHtmlElementK o

toDOMHTMLHtmlElement :: DOMHTMLHtmlElementK o => o -> IO DOMHTMLHtmlElement
toDOMHTMLHtmlElement = unsafeCastTo DOMHTMLHtmlElement

noDOMHTMLHtmlElement :: Maybe DOMHTMLHtmlElement
noDOMHTMLHtmlElement = Nothing

type family ResolveDOMHTMLHtmlElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLHtmlElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLHtmlElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLHtmlElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLHtmlElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLHtmlElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLHtmlElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLHtmlElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLHtmlElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLHtmlElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLHtmlElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLHtmlElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLHtmlElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLHtmlElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLHtmlElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLHtmlElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLHtmlElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLHtmlElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLHtmlElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLHtmlElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLHtmlElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLHtmlElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLHtmlElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLHtmlElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLHtmlElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLHtmlElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLHtmlElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLHtmlElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLHtmlElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLHtmlElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLHtmlElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLHtmlElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLHtmlElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLHtmlElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLHtmlElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLHtmlElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLHtmlElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLHtmlElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLHtmlElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLHtmlElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLHtmlElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLHtmlElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLHtmlElementMethod "getVersion" o = DOMHTMLHtmlElementGetVersionMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLHtmlElementMethod "setVersion" o = DOMHTMLHtmlElementSetVersionMethodInfo
    ResolveDOMHTMLHtmlElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLHtmlElementMethod t DOMHTMLHtmlElement, MethodInfo info DOMHTMLHtmlElement p) => IsLabelProxy t (DOMHTMLHtmlElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLHtmlElementMethod t DOMHTMLHtmlElement, MethodInfo info DOMHTMLHtmlElement p) => IsLabel t (DOMHTMLHtmlElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "manifest"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLHtmlElementManifest :: (MonadIO m, DOMHTMLHtmlElementK o) => o -> m (Maybe T.Text)
getDOMHTMLHtmlElementManifest obj = liftIO $ getObjectPropertyString obj "manifest"

setDOMHTMLHtmlElementManifest :: (MonadIO m, DOMHTMLHtmlElementK o) => o -> T.Text -> m ()
setDOMHTMLHtmlElementManifest obj val = liftIO $ setObjectPropertyString obj "manifest" (Just val)

constructDOMHTMLHtmlElementManifest :: T.Text -> IO ([Char], GValue)
constructDOMHTMLHtmlElementManifest val = constructObjectPropertyString "manifest" (Just val)

clearDOMHTMLHtmlElementManifest :: (MonadIO m, DOMHTMLHtmlElementK o) => o -> m ()
clearDOMHTMLHtmlElementManifest obj = liftIO $ setObjectPropertyString obj "manifest" (Nothing :: Maybe T.Text)

data DOMHTMLHtmlElementManifestPropertyInfo
instance AttrInfo DOMHTMLHtmlElementManifestPropertyInfo where
    type AttrAllowedOps DOMHTMLHtmlElementManifestPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLHtmlElementManifestPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLHtmlElementManifestPropertyInfo = DOMHTMLHtmlElementK
    type AttrGetType DOMHTMLHtmlElementManifestPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLHtmlElementManifestPropertyInfo = "manifest"
    attrGet _ = getDOMHTMLHtmlElementManifest
    attrSet _ = setDOMHTMLHtmlElementManifest
    attrConstruct _ = constructDOMHTMLHtmlElementManifest
    attrClear _ = clearDOMHTMLHtmlElementManifest

-- VVV Prop "version"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLHtmlElementVersion :: (MonadIO m, DOMHTMLHtmlElementK o) => o -> m (Maybe T.Text)
getDOMHTMLHtmlElementVersion obj = liftIO $ getObjectPropertyString obj "version"

setDOMHTMLHtmlElementVersion :: (MonadIO m, DOMHTMLHtmlElementK o) => o -> T.Text -> m ()
setDOMHTMLHtmlElementVersion obj val = liftIO $ setObjectPropertyString obj "version" (Just val)

constructDOMHTMLHtmlElementVersion :: T.Text -> IO ([Char], GValue)
constructDOMHTMLHtmlElementVersion val = constructObjectPropertyString "version" (Just val)

data DOMHTMLHtmlElementVersionPropertyInfo
instance AttrInfo DOMHTMLHtmlElementVersionPropertyInfo where
    type AttrAllowedOps DOMHTMLHtmlElementVersionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLHtmlElementVersionPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLHtmlElementVersionPropertyInfo = DOMHTMLHtmlElementK
    type AttrGetType DOMHTMLHtmlElementVersionPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLHtmlElementVersionPropertyInfo = "version"
    attrGet _ = getDOMHTMLHtmlElementVersion
    attrSet _ = setDOMHTMLHtmlElementVersion
    attrConstruct _ = constructDOMHTMLHtmlElementVersion
    attrClear _ = undefined

type instance AttributeList DOMHTMLHtmlElement = DOMHTMLHtmlElementAttributeList
type DOMHTMLHtmlElementAttributeList = ('[ '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("id", DOMElementIdPropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("manifest", DOMHTMLHtmlElementManifestPropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("version", DOMHTMLHtmlElementVersionPropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo)] :: [(Symbol, *)])

dOMHTMLHtmlElementManifest :: AttrLabelProxy "manifest"
dOMHTMLHtmlElementManifest = AttrLabelProxy

dOMHTMLHtmlElementVersion :: AttrLabelProxy "version"
dOMHTMLHtmlElementVersion = AttrLabelProxy

type instance SignalList DOMHTMLHtmlElement = DOMHTMLHtmlElementSignalList
type DOMHTMLHtmlElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLHtmlElement::get_version
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLHtmlElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_html_element_get_version" webkit_dom_html_html_element_get_version :: 
    Ptr DOMHTMLHtmlElement ->               -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLHtmlElement"
    IO CString


dOMHTMLHtmlElementGetVersion ::
    (MonadIO m, DOMHTMLHtmlElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLHtmlElementGetVersion _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_html_element_get_version _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_html_element_get_version" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLHtmlElementGetVersionMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLHtmlElementK a) => MethodInfo DOMHTMLHtmlElementGetVersionMethodInfo a signature where
    overloadedMethod _ = dOMHTMLHtmlElementGetVersion

-- method DOMHTMLHtmlElement::set_version
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLHtmlElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_html_element_set_version" webkit_dom_html_html_element_set_version :: 
    Ptr DOMHTMLHtmlElement ->               -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLHtmlElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLHtmlElementSetVersion ::
    (MonadIO m, DOMHTMLHtmlElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLHtmlElementSetVersion _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_html_element_set_version _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLHtmlElementSetVersionMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLHtmlElementK a) => MethodInfo DOMHTMLHtmlElementSetVersionMethodInfo a signature where
    overloadedMethod _ = dOMHTMLHtmlElementSetVersion


