

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLImageElement
    ( 

-- * Exported types
    DOMHTMLImageElement(..)                 ,
    DOMHTMLImageElementK                    ,
    toDOMHTMLImageElement                   ,
    noDOMHTMLImageElement                   ,


 -- * Methods
-- ** dOMHTMLImageElementGetAlign
    DOMHTMLImageElementGetAlignMethodInfo   ,
    dOMHTMLImageElementGetAlign             ,


-- ** dOMHTMLImageElementGetAlt
    DOMHTMLImageElementGetAltMethodInfo     ,
    dOMHTMLImageElementGetAlt               ,


-- ** dOMHTMLImageElementGetBorder
    DOMHTMLImageElementGetBorderMethodInfo  ,
    dOMHTMLImageElementGetBorder            ,


-- ** dOMHTMLImageElementGetComplete
    DOMHTMLImageElementGetCompleteMethodInfo,
    dOMHTMLImageElementGetComplete          ,


-- ** dOMHTMLImageElementGetHeight
    DOMHTMLImageElementGetHeightMethodInfo  ,
    dOMHTMLImageElementGetHeight            ,


-- ** dOMHTMLImageElementGetHspace
    DOMHTMLImageElementGetHspaceMethodInfo  ,
    dOMHTMLImageElementGetHspace            ,


-- ** dOMHTMLImageElementGetIsMap
    DOMHTMLImageElementGetIsMapMethodInfo   ,
    dOMHTMLImageElementGetIsMap             ,


-- ** dOMHTMLImageElementGetLongDesc
    DOMHTMLImageElementGetLongDescMethodInfo,
    dOMHTMLImageElementGetLongDesc          ,


-- ** dOMHTMLImageElementGetLowsrc
    DOMHTMLImageElementGetLowsrcMethodInfo  ,
    dOMHTMLImageElementGetLowsrc            ,


-- ** dOMHTMLImageElementGetName
    DOMHTMLImageElementGetNameMethodInfo    ,
    dOMHTMLImageElementGetName              ,


-- ** dOMHTMLImageElementGetNaturalHeight
    DOMHTMLImageElementGetNaturalHeightMethodInfo,
    dOMHTMLImageElementGetNaturalHeight     ,


-- ** dOMHTMLImageElementGetNaturalWidth
    DOMHTMLImageElementGetNaturalWidthMethodInfo,
    dOMHTMLImageElementGetNaturalWidth      ,


-- ** dOMHTMLImageElementGetSrc
    DOMHTMLImageElementGetSrcMethodInfo     ,
    dOMHTMLImageElementGetSrc               ,


-- ** dOMHTMLImageElementGetUseMap
    DOMHTMLImageElementGetUseMapMethodInfo  ,
    dOMHTMLImageElementGetUseMap            ,


-- ** dOMHTMLImageElementGetVspace
    DOMHTMLImageElementGetVspaceMethodInfo  ,
    dOMHTMLImageElementGetVspace            ,


-- ** dOMHTMLImageElementGetWidth
    DOMHTMLImageElementGetWidthMethodInfo   ,
    dOMHTMLImageElementGetWidth             ,


-- ** dOMHTMLImageElementGetX
    DOMHTMLImageElementGetXMethodInfo       ,
    dOMHTMLImageElementGetX                 ,


-- ** dOMHTMLImageElementGetY
    DOMHTMLImageElementGetYMethodInfo       ,
    dOMHTMLImageElementGetY                 ,


-- ** dOMHTMLImageElementSetAlign
    DOMHTMLImageElementSetAlignMethodInfo   ,
    dOMHTMLImageElementSetAlign             ,


-- ** dOMHTMLImageElementSetAlt
    DOMHTMLImageElementSetAltMethodInfo     ,
    dOMHTMLImageElementSetAlt               ,


-- ** dOMHTMLImageElementSetBorder
    DOMHTMLImageElementSetBorderMethodInfo  ,
    dOMHTMLImageElementSetBorder            ,


-- ** dOMHTMLImageElementSetHeight
    DOMHTMLImageElementSetHeightMethodInfo  ,
    dOMHTMLImageElementSetHeight            ,


-- ** dOMHTMLImageElementSetHspace
    DOMHTMLImageElementSetHspaceMethodInfo  ,
    dOMHTMLImageElementSetHspace            ,


-- ** dOMHTMLImageElementSetIsMap
    DOMHTMLImageElementSetIsMapMethodInfo   ,
    dOMHTMLImageElementSetIsMap             ,


-- ** dOMHTMLImageElementSetLongDesc
    DOMHTMLImageElementSetLongDescMethodInfo,
    dOMHTMLImageElementSetLongDesc          ,


-- ** dOMHTMLImageElementSetLowsrc
    DOMHTMLImageElementSetLowsrcMethodInfo  ,
    dOMHTMLImageElementSetLowsrc            ,


-- ** dOMHTMLImageElementSetName
    DOMHTMLImageElementSetNameMethodInfo    ,
    dOMHTMLImageElementSetName              ,


-- ** dOMHTMLImageElementSetSrc
    DOMHTMLImageElementSetSrcMethodInfo     ,
    dOMHTMLImageElementSetSrc               ,


-- ** dOMHTMLImageElementSetUseMap
    DOMHTMLImageElementSetUseMapMethodInfo  ,
    dOMHTMLImageElementSetUseMap            ,


-- ** dOMHTMLImageElementSetVspace
    DOMHTMLImageElementSetVspaceMethodInfo  ,
    dOMHTMLImageElementSetVspace            ,


-- ** dOMHTMLImageElementSetWidth
    DOMHTMLImageElementSetWidthMethodInfo   ,
    dOMHTMLImageElementSetWidth             ,




 -- * Properties
-- ** Align
    DOMHTMLImageElementAlignPropertyInfo    ,
    constructDOMHTMLImageElementAlign       ,
    dOMHTMLImageElementAlign                ,
    getDOMHTMLImageElementAlign             ,
    setDOMHTMLImageElementAlign             ,


-- ** Alt
    DOMHTMLImageElementAltPropertyInfo      ,
    constructDOMHTMLImageElementAlt         ,
    dOMHTMLImageElementAlt                  ,
    getDOMHTMLImageElementAlt               ,
    setDOMHTMLImageElementAlt               ,


-- ** Border
    DOMHTMLImageElementBorderPropertyInfo   ,
    constructDOMHTMLImageElementBorder      ,
    dOMHTMLImageElementBorder               ,
    getDOMHTMLImageElementBorder            ,
    setDOMHTMLImageElementBorder            ,


-- ** Complete
    DOMHTMLImageElementCompletePropertyInfo ,
    dOMHTMLImageElementComplete             ,
    getDOMHTMLImageElementComplete          ,


-- ** CrossOrigin
    DOMHTMLImageElementCrossOriginPropertyInfo,
    clearDOMHTMLImageElementCrossOrigin     ,
    constructDOMHTMLImageElementCrossOrigin ,
    dOMHTMLImageElementCrossOrigin          ,
    getDOMHTMLImageElementCrossOrigin       ,
    setDOMHTMLImageElementCrossOrigin       ,


-- ** CurrentSrc
    DOMHTMLImageElementCurrentSrcPropertyInfo,
    dOMHTMLImageElementCurrentSrc           ,
    getDOMHTMLImageElementCurrentSrc        ,


-- ** Height
    DOMHTMLImageElementHeightPropertyInfo   ,
    constructDOMHTMLImageElementHeight      ,
    dOMHTMLImageElementHeight               ,
    getDOMHTMLImageElementHeight            ,
    setDOMHTMLImageElementHeight            ,


-- ** Hspace
    DOMHTMLImageElementHspacePropertyInfo   ,
    constructDOMHTMLImageElementHspace      ,
    dOMHTMLImageElementHspace               ,
    getDOMHTMLImageElementHspace            ,
    setDOMHTMLImageElementHspace            ,


-- ** IsMap
    DOMHTMLImageElementIsMapPropertyInfo    ,
    constructDOMHTMLImageElementIsMap       ,
    dOMHTMLImageElementIsMap                ,
    getDOMHTMLImageElementIsMap             ,
    setDOMHTMLImageElementIsMap             ,


-- ** LongDesc
    DOMHTMLImageElementLongDescPropertyInfo ,
    constructDOMHTMLImageElementLongDesc    ,
    dOMHTMLImageElementLongDesc             ,
    getDOMHTMLImageElementLongDesc          ,
    setDOMHTMLImageElementLongDesc          ,


-- ** Lowsrc
    DOMHTMLImageElementLowsrcPropertyInfo   ,
    constructDOMHTMLImageElementLowsrc      ,
    dOMHTMLImageElementLowsrc               ,
    getDOMHTMLImageElementLowsrc            ,
    setDOMHTMLImageElementLowsrc            ,


-- ** Name
    DOMHTMLImageElementNamePropertyInfo     ,
    constructDOMHTMLImageElementName        ,
    dOMHTMLImageElementName                 ,
    getDOMHTMLImageElementName              ,
    setDOMHTMLImageElementName              ,


-- ** NaturalHeight
    DOMHTMLImageElementNaturalHeightPropertyInfo,
    dOMHTMLImageElementNaturalHeight        ,
    getDOMHTMLImageElementNaturalHeight     ,


-- ** NaturalWidth
    DOMHTMLImageElementNaturalWidthPropertyInfo,
    dOMHTMLImageElementNaturalWidth         ,
    getDOMHTMLImageElementNaturalWidth      ,


-- ** Sizes
    DOMHTMLImageElementSizesPropertyInfo    ,
    clearDOMHTMLImageElementSizes           ,
    constructDOMHTMLImageElementSizes       ,
    dOMHTMLImageElementSizes                ,
    getDOMHTMLImageElementSizes             ,
    setDOMHTMLImageElementSizes             ,


-- ** Src
    DOMHTMLImageElementSrcPropertyInfo      ,
    constructDOMHTMLImageElementSrc         ,
    dOMHTMLImageElementSrc                  ,
    getDOMHTMLImageElementSrc               ,
    setDOMHTMLImageElementSrc               ,


-- ** Srcset
    DOMHTMLImageElementSrcsetPropertyInfo   ,
    clearDOMHTMLImageElementSrcset          ,
    constructDOMHTMLImageElementSrcset      ,
    dOMHTMLImageElementSrcset               ,
    getDOMHTMLImageElementSrcset            ,
    setDOMHTMLImageElementSrcset            ,


-- ** UseMap
    DOMHTMLImageElementUseMapPropertyInfo   ,
    constructDOMHTMLImageElementUseMap      ,
    dOMHTMLImageElementUseMap               ,
    getDOMHTMLImageElementUseMap            ,
    setDOMHTMLImageElementUseMap            ,


-- ** Vspace
    DOMHTMLImageElementVspacePropertyInfo   ,
    constructDOMHTMLImageElementVspace      ,
    dOMHTMLImageElementVspace               ,
    getDOMHTMLImageElementVspace            ,
    setDOMHTMLImageElementVspace            ,


-- ** Width
    DOMHTMLImageElementWidthPropertyInfo    ,
    constructDOMHTMLImageElementWidth       ,
    dOMHTMLImageElementWidth                ,
    getDOMHTMLImageElementWidth             ,
    setDOMHTMLImageElementWidth             ,


-- ** X
    DOMHTMLImageElementXPropertyInfo        ,
    dOMHTMLImageElementX                    ,
    getDOMHTMLImageElementX                 ,


-- ** Y
    DOMHTMLImageElementYPropertyInfo        ,
    dOMHTMLImageElementY                    ,
    getDOMHTMLImageElementY                 ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLImageElement = DOMHTMLImageElement (ForeignPtr DOMHTMLImageElement)
foreign import ccall "webkit_dom_html_image_element_get_type"
    c_webkit_dom_html_image_element_get_type :: IO GType

type instance ParentTypes DOMHTMLImageElement = DOMHTMLImageElementParentTypes
type DOMHTMLImageElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLImageElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_image_element_get_type
    

class GObject o => DOMHTMLImageElementK o
instance (GObject o, IsDescendantOf DOMHTMLImageElement o) => DOMHTMLImageElementK o

toDOMHTMLImageElement :: DOMHTMLImageElementK o => o -> IO DOMHTMLImageElement
toDOMHTMLImageElement = unsafeCastTo DOMHTMLImageElement

noDOMHTMLImageElement :: Maybe DOMHTMLImageElement
noDOMHTMLImageElement = Nothing

type family ResolveDOMHTMLImageElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLImageElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLImageElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLImageElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLImageElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLImageElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLImageElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLImageElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLImageElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLImageElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLImageElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLImageElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLImageElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLImageElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLImageElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLImageElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLImageElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLImageElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLImageElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLImageElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLImageElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLImageElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLImageElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLImageElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLImageElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLImageElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLImageElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLImageElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLImageElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLImageElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLImageElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLImageElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLImageElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLImageElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLImageElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLImageElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLImageElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLImageElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLImageElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLImageElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLImageElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLImageElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLImageElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLImageElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLImageElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLImageElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLImageElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLImageElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLImageElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLImageElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLImageElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLImageElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLImageElementMethod "getAlign" o = DOMHTMLImageElementGetAlignMethodInfo
    ResolveDOMHTMLImageElementMethod "getAlt" o = DOMHTMLImageElementGetAltMethodInfo
    ResolveDOMHTMLImageElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLImageElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLImageElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLImageElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLImageElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLImageElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLImageElementMethod "getBorder" o = DOMHTMLImageElementGetBorderMethodInfo
    ResolveDOMHTMLImageElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLImageElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLImageElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLImageElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLImageElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLImageElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLImageElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLImageElementMethod "getComplete" o = DOMHTMLImageElementGetCompleteMethodInfo
    ResolveDOMHTMLImageElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLImageElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLImageElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLImageElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLImageElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLImageElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLImageElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLImageElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLImageElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLImageElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLImageElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLImageElementMethod "getHeight" o = DOMHTMLImageElementGetHeightMethodInfo
    ResolveDOMHTMLImageElementMethod "getHspace" o = DOMHTMLImageElementGetHspaceMethodInfo
    ResolveDOMHTMLImageElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLImageElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLImageElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLImageElementMethod "getIsMap" o = DOMHTMLImageElementGetIsMapMethodInfo
    ResolveDOMHTMLImageElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLImageElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLImageElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLImageElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLImageElementMethod "getLongDesc" o = DOMHTMLImageElementGetLongDescMethodInfo
    ResolveDOMHTMLImageElementMethod "getLowsrc" o = DOMHTMLImageElementGetLowsrcMethodInfo
    ResolveDOMHTMLImageElementMethod "getName" o = DOMHTMLImageElementGetNameMethodInfo
    ResolveDOMHTMLImageElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLImageElementMethod "getNaturalHeight" o = DOMHTMLImageElementGetNaturalHeightMethodInfo
    ResolveDOMHTMLImageElementMethod "getNaturalWidth" o = DOMHTMLImageElementGetNaturalWidthMethodInfo
    ResolveDOMHTMLImageElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLImageElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLImageElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLImageElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLImageElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLImageElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLImageElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLImageElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLImageElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLImageElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLImageElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLImageElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLImageElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLImageElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLImageElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLImageElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLImageElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLImageElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLImageElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLImageElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLImageElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLImageElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLImageElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLImageElementMethod "getSrc" o = DOMHTMLImageElementGetSrcMethodInfo
    ResolveDOMHTMLImageElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLImageElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLImageElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLImageElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLImageElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLImageElementMethod "getUseMap" o = DOMHTMLImageElementGetUseMapMethodInfo
    ResolveDOMHTMLImageElementMethod "getVspace" o = DOMHTMLImageElementGetVspaceMethodInfo
    ResolveDOMHTMLImageElementMethod "getWidth" o = DOMHTMLImageElementGetWidthMethodInfo
    ResolveDOMHTMLImageElementMethod "getX" o = DOMHTMLImageElementGetXMethodInfo
    ResolveDOMHTMLImageElementMethod "getY" o = DOMHTMLImageElementGetYMethodInfo
    ResolveDOMHTMLImageElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLImageElementMethod "setAlign" o = DOMHTMLImageElementSetAlignMethodInfo
    ResolveDOMHTMLImageElementMethod "setAlt" o = DOMHTMLImageElementSetAltMethodInfo
    ResolveDOMHTMLImageElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLImageElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLImageElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLImageElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLImageElementMethod "setBorder" o = DOMHTMLImageElementSetBorderMethodInfo
    ResolveDOMHTMLImageElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLImageElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLImageElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLImageElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLImageElementMethod "setHeight" o = DOMHTMLImageElementSetHeightMethodInfo
    ResolveDOMHTMLImageElementMethod "setHspace" o = DOMHTMLImageElementSetHspaceMethodInfo
    ResolveDOMHTMLImageElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLImageElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLImageElementMethod "setIsMap" o = DOMHTMLImageElementSetIsMapMethodInfo
    ResolveDOMHTMLImageElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLImageElementMethod "setLongDesc" o = DOMHTMLImageElementSetLongDescMethodInfo
    ResolveDOMHTMLImageElementMethod "setLowsrc" o = DOMHTMLImageElementSetLowsrcMethodInfo
    ResolveDOMHTMLImageElementMethod "setName" o = DOMHTMLImageElementSetNameMethodInfo
    ResolveDOMHTMLImageElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLImageElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLImageElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLImageElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLImageElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLImageElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLImageElementMethod "setSrc" o = DOMHTMLImageElementSetSrcMethodInfo
    ResolveDOMHTMLImageElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLImageElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLImageElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLImageElementMethod "setUseMap" o = DOMHTMLImageElementSetUseMapMethodInfo
    ResolveDOMHTMLImageElementMethod "setVspace" o = DOMHTMLImageElementSetVspaceMethodInfo
    ResolveDOMHTMLImageElementMethod "setWidth" o = DOMHTMLImageElementSetWidthMethodInfo
    ResolveDOMHTMLImageElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLImageElementMethod t DOMHTMLImageElement, MethodInfo info DOMHTMLImageElement p) => IsLabelProxy t (DOMHTMLImageElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLImageElementMethod t DOMHTMLImageElement, MethodInfo info DOMHTMLImageElement p) => IsLabel t (DOMHTMLImageElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "align"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLImageElementAlign :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementAlign obj = liftIO $ getObjectPropertyString obj "align"

setDOMHTMLImageElementAlign :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementAlign obj val = liftIO $ setObjectPropertyString obj "align" (Just val)

constructDOMHTMLImageElementAlign :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementAlign val = constructObjectPropertyString "align" (Just val)

data DOMHTMLImageElementAlignPropertyInfo
instance AttrInfo DOMHTMLImageElementAlignPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementAlignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementAlignPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementAlignPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementAlignPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementAlignPropertyInfo = "align"
    attrGet _ = getDOMHTMLImageElementAlign
    attrSet _ = setDOMHTMLImageElementAlign
    attrConstruct _ = constructDOMHTMLImageElementAlign
    attrClear _ = undefined

-- VVV Prop "alt"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLImageElementAlt :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementAlt obj = liftIO $ getObjectPropertyString obj "alt"

setDOMHTMLImageElementAlt :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementAlt obj val = liftIO $ setObjectPropertyString obj "alt" (Just val)

constructDOMHTMLImageElementAlt :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementAlt val = constructObjectPropertyString "alt" (Just val)

data DOMHTMLImageElementAltPropertyInfo
instance AttrInfo DOMHTMLImageElementAltPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementAltPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementAltPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementAltPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementAltPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementAltPropertyInfo = "alt"
    attrGet _ = getDOMHTMLImageElementAlt
    attrSet _ = setDOMHTMLImageElementAlt
    attrConstruct _ = constructDOMHTMLImageElementAlt
    attrClear _ = undefined

-- VVV Prop "border"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLImageElementBorder :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementBorder obj = liftIO $ getObjectPropertyString obj "border"

setDOMHTMLImageElementBorder :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementBorder obj val = liftIO $ setObjectPropertyString obj "border" (Just val)

constructDOMHTMLImageElementBorder :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementBorder val = constructObjectPropertyString "border" (Just val)

data DOMHTMLImageElementBorderPropertyInfo
instance AttrInfo DOMHTMLImageElementBorderPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementBorderPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementBorderPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementBorderPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementBorderPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementBorderPropertyInfo = "border"
    attrGet _ = getDOMHTMLImageElementBorder
    attrSet _ = setDOMHTMLImageElementBorder
    attrConstruct _ = constructDOMHTMLImageElementBorder
    attrClear _ = undefined

-- VVV Prop "complete"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLImageElementComplete :: (MonadIO m, DOMHTMLImageElementK o) => o -> m Bool
getDOMHTMLImageElementComplete obj = liftIO $ getObjectPropertyBool obj "complete"

data DOMHTMLImageElementCompletePropertyInfo
instance AttrInfo DOMHTMLImageElementCompletePropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementCompletePropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementCompletePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLImageElementCompletePropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementCompletePropertyInfo = Bool
    type AttrLabel DOMHTMLImageElementCompletePropertyInfo = "complete"
    attrGet _ = getDOMHTMLImageElementComplete
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "cross-origin"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLImageElementCrossOrigin :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementCrossOrigin obj = liftIO $ getObjectPropertyString obj "cross-origin"

setDOMHTMLImageElementCrossOrigin :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementCrossOrigin obj val = liftIO $ setObjectPropertyString obj "cross-origin" (Just val)

constructDOMHTMLImageElementCrossOrigin :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementCrossOrigin val = constructObjectPropertyString "cross-origin" (Just val)

clearDOMHTMLImageElementCrossOrigin :: (MonadIO m, DOMHTMLImageElementK o) => o -> m ()
clearDOMHTMLImageElementCrossOrigin obj = liftIO $ setObjectPropertyString obj "cross-origin" (Nothing :: Maybe T.Text)

data DOMHTMLImageElementCrossOriginPropertyInfo
instance AttrInfo DOMHTMLImageElementCrossOriginPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementCrossOriginPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLImageElementCrossOriginPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementCrossOriginPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementCrossOriginPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementCrossOriginPropertyInfo = "cross-origin"
    attrGet _ = getDOMHTMLImageElementCrossOrigin
    attrSet _ = setDOMHTMLImageElementCrossOrigin
    attrConstruct _ = constructDOMHTMLImageElementCrossOrigin
    attrClear _ = clearDOMHTMLImageElementCrossOrigin

-- VVV Prop "current-src"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLImageElementCurrentSrc :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementCurrentSrc obj = liftIO $ getObjectPropertyString obj "current-src"

data DOMHTMLImageElementCurrentSrcPropertyInfo
instance AttrInfo DOMHTMLImageElementCurrentSrcPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementCurrentSrcPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLImageElementCurrentSrcPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLImageElementCurrentSrcPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementCurrentSrcPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementCurrentSrcPropertyInfo = "current-src"
    attrGet _ = getDOMHTMLImageElementCurrentSrc
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "height"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLImageElementHeight :: (MonadIO m, DOMHTMLImageElementK o) => o -> m CLong
getDOMHTMLImageElementHeight obj = liftIO $ getObjectPropertyLong obj "height"

setDOMHTMLImageElementHeight :: (MonadIO m, DOMHTMLImageElementK o) => o -> CLong -> m ()
setDOMHTMLImageElementHeight obj val = liftIO $ setObjectPropertyLong obj "height" val

constructDOMHTMLImageElementHeight :: CLong -> IO ([Char], GValue)
constructDOMHTMLImageElementHeight val = constructObjectPropertyLong "height" val

data DOMHTMLImageElementHeightPropertyInfo
instance AttrInfo DOMHTMLImageElementHeightPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementHeightPropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLImageElementHeightPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementHeightPropertyInfo = CLong
    type AttrLabel DOMHTMLImageElementHeightPropertyInfo = "height"
    attrGet _ = getDOMHTMLImageElementHeight
    attrSet _ = setDOMHTMLImageElementHeight
    attrConstruct _ = constructDOMHTMLImageElementHeight
    attrClear _ = undefined

-- VVV Prop "hspace"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLImageElementHspace :: (MonadIO m, DOMHTMLImageElementK o) => o -> m CLong
getDOMHTMLImageElementHspace obj = liftIO $ getObjectPropertyLong obj "hspace"

setDOMHTMLImageElementHspace :: (MonadIO m, DOMHTMLImageElementK o) => o -> CLong -> m ()
setDOMHTMLImageElementHspace obj val = liftIO $ setObjectPropertyLong obj "hspace" val

constructDOMHTMLImageElementHspace :: CLong -> IO ([Char], GValue)
constructDOMHTMLImageElementHspace val = constructObjectPropertyLong "hspace" val

data DOMHTMLImageElementHspacePropertyInfo
instance AttrInfo DOMHTMLImageElementHspacePropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementHspacePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementHspacePropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLImageElementHspacePropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementHspacePropertyInfo = CLong
    type AttrLabel DOMHTMLImageElementHspacePropertyInfo = "hspace"
    attrGet _ = getDOMHTMLImageElementHspace
    attrSet _ = setDOMHTMLImageElementHspace
    attrConstruct _ = constructDOMHTMLImageElementHspace
    attrClear _ = undefined

-- VVV Prop "is-map"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLImageElementIsMap :: (MonadIO m, DOMHTMLImageElementK o) => o -> m Bool
getDOMHTMLImageElementIsMap obj = liftIO $ getObjectPropertyBool obj "is-map"

setDOMHTMLImageElementIsMap :: (MonadIO m, DOMHTMLImageElementK o) => o -> Bool -> m ()
setDOMHTMLImageElementIsMap obj val = liftIO $ setObjectPropertyBool obj "is-map" val

constructDOMHTMLImageElementIsMap :: Bool -> IO ([Char], GValue)
constructDOMHTMLImageElementIsMap val = constructObjectPropertyBool "is-map" val

data DOMHTMLImageElementIsMapPropertyInfo
instance AttrInfo DOMHTMLImageElementIsMapPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementIsMapPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementIsMapPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLImageElementIsMapPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementIsMapPropertyInfo = Bool
    type AttrLabel DOMHTMLImageElementIsMapPropertyInfo = "is-map"
    attrGet _ = getDOMHTMLImageElementIsMap
    attrSet _ = setDOMHTMLImageElementIsMap
    attrConstruct _ = constructDOMHTMLImageElementIsMap
    attrClear _ = undefined

-- VVV Prop "long-desc"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLImageElementLongDesc :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementLongDesc obj = liftIO $ getObjectPropertyString obj "long-desc"

setDOMHTMLImageElementLongDesc :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementLongDesc obj val = liftIO $ setObjectPropertyString obj "long-desc" (Just val)

constructDOMHTMLImageElementLongDesc :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementLongDesc val = constructObjectPropertyString "long-desc" (Just val)

data DOMHTMLImageElementLongDescPropertyInfo
instance AttrInfo DOMHTMLImageElementLongDescPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementLongDescPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementLongDescPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementLongDescPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementLongDescPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementLongDescPropertyInfo = "long-desc"
    attrGet _ = getDOMHTMLImageElementLongDesc
    attrSet _ = setDOMHTMLImageElementLongDesc
    attrConstruct _ = constructDOMHTMLImageElementLongDesc
    attrClear _ = undefined

-- VVV Prop "lowsrc"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLImageElementLowsrc :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementLowsrc obj = liftIO $ getObjectPropertyString obj "lowsrc"

setDOMHTMLImageElementLowsrc :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementLowsrc obj val = liftIO $ setObjectPropertyString obj "lowsrc" (Just val)

constructDOMHTMLImageElementLowsrc :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementLowsrc val = constructObjectPropertyString "lowsrc" (Just val)

data DOMHTMLImageElementLowsrcPropertyInfo
instance AttrInfo DOMHTMLImageElementLowsrcPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementLowsrcPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementLowsrcPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementLowsrcPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementLowsrcPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementLowsrcPropertyInfo = "lowsrc"
    attrGet _ = getDOMHTMLImageElementLowsrc
    attrSet _ = setDOMHTMLImageElementLowsrc
    attrConstruct _ = constructDOMHTMLImageElementLowsrc
    attrClear _ = undefined

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLImageElementName :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementName obj = liftIO $ getObjectPropertyString obj "name"

setDOMHTMLImageElementName :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementName obj val = liftIO $ setObjectPropertyString obj "name" (Just val)

constructDOMHTMLImageElementName :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementName val = constructObjectPropertyString "name" (Just val)

data DOMHTMLImageElementNamePropertyInfo
instance AttrInfo DOMHTMLImageElementNamePropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementNamePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementNamePropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementNamePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementNamePropertyInfo = "name"
    attrGet _ = getDOMHTMLImageElementName
    attrSet _ = setDOMHTMLImageElementName
    attrConstruct _ = constructDOMHTMLImageElementName
    attrClear _ = undefined

-- VVV Prop "natural-height"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLImageElementNaturalHeight :: (MonadIO m, DOMHTMLImageElementK o) => o -> m CLong
getDOMHTMLImageElementNaturalHeight obj = liftIO $ getObjectPropertyLong obj "natural-height"

data DOMHTMLImageElementNaturalHeightPropertyInfo
instance AttrInfo DOMHTMLImageElementNaturalHeightPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementNaturalHeightPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementNaturalHeightPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLImageElementNaturalHeightPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementNaturalHeightPropertyInfo = CLong
    type AttrLabel DOMHTMLImageElementNaturalHeightPropertyInfo = "natural-height"
    attrGet _ = getDOMHTMLImageElementNaturalHeight
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "natural-width"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLImageElementNaturalWidth :: (MonadIO m, DOMHTMLImageElementK o) => o -> m CLong
getDOMHTMLImageElementNaturalWidth obj = liftIO $ getObjectPropertyLong obj "natural-width"

data DOMHTMLImageElementNaturalWidthPropertyInfo
instance AttrInfo DOMHTMLImageElementNaturalWidthPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementNaturalWidthPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementNaturalWidthPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLImageElementNaturalWidthPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementNaturalWidthPropertyInfo = CLong
    type AttrLabel DOMHTMLImageElementNaturalWidthPropertyInfo = "natural-width"
    attrGet _ = getDOMHTMLImageElementNaturalWidth
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "sizes"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLImageElementSizes :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementSizes obj = liftIO $ getObjectPropertyString obj "sizes"

setDOMHTMLImageElementSizes :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementSizes obj val = liftIO $ setObjectPropertyString obj "sizes" (Just val)

constructDOMHTMLImageElementSizes :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementSizes val = constructObjectPropertyString "sizes" (Just val)

clearDOMHTMLImageElementSizes :: (MonadIO m, DOMHTMLImageElementK o) => o -> m ()
clearDOMHTMLImageElementSizes obj = liftIO $ setObjectPropertyString obj "sizes" (Nothing :: Maybe T.Text)

data DOMHTMLImageElementSizesPropertyInfo
instance AttrInfo DOMHTMLImageElementSizesPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementSizesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLImageElementSizesPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementSizesPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementSizesPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementSizesPropertyInfo = "sizes"
    attrGet _ = getDOMHTMLImageElementSizes
    attrSet _ = setDOMHTMLImageElementSizes
    attrConstruct _ = constructDOMHTMLImageElementSizes
    attrClear _ = clearDOMHTMLImageElementSizes

-- VVV Prop "src"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLImageElementSrc :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementSrc obj = liftIO $ getObjectPropertyString obj "src"

setDOMHTMLImageElementSrc :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementSrc obj val = liftIO $ setObjectPropertyString obj "src" (Just val)

constructDOMHTMLImageElementSrc :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementSrc val = constructObjectPropertyString "src" (Just val)

data DOMHTMLImageElementSrcPropertyInfo
instance AttrInfo DOMHTMLImageElementSrcPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementSrcPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementSrcPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementSrcPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementSrcPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementSrcPropertyInfo = "src"
    attrGet _ = getDOMHTMLImageElementSrc
    attrSet _ = setDOMHTMLImageElementSrc
    attrConstruct _ = constructDOMHTMLImageElementSrc
    attrClear _ = undefined

-- VVV Prop "srcset"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLImageElementSrcset :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementSrcset obj = liftIO $ getObjectPropertyString obj "srcset"

setDOMHTMLImageElementSrcset :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementSrcset obj val = liftIO $ setObjectPropertyString obj "srcset" (Just val)

constructDOMHTMLImageElementSrcset :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementSrcset val = constructObjectPropertyString "srcset" (Just val)

clearDOMHTMLImageElementSrcset :: (MonadIO m, DOMHTMLImageElementK o) => o -> m ()
clearDOMHTMLImageElementSrcset obj = liftIO $ setObjectPropertyString obj "srcset" (Nothing :: Maybe T.Text)

data DOMHTMLImageElementSrcsetPropertyInfo
instance AttrInfo DOMHTMLImageElementSrcsetPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementSrcsetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLImageElementSrcsetPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementSrcsetPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementSrcsetPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementSrcsetPropertyInfo = "srcset"
    attrGet _ = getDOMHTMLImageElementSrcset
    attrSet _ = setDOMHTMLImageElementSrcset
    attrConstruct _ = constructDOMHTMLImageElementSrcset
    attrClear _ = clearDOMHTMLImageElementSrcset

-- VVV Prop "use-map"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLImageElementUseMap :: (MonadIO m, DOMHTMLImageElementK o) => o -> m (Maybe T.Text)
getDOMHTMLImageElementUseMap obj = liftIO $ getObjectPropertyString obj "use-map"

setDOMHTMLImageElementUseMap :: (MonadIO m, DOMHTMLImageElementK o) => o -> T.Text -> m ()
setDOMHTMLImageElementUseMap obj val = liftIO $ setObjectPropertyString obj "use-map" (Just val)

constructDOMHTMLImageElementUseMap :: T.Text -> IO ([Char], GValue)
constructDOMHTMLImageElementUseMap val = constructObjectPropertyString "use-map" (Just val)

data DOMHTMLImageElementUseMapPropertyInfo
instance AttrInfo DOMHTMLImageElementUseMapPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementUseMapPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementUseMapPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLImageElementUseMapPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementUseMapPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLImageElementUseMapPropertyInfo = "use-map"
    attrGet _ = getDOMHTMLImageElementUseMap
    attrSet _ = setDOMHTMLImageElementUseMap
    attrConstruct _ = constructDOMHTMLImageElementUseMap
    attrClear _ = undefined

-- VVV Prop "vspace"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLImageElementVspace :: (MonadIO m, DOMHTMLImageElementK o) => o -> m CLong
getDOMHTMLImageElementVspace obj = liftIO $ getObjectPropertyLong obj "vspace"

setDOMHTMLImageElementVspace :: (MonadIO m, DOMHTMLImageElementK o) => o -> CLong -> m ()
setDOMHTMLImageElementVspace obj val = liftIO $ setObjectPropertyLong obj "vspace" val

constructDOMHTMLImageElementVspace :: CLong -> IO ([Char], GValue)
constructDOMHTMLImageElementVspace val = constructObjectPropertyLong "vspace" val

data DOMHTMLImageElementVspacePropertyInfo
instance AttrInfo DOMHTMLImageElementVspacePropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementVspacePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementVspacePropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLImageElementVspacePropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementVspacePropertyInfo = CLong
    type AttrLabel DOMHTMLImageElementVspacePropertyInfo = "vspace"
    attrGet _ = getDOMHTMLImageElementVspace
    attrSet _ = setDOMHTMLImageElementVspace
    attrConstruct _ = constructDOMHTMLImageElementVspace
    attrClear _ = undefined

-- VVV Prop "width"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLImageElementWidth :: (MonadIO m, DOMHTMLImageElementK o) => o -> m CLong
getDOMHTMLImageElementWidth obj = liftIO $ getObjectPropertyLong obj "width"

setDOMHTMLImageElementWidth :: (MonadIO m, DOMHTMLImageElementK o) => o -> CLong -> m ()
setDOMHTMLImageElementWidth obj val = liftIO $ setObjectPropertyLong obj "width" val

constructDOMHTMLImageElementWidth :: CLong -> IO ([Char], GValue)
constructDOMHTMLImageElementWidth val = constructObjectPropertyLong "width" val

data DOMHTMLImageElementWidthPropertyInfo
instance AttrInfo DOMHTMLImageElementWidthPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementWidthPropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLImageElementWidthPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementWidthPropertyInfo = CLong
    type AttrLabel DOMHTMLImageElementWidthPropertyInfo = "width"
    attrGet _ = getDOMHTMLImageElementWidth
    attrSet _ = setDOMHTMLImageElementWidth
    attrConstruct _ = constructDOMHTMLImageElementWidth
    attrClear _ = undefined

-- VVV Prop "x"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLImageElementX :: (MonadIO m, DOMHTMLImageElementK o) => o -> m CLong
getDOMHTMLImageElementX obj = liftIO $ getObjectPropertyLong obj "x"

data DOMHTMLImageElementXPropertyInfo
instance AttrInfo DOMHTMLImageElementXPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementXPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementXPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLImageElementXPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementXPropertyInfo = CLong
    type AttrLabel DOMHTMLImageElementXPropertyInfo = "x"
    attrGet _ = getDOMHTMLImageElementX
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "y"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLImageElementY :: (MonadIO m, DOMHTMLImageElementK o) => o -> m CLong
getDOMHTMLImageElementY obj = liftIO $ getObjectPropertyLong obj "y"

data DOMHTMLImageElementYPropertyInfo
instance AttrInfo DOMHTMLImageElementYPropertyInfo where
    type AttrAllowedOps DOMHTMLImageElementYPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLImageElementYPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLImageElementYPropertyInfo = DOMHTMLImageElementK
    type AttrGetType DOMHTMLImageElementYPropertyInfo = CLong
    type AttrLabel DOMHTMLImageElementYPropertyInfo = "y"
    attrGet _ = getDOMHTMLImageElementY
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList DOMHTMLImageElement = DOMHTMLImageElementAttributeList
type DOMHTMLImageElementAttributeList = ('[ '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("align", DOMHTMLImageElementAlignPropertyInfo), '("alt", DOMHTMLImageElementAltPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("border", DOMHTMLImageElementBorderPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("complete", DOMHTMLImageElementCompletePropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("crossOrigin", DOMHTMLImageElementCrossOriginPropertyInfo), '("currentSrc", DOMHTMLImageElementCurrentSrcPropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("height", DOMHTMLImageElementHeightPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("hspace", DOMHTMLImageElementHspacePropertyInfo), '("id", DOMElementIdPropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("isMap", DOMHTMLImageElementIsMapPropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("longDesc", DOMHTMLImageElementLongDescPropertyInfo), '("lowsrc", DOMHTMLImageElementLowsrcPropertyInfo), '("name", DOMHTMLImageElementNamePropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("naturalHeight", DOMHTMLImageElementNaturalHeightPropertyInfo), '("naturalWidth", DOMHTMLImageElementNaturalWidthPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("sizes", DOMHTMLImageElementSizesPropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("src", DOMHTMLImageElementSrcPropertyInfo), '("srcset", DOMHTMLImageElementSrcsetPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("useMap", DOMHTMLImageElementUseMapPropertyInfo), '("vspace", DOMHTMLImageElementVspacePropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo), '("width", DOMHTMLImageElementWidthPropertyInfo), '("x", DOMHTMLImageElementXPropertyInfo), '("y", DOMHTMLImageElementYPropertyInfo)] :: [(Symbol, *)])

dOMHTMLImageElementAlign :: AttrLabelProxy "align"
dOMHTMLImageElementAlign = AttrLabelProxy

dOMHTMLImageElementAlt :: AttrLabelProxy "alt"
dOMHTMLImageElementAlt = AttrLabelProxy

dOMHTMLImageElementBorder :: AttrLabelProxy "border"
dOMHTMLImageElementBorder = AttrLabelProxy

dOMHTMLImageElementComplete :: AttrLabelProxy "complete"
dOMHTMLImageElementComplete = AttrLabelProxy

dOMHTMLImageElementCrossOrigin :: AttrLabelProxy "crossOrigin"
dOMHTMLImageElementCrossOrigin = AttrLabelProxy

dOMHTMLImageElementCurrentSrc :: AttrLabelProxy "currentSrc"
dOMHTMLImageElementCurrentSrc = AttrLabelProxy

dOMHTMLImageElementHeight :: AttrLabelProxy "height"
dOMHTMLImageElementHeight = AttrLabelProxy

dOMHTMLImageElementHspace :: AttrLabelProxy "hspace"
dOMHTMLImageElementHspace = AttrLabelProxy

dOMHTMLImageElementIsMap :: AttrLabelProxy "isMap"
dOMHTMLImageElementIsMap = AttrLabelProxy

dOMHTMLImageElementLongDesc :: AttrLabelProxy "longDesc"
dOMHTMLImageElementLongDesc = AttrLabelProxy

dOMHTMLImageElementLowsrc :: AttrLabelProxy "lowsrc"
dOMHTMLImageElementLowsrc = AttrLabelProxy

dOMHTMLImageElementName :: AttrLabelProxy "name"
dOMHTMLImageElementName = AttrLabelProxy

dOMHTMLImageElementNaturalHeight :: AttrLabelProxy "naturalHeight"
dOMHTMLImageElementNaturalHeight = AttrLabelProxy

dOMHTMLImageElementNaturalWidth :: AttrLabelProxy "naturalWidth"
dOMHTMLImageElementNaturalWidth = AttrLabelProxy

dOMHTMLImageElementSizes :: AttrLabelProxy "sizes"
dOMHTMLImageElementSizes = AttrLabelProxy

dOMHTMLImageElementSrc :: AttrLabelProxy "src"
dOMHTMLImageElementSrc = AttrLabelProxy

dOMHTMLImageElementSrcset :: AttrLabelProxy "srcset"
dOMHTMLImageElementSrcset = AttrLabelProxy

dOMHTMLImageElementUseMap :: AttrLabelProxy "useMap"
dOMHTMLImageElementUseMap = AttrLabelProxy

dOMHTMLImageElementVspace :: AttrLabelProxy "vspace"
dOMHTMLImageElementVspace = AttrLabelProxy

dOMHTMLImageElementWidth :: AttrLabelProxy "width"
dOMHTMLImageElementWidth = AttrLabelProxy

dOMHTMLImageElementX :: AttrLabelProxy "x"
dOMHTMLImageElementX = AttrLabelProxy

dOMHTMLImageElementY :: AttrLabelProxy "y"
dOMHTMLImageElementY = AttrLabelProxy

type instance SignalList DOMHTMLImageElement = DOMHTMLImageElementSignalList
type DOMHTMLImageElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLImageElement::get_align
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_align" webkit_dom_html_image_element_get_align :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CString


dOMHTMLImageElementGetAlign ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLImageElementGetAlign _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_align _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_image_element_get_align" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetAlignMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetAlignMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetAlign

-- method DOMHTMLImageElement::get_alt
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_alt" webkit_dom_html_image_element_get_alt :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CString


dOMHTMLImageElementGetAlt ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLImageElementGetAlt _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_alt _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_image_element_get_alt" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetAltMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetAltMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetAlt

-- method DOMHTMLImageElement::get_border
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_border" webkit_dom_html_image_element_get_border :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CString


dOMHTMLImageElementGetBorder ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLImageElementGetBorder _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_border _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_image_element_get_border" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetBorderMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetBorderMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetBorder

-- method DOMHTMLImageElement::get_complete
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_complete" webkit_dom_html_image_element_get_complete :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CInt


dOMHTMLImageElementGetComplete ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLImageElementGetComplete _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_complete _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetCompleteMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetCompleteMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetComplete

-- method DOMHTMLImageElement::get_height
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_height" webkit_dom_html_image_element_get_height :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CLong


dOMHTMLImageElementGetHeight ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLImageElementGetHeight _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_height _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLImageElementGetHeightMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetHeightMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetHeight

-- method DOMHTMLImageElement::get_hspace
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_hspace" webkit_dom_html_image_element_get_hspace :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CLong


dOMHTMLImageElementGetHspace ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLImageElementGetHspace _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_hspace _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLImageElementGetHspaceMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetHspaceMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetHspace

-- method DOMHTMLImageElement::get_is_map
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_is_map" webkit_dom_html_image_element_get_is_map :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CInt


dOMHTMLImageElementGetIsMap ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLImageElementGetIsMap _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_is_map _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetIsMapMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetIsMapMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetIsMap

-- method DOMHTMLImageElement::get_long_desc
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_long_desc" webkit_dom_html_image_element_get_long_desc :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CString


dOMHTMLImageElementGetLongDesc ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLImageElementGetLongDesc _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_long_desc _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_image_element_get_long_desc" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetLongDescMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetLongDescMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetLongDesc

-- method DOMHTMLImageElement::get_lowsrc
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_lowsrc" webkit_dom_html_image_element_get_lowsrc :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CString


dOMHTMLImageElementGetLowsrc ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLImageElementGetLowsrc _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_lowsrc _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_image_element_get_lowsrc" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetLowsrcMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetLowsrcMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetLowsrc

-- method DOMHTMLImageElement::get_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_name" webkit_dom_html_image_element_get_name :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CString


dOMHTMLImageElementGetName ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLImageElementGetName _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_name _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_image_element_get_name" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetNameMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetName

-- method DOMHTMLImageElement::get_natural_height
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_natural_height" webkit_dom_html_image_element_get_natural_height :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CLong


dOMHTMLImageElementGetNaturalHeight ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLImageElementGetNaturalHeight _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_natural_height _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLImageElementGetNaturalHeightMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetNaturalHeightMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetNaturalHeight

-- method DOMHTMLImageElement::get_natural_width
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_natural_width" webkit_dom_html_image_element_get_natural_width :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CLong


dOMHTMLImageElementGetNaturalWidth ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLImageElementGetNaturalWidth _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_natural_width _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLImageElementGetNaturalWidthMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetNaturalWidthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetNaturalWidth

-- method DOMHTMLImageElement::get_src
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_src" webkit_dom_html_image_element_get_src :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CString


dOMHTMLImageElementGetSrc ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLImageElementGetSrc _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_src _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_image_element_get_src" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetSrcMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetSrcMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetSrc

-- method DOMHTMLImageElement::get_use_map
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_use_map" webkit_dom_html_image_element_get_use_map :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CString


dOMHTMLImageElementGetUseMap ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLImageElementGetUseMap _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_use_map _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_image_element_get_use_map" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLImageElementGetUseMapMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetUseMapMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetUseMap

-- method DOMHTMLImageElement::get_vspace
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_vspace" webkit_dom_html_image_element_get_vspace :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CLong


dOMHTMLImageElementGetVspace ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLImageElementGetVspace _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_vspace _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLImageElementGetVspaceMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetVspaceMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetVspace

-- method DOMHTMLImageElement::get_width
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_width" webkit_dom_html_image_element_get_width :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CLong


dOMHTMLImageElementGetWidth ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLImageElementGetWidth _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_width _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLImageElementGetWidthMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetWidthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetWidth

-- method DOMHTMLImageElement::get_x
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_x" webkit_dom_html_image_element_get_x :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CLong


dOMHTMLImageElementGetX ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLImageElementGetX _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_x _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLImageElementGetXMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetXMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetX

-- method DOMHTMLImageElement::get_y
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_get_y" webkit_dom_html_image_element_get_y :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    IO CLong


dOMHTMLImageElementGetY ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLImageElementGetY _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_image_element_get_y _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLImageElementGetYMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementGetYMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementGetY

-- method DOMHTMLImageElement::set_align
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_align" webkit_dom_html_image_element_set_align :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLImageElementSetAlign ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetAlign _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_image_element_set_align _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLImageElementSetAlignMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetAlignMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetAlign

-- method DOMHTMLImageElement::set_alt
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_alt" webkit_dom_html_image_element_set_alt :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLImageElementSetAlt ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetAlt _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_image_element_set_alt _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLImageElementSetAltMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetAltMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetAlt

-- method DOMHTMLImageElement::set_border
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_border" webkit_dom_html_image_element_set_border :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLImageElementSetBorder ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetBorder _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_image_element_set_border _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLImageElementSetBorderMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetBorderMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetBorder

-- method DOMHTMLImageElement::set_height
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TLong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_height" webkit_dom_html_image_element_set_height :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CLong ->                                -- value : TBasicType TLong
    IO ()


dOMHTMLImageElementSetHeight ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> CLong                                -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetHeight _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_image_element_set_height _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLImageElementSetHeightMethodInfo
instance (signature ~ (CLong -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetHeightMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetHeight

-- method DOMHTMLImageElement::set_hspace
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TLong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_hspace" webkit_dom_html_image_element_set_hspace :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CLong ->                                -- value : TBasicType TLong
    IO ()


dOMHTMLImageElementSetHspace ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> CLong                                -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetHspace _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_image_element_set_hspace _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLImageElementSetHspaceMethodInfo
instance (signature ~ (CLong -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetHspaceMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetHspace

-- method DOMHTMLImageElement::set_is_map
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_is_map" webkit_dom_html_image_element_set_is_map :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLImageElementSetIsMap ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetIsMap _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_image_element_set_is_map _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLImageElementSetIsMapMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetIsMapMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetIsMap

-- method DOMHTMLImageElement::set_long_desc
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_long_desc" webkit_dom_html_image_element_set_long_desc :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLImageElementSetLongDesc ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetLongDesc _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_image_element_set_long_desc _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLImageElementSetLongDescMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetLongDescMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetLongDesc

-- method DOMHTMLImageElement::set_lowsrc
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_lowsrc" webkit_dom_html_image_element_set_lowsrc :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLImageElementSetLowsrc ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetLowsrc _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_image_element_set_lowsrc _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLImageElementSetLowsrcMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetLowsrcMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetLowsrc

-- method DOMHTMLImageElement::set_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_name" webkit_dom_html_image_element_set_name :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLImageElementSetName ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetName _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_image_element_set_name _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLImageElementSetNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetNameMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetName

-- method DOMHTMLImageElement::set_src
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_src" webkit_dom_html_image_element_set_src :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLImageElementSetSrc ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetSrc _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_image_element_set_src _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLImageElementSetSrcMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetSrcMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetSrc

-- method DOMHTMLImageElement::set_use_map
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_use_map" webkit_dom_html_image_element_set_use_map :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLImageElementSetUseMap ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetUseMap _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_image_element_set_use_map _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLImageElementSetUseMapMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetUseMapMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetUseMap

-- method DOMHTMLImageElement::set_vspace
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TLong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_vspace" webkit_dom_html_image_element_set_vspace :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CLong ->                                -- value : TBasicType TLong
    IO ()


dOMHTMLImageElementSetVspace ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> CLong                                -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetVspace _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_image_element_set_vspace _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLImageElementSetVspaceMethodInfo
instance (signature ~ (CLong -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetVspaceMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetVspace

-- method DOMHTMLImageElement::set_width
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLImageElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TLong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_image_element_set_width" webkit_dom_html_image_element_set_width :: 
    Ptr DOMHTMLImageElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLImageElement"
    CLong ->                                -- value : TBasicType TLong
    IO ()


dOMHTMLImageElementSetWidth ::
    (MonadIO m, DOMHTMLImageElementK a) =>
    a                                       -- _obj
    -> CLong                                -- value
    -> m ()                                 -- result
dOMHTMLImageElementSetWidth _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_image_element_set_width _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLImageElementSetWidthMethodInfo
instance (signature ~ (CLong -> m ()), MonadIO m, DOMHTMLImageElementK a) => MethodInfo DOMHTMLImageElementSetWidthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLImageElementSetWidth


