

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLInputElement
    ( 

-- * Exported types
    DOMHTMLInputElement(..)                 ,
    DOMHTMLInputElementK                    ,
    toDOMHTMLInputElement                   ,
    noDOMHTMLInputElement                   ,


 -- * Methods
-- ** dOMHTMLInputElementGetAccept
    DOMHTMLInputElementGetAcceptMethodInfo  ,
    dOMHTMLInputElementGetAccept            ,


-- ** dOMHTMLInputElementGetAlign
    DOMHTMLInputElementGetAlignMethodInfo   ,
    dOMHTMLInputElementGetAlign             ,


-- ** dOMHTMLInputElementGetAlt
    DOMHTMLInputElementGetAltMethodInfo     ,
    dOMHTMLInputElementGetAlt               ,


-- ** dOMHTMLInputElementGetAutofocus
    DOMHTMLInputElementGetAutofocusMethodInfo,
    dOMHTMLInputElementGetAutofocus         ,


-- ** dOMHTMLInputElementGetCapture
    DOMHTMLInputElementGetCaptureMethodInfo ,
    dOMHTMLInputElementGetCapture           ,


-- ** dOMHTMLInputElementGetChecked
    DOMHTMLInputElementGetCheckedMethodInfo ,
    dOMHTMLInputElementGetChecked           ,


-- ** dOMHTMLInputElementGetDefaultChecked
    DOMHTMLInputElementGetDefaultCheckedMethodInfo,
    dOMHTMLInputElementGetDefaultChecked    ,


-- ** dOMHTMLInputElementGetDefaultValue
    DOMHTMLInputElementGetDefaultValueMethodInfo,
    dOMHTMLInputElementGetDefaultValue      ,


-- ** dOMHTMLInputElementGetDisabled
    DOMHTMLInputElementGetDisabledMethodInfo,
    dOMHTMLInputElementGetDisabled          ,


-- ** dOMHTMLInputElementGetFiles
    DOMHTMLInputElementGetFilesMethodInfo   ,
    dOMHTMLInputElementGetFiles             ,


-- ** dOMHTMLInputElementGetForm
    DOMHTMLInputElementGetFormMethodInfo    ,
    dOMHTMLInputElementGetForm              ,


-- ** dOMHTMLInputElementGetHeight
    DOMHTMLInputElementGetHeightMethodInfo  ,
    dOMHTMLInputElementGetHeight            ,


-- ** dOMHTMLInputElementGetIndeterminate
    DOMHTMLInputElementGetIndeterminateMethodInfo,
    dOMHTMLInputElementGetIndeterminate     ,


-- ** dOMHTMLInputElementGetInputType
    DOMHTMLInputElementGetInputTypeMethodInfo,
    dOMHTMLInputElementGetInputType         ,


-- ** dOMHTMLInputElementGetMaxLength
    DOMHTMLInputElementGetMaxLengthMethodInfo,
    dOMHTMLInputElementGetMaxLength         ,


-- ** dOMHTMLInputElementGetMultiple
    DOMHTMLInputElementGetMultipleMethodInfo,
    dOMHTMLInputElementGetMultiple          ,


-- ** dOMHTMLInputElementGetName
    DOMHTMLInputElementGetNameMethodInfo    ,
    dOMHTMLInputElementGetName              ,


-- ** dOMHTMLInputElementGetSize
    DOMHTMLInputElementGetSizeMethodInfo    ,
    dOMHTMLInputElementGetSize              ,


-- ** dOMHTMLInputElementGetSrc
    DOMHTMLInputElementGetSrcMethodInfo     ,
    dOMHTMLInputElementGetSrc               ,


-- ** dOMHTMLInputElementGetUseMap
    DOMHTMLInputElementGetUseMapMethodInfo  ,
    dOMHTMLInputElementGetUseMap            ,


-- ** dOMHTMLInputElementGetValue
    DOMHTMLInputElementGetValueMethodInfo   ,
    dOMHTMLInputElementGetValue             ,


-- ** dOMHTMLInputElementGetWidth
    DOMHTMLInputElementGetWidthMethodInfo   ,
    dOMHTMLInputElementGetWidth             ,


-- ** dOMHTMLInputElementGetWillValidate
    DOMHTMLInputElementGetWillValidateMethodInfo,
    dOMHTMLInputElementGetWillValidate      ,


-- ** dOMHTMLInputElementIsEdited
    DOMHTMLInputElementIsEditedMethodInfo   ,
    dOMHTMLInputElementIsEdited             ,


-- ** dOMHTMLInputElementSelect
    DOMHTMLInputElementSelectMethodInfo     ,
    dOMHTMLInputElementSelect               ,


-- ** dOMHTMLInputElementSetAccept
    DOMHTMLInputElementSetAcceptMethodInfo  ,
    dOMHTMLInputElementSetAccept            ,


-- ** dOMHTMLInputElementSetAlign
    DOMHTMLInputElementSetAlignMethodInfo   ,
    dOMHTMLInputElementSetAlign             ,


-- ** dOMHTMLInputElementSetAlt
    DOMHTMLInputElementSetAltMethodInfo     ,
    dOMHTMLInputElementSetAlt               ,


-- ** dOMHTMLInputElementSetAutofocus
    DOMHTMLInputElementSetAutofocusMethodInfo,
    dOMHTMLInputElementSetAutofocus         ,


-- ** dOMHTMLInputElementSetChecked
    DOMHTMLInputElementSetCheckedMethodInfo ,
    dOMHTMLInputElementSetChecked           ,


-- ** dOMHTMLInputElementSetDefaultValue
    DOMHTMLInputElementSetDefaultValueMethodInfo,
    dOMHTMLInputElementSetDefaultValue      ,


-- ** dOMHTMLInputElementSetDisabled
    DOMHTMLInputElementSetDisabledMethodInfo,
    dOMHTMLInputElementSetDisabled          ,


-- ** dOMHTMLInputElementSetFiles
    DOMHTMLInputElementSetFilesMethodInfo   ,
    dOMHTMLInputElementSetFiles             ,


-- ** dOMHTMLInputElementSetHeight
    DOMHTMLInputElementSetHeightMethodInfo  ,
    dOMHTMLInputElementSetHeight            ,


-- ** dOMHTMLInputElementSetIndeterminate
    DOMHTMLInputElementSetIndeterminateMethodInfo,
    dOMHTMLInputElementSetIndeterminate     ,


-- ** dOMHTMLInputElementSetInputType
    DOMHTMLInputElementSetInputTypeMethodInfo,
    dOMHTMLInputElementSetInputType         ,


-- ** dOMHTMLInputElementSetMaxLength
    DOMHTMLInputElementSetMaxLengthMethodInfo,
    dOMHTMLInputElementSetMaxLength         ,


-- ** dOMHTMLInputElementSetMultiple
    DOMHTMLInputElementSetMultipleMethodInfo,
    dOMHTMLInputElementSetMultiple          ,


-- ** dOMHTMLInputElementSetName
    DOMHTMLInputElementSetNameMethodInfo    ,
    dOMHTMLInputElementSetName              ,


-- ** dOMHTMLInputElementSetReadOnly
    DOMHTMLInputElementSetReadOnlyMethodInfo,
    dOMHTMLInputElementSetReadOnly          ,


-- ** dOMHTMLInputElementSetSize
    DOMHTMLInputElementSetSizeMethodInfo    ,
    dOMHTMLInputElementSetSize              ,


-- ** dOMHTMLInputElementSetSrc
    DOMHTMLInputElementSetSrcMethodInfo     ,
    dOMHTMLInputElementSetSrc               ,


-- ** dOMHTMLInputElementSetUseMap
    DOMHTMLInputElementSetUseMapMethodInfo  ,
    dOMHTMLInputElementSetUseMap            ,


-- ** dOMHTMLInputElementSetValue
    DOMHTMLInputElementSetValueMethodInfo   ,
    dOMHTMLInputElementSetValue             ,


-- ** dOMHTMLInputElementSetWidth
    DOMHTMLInputElementSetWidthMethodInfo   ,
    dOMHTMLInputElementSetWidth             ,




 -- * Properties
-- ** Accept
    DOMHTMLInputElementAcceptPropertyInfo   ,
    constructDOMHTMLInputElementAccept      ,
    dOMHTMLInputElementAccept               ,
    getDOMHTMLInputElementAccept            ,
    setDOMHTMLInputElementAccept            ,


-- ** Align
    DOMHTMLInputElementAlignPropertyInfo    ,
    constructDOMHTMLInputElementAlign       ,
    dOMHTMLInputElementAlign                ,
    getDOMHTMLInputElementAlign             ,
    setDOMHTMLInputElementAlign             ,


-- ** Alt
    DOMHTMLInputElementAltPropertyInfo      ,
    constructDOMHTMLInputElementAlt         ,
    dOMHTMLInputElementAlt                  ,
    getDOMHTMLInputElementAlt               ,
    setDOMHTMLInputElementAlt               ,


-- ** Autocapitalize
    DOMHTMLInputElementAutocapitalizePropertyInfo,
    clearDOMHTMLInputElementAutocapitalize  ,
    constructDOMHTMLInputElementAutocapitalize,
    dOMHTMLInputElementAutocapitalize       ,
    getDOMHTMLInputElementAutocapitalize    ,
    setDOMHTMLInputElementAutocapitalize    ,


-- ** Autocomplete
    DOMHTMLInputElementAutocompletePropertyInfo,
    clearDOMHTMLInputElementAutocomplete    ,
    constructDOMHTMLInputElementAutocomplete,
    dOMHTMLInputElementAutocomplete         ,
    getDOMHTMLInputElementAutocomplete      ,
    setDOMHTMLInputElementAutocomplete      ,


-- ** Autocorrect
    DOMHTMLInputElementAutocorrectPropertyInfo,
    constructDOMHTMLInputElementAutocorrect ,
    dOMHTMLInputElementAutocorrect          ,
    getDOMHTMLInputElementAutocorrect       ,
    setDOMHTMLInputElementAutocorrect       ,


-- ** Autofocus
    DOMHTMLInputElementAutofocusPropertyInfo,
    constructDOMHTMLInputElementAutofocus   ,
    dOMHTMLInputElementAutofocus            ,
    getDOMHTMLInputElementAutofocus         ,
    setDOMHTMLInputElementAutofocus         ,


-- ** Capture
    DOMHTMLInputElementCapturePropertyInfo  ,
    constructDOMHTMLInputElementCapture     ,
    dOMHTMLInputElementCapture              ,
    getDOMHTMLInputElementCapture           ,
    setDOMHTMLInputElementCapture           ,


-- ** Checked
    DOMHTMLInputElementCheckedPropertyInfo  ,
    constructDOMHTMLInputElementChecked     ,
    dOMHTMLInputElementChecked              ,
    getDOMHTMLInputElementChecked           ,
    setDOMHTMLInputElementChecked           ,


-- ** DefaultChecked
    DOMHTMLInputElementDefaultCheckedPropertyInfo,
    constructDOMHTMLInputElementDefaultChecked,
    dOMHTMLInputElementDefaultChecked       ,
    getDOMHTMLInputElementDefaultChecked    ,
    setDOMHTMLInputElementDefaultChecked    ,


-- ** DefaultValue
    DOMHTMLInputElementDefaultValuePropertyInfo,
    constructDOMHTMLInputElementDefaultValue,
    dOMHTMLInputElementDefaultValue         ,
    getDOMHTMLInputElementDefaultValue      ,
    setDOMHTMLInputElementDefaultValue      ,


-- ** DirName
    DOMHTMLInputElementDirNamePropertyInfo  ,
    clearDOMHTMLInputElementDirName         ,
    constructDOMHTMLInputElementDirName     ,
    dOMHTMLInputElementDirName              ,
    getDOMHTMLInputElementDirName           ,
    setDOMHTMLInputElementDirName           ,


-- ** Disabled
    DOMHTMLInputElementDisabledPropertyInfo ,
    constructDOMHTMLInputElementDisabled    ,
    dOMHTMLInputElementDisabled             ,
    getDOMHTMLInputElementDisabled          ,
    setDOMHTMLInputElementDisabled          ,


-- ** Files
    DOMHTMLInputElementFilesPropertyInfo    ,
    dOMHTMLInputElementFiles                ,
    getDOMHTMLInputElementFiles             ,


-- ** Form
    DOMHTMLInputElementFormPropertyInfo     ,
    dOMHTMLInputElementForm                 ,
    getDOMHTMLInputElementForm              ,


-- ** FormAction
    DOMHTMLInputElementFormActionPropertyInfo,
    clearDOMHTMLInputElementFormAction      ,
    constructDOMHTMLInputElementFormAction  ,
    dOMHTMLInputElementFormAction           ,
    getDOMHTMLInputElementFormAction        ,
    setDOMHTMLInputElementFormAction        ,


-- ** FormEnctype
    DOMHTMLInputElementFormEnctypePropertyInfo,
    clearDOMHTMLInputElementFormEnctype     ,
    constructDOMHTMLInputElementFormEnctype ,
    dOMHTMLInputElementFormEnctype          ,
    getDOMHTMLInputElementFormEnctype       ,
    setDOMHTMLInputElementFormEnctype       ,


-- ** FormMethod
    DOMHTMLInputElementFormMethodPropertyInfo,
    clearDOMHTMLInputElementFormMethod      ,
    constructDOMHTMLInputElementFormMethod  ,
    dOMHTMLInputElementFormMethod           ,
    getDOMHTMLInputElementFormMethod        ,
    setDOMHTMLInputElementFormMethod        ,


-- ** FormNoValidate
    DOMHTMLInputElementFormNoValidatePropertyInfo,
    constructDOMHTMLInputElementFormNoValidate,
    dOMHTMLInputElementFormNoValidate       ,
    getDOMHTMLInputElementFormNoValidate    ,
    setDOMHTMLInputElementFormNoValidate    ,


-- ** FormTarget
    DOMHTMLInputElementFormTargetPropertyInfo,
    clearDOMHTMLInputElementFormTarget      ,
    constructDOMHTMLInputElementFormTarget  ,
    dOMHTMLInputElementFormTarget           ,
    getDOMHTMLInputElementFormTarget        ,
    setDOMHTMLInputElementFormTarget        ,


-- ** Height
    DOMHTMLInputElementHeightPropertyInfo   ,
    constructDOMHTMLInputElementHeight      ,
    dOMHTMLInputElementHeight               ,
    getDOMHTMLInputElementHeight            ,
    setDOMHTMLInputElementHeight            ,


-- ** Incremental
    DOMHTMLInputElementIncrementalPropertyInfo,
    constructDOMHTMLInputElementIncremental ,
    dOMHTMLInputElementIncremental          ,
    getDOMHTMLInputElementIncremental       ,
    setDOMHTMLInputElementIncremental       ,


-- ** Indeterminate
    DOMHTMLInputElementIndeterminatePropertyInfo,
    constructDOMHTMLInputElementIndeterminate,
    dOMHTMLInputElementIndeterminate        ,
    getDOMHTMLInputElementIndeterminate     ,
    setDOMHTMLInputElementIndeterminate     ,


-- ** Labels
    DOMHTMLInputElementLabelsPropertyInfo   ,
    dOMHTMLInputElementLabels               ,
    getDOMHTMLInputElementLabels            ,


-- ** List
    DOMHTMLInputElementListPropertyInfo     ,
    dOMHTMLInputElementList                 ,
    getDOMHTMLInputElementList              ,


-- ** Max
    DOMHTMLInputElementMaxPropertyInfo      ,
    clearDOMHTMLInputElementMax             ,
    constructDOMHTMLInputElementMax         ,
    dOMHTMLInputElementMax                  ,
    getDOMHTMLInputElementMax               ,
    setDOMHTMLInputElementMax               ,


-- ** MaxLength
    DOMHTMLInputElementMaxLengthPropertyInfo,
    constructDOMHTMLInputElementMaxLength   ,
    dOMHTMLInputElementMaxLength            ,
    getDOMHTMLInputElementMaxLength         ,
    setDOMHTMLInputElementMaxLength         ,


-- ** Min
    DOMHTMLInputElementMinPropertyInfo      ,
    clearDOMHTMLInputElementMin             ,
    constructDOMHTMLInputElementMin         ,
    dOMHTMLInputElementMin                  ,
    getDOMHTMLInputElementMin               ,
    setDOMHTMLInputElementMin               ,


-- ** Multiple
    DOMHTMLInputElementMultiplePropertyInfo ,
    constructDOMHTMLInputElementMultiple    ,
    dOMHTMLInputElementMultiple             ,
    getDOMHTMLInputElementMultiple          ,
    setDOMHTMLInputElementMultiple          ,


-- ** Name
    DOMHTMLInputElementNamePropertyInfo     ,
    constructDOMHTMLInputElementName        ,
    dOMHTMLInputElementName                 ,
    getDOMHTMLInputElementName              ,
    setDOMHTMLInputElementName              ,


-- ** Pattern
    DOMHTMLInputElementPatternPropertyInfo  ,
    clearDOMHTMLInputElementPattern         ,
    constructDOMHTMLInputElementPattern     ,
    dOMHTMLInputElementPattern              ,
    getDOMHTMLInputElementPattern           ,
    setDOMHTMLInputElementPattern           ,


-- ** Placeholder
    DOMHTMLInputElementPlaceholderPropertyInfo,
    clearDOMHTMLInputElementPlaceholder     ,
    constructDOMHTMLInputElementPlaceholder ,
    dOMHTMLInputElementPlaceholder          ,
    getDOMHTMLInputElementPlaceholder       ,
    setDOMHTMLInputElementPlaceholder       ,


-- ** ReadOnly
    DOMHTMLInputElementReadOnlyPropertyInfo ,
    constructDOMHTMLInputElementReadOnly    ,
    dOMHTMLInputElementReadOnly             ,
    getDOMHTMLInputElementReadOnly          ,
    setDOMHTMLInputElementReadOnly          ,


-- ** Required
    DOMHTMLInputElementRequiredPropertyInfo ,
    constructDOMHTMLInputElementRequired    ,
    dOMHTMLInputElementRequired             ,
    getDOMHTMLInputElementRequired          ,
    setDOMHTMLInputElementRequired          ,


-- ** Size
    DOMHTMLInputElementSizePropertyInfo     ,
    constructDOMHTMLInputElementSize        ,
    dOMHTMLInputElementSize                 ,
    getDOMHTMLInputElementSize              ,
    setDOMHTMLInputElementSize              ,


-- ** Src
    DOMHTMLInputElementSrcPropertyInfo      ,
    constructDOMHTMLInputElementSrc         ,
    dOMHTMLInputElementSrc                  ,
    getDOMHTMLInputElementSrc               ,
    setDOMHTMLInputElementSrc               ,


-- ** Step
    DOMHTMLInputElementStepPropertyInfo     ,
    clearDOMHTMLInputElementStep            ,
    constructDOMHTMLInputElementStep        ,
    dOMHTMLInputElementStep                 ,
    getDOMHTMLInputElementStep              ,
    setDOMHTMLInputElementStep              ,


-- ** Type
    DOMHTMLInputElementTypePropertyInfo     ,
    clearDOMHTMLInputElementType            ,
    constructDOMHTMLInputElementType        ,
    dOMHTMLInputElementType                 ,
    getDOMHTMLInputElementType              ,
    setDOMHTMLInputElementType              ,


-- ** UseMap
    DOMHTMLInputElementUseMapPropertyInfo   ,
    constructDOMHTMLInputElementUseMap      ,
    dOMHTMLInputElementUseMap               ,
    getDOMHTMLInputElementUseMap            ,
    setDOMHTMLInputElementUseMap            ,


-- ** ValidationMessage
    DOMHTMLInputElementValidationMessagePropertyInfo,
    dOMHTMLInputElementValidationMessage    ,
    getDOMHTMLInputElementValidationMessage ,


-- ** Value
    DOMHTMLInputElementValuePropertyInfo    ,
    constructDOMHTMLInputElementValue       ,
    dOMHTMLInputElementValue                ,
    getDOMHTMLInputElementValue             ,
    setDOMHTMLInputElementValue             ,


-- ** ValueAsNumber
    DOMHTMLInputElementValueAsNumberPropertyInfo,
    constructDOMHTMLInputElementValueAsNumber,
    dOMHTMLInputElementValueAsNumber        ,
    getDOMHTMLInputElementValueAsNumber     ,
    setDOMHTMLInputElementValueAsNumber     ,


-- ** Width
    DOMHTMLInputElementWidthPropertyInfo    ,
    constructDOMHTMLInputElementWidth       ,
    dOMHTMLInputElementWidth                ,
    getDOMHTMLInputElementWidth             ,
    setDOMHTMLInputElementWidth             ,


-- ** WillValidate
    DOMHTMLInputElementWillValidatePropertyInfo,
    dOMHTMLInputElementWillValidate         ,
    getDOMHTMLInputElementWillValidate      ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLInputElement = DOMHTMLInputElement (ForeignPtr DOMHTMLInputElement)
foreign import ccall "webkit_dom_html_input_element_get_type"
    c_webkit_dom_html_input_element_get_type :: IO GType

type instance ParentTypes DOMHTMLInputElement = DOMHTMLInputElementParentTypes
type DOMHTMLInputElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLInputElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_input_element_get_type
    

class GObject o => DOMHTMLInputElementK o
instance (GObject o, IsDescendantOf DOMHTMLInputElement o) => DOMHTMLInputElementK o

toDOMHTMLInputElement :: DOMHTMLInputElementK o => o -> IO DOMHTMLInputElement
toDOMHTMLInputElement = unsafeCastTo DOMHTMLInputElement

noDOMHTMLInputElement :: Maybe DOMHTMLInputElement
noDOMHTMLInputElement = Nothing

type family ResolveDOMHTMLInputElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLInputElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLInputElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLInputElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLInputElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLInputElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLInputElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLInputElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLInputElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLInputElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLInputElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLInputElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLInputElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLInputElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLInputElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLInputElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLInputElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLInputElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLInputElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLInputElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLInputElementMethod "isEdited" o = DOMHTMLInputElementIsEditedMethodInfo
    ResolveDOMHTMLInputElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLInputElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLInputElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLInputElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLInputElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLInputElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLInputElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLInputElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLInputElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLInputElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLInputElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLInputElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLInputElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLInputElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLInputElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLInputElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLInputElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLInputElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLInputElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLInputElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLInputElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLInputElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLInputElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLInputElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLInputElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLInputElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLInputElementMethod "select" o = DOMHTMLInputElementSelectMethodInfo
    ResolveDOMHTMLInputElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLInputElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLInputElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLInputElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLInputElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLInputElementMethod "getAccept" o = DOMHTMLInputElementGetAcceptMethodInfo
    ResolveDOMHTMLInputElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLInputElementMethod "getAlign" o = DOMHTMLInputElementGetAlignMethodInfo
    ResolveDOMHTMLInputElementMethod "getAlt" o = DOMHTMLInputElementGetAltMethodInfo
    ResolveDOMHTMLInputElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLInputElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLInputElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLInputElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLInputElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLInputElementMethod "getAutofocus" o = DOMHTMLInputElementGetAutofocusMethodInfo
    ResolveDOMHTMLInputElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLInputElementMethod "getCapture" o = DOMHTMLInputElementGetCaptureMethodInfo
    ResolveDOMHTMLInputElementMethod "getChecked" o = DOMHTMLInputElementGetCheckedMethodInfo
    ResolveDOMHTMLInputElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLInputElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLInputElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLInputElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLInputElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLInputElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLInputElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLInputElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLInputElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLInputElementMethod "getDefaultChecked" o = DOMHTMLInputElementGetDefaultCheckedMethodInfo
    ResolveDOMHTMLInputElementMethod "getDefaultValue" o = DOMHTMLInputElementGetDefaultValueMethodInfo
    ResolveDOMHTMLInputElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLInputElementMethod "getDisabled" o = DOMHTMLInputElementGetDisabledMethodInfo
    ResolveDOMHTMLInputElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLInputElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLInputElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLInputElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLInputElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLInputElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLInputElementMethod "getFiles" o = DOMHTMLInputElementGetFilesMethodInfo
    ResolveDOMHTMLInputElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLInputElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLInputElementMethod "getForm" o = DOMHTMLInputElementGetFormMethodInfo
    ResolveDOMHTMLInputElementMethod "getHeight" o = DOMHTMLInputElementGetHeightMethodInfo
    ResolveDOMHTMLInputElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLInputElementMethod "getIndeterminate" o = DOMHTMLInputElementGetIndeterminateMethodInfo
    ResolveDOMHTMLInputElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLInputElementMethod "getInputType" o = DOMHTMLInputElementGetInputTypeMethodInfo
    ResolveDOMHTMLInputElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLInputElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLInputElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLInputElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLInputElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLInputElementMethod "getMaxLength" o = DOMHTMLInputElementGetMaxLengthMethodInfo
    ResolveDOMHTMLInputElementMethod "getMultiple" o = DOMHTMLInputElementGetMultipleMethodInfo
    ResolveDOMHTMLInputElementMethod "getName" o = DOMHTMLInputElementGetNameMethodInfo
    ResolveDOMHTMLInputElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLInputElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLInputElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLInputElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLInputElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLInputElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLInputElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLInputElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLInputElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLInputElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLInputElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLInputElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLInputElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLInputElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLInputElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLInputElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLInputElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLInputElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLInputElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLInputElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLInputElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLInputElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLInputElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLInputElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLInputElementMethod "getSize" o = DOMHTMLInputElementGetSizeMethodInfo
    ResolveDOMHTMLInputElementMethod "getSrc" o = DOMHTMLInputElementGetSrcMethodInfo
    ResolveDOMHTMLInputElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLInputElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLInputElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLInputElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLInputElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLInputElementMethod "getUseMap" o = DOMHTMLInputElementGetUseMapMethodInfo
    ResolveDOMHTMLInputElementMethod "getValue" o = DOMHTMLInputElementGetValueMethodInfo
    ResolveDOMHTMLInputElementMethod "getWidth" o = DOMHTMLInputElementGetWidthMethodInfo
    ResolveDOMHTMLInputElementMethod "getWillValidate" o = DOMHTMLInputElementGetWillValidateMethodInfo
    ResolveDOMHTMLInputElementMethod "setAccept" o = DOMHTMLInputElementSetAcceptMethodInfo
    ResolveDOMHTMLInputElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLInputElementMethod "setAlign" o = DOMHTMLInputElementSetAlignMethodInfo
    ResolveDOMHTMLInputElementMethod "setAlt" o = DOMHTMLInputElementSetAltMethodInfo
    ResolveDOMHTMLInputElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLInputElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLInputElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLInputElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLInputElementMethod "setAutofocus" o = DOMHTMLInputElementSetAutofocusMethodInfo
    ResolveDOMHTMLInputElementMethod "setChecked" o = DOMHTMLInputElementSetCheckedMethodInfo
    ResolveDOMHTMLInputElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLInputElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLInputElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLInputElementMethod "setDefaultValue" o = DOMHTMLInputElementSetDefaultValueMethodInfo
    ResolveDOMHTMLInputElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLInputElementMethod "setDisabled" o = DOMHTMLInputElementSetDisabledMethodInfo
    ResolveDOMHTMLInputElementMethod "setFiles" o = DOMHTMLInputElementSetFilesMethodInfo
    ResolveDOMHTMLInputElementMethod "setHeight" o = DOMHTMLInputElementSetHeightMethodInfo
    ResolveDOMHTMLInputElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLInputElementMethod "setIndeterminate" o = DOMHTMLInputElementSetIndeterminateMethodInfo
    ResolveDOMHTMLInputElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLInputElementMethod "setInputType" o = DOMHTMLInputElementSetInputTypeMethodInfo
    ResolveDOMHTMLInputElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLInputElementMethod "setMaxLength" o = DOMHTMLInputElementSetMaxLengthMethodInfo
    ResolveDOMHTMLInputElementMethod "setMultiple" o = DOMHTMLInputElementSetMultipleMethodInfo
    ResolveDOMHTMLInputElementMethod "setName" o = DOMHTMLInputElementSetNameMethodInfo
    ResolveDOMHTMLInputElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLInputElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLInputElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLInputElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLInputElementMethod "setReadOnly" o = DOMHTMLInputElementSetReadOnlyMethodInfo
    ResolveDOMHTMLInputElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLInputElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLInputElementMethod "setSize" o = DOMHTMLInputElementSetSizeMethodInfo
    ResolveDOMHTMLInputElementMethod "setSrc" o = DOMHTMLInputElementSetSrcMethodInfo
    ResolveDOMHTMLInputElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLInputElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLInputElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLInputElementMethod "setUseMap" o = DOMHTMLInputElementSetUseMapMethodInfo
    ResolveDOMHTMLInputElementMethod "setValue" o = DOMHTMLInputElementSetValueMethodInfo
    ResolveDOMHTMLInputElementMethod "setWidth" o = DOMHTMLInputElementSetWidthMethodInfo
    ResolveDOMHTMLInputElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLInputElementMethod t DOMHTMLInputElement, MethodInfo info DOMHTMLInputElement p) => IsLabelProxy t (DOMHTMLInputElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLInputElementMethod t DOMHTMLInputElement, MethodInfo info DOMHTMLInputElement p) => IsLabel t (DOMHTMLInputElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "accept"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementAccept :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementAccept obj = liftIO $ getObjectPropertyString obj "accept"

setDOMHTMLInputElementAccept :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementAccept obj val = liftIO $ setObjectPropertyString obj "accept" (Just val)

constructDOMHTMLInputElementAccept :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementAccept val = constructObjectPropertyString "accept" (Just val)

data DOMHTMLInputElementAcceptPropertyInfo
instance AttrInfo DOMHTMLInputElementAcceptPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementAcceptPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementAcceptPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementAcceptPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementAcceptPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementAcceptPropertyInfo = "accept"
    attrGet _ = getDOMHTMLInputElementAccept
    attrSet _ = setDOMHTMLInputElementAccept
    attrConstruct _ = constructDOMHTMLInputElementAccept
    attrClear _ = undefined

-- VVV Prop "align"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementAlign :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementAlign obj = liftIO $ getObjectPropertyString obj "align"

setDOMHTMLInputElementAlign :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementAlign obj val = liftIO $ setObjectPropertyString obj "align" (Just val)

constructDOMHTMLInputElementAlign :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementAlign val = constructObjectPropertyString "align" (Just val)

data DOMHTMLInputElementAlignPropertyInfo
instance AttrInfo DOMHTMLInputElementAlignPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementAlignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementAlignPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementAlignPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementAlignPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementAlignPropertyInfo = "align"
    attrGet _ = getDOMHTMLInputElementAlign
    attrSet _ = setDOMHTMLInputElementAlign
    attrConstruct _ = constructDOMHTMLInputElementAlign
    attrClear _ = undefined

-- VVV Prop "alt"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementAlt :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementAlt obj = liftIO $ getObjectPropertyString obj "alt"

setDOMHTMLInputElementAlt :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementAlt obj val = liftIO $ setObjectPropertyString obj "alt" (Just val)

constructDOMHTMLInputElementAlt :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementAlt val = constructObjectPropertyString "alt" (Just val)

data DOMHTMLInputElementAltPropertyInfo
instance AttrInfo DOMHTMLInputElementAltPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementAltPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementAltPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementAltPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementAltPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementAltPropertyInfo = "alt"
    attrGet _ = getDOMHTMLInputElementAlt
    attrSet _ = setDOMHTMLInputElementAlt
    attrConstruct _ = constructDOMHTMLInputElementAlt
    attrClear _ = undefined

-- VVV Prop "autocapitalize"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementAutocapitalize :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementAutocapitalize obj = liftIO $ getObjectPropertyString obj "autocapitalize"

setDOMHTMLInputElementAutocapitalize :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementAutocapitalize obj val = liftIO $ setObjectPropertyString obj "autocapitalize" (Just val)

constructDOMHTMLInputElementAutocapitalize :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementAutocapitalize val = constructObjectPropertyString "autocapitalize" (Just val)

clearDOMHTMLInputElementAutocapitalize :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementAutocapitalize obj = liftIO $ setObjectPropertyString obj "autocapitalize" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementAutocapitalizePropertyInfo
instance AttrInfo DOMHTMLInputElementAutocapitalizePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementAutocapitalizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementAutocapitalizePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementAutocapitalizePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementAutocapitalizePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementAutocapitalizePropertyInfo = "autocapitalize"
    attrGet _ = getDOMHTMLInputElementAutocapitalize
    attrSet _ = setDOMHTMLInputElementAutocapitalize
    attrConstruct _ = constructDOMHTMLInputElementAutocapitalize
    attrClear _ = clearDOMHTMLInputElementAutocapitalize

-- VVV Prop "autocomplete"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementAutocomplete :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementAutocomplete obj = liftIO $ getObjectPropertyString obj "autocomplete"

setDOMHTMLInputElementAutocomplete :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementAutocomplete obj val = liftIO $ setObjectPropertyString obj "autocomplete" (Just val)

constructDOMHTMLInputElementAutocomplete :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementAutocomplete val = constructObjectPropertyString "autocomplete" (Just val)

clearDOMHTMLInputElementAutocomplete :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementAutocomplete obj = liftIO $ setObjectPropertyString obj "autocomplete" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementAutocompletePropertyInfo
instance AttrInfo DOMHTMLInputElementAutocompletePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementAutocompletePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementAutocompletePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementAutocompletePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementAutocompletePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementAutocompletePropertyInfo = "autocomplete"
    attrGet _ = getDOMHTMLInputElementAutocomplete
    attrSet _ = setDOMHTMLInputElementAutocomplete
    attrConstruct _ = constructDOMHTMLInputElementAutocomplete
    attrClear _ = clearDOMHTMLInputElementAutocomplete

-- VVV Prop "autocorrect"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementAutocorrect :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementAutocorrect obj = liftIO $ getObjectPropertyBool obj "autocorrect"

setDOMHTMLInputElementAutocorrect :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementAutocorrect obj val = liftIO $ setObjectPropertyBool obj "autocorrect" val

constructDOMHTMLInputElementAutocorrect :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementAutocorrect val = constructObjectPropertyBool "autocorrect" val

data DOMHTMLInputElementAutocorrectPropertyInfo
instance AttrInfo DOMHTMLInputElementAutocorrectPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementAutocorrectPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementAutocorrectPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementAutocorrectPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementAutocorrectPropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementAutocorrectPropertyInfo = "autocorrect"
    attrGet _ = getDOMHTMLInputElementAutocorrect
    attrSet _ = setDOMHTMLInputElementAutocorrect
    attrConstruct _ = constructDOMHTMLInputElementAutocorrect
    attrClear _ = undefined

-- VVV Prop "autofocus"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLInputElementAutofocus :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementAutofocus obj = liftIO $ getObjectPropertyBool obj "autofocus"

setDOMHTMLInputElementAutofocus :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementAutofocus obj val = liftIO $ setObjectPropertyBool obj "autofocus" val

constructDOMHTMLInputElementAutofocus :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementAutofocus val = constructObjectPropertyBool "autofocus" val

data DOMHTMLInputElementAutofocusPropertyInfo
instance AttrInfo DOMHTMLInputElementAutofocusPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementAutofocusPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementAutofocusPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementAutofocusPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementAutofocusPropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementAutofocusPropertyInfo = "autofocus"
    attrGet _ = getDOMHTMLInputElementAutofocus
    attrSet _ = setDOMHTMLInputElementAutofocus
    attrConstruct _ = constructDOMHTMLInputElementAutofocus
    attrClear _ = undefined

-- VVV Prop "capture"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLInputElementCapture :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementCapture obj = liftIO $ getObjectPropertyBool obj "capture"

setDOMHTMLInputElementCapture :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementCapture obj val = liftIO $ setObjectPropertyBool obj "capture" val

constructDOMHTMLInputElementCapture :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementCapture val = constructObjectPropertyBool "capture" val

data DOMHTMLInputElementCapturePropertyInfo
instance AttrInfo DOMHTMLInputElementCapturePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementCapturePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementCapturePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementCapturePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementCapturePropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementCapturePropertyInfo = "capture"
    attrGet _ = getDOMHTMLInputElementCapture
    attrSet _ = setDOMHTMLInputElementCapture
    attrConstruct _ = constructDOMHTMLInputElementCapture
    attrClear _ = undefined

-- VVV Prop "checked"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLInputElementChecked :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementChecked obj = liftIO $ getObjectPropertyBool obj "checked"

setDOMHTMLInputElementChecked :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementChecked obj val = liftIO $ setObjectPropertyBool obj "checked" val

constructDOMHTMLInputElementChecked :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementChecked val = constructObjectPropertyBool "checked" val

data DOMHTMLInputElementCheckedPropertyInfo
instance AttrInfo DOMHTMLInputElementCheckedPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementCheckedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementCheckedPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementCheckedPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementCheckedPropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementCheckedPropertyInfo = "checked"
    attrGet _ = getDOMHTMLInputElementChecked
    attrSet _ = setDOMHTMLInputElementChecked
    attrConstruct _ = constructDOMHTMLInputElementChecked
    attrClear _ = undefined

-- VVV Prop "default-checked"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLInputElementDefaultChecked :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementDefaultChecked obj = liftIO $ getObjectPropertyBool obj "default-checked"

setDOMHTMLInputElementDefaultChecked :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementDefaultChecked obj val = liftIO $ setObjectPropertyBool obj "default-checked" val

constructDOMHTMLInputElementDefaultChecked :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementDefaultChecked val = constructObjectPropertyBool "default-checked" val

data DOMHTMLInputElementDefaultCheckedPropertyInfo
instance AttrInfo DOMHTMLInputElementDefaultCheckedPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementDefaultCheckedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementDefaultCheckedPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementDefaultCheckedPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementDefaultCheckedPropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementDefaultCheckedPropertyInfo = "default-checked"
    attrGet _ = getDOMHTMLInputElementDefaultChecked
    attrSet _ = setDOMHTMLInputElementDefaultChecked
    attrConstruct _ = constructDOMHTMLInputElementDefaultChecked
    attrClear _ = undefined

-- VVV Prop "default-value"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementDefaultValue :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementDefaultValue obj = liftIO $ getObjectPropertyString obj "default-value"

setDOMHTMLInputElementDefaultValue :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementDefaultValue obj val = liftIO $ setObjectPropertyString obj "default-value" (Just val)

constructDOMHTMLInputElementDefaultValue :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementDefaultValue val = constructObjectPropertyString "default-value" (Just val)

data DOMHTMLInputElementDefaultValuePropertyInfo
instance AttrInfo DOMHTMLInputElementDefaultValuePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementDefaultValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementDefaultValuePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementDefaultValuePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementDefaultValuePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementDefaultValuePropertyInfo = "default-value"
    attrGet _ = getDOMHTMLInputElementDefaultValue
    attrSet _ = setDOMHTMLInputElementDefaultValue
    attrConstruct _ = constructDOMHTMLInputElementDefaultValue
    attrClear _ = undefined

-- VVV Prop "dir-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementDirName :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementDirName obj = liftIO $ getObjectPropertyString obj "dir-name"

setDOMHTMLInputElementDirName :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementDirName obj val = liftIO $ setObjectPropertyString obj "dir-name" (Just val)

constructDOMHTMLInputElementDirName :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementDirName val = constructObjectPropertyString "dir-name" (Just val)

clearDOMHTMLInputElementDirName :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementDirName obj = liftIO $ setObjectPropertyString obj "dir-name" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementDirNamePropertyInfo
instance AttrInfo DOMHTMLInputElementDirNamePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementDirNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementDirNamePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementDirNamePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementDirNamePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementDirNamePropertyInfo = "dir-name"
    attrGet _ = getDOMHTMLInputElementDirName
    attrSet _ = setDOMHTMLInputElementDirName
    attrConstruct _ = constructDOMHTMLInputElementDirName
    attrClear _ = clearDOMHTMLInputElementDirName

-- VVV Prop "disabled"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLInputElementDisabled :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementDisabled obj = liftIO $ getObjectPropertyBool obj "disabled"

setDOMHTMLInputElementDisabled :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementDisabled obj val = liftIO $ setObjectPropertyBool obj "disabled" val

constructDOMHTMLInputElementDisabled :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementDisabled val = constructObjectPropertyBool "disabled" val

data DOMHTMLInputElementDisabledPropertyInfo
instance AttrInfo DOMHTMLInputElementDisabledPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementDisabledPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementDisabledPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementDisabledPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementDisabledPropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementDisabledPropertyInfo = "disabled"
    attrGet _ = getDOMHTMLInputElementDisabled
    attrSet _ = setDOMHTMLInputElementDisabled
    attrConstruct _ = constructDOMHTMLInputElementDisabled
    attrClear _ = undefined

-- VVV Prop "files"
   -- Type: TInterface "WebKit2WebExtension" "DOMFileList"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementFiles :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe DOMFileList)
getDOMHTMLInputElementFiles obj = liftIO $ getObjectPropertyObject obj "files" DOMFileList

data DOMHTMLInputElementFilesPropertyInfo
instance AttrInfo DOMHTMLInputElementFilesPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementFilesPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementFilesPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLInputElementFilesPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementFilesPropertyInfo = (Maybe DOMFileList)
    type AttrLabel DOMHTMLInputElementFilesPropertyInfo = "files"
    attrGet _ = getDOMHTMLInputElementFiles
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "form"
   -- Type: TInterface "WebKit2WebExtension" "DOMHTMLFormElement"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLInputElementForm :: (MonadIO m, DOMHTMLInputElementK o) => o -> m DOMHTMLFormElement
getDOMHTMLInputElementForm obj = liftIO $ checkUnexpectedNothing "getDOMHTMLInputElementForm" $ getObjectPropertyObject obj "form" DOMHTMLFormElement

data DOMHTMLInputElementFormPropertyInfo
instance AttrInfo DOMHTMLInputElementFormPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementFormPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementFormPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLInputElementFormPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementFormPropertyInfo = DOMHTMLFormElement
    type AttrLabel DOMHTMLInputElementFormPropertyInfo = "form"
    attrGet _ = getDOMHTMLInputElementForm
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "form-action"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementFormAction :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementFormAction obj = liftIO $ getObjectPropertyString obj "form-action"

setDOMHTMLInputElementFormAction :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementFormAction obj val = liftIO $ setObjectPropertyString obj "form-action" (Just val)

constructDOMHTMLInputElementFormAction :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementFormAction val = constructObjectPropertyString "form-action" (Just val)

clearDOMHTMLInputElementFormAction :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementFormAction obj = liftIO $ setObjectPropertyString obj "form-action" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementFormActionPropertyInfo
instance AttrInfo DOMHTMLInputElementFormActionPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementFormActionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementFormActionPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementFormActionPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementFormActionPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementFormActionPropertyInfo = "form-action"
    attrGet _ = getDOMHTMLInputElementFormAction
    attrSet _ = setDOMHTMLInputElementFormAction
    attrConstruct _ = constructDOMHTMLInputElementFormAction
    attrClear _ = clearDOMHTMLInputElementFormAction

-- VVV Prop "form-enctype"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementFormEnctype :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementFormEnctype obj = liftIO $ getObjectPropertyString obj "form-enctype"

setDOMHTMLInputElementFormEnctype :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementFormEnctype obj val = liftIO $ setObjectPropertyString obj "form-enctype" (Just val)

constructDOMHTMLInputElementFormEnctype :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementFormEnctype val = constructObjectPropertyString "form-enctype" (Just val)

clearDOMHTMLInputElementFormEnctype :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementFormEnctype obj = liftIO $ setObjectPropertyString obj "form-enctype" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementFormEnctypePropertyInfo
instance AttrInfo DOMHTMLInputElementFormEnctypePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementFormEnctypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementFormEnctypePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementFormEnctypePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementFormEnctypePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementFormEnctypePropertyInfo = "form-enctype"
    attrGet _ = getDOMHTMLInputElementFormEnctype
    attrSet _ = setDOMHTMLInputElementFormEnctype
    attrConstruct _ = constructDOMHTMLInputElementFormEnctype
    attrClear _ = clearDOMHTMLInputElementFormEnctype

-- VVV Prop "form-method"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementFormMethod :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementFormMethod obj = liftIO $ getObjectPropertyString obj "form-method"

setDOMHTMLInputElementFormMethod :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementFormMethod obj val = liftIO $ setObjectPropertyString obj "form-method" (Just val)

constructDOMHTMLInputElementFormMethod :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementFormMethod val = constructObjectPropertyString "form-method" (Just val)

clearDOMHTMLInputElementFormMethod :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementFormMethod obj = liftIO $ setObjectPropertyString obj "form-method" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementFormMethodPropertyInfo
instance AttrInfo DOMHTMLInputElementFormMethodPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementFormMethodPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementFormMethodPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementFormMethodPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementFormMethodPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementFormMethodPropertyInfo = "form-method"
    attrGet _ = getDOMHTMLInputElementFormMethod
    attrSet _ = setDOMHTMLInputElementFormMethod
    attrConstruct _ = constructDOMHTMLInputElementFormMethod
    attrClear _ = clearDOMHTMLInputElementFormMethod

-- VVV Prop "form-no-validate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementFormNoValidate :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementFormNoValidate obj = liftIO $ getObjectPropertyBool obj "form-no-validate"

setDOMHTMLInputElementFormNoValidate :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementFormNoValidate obj val = liftIO $ setObjectPropertyBool obj "form-no-validate" val

constructDOMHTMLInputElementFormNoValidate :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementFormNoValidate val = constructObjectPropertyBool "form-no-validate" val

data DOMHTMLInputElementFormNoValidatePropertyInfo
instance AttrInfo DOMHTMLInputElementFormNoValidatePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementFormNoValidatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementFormNoValidatePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementFormNoValidatePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementFormNoValidatePropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementFormNoValidatePropertyInfo = "form-no-validate"
    attrGet _ = getDOMHTMLInputElementFormNoValidate
    attrSet _ = setDOMHTMLInputElementFormNoValidate
    attrConstruct _ = constructDOMHTMLInputElementFormNoValidate
    attrClear _ = undefined

-- VVV Prop "form-target"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementFormTarget :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementFormTarget obj = liftIO $ getObjectPropertyString obj "form-target"

setDOMHTMLInputElementFormTarget :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementFormTarget obj val = liftIO $ setObjectPropertyString obj "form-target" (Just val)

constructDOMHTMLInputElementFormTarget :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementFormTarget val = constructObjectPropertyString "form-target" (Just val)

clearDOMHTMLInputElementFormTarget :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementFormTarget obj = liftIO $ setObjectPropertyString obj "form-target" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementFormTargetPropertyInfo
instance AttrInfo DOMHTMLInputElementFormTargetPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementFormTargetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementFormTargetPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementFormTargetPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementFormTargetPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementFormTargetPropertyInfo = "form-target"
    attrGet _ = getDOMHTMLInputElementFormTarget
    attrSet _ = setDOMHTMLInputElementFormTarget
    attrConstruct _ = constructDOMHTMLInputElementFormTarget
    attrClear _ = clearDOMHTMLInputElementFormTarget

-- VVV Prop "height"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLInputElementHeight :: (MonadIO m, DOMHTMLInputElementK o) => o -> m CULong
getDOMHTMLInputElementHeight obj = liftIO $ getObjectPropertyULong obj "height"

setDOMHTMLInputElementHeight :: (MonadIO m, DOMHTMLInputElementK o) => o -> CULong -> m ()
setDOMHTMLInputElementHeight obj val = liftIO $ setObjectPropertyULong obj "height" val

constructDOMHTMLInputElementHeight :: CULong -> IO ([Char], GValue)
constructDOMHTMLInputElementHeight val = constructObjectPropertyULong "height" val

data DOMHTMLInputElementHeightPropertyInfo
instance AttrInfo DOMHTMLInputElementHeightPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementHeightPropertyInfo = (~) CULong
    type AttrBaseTypeConstraint DOMHTMLInputElementHeightPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementHeightPropertyInfo = CULong
    type AttrLabel DOMHTMLInputElementHeightPropertyInfo = "height"
    attrGet _ = getDOMHTMLInputElementHeight
    attrSet _ = setDOMHTMLInputElementHeight
    attrConstruct _ = constructDOMHTMLInputElementHeight
    attrClear _ = undefined

-- VVV Prop "incremental"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementIncremental :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementIncremental obj = liftIO $ getObjectPropertyBool obj "incremental"

setDOMHTMLInputElementIncremental :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementIncremental obj val = liftIO $ setObjectPropertyBool obj "incremental" val

constructDOMHTMLInputElementIncremental :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementIncremental val = constructObjectPropertyBool "incremental" val

data DOMHTMLInputElementIncrementalPropertyInfo
instance AttrInfo DOMHTMLInputElementIncrementalPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementIncrementalPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementIncrementalPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementIncrementalPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementIncrementalPropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementIncrementalPropertyInfo = "incremental"
    attrGet _ = getDOMHTMLInputElementIncremental
    attrSet _ = setDOMHTMLInputElementIncremental
    attrConstruct _ = constructDOMHTMLInputElementIncremental
    attrClear _ = undefined

-- VVV Prop "indeterminate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLInputElementIndeterminate :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementIndeterminate obj = liftIO $ getObjectPropertyBool obj "indeterminate"

setDOMHTMLInputElementIndeterminate :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementIndeterminate obj val = liftIO $ setObjectPropertyBool obj "indeterminate" val

constructDOMHTMLInputElementIndeterminate :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementIndeterminate val = constructObjectPropertyBool "indeterminate" val

data DOMHTMLInputElementIndeterminatePropertyInfo
instance AttrInfo DOMHTMLInputElementIndeterminatePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementIndeterminatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementIndeterminatePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementIndeterminatePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementIndeterminatePropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementIndeterminatePropertyInfo = "indeterminate"
    attrGet _ = getDOMHTMLInputElementIndeterminate
    attrSet _ = setDOMHTMLInputElementIndeterminate
    attrConstruct _ = constructDOMHTMLInputElementIndeterminate
    attrClear _ = undefined

-- VVV Prop "labels"
   -- Type: TInterface "WebKit2WebExtension" "DOMNodeList"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementLabels :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe DOMNodeList)
getDOMHTMLInputElementLabels obj = liftIO $ getObjectPropertyObject obj "labels" DOMNodeList

data DOMHTMLInputElementLabelsPropertyInfo
instance AttrInfo DOMHTMLInputElementLabelsPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementLabelsPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementLabelsPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLInputElementLabelsPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementLabelsPropertyInfo = (Maybe DOMNodeList)
    type AttrLabel DOMHTMLInputElementLabelsPropertyInfo = "labels"
    attrGet _ = getDOMHTMLInputElementLabels
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "list"
   -- Type: TInterface "WebKit2WebExtension" "DOMHTMLElement"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementList :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe DOMHTMLElement)
getDOMHTMLInputElementList obj = liftIO $ getObjectPropertyObject obj "list" DOMHTMLElement

data DOMHTMLInputElementListPropertyInfo
instance AttrInfo DOMHTMLInputElementListPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementListPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementListPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLInputElementListPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementListPropertyInfo = (Maybe DOMHTMLElement)
    type AttrLabel DOMHTMLInputElementListPropertyInfo = "list"
    attrGet _ = getDOMHTMLInputElementList
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "max"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementMax :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementMax obj = liftIO $ getObjectPropertyString obj "max"

setDOMHTMLInputElementMax :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementMax obj val = liftIO $ setObjectPropertyString obj "max" (Just val)

constructDOMHTMLInputElementMax :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementMax val = constructObjectPropertyString "max" (Just val)

clearDOMHTMLInputElementMax :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementMax obj = liftIO $ setObjectPropertyString obj "max" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementMaxPropertyInfo
instance AttrInfo DOMHTMLInputElementMaxPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementMaxPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementMaxPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementMaxPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementMaxPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementMaxPropertyInfo = "max"
    attrGet _ = getDOMHTMLInputElementMax
    attrSet _ = setDOMHTMLInputElementMax
    attrConstruct _ = constructDOMHTMLInputElementMax
    attrClear _ = clearDOMHTMLInputElementMax

-- VVV Prop "max-length"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLInputElementMaxLength :: (MonadIO m, DOMHTMLInputElementK o) => o -> m CLong
getDOMHTMLInputElementMaxLength obj = liftIO $ getObjectPropertyLong obj "max-length"

setDOMHTMLInputElementMaxLength :: (MonadIO m, DOMHTMLInputElementK o) => o -> CLong -> m ()
setDOMHTMLInputElementMaxLength obj val = liftIO $ setObjectPropertyLong obj "max-length" val

constructDOMHTMLInputElementMaxLength :: CLong -> IO ([Char], GValue)
constructDOMHTMLInputElementMaxLength val = constructObjectPropertyLong "max-length" val

data DOMHTMLInputElementMaxLengthPropertyInfo
instance AttrInfo DOMHTMLInputElementMaxLengthPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementMaxLengthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementMaxLengthPropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLInputElementMaxLengthPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementMaxLengthPropertyInfo = CLong
    type AttrLabel DOMHTMLInputElementMaxLengthPropertyInfo = "max-length"
    attrGet _ = getDOMHTMLInputElementMaxLength
    attrSet _ = setDOMHTMLInputElementMaxLength
    attrConstruct _ = constructDOMHTMLInputElementMaxLength
    attrClear _ = undefined

-- VVV Prop "min"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementMin :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementMin obj = liftIO $ getObjectPropertyString obj "min"

setDOMHTMLInputElementMin :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementMin obj val = liftIO $ setObjectPropertyString obj "min" (Just val)

constructDOMHTMLInputElementMin :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementMin val = constructObjectPropertyString "min" (Just val)

clearDOMHTMLInputElementMin :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementMin obj = liftIO $ setObjectPropertyString obj "min" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementMinPropertyInfo
instance AttrInfo DOMHTMLInputElementMinPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementMinPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementMinPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementMinPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementMinPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementMinPropertyInfo = "min"
    attrGet _ = getDOMHTMLInputElementMin
    attrSet _ = setDOMHTMLInputElementMin
    attrConstruct _ = constructDOMHTMLInputElementMin
    attrClear _ = clearDOMHTMLInputElementMin

-- VVV Prop "multiple"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLInputElementMultiple :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementMultiple obj = liftIO $ getObjectPropertyBool obj "multiple"

setDOMHTMLInputElementMultiple :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementMultiple obj val = liftIO $ setObjectPropertyBool obj "multiple" val

constructDOMHTMLInputElementMultiple :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementMultiple val = constructObjectPropertyBool "multiple" val

data DOMHTMLInputElementMultiplePropertyInfo
instance AttrInfo DOMHTMLInputElementMultiplePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementMultiplePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementMultiplePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementMultiplePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementMultiplePropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementMultiplePropertyInfo = "multiple"
    attrGet _ = getDOMHTMLInputElementMultiple
    attrSet _ = setDOMHTMLInputElementMultiple
    attrConstruct _ = constructDOMHTMLInputElementMultiple
    attrClear _ = undefined

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementName :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementName obj = liftIO $ getObjectPropertyString obj "name"

setDOMHTMLInputElementName :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementName obj val = liftIO $ setObjectPropertyString obj "name" (Just val)

constructDOMHTMLInputElementName :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementName val = constructObjectPropertyString "name" (Just val)

data DOMHTMLInputElementNamePropertyInfo
instance AttrInfo DOMHTMLInputElementNamePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementNamePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementNamePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementNamePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementNamePropertyInfo = "name"
    attrGet _ = getDOMHTMLInputElementName
    attrSet _ = setDOMHTMLInputElementName
    attrConstruct _ = constructDOMHTMLInputElementName
    attrClear _ = undefined

-- VVV Prop "pattern"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementPattern :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementPattern obj = liftIO $ getObjectPropertyString obj "pattern"

setDOMHTMLInputElementPattern :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementPattern obj val = liftIO $ setObjectPropertyString obj "pattern" (Just val)

constructDOMHTMLInputElementPattern :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementPattern val = constructObjectPropertyString "pattern" (Just val)

clearDOMHTMLInputElementPattern :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementPattern obj = liftIO $ setObjectPropertyString obj "pattern" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementPatternPropertyInfo
instance AttrInfo DOMHTMLInputElementPatternPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementPatternPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementPatternPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementPatternPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementPatternPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementPatternPropertyInfo = "pattern"
    attrGet _ = getDOMHTMLInputElementPattern
    attrSet _ = setDOMHTMLInputElementPattern
    attrConstruct _ = constructDOMHTMLInputElementPattern
    attrClear _ = clearDOMHTMLInputElementPattern

-- VVV Prop "placeholder"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementPlaceholder :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementPlaceholder obj = liftIO $ getObjectPropertyString obj "placeholder"

setDOMHTMLInputElementPlaceholder :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementPlaceholder obj val = liftIO $ setObjectPropertyString obj "placeholder" (Just val)

constructDOMHTMLInputElementPlaceholder :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementPlaceholder val = constructObjectPropertyString "placeholder" (Just val)

clearDOMHTMLInputElementPlaceholder :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementPlaceholder obj = liftIO $ setObjectPropertyString obj "placeholder" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementPlaceholderPropertyInfo
instance AttrInfo DOMHTMLInputElementPlaceholderPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementPlaceholderPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementPlaceholderPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementPlaceholderPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementPlaceholderPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementPlaceholderPropertyInfo = "placeholder"
    attrGet _ = getDOMHTMLInputElementPlaceholder
    attrSet _ = setDOMHTMLInputElementPlaceholder
    attrConstruct _ = constructDOMHTMLInputElementPlaceholder
    attrClear _ = clearDOMHTMLInputElementPlaceholder

-- VVV Prop "read-only"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementReadOnly :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementReadOnly obj = liftIO $ getObjectPropertyBool obj "read-only"

setDOMHTMLInputElementReadOnly :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementReadOnly obj val = liftIO $ setObjectPropertyBool obj "read-only" val

constructDOMHTMLInputElementReadOnly :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementReadOnly val = constructObjectPropertyBool "read-only" val

data DOMHTMLInputElementReadOnlyPropertyInfo
instance AttrInfo DOMHTMLInputElementReadOnlyPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementReadOnlyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementReadOnlyPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementReadOnlyPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementReadOnlyPropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementReadOnlyPropertyInfo = "read-only"
    attrGet _ = getDOMHTMLInputElementReadOnly
    attrSet _ = setDOMHTMLInputElementReadOnly
    attrConstruct _ = constructDOMHTMLInputElementReadOnly
    attrClear _ = undefined

-- VVV Prop "required"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementRequired :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementRequired obj = liftIO $ getObjectPropertyBool obj "required"

setDOMHTMLInputElementRequired :: (MonadIO m, DOMHTMLInputElementK o) => o -> Bool -> m ()
setDOMHTMLInputElementRequired obj val = liftIO $ setObjectPropertyBool obj "required" val

constructDOMHTMLInputElementRequired :: Bool -> IO ([Char], GValue)
constructDOMHTMLInputElementRequired val = constructObjectPropertyBool "required" val

data DOMHTMLInputElementRequiredPropertyInfo
instance AttrInfo DOMHTMLInputElementRequiredPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementRequiredPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementRequiredPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLInputElementRequiredPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementRequiredPropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementRequiredPropertyInfo = "required"
    attrGet _ = getDOMHTMLInputElementRequired
    attrSet _ = setDOMHTMLInputElementRequired
    attrConstruct _ = constructDOMHTMLInputElementRequired
    attrClear _ = undefined

-- VVV Prop "size"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLInputElementSize :: (MonadIO m, DOMHTMLInputElementK o) => o -> m CULong
getDOMHTMLInputElementSize obj = liftIO $ getObjectPropertyULong obj "size"

setDOMHTMLInputElementSize :: (MonadIO m, DOMHTMLInputElementK o) => o -> CULong -> m ()
setDOMHTMLInputElementSize obj val = liftIO $ setObjectPropertyULong obj "size" val

constructDOMHTMLInputElementSize :: CULong -> IO ([Char], GValue)
constructDOMHTMLInputElementSize val = constructObjectPropertyULong "size" val

data DOMHTMLInputElementSizePropertyInfo
instance AttrInfo DOMHTMLInputElementSizePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementSizePropertyInfo = (~) CULong
    type AttrBaseTypeConstraint DOMHTMLInputElementSizePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementSizePropertyInfo = CULong
    type AttrLabel DOMHTMLInputElementSizePropertyInfo = "size"
    attrGet _ = getDOMHTMLInputElementSize
    attrSet _ = setDOMHTMLInputElementSize
    attrConstruct _ = constructDOMHTMLInputElementSize
    attrClear _ = undefined

-- VVV Prop "src"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementSrc :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementSrc obj = liftIO $ getObjectPropertyString obj "src"

setDOMHTMLInputElementSrc :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementSrc obj val = liftIO $ setObjectPropertyString obj "src" (Just val)

constructDOMHTMLInputElementSrc :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementSrc val = constructObjectPropertyString "src" (Just val)

data DOMHTMLInputElementSrcPropertyInfo
instance AttrInfo DOMHTMLInputElementSrcPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementSrcPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementSrcPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementSrcPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementSrcPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementSrcPropertyInfo = "src"
    attrGet _ = getDOMHTMLInputElementSrc
    attrSet _ = setDOMHTMLInputElementSrc
    attrConstruct _ = constructDOMHTMLInputElementSrc
    attrClear _ = undefined

-- VVV Prop "step"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementStep :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementStep obj = liftIO $ getObjectPropertyString obj "step"

setDOMHTMLInputElementStep :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementStep obj val = liftIO $ setObjectPropertyString obj "step" (Just val)

constructDOMHTMLInputElementStep :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementStep val = constructObjectPropertyString "step" (Just val)

clearDOMHTMLInputElementStep :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementStep obj = liftIO $ setObjectPropertyString obj "step" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementStepPropertyInfo
instance AttrInfo DOMHTMLInputElementStepPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementStepPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementStepPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementStepPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementStepPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementStepPropertyInfo = "step"
    attrGet _ = getDOMHTMLInputElementStep
    attrSet _ = setDOMHTMLInputElementStep
    attrConstruct _ = constructDOMHTMLInputElementStep
    attrClear _ = clearDOMHTMLInputElementStep

-- VVV Prop "type"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementType :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementType obj = liftIO $ getObjectPropertyString obj "type"

setDOMHTMLInputElementType :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementType obj val = liftIO $ setObjectPropertyString obj "type" (Just val)

constructDOMHTMLInputElementType :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementType val = constructObjectPropertyString "type" (Just val)

clearDOMHTMLInputElementType :: (MonadIO m, DOMHTMLInputElementK o) => o -> m ()
clearDOMHTMLInputElementType obj = liftIO $ setObjectPropertyString obj "type" (Nothing :: Maybe T.Text)

data DOMHTMLInputElementTypePropertyInfo
instance AttrInfo DOMHTMLInputElementTypePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementTypePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementTypePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementTypePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementTypePropertyInfo = "type"
    attrGet _ = getDOMHTMLInputElementType
    attrSet _ = setDOMHTMLInputElementType
    attrConstruct _ = constructDOMHTMLInputElementType
    attrClear _ = clearDOMHTMLInputElementType

-- VVV Prop "use-map"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementUseMap :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementUseMap obj = liftIO $ getObjectPropertyString obj "use-map"

setDOMHTMLInputElementUseMap :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementUseMap obj val = liftIO $ setObjectPropertyString obj "use-map" (Just val)

constructDOMHTMLInputElementUseMap :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementUseMap val = constructObjectPropertyString "use-map" (Just val)

data DOMHTMLInputElementUseMapPropertyInfo
instance AttrInfo DOMHTMLInputElementUseMapPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementUseMapPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementUseMapPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementUseMapPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementUseMapPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementUseMapPropertyInfo = "use-map"
    attrGet _ = getDOMHTMLInputElementUseMap
    attrSet _ = setDOMHTMLInputElementUseMap
    attrConstruct _ = constructDOMHTMLInputElementUseMap
    attrClear _ = undefined

-- VVV Prop "validation-message"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementValidationMessage :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementValidationMessage obj = liftIO $ getObjectPropertyString obj "validation-message"

data DOMHTMLInputElementValidationMessagePropertyInfo
instance AttrInfo DOMHTMLInputElementValidationMessagePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementValidationMessagePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLInputElementValidationMessagePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLInputElementValidationMessagePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementValidationMessagePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementValidationMessagePropertyInfo = "validation-message"
    attrGet _ = getDOMHTMLInputElementValidationMessage
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "value"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLInputElementValue :: (MonadIO m, DOMHTMLInputElementK o) => o -> m (Maybe T.Text)
getDOMHTMLInputElementValue obj = liftIO $ getObjectPropertyString obj "value"

setDOMHTMLInputElementValue :: (MonadIO m, DOMHTMLInputElementK o) => o -> T.Text -> m ()
setDOMHTMLInputElementValue obj val = liftIO $ setObjectPropertyString obj "value" (Just val)

constructDOMHTMLInputElementValue :: T.Text -> IO ([Char], GValue)
constructDOMHTMLInputElementValue val = constructObjectPropertyString "value" (Just val)

data DOMHTMLInputElementValuePropertyInfo
instance AttrInfo DOMHTMLInputElementValuePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementValuePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLInputElementValuePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementValuePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLInputElementValuePropertyInfo = "value"
    attrGet _ = getDOMHTMLInputElementValue
    attrSet _ = setDOMHTMLInputElementValue
    attrConstruct _ = constructDOMHTMLInputElementValue
    attrClear _ = undefined

-- VVV Prop "value-as-number"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLInputElementValueAsNumber :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Double
getDOMHTMLInputElementValueAsNumber obj = liftIO $ getObjectPropertyDouble obj "value-as-number"

setDOMHTMLInputElementValueAsNumber :: (MonadIO m, DOMHTMLInputElementK o) => o -> Double -> m ()
setDOMHTMLInputElementValueAsNumber obj val = liftIO $ setObjectPropertyDouble obj "value-as-number" val

constructDOMHTMLInputElementValueAsNumber :: Double -> IO ([Char], GValue)
constructDOMHTMLInputElementValueAsNumber val = constructObjectPropertyDouble "value-as-number" val

data DOMHTMLInputElementValueAsNumberPropertyInfo
instance AttrInfo DOMHTMLInputElementValueAsNumberPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementValueAsNumberPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementValueAsNumberPropertyInfo = (~) Double
    type AttrBaseTypeConstraint DOMHTMLInputElementValueAsNumberPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementValueAsNumberPropertyInfo = Double
    type AttrLabel DOMHTMLInputElementValueAsNumberPropertyInfo = "value-as-number"
    attrGet _ = getDOMHTMLInputElementValueAsNumber
    attrSet _ = setDOMHTMLInputElementValueAsNumber
    attrConstruct _ = constructDOMHTMLInputElementValueAsNumber
    attrClear _ = undefined

-- VVV Prop "width"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLInputElementWidth :: (MonadIO m, DOMHTMLInputElementK o) => o -> m CULong
getDOMHTMLInputElementWidth obj = liftIO $ getObjectPropertyULong obj "width"

setDOMHTMLInputElementWidth :: (MonadIO m, DOMHTMLInputElementK o) => o -> CULong -> m ()
setDOMHTMLInputElementWidth obj val = liftIO $ setObjectPropertyULong obj "width" val

constructDOMHTMLInputElementWidth :: CULong -> IO ([Char], GValue)
constructDOMHTMLInputElementWidth val = constructObjectPropertyULong "width" val

data DOMHTMLInputElementWidthPropertyInfo
instance AttrInfo DOMHTMLInputElementWidthPropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementWidthPropertyInfo = (~) CULong
    type AttrBaseTypeConstraint DOMHTMLInputElementWidthPropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementWidthPropertyInfo = CULong
    type AttrLabel DOMHTMLInputElementWidthPropertyInfo = "width"
    attrGet _ = getDOMHTMLInputElementWidth
    attrSet _ = setDOMHTMLInputElementWidth
    attrConstruct _ = constructDOMHTMLInputElementWidth
    attrClear _ = undefined

-- VVV Prop "will-validate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLInputElementWillValidate :: (MonadIO m, DOMHTMLInputElementK o) => o -> m Bool
getDOMHTMLInputElementWillValidate obj = liftIO $ getObjectPropertyBool obj "will-validate"

data DOMHTMLInputElementWillValidatePropertyInfo
instance AttrInfo DOMHTMLInputElementWillValidatePropertyInfo where
    type AttrAllowedOps DOMHTMLInputElementWillValidatePropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLInputElementWillValidatePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLInputElementWillValidatePropertyInfo = DOMHTMLInputElementK
    type AttrGetType DOMHTMLInputElementWillValidatePropertyInfo = Bool
    type AttrLabel DOMHTMLInputElementWillValidatePropertyInfo = "will-validate"
    attrGet _ = getDOMHTMLInputElementWillValidate
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList DOMHTMLInputElement = DOMHTMLInputElementAttributeList
type DOMHTMLInputElementAttributeList = ('[ '("accept", DOMHTMLInputElementAcceptPropertyInfo), '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("align", DOMHTMLInputElementAlignPropertyInfo), '("alt", DOMHTMLInputElementAltPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("autocapitalize", DOMHTMLInputElementAutocapitalizePropertyInfo), '("autocomplete", DOMHTMLInputElementAutocompletePropertyInfo), '("autocorrect", DOMHTMLInputElementAutocorrectPropertyInfo), '("autofocus", DOMHTMLInputElementAutofocusPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("capture", DOMHTMLInputElementCapturePropertyInfo), '("checked", DOMHTMLInputElementCheckedPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("defaultChecked", DOMHTMLInputElementDefaultCheckedPropertyInfo), '("defaultValue", DOMHTMLInputElementDefaultValuePropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("dirName", DOMHTMLInputElementDirNamePropertyInfo), '("disabled", DOMHTMLInputElementDisabledPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("files", DOMHTMLInputElementFilesPropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("form", DOMHTMLInputElementFormPropertyInfo), '("formAction", DOMHTMLInputElementFormActionPropertyInfo), '("formEnctype", DOMHTMLInputElementFormEnctypePropertyInfo), '("formMethod", DOMHTMLInputElementFormMethodPropertyInfo), '("formNoValidate", DOMHTMLInputElementFormNoValidatePropertyInfo), '("formTarget", DOMHTMLInputElementFormTargetPropertyInfo), '("height", DOMHTMLInputElementHeightPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("id", DOMElementIdPropertyInfo), '("incremental", DOMHTMLInputElementIncrementalPropertyInfo), '("indeterminate", DOMHTMLInputElementIndeterminatePropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("labels", DOMHTMLInputElementLabelsPropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("list", DOMHTMLInputElementListPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("max", DOMHTMLInputElementMaxPropertyInfo), '("maxLength", DOMHTMLInputElementMaxLengthPropertyInfo), '("min", DOMHTMLInputElementMinPropertyInfo), '("multiple", DOMHTMLInputElementMultiplePropertyInfo), '("name", DOMHTMLInputElementNamePropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("pattern", DOMHTMLInputElementPatternPropertyInfo), '("placeholder", DOMHTMLInputElementPlaceholderPropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("readOnly", DOMHTMLInputElementReadOnlyPropertyInfo), '("required", DOMHTMLInputElementRequiredPropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("size", DOMHTMLInputElementSizePropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("src", DOMHTMLInputElementSrcPropertyInfo), '("step", DOMHTMLInputElementStepPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("type", DOMHTMLInputElementTypePropertyInfo), '("useMap", DOMHTMLInputElementUseMapPropertyInfo), '("validationMessage", DOMHTMLInputElementValidationMessagePropertyInfo), '("value", DOMHTMLInputElementValuePropertyInfo), '("valueAsNumber", DOMHTMLInputElementValueAsNumberPropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo), '("width", DOMHTMLInputElementWidthPropertyInfo), '("willValidate", DOMHTMLInputElementWillValidatePropertyInfo)] :: [(Symbol, *)])

dOMHTMLInputElementAccept :: AttrLabelProxy "accept"
dOMHTMLInputElementAccept = AttrLabelProxy

dOMHTMLInputElementAlign :: AttrLabelProxy "align"
dOMHTMLInputElementAlign = AttrLabelProxy

dOMHTMLInputElementAlt :: AttrLabelProxy "alt"
dOMHTMLInputElementAlt = AttrLabelProxy

dOMHTMLInputElementAutocapitalize :: AttrLabelProxy "autocapitalize"
dOMHTMLInputElementAutocapitalize = AttrLabelProxy

dOMHTMLInputElementAutocomplete :: AttrLabelProxy "autocomplete"
dOMHTMLInputElementAutocomplete = AttrLabelProxy

dOMHTMLInputElementAutocorrect :: AttrLabelProxy "autocorrect"
dOMHTMLInputElementAutocorrect = AttrLabelProxy

dOMHTMLInputElementAutofocus :: AttrLabelProxy "autofocus"
dOMHTMLInputElementAutofocus = AttrLabelProxy

dOMHTMLInputElementCapture :: AttrLabelProxy "capture"
dOMHTMLInputElementCapture = AttrLabelProxy

dOMHTMLInputElementChecked :: AttrLabelProxy "checked"
dOMHTMLInputElementChecked = AttrLabelProxy

dOMHTMLInputElementDefaultChecked :: AttrLabelProxy "defaultChecked"
dOMHTMLInputElementDefaultChecked = AttrLabelProxy

dOMHTMLInputElementDefaultValue :: AttrLabelProxy "defaultValue"
dOMHTMLInputElementDefaultValue = AttrLabelProxy

dOMHTMLInputElementDirName :: AttrLabelProxy "dirName"
dOMHTMLInputElementDirName = AttrLabelProxy

dOMHTMLInputElementDisabled :: AttrLabelProxy "disabled"
dOMHTMLInputElementDisabled = AttrLabelProxy

dOMHTMLInputElementFiles :: AttrLabelProxy "files"
dOMHTMLInputElementFiles = AttrLabelProxy

dOMHTMLInputElementForm :: AttrLabelProxy "form"
dOMHTMLInputElementForm = AttrLabelProxy

dOMHTMLInputElementFormAction :: AttrLabelProxy "formAction"
dOMHTMLInputElementFormAction = AttrLabelProxy

dOMHTMLInputElementFormEnctype :: AttrLabelProxy "formEnctype"
dOMHTMLInputElementFormEnctype = AttrLabelProxy

dOMHTMLInputElementFormMethod :: AttrLabelProxy "formMethod"
dOMHTMLInputElementFormMethod = AttrLabelProxy

dOMHTMLInputElementFormNoValidate :: AttrLabelProxy "formNoValidate"
dOMHTMLInputElementFormNoValidate = AttrLabelProxy

dOMHTMLInputElementFormTarget :: AttrLabelProxy "formTarget"
dOMHTMLInputElementFormTarget = AttrLabelProxy

dOMHTMLInputElementHeight :: AttrLabelProxy "height"
dOMHTMLInputElementHeight = AttrLabelProxy

dOMHTMLInputElementIncremental :: AttrLabelProxy "incremental"
dOMHTMLInputElementIncremental = AttrLabelProxy

dOMHTMLInputElementIndeterminate :: AttrLabelProxy "indeterminate"
dOMHTMLInputElementIndeterminate = AttrLabelProxy

dOMHTMLInputElementLabels :: AttrLabelProxy "labels"
dOMHTMLInputElementLabels = AttrLabelProxy

dOMHTMLInputElementList :: AttrLabelProxy "list"
dOMHTMLInputElementList = AttrLabelProxy

dOMHTMLInputElementMax :: AttrLabelProxy "max"
dOMHTMLInputElementMax = AttrLabelProxy

dOMHTMLInputElementMaxLength :: AttrLabelProxy "maxLength"
dOMHTMLInputElementMaxLength = AttrLabelProxy

dOMHTMLInputElementMin :: AttrLabelProxy "min"
dOMHTMLInputElementMin = AttrLabelProxy

dOMHTMLInputElementMultiple :: AttrLabelProxy "multiple"
dOMHTMLInputElementMultiple = AttrLabelProxy

dOMHTMLInputElementName :: AttrLabelProxy "name"
dOMHTMLInputElementName = AttrLabelProxy

dOMHTMLInputElementPattern :: AttrLabelProxy "pattern"
dOMHTMLInputElementPattern = AttrLabelProxy

dOMHTMLInputElementPlaceholder :: AttrLabelProxy "placeholder"
dOMHTMLInputElementPlaceholder = AttrLabelProxy

dOMHTMLInputElementReadOnly :: AttrLabelProxy "readOnly"
dOMHTMLInputElementReadOnly = AttrLabelProxy

dOMHTMLInputElementRequired :: AttrLabelProxy "required"
dOMHTMLInputElementRequired = AttrLabelProxy

dOMHTMLInputElementSize :: AttrLabelProxy "size"
dOMHTMLInputElementSize = AttrLabelProxy

dOMHTMLInputElementSrc :: AttrLabelProxy "src"
dOMHTMLInputElementSrc = AttrLabelProxy

dOMHTMLInputElementStep :: AttrLabelProxy "step"
dOMHTMLInputElementStep = AttrLabelProxy

dOMHTMLInputElementType :: AttrLabelProxy "type"
dOMHTMLInputElementType = AttrLabelProxy

dOMHTMLInputElementUseMap :: AttrLabelProxy "useMap"
dOMHTMLInputElementUseMap = AttrLabelProxy

dOMHTMLInputElementValidationMessage :: AttrLabelProxy "validationMessage"
dOMHTMLInputElementValidationMessage = AttrLabelProxy

dOMHTMLInputElementValue :: AttrLabelProxy "value"
dOMHTMLInputElementValue = AttrLabelProxy

dOMHTMLInputElementValueAsNumber :: AttrLabelProxy "valueAsNumber"
dOMHTMLInputElementValueAsNumber = AttrLabelProxy

dOMHTMLInputElementWidth :: AttrLabelProxy "width"
dOMHTMLInputElementWidth = AttrLabelProxy

dOMHTMLInputElementWillValidate :: AttrLabelProxy "willValidate"
dOMHTMLInputElementWillValidate = AttrLabelProxy

type instance SignalList DOMHTMLInputElement = DOMHTMLInputElementSignalList
type DOMHTMLInputElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLInputElement::get_accept
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_accept" webkit_dom_html_input_element_get_accept :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetAccept ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetAccept _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_accept _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_accept" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetAcceptMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetAcceptMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetAccept

-- method DOMHTMLInputElement::get_align
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_align" webkit_dom_html_input_element_get_align :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetAlign ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetAlign _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_align _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_align" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetAlignMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetAlignMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetAlign

-- method DOMHTMLInputElement::get_alt
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_alt" webkit_dom_html_input_element_get_alt :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetAlt ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetAlt _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_alt _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_alt" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetAltMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetAltMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetAlt

-- method DOMHTMLInputElement::get_autofocus
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_autofocus" webkit_dom_html_input_element_get_autofocus :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementGetAutofocus ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementGetAutofocus _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_autofocus _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetAutofocusMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetAutofocusMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetAutofocus

-- method DOMHTMLInputElement::get_capture
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_capture" webkit_dom_html_input_element_get_capture :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementGetCapture ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementGetCapture _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_capture _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetCaptureMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetCaptureMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetCapture

-- method DOMHTMLInputElement::get_checked
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_checked" webkit_dom_html_input_element_get_checked :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementGetChecked ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementGetChecked _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_checked _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetCheckedMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetCheckedMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetChecked

-- method DOMHTMLInputElement::get_default_checked
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_default_checked" webkit_dom_html_input_element_get_default_checked :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementGetDefaultChecked ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementGetDefaultChecked _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_default_checked _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetDefaultCheckedMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetDefaultCheckedMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetDefaultChecked

-- method DOMHTMLInputElement::get_default_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_default_value" webkit_dom_html_input_element_get_default_value :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetDefaultValue ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetDefaultValue _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_default_value _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_default_value" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetDefaultValueMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetDefaultValueMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetDefaultValue

-- method DOMHTMLInputElement::get_disabled
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_disabled" webkit_dom_html_input_element_get_disabled :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementGetDisabled ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementGetDisabled _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_disabled _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetDisabledMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetDisabledMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetDisabled

-- method DOMHTMLInputElement::get_files
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "DOMFileList")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_files" webkit_dom_html_input_element_get_files :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO (Ptr DOMFileList)


dOMHTMLInputElementGetFiles ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m DOMFileList                        -- result
dOMHTMLInputElementGetFiles _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_files _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_files" result
    result' <- (wrapObject DOMFileList) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetFilesMethodInfo
instance (signature ~ (m DOMFileList), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetFilesMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetFiles

-- method DOMHTMLInputElement::get_form
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "DOMHTMLFormElement")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_form" webkit_dom_html_input_element_get_form :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO (Ptr DOMHTMLFormElement)


dOMHTMLInputElementGetForm ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m DOMHTMLFormElement                 -- result
dOMHTMLInputElementGetForm _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_form _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_form" result
    result' <- (newObject DOMHTMLFormElement) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetFormMethodInfo
instance (signature ~ (m DOMHTMLFormElement), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetFormMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetForm

-- method DOMHTMLInputElement::get_height
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_height" webkit_dom_html_input_element_get_height :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CULong


dOMHTMLInputElementGetHeight ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m CULong                             -- result
dOMHTMLInputElementGetHeight _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_height _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLInputElementGetHeightMethodInfo
instance (signature ~ (m CULong), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetHeightMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetHeight

-- method DOMHTMLInputElement::get_indeterminate
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_indeterminate" webkit_dom_html_input_element_get_indeterminate :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementGetIndeterminate ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementGetIndeterminate _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_indeterminate _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetIndeterminateMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetIndeterminateMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetIndeterminate

-- method DOMHTMLInputElement::get_input_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_input_type" webkit_dom_html_input_element_get_input_type :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetInputType ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetInputType _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_input_type _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_input_type" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetInputTypeMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetInputTypeMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetInputType

-- method DOMHTMLInputElement::get_max_length
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_max_length" webkit_dom_html_input_element_get_max_length :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CLong


dOMHTMLInputElementGetMaxLength ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLInputElementGetMaxLength _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_max_length _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLInputElementGetMaxLengthMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetMaxLengthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetMaxLength

-- method DOMHTMLInputElement::get_multiple
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_multiple" webkit_dom_html_input_element_get_multiple :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementGetMultiple ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementGetMultiple _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_multiple _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetMultipleMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetMultipleMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetMultiple

-- method DOMHTMLInputElement::get_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_name" webkit_dom_html_input_element_get_name :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetName ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetName _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_name _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_name" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetNameMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetName

-- method DOMHTMLInputElement::get_size
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_size" webkit_dom_html_input_element_get_size :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CULong


dOMHTMLInputElementGetSize ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m CULong                             -- result
dOMHTMLInputElementGetSize _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_size _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLInputElementGetSizeMethodInfo
instance (signature ~ (m CULong), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetSizeMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetSize

-- method DOMHTMLInputElement::get_src
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_src" webkit_dom_html_input_element_get_src :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetSrc ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetSrc _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_src _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_src" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetSrcMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetSrcMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetSrc

-- method DOMHTMLInputElement::get_use_map
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_use_map" webkit_dom_html_input_element_get_use_map :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetUseMap ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetUseMap _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_use_map _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_use_map" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetUseMapMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetUseMapMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetUseMap

-- method DOMHTMLInputElement::get_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_value" webkit_dom_html_input_element_get_value :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CString


dOMHTMLInputElementGetValue ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLInputElementGetValue _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_value _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_input_element_get_value" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetValueMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetValueMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetValue

-- method DOMHTMLInputElement::get_width
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_width" webkit_dom_html_input_element_get_width :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CULong


dOMHTMLInputElementGetWidth ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m CULong                             -- result
dOMHTMLInputElementGetWidth _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_width _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLInputElementGetWidthMethodInfo
instance (signature ~ (m CULong), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetWidthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetWidth

-- method DOMHTMLInputElement::get_will_validate
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_get_will_validate" webkit_dom_html_input_element_get_will_validate :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementGetWillValidate ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementGetWillValidate _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_get_will_validate _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementGetWillValidateMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementGetWillValidateMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementGetWillValidate

-- method DOMHTMLInputElement::is_edited
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_is_edited" webkit_dom_html_input_element_is_edited :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO CInt


dOMHTMLInputElementIsEdited ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLInputElementIsEdited _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_input_element_is_edited _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLInputElementIsEditedMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementIsEditedMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementIsEdited

-- method DOMHTMLInputElement::select
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_select" webkit_dom_html_input_element_select :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    IO ()


dOMHTMLInputElementSelect ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
dOMHTMLInputElementSelect _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_input_element_select _obj'
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSelectMethodInfo
instance (signature ~ (m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSelectMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSelect

-- method DOMHTMLInputElement::set_accept
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_accept" webkit_dom_html_input_element_set_accept :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetAccept ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetAccept _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_accept _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetAcceptMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetAcceptMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetAccept

-- method DOMHTMLInputElement::set_align
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_align" webkit_dom_html_input_element_set_align :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetAlign ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetAlign _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_align _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetAlignMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetAlignMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetAlign

-- method DOMHTMLInputElement::set_alt
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_alt" webkit_dom_html_input_element_set_alt :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetAlt ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetAlt _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_alt _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetAltMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetAltMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetAlt

-- method DOMHTMLInputElement::set_autofocus
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_autofocus" webkit_dom_html_input_element_set_autofocus :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLInputElementSetAutofocus ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetAutofocus _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_input_element_set_autofocus _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSetAutofocusMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetAutofocusMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetAutofocus

-- method DOMHTMLInputElement::set_checked
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_checked" webkit_dom_html_input_element_set_checked :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLInputElementSetChecked ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetChecked _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_input_element_set_checked _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSetCheckedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetCheckedMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetChecked

-- method DOMHTMLInputElement::set_default_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_default_value" webkit_dom_html_input_element_set_default_value :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetDefaultValue ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetDefaultValue _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_default_value _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetDefaultValueMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetDefaultValueMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetDefaultValue

-- method DOMHTMLInputElement::set_disabled
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_disabled" webkit_dom_html_input_element_set_disabled :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLInputElementSetDisabled ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetDisabled _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_input_element_set_disabled _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSetDisabledMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetDisabledMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetDisabled

-- method DOMHTMLInputElement::set_files
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TInterface "WebKit2WebExtension" "DOMFileList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_files" webkit_dom_html_input_element_set_files :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    Ptr DOMFileList ->                      -- value : TInterface "WebKit2WebExtension" "DOMFileList"
    IO ()


dOMHTMLInputElementSetFiles ::
    (MonadIO m, DOMHTMLInputElementK a, DOMFileListK b) =>
    a                                       -- _obj
    -> b                                    -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetFiles _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = unsafeManagedPtrCastPtr value
    webkit_dom_html_input_element_set_files _obj' value'
    touchManagedPtr _obj
    touchManagedPtr value
    return ()

data DOMHTMLInputElementSetFilesMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, DOMHTMLInputElementK a, DOMFileListK b) => MethodInfo DOMHTMLInputElementSetFilesMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetFiles

-- method DOMHTMLInputElement::set_height
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TULong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_height" webkit_dom_html_input_element_set_height :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CULong ->                               -- value : TBasicType TULong
    IO ()


dOMHTMLInputElementSetHeight ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> CULong                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetHeight _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_input_element_set_height _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSetHeightMethodInfo
instance (signature ~ (CULong -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetHeightMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetHeight

-- method DOMHTMLInputElement::set_indeterminate
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_indeterminate" webkit_dom_html_input_element_set_indeterminate :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLInputElementSetIndeterminate ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetIndeterminate _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_input_element_set_indeterminate _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSetIndeterminateMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetIndeterminateMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetIndeterminate

-- method DOMHTMLInputElement::set_input_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_input_type" webkit_dom_html_input_element_set_input_type :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetInputType ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetInputType _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_input_type _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetInputTypeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetInputTypeMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetInputType

-- method DOMHTMLInputElement::set_max_length
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TLong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : True
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_max_length" webkit_dom_html_input_element_set_max_length :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CLong ->                                -- value : TBasicType TLong
    Ptr (Ptr GError) ->                     -- error
    IO ()


dOMHTMLInputElementSetMaxLength ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> CLong                                -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetMaxLength _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    onException (do
        propagateGError $ webkit_dom_html_input_element_set_max_length _obj' value
        touchManagedPtr _obj
        return ()
     ) (do
        return ()
     )

data DOMHTMLInputElementSetMaxLengthMethodInfo
instance (signature ~ (CLong -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetMaxLengthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetMaxLength

-- method DOMHTMLInputElement::set_multiple
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_multiple" webkit_dom_html_input_element_set_multiple :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLInputElementSetMultiple ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetMultiple _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_input_element_set_multiple _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSetMultipleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetMultipleMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetMultiple

-- method DOMHTMLInputElement::set_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_name" webkit_dom_html_input_element_set_name :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetName ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetName _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_name _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetNameMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetName

-- method DOMHTMLInputElement::set_read_only
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_read_only" webkit_dom_html_input_element_set_read_only :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLInputElementSetReadOnly ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetReadOnly _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_input_element_set_read_only _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSetReadOnlyMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetReadOnlyMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetReadOnly

-- method DOMHTMLInputElement::set_size
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TULong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : True
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_size" webkit_dom_html_input_element_set_size :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CULong ->                               -- value : TBasicType TULong
    Ptr (Ptr GError) ->                     -- error
    IO ()


dOMHTMLInputElementSetSize ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> CULong                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetSize _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    onException (do
        propagateGError $ webkit_dom_html_input_element_set_size _obj' value
        touchManagedPtr _obj
        return ()
     ) (do
        return ()
     )

data DOMHTMLInputElementSetSizeMethodInfo
instance (signature ~ (CULong -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetSizeMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetSize

-- method DOMHTMLInputElement::set_src
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_src" webkit_dom_html_input_element_set_src :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetSrc ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetSrc _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_src _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetSrcMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetSrcMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetSrc

-- method DOMHTMLInputElement::set_use_map
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_use_map" webkit_dom_html_input_element_set_use_map :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetUseMap ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetUseMap _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_use_map _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetUseMapMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetUseMapMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetUseMap

-- method DOMHTMLInputElement::set_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_value" webkit_dom_html_input_element_set_value :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLInputElementSetValue ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetValue _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_input_element_set_value _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLInputElementSetValueMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetValueMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetValue

-- method DOMHTMLInputElement::set_width
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLInputElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TULong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_input_element_set_width" webkit_dom_html_input_element_set_width :: 
    Ptr DOMHTMLInputElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLInputElement"
    CULong ->                               -- value : TBasicType TULong
    IO ()


dOMHTMLInputElementSetWidth ::
    (MonadIO m, DOMHTMLInputElementK a) =>
    a                                       -- _obj
    -> CULong                               -- value
    -> m ()                                 -- result
dOMHTMLInputElementSetWidth _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_input_element_set_width _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLInputElementSetWidthMethodInfo
instance (signature ~ (CULong -> m ()), MonadIO m, DOMHTMLInputElementK a) => MethodInfo DOMHTMLInputElementSetWidthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLInputElementSetWidth


