

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLLIElement
    ( 

-- * Exported types
    DOMHTMLLIElement(..)                    ,
    DOMHTMLLIElementK                       ,
    toDOMHTMLLIElement                      ,
    noDOMHTMLLIElement                      ,


 -- * Methods
-- ** dOMHTMLLIElementGetTypeAttr
    DOMHTMLLIElementGetTypeAttrMethodInfo   ,
    dOMHTMLLIElementGetTypeAttr             ,


-- ** dOMHTMLLIElementGetValue
    DOMHTMLLIElementGetValueMethodInfo      ,
    dOMHTMLLIElementGetValue                ,


-- ** dOMHTMLLIElementSetTypeAttr
    DOMHTMLLIElementSetTypeAttrMethodInfo   ,
    dOMHTMLLIElementSetTypeAttr             ,


-- ** dOMHTMLLIElementSetValue
    DOMHTMLLIElementSetValueMethodInfo      ,
    dOMHTMLLIElementSetValue                ,




 -- * Properties
-- ** Type
    DOMHTMLLIElementTypePropertyInfo        ,
    clearDOMHTMLLIElementType               ,
    constructDOMHTMLLIElementType           ,
    dOMHTMLLIElementType                    ,
    getDOMHTMLLIElementType                 ,
    setDOMHTMLLIElementType                 ,


-- ** Value
    DOMHTMLLIElementValuePropertyInfo       ,
    constructDOMHTMLLIElementValue          ,
    dOMHTMLLIElementValue                   ,
    getDOMHTMLLIElementValue                ,
    setDOMHTMLLIElementValue                ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLLIElement = DOMHTMLLIElement (ForeignPtr DOMHTMLLIElement)
foreign import ccall "webkit_dom_html_li_element_get_type"
    c_webkit_dom_html_li_element_get_type :: IO GType

type instance ParentTypes DOMHTMLLIElement = DOMHTMLLIElementParentTypes
type DOMHTMLLIElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLLIElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_li_element_get_type
    

class GObject o => DOMHTMLLIElementK o
instance (GObject o, IsDescendantOf DOMHTMLLIElement o) => DOMHTMLLIElementK o

toDOMHTMLLIElement :: DOMHTMLLIElementK o => o -> IO DOMHTMLLIElement
toDOMHTMLLIElement = unsafeCastTo DOMHTMLLIElement

noDOMHTMLLIElement :: Maybe DOMHTMLLIElement
noDOMHTMLLIElement = Nothing

type family ResolveDOMHTMLLIElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLLIElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLLIElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLLIElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLLIElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLLIElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLLIElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLLIElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLLIElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLLIElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLLIElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLLIElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLLIElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLLIElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLLIElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLLIElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLLIElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLLIElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLLIElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLLIElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLLIElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLLIElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLLIElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLLIElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLLIElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLLIElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLLIElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLLIElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLLIElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLLIElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLLIElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLLIElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLLIElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLLIElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLLIElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLLIElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLLIElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLLIElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLLIElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLLIElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLLIElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLLIElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLLIElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLLIElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLLIElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLLIElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLLIElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLLIElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLLIElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLLIElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLLIElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLLIElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLLIElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLLIElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLLIElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLLIElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLLIElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLLIElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLLIElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLLIElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLLIElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLLIElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLLIElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLLIElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLLIElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLLIElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLLIElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLLIElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLLIElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLLIElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLLIElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLLIElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLLIElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLLIElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLLIElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLLIElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLLIElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLLIElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLLIElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLLIElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLLIElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLLIElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLLIElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLLIElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLLIElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLLIElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLLIElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLLIElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLLIElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLLIElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLLIElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLLIElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLLIElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLLIElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLLIElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLLIElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLLIElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLLIElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLLIElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLLIElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLLIElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLLIElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLLIElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLLIElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLLIElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLLIElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLLIElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLLIElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLLIElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLLIElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLLIElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLLIElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLLIElementMethod "getTypeAttr" o = DOMHTMLLIElementGetTypeAttrMethodInfo
    ResolveDOMHTMLLIElementMethod "getValue" o = DOMHTMLLIElementGetValueMethodInfo
    ResolveDOMHTMLLIElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLLIElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLLIElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLLIElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLLIElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLLIElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLLIElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLLIElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLLIElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLLIElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLLIElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLLIElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLLIElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLLIElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLLIElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLLIElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLLIElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLLIElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLLIElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLLIElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLLIElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLLIElementMethod "setTypeAttr" o = DOMHTMLLIElementSetTypeAttrMethodInfo
    ResolveDOMHTMLLIElementMethod "setValue" o = DOMHTMLLIElementSetValueMethodInfo
    ResolveDOMHTMLLIElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLLIElementMethod t DOMHTMLLIElement, MethodInfo info DOMHTMLLIElement p) => IsLabelProxy t (DOMHTMLLIElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLLIElementMethod t DOMHTMLLIElement, MethodInfo info DOMHTMLLIElement p) => IsLabel t (DOMHTMLLIElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "type"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLLIElementType :: (MonadIO m, DOMHTMLLIElementK o) => o -> m (Maybe T.Text)
getDOMHTMLLIElementType obj = liftIO $ getObjectPropertyString obj "type"

setDOMHTMLLIElementType :: (MonadIO m, DOMHTMLLIElementK o) => o -> T.Text -> m ()
setDOMHTMLLIElementType obj val = liftIO $ setObjectPropertyString obj "type" (Just val)

constructDOMHTMLLIElementType :: T.Text -> IO ([Char], GValue)
constructDOMHTMLLIElementType val = constructObjectPropertyString "type" (Just val)

clearDOMHTMLLIElementType :: (MonadIO m, DOMHTMLLIElementK o) => o -> m ()
clearDOMHTMLLIElementType obj = liftIO $ setObjectPropertyString obj "type" (Nothing :: Maybe T.Text)

data DOMHTMLLIElementTypePropertyInfo
instance AttrInfo DOMHTMLLIElementTypePropertyInfo where
    type AttrAllowedOps DOMHTMLLIElementTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLLIElementTypePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLLIElementTypePropertyInfo = DOMHTMLLIElementK
    type AttrGetType DOMHTMLLIElementTypePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLLIElementTypePropertyInfo = "type"
    attrGet _ = getDOMHTMLLIElementType
    attrSet _ = setDOMHTMLLIElementType
    attrConstruct _ = constructDOMHTMLLIElementType
    attrClear _ = clearDOMHTMLLIElementType

-- VVV Prop "value"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLLIElementValue :: (MonadIO m, DOMHTMLLIElementK o) => o -> m CLong
getDOMHTMLLIElementValue obj = liftIO $ getObjectPropertyLong obj "value"

setDOMHTMLLIElementValue :: (MonadIO m, DOMHTMLLIElementK o) => o -> CLong -> m ()
setDOMHTMLLIElementValue obj val = liftIO $ setObjectPropertyLong obj "value" val

constructDOMHTMLLIElementValue :: CLong -> IO ([Char], GValue)
constructDOMHTMLLIElementValue val = constructObjectPropertyLong "value" val

data DOMHTMLLIElementValuePropertyInfo
instance AttrInfo DOMHTMLLIElementValuePropertyInfo where
    type AttrAllowedOps DOMHTMLLIElementValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLLIElementValuePropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLLIElementValuePropertyInfo = DOMHTMLLIElementK
    type AttrGetType DOMHTMLLIElementValuePropertyInfo = CLong
    type AttrLabel DOMHTMLLIElementValuePropertyInfo = "value"
    attrGet _ = getDOMHTMLLIElementValue
    attrSet _ = setDOMHTMLLIElementValue
    attrConstruct _ = constructDOMHTMLLIElementValue
    attrClear _ = undefined

type instance AttributeList DOMHTMLLIElement = DOMHTMLLIElementAttributeList
type DOMHTMLLIElementAttributeList = ('[ '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("id", DOMElementIdPropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("type", DOMHTMLLIElementTypePropertyInfo), '("value", DOMHTMLLIElementValuePropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo)] :: [(Symbol, *)])

dOMHTMLLIElementType :: AttrLabelProxy "type"
dOMHTMLLIElementType = AttrLabelProxy

dOMHTMLLIElementValue :: AttrLabelProxy "value"
dOMHTMLLIElementValue = AttrLabelProxy

type instance SignalList DOMHTMLLIElement = DOMHTMLLIElementSignalList
type DOMHTMLLIElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLLIElement::get_type_attr
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLLIElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_li_element_get_type_attr" webkit_dom_html_li_element_get_type_attr :: 
    Ptr DOMHTMLLIElement ->                 -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLLIElement"
    IO CString


dOMHTMLLIElementGetTypeAttr ::
    (MonadIO m, DOMHTMLLIElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLLIElementGetTypeAttr _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_li_element_get_type_attr _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_li_element_get_type_attr" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLLIElementGetTypeAttrMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLLIElementK a) => MethodInfo DOMHTMLLIElementGetTypeAttrMethodInfo a signature where
    overloadedMethod _ = dOMHTMLLIElementGetTypeAttr

-- method DOMHTMLLIElement::get_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLLIElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_li_element_get_value" webkit_dom_html_li_element_get_value :: 
    Ptr DOMHTMLLIElement ->                 -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLLIElement"
    IO CLong


dOMHTMLLIElementGetValue ::
    (MonadIO m, DOMHTMLLIElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLLIElementGetValue _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_li_element_get_value _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLLIElementGetValueMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLLIElementK a) => MethodInfo DOMHTMLLIElementGetValueMethodInfo a signature where
    overloadedMethod _ = dOMHTMLLIElementGetValue

-- method DOMHTMLLIElement::set_type_attr
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLLIElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_li_element_set_type_attr" webkit_dom_html_li_element_set_type_attr :: 
    Ptr DOMHTMLLIElement ->                 -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLLIElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLLIElementSetTypeAttr ::
    (MonadIO m, DOMHTMLLIElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLLIElementSetTypeAttr _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_li_element_set_type_attr _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLLIElementSetTypeAttrMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLLIElementK a) => MethodInfo DOMHTMLLIElementSetTypeAttrMethodInfo a signature where
    overloadedMethod _ = dOMHTMLLIElementSetTypeAttr

-- method DOMHTMLLIElement::set_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLLIElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TLong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_li_element_set_value" webkit_dom_html_li_element_set_value :: 
    Ptr DOMHTMLLIElement ->                 -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLLIElement"
    CLong ->                                -- value : TBasicType TLong
    IO ()


dOMHTMLLIElementSetValue ::
    (MonadIO m, DOMHTMLLIElementK a) =>
    a                                       -- _obj
    -> CLong                                -- value
    -> m ()                                 -- result
dOMHTMLLIElementSetValue _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_li_element_set_value _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLLIElementSetValueMethodInfo
instance (signature ~ (CLong -> m ()), MonadIO m, DOMHTMLLIElementK a) => MethodInfo DOMHTMLLIElementSetValueMethodInfo a signature where
    overloadedMethod _ = dOMHTMLLIElementSetValue


