

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLMarqueeElement
    ( 

-- * Exported types
    DOMHTMLMarqueeElement(..)               ,
    DOMHTMLMarqueeElementK                  ,
    toDOMHTMLMarqueeElement                 ,
    noDOMHTMLMarqueeElement                 ,


 -- * Methods
-- ** dOMHTMLMarqueeElementStart
    DOMHTMLMarqueeElementStartMethodInfo    ,
    dOMHTMLMarqueeElementStart              ,


-- ** dOMHTMLMarqueeElementStop
    DOMHTMLMarqueeElementStopMethodInfo     ,
    dOMHTMLMarqueeElementStop               ,




 -- * Properties
-- ** Behavior
    DOMHTMLMarqueeElementBehaviorPropertyInfo,
    clearDOMHTMLMarqueeElementBehavior      ,
    constructDOMHTMLMarqueeElementBehavior  ,
    dOMHTMLMarqueeElementBehavior           ,
    getDOMHTMLMarqueeElementBehavior        ,
    setDOMHTMLMarqueeElementBehavior        ,


-- ** BgColor
    DOMHTMLMarqueeElementBgColorPropertyInfo,
    clearDOMHTMLMarqueeElementBgColor       ,
    constructDOMHTMLMarqueeElementBgColor   ,
    dOMHTMLMarqueeElementBgColor            ,
    getDOMHTMLMarqueeElementBgColor         ,
    setDOMHTMLMarqueeElementBgColor         ,


-- ** Direction
    DOMHTMLMarqueeElementDirectionPropertyInfo,
    clearDOMHTMLMarqueeElementDirection     ,
    constructDOMHTMLMarqueeElementDirection ,
    dOMHTMLMarqueeElementDirection          ,
    getDOMHTMLMarqueeElementDirection       ,
    setDOMHTMLMarqueeElementDirection       ,


-- ** Height
    DOMHTMLMarqueeElementHeightPropertyInfo ,
    clearDOMHTMLMarqueeElementHeight        ,
    constructDOMHTMLMarqueeElementHeight    ,
    dOMHTMLMarqueeElementHeight             ,
    getDOMHTMLMarqueeElementHeight          ,
    setDOMHTMLMarqueeElementHeight          ,


-- ** Hspace
    DOMHTMLMarqueeElementHspacePropertyInfo ,
    constructDOMHTMLMarqueeElementHspace    ,
    dOMHTMLMarqueeElementHspace             ,
    getDOMHTMLMarqueeElementHspace          ,
    setDOMHTMLMarqueeElementHspace          ,


-- ** Loop
    DOMHTMLMarqueeElementLoopPropertyInfo   ,
    constructDOMHTMLMarqueeElementLoop      ,
    dOMHTMLMarqueeElementLoop               ,
    getDOMHTMLMarqueeElementLoop            ,
    setDOMHTMLMarqueeElementLoop            ,


-- ** ScrollAmount
    DOMHTMLMarqueeElementScrollAmountPropertyInfo,
    constructDOMHTMLMarqueeElementScrollAmount,
    dOMHTMLMarqueeElementScrollAmount       ,
    getDOMHTMLMarqueeElementScrollAmount    ,
    setDOMHTMLMarqueeElementScrollAmount    ,


-- ** ScrollDelay
    DOMHTMLMarqueeElementScrollDelayPropertyInfo,
    constructDOMHTMLMarqueeElementScrollDelay,
    dOMHTMLMarqueeElementScrollDelay        ,
    getDOMHTMLMarqueeElementScrollDelay     ,
    setDOMHTMLMarqueeElementScrollDelay     ,


-- ** TrueSpeed
    DOMHTMLMarqueeElementTrueSpeedPropertyInfo,
    constructDOMHTMLMarqueeElementTrueSpeed ,
    dOMHTMLMarqueeElementTrueSpeed          ,
    getDOMHTMLMarqueeElementTrueSpeed       ,
    setDOMHTMLMarqueeElementTrueSpeed       ,


-- ** Vspace
    DOMHTMLMarqueeElementVspacePropertyInfo ,
    constructDOMHTMLMarqueeElementVspace    ,
    dOMHTMLMarqueeElementVspace             ,
    getDOMHTMLMarqueeElementVspace          ,
    setDOMHTMLMarqueeElementVspace          ,


-- ** Width
    DOMHTMLMarqueeElementWidthPropertyInfo  ,
    clearDOMHTMLMarqueeElementWidth         ,
    constructDOMHTMLMarqueeElementWidth     ,
    dOMHTMLMarqueeElementWidth              ,
    getDOMHTMLMarqueeElementWidth           ,
    setDOMHTMLMarqueeElementWidth           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLMarqueeElement = DOMHTMLMarqueeElement (ForeignPtr DOMHTMLMarqueeElement)
foreign import ccall "webkit_dom_html_marquee_element_get_type"
    c_webkit_dom_html_marquee_element_get_type :: IO GType

type instance ParentTypes DOMHTMLMarqueeElement = DOMHTMLMarqueeElementParentTypes
type DOMHTMLMarqueeElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLMarqueeElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_marquee_element_get_type
    

class GObject o => DOMHTMLMarqueeElementK o
instance (GObject o, IsDescendantOf DOMHTMLMarqueeElement o) => DOMHTMLMarqueeElementK o

toDOMHTMLMarqueeElement :: DOMHTMLMarqueeElementK o => o -> IO DOMHTMLMarqueeElement
toDOMHTMLMarqueeElement = unsafeCastTo DOMHTMLMarqueeElement

noDOMHTMLMarqueeElement :: Maybe DOMHTMLMarqueeElement
noDOMHTMLMarqueeElement = Nothing

type family ResolveDOMHTMLMarqueeElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLMarqueeElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "start" o = DOMHTMLMarqueeElementStartMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "stop" o = DOMHTMLMarqueeElementStopMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLMarqueeElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLMarqueeElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLMarqueeElementMethod t DOMHTMLMarqueeElement, MethodInfo info DOMHTMLMarqueeElement p) => IsLabelProxy t (DOMHTMLMarqueeElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLMarqueeElementMethod t DOMHTMLMarqueeElement, MethodInfo info DOMHTMLMarqueeElement p) => IsLabel t (DOMHTMLMarqueeElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "behavior"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementBehavior :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m (Maybe T.Text)
getDOMHTMLMarqueeElementBehavior obj = liftIO $ getObjectPropertyString obj "behavior"

setDOMHTMLMarqueeElementBehavior :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> T.Text -> m ()
setDOMHTMLMarqueeElementBehavior obj val = liftIO $ setObjectPropertyString obj "behavior" (Just val)

constructDOMHTMLMarqueeElementBehavior :: T.Text -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementBehavior val = constructObjectPropertyString "behavior" (Just val)

clearDOMHTMLMarqueeElementBehavior :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m ()
clearDOMHTMLMarqueeElementBehavior obj = liftIO $ setObjectPropertyString obj "behavior" (Nothing :: Maybe T.Text)

data DOMHTMLMarqueeElementBehaviorPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementBehaviorPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementBehaviorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementBehaviorPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementBehaviorPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementBehaviorPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLMarqueeElementBehaviorPropertyInfo = "behavior"
    attrGet _ = getDOMHTMLMarqueeElementBehavior
    attrSet _ = setDOMHTMLMarqueeElementBehavior
    attrConstruct _ = constructDOMHTMLMarqueeElementBehavior
    attrClear _ = clearDOMHTMLMarqueeElementBehavior

-- VVV Prop "bg-color"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementBgColor :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m (Maybe T.Text)
getDOMHTMLMarqueeElementBgColor obj = liftIO $ getObjectPropertyString obj "bg-color"

setDOMHTMLMarqueeElementBgColor :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> T.Text -> m ()
setDOMHTMLMarqueeElementBgColor obj val = liftIO $ setObjectPropertyString obj "bg-color" (Just val)

constructDOMHTMLMarqueeElementBgColor :: T.Text -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementBgColor val = constructObjectPropertyString "bg-color" (Just val)

clearDOMHTMLMarqueeElementBgColor :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m ()
clearDOMHTMLMarqueeElementBgColor obj = liftIO $ setObjectPropertyString obj "bg-color" (Nothing :: Maybe T.Text)

data DOMHTMLMarqueeElementBgColorPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementBgColorPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementBgColorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementBgColorPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementBgColorPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementBgColorPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLMarqueeElementBgColorPropertyInfo = "bg-color"
    attrGet _ = getDOMHTMLMarqueeElementBgColor
    attrSet _ = setDOMHTMLMarqueeElementBgColor
    attrConstruct _ = constructDOMHTMLMarqueeElementBgColor
    attrClear _ = clearDOMHTMLMarqueeElementBgColor

-- VVV Prop "direction"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementDirection :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m (Maybe T.Text)
getDOMHTMLMarqueeElementDirection obj = liftIO $ getObjectPropertyString obj "direction"

setDOMHTMLMarqueeElementDirection :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> T.Text -> m ()
setDOMHTMLMarqueeElementDirection obj val = liftIO $ setObjectPropertyString obj "direction" (Just val)

constructDOMHTMLMarqueeElementDirection :: T.Text -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementDirection val = constructObjectPropertyString "direction" (Just val)

clearDOMHTMLMarqueeElementDirection :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m ()
clearDOMHTMLMarqueeElementDirection obj = liftIO $ setObjectPropertyString obj "direction" (Nothing :: Maybe T.Text)

data DOMHTMLMarqueeElementDirectionPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementDirectionPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementDirectionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementDirectionPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementDirectionPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementDirectionPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLMarqueeElementDirectionPropertyInfo = "direction"
    attrGet _ = getDOMHTMLMarqueeElementDirection
    attrSet _ = setDOMHTMLMarqueeElementDirection
    attrConstruct _ = constructDOMHTMLMarqueeElementDirection
    attrClear _ = clearDOMHTMLMarqueeElementDirection

-- VVV Prop "height"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementHeight :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m (Maybe T.Text)
getDOMHTMLMarqueeElementHeight obj = liftIO $ getObjectPropertyString obj "height"

setDOMHTMLMarqueeElementHeight :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> T.Text -> m ()
setDOMHTMLMarqueeElementHeight obj val = liftIO $ setObjectPropertyString obj "height" (Just val)

constructDOMHTMLMarqueeElementHeight :: T.Text -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementHeight val = constructObjectPropertyString "height" (Just val)

clearDOMHTMLMarqueeElementHeight :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m ()
clearDOMHTMLMarqueeElementHeight obj = liftIO $ setObjectPropertyString obj "height" (Nothing :: Maybe T.Text)

data DOMHTMLMarqueeElementHeightPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementHeightPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementHeightPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementHeightPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementHeightPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLMarqueeElementHeightPropertyInfo = "height"
    attrGet _ = getDOMHTMLMarqueeElementHeight
    attrSet _ = setDOMHTMLMarqueeElementHeight
    attrConstruct _ = constructDOMHTMLMarqueeElementHeight
    attrClear _ = clearDOMHTMLMarqueeElementHeight

-- VVV Prop "hspace"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementHspace :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m CULong
getDOMHTMLMarqueeElementHspace obj = liftIO $ getObjectPropertyULong obj "hspace"

setDOMHTMLMarqueeElementHspace :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> CULong -> m ()
setDOMHTMLMarqueeElementHspace obj val = liftIO $ setObjectPropertyULong obj "hspace" val

constructDOMHTMLMarqueeElementHspace :: CULong -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementHspace val = constructObjectPropertyULong "hspace" val

data DOMHTMLMarqueeElementHspacePropertyInfo
instance AttrInfo DOMHTMLMarqueeElementHspacePropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementHspacePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementHspacePropertyInfo = (~) CULong
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementHspacePropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementHspacePropertyInfo = CULong
    type AttrLabel DOMHTMLMarqueeElementHspacePropertyInfo = "hspace"
    attrGet _ = getDOMHTMLMarqueeElementHspace
    attrSet _ = setDOMHTMLMarqueeElementHspace
    attrConstruct _ = constructDOMHTMLMarqueeElementHspace
    attrClear _ = undefined

-- VVV Prop "loop"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementLoop :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m CLong
getDOMHTMLMarqueeElementLoop obj = liftIO $ getObjectPropertyLong obj "loop"

setDOMHTMLMarqueeElementLoop :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> CLong -> m ()
setDOMHTMLMarqueeElementLoop obj val = liftIO $ setObjectPropertyLong obj "loop" val

constructDOMHTMLMarqueeElementLoop :: CLong -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementLoop val = constructObjectPropertyLong "loop" val

data DOMHTMLMarqueeElementLoopPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementLoopPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementLoopPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementLoopPropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementLoopPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementLoopPropertyInfo = CLong
    type AttrLabel DOMHTMLMarqueeElementLoopPropertyInfo = "loop"
    attrGet _ = getDOMHTMLMarqueeElementLoop
    attrSet _ = setDOMHTMLMarqueeElementLoop
    attrConstruct _ = constructDOMHTMLMarqueeElementLoop
    attrClear _ = undefined

-- VVV Prop "scroll-amount"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementScrollAmount :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m CLong
getDOMHTMLMarqueeElementScrollAmount obj = liftIO $ getObjectPropertyLong obj "scroll-amount"

setDOMHTMLMarqueeElementScrollAmount :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> CLong -> m ()
setDOMHTMLMarqueeElementScrollAmount obj val = liftIO $ setObjectPropertyLong obj "scroll-amount" val

constructDOMHTMLMarqueeElementScrollAmount :: CLong -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementScrollAmount val = constructObjectPropertyLong "scroll-amount" val

data DOMHTMLMarqueeElementScrollAmountPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementScrollAmountPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementScrollAmountPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementScrollAmountPropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementScrollAmountPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementScrollAmountPropertyInfo = CLong
    type AttrLabel DOMHTMLMarqueeElementScrollAmountPropertyInfo = "scroll-amount"
    attrGet _ = getDOMHTMLMarqueeElementScrollAmount
    attrSet _ = setDOMHTMLMarqueeElementScrollAmount
    attrConstruct _ = constructDOMHTMLMarqueeElementScrollAmount
    attrClear _ = undefined

-- VVV Prop "scroll-delay"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementScrollDelay :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m CLong
getDOMHTMLMarqueeElementScrollDelay obj = liftIO $ getObjectPropertyLong obj "scroll-delay"

setDOMHTMLMarqueeElementScrollDelay :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> CLong -> m ()
setDOMHTMLMarqueeElementScrollDelay obj val = liftIO $ setObjectPropertyLong obj "scroll-delay" val

constructDOMHTMLMarqueeElementScrollDelay :: CLong -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementScrollDelay val = constructObjectPropertyLong "scroll-delay" val

data DOMHTMLMarqueeElementScrollDelayPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementScrollDelayPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementScrollDelayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementScrollDelayPropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementScrollDelayPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementScrollDelayPropertyInfo = CLong
    type AttrLabel DOMHTMLMarqueeElementScrollDelayPropertyInfo = "scroll-delay"
    attrGet _ = getDOMHTMLMarqueeElementScrollDelay
    attrSet _ = setDOMHTMLMarqueeElementScrollDelay
    attrConstruct _ = constructDOMHTMLMarqueeElementScrollDelay
    attrClear _ = undefined

-- VVV Prop "true-speed"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementTrueSpeed :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m Bool
getDOMHTMLMarqueeElementTrueSpeed obj = liftIO $ getObjectPropertyBool obj "true-speed"

setDOMHTMLMarqueeElementTrueSpeed :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> Bool -> m ()
setDOMHTMLMarqueeElementTrueSpeed obj val = liftIO $ setObjectPropertyBool obj "true-speed" val

constructDOMHTMLMarqueeElementTrueSpeed :: Bool -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementTrueSpeed val = constructObjectPropertyBool "true-speed" val

data DOMHTMLMarqueeElementTrueSpeedPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementTrueSpeedPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementTrueSpeedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementTrueSpeedPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementTrueSpeedPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementTrueSpeedPropertyInfo = Bool
    type AttrLabel DOMHTMLMarqueeElementTrueSpeedPropertyInfo = "true-speed"
    attrGet _ = getDOMHTMLMarqueeElementTrueSpeed
    attrSet _ = setDOMHTMLMarqueeElementTrueSpeed
    attrConstruct _ = constructDOMHTMLMarqueeElementTrueSpeed
    attrClear _ = undefined

-- VVV Prop "vspace"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementVspace :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m CULong
getDOMHTMLMarqueeElementVspace obj = liftIO $ getObjectPropertyULong obj "vspace"

setDOMHTMLMarqueeElementVspace :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> CULong -> m ()
setDOMHTMLMarqueeElementVspace obj val = liftIO $ setObjectPropertyULong obj "vspace" val

constructDOMHTMLMarqueeElementVspace :: CULong -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementVspace val = constructObjectPropertyULong "vspace" val

data DOMHTMLMarqueeElementVspacePropertyInfo
instance AttrInfo DOMHTMLMarqueeElementVspacePropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementVspacePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementVspacePropertyInfo = (~) CULong
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementVspacePropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementVspacePropertyInfo = CULong
    type AttrLabel DOMHTMLMarqueeElementVspacePropertyInfo = "vspace"
    attrGet _ = getDOMHTMLMarqueeElementVspace
    attrSet _ = setDOMHTMLMarqueeElementVspace
    attrConstruct _ = constructDOMHTMLMarqueeElementVspace
    attrClear _ = undefined

-- VVV Prop "width"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLMarqueeElementWidth :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m (Maybe T.Text)
getDOMHTMLMarqueeElementWidth obj = liftIO $ getObjectPropertyString obj "width"

setDOMHTMLMarqueeElementWidth :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> T.Text -> m ()
setDOMHTMLMarqueeElementWidth obj val = liftIO $ setObjectPropertyString obj "width" (Just val)

constructDOMHTMLMarqueeElementWidth :: T.Text -> IO ([Char], GValue)
constructDOMHTMLMarqueeElementWidth val = constructObjectPropertyString "width" (Just val)

clearDOMHTMLMarqueeElementWidth :: (MonadIO m, DOMHTMLMarqueeElementK o) => o -> m ()
clearDOMHTMLMarqueeElementWidth obj = liftIO $ setObjectPropertyString obj "width" (Nothing :: Maybe T.Text)

data DOMHTMLMarqueeElementWidthPropertyInfo
instance AttrInfo DOMHTMLMarqueeElementWidthPropertyInfo where
    type AttrAllowedOps DOMHTMLMarqueeElementWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLMarqueeElementWidthPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLMarqueeElementWidthPropertyInfo = DOMHTMLMarqueeElementK
    type AttrGetType DOMHTMLMarqueeElementWidthPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLMarqueeElementWidthPropertyInfo = "width"
    attrGet _ = getDOMHTMLMarqueeElementWidth
    attrSet _ = setDOMHTMLMarqueeElementWidth
    attrConstruct _ = constructDOMHTMLMarqueeElementWidth
    attrClear _ = clearDOMHTMLMarqueeElementWidth

type instance AttributeList DOMHTMLMarqueeElement = DOMHTMLMarqueeElementAttributeList
type DOMHTMLMarqueeElementAttributeList = ('[ '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("behavior", DOMHTMLMarqueeElementBehaviorPropertyInfo), '("bgColor", DOMHTMLMarqueeElementBgColorPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("direction", DOMHTMLMarqueeElementDirectionPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("height", DOMHTMLMarqueeElementHeightPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("hspace", DOMHTMLMarqueeElementHspacePropertyInfo), '("id", DOMElementIdPropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("loop", DOMHTMLMarqueeElementLoopPropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("scrollAmount", DOMHTMLMarqueeElementScrollAmountPropertyInfo), '("scrollDelay", DOMHTMLMarqueeElementScrollDelayPropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("trueSpeed", DOMHTMLMarqueeElementTrueSpeedPropertyInfo), '("vspace", DOMHTMLMarqueeElementVspacePropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo), '("width", DOMHTMLMarqueeElementWidthPropertyInfo)] :: [(Symbol, *)])

dOMHTMLMarqueeElementBehavior :: AttrLabelProxy "behavior"
dOMHTMLMarqueeElementBehavior = AttrLabelProxy

dOMHTMLMarqueeElementBgColor :: AttrLabelProxy "bgColor"
dOMHTMLMarqueeElementBgColor = AttrLabelProxy

dOMHTMLMarqueeElementDirection :: AttrLabelProxy "direction"
dOMHTMLMarqueeElementDirection = AttrLabelProxy

dOMHTMLMarqueeElementHeight :: AttrLabelProxy "height"
dOMHTMLMarqueeElementHeight = AttrLabelProxy

dOMHTMLMarqueeElementHspace :: AttrLabelProxy "hspace"
dOMHTMLMarqueeElementHspace = AttrLabelProxy

dOMHTMLMarqueeElementLoop :: AttrLabelProxy "loop"
dOMHTMLMarqueeElementLoop = AttrLabelProxy

dOMHTMLMarqueeElementScrollAmount :: AttrLabelProxy "scrollAmount"
dOMHTMLMarqueeElementScrollAmount = AttrLabelProxy

dOMHTMLMarqueeElementScrollDelay :: AttrLabelProxy "scrollDelay"
dOMHTMLMarqueeElementScrollDelay = AttrLabelProxy

dOMHTMLMarqueeElementTrueSpeed :: AttrLabelProxy "trueSpeed"
dOMHTMLMarqueeElementTrueSpeed = AttrLabelProxy

dOMHTMLMarqueeElementVspace :: AttrLabelProxy "vspace"
dOMHTMLMarqueeElementVspace = AttrLabelProxy

dOMHTMLMarqueeElementWidth :: AttrLabelProxy "width"
dOMHTMLMarqueeElementWidth = AttrLabelProxy

type instance SignalList DOMHTMLMarqueeElement = DOMHTMLMarqueeElementSignalList
type DOMHTMLMarqueeElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLMarqueeElement::start
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLMarqueeElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_marquee_element_start" webkit_dom_html_marquee_element_start :: 
    Ptr DOMHTMLMarqueeElement ->            -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLMarqueeElement"
    IO ()


dOMHTMLMarqueeElementStart ::
    (MonadIO m, DOMHTMLMarqueeElementK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
dOMHTMLMarqueeElementStart _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_marquee_element_start _obj'
    touchManagedPtr _obj
    return ()

data DOMHTMLMarqueeElementStartMethodInfo
instance (signature ~ (m ()), MonadIO m, DOMHTMLMarqueeElementK a) => MethodInfo DOMHTMLMarqueeElementStartMethodInfo a signature where
    overloadedMethod _ = dOMHTMLMarqueeElementStart

-- method DOMHTMLMarqueeElement::stop
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLMarqueeElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_marquee_element_stop" webkit_dom_html_marquee_element_stop :: 
    Ptr DOMHTMLMarqueeElement ->            -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLMarqueeElement"
    IO ()


dOMHTMLMarqueeElementStop ::
    (MonadIO m, DOMHTMLMarqueeElementK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
dOMHTMLMarqueeElementStop _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_marquee_element_stop _obj'
    touchManagedPtr _obj
    return ()

data DOMHTMLMarqueeElementStopMethodInfo
instance (signature ~ (m ()), MonadIO m, DOMHTMLMarqueeElementK a) => MethodInfo DOMHTMLMarqueeElementStopMethodInfo a signature where
    overloadedMethod _ = dOMHTMLMarqueeElementStop


