

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLTableCellElement
    ( 

-- * Exported types
    DOMHTMLTableCellElement(..)             ,
    DOMHTMLTableCellElementK                ,
    toDOMHTMLTableCellElement               ,
    noDOMHTMLTableCellElement               ,


 -- * Methods
-- ** dOMHTMLTableCellElementGetAbbr
    DOMHTMLTableCellElementGetAbbrMethodInfo,
    dOMHTMLTableCellElementGetAbbr          ,


-- ** dOMHTMLTableCellElementGetAlign
    DOMHTMLTableCellElementGetAlignMethodInfo,
    dOMHTMLTableCellElementGetAlign         ,


-- ** dOMHTMLTableCellElementGetAxis
    DOMHTMLTableCellElementGetAxisMethodInfo,
    dOMHTMLTableCellElementGetAxis          ,


-- ** dOMHTMLTableCellElementGetBgColor
    DOMHTMLTableCellElementGetBgColorMethodInfo,
    dOMHTMLTableCellElementGetBgColor       ,


-- ** dOMHTMLTableCellElementGetCellIndex
    DOMHTMLTableCellElementGetCellIndexMethodInfo,
    dOMHTMLTableCellElementGetCellIndex     ,


-- ** dOMHTMLTableCellElementGetCh
    DOMHTMLTableCellElementGetChMethodInfo  ,
    dOMHTMLTableCellElementGetCh            ,


-- ** dOMHTMLTableCellElementGetChOff
    DOMHTMLTableCellElementGetChOffMethodInfo,
    dOMHTMLTableCellElementGetChOff         ,


-- ** dOMHTMLTableCellElementGetColSpan
    DOMHTMLTableCellElementGetColSpanMethodInfo,
    dOMHTMLTableCellElementGetColSpan       ,


-- ** dOMHTMLTableCellElementGetHeaders
    DOMHTMLTableCellElementGetHeadersMethodInfo,
    dOMHTMLTableCellElementGetHeaders       ,


-- ** dOMHTMLTableCellElementGetHeight
    DOMHTMLTableCellElementGetHeightMethodInfo,
    dOMHTMLTableCellElementGetHeight        ,


-- ** dOMHTMLTableCellElementGetNoWrap
    DOMHTMLTableCellElementGetNoWrapMethodInfo,
    dOMHTMLTableCellElementGetNoWrap        ,


-- ** dOMHTMLTableCellElementGetRowSpan
    DOMHTMLTableCellElementGetRowSpanMethodInfo,
    dOMHTMLTableCellElementGetRowSpan       ,


-- ** dOMHTMLTableCellElementGetScope
    DOMHTMLTableCellElementGetScopeMethodInfo,
    dOMHTMLTableCellElementGetScope         ,


-- ** dOMHTMLTableCellElementGetVAlign
    DOMHTMLTableCellElementGetVAlignMethodInfo,
    dOMHTMLTableCellElementGetVAlign        ,


-- ** dOMHTMLTableCellElementGetWidth
    DOMHTMLTableCellElementGetWidthMethodInfo,
    dOMHTMLTableCellElementGetWidth         ,


-- ** dOMHTMLTableCellElementSetAbbr
    DOMHTMLTableCellElementSetAbbrMethodInfo,
    dOMHTMLTableCellElementSetAbbr          ,


-- ** dOMHTMLTableCellElementSetAlign
    DOMHTMLTableCellElementSetAlignMethodInfo,
    dOMHTMLTableCellElementSetAlign         ,


-- ** dOMHTMLTableCellElementSetAxis
    DOMHTMLTableCellElementSetAxisMethodInfo,
    dOMHTMLTableCellElementSetAxis          ,


-- ** dOMHTMLTableCellElementSetBgColor
    DOMHTMLTableCellElementSetBgColorMethodInfo,
    dOMHTMLTableCellElementSetBgColor       ,


-- ** dOMHTMLTableCellElementSetCh
    DOMHTMLTableCellElementSetChMethodInfo  ,
    dOMHTMLTableCellElementSetCh            ,


-- ** dOMHTMLTableCellElementSetChOff
    DOMHTMLTableCellElementSetChOffMethodInfo,
    dOMHTMLTableCellElementSetChOff         ,


-- ** dOMHTMLTableCellElementSetColSpan
    DOMHTMLTableCellElementSetColSpanMethodInfo,
    dOMHTMLTableCellElementSetColSpan       ,


-- ** dOMHTMLTableCellElementSetHeaders
    DOMHTMLTableCellElementSetHeadersMethodInfo,
    dOMHTMLTableCellElementSetHeaders       ,


-- ** dOMHTMLTableCellElementSetHeight
    DOMHTMLTableCellElementSetHeightMethodInfo,
    dOMHTMLTableCellElementSetHeight        ,


-- ** dOMHTMLTableCellElementSetNoWrap
    DOMHTMLTableCellElementSetNoWrapMethodInfo,
    dOMHTMLTableCellElementSetNoWrap        ,


-- ** dOMHTMLTableCellElementSetRowSpan
    DOMHTMLTableCellElementSetRowSpanMethodInfo,
    dOMHTMLTableCellElementSetRowSpan       ,


-- ** dOMHTMLTableCellElementSetScope
    DOMHTMLTableCellElementSetScopeMethodInfo,
    dOMHTMLTableCellElementSetScope         ,


-- ** dOMHTMLTableCellElementSetVAlign
    DOMHTMLTableCellElementSetVAlignMethodInfo,
    dOMHTMLTableCellElementSetVAlign        ,


-- ** dOMHTMLTableCellElementSetWidth
    DOMHTMLTableCellElementSetWidthMethodInfo,
    dOMHTMLTableCellElementSetWidth         ,




 -- * Properties
-- ** Abbr
    DOMHTMLTableCellElementAbbrPropertyInfo ,
    constructDOMHTMLTableCellElementAbbr    ,
    dOMHTMLTableCellElementAbbr             ,
    getDOMHTMLTableCellElementAbbr          ,
    setDOMHTMLTableCellElementAbbr          ,


-- ** Align
    DOMHTMLTableCellElementAlignPropertyInfo,
    constructDOMHTMLTableCellElementAlign   ,
    dOMHTMLTableCellElementAlign            ,
    getDOMHTMLTableCellElementAlign         ,
    setDOMHTMLTableCellElementAlign         ,


-- ** Axis
    DOMHTMLTableCellElementAxisPropertyInfo ,
    constructDOMHTMLTableCellElementAxis    ,
    dOMHTMLTableCellElementAxis             ,
    getDOMHTMLTableCellElementAxis          ,
    setDOMHTMLTableCellElementAxis          ,


-- ** BgColor
    DOMHTMLTableCellElementBgColorPropertyInfo,
    constructDOMHTMLTableCellElementBgColor ,
    dOMHTMLTableCellElementBgColor          ,
    getDOMHTMLTableCellElementBgColor       ,
    setDOMHTMLTableCellElementBgColor       ,


-- ** CellIndex
    DOMHTMLTableCellElementCellIndexPropertyInfo,
    dOMHTMLTableCellElementCellIndex        ,
    getDOMHTMLTableCellElementCellIndex     ,


-- ** Ch
    DOMHTMLTableCellElementChPropertyInfo   ,
    constructDOMHTMLTableCellElementCh      ,
    dOMHTMLTableCellElementCh               ,
    getDOMHTMLTableCellElementCh            ,
    setDOMHTMLTableCellElementCh            ,


-- ** ChOff
    DOMHTMLTableCellElementChOffPropertyInfo,
    constructDOMHTMLTableCellElementChOff   ,
    dOMHTMLTableCellElementChOff            ,
    getDOMHTMLTableCellElementChOff         ,
    setDOMHTMLTableCellElementChOff         ,


-- ** ColSpan
    DOMHTMLTableCellElementColSpanPropertyInfo,
    constructDOMHTMLTableCellElementColSpan ,
    dOMHTMLTableCellElementColSpan          ,
    getDOMHTMLTableCellElementColSpan       ,
    setDOMHTMLTableCellElementColSpan       ,


-- ** Headers
    DOMHTMLTableCellElementHeadersPropertyInfo,
    constructDOMHTMLTableCellElementHeaders ,
    dOMHTMLTableCellElementHeaders          ,
    getDOMHTMLTableCellElementHeaders       ,
    setDOMHTMLTableCellElementHeaders       ,


-- ** Height
    DOMHTMLTableCellElementHeightPropertyInfo,
    constructDOMHTMLTableCellElementHeight  ,
    dOMHTMLTableCellElementHeight           ,
    getDOMHTMLTableCellElementHeight        ,
    setDOMHTMLTableCellElementHeight        ,


-- ** NoWrap
    DOMHTMLTableCellElementNoWrapPropertyInfo,
    constructDOMHTMLTableCellElementNoWrap  ,
    dOMHTMLTableCellElementNoWrap           ,
    getDOMHTMLTableCellElementNoWrap        ,
    setDOMHTMLTableCellElementNoWrap        ,


-- ** RowSpan
    DOMHTMLTableCellElementRowSpanPropertyInfo,
    constructDOMHTMLTableCellElementRowSpan ,
    dOMHTMLTableCellElementRowSpan          ,
    getDOMHTMLTableCellElementRowSpan       ,
    setDOMHTMLTableCellElementRowSpan       ,


-- ** Scope
    DOMHTMLTableCellElementScopePropertyInfo,
    constructDOMHTMLTableCellElementScope   ,
    dOMHTMLTableCellElementScope            ,
    getDOMHTMLTableCellElementScope         ,
    setDOMHTMLTableCellElementScope         ,


-- ** VAlign
    DOMHTMLTableCellElementVAlignPropertyInfo,
    constructDOMHTMLTableCellElementVAlign  ,
    dOMHTMLTableCellElementVAlign           ,
    getDOMHTMLTableCellElementVAlign        ,
    setDOMHTMLTableCellElementVAlign        ,


-- ** Width
    DOMHTMLTableCellElementWidthPropertyInfo,
    constructDOMHTMLTableCellElementWidth   ,
    dOMHTMLTableCellElementWidth            ,
    getDOMHTMLTableCellElementWidth         ,
    setDOMHTMLTableCellElementWidth         ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLTableCellElement = DOMHTMLTableCellElement (ForeignPtr DOMHTMLTableCellElement)
foreign import ccall "webkit_dom_html_table_cell_element_get_type"
    c_webkit_dom_html_table_cell_element_get_type :: IO GType

type instance ParentTypes DOMHTMLTableCellElement = DOMHTMLTableCellElementParentTypes
type DOMHTMLTableCellElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLTableCellElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_table_cell_element_get_type
    

class GObject o => DOMHTMLTableCellElementK o
instance (GObject o, IsDescendantOf DOMHTMLTableCellElement o) => DOMHTMLTableCellElementK o

toDOMHTMLTableCellElement :: DOMHTMLTableCellElementK o => o -> IO DOMHTMLTableCellElement
toDOMHTMLTableCellElement = unsafeCastTo DOMHTMLTableCellElement

noDOMHTMLTableCellElement :: Maybe DOMHTMLTableCellElement
noDOMHTMLTableCellElement = Nothing

type family ResolveDOMHTMLTableCellElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLTableCellElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLTableCellElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLTableCellElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLTableCellElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLTableCellElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLTableCellElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLTableCellElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLTableCellElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLTableCellElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLTableCellElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLTableCellElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLTableCellElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLTableCellElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLTableCellElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLTableCellElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLTableCellElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLTableCellElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLTableCellElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLTableCellElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLTableCellElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLTableCellElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLTableCellElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLTableCellElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLTableCellElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLTableCellElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLTableCellElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLTableCellElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLTableCellElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLTableCellElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLTableCellElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLTableCellElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLTableCellElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLTableCellElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLTableCellElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLTableCellElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLTableCellElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLTableCellElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLTableCellElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLTableCellElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLTableCellElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLTableCellElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAbbr" o = DOMHTMLTableCellElementGetAbbrMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAlign" o = DOMHTMLTableCellElementGetAlignMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getAxis" o = DOMHTMLTableCellElementGetAxisMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getBgColor" o = DOMHTMLTableCellElementGetBgColorMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getCellIndex" o = DOMHTMLTableCellElementGetCellIndexMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getCh" o = DOMHTMLTableCellElementGetChMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getChOff" o = DOMHTMLTableCellElementGetChOffMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getColSpan" o = DOMHTMLTableCellElementGetColSpanMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getHeaders" o = DOMHTMLTableCellElementGetHeadersMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getHeight" o = DOMHTMLTableCellElementGetHeightMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getNoWrap" o = DOMHTMLTableCellElementGetNoWrapMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getRowSpan" o = DOMHTMLTableCellElementGetRowSpanMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getScope" o = DOMHTMLTableCellElementGetScopeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getVAlign" o = DOMHTMLTableCellElementGetVAlignMethodInfo
    ResolveDOMHTMLTableCellElementMethod "getWidth" o = DOMHTMLTableCellElementGetWidthMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setAbbr" o = DOMHTMLTableCellElementSetAbbrMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setAlign" o = DOMHTMLTableCellElementSetAlignMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setAxis" o = DOMHTMLTableCellElementSetAxisMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setBgColor" o = DOMHTMLTableCellElementSetBgColorMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setCh" o = DOMHTMLTableCellElementSetChMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setChOff" o = DOMHTMLTableCellElementSetChOffMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setColSpan" o = DOMHTMLTableCellElementSetColSpanMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setHeaders" o = DOMHTMLTableCellElementSetHeadersMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setHeight" o = DOMHTMLTableCellElementSetHeightMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setNoWrap" o = DOMHTMLTableCellElementSetNoWrapMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setRowSpan" o = DOMHTMLTableCellElementSetRowSpanMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setScope" o = DOMHTMLTableCellElementSetScopeMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setVAlign" o = DOMHTMLTableCellElementSetVAlignMethodInfo
    ResolveDOMHTMLTableCellElementMethod "setWidth" o = DOMHTMLTableCellElementSetWidthMethodInfo
    ResolveDOMHTMLTableCellElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLTableCellElementMethod t DOMHTMLTableCellElement, MethodInfo info DOMHTMLTableCellElement p) => IsLabelProxy t (DOMHTMLTableCellElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLTableCellElementMethod t DOMHTMLTableCellElement, MethodInfo info DOMHTMLTableCellElement p) => IsLabel t (DOMHTMLTableCellElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "abbr"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementAbbr :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementAbbr obj = liftIO $ getObjectPropertyString obj "abbr"

setDOMHTMLTableCellElementAbbr :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementAbbr obj val = liftIO $ setObjectPropertyString obj "abbr" (Just val)

constructDOMHTMLTableCellElementAbbr :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementAbbr val = constructObjectPropertyString "abbr" (Just val)

data DOMHTMLTableCellElementAbbrPropertyInfo
instance AttrInfo DOMHTMLTableCellElementAbbrPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementAbbrPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementAbbrPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementAbbrPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementAbbrPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementAbbrPropertyInfo = "abbr"
    attrGet _ = getDOMHTMLTableCellElementAbbr
    attrSet _ = setDOMHTMLTableCellElementAbbr
    attrConstruct _ = constructDOMHTMLTableCellElementAbbr
    attrClear _ = undefined

-- VVV Prop "align"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementAlign :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementAlign obj = liftIO $ getObjectPropertyString obj "align"

setDOMHTMLTableCellElementAlign :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementAlign obj val = liftIO $ setObjectPropertyString obj "align" (Just val)

constructDOMHTMLTableCellElementAlign :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementAlign val = constructObjectPropertyString "align" (Just val)

data DOMHTMLTableCellElementAlignPropertyInfo
instance AttrInfo DOMHTMLTableCellElementAlignPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementAlignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementAlignPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementAlignPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementAlignPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementAlignPropertyInfo = "align"
    attrGet _ = getDOMHTMLTableCellElementAlign
    attrSet _ = setDOMHTMLTableCellElementAlign
    attrConstruct _ = constructDOMHTMLTableCellElementAlign
    attrClear _ = undefined

-- VVV Prop "axis"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementAxis :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementAxis obj = liftIO $ getObjectPropertyString obj "axis"

setDOMHTMLTableCellElementAxis :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementAxis obj val = liftIO $ setObjectPropertyString obj "axis" (Just val)

constructDOMHTMLTableCellElementAxis :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementAxis val = constructObjectPropertyString "axis" (Just val)

data DOMHTMLTableCellElementAxisPropertyInfo
instance AttrInfo DOMHTMLTableCellElementAxisPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementAxisPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementAxisPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementAxisPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementAxisPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementAxisPropertyInfo = "axis"
    attrGet _ = getDOMHTMLTableCellElementAxis
    attrSet _ = setDOMHTMLTableCellElementAxis
    attrConstruct _ = constructDOMHTMLTableCellElementAxis
    attrClear _ = undefined

-- VVV Prop "bg-color"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementBgColor :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementBgColor obj = liftIO $ getObjectPropertyString obj "bg-color"

setDOMHTMLTableCellElementBgColor :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementBgColor obj val = liftIO $ setObjectPropertyString obj "bg-color" (Just val)

constructDOMHTMLTableCellElementBgColor :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementBgColor val = constructObjectPropertyString "bg-color" (Just val)

data DOMHTMLTableCellElementBgColorPropertyInfo
instance AttrInfo DOMHTMLTableCellElementBgColorPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementBgColorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementBgColorPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementBgColorPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementBgColorPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementBgColorPropertyInfo = "bg-color"
    attrGet _ = getDOMHTMLTableCellElementBgColor
    attrSet _ = setDOMHTMLTableCellElementBgColor
    attrConstruct _ = constructDOMHTMLTableCellElementBgColor
    attrClear _ = undefined

-- VVV Prop "cell-index"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDOMHTMLTableCellElementCellIndex :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m CLong
getDOMHTMLTableCellElementCellIndex obj = liftIO $ getObjectPropertyLong obj "cell-index"

data DOMHTMLTableCellElementCellIndexPropertyInfo
instance AttrInfo DOMHTMLTableCellElementCellIndexPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementCellIndexPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementCellIndexPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DOMHTMLTableCellElementCellIndexPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementCellIndexPropertyInfo = CLong
    type AttrLabel DOMHTMLTableCellElementCellIndexPropertyInfo = "cell-index"
    attrGet _ = getDOMHTMLTableCellElementCellIndex
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "ch"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementCh :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementCh obj = liftIO $ getObjectPropertyString obj "ch"

setDOMHTMLTableCellElementCh :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementCh obj val = liftIO $ setObjectPropertyString obj "ch" (Just val)

constructDOMHTMLTableCellElementCh :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementCh val = constructObjectPropertyString "ch" (Just val)

data DOMHTMLTableCellElementChPropertyInfo
instance AttrInfo DOMHTMLTableCellElementChPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementChPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementChPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementChPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementChPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementChPropertyInfo = "ch"
    attrGet _ = getDOMHTMLTableCellElementCh
    attrSet _ = setDOMHTMLTableCellElementCh
    attrConstruct _ = constructDOMHTMLTableCellElementCh
    attrClear _ = undefined

-- VVV Prop "ch-off"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementChOff :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementChOff obj = liftIO $ getObjectPropertyString obj "ch-off"

setDOMHTMLTableCellElementChOff :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementChOff obj val = liftIO $ setObjectPropertyString obj "ch-off" (Just val)

constructDOMHTMLTableCellElementChOff :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementChOff val = constructObjectPropertyString "ch-off" (Just val)

data DOMHTMLTableCellElementChOffPropertyInfo
instance AttrInfo DOMHTMLTableCellElementChOffPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementChOffPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementChOffPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementChOffPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementChOffPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementChOffPropertyInfo = "ch-off"
    attrGet _ = getDOMHTMLTableCellElementChOff
    attrSet _ = setDOMHTMLTableCellElementChOff
    attrConstruct _ = constructDOMHTMLTableCellElementChOff
    attrClear _ = undefined

-- VVV Prop "col-span"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLTableCellElementColSpan :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m CLong
getDOMHTMLTableCellElementColSpan obj = liftIO $ getObjectPropertyLong obj "col-span"

setDOMHTMLTableCellElementColSpan :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> CLong -> m ()
setDOMHTMLTableCellElementColSpan obj val = liftIO $ setObjectPropertyLong obj "col-span" val

constructDOMHTMLTableCellElementColSpan :: CLong -> IO ([Char], GValue)
constructDOMHTMLTableCellElementColSpan val = constructObjectPropertyLong "col-span" val

data DOMHTMLTableCellElementColSpanPropertyInfo
instance AttrInfo DOMHTMLTableCellElementColSpanPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementColSpanPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementColSpanPropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLTableCellElementColSpanPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementColSpanPropertyInfo = CLong
    type AttrLabel DOMHTMLTableCellElementColSpanPropertyInfo = "col-span"
    attrGet _ = getDOMHTMLTableCellElementColSpan
    attrSet _ = setDOMHTMLTableCellElementColSpan
    attrConstruct _ = constructDOMHTMLTableCellElementColSpan
    attrClear _ = undefined

-- VVV Prop "headers"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementHeaders :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementHeaders obj = liftIO $ getObjectPropertyString obj "headers"

setDOMHTMLTableCellElementHeaders :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementHeaders obj val = liftIO $ setObjectPropertyString obj "headers" (Just val)

constructDOMHTMLTableCellElementHeaders :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementHeaders val = constructObjectPropertyString "headers" (Just val)

data DOMHTMLTableCellElementHeadersPropertyInfo
instance AttrInfo DOMHTMLTableCellElementHeadersPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementHeadersPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementHeadersPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementHeadersPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementHeadersPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementHeadersPropertyInfo = "headers"
    attrGet _ = getDOMHTMLTableCellElementHeaders
    attrSet _ = setDOMHTMLTableCellElementHeaders
    attrConstruct _ = constructDOMHTMLTableCellElementHeaders
    attrClear _ = undefined

-- VVV Prop "height"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementHeight :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementHeight obj = liftIO $ getObjectPropertyString obj "height"

setDOMHTMLTableCellElementHeight :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementHeight obj val = liftIO $ setObjectPropertyString obj "height" (Just val)

constructDOMHTMLTableCellElementHeight :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementHeight val = constructObjectPropertyString "height" (Just val)

data DOMHTMLTableCellElementHeightPropertyInfo
instance AttrInfo DOMHTMLTableCellElementHeightPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementHeightPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementHeightPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementHeightPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementHeightPropertyInfo = "height"
    attrGet _ = getDOMHTMLTableCellElementHeight
    attrSet _ = setDOMHTMLTableCellElementHeight
    attrConstruct _ = constructDOMHTMLTableCellElementHeight
    attrClear _ = undefined

-- VVV Prop "no-wrap"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLTableCellElementNoWrap :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m Bool
getDOMHTMLTableCellElementNoWrap obj = liftIO $ getObjectPropertyBool obj "no-wrap"

setDOMHTMLTableCellElementNoWrap :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> Bool -> m ()
setDOMHTMLTableCellElementNoWrap obj val = liftIO $ setObjectPropertyBool obj "no-wrap" val

constructDOMHTMLTableCellElementNoWrap :: Bool -> IO ([Char], GValue)
constructDOMHTMLTableCellElementNoWrap val = constructObjectPropertyBool "no-wrap" val

data DOMHTMLTableCellElementNoWrapPropertyInfo
instance AttrInfo DOMHTMLTableCellElementNoWrapPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementNoWrapPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementNoWrapPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLTableCellElementNoWrapPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementNoWrapPropertyInfo = Bool
    type AttrLabel DOMHTMLTableCellElementNoWrapPropertyInfo = "no-wrap"
    attrGet _ = getDOMHTMLTableCellElementNoWrap
    attrSet _ = setDOMHTMLTableCellElementNoWrap
    attrConstruct _ = constructDOMHTMLTableCellElementNoWrap
    attrClear _ = undefined

-- VVV Prop "row-span"
   -- Type: TBasicType TLong
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLTableCellElementRowSpan :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m CLong
getDOMHTMLTableCellElementRowSpan obj = liftIO $ getObjectPropertyLong obj "row-span"

setDOMHTMLTableCellElementRowSpan :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> CLong -> m ()
setDOMHTMLTableCellElementRowSpan obj val = liftIO $ setObjectPropertyLong obj "row-span" val

constructDOMHTMLTableCellElementRowSpan :: CLong -> IO ([Char], GValue)
constructDOMHTMLTableCellElementRowSpan val = constructObjectPropertyLong "row-span" val

data DOMHTMLTableCellElementRowSpanPropertyInfo
instance AttrInfo DOMHTMLTableCellElementRowSpanPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementRowSpanPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementRowSpanPropertyInfo = (~) CLong
    type AttrBaseTypeConstraint DOMHTMLTableCellElementRowSpanPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementRowSpanPropertyInfo = CLong
    type AttrLabel DOMHTMLTableCellElementRowSpanPropertyInfo = "row-span"
    attrGet _ = getDOMHTMLTableCellElementRowSpan
    attrSet _ = setDOMHTMLTableCellElementRowSpan
    attrConstruct _ = constructDOMHTMLTableCellElementRowSpan
    attrClear _ = undefined

-- VVV Prop "scope"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementScope :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementScope obj = liftIO $ getObjectPropertyString obj "scope"

setDOMHTMLTableCellElementScope :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementScope obj val = liftIO $ setObjectPropertyString obj "scope" (Just val)

constructDOMHTMLTableCellElementScope :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementScope val = constructObjectPropertyString "scope" (Just val)

data DOMHTMLTableCellElementScopePropertyInfo
instance AttrInfo DOMHTMLTableCellElementScopePropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementScopePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementScopePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementScopePropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementScopePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementScopePropertyInfo = "scope"
    attrGet _ = getDOMHTMLTableCellElementScope
    attrSet _ = setDOMHTMLTableCellElementScope
    attrConstruct _ = constructDOMHTMLTableCellElementScope
    attrClear _ = undefined

-- VVV Prop "v-align"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementVAlign :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementVAlign obj = liftIO $ getObjectPropertyString obj "v-align"

setDOMHTMLTableCellElementVAlign :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementVAlign obj val = liftIO $ setObjectPropertyString obj "v-align" (Just val)

constructDOMHTMLTableCellElementVAlign :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementVAlign val = constructObjectPropertyString "v-align" (Just val)

data DOMHTMLTableCellElementVAlignPropertyInfo
instance AttrInfo DOMHTMLTableCellElementVAlignPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementVAlignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementVAlignPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementVAlignPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementVAlignPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementVAlignPropertyInfo = "v-align"
    attrGet _ = getDOMHTMLTableCellElementVAlign
    attrSet _ = setDOMHTMLTableCellElementVAlign
    attrConstruct _ = constructDOMHTMLTableCellElementVAlign
    attrClear _ = undefined

-- VVV Prop "width"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

getDOMHTMLTableCellElementWidth :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> m (Maybe T.Text)
getDOMHTMLTableCellElementWidth obj = liftIO $ getObjectPropertyString obj "width"

setDOMHTMLTableCellElementWidth :: (MonadIO m, DOMHTMLTableCellElementK o) => o -> T.Text -> m ()
setDOMHTMLTableCellElementWidth obj val = liftIO $ setObjectPropertyString obj "width" (Just val)

constructDOMHTMLTableCellElementWidth :: T.Text -> IO ([Char], GValue)
constructDOMHTMLTableCellElementWidth val = constructObjectPropertyString "width" (Just val)

data DOMHTMLTableCellElementWidthPropertyInfo
instance AttrInfo DOMHTMLTableCellElementWidthPropertyInfo where
    type AttrAllowedOps DOMHTMLTableCellElementWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLTableCellElementWidthPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLTableCellElementWidthPropertyInfo = DOMHTMLTableCellElementK
    type AttrGetType DOMHTMLTableCellElementWidthPropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLTableCellElementWidthPropertyInfo = "width"
    attrGet _ = getDOMHTMLTableCellElementWidth
    attrSet _ = setDOMHTMLTableCellElementWidth
    attrConstruct _ = constructDOMHTMLTableCellElementWidth
    attrClear _ = undefined

type instance AttributeList DOMHTMLTableCellElement = DOMHTMLTableCellElementAttributeList
type DOMHTMLTableCellElementAttributeList = ('[ '("abbr", DOMHTMLTableCellElementAbbrPropertyInfo), '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("align", DOMHTMLTableCellElementAlignPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("axis", DOMHTMLTableCellElementAxisPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("bgColor", DOMHTMLTableCellElementBgColorPropertyInfo), '("cellIndex", DOMHTMLTableCellElementCellIndexPropertyInfo), '("ch", DOMHTMLTableCellElementChPropertyInfo), '("chOff", DOMHTMLTableCellElementChOffPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("colSpan", DOMHTMLTableCellElementColSpanPropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("headers", DOMHTMLTableCellElementHeadersPropertyInfo), '("height", DOMHTMLTableCellElementHeightPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("id", DOMElementIdPropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("noWrap", DOMHTMLTableCellElementNoWrapPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("rowSpan", DOMHTMLTableCellElementRowSpanPropertyInfo), '("scope", DOMHTMLTableCellElementScopePropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("vAlign", DOMHTMLTableCellElementVAlignPropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo), '("width", DOMHTMLTableCellElementWidthPropertyInfo)] :: [(Symbol, *)])

dOMHTMLTableCellElementAbbr :: AttrLabelProxy "abbr"
dOMHTMLTableCellElementAbbr = AttrLabelProxy

dOMHTMLTableCellElementAlign :: AttrLabelProxy "align"
dOMHTMLTableCellElementAlign = AttrLabelProxy

dOMHTMLTableCellElementAxis :: AttrLabelProxy "axis"
dOMHTMLTableCellElementAxis = AttrLabelProxy

dOMHTMLTableCellElementBgColor :: AttrLabelProxy "bgColor"
dOMHTMLTableCellElementBgColor = AttrLabelProxy

dOMHTMLTableCellElementCellIndex :: AttrLabelProxy "cellIndex"
dOMHTMLTableCellElementCellIndex = AttrLabelProxy

dOMHTMLTableCellElementCh :: AttrLabelProxy "ch"
dOMHTMLTableCellElementCh = AttrLabelProxy

dOMHTMLTableCellElementChOff :: AttrLabelProxy "chOff"
dOMHTMLTableCellElementChOff = AttrLabelProxy

dOMHTMLTableCellElementColSpan :: AttrLabelProxy "colSpan"
dOMHTMLTableCellElementColSpan = AttrLabelProxy

dOMHTMLTableCellElementHeaders :: AttrLabelProxy "headers"
dOMHTMLTableCellElementHeaders = AttrLabelProxy

dOMHTMLTableCellElementHeight :: AttrLabelProxy "height"
dOMHTMLTableCellElementHeight = AttrLabelProxy

dOMHTMLTableCellElementNoWrap :: AttrLabelProxy "noWrap"
dOMHTMLTableCellElementNoWrap = AttrLabelProxy

dOMHTMLTableCellElementRowSpan :: AttrLabelProxy "rowSpan"
dOMHTMLTableCellElementRowSpan = AttrLabelProxy

dOMHTMLTableCellElementScope :: AttrLabelProxy "scope"
dOMHTMLTableCellElementScope = AttrLabelProxy

dOMHTMLTableCellElementVAlign :: AttrLabelProxy "vAlign"
dOMHTMLTableCellElementVAlign = AttrLabelProxy

dOMHTMLTableCellElementWidth :: AttrLabelProxy "width"
dOMHTMLTableCellElementWidth = AttrLabelProxy

type instance SignalList DOMHTMLTableCellElement = DOMHTMLTableCellElementSignalList
type DOMHTMLTableCellElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLTableCellElement::get_abbr
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_abbr" webkit_dom_html_table_cell_element_get_abbr :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetAbbr ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetAbbr _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_abbr _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_abbr" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetAbbrMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetAbbrMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetAbbr

-- method DOMHTMLTableCellElement::get_align
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_align" webkit_dom_html_table_cell_element_get_align :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetAlign ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetAlign _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_align _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_align" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetAlignMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetAlignMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetAlign

-- method DOMHTMLTableCellElement::get_axis
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_axis" webkit_dom_html_table_cell_element_get_axis :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetAxis ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetAxis _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_axis _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_axis" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetAxisMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetAxisMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetAxis

-- method DOMHTMLTableCellElement::get_bg_color
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_bg_color" webkit_dom_html_table_cell_element_get_bg_color :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetBgColor ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetBgColor _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_bg_color _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_bg_color" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetBgColorMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetBgColorMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetBgColor

-- method DOMHTMLTableCellElement::get_cell_index
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_cell_index" webkit_dom_html_table_cell_element_get_cell_index :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CLong


dOMHTMLTableCellElementGetCellIndex ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLTableCellElementGetCellIndex _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_cell_index _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLTableCellElementGetCellIndexMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetCellIndexMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetCellIndex

-- method DOMHTMLTableCellElement::get_ch
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_ch" webkit_dom_html_table_cell_element_get_ch :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetCh ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetCh _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_ch _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_ch" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetChMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetChMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetCh

-- method DOMHTMLTableCellElement::get_ch_off
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_ch_off" webkit_dom_html_table_cell_element_get_ch_off :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetChOff ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetChOff _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_ch_off _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_ch_off" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetChOffMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetChOffMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetChOff

-- method DOMHTMLTableCellElement::get_col_span
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_col_span" webkit_dom_html_table_cell_element_get_col_span :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CLong


dOMHTMLTableCellElementGetColSpan ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLTableCellElementGetColSpan _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_col_span _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLTableCellElementGetColSpanMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetColSpanMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetColSpan

-- method DOMHTMLTableCellElement::get_headers
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_headers" webkit_dom_html_table_cell_element_get_headers :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetHeaders ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetHeaders _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_headers _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_headers" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetHeadersMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetHeadersMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetHeaders

-- method DOMHTMLTableCellElement::get_height
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_height" webkit_dom_html_table_cell_element_get_height :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetHeight ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetHeight _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_height _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_height" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetHeightMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetHeightMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetHeight

-- method DOMHTMLTableCellElement::get_no_wrap
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_no_wrap" webkit_dom_html_table_cell_element_get_no_wrap :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CInt


dOMHTMLTableCellElementGetNoWrap ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLTableCellElementGetNoWrap _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_no_wrap _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetNoWrapMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetNoWrapMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetNoWrap

-- method DOMHTMLTableCellElement::get_row_span
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_row_span" webkit_dom_html_table_cell_element_get_row_span :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CLong


dOMHTMLTableCellElementGetRowSpan ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m CLong                              -- result
dOMHTMLTableCellElementGetRowSpan _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_row_span _obj'
    touchManagedPtr _obj
    return result

data DOMHTMLTableCellElementGetRowSpanMethodInfo
instance (signature ~ (m CLong), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetRowSpanMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetRowSpan

-- method DOMHTMLTableCellElement::get_scope
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_scope" webkit_dom_html_table_cell_element_get_scope :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetScope ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetScope _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_scope _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_scope" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetScopeMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetScopeMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetScope

-- method DOMHTMLTableCellElement::get_v_align
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_v_align" webkit_dom_html_table_cell_element_get_v_align :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetVAlign ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetVAlign _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_v_align _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_v_align" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetVAlignMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetVAlignMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetVAlign

-- method DOMHTMLTableCellElement::get_width
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_get_width" webkit_dom_html_table_cell_element_get_width :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    IO CString


dOMHTMLTableCellElementGetWidth ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLTableCellElementGetWidth _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_table_cell_element_get_width _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_table_cell_element_get_width" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLTableCellElementGetWidthMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementGetWidthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementGetWidth

-- method DOMHTMLTableCellElement::set_abbr
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_abbr" webkit_dom_html_table_cell_element_set_abbr :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetAbbr ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetAbbr _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_abbr _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetAbbrMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetAbbrMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetAbbr

-- method DOMHTMLTableCellElement::set_align
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_align" webkit_dom_html_table_cell_element_set_align :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetAlign ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetAlign _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_align _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetAlignMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetAlignMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetAlign

-- method DOMHTMLTableCellElement::set_axis
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_axis" webkit_dom_html_table_cell_element_set_axis :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetAxis ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetAxis _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_axis _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetAxisMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetAxisMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetAxis

-- method DOMHTMLTableCellElement::set_bg_color
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_bg_color" webkit_dom_html_table_cell_element_set_bg_color :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetBgColor ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetBgColor _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_bg_color _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetBgColorMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetBgColorMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetBgColor

-- method DOMHTMLTableCellElement::set_ch
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_ch" webkit_dom_html_table_cell_element_set_ch :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetCh ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetCh _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_ch _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetChMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetChMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetCh

-- method DOMHTMLTableCellElement::set_ch_off
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_ch_off" webkit_dom_html_table_cell_element_set_ch_off :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetChOff ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetChOff _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_ch_off _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetChOffMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetChOffMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetChOff

-- method DOMHTMLTableCellElement::set_col_span
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TLong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_col_span" webkit_dom_html_table_cell_element_set_col_span :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CLong ->                                -- value : TBasicType TLong
    IO ()


dOMHTMLTableCellElementSetColSpan ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> CLong                                -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetColSpan _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_table_cell_element_set_col_span _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLTableCellElementSetColSpanMethodInfo
instance (signature ~ (CLong -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetColSpanMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetColSpan

-- method DOMHTMLTableCellElement::set_headers
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_headers" webkit_dom_html_table_cell_element_set_headers :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetHeaders ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetHeaders _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_headers _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetHeadersMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetHeadersMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetHeaders

-- method DOMHTMLTableCellElement::set_height
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_height" webkit_dom_html_table_cell_element_set_height :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetHeight ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetHeight _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_height _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetHeightMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetHeightMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetHeight

-- method DOMHTMLTableCellElement::set_no_wrap
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_no_wrap" webkit_dom_html_table_cell_element_set_no_wrap :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLTableCellElementSetNoWrap ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetNoWrap _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_table_cell_element_set_no_wrap _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLTableCellElementSetNoWrapMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetNoWrapMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetNoWrap

-- method DOMHTMLTableCellElement::set_row_span
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TLong, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_row_span" webkit_dom_html_table_cell_element_set_row_span :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CLong ->                                -- value : TBasicType TLong
    IO ()


dOMHTMLTableCellElementSetRowSpan ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> CLong                                -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetRowSpan _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_dom_html_table_cell_element_set_row_span _obj' value
    touchManagedPtr _obj
    return ()

data DOMHTMLTableCellElementSetRowSpanMethodInfo
instance (signature ~ (CLong -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetRowSpanMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetRowSpan

-- method DOMHTMLTableCellElement::set_scope
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_scope" webkit_dom_html_table_cell_element_set_scope :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetScope ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetScope _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_scope _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetScopeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetScopeMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetScope

-- method DOMHTMLTableCellElement::set_v_align
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_v_align" webkit_dom_html_table_cell_element_set_v_align :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetVAlign ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetVAlign _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_v_align _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetVAlignMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetVAlignMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetVAlign

-- method DOMHTMLTableCellElement::set_width
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_table_cell_element_set_width" webkit_dom_html_table_cell_element_set_width :: 
    Ptr DOMHTMLTableCellElement ->          -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLTableCellElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLTableCellElementSetWidth ::
    (MonadIO m, DOMHTMLTableCellElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLTableCellElementSetWidth _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_table_cell_element_set_width _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLTableCellElementSetWidthMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLTableCellElementK a) => MethodInfo DOMHTMLTableCellElementSetWidthMethodInfo a signature where
    overloadedMethod _ = dOMHTMLTableCellElementSetWidth


