

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.DOMHTMLUListElement
    ( 

-- * Exported types
    DOMHTMLUListElement(..)                 ,
    DOMHTMLUListElementK                    ,
    toDOMHTMLUListElement                   ,
    noDOMHTMLUListElement                   ,


 -- * Methods
-- ** dOMHTMLUListElementGetCompact
    DOMHTMLUListElementGetCompactMethodInfo ,
    dOMHTMLUListElementGetCompact           ,


-- ** dOMHTMLUListElementGetTypeAttr
    DOMHTMLUListElementGetTypeAttrMethodInfo,
    dOMHTMLUListElementGetTypeAttr          ,


-- ** dOMHTMLUListElementSetCompact
    DOMHTMLUListElementSetCompactMethodInfo ,
    dOMHTMLUListElementSetCompact           ,


-- ** dOMHTMLUListElementSetTypeAttr
    DOMHTMLUListElementSetTypeAttrMethodInfo,
    dOMHTMLUListElementSetTypeAttr          ,




 -- * Properties
-- ** Compact
    DOMHTMLUListElementCompactPropertyInfo  ,
    constructDOMHTMLUListElementCompact     ,
    dOMHTMLUListElementCompact              ,
    getDOMHTMLUListElementCompact           ,
    setDOMHTMLUListElementCompact           ,


-- ** Type
    DOMHTMLUListElementTypePropertyInfo     ,
    clearDOMHTMLUListElementType            ,
    constructDOMHTMLUListElementType        ,
    dOMHTMLUListElementType                 ,
    getDOMHTMLUListElementType              ,
    setDOMHTMLUListElementType              ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype DOMHTMLUListElement = DOMHTMLUListElement (ForeignPtr DOMHTMLUListElement)
foreign import ccall "webkit_dom_html_u_list_element_get_type"
    c_webkit_dom_html_u_list_element_get_type :: IO GType

type instance ParentTypes DOMHTMLUListElement = DOMHTMLUListElementParentTypes
type DOMHTMLUListElementParentTypes = '[DOMHTMLElement, DOMElement, DOMNode, DOMObject, GObject.Object, DOMEventTarget]

instance GObject DOMHTMLUListElement where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_dom_html_u_list_element_get_type
    

class GObject o => DOMHTMLUListElementK o
instance (GObject o, IsDescendantOf DOMHTMLUListElement o) => DOMHTMLUListElementK o

toDOMHTMLUListElement :: DOMHTMLUListElementK o => o -> IO DOMHTMLUListElement
toDOMHTMLUListElement = unsafeCastTo DOMHTMLUListElement

noDOMHTMLUListElement :: Maybe DOMHTMLUListElement
noDOMHTMLUListElement = Nothing

type family ResolveDOMHTMLUListElementMethod (t :: Symbol) (o :: *) :: * where
    ResolveDOMHTMLUListElementMethod "addEventListener" o = DOMEventTargetAddEventListenerMethodInfo
    ResolveDOMHTMLUListElementMethod "appendChild" o = DOMNodeAppendChildMethodInfo
    ResolveDOMHTMLUListElementMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDOMHTMLUListElementMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDOMHTMLUListElementMethod "blur" o = DOMElementBlurMethodInfo
    ResolveDOMHTMLUListElementMethod "click" o = DOMHTMLElementClickMethodInfo
    ResolveDOMHTMLUListElementMethod "cloneNode" o = DOMNodeCloneNodeMethodInfo
    ResolveDOMHTMLUListElementMethod "compareDocumentPosition" o = DOMNodeCompareDocumentPositionMethodInfo
    ResolveDOMHTMLUListElementMethod "contains" o = DOMNodeContainsMethodInfo
    ResolveDOMHTMLUListElementMethod "dispatchEvent" o = DOMEventTargetDispatchEventMethodInfo
    ResolveDOMHTMLUListElementMethod "focus" o = DOMElementFocusMethodInfo
    ResolveDOMHTMLUListElementMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDOMHTMLUListElementMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDOMHTMLUListElementMethod "hasAttribute" o = DOMElementHasAttributeMethodInfo
    ResolveDOMHTMLUListElementMethod "hasAttributeNs" o = DOMElementHasAttributeNsMethodInfo
    ResolveDOMHTMLUListElementMethod "hasAttributes" o = DOMElementHasAttributesMethodInfo
    ResolveDOMHTMLUListElementMethod "hasChildNodes" o = DOMNodeHasChildNodesMethodInfo
    ResolveDOMHTMLUListElementMethod "insertBefore" o = DOMNodeInsertBeforeMethodInfo
    ResolveDOMHTMLUListElementMethod "isDefaultNamespace" o = DOMNodeIsDefaultNamespaceMethodInfo
    ResolveDOMHTMLUListElementMethod "isEqualNode" o = DOMNodeIsEqualNodeMethodInfo
    ResolveDOMHTMLUListElementMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDOMHTMLUListElementMethod "isSameNode" o = DOMNodeIsSameNodeMethodInfo
    ResolveDOMHTMLUListElementMethod "isSupported" o = DOMNodeIsSupportedMethodInfo
    ResolveDOMHTMLUListElementMethod "lookupNamespaceUri" o = DOMNodeLookupNamespaceUriMethodInfo
    ResolveDOMHTMLUListElementMethod "lookupPrefix" o = DOMNodeLookupPrefixMethodInfo
    ResolveDOMHTMLUListElementMethod "normalize" o = DOMNodeNormalizeMethodInfo
    ResolveDOMHTMLUListElementMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDOMHTMLUListElementMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDOMHTMLUListElementMethod "querySelector" o = DOMElementQuerySelectorMethodInfo
    ResolveDOMHTMLUListElementMethod "querySelectorAll" o = DOMElementQuerySelectorAllMethodInfo
    ResolveDOMHTMLUListElementMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDOMHTMLUListElementMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDOMHTMLUListElementMethod "removeAttribute" o = DOMElementRemoveAttributeMethodInfo
    ResolveDOMHTMLUListElementMethod "removeAttributeNode" o = DOMElementRemoveAttributeNodeMethodInfo
    ResolveDOMHTMLUListElementMethod "removeAttributeNs" o = DOMElementRemoveAttributeNsMethodInfo
    ResolveDOMHTMLUListElementMethod "removeChild" o = DOMNodeRemoveChildMethodInfo
    ResolveDOMHTMLUListElementMethod "removeEventListener" o = DOMEventTargetRemoveEventListenerMethodInfo
    ResolveDOMHTMLUListElementMethod "replaceChild" o = DOMNodeReplaceChildMethodInfo
    ResolveDOMHTMLUListElementMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDOMHTMLUListElementMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDOMHTMLUListElementMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDOMHTMLUListElementMethod "scrollByLines" o = DOMElementScrollByLinesMethodInfo
    ResolveDOMHTMLUListElementMethod "scrollByPages" o = DOMElementScrollByPagesMethodInfo
    ResolveDOMHTMLUListElementMethod "scrollIntoView" o = DOMElementScrollIntoViewMethodInfo
    ResolveDOMHTMLUListElementMethod "scrollIntoViewIfNeeded" o = DOMElementScrollIntoViewIfNeededMethodInfo
    ResolveDOMHTMLUListElementMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDOMHTMLUListElementMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDOMHTMLUListElementMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDOMHTMLUListElementMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDOMHTMLUListElementMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDOMHTMLUListElementMethod "getAccessKey" o = DOMHTMLElementGetAccessKeyMethodInfo
    ResolveDOMHTMLUListElementMethod "getAttribute" o = DOMElementGetAttributeMethodInfo
    ResolveDOMHTMLUListElementMethod "getAttributeNode" o = DOMElementGetAttributeNodeMethodInfo
    ResolveDOMHTMLUListElementMethod "getAttributeNodeNs" o = DOMElementGetAttributeNodeNsMethodInfo
    ResolveDOMHTMLUListElementMethod "getAttributeNs" o = DOMElementGetAttributeNsMethodInfo
    ResolveDOMHTMLUListElementMethod "getAttributes" o = DOMElementGetAttributesMethodInfo
    ResolveDOMHTMLUListElementMethod "getBaseUri" o = DOMNodeGetBaseUriMethodInfo
    ResolveDOMHTMLUListElementMethod "getChildElementCount" o = DOMElementGetChildElementCountMethodInfo
    ResolveDOMHTMLUListElementMethod "getChildNodes" o = DOMNodeGetChildNodesMethodInfo
    ResolveDOMHTMLUListElementMethod "getClassName" o = DOMElementGetClassNameMethodInfo
    ResolveDOMHTMLUListElementMethod "getClientHeight" o = DOMElementGetClientHeightMethodInfo
    ResolveDOMHTMLUListElementMethod "getClientLeft" o = DOMElementGetClientLeftMethodInfo
    ResolveDOMHTMLUListElementMethod "getClientTop" o = DOMElementGetClientTopMethodInfo
    ResolveDOMHTMLUListElementMethod "getClientWidth" o = DOMElementGetClientWidthMethodInfo
    ResolveDOMHTMLUListElementMethod "getCompact" o = DOMHTMLUListElementGetCompactMethodInfo
    ResolveDOMHTMLUListElementMethod "getContentEditable" o = DOMHTMLElementGetContentEditableMethodInfo
    ResolveDOMHTMLUListElementMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDOMHTMLUListElementMethod "getDir" o = DOMHTMLElementGetDirMethodInfo
    ResolveDOMHTMLUListElementMethod "getElementsByClassName" o = DOMElementGetElementsByClassNameMethodInfo
    ResolveDOMHTMLUListElementMethod "getElementsByClassNameAsHtmlCollection" o = DOMElementGetElementsByClassNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLUListElementMethod "getElementsByTagName" o = DOMElementGetElementsByTagNameMethodInfo
    ResolveDOMHTMLUListElementMethod "getElementsByTagNameAsHtmlCollection" o = DOMElementGetElementsByTagNameAsHtmlCollectionMethodInfo
    ResolveDOMHTMLUListElementMethod "getElementsByTagNameNs" o = DOMElementGetElementsByTagNameNsMethodInfo
    ResolveDOMHTMLUListElementMethod "getElementsByTagNameNsAsHtmlCollection" o = DOMElementGetElementsByTagNameNsAsHtmlCollectionMethodInfo
    ResolveDOMHTMLUListElementMethod "getFirstChild" o = DOMNodeGetFirstChildMethodInfo
    ResolveDOMHTMLUListElementMethod "getFirstElementChild" o = DOMElementGetFirstElementChildMethodInfo
    ResolveDOMHTMLUListElementMethod "getId" o = DOMElementGetIdMethodInfo
    ResolveDOMHTMLUListElementMethod "getInnerText" o = DOMHTMLElementGetInnerTextMethodInfo
    ResolveDOMHTMLUListElementMethod "getIsContentEditable" o = DOMHTMLElementGetIsContentEditableMethodInfo
    ResolveDOMHTMLUListElementMethod "getLang" o = DOMHTMLElementGetLangMethodInfo
    ResolveDOMHTMLUListElementMethod "getLastChild" o = DOMNodeGetLastChildMethodInfo
    ResolveDOMHTMLUListElementMethod "getLastElementChild" o = DOMElementGetLastElementChildMethodInfo
    ResolveDOMHTMLUListElementMethod "getLocalName" o = DOMNodeGetLocalNameMethodInfo
    ResolveDOMHTMLUListElementMethod "getNamespaceUri" o = DOMNodeGetNamespaceUriMethodInfo
    ResolveDOMHTMLUListElementMethod "getNextElementSibling" o = DOMElementGetNextElementSiblingMethodInfo
    ResolveDOMHTMLUListElementMethod "getNextSibling" o = DOMNodeGetNextSiblingMethodInfo
    ResolveDOMHTMLUListElementMethod "getNodeName" o = DOMNodeGetNodeNameMethodInfo
    ResolveDOMHTMLUListElementMethod "getNodeType" o = DOMNodeGetNodeTypeMethodInfo
    ResolveDOMHTMLUListElementMethod "getNodeValue" o = DOMNodeGetNodeValueMethodInfo
    ResolveDOMHTMLUListElementMethod "getOffsetHeight" o = DOMElementGetOffsetHeightMethodInfo
    ResolveDOMHTMLUListElementMethod "getOffsetLeft" o = DOMElementGetOffsetLeftMethodInfo
    ResolveDOMHTMLUListElementMethod "getOffsetParent" o = DOMElementGetOffsetParentMethodInfo
    ResolveDOMHTMLUListElementMethod "getOffsetTop" o = DOMElementGetOffsetTopMethodInfo
    ResolveDOMHTMLUListElementMethod "getOffsetWidth" o = DOMElementGetOffsetWidthMethodInfo
    ResolveDOMHTMLUListElementMethod "getOuterText" o = DOMHTMLElementGetOuterTextMethodInfo
    ResolveDOMHTMLUListElementMethod "getOwnerDocument" o = DOMNodeGetOwnerDocumentMethodInfo
    ResolveDOMHTMLUListElementMethod "getParentElement" o = DOMNodeGetParentElementMethodInfo
    ResolveDOMHTMLUListElementMethod "getParentNode" o = DOMNodeGetParentNodeMethodInfo
    ResolveDOMHTMLUListElementMethod "getPrefix" o = DOMNodeGetPrefixMethodInfo
    ResolveDOMHTMLUListElementMethod "getPreviousElementSibling" o = DOMElementGetPreviousElementSiblingMethodInfo
    ResolveDOMHTMLUListElementMethod "getPreviousSibling" o = DOMNodeGetPreviousSiblingMethodInfo
    ResolveDOMHTMLUListElementMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDOMHTMLUListElementMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDOMHTMLUListElementMethod "getScrollHeight" o = DOMElementGetScrollHeightMethodInfo
    ResolveDOMHTMLUListElementMethod "getScrollLeft" o = DOMElementGetScrollLeftMethodInfo
    ResolveDOMHTMLUListElementMethod "getScrollTop" o = DOMElementGetScrollTopMethodInfo
    ResolveDOMHTMLUListElementMethod "getScrollWidth" o = DOMElementGetScrollWidthMethodInfo
    ResolveDOMHTMLUListElementMethod "getStyle" o = DOMElementGetStyleMethodInfo
    ResolveDOMHTMLUListElementMethod "getTabIndex" o = DOMHTMLElementGetTabIndexMethodInfo
    ResolveDOMHTMLUListElementMethod "getTagName" o = DOMElementGetTagNameMethodInfo
    ResolveDOMHTMLUListElementMethod "getTextContent" o = DOMNodeGetTextContentMethodInfo
    ResolveDOMHTMLUListElementMethod "getTitle" o = DOMHTMLElementGetTitleMethodInfo
    ResolveDOMHTMLUListElementMethod "getTypeAttr" o = DOMHTMLUListElementGetTypeAttrMethodInfo
    ResolveDOMHTMLUListElementMethod "setAccessKey" o = DOMHTMLElementSetAccessKeyMethodInfo
    ResolveDOMHTMLUListElementMethod "setAttribute" o = DOMElementSetAttributeMethodInfo
    ResolveDOMHTMLUListElementMethod "setAttributeNode" o = DOMElementSetAttributeNodeMethodInfo
    ResolveDOMHTMLUListElementMethod "setAttributeNodeNs" o = DOMElementSetAttributeNodeNsMethodInfo
    ResolveDOMHTMLUListElementMethod "setAttributeNs" o = DOMElementSetAttributeNsMethodInfo
    ResolveDOMHTMLUListElementMethod "setClassName" o = DOMElementSetClassNameMethodInfo
    ResolveDOMHTMLUListElementMethod "setCompact" o = DOMHTMLUListElementSetCompactMethodInfo
    ResolveDOMHTMLUListElementMethod "setContentEditable" o = DOMHTMLElementSetContentEditableMethodInfo
    ResolveDOMHTMLUListElementMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDOMHTMLUListElementMethod "setDir" o = DOMHTMLElementSetDirMethodInfo
    ResolveDOMHTMLUListElementMethod "setId" o = DOMElementSetIdMethodInfo
    ResolveDOMHTMLUListElementMethod "setInnerText" o = DOMHTMLElementSetInnerTextMethodInfo
    ResolveDOMHTMLUListElementMethod "setLang" o = DOMHTMLElementSetLangMethodInfo
    ResolveDOMHTMLUListElementMethod "setNodeValue" o = DOMNodeSetNodeValueMethodInfo
    ResolveDOMHTMLUListElementMethod "setOuterText" o = DOMHTMLElementSetOuterTextMethodInfo
    ResolveDOMHTMLUListElementMethod "setPrefix" o = DOMNodeSetPrefixMethodInfo
    ResolveDOMHTMLUListElementMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDOMHTMLUListElementMethod "setScrollLeft" o = DOMElementSetScrollLeftMethodInfo
    ResolveDOMHTMLUListElementMethod "setScrollTop" o = DOMElementSetScrollTopMethodInfo
    ResolveDOMHTMLUListElementMethod "setTabIndex" o = DOMHTMLElementSetTabIndexMethodInfo
    ResolveDOMHTMLUListElementMethod "setTextContent" o = DOMNodeSetTextContentMethodInfo
    ResolveDOMHTMLUListElementMethod "setTitle" o = DOMHTMLElementSetTitleMethodInfo
    ResolveDOMHTMLUListElementMethod "setTypeAttr" o = DOMHTMLUListElementSetTypeAttrMethodInfo
    ResolveDOMHTMLUListElementMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDOMHTMLUListElementMethod t DOMHTMLUListElement, MethodInfo info DOMHTMLUListElement p) => IsLabelProxy t (DOMHTMLUListElement -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDOMHTMLUListElementMethod t DOMHTMLUListElement, MethodInfo info DOMHTMLUListElement p) => IsLabel t (DOMHTMLUListElement -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "compact"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDOMHTMLUListElementCompact :: (MonadIO m, DOMHTMLUListElementK o) => o -> m Bool
getDOMHTMLUListElementCompact obj = liftIO $ getObjectPropertyBool obj "compact"

setDOMHTMLUListElementCompact :: (MonadIO m, DOMHTMLUListElementK o) => o -> Bool -> m ()
setDOMHTMLUListElementCompact obj val = liftIO $ setObjectPropertyBool obj "compact" val

constructDOMHTMLUListElementCompact :: Bool -> IO ([Char], GValue)
constructDOMHTMLUListElementCompact val = constructObjectPropertyBool "compact" val

data DOMHTMLUListElementCompactPropertyInfo
instance AttrInfo DOMHTMLUListElementCompactPropertyInfo where
    type AttrAllowedOps DOMHTMLUListElementCompactPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DOMHTMLUListElementCompactPropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DOMHTMLUListElementCompactPropertyInfo = DOMHTMLUListElementK
    type AttrGetType DOMHTMLUListElementCompactPropertyInfo = Bool
    type AttrLabel DOMHTMLUListElementCompactPropertyInfo = "compact"
    attrGet _ = getDOMHTMLUListElementCompact
    attrSet _ = setDOMHTMLUListElementCompact
    attrConstruct _ = constructDOMHTMLUListElementCompact
    attrClear _ = undefined

-- VVV Prop "type"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

getDOMHTMLUListElementType :: (MonadIO m, DOMHTMLUListElementK o) => o -> m (Maybe T.Text)
getDOMHTMLUListElementType obj = liftIO $ getObjectPropertyString obj "type"

setDOMHTMLUListElementType :: (MonadIO m, DOMHTMLUListElementK o) => o -> T.Text -> m ()
setDOMHTMLUListElementType obj val = liftIO $ setObjectPropertyString obj "type" (Just val)

constructDOMHTMLUListElementType :: T.Text -> IO ([Char], GValue)
constructDOMHTMLUListElementType val = constructObjectPropertyString "type" (Just val)

clearDOMHTMLUListElementType :: (MonadIO m, DOMHTMLUListElementK o) => o -> m ()
clearDOMHTMLUListElementType obj = liftIO $ setObjectPropertyString obj "type" (Nothing :: Maybe T.Text)

data DOMHTMLUListElementTypePropertyInfo
instance AttrInfo DOMHTMLUListElementTypePropertyInfo where
    type AttrAllowedOps DOMHTMLUListElementTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DOMHTMLUListElementTypePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint DOMHTMLUListElementTypePropertyInfo = DOMHTMLUListElementK
    type AttrGetType DOMHTMLUListElementTypePropertyInfo = (Maybe T.Text)
    type AttrLabel DOMHTMLUListElementTypePropertyInfo = "type"
    attrGet _ = getDOMHTMLUListElementType
    attrSet _ = setDOMHTMLUListElementType
    attrConstruct _ = constructDOMHTMLUListElementType
    attrClear _ = clearDOMHTMLUListElementType

type instance AttributeList DOMHTMLUListElement = DOMHTMLUListElementAttributeList
type DOMHTMLUListElementAttributeList = ('[ '("accessKey", DOMHTMLElementAccessKeyPropertyInfo), '("attributes", DOMElementAttributesPropertyInfo), '("baseUri", DOMNodeBaseUriPropertyInfo), '("childElementCount", DOMElementChildElementCountPropertyInfo), '("childNodes", DOMNodeChildNodesPropertyInfo), '("children", DOMElementChildrenPropertyInfo), '("className", DOMElementClassNamePropertyInfo), '("clientHeight", DOMElementClientHeightPropertyInfo), '("clientLeft", DOMElementClientLeftPropertyInfo), '("clientTop", DOMElementClientTopPropertyInfo), '("clientWidth", DOMElementClientWidthPropertyInfo), '("compact", DOMHTMLUListElementCompactPropertyInfo), '("contentEditable", DOMHTMLElementContentEditablePropertyInfo), '("coreObject", DOMObjectCoreObjectPropertyInfo), '("dir", DOMHTMLElementDirPropertyInfo), '("draggable", DOMHTMLElementDraggablePropertyInfo), '("firstChild", DOMNodeFirstChildPropertyInfo), '("firstElementChild", DOMElementFirstElementChildPropertyInfo), '("hidden", DOMHTMLElementHiddenPropertyInfo), '("id", DOMElementIdPropertyInfo), '("innerHtml", DOMElementInnerHtmlPropertyInfo), '("innerText", DOMHTMLElementInnerTextPropertyInfo), '("isContentEditable", DOMHTMLElementIsContentEditablePropertyInfo), '("lang", DOMHTMLElementLangPropertyInfo), '("lastChild", DOMNodeLastChildPropertyInfo), '("lastElementChild", DOMElementLastElementChildPropertyInfo), '("localName", DOMNodeLocalNamePropertyInfo), '("namespaceUri", DOMNodeNamespaceUriPropertyInfo), '("nextElementSibling", DOMElementNextElementSiblingPropertyInfo), '("nextSibling", DOMNodeNextSiblingPropertyInfo), '("nodeName", DOMNodeNodeNamePropertyInfo), '("nodeType", DOMNodeNodeTypePropertyInfo), '("nodeValue", DOMNodeNodeValuePropertyInfo), '("offsetHeight", DOMElementOffsetHeightPropertyInfo), '("offsetLeft", DOMElementOffsetLeftPropertyInfo), '("offsetParent", DOMElementOffsetParentPropertyInfo), '("offsetTop", DOMElementOffsetTopPropertyInfo), '("offsetWidth", DOMElementOffsetWidthPropertyInfo), '("outerHtml", DOMElementOuterHtmlPropertyInfo), '("outerText", DOMHTMLElementOuterTextPropertyInfo), '("ownerDocument", DOMNodeOwnerDocumentPropertyInfo), '("parentElement", DOMNodeParentElementPropertyInfo), '("parentNode", DOMNodeParentNodePropertyInfo), '("prefix", DOMNodePrefixPropertyInfo), '("previousElementSibling", DOMElementPreviousElementSiblingPropertyInfo), '("previousSibling", DOMNodePreviousSiblingPropertyInfo), '("scrollHeight", DOMElementScrollHeightPropertyInfo), '("scrollLeft", DOMElementScrollLeftPropertyInfo), '("scrollTop", DOMElementScrollTopPropertyInfo), '("scrollWidth", DOMElementScrollWidthPropertyInfo), '("spellcheck", DOMHTMLElementSpellcheckPropertyInfo), '("style", DOMElementStylePropertyInfo), '("tabIndex", DOMHTMLElementTabIndexPropertyInfo), '("tagName", DOMElementTagNamePropertyInfo), '("textContent", DOMNodeTextContentPropertyInfo), '("title", DOMHTMLElementTitlePropertyInfo), '("translate", DOMHTMLElementTranslatePropertyInfo), '("treeRoot", DOMNodeTreeRootPropertyInfo), '("type", DOMHTMLUListElementTypePropertyInfo), '("webkitRegionOverset", DOMElementWebkitRegionOversetPropertyInfo), '("webkitdropzone", DOMHTMLElementWebkitdropzonePropertyInfo)] :: [(Symbol, *)])

dOMHTMLUListElementCompact :: AttrLabelProxy "compact"
dOMHTMLUListElementCompact = AttrLabelProxy

dOMHTMLUListElementType :: AttrLabelProxy "type"
dOMHTMLUListElementType = AttrLabelProxy

type instance SignalList DOMHTMLUListElement = DOMHTMLUListElementSignalList
type DOMHTMLUListElementSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method DOMHTMLUListElement::get_compact
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLUListElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_u_list_element_get_compact" webkit_dom_html_u_list_element_get_compact :: 
    Ptr DOMHTMLUListElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLUListElement"
    IO CInt


dOMHTMLUListElementGetCompact ::
    (MonadIO m, DOMHTMLUListElementK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
dOMHTMLUListElementGetCompact _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_u_list_element_get_compact _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DOMHTMLUListElementGetCompactMethodInfo
instance (signature ~ (m Bool), MonadIO m, DOMHTMLUListElementK a) => MethodInfo DOMHTMLUListElementGetCompactMethodInfo a signature where
    overloadedMethod _ = dOMHTMLUListElementGetCompact

-- method DOMHTMLUListElement::get_type_attr
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLUListElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_u_list_element_get_type_attr" webkit_dom_html_u_list_element_get_type_attr :: 
    Ptr DOMHTMLUListElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLUListElement"
    IO CString


dOMHTMLUListElementGetTypeAttr ::
    (MonadIO m, DOMHTMLUListElementK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
dOMHTMLUListElementGetTypeAttr _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_dom_html_u_list_element_get_type_attr _obj'
    checkUnexpectedReturnNULL "webkit_dom_html_u_list_element_get_type_attr" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    return result'

data DOMHTMLUListElementGetTypeAttrMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DOMHTMLUListElementK a) => MethodInfo DOMHTMLUListElementGetTypeAttrMethodInfo a signature where
    overloadedMethod _ = dOMHTMLUListElementGetTypeAttr

-- method DOMHTMLUListElement::set_compact
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLUListElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_u_list_element_set_compact" webkit_dom_html_u_list_element_set_compact :: 
    Ptr DOMHTMLUListElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLUListElement"
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()


dOMHTMLUListElementSetCompact ::
    (MonadIO m, DOMHTMLUListElementK a) =>
    a                                       -- _obj
    -> Bool                                 -- value
    -> m ()                                 -- result
dOMHTMLUListElementSetCompact _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let value' = (fromIntegral . fromEnum) value
    webkit_dom_html_u_list_element_set_compact _obj' value'
    touchManagedPtr _obj
    return ()

data DOMHTMLUListElementSetCompactMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DOMHTMLUListElementK a) => MethodInfo DOMHTMLUListElementSetCompactMethodInfo a signature where
    overloadedMethod _ = dOMHTMLUListElementSetCompact

-- method DOMHTMLUListElement::set_type_attr
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "DOMHTMLUListElement", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_dom_html_u_list_element_set_type_attr" webkit_dom_html_u_list_element_set_type_attr :: 
    Ptr DOMHTMLUListElement ->              -- _obj : TInterface "WebKit2WebExtension" "DOMHTMLUListElement"
    CString ->                              -- value : TBasicType TUTF8
    IO ()


dOMHTMLUListElementSetTypeAttr ::
    (MonadIO m, DOMHTMLUListElementK a) =>
    a                                       -- _obj
    -> T.Text                               -- value
    -> m ()                                 -- result
dOMHTMLUListElementSetTypeAttr _obj value = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    value' <- textToCString value
    webkit_dom_html_u_list_element_set_type_attr _obj' value'
    touchManagedPtr _obj
    freeMem value'
    return ()

data DOMHTMLUListElementSetTypeAttrMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DOMHTMLUListElementK a) => MethodInfo DOMHTMLUListElementSetTypeAttrMethodInfo a signature where
    overloadedMethod _ = dOMHTMLUListElementSetTypeAttr


