

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.Frame
    ( 

-- * Exported types
    Frame(..)                               ,
    FrameK                                  ,
    toFrame                                 ,
    noFrame                                 ,


 -- * Methods
-- ** frameGetJavascriptContextForScriptWorld
    FrameGetJavascriptContextForScriptWorldMethodInfo,
    frameGetJavascriptContextForScriptWorld ,


-- ** frameGetJavascriptGlobalContext
    FrameGetJavascriptGlobalContextMethodInfo,
    frameGetJavascriptGlobalContext         ,


-- ** frameGetUri
    FrameGetUriMethodInfo                   ,
    frameGetUri                             ,


-- ** frameIsMainFrame
    FrameIsMainFrameMethodInfo              ,
    frameIsMainFrame                        ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject
import qualified GI.JavaScriptCore as JavaScriptCore

newtype Frame = Frame (ForeignPtr Frame)
foreign import ccall "webkit_frame_get_type"
    c_webkit_frame_get_type :: IO GType

type instance ParentTypes Frame = FrameParentTypes
type FrameParentTypes = '[GObject.Object]

instance GObject Frame where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_frame_get_type
    

class GObject o => FrameK o
instance (GObject o, IsDescendantOf Frame o) => FrameK o

toFrame :: FrameK o => o -> IO Frame
toFrame = unsafeCastTo Frame

noFrame :: Maybe Frame
noFrame = Nothing

type family ResolveFrameMethod (t :: Symbol) (o :: *) :: * where
    ResolveFrameMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveFrameMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveFrameMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveFrameMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveFrameMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveFrameMethod "isMainFrame" o = FrameIsMainFrameMethodInfo
    ResolveFrameMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveFrameMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveFrameMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveFrameMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveFrameMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveFrameMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveFrameMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveFrameMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveFrameMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveFrameMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveFrameMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveFrameMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveFrameMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveFrameMethod "getJavascriptContextForScriptWorld" o = FrameGetJavascriptContextForScriptWorldMethodInfo
    ResolveFrameMethod "getJavascriptGlobalContext" o = FrameGetJavascriptGlobalContextMethodInfo
    ResolveFrameMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveFrameMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveFrameMethod "getUri" o = FrameGetUriMethodInfo
    ResolveFrameMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveFrameMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveFrameMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveFrameMethod t Frame, MethodInfo info Frame p) => IsLabelProxy t (Frame -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveFrameMethod t Frame, MethodInfo info Frame p) => IsLabel t (Frame -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList Frame = FrameAttributeList
type FrameAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList Frame = FrameSignalList
type FrameSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method Frame::get_javascript_context_for_script_world
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "Frame", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "world", argType = TInterface "WebKit2WebExtension" "ScriptWorld", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "JavaScriptCore" "GlobalContext")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_frame_get_javascript_context_for_script_world" webkit_frame_get_javascript_context_for_script_world :: 
    Ptr Frame ->                            -- _obj : TInterface "WebKit2WebExtension" "Frame"
    Ptr ScriptWorld ->                      -- world : TInterface "WebKit2WebExtension" "ScriptWorld"
    IO (Ptr JavaScriptCore.GlobalContext)


frameGetJavascriptContextForScriptWorld ::
    (MonadIO m, FrameK a, ScriptWorldK b) =>
    a                                       -- _obj
    -> b                                    -- world
    -> m JavaScriptCore.GlobalContext       -- result
frameGetJavascriptContextForScriptWorld _obj world = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let world' = unsafeManagedPtrCastPtr world
    result <- webkit_frame_get_javascript_context_for_script_world _obj' world'
    checkUnexpectedReturnNULL "webkit_frame_get_javascript_context_for_script_world" result
    result' <- (newPtr JavaScriptCore.GlobalContext) result
    touchManagedPtr _obj
    touchManagedPtr world
    return result'

data FrameGetJavascriptContextForScriptWorldMethodInfo
instance (signature ~ (b -> m JavaScriptCore.GlobalContext), MonadIO m, FrameK a, ScriptWorldK b) => MethodInfo FrameGetJavascriptContextForScriptWorldMethodInfo a signature where
    overloadedMethod _ = frameGetJavascriptContextForScriptWorld

-- method Frame::get_javascript_global_context
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "Frame", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "JavaScriptCore" "GlobalContext")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_frame_get_javascript_global_context" webkit_frame_get_javascript_global_context :: 
    Ptr Frame ->                            -- _obj : TInterface "WebKit2WebExtension" "Frame"
    IO (Ptr JavaScriptCore.GlobalContext)


frameGetJavascriptGlobalContext ::
    (MonadIO m, FrameK a) =>
    a                                       -- _obj
    -> m JavaScriptCore.GlobalContext       -- result
frameGetJavascriptGlobalContext _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_frame_get_javascript_global_context _obj'
    checkUnexpectedReturnNULL "webkit_frame_get_javascript_global_context" result
    result' <- (newPtr JavaScriptCore.GlobalContext) result
    touchManagedPtr _obj
    return result'

data FrameGetJavascriptGlobalContextMethodInfo
instance (signature ~ (m JavaScriptCore.GlobalContext), MonadIO m, FrameK a) => MethodInfo FrameGetJavascriptGlobalContextMethodInfo a signature where
    overloadedMethod _ = frameGetJavascriptGlobalContext

-- method Frame::get_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "Frame", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_frame_get_uri" webkit_frame_get_uri :: 
    Ptr Frame ->                            -- _obj : TInterface "WebKit2WebExtension" "Frame"
    IO CString


frameGetUri ::
    (MonadIO m, FrameK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
frameGetUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_frame_get_uri _obj'
    checkUnexpectedReturnNULL "webkit_frame_get_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data FrameGetUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, FrameK a) => MethodInfo FrameGetUriMethodInfo a signature where
    overloadedMethod _ = frameGetUri

-- method Frame::is_main_frame
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "Frame", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_frame_is_main_frame" webkit_frame_is_main_frame :: 
    Ptr Frame ->                            -- _obj : TInterface "WebKit2WebExtension" "Frame"
    IO CInt


frameIsMainFrame ::
    (MonadIO m, FrameK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
frameIsMainFrame _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_frame_is_main_frame _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data FrameIsMainFrameMethodInfo
instance (signature ~ (m Bool), MonadIO m, FrameK a) => MethodInfo FrameIsMainFrameMethodInfo a signature where
    overloadedMethod _ = frameIsMainFrame


