

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.ScriptWorld
    ( 

-- * Exported types
    ScriptWorld(..)                         ,
    ScriptWorldK                            ,
    toScriptWorld                           ,
    noScriptWorld                           ,


 -- * Methods
-- ** scriptWorldGetDefault
    scriptWorldGetDefault                   ,


-- ** scriptWorldNew
    scriptWorldNew                          ,




 -- * Signals
-- ** WindowObjectCleared
    ScriptWorldWindowObjectClearedCallback  ,
    ScriptWorldWindowObjectClearedCallbackC ,
    ScriptWorldWindowObjectClearedSignalInfo,
    afterScriptWorldWindowObjectCleared     ,
    mkScriptWorldWindowObjectClearedCallback,
    noScriptWorldWindowObjectClearedCallback,
    onScriptWorldWindowObjectCleared        ,
    scriptWorldWindowObjectClearedCallbackWrapper,
    scriptWorldWindowObjectClearedClosure   ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype ScriptWorld = ScriptWorld (ForeignPtr ScriptWorld)
foreign import ccall "webkit_script_world_get_type"
    c_webkit_script_world_get_type :: IO GType

type instance ParentTypes ScriptWorld = ScriptWorldParentTypes
type ScriptWorldParentTypes = '[GObject.Object]

instance GObject ScriptWorld where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_script_world_get_type
    

class GObject o => ScriptWorldK o
instance (GObject o, IsDescendantOf ScriptWorld o) => ScriptWorldK o

toScriptWorld :: ScriptWorldK o => o -> IO ScriptWorld
toScriptWorld = unsafeCastTo ScriptWorld

noScriptWorld :: Maybe ScriptWorld
noScriptWorld = Nothing

type family ResolveScriptWorldMethod (t :: Symbol) (o :: *) :: * where
    ResolveScriptWorldMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveScriptWorldMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveScriptWorldMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveScriptWorldMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveScriptWorldMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveScriptWorldMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveScriptWorldMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveScriptWorldMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveScriptWorldMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveScriptWorldMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveScriptWorldMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveScriptWorldMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveScriptWorldMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveScriptWorldMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveScriptWorldMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveScriptWorldMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveScriptWorldMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveScriptWorldMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveScriptWorldMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveScriptWorldMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveScriptWorldMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveScriptWorldMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveScriptWorldMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveScriptWorldMethod t ScriptWorld, MethodInfo info ScriptWorld p) => IsLabelProxy t (ScriptWorld -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveScriptWorldMethod t ScriptWorld, MethodInfo info ScriptWorld p) => IsLabel t (ScriptWorld -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal ScriptWorld::window-object-cleared
type ScriptWorldWindowObjectClearedCallback =
    WebPage ->
    Frame ->
    IO ()

noScriptWorldWindowObjectClearedCallback :: Maybe ScriptWorldWindowObjectClearedCallback
noScriptWorldWindowObjectClearedCallback = Nothing

type ScriptWorldWindowObjectClearedCallbackC =
    Ptr () ->                               -- object
    Ptr WebPage ->
    Ptr Frame ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkScriptWorldWindowObjectClearedCallback :: ScriptWorldWindowObjectClearedCallbackC -> IO (FunPtr ScriptWorldWindowObjectClearedCallbackC)

scriptWorldWindowObjectClearedClosure :: ScriptWorldWindowObjectClearedCallback -> IO Closure
scriptWorldWindowObjectClearedClosure cb = newCClosure =<< mkScriptWorldWindowObjectClearedCallback wrapped
    where wrapped = scriptWorldWindowObjectClearedCallbackWrapper cb

scriptWorldWindowObjectClearedCallbackWrapper ::
    ScriptWorldWindowObjectClearedCallback ->
    Ptr () ->
    Ptr WebPage ->
    Ptr Frame ->
    Ptr () ->
    IO ()
scriptWorldWindowObjectClearedCallbackWrapper _cb _ page frame _ = do
    page' <- (newObject WebPage) page
    frame' <- (newObject Frame) frame
    _cb  page' frame'

onScriptWorldWindowObjectCleared :: (GObject a, MonadIO m) => a -> ScriptWorldWindowObjectClearedCallback -> m SignalHandlerId
onScriptWorldWindowObjectCleared obj cb = liftIO $ connectScriptWorldWindowObjectCleared obj cb SignalConnectBefore
afterScriptWorldWindowObjectCleared :: (GObject a, MonadIO m) => a -> ScriptWorldWindowObjectClearedCallback -> m SignalHandlerId
afterScriptWorldWindowObjectCleared obj cb = connectScriptWorldWindowObjectCleared obj cb SignalConnectAfter

connectScriptWorldWindowObjectCleared :: (GObject a, MonadIO m) =>
                                         a -> ScriptWorldWindowObjectClearedCallback -> SignalConnectMode -> m SignalHandlerId
connectScriptWorldWindowObjectCleared obj cb after = liftIO $ do
    cb' <- mkScriptWorldWindowObjectClearedCallback (scriptWorldWindowObjectClearedCallbackWrapper cb)
    connectSignalFunPtr obj "window-object-cleared" cb' after

type instance AttributeList ScriptWorld = ScriptWorldAttributeList
type ScriptWorldAttributeList = ('[ ] :: [(Symbol, *)])

data ScriptWorldWindowObjectClearedSignalInfo
instance SignalInfo ScriptWorldWindowObjectClearedSignalInfo where
    type HaskellCallbackType ScriptWorldWindowObjectClearedSignalInfo = ScriptWorldWindowObjectClearedCallback
    connectSignal _ = connectScriptWorldWindowObjectCleared

type instance SignalList ScriptWorld = ScriptWorldSignalList
type ScriptWorldSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo), '("windowObjectCleared", ScriptWorldWindowObjectClearedSignalInfo)] :: [(Symbol, *)])

-- method ScriptWorld::new
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ScriptWorld")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_script_world_new" webkit_script_world_new :: 
    IO (Ptr ScriptWorld)


scriptWorldNew ::
    (MonadIO m) =>
    m ScriptWorld                           -- result
scriptWorldNew  = liftIO $ do
    result <- webkit_script_world_new
    checkUnexpectedReturnNULL "webkit_script_world_new" result
    result' <- (wrapObject ScriptWorld) result
    return result'

-- method ScriptWorld::get_default
-- method type : MemberFunction
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ScriptWorld")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_script_world_get_default" webkit_script_world_get_default :: 
    IO (Ptr ScriptWorld)


scriptWorldGetDefault ::
    (MonadIO m) =>
    m ScriptWorld                           -- result
scriptWorldGetDefault  = liftIO $ do
    result <- webkit_script_world_get_default
    checkUnexpectedReturnNULL "webkit_script_world_get_default" result
    result' <- (newObject ScriptWorld) result
    return result'


