

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.URIResponse
    ( 

-- * Exported types
    URIResponse(..)                         ,
    URIResponseK                            ,
    toURIResponse                           ,
    noURIResponse                           ,


 -- * Methods
-- ** uRIResponseGetContentLength
    URIResponseGetContentLengthMethodInfo   ,
    uRIResponseGetContentLength             ,


-- ** uRIResponseGetHttpHeaders
    URIResponseGetHttpHeadersMethodInfo     ,
    uRIResponseGetHttpHeaders               ,


-- ** uRIResponseGetMimeType
    URIResponseGetMimeTypeMethodInfo        ,
    uRIResponseGetMimeType                  ,


-- ** uRIResponseGetStatusCode
    URIResponseGetStatusCodeMethodInfo      ,
    uRIResponseGetStatusCode                ,


-- ** uRIResponseGetSuggestedFilename
    URIResponseGetSuggestedFilenameMethodInfo,
    uRIResponseGetSuggestedFilename         ,


-- ** uRIResponseGetUri
    URIResponseGetUriMethodInfo             ,
    uRIResponseGetUri                       ,




 -- * Properties
-- ** ContentLength
    URIResponseContentLengthPropertyInfo    ,
    getURIResponseContentLength             ,
    uRIResponseContentLength                ,


-- ** HttpHeaders
    URIResponseHttpHeadersPropertyInfo      ,
    getURIResponseHttpHeaders               ,
    uRIResponseHttpHeaders                  ,


-- ** MimeType
    URIResponseMimeTypePropertyInfo         ,
    getURIResponseMimeType                  ,
    uRIResponseMimeType                     ,


-- ** StatusCode
    URIResponseStatusCodePropertyInfo       ,
    getURIResponseStatusCode                ,
    uRIResponseStatusCode                   ,


-- ** SuggestedFilename
    URIResponseSuggestedFilenamePropertyInfo,
    getURIResponseSuggestedFilename         ,
    uRIResponseSuggestedFilename            ,


-- ** Uri
    URIResponseUriPropertyInfo              ,
    getURIResponseUri                       ,
    uRIResponseUri                          ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Soup as Soup

newtype URIResponse = URIResponse (ForeignPtr URIResponse)
foreign import ccall "webkit_uri_response_get_type"
    c_webkit_uri_response_get_type :: IO GType

type instance ParentTypes URIResponse = URIResponseParentTypes
type URIResponseParentTypes = '[GObject.Object]

instance GObject URIResponse where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_uri_response_get_type
    

class GObject o => URIResponseK o
instance (GObject o, IsDescendantOf URIResponse o) => URIResponseK o

toURIResponse :: URIResponseK o => o -> IO URIResponse
toURIResponse = unsafeCastTo URIResponse

noURIResponse :: Maybe URIResponse
noURIResponse = Nothing

type family ResolveURIResponseMethod (t :: Symbol) (o :: *) :: * where
    ResolveURIResponseMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveURIResponseMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveURIResponseMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveURIResponseMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveURIResponseMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveURIResponseMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveURIResponseMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveURIResponseMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveURIResponseMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveURIResponseMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveURIResponseMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveURIResponseMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveURIResponseMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveURIResponseMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveURIResponseMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveURIResponseMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveURIResponseMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveURIResponseMethod "getContentLength" o = URIResponseGetContentLengthMethodInfo
    ResolveURIResponseMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveURIResponseMethod "getHttpHeaders" o = URIResponseGetHttpHeadersMethodInfo
    ResolveURIResponseMethod "getMimeType" o = URIResponseGetMimeTypeMethodInfo
    ResolveURIResponseMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveURIResponseMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveURIResponseMethod "getStatusCode" o = URIResponseGetStatusCodeMethodInfo
    ResolveURIResponseMethod "getSuggestedFilename" o = URIResponseGetSuggestedFilenameMethodInfo
    ResolveURIResponseMethod "getUri" o = URIResponseGetUriMethodInfo
    ResolveURIResponseMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveURIResponseMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveURIResponseMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveURIResponseMethod t URIResponse, MethodInfo info URIResponse p) => IsLabelProxy t (URIResponse -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveURIResponseMethod t URIResponse, MethodInfo info URIResponse p) => IsLabel t (URIResponse -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "content-length"
   -- Type: TBasicType TUInt64
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getURIResponseContentLength :: (MonadIO m, URIResponseK o) => o -> m Word64
getURIResponseContentLength obj = liftIO $ getObjectPropertyUInt64 obj "content-length"

data URIResponseContentLengthPropertyInfo
instance AttrInfo URIResponseContentLengthPropertyInfo where
    type AttrAllowedOps URIResponseContentLengthPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint URIResponseContentLengthPropertyInfo = (~) ()
    type AttrBaseTypeConstraint URIResponseContentLengthPropertyInfo = URIResponseK
    type AttrGetType URIResponseContentLengthPropertyInfo = Word64
    type AttrLabel URIResponseContentLengthPropertyInfo = "content-length"
    attrGet _ = getURIResponseContentLength
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "http-headers"
   -- Type: TInterface "Soup" "MessageHeaders"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getURIResponseHttpHeaders :: (MonadIO m, URIResponseK o) => o -> m (Maybe Soup.MessageHeaders)
getURIResponseHttpHeaders obj = liftIO $ getObjectPropertyBoxed obj "http-headers" Soup.MessageHeaders

data URIResponseHttpHeadersPropertyInfo
instance AttrInfo URIResponseHttpHeadersPropertyInfo where
    type AttrAllowedOps URIResponseHttpHeadersPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint URIResponseHttpHeadersPropertyInfo = (~) ()
    type AttrBaseTypeConstraint URIResponseHttpHeadersPropertyInfo = URIResponseK
    type AttrGetType URIResponseHttpHeadersPropertyInfo = (Maybe Soup.MessageHeaders)
    type AttrLabel URIResponseHttpHeadersPropertyInfo = "http-headers"
    attrGet _ = getURIResponseHttpHeaders
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "mime-type"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getURIResponseMimeType :: (MonadIO m, URIResponseK o) => o -> m T.Text
getURIResponseMimeType obj = liftIO $ checkUnexpectedNothing "getURIResponseMimeType" $ getObjectPropertyString obj "mime-type"

data URIResponseMimeTypePropertyInfo
instance AttrInfo URIResponseMimeTypePropertyInfo where
    type AttrAllowedOps URIResponseMimeTypePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint URIResponseMimeTypePropertyInfo = (~) ()
    type AttrBaseTypeConstraint URIResponseMimeTypePropertyInfo = URIResponseK
    type AttrGetType URIResponseMimeTypePropertyInfo = T.Text
    type AttrLabel URIResponseMimeTypePropertyInfo = "mime-type"
    attrGet _ = getURIResponseMimeType
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "status-code"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getURIResponseStatusCode :: (MonadIO m, URIResponseK o) => o -> m Word32
getURIResponseStatusCode obj = liftIO $ getObjectPropertyUInt32 obj "status-code"

data URIResponseStatusCodePropertyInfo
instance AttrInfo URIResponseStatusCodePropertyInfo where
    type AttrAllowedOps URIResponseStatusCodePropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint URIResponseStatusCodePropertyInfo = (~) ()
    type AttrBaseTypeConstraint URIResponseStatusCodePropertyInfo = URIResponseK
    type AttrGetType URIResponseStatusCodePropertyInfo = Word32
    type AttrLabel URIResponseStatusCodePropertyInfo = "status-code"
    attrGet _ = getURIResponseStatusCode
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "suggested-filename"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getURIResponseSuggestedFilename :: (MonadIO m, URIResponseK o) => o -> m T.Text
getURIResponseSuggestedFilename obj = liftIO $ checkUnexpectedNothing "getURIResponseSuggestedFilename" $ getObjectPropertyString obj "suggested-filename"

data URIResponseSuggestedFilenamePropertyInfo
instance AttrInfo URIResponseSuggestedFilenamePropertyInfo where
    type AttrAllowedOps URIResponseSuggestedFilenamePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint URIResponseSuggestedFilenamePropertyInfo = (~) ()
    type AttrBaseTypeConstraint URIResponseSuggestedFilenamePropertyInfo = URIResponseK
    type AttrGetType URIResponseSuggestedFilenamePropertyInfo = T.Text
    type AttrLabel URIResponseSuggestedFilenamePropertyInfo = "suggested-filename"
    attrGet _ = getURIResponseSuggestedFilename
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getURIResponseUri :: (MonadIO m, URIResponseK o) => o -> m T.Text
getURIResponseUri obj = liftIO $ checkUnexpectedNothing "getURIResponseUri" $ getObjectPropertyString obj "uri"

data URIResponseUriPropertyInfo
instance AttrInfo URIResponseUriPropertyInfo where
    type AttrAllowedOps URIResponseUriPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint URIResponseUriPropertyInfo = (~) ()
    type AttrBaseTypeConstraint URIResponseUriPropertyInfo = URIResponseK
    type AttrGetType URIResponseUriPropertyInfo = T.Text
    type AttrLabel URIResponseUriPropertyInfo = "uri"
    attrGet _ = getURIResponseUri
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList URIResponse = URIResponseAttributeList
type URIResponseAttributeList = ('[ '("contentLength", URIResponseContentLengthPropertyInfo), '("httpHeaders", URIResponseHttpHeadersPropertyInfo), '("mimeType", URIResponseMimeTypePropertyInfo), '("statusCode", URIResponseStatusCodePropertyInfo), '("suggestedFilename", URIResponseSuggestedFilenamePropertyInfo), '("uri", URIResponseUriPropertyInfo)] :: [(Symbol, *)])

uRIResponseContentLength :: AttrLabelProxy "contentLength"
uRIResponseContentLength = AttrLabelProxy

uRIResponseHttpHeaders :: AttrLabelProxy "httpHeaders"
uRIResponseHttpHeaders = AttrLabelProxy

uRIResponseMimeType :: AttrLabelProxy "mimeType"
uRIResponseMimeType = AttrLabelProxy

uRIResponseStatusCode :: AttrLabelProxy "statusCode"
uRIResponseStatusCode = AttrLabelProxy

uRIResponseSuggestedFilename :: AttrLabelProxy "suggestedFilename"
uRIResponseSuggestedFilename = AttrLabelProxy

uRIResponseUri :: AttrLabelProxy "uri"
uRIResponseUri = AttrLabelProxy

type instance SignalList URIResponse = URIResponseSignalList
type URIResponseSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method URIResponse::get_content_length
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "URIResponse", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt64)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_response_get_content_length" webkit_uri_response_get_content_length :: 
    Ptr URIResponse ->                      -- _obj : TInterface "WebKit2WebExtension" "URIResponse"
    IO Word64


uRIResponseGetContentLength ::
    (MonadIO m, URIResponseK a) =>
    a                                       -- _obj
    -> m Word64                             -- result
uRIResponseGetContentLength _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_response_get_content_length _obj'
    touchManagedPtr _obj
    return result

data URIResponseGetContentLengthMethodInfo
instance (signature ~ (m Word64), MonadIO m, URIResponseK a) => MethodInfo URIResponseGetContentLengthMethodInfo a signature where
    overloadedMethod _ = uRIResponseGetContentLength

-- method URIResponse::get_http_headers
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "URIResponse", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "Soup" "MessageHeaders")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_response_get_http_headers" webkit_uri_response_get_http_headers :: 
    Ptr URIResponse ->                      -- _obj : TInterface "WebKit2WebExtension" "URIResponse"
    IO (Ptr Soup.MessageHeaders)


uRIResponseGetHttpHeaders ::
    (MonadIO m, URIResponseK a) =>
    a                                       -- _obj
    -> m Soup.MessageHeaders                -- result
uRIResponseGetHttpHeaders _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_response_get_http_headers _obj'
    checkUnexpectedReturnNULL "webkit_uri_response_get_http_headers" result
    result' <- (wrapBoxed Soup.MessageHeaders) result
    touchManagedPtr _obj
    return result'

data URIResponseGetHttpHeadersMethodInfo
instance (signature ~ (m Soup.MessageHeaders), MonadIO m, URIResponseK a) => MethodInfo URIResponseGetHttpHeadersMethodInfo a signature where
    overloadedMethod _ = uRIResponseGetHttpHeaders

-- method URIResponse::get_mime_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "URIResponse", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_response_get_mime_type" webkit_uri_response_get_mime_type :: 
    Ptr URIResponse ->                      -- _obj : TInterface "WebKit2WebExtension" "URIResponse"
    IO CString


uRIResponseGetMimeType ::
    (MonadIO m, URIResponseK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
uRIResponseGetMimeType _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_response_get_mime_type _obj'
    checkUnexpectedReturnNULL "webkit_uri_response_get_mime_type" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data URIResponseGetMimeTypeMethodInfo
instance (signature ~ (m T.Text), MonadIO m, URIResponseK a) => MethodInfo URIResponseGetMimeTypeMethodInfo a signature where
    overloadedMethod _ = uRIResponseGetMimeType

-- method URIResponse::get_status_code
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "URIResponse", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_response_get_status_code" webkit_uri_response_get_status_code :: 
    Ptr URIResponse ->                      -- _obj : TInterface "WebKit2WebExtension" "URIResponse"
    IO Word32


uRIResponseGetStatusCode ::
    (MonadIO m, URIResponseK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
uRIResponseGetStatusCode _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_response_get_status_code _obj'
    touchManagedPtr _obj
    return result

data URIResponseGetStatusCodeMethodInfo
instance (signature ~ (m Word32), MonadIO m, URIResponseK a) => MethodInfo URIResponseGetStatusCodeMethodInfo a signature where
    overloadedMethod _ = uRIResponseGetStatusCode

-- method URIResponse::get_suggested_filename
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "URIResponse", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_response_get_suggested_filename" webkit_uri_response_get_suggested_filename :: 
    Ptr URIResponse ->                      -- _obj : TInterface "WebKit2WebExtension" "URIResponse"
    IO CString


uRIResponseGetSuggestedFilename ::
    (MonadIO m, URIResponseK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
uRIResponseGetSuggestedFilename _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_response_get_suggested_filename _obj'
    checkUnexpectedReturnNULL "webkit_uri_response_get_suggested_filename" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data URIResponseGetSuggestedFilenameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, URIResponseK a) => MethodInfo URIResponseGetSuggestedFilenameMethodInfo a signature where
    overloadedMethod _ = uRIResponseGetSuggestedFilename

-- method URIResponse::get_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "URIResponse", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_uri_response_get_uri" webkit_uri_response_get_uri :: 
    Ptr URIResponse ->                      -- _obj : TInterface "WebKit2WebExtension" "URIResponse"
    IO CString


uRIResponseGetUri ::
    (MonadIO m, URIResponseK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
uRIResponseGetUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_uri_response_get_uri _obj'
    checkUnexpectedReturnNULL "webkit_uri_response_get_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data URIResponseGetUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, URIResponseK a) => MethodInfo URIResponseGetUriMethodInfo a signature where
    overloadedMethod _ = uRIResponseGetUri


