

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.WebEditor
    ( 

-- * Exported types
    WebEditor(..)                           ,
    WebEditorK                              ,
    toWebEditor                             ,
    noWebEditor                             ,


 -- * Methods
-- ** webEditorGetPage
    WebEditorGetPageMethodInfo              ,
    webEditorGetPage                        ,




 -- * Signals
-- ** SelectionChanged
    WebEditorSelectionChangedCallback       ,
    WebEditorSelectionChangedCallbackC      ,
    WebEditorSelectionChangedSignalInfo     ,
    afterWebEditorSelectionChanged          ,
    mkWebEditorSelectionChangedCallback     ,
    noWebEditorSelectionChangedCallback     ,
    onWebEditorSelectionChanged             ,
    webEditorSelectionChangedCallbackWrapper,
    webEditorSelectionChangedClosure        ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype WebEditor = WebEditor (ForeignPtr WebEditor)
foreign import ccall "webkit_web_editor_get_type"
    c_webkit_web_editor_get_type :: IO GType

type instance ParentTypes WebEditor = WebEditorParentTypes
type WebEditorParentTypes = '[GObject.Object]

instance GObject WebEditor where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_web_editor_get_type
    

class GObject o => WebEditorK o
instance (GObject o, IsDescendantOf WebEditor o) => WebEditorK o

toWebEditor :: WebEditorK o => o -> IO WebEditor
toWebEditor = unsafeCastTo WebEditor

noWebEditor :: Maybe WebEditor
noWebEditor = Nothing

type family ResolveWebEditorMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebEditorMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebEditorMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebEditorMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebEditorMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebEditorMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebEditorMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebEditorMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebEditorMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebEditorMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebEditorMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebEditorMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebEditorMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebEditorMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebEditorMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebEditorMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebEditorMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebEditorMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebEditorMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebEditorMethod "getPage" o = WebEditorGetPageMethodInfo
    ResolveWebEditorMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebEditorMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebEditorMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebEditorMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebEditorMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebEditorMethod t WebEditor, MethodInfo info WebEditor p) => IsLabelProxy t (WebEditor -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebEditorMethod t WebEditor, MethodInfo info WebEditor p) => IsLabel t (WebEditor -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal WebEditor::selection-changed
type WebEditorSelectionChangedCallback =
    IO ()

noWebEditorSelectionChangedCallback :: Maybe WebEditorSelectionChangedCallback
noWebEditorSelectionChangedCallback = Nothing

type WebEditorSelectionChangedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebEditorSelectionChangedCallback :: WebEditorSelectionChangedCallbackC -> IO (FunPtr WebEditorSelectionChangedCallbackC)

webEditorSelectionChangedClosure :: WebEditorSelectionChangedCallback -> IO Closure
webEditorSelectionChangedClosure cb = newCClosure =<< mkWebEditorSelectionChangedCallback wrapped
    where wrapped = webEditorSelectionChangedCallbackWrapper cb

webEditorSelectionChangedCallbackWrapper ::
    WebEditorSelectionChangedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webEditorSelectionChangedCallbackWrapper _cb _ _ = do
    _cb 

onWebEditorSelectionChanged :: (GObject a, MonadIO m) => a -> WebEditorSelectionChangedCallback -> m SignalHandlerId
onWebEditorSelectionChanged obj cb = liftIO $ connectWebEditorSelectionChanged obj cb SignalConnectBefore
afterWebEditorSelectionChanged :: (GObject a, MonadIO m) => a -> WebEditorSelectionChangedCallback -> m SignalHandlerId
afterWebEditorSelectionChanged obj cb = connectWebEditorSelectionChanged obj cb SignalConnectAfter

connectWebEditorSelectionChanged :: (GObject a, MonadIO m) =>
                                    a -> WebEditorSelectionChangedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebEditorSelectionChanged obj cb after = liftIO $ do
    cb' <- mkWebEditorSelectionChangedCallback (webEditorSelectionChangedCallbackWrapper cb)
    connectSignalFunPtr obj "selection-changed" cb' after

type instance AttributeList WebEditor = WebEditorAttributeList
type WebEditorAttributeList = ('[ ] :: [(Symbol, *)])

data WebEditorSelectionChangedSignalInfo
instance SignalInfo WebEditorSelectionChangedSignalInfo where
    type HaskellCallbackType WebEditorSelectionChangedSignalInfo = WebEditorSelectionChangedCallback
    connectSignal _ = connectWebEditorSelectionChanged

type instance SignalList WebEditor = WebEditorSignalList
type WebEditorSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo), '("selectionChanged", WebEditorSelectionChangedSignalInfo)] :: [(Symbol, *)])

-- method WebEditor::get_page
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "WebEditor", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "WebPage")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_editor_get_page" webkit_web_editor_get_page :: 
    Ptr WebEditor ->                        -- _obj : TInterface "WebKit2WebExtension" "WebEditor"
    IO (Ptr WebPage)


webEditorGetPage ::
    (MonadIO m, WebEditorK a) =>
    a                                       -- _obj
    -> m WebPage                            -- result
webEditorGetPage _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_editor_get_page _obj'
    checkUnexpectedReturnNULL "webkit_web_editor_get_page" result
    result' <- (newObject WebPage) result
    touchManagedPtr _obj
    return result'

data WebEditorGetPageMethodInfo
instance (signature ~ (m WebPage), MonadIO m, WebEditorK a) => MethodInfo WebEditorGetPageMethodInfo a signature where
    overloadedMethod _ = webEditorGetPage


