

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.WebExtension
    ( 

-- * Exported types
    WebExtension(..)                        ,
    WebExtensionK                           ,
    toWebExtension                          ,
    noWebExtension                          ,


 -- * Methods
-- ** webExtensionGetPage
    WebExtensionGetPageMethodInfo           ,
    webExtensionGetPage                     ,




 -- * Signals
-- ** PageCreated
    WebExtensionPageCreatedCallback         ,
    WebExtensionPageCreatedCallbackC        ,
    WebExtensionPageCreatedSignalInfo       ,
    afterWebExtensionPageCreated            ,
    mkWebExtensionPageCreatedCallback       ,
    noWebExtensionPageCreatedCallback       ,
    onWebExtensionPageCreated               ,
    webExtensionPageCreatedCallbackWrapper  ,
    webExtensionPageCreatedClosure          ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype WebExtension = WebExtension (ForeignPtr WebExtension)
foreign import ccall "webkit_web_extension_get_type"
    c_webkit_web_extension_get_type :: IO GType

type instance ParentTypes WebExtension = WebExtensionParentTypes
type WebExtensionParentTypes = '[GObject.Object]

instance GObject WebExtension where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_web_extension_get_type
    

class GObject o => WebExtensionK o
instance (GObject o, IsDescendantOf WebExtension o) => WebExtensionK o

toWebExtension :: WebExtensionK o => o -> IO WebExtension
toWebExtension = unsafeCastTo WebExtension

noWebExtension :: Maybe WebExtension
noWebExtension = Nothing

type family ResolveWebExtensionMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebExtensionMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebExtensionMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebExtensionMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebExtensionMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebExtensionMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebExtensionMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebExtensionMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebExtensionMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebExtensionMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebExtensionMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebExtensionMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebExtensionMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebExtensionMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebExtensionMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebExtensionMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebExtensionMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebExtensionMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebExtensionMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebExtensionMethod "getPage" o = WebExtensionGetPageMethodInfo
    ResolveWebExtensionMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebExtensionMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebExtensionMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebExtensionMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebExtensionMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebExtensionMethod t WebExtension, MethodInfo info WebExtension p) => IsLabelProxy t (WebExtension -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebExtensionMethod t WebExtension, MethodInfo info WebExtension p) => IsLabel t (WebExtension -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal WebExtension::page-created
type WebExtensionPageCreatedCallback =
    WebPage ->
    IO ()

noWebExtensionPageCreatedCallback :: Maybe WebExtensionPageCreatedCallback
noWebExtensionPageCreatedCallback = Nothing

type WebExtensionPageCreatedCallbackC =
    Ptr () ->                               -- object
    Ptr WebPage ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebExtensionPageCreatedCallback :: WebExtensionPageCreatedCallbackC -> IO (FunPtr WebExtensionPageCreatedCallbackC)

webExtensionPageCreatedClosure :: WebExtensionPageCreatedCallback -> IO Closure
webExtensionPageCreatedClosure cb = newCClosure =<< mkWebExtensionPageCreatedCallback wrapped
    where wrapped = webExtensionPageCreatedCallbackWrapper cb

webExtensionPageCreatedCallbackWrapper ::
    WebExtensionPageCreatedCallback ->
    Ptr () ->
    Ptr WebPage ->
    Ptr () ->
    IO ()
webExtensionPageCreatedCallbackWrapper _cb _ webPage _ = do
    webPage' <- (newObject WebPage) webPage
    _cb  webPage'

onWebExtensionPageCreated :: (GObject a, MonadIO m) => a -> WebExtensionPageCreatedCallback -> m SignalHandlerId
onWebExtensionPageCreated obj cb = liftIO $ connectWebExtensionPageCreated obj cb SignalConnectBefore
afterWebExtensionPageCreated :: (GObject a, MonadIO m) => a -> WebExtensionPageCreatedCallback -> m SignalHandlerId
afterWebExtensionPageCreated obj cb = connectWebExtensionPageCreated obj cb SignalConnectAfter

connectWebExtensionPageCreated :: (GObject a, MonadIO m) =>
                                  a -> WebExtensionPageCreatedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebExtensionPageCreated obj cb after = liftIO $ do
    cb' <- mkWebExtensionPageCreatedCallback (webExtensionPageCreatedCallbackWrapper cb)
    connectSignalFunPtr obj "page-created" cb' after

type instance AttributeList WebExtension = WebExtensionAttributeList
type WebExtensionAttributeList = ('[ ] :: [(Symbol, *)])

data WebExtensionPageCreatedSignalInfo
instance SignalInfo WebExtensionPageCreatedSignalInfo where
    type HaskellCallbackType WebExtensionPageCreatedSignalInfo = WebExtensionPageCreatedCallback
    connectSignal _ = connectWebExtensionPageCreated

type instance SignalList WebExtension = WebExtensionSignalList
type WebExtensionSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo), '("pageCreated", WebExtensionPageCreatedSignalInfo)] :: [(Symbol, *)])

-- method WebExtension::get_page
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "WebExtension", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "page_id", argType = TBasicType TUInt64, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "WebPage")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_extension_get_page" webkit_web_extension_get_page :: 
    Ptr WebExtension ->                     -- _obj : TInterface "WebKit2WebExtension" "WebExtension"
    Word64 ->                               -- page_id : TBasicType TUInt64
    IO (Ptr WebPage)


webExtensionGetPage ::
    (MonadIO m, WebExtensionK a) =>
    a                                       -- _obj
    -> Word64                               -- pageId
    -> m WebPage                            -- result
webExtensionGetPage _obj pageId = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_extension_get_page _obj' pageId
    checkUnexpectedReturnNULL "webkit_web_extension_get_page" result
    result' <- (newObject WebPage) result
    touchManagedPtr _obj
    return result'

data WebExtensionGetPageMethodInfo
instance (signature ~ (Word64 -> m WebPage), MonadIO m, WebExtensionK a) => MethodInfo WebExtensionGetPageMethodInfo a signature where
    overloadedMethod _ = webExtensionGetPage


