

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.WebHitTestResult
    ( 

-- * Exported types
    WebHitTestResult(..)                    ,
    WebHitTestResultK                       ,
    toWebHitTestResult                      ,
    noWebHitTestResult                      ,


 -- * Methods
-- ** webHitTestResultGetNode
    WebHitTestResultGetNodeMethodInfo       ,
    webHitTestResultGetNode                 ,




 -- * Properties
-- ** Node
    WebHitTestResultNodePropertyInfo        ,
    constructWebHitTestResultNode           ,
    getWebHitTestResultNode                 ,
    webHitTestResultNode                    ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype WebHitTestResult = WebHitTestResult (ForeignPtr WebHitTestResult)
foreign import ccall "webkit_web_hit_test_result_get_type"
    c_webkit_web_hit_test_result_get_type :: IO GType

type instance ParentTypes WebHitTestResult = WebHitTestResultParentTypes
type WebHitTestResultParentTypes = '[HitTestResult, GObject.Object]

instance GObject WebHitTestResult where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_web_hit_test_result_get_type
    

class GObject o => WebHitTestResultK o
instance (GObject o, IsDescendantOf WebHitTestResult o) => WebHitTestResultK o

toWebHitTestResult :: WebHitTestResultK o => o -> IO WebHitTestResult
toWebHitTestResult = unsafeCastTo WebHitTestResult

noWebHitTestResult :: Maybe WebHitTestResult
noWebHitTestResult = Nothing

type family ResolveWebHitTestResultMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebHitTestResultMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebHitTestResultMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebHitTestResultMethod "contextIsEditable" o = HitTestResultContextIsEditableMethodInfo
    ResolveWebHitTestResultMethod "contextIsImage" o = HitTestResultContextIsImageMethodInfo
    ResolveWebHitTestResultMethod "contextIsLink" o = HitTestResultContextIsLinkMethodInfo
    ResolveWebHitTestResultMethod "contextIsMedia" o = HitTestResultContextIsMediaMethodInfo
    ResolveWebHitTestResultMethod "contextIsScrollbar" o = HitTestResultContextIsScrollbarMethodInfo
    ResolveWebHitTestResultMethod "contextIsSelection" o = HitTestResultContextIsSelectionMethodInfo
    ResolveWebHitTestResultMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebHitTestResultMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebHitTestResultMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebHitTestResultMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebHitTestResultMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebHitTestResultMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebHitTestResultMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebHitTestResultMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebHitTestResultMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebHitTestResultMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebHitTestResultMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebHitTestResultMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebHitTestResultMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebHitTestResultMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebHitTestResultMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebHitTestResultMethod "getContext" o = HitTestResultGetContextMethodInfo
    ResolveWebHitTestResultMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebHitTestResultMethod "getImageUri" o = HitTestResultGetImageUriMethodInfo
    ResolveWebHitTestResultMethod "getLinkLabel" o = HitTestResultGetLinkLabelMethodInfo
    ResolveWebHitTestResultMethod "getLinkTitle" o = HitTestResultGetLinkTitleMethodInfo
    ResolveWebHitTestResultMethod "getLinkUri" o = HitTestResultGetLinkUriMethodInfo
    ResolveWebHitTestResultMethod "getMediaUri" o = HitTestResultGetMediaUriMethodInfo
    ResolveWebHitTestResultMethod "getNode" o = WebHitTestResultGetNodeMethodInfo
    ResolveWebHitTestResultMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebHitTestResultMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebHitTestResultMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebHitTestResultMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebHitTestResultMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebHitTestResultMethod t WebHitTestResult, MethodInfo info WebHitTestResult p) => IsLabelProxy t (WebHitTestResult -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebHitTestResultMethod t WebHitTestResult, MethodInfo info WebHitTestResult p) => IsLabel t (WebHitTestResult -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "node"
   -- Type: TInterface "WebKit2WebExtension" "DOMNode"
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getWebHitTestResultNode :: (MonadIO m, WebHitTestResultK o) => o -> m DOMNode
getWebHitTestResultNode obj = liftIO $ checkUnexpectedNothing "getWebHitTestResultNode" $ getObjectPropertyObject obj "node" DOMNode

constructWebHitTestResultNode :: (DOMNodeK a) => a -> IO ([Char], GValue)
constructWebHitTestResultNode val = constructObjectPropertyObject "node" (Just val)

data WebHitTestResultNodePropertyInfo
instance AttrInfo WebHitTestResultNodePropertyInfo where
    type AttrAllowedOps WebHitTestResultNodePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebHitTestResultNodePropertyInfo = DOMNodeK
    type AttrBaseTypeConstraint WebHitTestResultNodePropertyInfo = WebHitTestResultK
    type AttrGetType WebHitTestResultNodePropertyInfo = DOMNode
    type AttrLabel WebHitTestResultNodePropertyInfo = "node"
    attrGet _ = getWebHitTestResultNode
    attrSet _ = undefined
    attrConstruct _ = constructWebHitTestResultNode
    attrClear _ = undefined

type instance AttributeList WebHitTestResult = WebHitTestResultAttributeList
type WebHitTestResultAttributeList = ('[ '("context", HitTestResultContextPropertyInfo), '("imageUri", HitTestResultImageUriPropertyInfo), '("linkLabel", HitTestResultLinkLabelPropertyInfo), '("linkTitle", HitTestResultLinkTitlePropertyInfo), '("linkUri", HitTestResultLinkUriPropertyInfo), '("mediaUri", HitTestResultMediaUriPropertyInfo), '("node", WebHitTestResultNodePropertyInfo)] :: [(Symbol, *)])

webHitTestResultNode :: AttrLabelProxy "node"
webHitTestResultNode = AttrLabelProxy

type instance SignalList WebHitTestResult = WebHitTestResultSignalList
type WebHitTestResultSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method WebHitTestResult::get_node
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "WebHitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "DOMNode")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_hit_test_result_get_node" webkit_web_hit_test_result_get_node :: 
    Ptr WebHitTestResult ->                 -- _obj : TInterface "WebKit2WebExtension" "WebHitTestResult"
    IO (Ptr DOMNode)


webHitTestResultGetNode ::
    (MonadIO m, WebHitTestResultK a) =>
    a                                       -- _obj
    -> m DOMNode                            -- result
webHitTestResultGetNode _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_hit_test_result_get_node _obj'
    checkUnexpectedReturnNULL "webkit_web_hit_test_result_get_node" result
    result' <- (newObject DOMNode) result
    touchManagedPtr _obj
    return result'

data WebHitTestResultGetNodeMethodInfo
instance (signature ~ (m DOMNode), MonadIO m, WebHitTestResultK a) => MethodInfo WebHitTestResultGetNodeMethodInfo a signature where
    overloadedMethod _ = webHitTestResultGetNode


