

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Objects.WebPage
    ( 

-- * Exported types
    WebPage(..)                             ,
    WebPageK                                ,
    toWebPage                               ,
    noWebPage                               ,


 -- * Methods
-- ** webPageGetDomDocument
    WebPageGetDomDocumentMethodInfo         ,
    webPageGetDomDocument                   ,


-- ** webPageGetEditor
    WebPageGetEditorMethodInfo              ,
    webPageGetEditor                        ,


-- ** webPageGetId
    WebPageGetIdMethodInfo                  ,
    webPageGetId                            ,


-- ** webPageGetMainFrame
    WebPageGetMainFrameMethodInfo           ,
    webPageGetMainFrame                     ,


-- ** webPageGetUri
    WebPageGetUriMethodInfo                 ,
    webPageGetUri                           ,




 -- * Properties
-- ** Uri
    WebPageUriPropertyInfo                  ,
    getWebPageUri                           ,
    webPageUri                              ,




 -- * Signals
-- ** ConsoleMessageSent
    WebPageConsoleMessageSentCallback       ,
    WebPageConsoleMessageSentCallbackC      ,
    WebPageConsoleMessageSentSignalInfo     ,
    afterWebPageConsoleMessageSent          ,
    mkWebPageConsoleMessageSentCallback     ,
    noWebPageConsoleMessageSentCallback     ,
    onWebPageConsoleMessageSent             ,
    webPageConsoleMessageSentCallbackWrapper,
    webPageConsoleMessageSentClosure        ,


-- ** ContextMenu
    WebPageContextMenuCallback              ,
    WebPageContextMenuCallbackC             ,
    WebPageContextMenuSignalInfo            ,
    afterWebPageContextMenu                 ,
    mkWebPageContextMenuCallback            ,
    noWebPageContextMenuCallback            ,
    onWebPageContextMenu                    ,
    webPageContextMenuCallbackWrapper       ,
    webPageContextMenuClosure               ,


-- ** DocumentLoaded
    WebPageDocumentLoadedCallback           ,
    WebPageDocumentLoadedCallbackC          ,
    WebPageDocumentLoadedSignalInfo         ,
    afterWebPageDocumentLoaded              ,
    mkWebPageDocumentLoadedCallback         ,
    noWebPageDocumentLoadedCallback         ,
    onWebPageDocumentLoaded                 ,
    webPageDocumentLoadedCallbackWrapper    ,
    webPageDocumentLoadedClosure            ,


-- ** SendRequest
    WebPageSendRequestCallback              ,
    WebPageSendRequestCallbackC             ,
    WebPageSendRequestSignalInfo            ,
    afterWebPageSendRequest                 ,
    mkWebPageSendRequestCallback            ,
    noWebPageSendRequestCallback            ,
    onWebPageSendRequest                    ,
    webPageSendRequestCallbackWrapper       ,
    webPageSendRequestClosure               ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype WebPage = WebPage (ForeignPtr WebPage)
foreign import ccall "webkit_web_page_get_type"
    c_webkit_web_page_get_type :: IO GType

type instance ParentTypes WebPage = WebPageParentTypes
type WebPageParentTypes = '[GObject.Object]

instance GObject WebPage where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_web_page_get_type
    

class GObject o => WebPageK o
instance (GObject o, IsDescendantOf WebPage o) => WebPageK o

toWebPage :: WebPageK o => o -> IO WebPage
toWebPage = unsafeCastTo WebPage

noWebPage :: Maybe WebPage
noWebPage = Nothing

type family ResolveWebPageMethod (t :: Symbol) (o :: *) :: * where
    ResolveWebPageMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveWebPageMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveWebPageMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveWebPageMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveWebPageMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveWebPageMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveWebPageMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveWebPageMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveWebPageMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveWebPageMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveWebPageMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveWebPageMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveWebPageMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveWebPageMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveWebPageMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveWebPageMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveWebPageMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveWebPageMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveWebPageMethod "getDomDocument" o = WebPageGetDomDocumentMethodInfo
    ResolveWebPageMethod "getEditor" o = WebPageGetEditorMethodInfo
    ResolveWebPageMethod "getId" o = WebPageGetIdMethodInfo
    ResolveWebPageMethod "getMainFrame" o = WebPageGetMainFrameMethodInfo
    ResolveWebPageMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveWebPageMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveWebPageMethod "getUri" o = WebPageGetUriMethodInfo
    ResolveWebPageMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveWebPageMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveWebPageMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveWebPageMethod t WebPage, MethodInfo info WebPage p) => IsLabelProxy t (WebPage -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveWebPageMethod t WebPage, MethodInfo info WebPage p) => IsLabel t (WebPage -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal WebPage::console-message-sent
type WebPageConsoleMessageSentCallback =
    ConsoleMessage ->
    IO ()

noWebPageConsoleMessageSentCallback :: Maybe WebPageConsoleMessageSentCallback
noWebPageConsoleMessageSentCallback = Nothing

type WebPageConsoleMessageSentCallbackC =
    Ptr () ->                               -- object
    Ptr ConsoleMessage ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebPageConsoleMessageSentCallback :: WebPageConsoleMessageSentCallbackC -> IO (FunPtr WebPageConsoleMessageSentCallbackC)

webPageConsoleMessageSentClosure :: WebPageConsoleMessageSentCallback -> IO Closure
webPageConsoleMessageSentClosure cb = newCClosure =<< mkWebPageConsoleMessageSentCallback wrapped
    where wrapped = webPageConsoleMessageSentCallbackWrapper cb

webPageConsoleMessageSentCallbackWrapper ::
    WebPageConsoleMessageSentCallback ->
    Ptr () ->
    Ptr ConsoleMessage ->
    Ptr () ->
    IO ()
webPageConsoleMessageSentCallbackWrapper _cb _ consoleMessage _ = do
    consoleMessage' <- (newBoxed ConsoleMessage) consoleMessage
    _cb  consoleMessage'

onWebPageConsoleMessageSent :: (GObject a, MonadIO m) => a -> WebPageConsoleMessageSentCallback -> m SignalHandlerId
onWebPageConsoleMessageSent obj cb = liftIO $ connectWebPageConsoleMessageSent obj cb SignalConnectBefore
afterWebPageConsoleMessageSent :: (GObject a, MonadIO m) => a -> WebPageConsoleMessageSentCallback -> m SignalHandlerId
afterWebPageConsoleMessageSent obj cb = connectWebPageConsoleMessageSent obj cb SignalConnectAfter

connectWebPageConsoleMessageSent :: (GObject a, MonadIO m) =>
                                    a -> WebPageConsoleMessageSentCallback -> SignalConnectMode -> m SignalHandlerId
connectWebPageConsoleMessageSent obj cb after = liftIO $ do
    cb' <- mkWebPageConsoleMessageSentCallback (webPageConsoleMessageSentCallbackWrapper cb)
    connectSignalFunPtr obj "console-message-sent" cb' after

-- signal WebPage::context-menu
type WebPageContextMenuCallback =
    ContextMenu ->
    WebHitTestResult ->
    IO Bool

noWebPageContextMenuCallback :: Maybe WebPageContextMenuCallback
noWebPageContextMenuCallback = Nothing

type WebPageContextMenuCallbackC =
    Ptr () ->                               -- object
    Ptr ContextMenu ->
    Ptr WebHitTestResult ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebPageContextMenuCallback :: WebPageContextMenuCallbackC -> IO (FunPtr WebPageContextMenuCallbackC)

webPageContextMenuClosure :: WebPageContextMenuCallback -> IO Closure
webPageContextMenuClosure cb = newCClosure =<< mkWebPageContextMenuCallback wrapped
    where wrapped = webPageContextMenuCallbackWrapper cb

webPageContextMenuCallbackWrapper ::
    WebPageContextMenuCallback ->
    Ptr () ->
    Ptr ContextMenu ->
    Ptr WebHitTestResult ->
    Ptr () ->
    IO CInt
webPageContextMenuCallbackWrapper _cb _ contextMenu hitTestResult _ = do
    contextMenu' <- (newObject ContextMenu) contextMenu
    hitTestResult' <- (newObject WebHitTestResult) hitTestResult
    result <- _cb  contextMenu' hitTestResult'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebPageContextMenu :: (GObject a, MonadIO m) => a -> WebPageContextMenuCallback -> m SignalHandlerId
onWebPageContextMenu obj cb = liftIO $ connectWebPageContextMenu obj cb SignalConnectBefore
afterWebPageContextMenu :: (GObject a, MonadIO m) => a -> WebPageContextMenuCallback -> m SignalHandlerId
afterWebPageContextMenu obj cb = connectWebPageContextMenu obj cb SignalConnectAfter

connectWebPageContextMenu :: (GObject a, MonadIO m) =>
                             a -> WebPageContextMenuCallback -> SignalConnectMode -> m SignalHandlerId
connectWebPageContextMenu obj cb after = liftIO $ do
    cb' <- mkWebPageContextMenuCallback (webPageContextMenuCallbackWrapper cb)
    connectSignalFunPtr obj "context-menu" cb' after

-- signal WebPage::document-loaded
type WebPageDocumentLoadedCallback =
    IO ()

noWebPageDocumentLoadedCallback :: Maybe WebPageDocumentLoadedCallback
noWebPageDocumentLoadedCallback = Nothing

type WebPageDocumentLoadedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkWebPageDocumentLoadedCallback :: WebPageDocumentLoadedCallbackC -> IO (FunPtr WebPageDocumentLoadedCallbackC)

webPageDocumentLoadedClosure :: WebPageDocumentLoadedCallback -> IO Closure
webPageDocumentLoadedClosure cb = newCClosure =<< mkWebPageDocumentLoadedCallback wrapped
    where wrapped = webPageDocumentLoadedCallbackWrapper cb

webPageDocumentLoadedCallbackWrapper ::
    WebPageDocumentLoadedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
webPageDocumentLoadedCallbackWrapper _cb _ _ = do
    _cb 

onWebPageDocumentLoaded :: (GObject a, MonadIO m) => a -> WebPageDocumentLoadedCallback -> m SignalHandlerId
onWebPageDocumentLoaded obj cb = liftIO $ connectWebPageDocumentLoaded obj cb SignalConnectBefore
afterWebPageDocumentLoaded :: (GObject a, MonadIO m) => a -> WebPageDocumentLoadedCallback -> m SignalHandlerId
afterWebPageDocumentLoaded obj cb = connectWebPageDocumentLoaded obj cb SignalConnectAfter

connectWebPageDocumentLoaded :: (GObject a, MonadIO m) =>
                                a -> WebPageDocumentLoadedCallback -> SignalConnectMode -> m SignalHandlerId
connectWebPageDocumentLoaded obj cb after = liftIO $ do
    cb' <- mkWebPageDocumentLoadedCallback (webPageDocumentLoadedCallbackWrapper cb)
    connectSignalFunPtr obj "document-loaded" cb' after

-- signal WebPage::send-request
type WebPageSendRequestCallback =
    URIRequest ->
    URIResponse ->
    IO Bool

noWebPageSendRequestCallback :: Maybe WebPageSendRequestCallback
noWebPageSendRequestCallback = Nothing

type WebPageSendRequestCallbackC =
    Ptr () ->                               -- object
    Ptr URIRequest ->
    Ptr URIResponse ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkWebPageSendRequestCallback :: WebPageSendRequestCallbackC -> IO (FunPtr WebPageSendRequestCallbackC)

webPageSendRequestClosure :: WebPageSendRequestCallback -> IO Closure
webPageSendRequestClosure cb = newCClosure =<< mkWebPageSendRequestCallback wrapped
    where wrapped = webPageSendRequestCallbackWrapper cb

webPageSendRequestCallbackWrapper ::
    WebPageSendRequestCallback ->
    Ptr () ->
    Ptr URIRequest ->
    Ptr URIResponse ->
    Ptr () ->
    IO CInt
webPageSendRequestCallbackWrapper _cb _ request redirectedResponse _ = do
    request' <- (newObject URIRequest) request
    redirectedResponse' <- (newObject URIResponse) redirectedResponse
    result <- _cb  request' redirectedResponse'
    let result' = (fromIntegral . fromEnum) result
    return result'

onWebPageSendRequest :: (GObject a, MonadIO m) => a -> WebPageSendRequestCallback -> m SignalHandlerId
onWebPageSendRequest obj cb = liftIO $ connectWebPageSendRequest obj cb SignalConnectBefore
afterWebPageSendRequest :: (GObject a, MonadIO m) => a -> WebPageSendRequestCallback -> m SignalHandlerId
afterWebPageSendRequest obj cb = connectWebPageSendRequest obj cb SignalConnectAfter

connectWebPageSendRequest :: (GObject a, MonadIO m) =>
                             a -> WebPageSendRequestCallback -> SignalConnectMode -> m SignalHandlerId
connectWebPageSendRequest obj cb after = liftIO $ do
    cb' <- mkWebPageSendRequestCallback (webPageSendRequestCallbackWrapper cb)
    connectSignalFunPtr obj "send-request" cb' after

-- VVV Prop "uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getWebPageUri :: (MonadIO m, WebPageK o) => o -> m T.Text
getWebPageUri obj = liftIO $ checkUnexpectedNothing "getWebPageUri" $ getObjectPropertyString obj "uri"

data WebPageUriPropertyInfo
instance AttrInfo WebPageUriPropertyInfo where
    type AttrAllowedOps WebPageUriPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WebPageUriPropertyInfo = (~) ()
    type AttrBaseTypeConstraint WebPageUriPropertyInfo = WebPageK
    type AttrGetType WebPageUriPropertyInfo = T.Text
    type AttrLabel WebPageUriPropertyInfo = "uri"
    attrGet _ = getWebPageUri
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList WebPage = WebPageAttributeList
type WebPageAttributeList = ('[ '("uri", WebPageUriPropertyInfo)] :: [(Symbol, *)])

webPageUri :: AttrLabelProxy "uri"
webPageUri = AttrLabelProxy

data WebPageConsoleMessageSentSignalInfo
instance SignalInfo WebPageConsoleMessageSentSignalInfo where
    type HaskellCallbackType WebPageConsoleMessageSentSignalInfo = WebPageConsoleMessageSentCallback
    connectSignal _ = connectWebPageConsoleMessageSent

data WebPageContextMenuSignalInfo
instance SignalInfo WebPageContextMenuSignalInfo where
    type HaskellCallbackType WebPageContextMenuSignalInfo = WebPageContextMenuCallback
    connectSignal _ = connectWebPageContextMenu

data WebPageDocumentLoadedSignalInfo
instance SignalInfo WebPageDocumentLoadedSignalInfo where
    type HaskellCallbackType WebPageDocumentLoadedSignalInfo = WebPageDocumentLoadedCallback
    connectSignal _ = connectWebPageDocumentLoaded

data WebPageSendRequestSignalInfo
instance SignalInfo WebPageSendRequestSignalInfo where
    type HaskellCallbackType WebPageSendRequestSignalInfo = WebPageSendRequestCallback
    connectSignal _ = connectWebPageSendRequest

type instance SignalList WebPage = WebPageSignalList
type WebPageSignalList = ('[ '("consoleMessageSent", WebPageConsoleMessageSentSignalInfo), '("contextMenu", WebPageContextMenuSignalInfo), '("documentLoaded", WebPageDocumentLoadedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo), '("sendRequest", WebPageSendRequestSignalInfo)] :: [(Symbol, *)])

-- method WebPage::get_dom_document
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "WebPage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "DOMDocument")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_page_get_dom_document" webkit_web_page_get_dom_document :: 
    Ptr WebPage ->                          -- _obj : TInterface "WebKit2WebExtension" "WebPage"
    IO (Ptr DOMDocument)


webPageGetDomDocument ::
    (MonadIO m, WebPageK a) =>
    a                                       -- _obj
    -> m DOMDocument                        -- result
webPageGetDomDocument _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_page_get_dom_document _obj'
    checkUnexpectedReturnNULL "webkit_web_page_get_dom_document" result
    result' <- (newObject DOMDocument) result
    touchManagedPtr _obj
    return result'

data WebPageGetDomDocumentMethodInfo
instance (signature ~ (m DOMDocument), MonadIO m, WebPageK a) => MethodInfo WebPageGetDomDocumentMethodInfo a signature where
    overloadedMethod _ = webPageGetDomDocument

-- method WebPage::get_editor
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "WebPage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "WebEditor")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_page_get_editor" webkit_web_page_get_editor :: 
    Ptr WebPage ->                          -- _obj : TInterface "WebKit2WebExtension" "WebPage"
    IO (Ptr WebEditor)


webPageGetEditor ::
    (MonadIO m, WebPageK a) =>
    a                                       -- _obj
    -> m WebEditor                          -- result
webPageGetEditor _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_page_get_editor _obj'
    checkUnexpectedReturnNULL "webkit_web_page_get_editor" result
    result' <- (newObject WebEditor) result
    touchManagedPtr _obj
    return result'

data WebPageGetEditorMethodInfo
instance (signature ~ (m WebEditor), MonadIO m, WebPageK a) => MethodInfo WebPageGetEditorMethodInfo a signature where
    overloadedMethod _ = webPageGetEditor

-- method WebPage::get_id
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "WebPage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt64)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_page_get_id" webkit_web_page_get_id :: 
    Ptr WebPage ->                          -- _obj : TInterface "WebKit2WebExtension" "WebPage"
    IO Word64


webPageGetId ::
    (MonadIO m, WebPageK a) =>
    a                                       -- _obj
    -> m Word64                             -- result
webPageGetId _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_page_get_id _obj'
    touchManagedPtr _obj
    return result

data WebPageGetIdMethodInfo
instance (signature ~ (m Word64), MonadIO m, WebPageK a) => MethodInfo WebPageGetIdMethodInfo a signature where
    overloadedMethod _ = webPageGetId

-- method WebPage::get_main_frame
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "WebPage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "Frame")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_page_get_main_frame" webkit_web_page_get_main_frame :: 
    Ptr WebPage ->                          -- _obj : TInterface "WebKit2WebExtension" "WebPage"
    IO (Ptr Frame)


webPageGetMainFrame ::
    (MonadIO m, WebPageK a) =>
    a                                       -- _obj
    -> m Frame                              -- result
webPageGetMainFrame _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_page_get_main_frame _obj'
    checkUnexpectedReturnNULL "webkit_web_page_get_main_frame" result
    result' <- (newObject Frame) result
    touchManagedPtr _obj
    return result'

data WebPageGetMainFrameMethodInfo
instance (signature ~ (m Frame), MonadIO m, WebPageK a) => MethodInfo WebPageGetMainFrameMethodInfo a signature where
    overloadedMethod _ = webPageGetMainFrame

-- method WebPage::get_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "WebPage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_web_page_get_uri" webkit_web_page_get_uri :: 
    Ptr WebPage ->                          -- _obj : TInterface "WebKit2WebExtension" "WebPage"
    IO CString


webPageGetUri ::
    (MonadIO m, WebPageK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
webPageGetUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_web_page_get_uri _obj'
    checkUnexpectedReturnNULL "webkit_web_page_get_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data WebPageGetUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, WebPageK a) => MethodInfo WebPageGetUriMethodInfo a signature where
    overloadedMethod _ = webPageGetUri


