

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Structs.ConsoleMessage
    ( 

-- * Exported types
    ConsoleMessage(..)                      ,
    noConsoleMessage                        ,


 -- * Methods
-- ** consoleMessageCopy
    ConsoleMessageCopyMethodInfo            ,
    consoleMessageCopy                      ,


-- ** consoleMessageFree
    ConsoleMessageFreeMethodInfo            ,
    consoleMessageFree                      ,


-- ** consoleMessageGetLevel
    ConsoleMessageGetLevelMethodInfo        ,
    consoleMessageGetLevel                  ,


-- ** consoleMessageGetLine
    ConsoleMessageGetLineMethodInfo         ,
    consoleMessageGetLine                   ,


-- ** consoleMessageGetSource
    ConsoleMessageGetSourceMethodInfo       ,
    consoleMessageGetSource                 ,


-- ** consoleMessageGetSourceId
    ConsoleMessageGetSourceIdMethodInfo     ,
    consoleMessageGetSourceId               ,


-- ** consoleMessageGetText
    ConsoleMessageGetTextMethodInfo         ,
    consoleMessageGetText                   ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks

newtype ConsoleMessage = ConsoleMessage (ForeignPtr ConsoleMessage)
foreign import ccall "webkit_console_message_get_type" c_webkit_console_message_get_type :: 
    IO GType

instance BoxedObject ConsoleMessage where
    boxedType _ = c_webkit_console_message_get_type

noConsoleMessage :: Maybe ConsoleMessage
noConsoleMessage = Nothing


type instance AttributeList ConsoleMessage = ConsoleMessageAttributeList
type ConsoleMessageAttributeList = ('[ ] :: [(Symbol, *)])

-- method ConsoleMessage::copy
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ConsoleMessage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ConsoleMessage")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_console_message_copy" webkit_console_message_copy :: 
    Ptr ConsoleMessage ->                   -- _obj : TInterface "WebKit2WebExtension" "ConsoleMessage"
    IO (Ptr ConsoleMessage)


consoleMessageCopy ::
    (MonadIO m) =>
    ConsoleMessage                          -- _obj
    -> m ConsoleMessage                     -- result
consoleMessageCopy _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_console_message_copy _obj'
    checkUnexpectedReturnNULL "webkit_console_message_copy" result
    result' <- (wrapBoxed ConsoleMessage) result
    touchManagedPtr _obj
    return result'

data ConsoleMessageCopyMethodInfo
instance (signature ~ (m ConsoleMessage), MonadIO m) => MethodInfo ConsoleMessageCopyMethodInfo ConsoleMessage signature where
    overloadedMethod _ = consoleMessageCopy

-- method ConsoleMessage::free
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ConsoleMessage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_console_message_free" webkit_console_message_free :: 
    Ptr ConsoleMessage ->                   -- _obj : TInterface "WebKit2WebExtension" "ConsoleMessage"
    IO ()


consoleMessageFree ::
    (MonadIO m) =>
    ConsoleMessage                          -- _obj
    -> m ()                                 -- result
consoleMessageFree _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    webkit_console_message_free _obj'
    touchManagedPtr _obj
    return ()

data ConsoleMessageFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => MethodInfo ConsoleMessageFreeMethodInfo ConsoleMessage signature where
    overloadedMethod _ = consoleMessageFree

-- method ConsoleMessage::get_level
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ConsoleMessage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ConsoleMessageLevel")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_console_message_get_level" webkit_console_message_get_level :: 
    Ptr ConsoleMessage ->                   -- _obj : TInterface "WebKit2WebExtension" "ConsoleMessage"
    IO CUInt


consoleMessageGetLevel ::
    (MonadIO m) =>
    ConsoleMessage                          -- _obj
    -> m ConsoleMessageLevel                -- result
consoleMessageGetLevel _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_console_message_get_level _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data ConsoleMessageGetLevelMethodInfo
instance (signature ~ (m ConsoleMessageLevel), MonadIO m) => MethodInfo ConsoleMessageGetLevelMethodInfo ConsoleMessage signature where
    overloadedMethod _ = consoleMessageGetLevel

-- method ConsoleMessage::get_line
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ConsoleMessage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_console_message_get_line" webkit_console_message_get_line :: 
    Ptr ConsoleMessage ->                   -- _obj : TInterface "WebKit2WebExtension" "ConsoleMessage"
    IO Word32


consoleMessageGetLine ::
    (MonadIO m) =>
    ConsoleMessage                          -- _obj
    -> m Word32                             -- result
consoleMessageGetLine _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_console_message_get_line _obj'
    touchManagedPtr _obj
    return result

data ConsoleMessageGetLineMethodInfo
instance (signature ~ (m Word32), MonadIO m) => MethodInfo ConsoleMessageGetLineMethodInfo ConsoleMessage signature where
    overloadedMethod _ = consoleMessageGetLine

-- method ConsoleMessage::get_source
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ConsoleMessage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2WebExtension" "ConsoleMessageSource")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_console_message_get_source" webkit_console_message_get_source :: 
    Ptr ConsoleMessage ->                   -- _obj : TInterface "WebKit2WebExtension" "ConsoleMessage"
    IO CUInt


consoleMessageGetSource ::
    (MonadIO m) =>
    ConsoleMessage                          -- _obj
    -> m ConsoleMessageSource               -- result
consoleMessageGetSource _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_console_message_get_source _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data ConsoleMessageGetSourceMethodInfo
instance (signature ~ (m ConsoleMessageSource), MonadIO m) => MethodInfo ConsoleMessageGetSourceMethodInfo ConsoleMessage signature where
    overloadedMethod _ = consoleMessageGetSource

-- method ConsoleMessage::get_source_id
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ConsoleMessage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_console_message_get_source_id" webkit_console_message_get_source_id :: 
    Ptr ConsoleMessage ->                   -- _obj : TInterface "WebKit2WebExtension" "ConsoleMessage"
    IO CString


consoleMessageGetSourceId ::
    (MonadIO m) =>
    ConsoleMessage                          -- _obj
    -> m T.Text                             -- result
consoleMessageGetSourceId _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_console_message_get_source_id _obj'
    checkUnexpectedReturnNULL "webkit_console_message_get_source_id" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data ConsoleMessageGetSourceIdMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => MethodInfo ConsoleMessageGetSourceIdMethodInfo ConsoleMessage signature where
    overloadedMethod _ = consoleMessageGetSourceId

-- method ConsoleMessage::get_text
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2WebExtension" "ConsoleMessage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_console_message_get_text" webkit_console_message_get_text :: 
    Ptr ConsoleMessage ->                   -- _obj : TInterface "WebKit2WebExtension" "ConsoleMessage"
    IO CString


consoleMessageGetText ::
    (MonadIO m) =>
    ConsoleMessage                          -- _obj
    -> m T.Text                             -- result
consoleMessageGetText _obj = liftIO $ do
    let _obj' = unsafeManagedPtrGetPtr _obj
    result <- webkit_console_message_get_text _obj'
    checkUnexpectedReturnNULL "webkit_console_message_get_text" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data ConsoleMessageGetTextMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => MethodInfo ConsoleMessageGetTextMethodInfo ConsoleMessage signature where
    overloadedMethod _ = consoleMessageGetText

type family ResolveConsoleMessageMethod (t :: Symbol) (o :: *) :: * where
    ResolveConsoleMessageMethod "copy" o = ConsoleMessageCopyMethodInfo
    ResolveConsoleMessageMethod "free" o = ConsoleMessageFreeMethodInfo
    ResolveConsoleMessageMethod "getLevel" o = ConsoleMessageGetLevelMethodInfo
    ResolveConsoleMessageMethod "getLine" o = ConsoleMessageGetLineMethodInfo
    ResolveConsoleMessageMethod "getSource" o = ConsoleMessageGetSourceMethodInfo
    ResolveConsoleMessageMethod "getSourceId" o = ConsoleMessageGetSourceIdMethodInfo
    ResolveConsoleMessageMethod "getText" o = ConsoleMessageGetTextMethodInfo
    ResolveConsoleMessageMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveConsoleMessageMethod t ConsoleMessage, MethodInfo info ConsoleMessage p) => IsLabelProxy t (ConsoleMessage -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveConsoleMessageMethod t ConsoleMessage, MethodInfo info ConsoleMessage p) => IsLabel t (ConsoleMessage -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


