

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Structs.ContextMenuItem_
    ( 

-- * Exported types
    ContextMenuItem_(..)                    ,
    newZeroContextMenuItem_                 ,
    noContextMenuItem_                      ,


 -- * Properties
-- ** Parent
    contextMenuItem_ClearParent             ,
    contextMenuItem_Parent                  ,
    contextMenuItem_ReadParent              ,
    contextMenuItem_WriteParent             ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype ContextMenuItem_ = ContextMenuItem_ (ForeignPtr ContextMenuItem_)
instance WrappedPtr ContextMenuItem_ where
    wrappedPtrCalloc = callocBytes 32
    wrappedPtrCopy = copyPtr 32
    wrappedPtrFree = Just ptr_to_g_free

-- | Construct a `ContextMenuItem_` struct initialized to zero.
newZeroContextMenuItem_ :: MonadIO m => m ContextMenuItem_
newZeroContextMenuItem_ = liftIO $ wrappedPtrCalloc >>= wrapPtr ContextMenuItem_

instance tag ~ 'AttrSet => Constructible ContextMenuItem_ tag where
    new _ attrs = do
        o <- newZeroContextMenuItem_
        GI.Attributes.set o attrs
        return o


noContextMenuItem_ :: Maybe ContextMenuItem_
noContextMenuItem_ = Nothing

contextMenuItem_ReadParent :: MonadIO m => ContextMenuItem_ -> m (Maybe GObject.InitiallyUnowned)
contextMenuItem_ReadParent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr GObject.InitiallyUnowned)
    result <- convertIfNonNull val $ \val' -> do
        val'' <- (newObject GObject.InitiallyUnowned) val'
        return val''
    return result

contextMenuItem_WriteParent :: MonadIO m => ContextMenuItem_ -> Ptr GObject.InitiallyUnowned -> m ()
contextMenuItem_WriteParent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr GObject.InitiallyUnowned)

contextMenuItem_ClearParent :: MonadIO m => ContextMenuItem_ -> m ()
contextMenuItem_ClearParent s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (nullPtr :: Ptr GObject.InitiallyUnowned)

data ContextMenuItem_ParentFieldInfo
instance AttrInfo ContextMenuItem_ParentFieldInfo where
    type AttrAllowedOps ContextMenuItem_ParentFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ContextMenuItem_ParentFieldInfo = (~) (Ptr GObject.InitiallyUnowned)
    type AttrBaseTypeConstraint ContextMenuItem_ParentFieldInfo = (~) ContextMenuItem_
    type AttrGetType ContextMenuItem_ParentFieldInfo = Maybe GObject.InitiallyUnowned
    type AttrLabel ContextMenuItem_ParentFieldInfo = "parent"
    attrGet _ = contextMenuItem_ReadParent
    attrSet _ = contextMenuItem_WriteParent
    attrConstruct = undefined
    attrClear _ = contextMenuItem_ClearParent

contextMenuItem_Parent :: AttrLabelProxy "parent"
contextMenuItem_Parent = AttrLabelProxy




type instance AttributeList ContextMenuItem_ = ContextMenuItem_AttributeList
type ContextMenuItem_AttributeList = ('[ '("parent", ContextMenuItem_ParentFieldInfo)] :: [(Symbol, *)])

type family ResolveContextMenuItem_Method (t :: Symbol) (o :: *) :: * where
    ResolveContextMenuItem_Method l o = MethodResolutionFailed l o

instance (info ~ ResolveContextMenuItem_Method t ContextMenuItem_, MethodInfo info ContextMenuItem_ p) => IsLabelProxy t (ContextMenuItem_ -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveContextMenuItem_Method t ContextMenuItem_, MethodInfo info ContextMenuItem_ p) => IsLabel t (ContextMenuItem_ -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


