

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2WebExtension.Structs.ContextMenu_
    ( 

-- * Exported types
    ContextMenu_(..)                        ,
    newZeroContextMenu_                     ,
    noContextMenu_                          ,


 -- * Properties
-- ** Parent
    contextMenu_ClearParent                 ,
    contextMenu_Parent                      ,
    contextMenu_ReadParent                  ,
    contextMenu_WriteParent                 ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2WebExtension.Types
import GI.WebKit2WebExtension.Callbacks
import qualified GI.GObject as GObject

newtype ContextMenu_ = ContextMenu_ (ForeignPtr ContextMenu_)
instance WrappedPtr ContextMenu_ where
    wrappedPtrCalloc = callocBytes 32
    wrappedPtrCopy = copyPtr 32
    wrappedPtrFree = Just ptr_to_g_free

-- | Construct a `ContextMenu_` struct initialized to zero.
newZeroContextMenu_ :: MonadIO m => m ContextMenu_
newZeroContextMenu_ = liftIO $ wrappedPtrCalloc >>= wrapPtr ContextMenu_

instance tag ~ 'AttrSet => Constructible ContextMenu_ tag where
    new _ attrs = do
        o <- newZeroContextMenu_
        GI.Attributes.set o attrs
        return o


noContextMenu_ :: Maybe ContextMenu_
noContextMenu_ = Nothing

contextMenu_ReadParent :: MonadIO m => ContextMenu_ -> m (Maybe GObject.Object)
contextMenu_ReadParent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr GObject.Object)
    result <- convertIfNonNull val $ \val' -> do
        val'' <- (newObject GObject.Object) val'
        return val''
    return result

contextMenu_WriteParent :: MonadIO m => ContextMenu_ -> Ptr GObject.Object -> m ()
contextMenu_WriteParent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr GObject.Object)

contextMenu_ClearParent :: MonadIO m => ContextMenu_ -> m ()
contextMenu_ClearParent s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (nullPtr :: Ptr GObject.Object)

data ContextMenu_ParentFieldInfo
instance AttrInfo ContextMenu_ParentFieldInfo where
    type AttrAllowedOps ContextMenu_ParentFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ContextMenu_ParentFieldInfo = (~) (Ptr GObject.Object)
    type AttrBaseTypeConstraint ContextMenu_ParentFieldInfo = (~) ContextMenu_
    type AttrGetType ContextMenu_ParentFieldInfo = Maybe GObject.Object
    type AttrLabel ContextMenu_ParentFieldInfo = "parent"
    attrGet _ = contextMenu_ReadParent
    attrSet _ = contextMenu_WriteParent
    attrConstruct = undefined
    attrClear _ = contextMenu_ClearParent

contextMenu_Parent :: AttrLabelProxy "parent"
contextMenu_Parent = AttrLabelProxy




type instance AttributeList ContextMenu_ = ContextMenu_AttributeList
type ContextMenu_AttributeList = ('[ '("parent", ContextMenu_ParentFieldInfo)] :: [(Symbol, *)])

type family ResolveContextMenu_Method (t :: Symbol) (o :: *) :: * where
    ResolveContextMenu_Method l o = MethodResolutionFailed l o

instance (info ~ ResolveContextMenu_Method t ContextMenu_, MethodInfo info ContextMenu_ p) => IsLabelProxy t (ContextMenu_ -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveContextMenu_Method t ContextMenu_, MethodInfo info ContextMenu_ p) => IsLabel t (ContextMenu_ -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif


