{-# LANGUAGE TemplateHaskell #-}

module Gitlab.Projects where

import           Data.Yaml
import           Gitlab.Core
import           Lens.Micro.Platform
import           RIO
import           RIO.Time

data GitlabCommitData = GitlabCommitData {
  _authoredDate  :: UTCTime,
  _authorEmail   :: Text,
  _authorName    :: Text,
  _committedDate :: UTCTime,
  _committerName :: Text,
  _commitId      :: Text
} deriving (Eq, Show)

$(makeLenses ''GitlabCommitData)

instance FromJSON GitlabCommitData where
  parseJSON = withObject "GitlabCommitData" $ \v -> GitlabCommitData
    <$> v .: "authored_date"
    <*> v .: "author_email"
    <*> v .: "author_name"
    <*> v .: "committed_date"
    <*> v .: "committer_name"
    <*> v .: "id"

getCommitData :: MonadGitlab env m => Text -> Text -> m GitlabCommitData
getCommitData p r = gitlabRequest
  "GET"
  ("/projects/" <> rParam p <> "/repository/commits/" <> rParam r)
  mempty
