-- This file is automatically generated by the tools/makeEnum.hs
--	% stack runghc --cwd tools/ makeEnum

{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE TypeSynonymInstances #-}
{-# LANGUAGE PatternSynonyms #-}
{-# LANGUAGE GeneralizedNewtypeDeriving #-}
{-# OPTIONS_GHC -Wall -fno-warn-missing-export-lists -fno-warn-tabs #-}

module Gpu.Vulkan.Enum where

import Foreign.Storable
import Foreign.C.Enum
import Foreign.Ptr
import Data.Bits
import Data.Word

#include <vulkan/vulkan.h>

enum "AccessFlagBits2" ''#{type VkAccessFlagBits2}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("AccessFlags2Zero", 0),
	("Access2None", #{const VK_ACCESS_2_NONE}),
	("Access2IndirectCommandReadBit",
		#{const VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT}),
	("Access2IndexReadBit", #{const VK_ACCESS_2_INDEX_READ_BIT}),
	("Access2VertexAttributeReadBit",
		#{const VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT}),
	("Access2UniformReadBit", #{const VK_ACCESS_2_UNIFORM_READ_BIT}),
	("Access2InputAttachmentReadBit",
		#{const VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT}),
	("Access2ShaderReadBit", #{const VK_ACCESS_2_SHADER_READ_BIT}),
	("Access2ShaderWriteBit", #{const VK_ACCESS_2_SHADER_WRITE_BIT}),
	("Access2ColorAttachmentReadBit",
		#{const VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT}),
	("Access2ColorAttachmentWriteBit",
		#{const VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT}),
	("Access2DepthStencilAttachmentReadBit",
		#{const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT}),
	("Access2DepthStencilAttachmentWriteBit",
		#{const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT}),
	("Access2TransferReadBit", #{const VK_ACCESS_2_TRANSFER_READ_BIT}),
	("Access2TransferWriteBit", #{const VK_ACCESS_2_TRANSFER_WRITE_BIT}),
	("Access2HostReadBit", #{const VK_ACCESS_2_HOST_READ_BIT}),
	("Access2HostWriteBit", #{const VK_ACCESS_2_HOST_WRITE_BIT}),
	("Access2MemoryReadBit", #{const VK_ACCESS_2_MEMORY_READ_BIT}),
	("Access2MemoryWriteBit", #{const VK_ACCESS_2_MEMORY_WRITE_BIT}),
	("Access2ShaderSampledReadBit",
		#{const VK_ACCESS_2_SHADER_SAMPLED_READ_BIT}),
	("Access2ShaderStorageReadBit",
		#{const VK_ACCESS_2_SHADER_STORAGE_READ_BIT}),
	("Access2ShaderStorageWriteBit",
		#{const VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT}),
	("Access2VideoDecodeReadBitKhr",
		#{const VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR}),
	("Access2VideoDecodeWriteBitKhr",
		#{const VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR}),
	("Access2VideoEncodeReadBitKhr",
		#{const VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR}),
	("Access2VideoEncodeWriteBitKhr",
		#{const VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR}),
	("Access2ShaderTileAttachmentReadBitQcom",
		#{const VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM}),
	("Access2ShaderTileAttachmentWriteBitQcom",
		#{const VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM}),
	("Access2NoneKhr", #{const VK_ACCESS_2_NONE_KHR}),
	("Access2IndirectCommandReadBitKhr",
		#{const VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR}),
	("Access2IndexReadBitKhr", #{const VK_ACCESS_2_INDEX_READ_BIT_KHR}),
	("Access2VertexAttributeReadBitKhr",
		#{const VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR}),
	("Access2UniformReadBitKhr", #{const VK_ACCESS_2_UNIFORM_READ_BIT_KHR}),
	("Access2InputAttachmentReadBitKhr",
		#{const VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR}),
	("Access2ShaderReadBitKhr", #{const VK_ACCESS_2_SHADER_READ_BIT_KHR}),
	("Access2ShaderWriteBitKhr", #{const VK_ACCESS_2_SHADER_WRITE_BIT_KHR}),
	("Access2ColorAttachmentReadBitKhr",
		#{const VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR}),
	("Access2ColorAttachmentWriteBitKhr",
		#{const VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR}),
	("Access2DepthStencilAttachmentReadBitKhr",
		#{const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR}),
	("Access2DepthStencilAttachmentWriteBitKhr",
		#{const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR}),
	("Access2TransferReadBitKhr",
		#{const VK_ACCESS_2_TRANSFER_READ_BIT_KHR}),
	("Access2TransferWriteBitKhr",
		#{const VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR}),
	("Access2HostReadBitKhr", #{const VK_ACCESS_2_HOST_READ_BIT_KHR}),
	("Access2HostWriteBitKhr", #{const VK_ACCESS_2_HOST_WRITE_BIT_KHR}),
	("Access2MemoryReadBitKhr", #{const VK_ACCESS_2_MEMORY_READ_BIT_KHR}),
	("Access2MemoryWriteBitKhr", #{const VK_ACCESS_2_MEMORY_WRITE_BIT_KHR}),
	("Access2ShaderSampledReadBitKhr",
		#{const VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR}),
	("Access2ShaderStorageReadBitKhr",
		#{const VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR}),
	("Access2ShaderStorageWriteBitKhr",
		#{const VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR}),
	("Access2TransformFeedbackWriteBitExt",
		#{const VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT}),
	("Access2TransformFeedbackCounterReadBitExt",
		#{const VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT}),
	("Access2TransformFeedbackCounterWriteBitExt",
		#{const VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT}),
	("Access2ConditionalRenderingReadBitExt",
		#{const VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT}),
	("Access2CommandPreprocessReadBitNv",
		#{const VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV}),
	("Access2CommandPreprocessWriteBitNv",
		#{const VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV}),
	("Access2CommandPreprocessReadBitExt",
		#{const VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_EXT}),
	("Access2CommandPreprocessWriteBitExt",
		#{const VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_EXT}),
	("Access2FragmentShadingRateAttachmentReadBitKhr",
		#{const VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR}),
	("Access2ShadingRateImageReadBitNv",
		#{const VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV}),
	("Access2AccelerationStructureReadBitKhr",
		#{const VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR}),
	("Access2AccelerationStructureWriteBitKhr",
		#{const VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR}),
	("Access2AccelerationStructureReadBitNv",
		#{const VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_NV}),
	("Access2AccelerationStructureWriteBitNv",
		#{const VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_NV}),
	("Access2FragmentDensityMapReadBitExt",
		#{const VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT}),
	("Access2ColorAttachmentReadNoncoherentBitExt",
		#{const VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT}),
	("Access2DescriptorBufferReadBitExt",
		#{const VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT}),
	("Access2InvocationMaskReadBitHuawei",
		#{const VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI}),
	("Access2ShaderBindingTableReadBitKhr",
		#{const VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR}),
	("Access2MicromapReadBitExt",
		#{const VK_ACCESS_2_MICROMAP_READ_BIT_EXT}),
	("Access2MicromapWriteBitExt",
		#{const VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT}),
	("Access2OpticalFlowReadBitNv",
		#{const VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV}),
	("Access2OpticalFlowWriteBitNv",
		#{const VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV}),
	("Access2DataGraphReadBitArm",
		#{const VK_ACCESS_2_DATA_GRAPH_READ_BIT_ARM}),
	("Access2DataGraphWriteBitArm",
		#{const VK_ACCESS_2_DATA_GRAPH_WRITE_BIT_ARM}) ]

enum "StructureType" ''#{type VkStructureType}
		[''Show, ''Eq, ''Storable] [
	("StructureTypeApplicationInfo",
		#{const VK_STRUCTURE_TYPE_APPLICATION_INFO}),
	("StructureTypeInstanceCreateInfo",
		#{const VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO}),
	("StructureTypeDeviceQueueCreateInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO}),
	("StructureTypeDeviceCreateInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO}),
	("StructureTypeSubmitInfo", #{const VK_STRUCTURE_TYPE_SUBMIT_INFO}),
	("StructureTypeMemoryAllocateInfo",
		#{const VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO}),
	("StructureTypeMappedMemoryRange",
		#{const VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE}),
	("StructureTypeBindSparseInfo",
		#{const VK_STRUCTURE_TYPE_BIND_SPARSE_INFO}),
	("StructureTypeFenceCreateInfo",
		#{const VK_STRUCTURE_TYPE_FENCE_CREATE_INFO}),
	("StructureTypeSemaphoreCreateInfo",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO}),
	("StructureTypeEventCreateInfo",
		#{const VK_STRUCTURE_TYPE_EVENT_CREATE_INFO}),
	("StructureTypeQueryPoolCreateInfo",
		#{const VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO}),
	("StructureTypeBufferCreateInfo",
		#{const VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO}),
	("StructureTypeBufferViewCreateInfo",
		#{const VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO}),
	("StructureTypeImageCreateInfo",
		#{const VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO}),
	("StructureTypeImageViewCreateInfo",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO}),
	("StructureTypeShaderModuleCreateInfo",
		#{const VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO}),
	("StructureTypePipelineCacheCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO}),
	("StructureTypePipelineShaderStageCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO}),
	("StructureTypePipelineVertexInputStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO}),
	("StructureTypePipelineInputAssemblyStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO}),
	("StructureTypePipelineTessellationStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO}),
	("StructureTypePipelineViewportStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO}),
	("StructureTypePipelineRasterizationStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO}),
	("StructureTypePipelineMultisampleStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO}),
	("StructureTypePipelineDepthStencilStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO}),
	("StructureTypePipelineColorBlendStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO}),
	("StructureTypePipelineDynamicStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO}),
	("StructureTypeGraphicsPipelineCreateInfo",
		#{const VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO}),
	("StructureTypeComputePipelineCreateInfo",
		#{const VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO}),
	("StructureTypePipelineLayoutCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO}),
	("StructureTypeSamplerCreateInfo",
		#{const VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO}),
	("StructureTypeDescriptorSetLayoutCreateInfo",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO}),
	("StructureTypeDescriptorPoolCreateInfo",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO}),
	("StructureTypeDescriptorSetAllocateInfo",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO}),
	("StructureTypeWriteDescriptorSet",
		#{const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET}),
	("StructureTypeCopyDescriptorSet",
		#{const VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET}),
	("StructureTypeFramebufferCreateInfo",
		#{const VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO}),
	("StructureTypeRenderPassCreateInfo",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO}),
	("StructureTypeCommandPoolCreateInfo",
		#{const VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO}),
	("StructureTypeCommandBufferAllocateInfo",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO}),
	("StructureTypeCommandBufferInheritanceInfo",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO}),
	("StructureTypeCommandBufferBeginInfo",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO}),
	("StructureTypeRenderPassBeginInfo",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO}),
	("StructureTypeBufferMemoryBarrier",
		#{const VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER}),
	("StructureTypeImageMemoryBarrier",
		#{const VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER}),
	("StructureTypeMemoryBarrier",
		#{const VK_STRUCTURE_TYPE_MEMORY_BARRIER}),
	("StructureTypeLoaderInstanceCreateInfo",
		#{const VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO}),
	("StructureTypeLoaderDeviceCreateInfo",
		#{const VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO}),
	("StructureTypePhysicalDeviceSubgroupProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES}),
	("StructureTypeBindBufferMemoryInfo",
		#{const VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO}),
	("StructureTypeBindImageMemoryInfo",
		#{const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO}),
	("StructureTypePhysicalDevice16bitStorageFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES}),
	("StructureTypeMemoryDedicatedRequirements",
		#{const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS}),
	("StructureTypeMemoryDedicatedAllocateInfo",
		#{const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO}),
	("StructureTypeMemoryAllocateFlagsInfo",
		#{const VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO}),
	("StructureTypeDeviceGroupRenderPassBeginInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO}),
	("StructureTypeDeviceGroupCommandBufferBeginInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO}),
	("StructureTypeDeviceGroupSubmitInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO}),
	("StructureTypeDeviceGroupBindSparseInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO}),
	("StructureTypeBindBufferMemoryDeviceGroupInfo",
		#{const VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO}),
	("StructureTypeBindImageMemoryDeviceGroupInfo",
		#{const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO}),
	("StructureTypePhysicalDeviceGroupProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES}),
	("StructureTypeDeviceGroupDeviceCreateInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO}),
	("StructureTypeBufferMemoryRequirementsInfo2",
		#{const VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2}),
	("StructureTypeImageMemoryRequirementsInfo2",
		#{const VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2}),
	("StructureTypeImageSparseMemoryRequirementsInfo2",
		#{const VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2}),
	("StructureTypeMemoryRequirements2",
		#{const VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2}),
	("StructureTypeSparseImageMemoryRequirements2",
		#{const VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2}),
	("StructureTypePhysicalDeviceFeatures2",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2}),
	("StructureTypePhysicalDeviceProperties2",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2}),
	("StructureTypeFormatProperties2",
		#{const VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2}),
	("StructureTypeImageFormatProperties2",
		#{const VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2}),
	("StructureTypePhysicalDeviceImageFormatInfo2",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2}),
	("StructureTypeQueueFamilyProperties2",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2}),
	("StructureTypePhysicalDeviceMemoryProperties2",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2}),
	("StructureTypeSparseImageFormatProperties2",
		#{const VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2}),
	("StructureTypePhysicalDeviceSparseImageFormatInfo2",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2}),
	("StructureTypePhysicalDevicePointClippingProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES}),
	("StructureTypeRenderPassInputAttachmentAspectCreateInfo",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO}),
	("StructureTypeImageViewUsageCreateInfo",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO}),
	("StructureTypePipelineTessellationDomainOriginStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO}),
	("StructureTypeRenderPassMultiviewCreateInfo",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO}),
	("StructureTypePhysicalDeviceMultiviewFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES}),
	("StructureTypePhysicalDeviceMultiviewProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES}),
	("StructureTypePhysicalDeviceVariablePointersFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES}),
	("StructureTypeProtectedSubmitInfo",
		#{const VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO}),
	("StructureTypePhysicalDeviceProtectedMemoryFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES}),
	("StructureTypePhysicalDeviceProtectedMemoryProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES}),
	("StructureTypeDeviceQueueInfo2",
		#{const VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2}),
	("StructureTypeSamplerYcbcrConversionCreateInfo",
		#{const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO}),
	("StructureTypeSamplerYcbcrConversionInfo",
		#{const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO}),
	("StructureTypeBindImagePlaneMemoryInfo",
		#{const VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO}),
	("StructureTypeImagePlaneMemoryRequirementsInfo",
		#{const VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO}),
	("StructureTypePhysicalDeviceSamplerYcbcrConversionFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES}),
	("StructureTypeSamplerYcbcrConversionImageFormatProperties",
		#{const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES}),
	("StructureTypeDescriptorUpdateTemplateCreateInfo",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO}),
	("StructureTypePhysicalDeviceExternalImageFormatInfo",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO}),
	("StructureTypeExternalImageFormatProperties",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES}),
	("StructureTypePhysicalDeviceExternalBufferInfo",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO}),
	("StructureTypeExternalBufferProperties",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES}),
	("StructureTypePhysicalDeviceIdProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES}),
	("StructureTypeExternalMemoryBufferCreateInfo",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO}),
	("StructureTypeExternalMemoryImageCreateInfo",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO}),
	("StructureTypeExportMemoryAllocateInfo",
		#{const VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO}),
	("StructureTypePhysicalDeviceExternalFenceInfo",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO}),
	("StructureTypeExternalFenceProperties",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES}),
	("StructureTypeExportFenceCreateInfo",
		#{const VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO}),
	("StructureTypeExportSemaphoreCreateInfo",
		#{const VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO}),
	("StructureTypePhysicalDeviceExternalSemaphoreInfo",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO}),
	("StructureTypeExternalSemaphoreProperties",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES}),
	("StructureTypePhysicalDeviceMaintenance3Properties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES}),
	("StructureTypeDescriptorSetLayoutSupport",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT}),
	("StructureTypePhysicalDeviceShaderDrawParametersFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES}),
	("StructureTypePhysicalDeviceVulkan11Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES}),
	("StructureTypePhysicalDeviceVulkan11Properties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES}),
	("StructureTypePhysicalDeviceVulkan12Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES}),
	("StructureTypePhysicalDeviceVulkan12Properties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES}),
	("StructureTypeImageFormatListCreateInfo",
		#{const VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO}),
	("StructureTypeAttachmentDescription2",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2}),
	("StructureTypeAttachmentReference2",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2}),
	("StructureTypeSubpassDescription2",
		#{const VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2}),
	("StructureTypeSubpassDependency2",
		#{const VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2}),
	("StructureTypeRenderPassCreateInfo2",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2}),
	("StructureTypeSubpassBeginInfo",
		#{const VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO}),
	("StructureTypeSubpassEndInfo",
		#{const VK_STRUCTURE_TYPE_SUBPASS_END_INFO}),
	("StructureTypePhysicalDevice8bitStorageFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES}),
	("StructureTypePhysicalDeviceDriverProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES}),
	("StructureTypePhysicalDeviceShaderAtomicInt64Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES}),
	("StructureTypePhysicalDeviceShaderFloat16Int8Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES}),
	("StructureTypePhysicalDeviceFloatControlsProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES}),
	("StructureTypeDescriptorSetLayoutBindingFlagsCreateInfo",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO}),
	("StructureTypePhysicalDeviceDescriptorIndexingFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES}),
	("StructureTypePhysicalDeviceDescriptorIndexingProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES}),
	("StructureTypeDescriptorSetVariableDescriptorCountAllocateInfo",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO}),
	("StructureTypeDescriptorSetVariableDescriptorCountLayoutSupport",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT}),
	("StructureTypePhysicalDeviceDepthStencilResolveProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES}),
	("StructureTypeSubpassDescriptionDepthStencilResolve",
		#{const VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE}),
	("StructureTypePhysicalDeviceScalarBlockLayoutFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES}),
	("StructureTypeImageStencilUsageCreateInfo",
		#{const VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO}),
	("StructureTypePhysicalDeviceSamplerFilterMinmaxProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES}),
	("StructureTypeSamplerReductionModeCreateInfo",
		#{const VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO}),
	("StructureTypePhysicalDeviceVulkanMemoryModelFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES}),
	("StructureTypePhysicalDeviceImagelessFramebufferFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES}),
	("StructureTypeFramebufferAttachmentsCreateInfo",
		#{const VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO}),
	("StructureTypeFramebufferAttachmentImageInfo",
		#{const VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO}),
	("StructureTypeRenderPassAttachmentBeginInfo",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO}),
	("StructureTypePhysicalDeviceUniformBufferStandardLayoutFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES}),
	("StructureTypePhysicalDeviceShaderSubgroupExtendedTypesFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES}),
	("StructureTypePhysicalDeviceSeparateDepthStencilLayoutsFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES}),
	("StructureTypeAttachmentReferenceStencilLayout",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT}),
	("StructureTypeAttachmentDescriptionStencilLayout",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT}),
	("StructureTypePhysicalDeviceHostQueryResetFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES}),
	("StructureTypePhysicalDeviceTimelineSemaphoreFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES}),
	("StructureTypePhysicalDeviceTimelineSemaphoreProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES}),
	("StructureTypeSemaphoreTypeCreateInfo",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO}),
	("StructureTypeTimelineSemaphoreSubmitInfo",
		#{const VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO}),
	("StructureTypeSemaphoreWaitInfo",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO}),
	("StructureTypeSemaphoreSignalInfo",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO}),
	("StructureTypePhysicalDeviceBufferDeviceAddressFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES}),
	("StructureTypeBufferDeviceAddressInfo",
		#{const VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO}),
	("StructureTypeBufferOpaqueCaptureAddressCreateInfo",
		#{const VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO}),
	("StructureTypeMemoryOpaqueCaptureAddressAllocateInfo",
		#{const VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO}),
	("StructureTypeDeviceMemoryOpaqueCaptureAddressInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO}),
	("StructureTypePhysicalDeviceVulkan13Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES}),
	("StructureTypePhysicalDeviceVulkan13Properties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES}),
	("StructureTypePipelineCreationFeedbackCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO}),
	("StructureTypePhysicalDeviceShaderTerminateInvocationFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES}),
	("StructureTypePhysicalDeviceToolProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES}),
	("StructureTypePhysicalDeviceShaderDemoteToHelperInvocationFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES}),
	("StructureTypePhysicalDevicePrivateDataFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES}),
	("StructureTypeDevicePrivateDataCreateInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO}),
	("StructureTypePrivateDataSlotCreateInfo",
		#{const VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO}),
	("StructureTypePhysicalDevicePipelineCreationCacheControlFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES}),
	("StructureTypeMemoryBarrier2",
		#{const VK_STRUCTURE_TYPE_MEMORY_BARRIER_2}),
	("StructureTypeBufferMemoryBarrier2",
		#{const VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2}),
	("StructureTypeImageMemoryBarrier2",
		#{const VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2}),
	("StructureTypeDependencyInfo",
		#{const VK_STRUCTURE_TYPE_DEPENDENCY_INFO}),
	("StructureTypeSubmitInfo2", #{const VK_STRUCTURE_TYPE_SUBMIT_INFO_2}),
	("StructureTypeSemaphoreSubmitInfo",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO}),
	("StructureTypeCommandBufferSubmitInfo",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO}),
	("StructureTypePhysicalDeviceSynchronization2Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES}),
	("StructureTypePhysicalDeviceZeroInitializeWorkgroupMemoryFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES}),
	("StructureTypePhysicalDeviceImageRobustnessFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES}),
	("StructureTypeCopyBufferInfo2",
		#{const VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2}),
	("StructureTypeCopyImageInfo2",
		#{const VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2}),
	("StructureTypeCopyBufferToImageInfo2",
		#{const VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2}),
	("StructureTypeCopyImageToBufferInfo2",
		#{const VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2}),
	("StructureTypeBlitImageInfo2",
		#{const VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2}),
	("StructureTypeResolveImageInfo2",
		#{const VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2}),
	("StructureTypeBufferCopy2", #{const VK_STRUCTURE_TYPE_BUFFER_COPY_2}),
	("StructureTypeImageCopy2", #{const VK_STRUCTURE_TYPE_IMAGE_COPY_2}),
	("StructureTypeImageBlit2", #{const VK_STRUCTURE_TYPE_IMAGE_BLIT_2}),
	("StructureTypeBufferImageCopy2",
		#{const VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2}),
	("StructureTypeImageResolve2",
		#{const VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2}),
	("StructureTypePhysicalDeviceSubgroupSizeControlProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES}),
	("StructureTypePipelineShaderStageRequiredSubgroupSizeCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO}),
	("StructureTypePhysicalDeviceSubgroupSizeControlFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES}),
	("StructureTypePhysicalDeviceInlineUniformBlockFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES}),
	("StructureTypePhysicalDeviceInlineUniformBlockProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES}),
	("StructureTypeWriteDescriptorSetInlineUniformBlock",
		#{const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK}),
	("StructureTypeDescriptorPoolInlineUniformBlockCreateInfo",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO}),
	("StructureTypePhysicalDeviceTextureCompressionAstcHdrFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES}),
	("StructureTypeRenderingInfo",
		#{const VK_STRUCTURE_TYPE_RENDERING_INFO}),
	("StructureTypeRenderingAttachmentInfo",
		#{const VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO}),
	("StructureTypePipelineRenderingCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO}),
	("StructureTypePhysicalDeviceDynamicRenderingFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES}),
	("StructureTypeCommandBufferInheritanceRenderingInfo",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO}),
	("StructureTypePhysicalDeviceShaderIntegerDotProductFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES}),
	("StructureTypePhysicalDeviceShaderIntegerDotProductProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES}),
	("StructureTypePhysicalDeviceTexelBufferAlignmentProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES}),
	("StructureTypeFormatProperties3",
		#{const VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3}),
	("StructureTypePhysicalDeviceMaintenance4Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES}),
	("StructureTypePhysicalDeviceMaintenance4Properties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES}),
	("StructureTypeDeviceBufferMemoryRequirements",
		#{const VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS}),
	("StructureTypeDeviceImageMemoryRequirements",
		#{const VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS}),
	("StructureTypePhysicalDeviceVulkan14Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES}),
	("StructureTypePhysicalDeviceVulkan14Properties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES}),
	("StructureTypeDeviceQueueGlobalPriorityCreateInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO}),
	("StructureTypePhysicalDeviceGlobalPriorityQueryFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES}),
	("StructureTypeQueueFamilyGlobalPriorityProperties",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES}),
	("StructureTypePhysicalDeviceShaderSubgroupRotateFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES}),
	("StructureTypePhysicalDeviceShaderFloatControls2Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES}),
	("StructureTypePhysicalDeviceShaderExpectAssumeFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES}),
	("StructureTypePhysicalDeviceLineRasterizationFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES}),
	("StructureTypePipelineRasterizationLineStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO}),
	("StructureTypePhysicalDeviceLineRasterizationProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES}),
	("StructureTypePhysicalDeviceVertexAttributeDivisorProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES}),
	("StructureTypePipelineVertexInputDivisorStateCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO}),
	("StructureTypePhysicalDeviceVertexAttributeDivisorFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES}),
	("StructureTypePhysicalDeviceIndexTypeUint8Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES}),
	("StructureTypeMemoryMapInfo",
		#{const VK_STRUCTURE_TYPE_MEMORY_MAP_INFO}),
	("StructureTypeMemoryUnmapInfo",
		#{const VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO}),
	("StructureTypePhysicalDeviceMaintenance5Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES}),
	("StructureTypePhysicalDeviceMaintenance5Properties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES}),
	("StructureTypeRenderingAreaInfo",
		#{const VK_STRUCTURE_TYPE_RENDERING_AREA_INFO}),
	("StructureTypeDeviceImageSubresourceInfo",
		#{const VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO}),
	("StructureTypeSubresourceLayout2",
		#{const VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2}),
	("StructureTypeImageSubresource2",
		#{const VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2}),
	("StructureTypePipelineCreateFlags2CreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO}),
	("StructureTypeBufferUsageFlags2CreateInfo",
		#{const VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO}),
	("StructureTypePhysicalDevicePushDescriptorProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES}),
	("StructureTypePhysicalDeviceDynamicRenderingLocalReadFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES}),
	("StructureTypeRenderingAttachmentLocationInfo",
		#{const VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO}),
	("StructureTypeRenderingInputAttachmentIndexInfo",
		#{const VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO}),
	("StructureTypePhysicalDeviceMaintenance6Features",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES}),
	("StructureTypePhysicalDeviceMaintenance6Properties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES}),
	("StructureTypeBindMemoryStatus",
		#{const VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS}),
	("StructureTypeBindDescriptorSetsInfo",
		#{const VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO}),
	("StructureTypePushConstantsInfo",
		#{const VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO}),
	("StructureTypePushDescriptorSetInfo",
		#{const VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO}),
	("StructureTypePushDescriptorSetWithTemplateInfo",
		#{const VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_WITH_TEMPLATE_INFO}),
	("StructureTypePhysicalDevicePipelineProtectedAccessFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES}),
	("StructureTypePipelineRobustnessCreateInfo",
		#{const VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO}),
	("StructureTypePhysicalDevicePipelineRobustnessFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES}),
	("StructureTypePhysicalDevicePipelineRobustnessProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES}),
	("StructureTypePhysicalDeviceHostImageCopyFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES}),
	("StructureTypePhysicalDeviceHostImageCopyProperties",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES}),
	("StructureTypeMemoryToImageCopy",
		#{const VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY}),
	("StructureTypeImageToMemoryCopy",
		#{const VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY}),
	("StructureTypeCopyImageToMemoryInfo",
		#{const VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO}),
	("StructureTypeCopyMemoryToImageInfo",
		#{const VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO}),
	("StructureTypeHostImageLayoutTransitionInfo",
		#{const VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO}),
	("StructureTypeCopyImageToImageInfo",
		#{const VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO}),
	("StructureTypeSubresourceHostMemcpySize",
		#{const VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE}),
	("StructureTypeHostImageCopyDevicePerformanceQuery",
		#{const VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY}),
	("StructureTypeSwapchainCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR}),
	("StructureTypePresentInfoKhr",
		#{const VK_STRUCTURE_TYPE_PRESENT_INFO_KHR}),
	("StructureTypeDeviceGroupPresentCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR}),
	("StructureTypeImageSwapchainCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR}),
	("StructureTypeBindImageMemorySwapchainInfoKhr",
		#{const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR}),
	("StructureTypeAcquireNextImageInfoKhr",
		#{const VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR}),
	("StructureTypeDeviceGroupPresentInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR}),
	("StructureTypeDeviceGroupSwapchainCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR}),
	("StructureTypeDisplayModeCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR}),
	("StructureTypeDisplaySurfaceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR}),
	("StructureTypeDisplayPresentInfoKhr",
		#{const VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR}),
	("StructureTypeXlibSurfaceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR}),
	("StructureTypeXcbSurfaceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR}),
	("StructureTypeWaylandSurfaceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR}),
	("StructureTypeAndroidSurfaceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR}),
	("StructureTypeWin32SurfaceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR}),
	("StructureTypeDebugReportCallbackCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT}),
	("StructureTypePipelineRasterizationStateRasterizationOrderAmd",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD}),
	("StructureTypeDebugMarkerObjectNameInfoExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT}),
	("StructureTypeDebugMarkerObjectTagInfoExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT}),
	("StructureTypeDebugMarkerMarkerInfoExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT}),
	("StructureTypeVideoProfileInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR}),
	("StructureTypeVideoCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR}),
	("StructureTypeVideoPictureResourceInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR}),
	("StructureTypeVideoSessionMemoryRequirementsKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR}),
	("StructureTypeBindVideoSessionMemoryInfoKhr",
		#{const VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR}),
	("StructureTypeVideoSessionCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR}),
	("StructureTypeVideoSessionParametersCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR}),
	("StructureTypeVideoSessionParametersUpdateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR}),
	("StructureTypeVideoBeginCodingInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR}),
	("StructureTypeVideoEndCodingInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR}),
	("StructureTypeVideoCodingControlInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR}),
	("StructureTypeVideoReferenceSlotInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR}),
	("StructureTypeQueueFamilyVideoPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR}),
	("StructureTypeVideoProfileListInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR}),
	("StructureTypePhysicalDeviceVideoFormatInfoKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR}),
	("StructureTypeVideoFormatPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR}),
	("StructureTypeQueueFamilyQueryResultStatusPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR}),
	("StructureTypeVideoDecodeInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR}),
	("StructureTypeVideoDecodeCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR}),
	("StructureTypeVideoDecodeUsageInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR}),
	("StructureTypeDedicatedAllocationImageCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV}),
	("StructureTypeDedicatedAllocationBufferCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV}),
	("StructureTypeDedicatedAllocationMemoryAllocateInfoNv",
		#{const VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV}),
	("StructureTypePhysicalDeviceTransformFeedbackFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT}),
	("StructureTypePhysicalDeviceTransformFeedbackPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT}),
	("StructureTypePipelineRasterizationStateStreamCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT}),
	("StructureTypeCuModuleCreateInfoNvx",
		#{const VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX}),
	("StructureTypeCuFunctionCreateInfoNvx",
		#{const VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX}),
	("StructureTypeCuLaunchInfoNvx",
		#{const VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX}),
	("StructureTypeCuModuleTexturingModeCreateInfoNvx",
		#{const VK_STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX}),
	("StructureTypeImageViewHandleInfoNvx",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX}),
	("StructureTypeImageViewAddressPropertiesNvx",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX}),
	("StructureTypeVideoEncodeH264CapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR}),
	("StructureTypeVideoEncodeH264SessionParametersCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR}),
	("StructureTypeVideoEncodeH264SessionParametersAddInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR}),
	("StructureTypeVideoEncodeH264PictureInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR}),
	("StructureTypeVideoEncodeH264DpbSlotInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR}),
	("StructureTypeVideoEncodeH264NaluSliceInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR}),
	("StructureTypeVideoEncodeH264GopRemainingFrameInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR}),
	("StructureTypeVideoEncodeH264ProfileInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR}),
	("StructureTypeVideoEncodeH264RateControlInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR}),
	("StructureTypeVideoEncodeH264RateControlLayerInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR}),
	("StructureTypeVideoEncodeH264SessionCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR}),
	("StructureTypeVideoEncodeH264QualityLevelPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR}),
	("StructureTypeVideoEncodeH264SessionParametersGetInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR}),
	("StructureTypeVideoEncodeH264SessionParametersFeedbackInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR}),
	("StructureTypeVideoEncodeH265CapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR}),
	("StructureTypeVideoEncodeH265SessionParametersCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR}),
	("StructureTypeVideoEncodeH265SessionParametersAddInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR}),
	("StructureTypeVideoEncodeH265PictureInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR}),
	("StructureTypeVideoEncodeH265DpbSlotInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR}),
	("StructureTypeVideoEncodeH265NaluSliceSegmentInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR}),
	("StructureTypeVideoEncodeH265GopRemainingFrameInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR}),
	("StructureTypeVideoEncodeH265ProfileInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR}),
	("StructureTypeVideoEncodeH265RateControlInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR}),
	("StructureTypeVideoEncodeH265RateControlLayerInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR}),
	("StructureTypeVideoEncodeH265SessionCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR}),
	("StructureTypeVideoEncodeH265QualityLevelPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR}),
	("StructureTypeVideoEncodeH265SessionParametersGetInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR}),
	("StructureTypeVideoEncodeH265SessionParametersFeedbackInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR}),
	("StructureTypeVideoDecodeH264CapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR}),
	("StructureTypeVideoDecodeH264PictureInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR}),
	("StructureTypeVideoDecodeH264ProfileInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR}),
	("StructureTypeVideoDecodeH264SessionParametersCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR}),
	("StructureTypeVideoDecodeH264SessionParametersAddInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR}),
	("StructureTypeVideoDecodeH264DpbSlotInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR}),
	("StructureTypeTextureLodGatherFormatPropertiesAmd",
		#{const VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD}),
	("StructureTypeStreamDescriptorSurfaceCreateInfoGgp",
		#{const VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP}),
	("StructureTypePhysicalDeviceCornerSampledImageFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV}),
	("StructureTypeExternalMemoryImageCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV}),
	("StructureTypeExportMemoryAllocateInfoNv",
		#{const VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV}),
	("StructureTypeImportMemoryWin32HandleInfoNv",
		#{const VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV}),
	("StructureTypeExportMemoryWin32HandleInfoNv",
		#{const VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV}),
	("StructureTypeWin32KeyedMutexAcquireReleaseInfoNv",
		#{const VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV}),
	("StructureTypeValidationFlagsExt",
		#{const VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT}),
	("StructureTypeViSurfaceCreateInfoNn",
		#{const VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN}),
	("StructureTypeImageViewAstcDecodeModeExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT}),
	("StructureTypePhysicalDeviceAstcDecodeFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT}),
	("StructureTypeImportMemoryWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeExportMemoryWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeMemoryWin32HandlePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR}),
	("StructureTypeMemoryGetWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeImportMemoryFdInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR}),
	("StructureTypeMemoryFdPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR}),
	("StructureTypeMemoryGetFdInfoKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR}),
	("StructureTypeWin32KeyedMutexAcquireReleaseInfoKhr",
		#{const VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR}),
	("StructureTypeImportSemaphoreWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeExportSemaphoreWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeD3d12FenceSubmitInfoKhr",
		#{const VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR}),
	("StructureTypeSemaphoreGetWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeImportSemaphoreFdInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR}),
	("StructureTypeSemaphoreGetFdInfoKhr",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR}),
	("StructureTypeCommandBufferInheritanceConditionalRenderingInfoExt",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT}),
	("StructureTypePhysicalDeviceConditionalRenderingFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT}),
	("StructureTypeConditionalRenderingBeginInfoExt",
		#{const VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT}),
	("StructureTypePresentRegionsKhr",
		#{const VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR}),
	("StructureTypePipelineViewportWScalingStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV}),
	("StructureTypeSurfaceCapabilities2Ext",
		#{const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT}),
	("StructureTypeDisplayPowerInfoExt",
		#{const VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT}),
	("StructureTypeDeviceEventInfoExt",
		#{const VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT}),
	("StructureTypeDisplayEventInfoExt",
		#{const VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT}),
	("StructureTypeSwapchainCounterCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT}),
	("StructureTypePresentTimesInfoGoogle",
		#{const VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE}),
	("StructureTypePhysicalDeviceMultiviewPerViewAttributesPropertiesNvx",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX}),
	("StructureTypeMultiviewPerViewAttributesInfoNvx",
		#{const VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX}),
	("StructureTypePipelineViewportSwizzleStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV}),
	("StructureTypePhysicalDeviceDiscardRectanglePropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT}),
	("StructureTypePipelineDiscardRectangleStateCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceConservativeRasterizationPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT}),
	("StructureTypePipelineRasterizationConservativeStateCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceDepthClipEnableFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT}),
	("StructureTypePipelineRasterizationDepthClipStateCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT}),
	("StructureTypeHdrMetadataExt",
		#{const VK_STRUCTURE_TYPE_HDR_METADATA_EXT}),
	("StructureTypePhysicalDeviceRelaxedLineRasterizationFeaturesImg",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG}),
	("StructureTypeSharedPresentSurfaceCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR}),
	("StructureTypeImportFenceWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeExportFenceWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeFenceGetWin32HandleInfoKhr",
		#{const VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR}),
	("StructureTypeImportFenceFdInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR}),
	("StructureTypeFenceGetFdInfoKhr",
		#{const VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR}),
	("StructureTypePhysicalDevicePerformanceQueryFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR}),
	("StructureTypePhysicalDevicePerformanceQueryPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR}),
	("StructureTypeQueryPoolPerformanceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR}),
	("StructureTypePerformanceQuerySubmitInfoKhr",
		#{const VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR}),
	("StructureTypeAcquireProfilingLockInfoKhr",
		#{const VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR}),
	("StructureTypePerformanceCounterKhr",
		#{const VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR}),
	("StructureTypePerformanceCounterDescriptionKhr",
		#{const VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR}),
	("StructureTypePhysicalDeviceSurfaceInfo2Khr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR}),
	("StructureTypeSurfaceCapabilities2Khr",
		#{const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR}),
	("StructureTypeSurfaceFormat2Khr",
		#{const VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR}),
	("StructureTypeDisplayProperties2Khr",
		#{const VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR}),
	("StructureTypeDisplayPlaneProperties2Khr",
		#{const VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR}),
	("StructureTypeDisplayModeProperties2Khr",
		#{const VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR}),
	("StructureTypeDisplayPlaneInfo2Khr",
		#{const VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR}),
	("StructureTypeDisplayPlaneCapabilities2Khr",
		#{const VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR}),
	("StructureTypeIosSurfaceCreateInfoMvk",
		#{const VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK}),
	("StructureTypeMacosSurfaceCreateInfoMvk",
		#{const VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK}),
	("StructureTypeDebugUtilsObjectNameInfoExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT}),
	("StructureTypeDebugUtilsObjectTagInfoExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT}),
	("StructureTypeDebugUtilsLabelExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT}),
	("StructureTypeDebugUtilsMessengerCallbackDataExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT}),
	("StructureTypeDebugUtilsMessengerCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT}),
	("StructureTypeAndroidHardwareBufferUsageAndroid",
		#{const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID}),
	("StructureTypeAndroidHardwareBufferPropertiesAndroid",
		#{const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID}),
	("StructureTypeAndroidHardwareBufferFormatPropertiesAndroid",
		#{const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID}),
	("StructureTypeImportAndroidHardwareBufferInfoAndroid",
		#{const VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID}),
	("StructureTypeMemoryGetAndroidHardwareBufferInfoAndroid",
		#{const VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID}),
	("StructureTypeExternalFormatAndroid",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID}),
	("StructureTypeAndroidHardwareBufferFormatProperties2Android",
		#{const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID}),
	("StructureTypeAttachmentSampleCountInfoAmd",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD}),
	("StructureTypePhysicalDeviceShaderBfloat16FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_BFLOAT16_FEATURES_KHR}),
	("StructureTypeSampleLocationsInfoExt",
		#{const VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT}),
	("StructureTypeRenderPassSampleLocationsBeginInfoExt",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT}),
	("StructureTypePipelineSampleLocationsStateCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceSampleLocationsPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT}),
	("StructureTypeMultisamplePropertiesExt",
		#{const VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceBlendOperationAdvancedFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT}),
	("StructureTypePhysicalDeviceBlendOperationAdvancedPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT}),
	("StructureTypePipelineColorBlendAdvancedStateCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT}),
	("StructureTypePipelineCoverageToColorStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV}),
	("StructureTypeWriteDescriptorSetAccelerationStructureKhr",
		#{const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR}),
	("StructureTypeAccelerationStructureBuildGeometryInfoKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR}),
	("StructureTypeAccelerationStructureDeviceAddressInfoKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR}),
	("StructureTypeAccelerationStructureGeometryAabbsDataKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR}),
	("StructureTypeAccelerationStructureGeometryInstancesDataKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR}),
	("StructureTypeAccelerationStructureGeometryTrianglesDataKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR}),
	("StructureTypeAccelerationStructureGeometryKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR}),
	("StructureTypeAccelerationStructureVersionInfoKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR}),
	("StructureTypeCopyAccelerationStructureInfoKhr",
		#{const VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR}),
	("StructureTypeCopyAccelerationStructureToMemoryInfoKhr",
		#{const VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR}),
	("StructureTypeCopyMemoryToAccelerationStructureInfoKhr",
		#{const VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR}),
	("StructureTypePhysicalDeviceAccelerationStructureFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR}),
	("StructureTypePhysicalDeviceAccelerationStructurePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR}),
	("StructureTypeAccelerationStructureCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR}),
	("StructureTypeAccelerationStructureBuildSizesInfoKhr",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR}),
	("StructureTypePhysicalDeviceRayTracingPipelineFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR}),
	("StructureTypePhysicalDeviceRayTracingPipelinePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR}),
	("StructureTypeRayTracingPipelineCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR}),
	("StructureTypeRayTracingShaderGroupCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR}),
	("StructureTypeRayTracingPipelineInterfaceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceRayQueryFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR}),
	("StructureTypePipelineCoverageModulationStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV}),
	("StructureTypePhysicalDeviceShaderSmBuiltinsFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV}),
	("StructureTypePhysicalDeviceShaderSmBuiltinsPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV}),
	("StructureTypeDrmFormatModifierPropertiesListExt",
		#{const VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT}),
	("StructureTypePhysicalDeviceImageDrmFormatModifierInfoExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT}),
	("StructureTypeImageDrmFormatModifierListCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT}),
	("StructureTypeImageDrmFormatModifierExplicitCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT}),
	("StructureTypeImageDrmFormatModifierPropertiesExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT}),
	("StructureTypeDrmFormatModifierPropertiesList2Ext",
		#{const VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT}),
	("StructureTypeValidationCacheCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT}),
	("StructureTypeShaderModuleValidationCacheCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT}),
	("StructureTypePipelineViewportShadingRateImageStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV}),
	("StructureTypePhysicalDeviceShadingRateImageFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV}),
	("StructureTypePhysicalDeviceShadingRateImagePropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV}),
	("StructureTypePipelineViewportCoarseSampleOrderStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV}),
	("StructureTypeRayTracingPipelineCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV}),
	("StructureTypeAccelerationStructureCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV}),
	("StructureTypeGeometryNv", #{const VK_STRUCTURE_TYPE_GEOMETRY_NV}),
	("StructureTypeGeometryTrianglesNv",
		#{const VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV}),
	("StructureTypeGeometryAabbNv",
		#{const VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV}),
	("StructureTypeBindAccelerationStructureMemoryInfoNv",
		#{const VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV}),
	("StructureTypeWriteDescriptorSetAccelerationStructureNv",
		#{const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV}),
	("StructureTypeAccelerationStructureMemoryRequirementsInfoNv",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV}),
	("StructureTypePhysicalDeviceRayTracingPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV}),
	("StructureTypeRayTracingShaderGroupCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV}),
	("StructureTypeAccelerationStructureInfoNv",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV}),
	("StructureTypePhysicalDeviceRepresentativeFragmentTestFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV}),
	("StructureTypePipelineRepresentativeFragmentTestStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV}),
	("StructureTypePhysicalDeviceImageViewImageFormatInfoExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT}),
	("StructureTypeFilterCubicImageViewImageFormatPropertiesExt",
		#{const VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT}),
	("StructureTypeImportMemoryHostPointerInfoExt",
		#{const VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT}),
	("StructureTypeMemoryHostPointerPropertiesExt",
		#{const VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceExternalMemoryHostPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceShaderClockFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR}),
	("StructureTypePipelineCompilerControlCreateInfoAmd",
		#{const VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD}),
	("StructureTypePhysicalDeviceShaderCorePropertiesAmd",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD}),
	("StructureTypeVideoDecodeH265CapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR}),
	("StructureTypeVideoDecodeH265SessionParametersCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR}),
	("StructureTypeVideoDecodeH265SessionParametersAddInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR}),
	("StructureTypeVideoDecodeH265ProfileInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR}),
	("StructureTypeVideoDecodeH265PictureInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR}),
	("StructureTypeVideoDecodeH265DpbSlotInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR}),
	("StructureTypeDeviceMemoryOverallocationCreateInfoAmd",
		#{const VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD}),
	("StructureTypePhysicalDeviceVertexAttributeDivisorPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT}),
	("StructureTypePresentFrameTokenGgp",
		#{const VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP}),
	("StructureTypePhysicalDeviceMeshShaderFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV}),
	("StructureTypePhysicalDeviceMeshShaderPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceShaderImageFootprintFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV}),
	("StructureTypePipelineViewportExclusiveScissorStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV}),
	("StructureTypePhysicalDeviceExclusiveScissorFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV}),
	("StructureTypeCheckpointDataNv",
		#{const VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV}),
	("StructureTypeQueueFamilyCheckpointPropertiesNv",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV}),
	("StructureTypeQueueFamilyCheckpointProperties2Nv",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV}),
	("StructureTypeCheckpointData2Nv",
		#{const VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV}),
	("StructureTypePhysicalDeviceShaderIntegerFunctions2FeaturesIntel",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL}),
	("StructureTypeQueryPoolPerformanceQueryCreateInfoIntel",
		#{const VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL}),
	("StructureTypeInitializePerformanceApiInfoIntel",
		#{const VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL}),
	("StructureTypePerformanceMarkerInfoIntel",
		#{const VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL}),
	("StructureTypePerformanceStreamMarkerInfoIntel",
		#{const VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL}),
	("StructureTypePerformanceOverrideInfoIntel",
		#{const VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL}),
	("StructureTypePerformanceConfigurationAcquireInfoIntel",
		#{const VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL}),
	("StructureTypePhysicalDevicePciBusInfoPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT}),
	("StructureTypeDisplayNativeHdrSurfaceCapabilitiesAmd",
		#{const VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD}),
	("StructureTypeSwapchainDisplayNativeHdrCreateInfoAmd",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD}),
	("StructureTypeImagepipeSurfaceCreateInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA}),
	("StructureTypeMetalSurfaceCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceFragmentDensityMapFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT}),
	("StructureTypePhysicalDeviceFragmentDensityMapPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT}),
	("StructureTypeRenderPassFragmentDensityMapCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT}),
	("StructureTypeRenderingFragmentDensityMapAttachmentInfoExt",
		#{const VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT}),
	("StructureTypeFragmentShadingRateAttachmentInfoKhr",
		#{const VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR}),
	("StructureTypePipelineFragmentShadingRateStateCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceFragmentShadingRatePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceFragmentShadingRateFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR}),
	("StructureTypePhysicalDeviceFragmentShadingRateKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR}),
	("StructureTypeRenderingFragmentShadingRateAttachmentInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR}),
	("StructureTypePhysicalDeviceShaderCoreProperties2Amd",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD}),
	("StructureTypePhysicalDeviceCoherentMemoryFeaturesAmd",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD}),
	("StructureTypePhysicalDeviceShaderImageAtomicInt64FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT}),
	("StructureTypePhysicalDeviceShaderQuadControlFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR}),
	("StructureTypePhysicalDeviceMemoryBudgetPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceMemoryPriorityFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT}),
	("StructureTypeMemoryPriorityAllocateInfoExt",
		#{const VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT}),
	("StructureTypeSurfaceProtectedCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR}),
	("StructureTypePhysicalDeviceDedicatedAllocationImageAliasingFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV}),
	("StructureTypePhysicalDeviceBufferDeviceAddressFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT}),
	("StructureTypeBufferDeviceAddressCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT}),
	("StructureTypeValidationFeaturesExt",
		#{const VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT}),
	("StructureTypePhysicalDevicePresentWaitFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR}),
	("StructureTypePhysicalDeviceCooperativeMatrixFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV}),
	("StructureTypeCooperativeMatrixPropertiesNv",
		#{const VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceCooperativeMatrixPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceCoverageReductionModeFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV}),
	("StructureTypePipelineCoverageReductionStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV}),
	("StructureTypeFramebufferMixedSamplesCombinationNv",
		#{const VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV}),
	("StructureTypePhysicalDeviceFragmentShaderInterlockFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT}),
	("StructureTypePhysicalDeviceYcbcrImageArraysFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT}),
	("StructureTypePhysicalDeviceProvokingVertexFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT}),
	("StructureTypePipelineRasterizationProvokingVertexStateCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceProvokingVertexPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT}),
	("StructureTypeSurfaceFullScreenExclusiveInfoExt",
		#{const VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT}),
	("StructureTypeSurfaceCapabilitiesFullScreenExclusiveExt",
		#{const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT}),
	("StructureTypeSurfaceFullScreenExclusiveWin32InfoExt",
		#{const VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT}),
	("StructureTypeHeadlessSurfaceCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceShaderAtomicFloatFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT}),
	("StructureTypePhysicalDeviceExtendedDynamicStateFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT}),
	("StructureTypePhysicalDevicePipelineExecutablePropertiesFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR}),
	("StructureTypePipelineInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR}),
	("StructureTypePipelineExecutablePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR}),
	("StructureTypePipelineExecutableInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR}),
	("StructureTypePipelineExecutableStatisticKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR}),
	("StructureTypePipelineExecutableInternalRepresentationKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR}),
	("StructureTypePhysicalDeviceMapMemoryPlacedFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT}),
	("StructureTypePhysicalDeviceMapMemoryPlacedPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_PROPERTIES_EXT}),
	("StructureTypeMemoryMapPlacedInfoExt",
		#{const VK_STRUCTURE_TYPE_MEMORY_MAP_PLACED_INFO_EXT}),
	("StructureTypePhysicalDeviceShaderAtomicFloat2FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT}),
	("StructureTypePhysicalDeviceDeviceGeneratedCommandsPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV}),
	("StructureTypeGraphicsShaderGroupCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV}),
	("StructureTypeGraphicsPipelineShaderGroupsCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV}),
	("StructureTypeIndirectCommandsLayoutTokenNv",
		#{const VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV}),
	("StructureTypeIndirectCommandsLayoutCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV}),
	("StructureTypeGeneratedCommandsInfoNv",
		#{const VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV}),
	("StructureTypeGeneratedCommandsMemoryRequirementsInfoNv",
		#{const VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV}),
	("StructureTypePhysicalDeviceDeviceGeneratedCommandsFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV}),
	("StructureTypePhysicalDeviceInheritedViewportScissorFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV}),
	("StructureTypeCommandBufferInheritanceViewportScissorInfoNv",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV}),
	("StructureTypePhysicalDeviceTexelBufferAlignmentFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT}),
	("StructureTypeCommandBufferInheritanceRenderPassTransformInfoQcom",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM}),
	("StructureTypeRenderPassTransformBeginInfoQcom",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM}),
	("StructureTypePhysicalDeviceDepthBiasControlFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT}),
	("StructureTypeDepthBiasInfoExt",
		#{const VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT}),
	("StructureTypeDepthBiasRepresentationInfoExt",
		#{const VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT}),
	("StructureTypePhysicalDeviceDeviceMemoryReportFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT}),
	("StructureTypeDeviceDeviceMemoryReportCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT}),
	("StructureTypeDeviceMemoryReportCallbackDataExt",
		#{const VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT}),
	("StructureTypeSamplerCustomBorderColorCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceCustomBorderColorPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceCustomBorderColorFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT}),
	("StructureTypePipelineLibraryCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR}),
	("StructureTypePhysicalDevicePresentBarrierFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV}),
	("StructureTypeSurfaceCapabilitiesPresentBarrierNv",
		#{const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV}),
	("StructureTypeSwapchainPresentBarrierCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV}),
	("StructureTypePresentIdKhr",
		#{const VK_STRUCTURE_TYPE_PRESENT_ID_KHR}),
	("StructureTypePhysicalDevicePresentIdFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR}),
	("StructureTypeVideoEncodeInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR}),
	("StructureTypeVideoEncodeRateControlInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR}),
	("StructureTypeVideoEncodeRateControlLayerInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR}),
	("StructureTypeVideoEncodeCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR}),
	("StructureTypeVideoEncodeUsageInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR}),
	("StructureTypeQueryPoolVideoEncodeFeedbackCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceVideoEncodeQualityLevelInfoKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR}),
	("StructureTypeVideoEncodeQualityLevelPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_PROPERTIES_KHR}),
	("StructureTypeVideoEncodeQualityLevelInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR}),
	("StructureTypeVideoEncodeSessionParametersGetInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_GET_INFO_KHR}),
	("StructureTypeVideoEncodeSessionParametersFeedbackInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_FEEDBACK_INFO_KHR}),
	("StructureTypePhysicalDeviceDiagnosticsConfigFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV}),
	("StructureTypeDeviceDiagnosticsConfigCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV}),
	("StructureTypePhysicalDeviceTileShadingFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_SHADING_FEATURES_QCOM}),
	("StructureTypePhysicalDeviceTileShadingPropertiesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_SHADING_PROPERTIES_QCOM}),
	("StructureTypeRenderPassTileShadingCreateInfoQcom",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_TILE_SHADING_CREATE_INFO_QCOM}),
	("StructureTypePerTileBeginInfoQcom",
		#{const VK_STRUCTURE_TYPE_PER_TILE_BEGIN_INFO_QCOM}),
	("StructureTypePerTileEndInfoQcom",
		#{const VK_STRUCTURE_TYPE_PER_TILE_END_INFO_QCOM}),
	("StructureTypeDispatchTileInfoQcom",
		#{const VK_STRUCTURE_TYPE_DISPATCH_TILE_INFO_QCOM}),
	("StructureTypeQueryLowLatencySupportNv",
		#{const VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV}),
	("StructureTypeExportMetalObjectCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT}),
	("StructureTypeExportMetalObjectsInfoExt",
		#{const VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT}),
	("StructureTypeExportMetalDeviceInfoExt",
		#{const VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT}),
	("StructureTypeExportMetalCommandQueueInfoExt",
		#{const VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT}),
	("StructureTypeExportMetalBufferInfoExt",
		#{const VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT}),
	("StructureTypeImportMetalBufferInfoExt",
		#{const VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT}),
	("StructureTypeExportMetalTextureInfoExt",
		#{const VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT}),
	("StructureTypeImportMetalTextureInfoExt",
		#{const VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT}),
	("StructureTypeExportMetalIoSurfaceInfoExt",
		#{const VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT}),
	("StructureTypeImportMetalIoSurfaceInfoExt",
		#{const VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT}),
	("StructureTypeExportMetalSharedEventInfoExt",
		#{const VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT}),
	("StructureTypeImportMetalSharedEventInfoExt",
		#{const VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT}),
	("StructureTypePhysicalDeviceDescriptorBufferPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceDescriptorBufferDensityMapPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceDescriptorBufferFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT}),
	("StructureTypeDescriptorAddressInfoExt",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT}),
	("StructureTypeDescriptorGetInfoExt",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT}),
	("StructureTypeBufferCaptureDescriptorDataInfoExt",
		#{const VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT}),
	("StructureTypeImageCaptureDescriptorDataInfoExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT}),
	("StructureTypeImageViewCaptureDescriptorDataInfoExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_EXT}),
	("StructureTypeSamplerCaptureDescriptorDataInfoExt",
		#{const VK_STRUCTURE_TYPE_SAMPLER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT}),
	("StructureTypeOpaqueCaptureDescriptorDataCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT}),
	("StructureTypeDescriptorBufferBindingInfoExt",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT}),
	("StructureTypeDescriptorBufferBindingPushDescriptorBufferHandleExt",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT}),
	("StructureTypeAccelerationStructureCaptureDescriptorDataInfoExt",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT}),
	("StructureTypePhysicalDeviceGraphicsPipelineLibraryFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT}),
	("StructureTypePhysicalDeviceGraphicsPipelineLibraryPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT}),
	("StructureTypeGraphicsPipelineLibraryCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAmd",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD}),
	("StructureTypePhysicalDeviceFragmentShaderBarycentricFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR}),
	("StructureTypePhysicalDeviceFragmentShaderBarycentricPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR}),
	("StructureTypePhysicalDeviceFragmentShadingRateEnumsPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceFragmentShadingRateEnumsFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV}),
	("StructureTypePipelineFragmentShadingRateEnumStateCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV}),
	("StructureTypeAccelerationStructureGeometryMotionTrianglesDataNv",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV}),
	("StructureTypePhysicalDeviceRayTracingMotionBlurFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV}),
	("StructureTypeAccelerationStructureMotionInfoNv",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV}),
	("StructureTypePhysicalDeviceMeshShaderFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT}),
	("StructureTypePhysicalDeviceMeshShaderPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceYcbcr2Plane444FormatsFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT}),
	("StructureTypePhysicalDeviceFragmentDensityMap2FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT}),
	("StructureTypePhysicalDeviceFragmentDensityMap2PropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT}),
	("StructureTypeCopyCommandTransformInfoQcom",
		#{const VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM}),
	("StructureTypePhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR}),
	("StructureTypePhysicalDeviceImageCompressionControlFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT}),
	("StructureTypeImageCompressionControlExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT}),
	("StructureTypeImageCompressionPropertiesExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT}),
	("StructureTypePhysicalDevice4444FormatsFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT}),
	("StructureTypePhysicalDeviceFaultFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT}),
	("StructureTypeDeviceFaultCountsExt",
		#{const VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT}),
	("StructureTypeDeviceFaultInfoExt",
		#{const VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT}),
	("StructureTypePhysicalDeviceRgba10x6FormatsFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT}),
	("StructureTypeDirectfbSurfaceCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceVertexInputDynamicStateFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT}),
	("StructureTypeVertexInputBindingDescription2Ext",
		#{const VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT}),
	("StructureTypeVertexInputAttributeDescription2Ext",
		#{const VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT}),
	("StructureTypePhysicalDeviceDrmPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceAddressBindingReportFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT}),
	("StructureTypeDeviceAddressBindingCallbackDataExt",
		#{const VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT}),
	("StructureTypePhysicalDeviceDepthClipControlFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT}),
	("StructureTypePipelineViewportDepthClipControlCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT}),
	("StructureTypePhysicalDevicePrimitiveTopologyListRestartFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT}),
	("StructureTypeImportMemoryZirconHandleInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA}),
	("StructureTypeMemoryZirconHandlePropertiesFuchsia",
		#{const VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA}),
	("StructureTypeMemoryGetZirconHandleInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA}),
	("StructureTypeImportSemaphoreZirconHandleInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA}),
	("StructureTypeSemaphoreGetZirconHandleInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA}),
	("StructureTypeBufferCollectionCreateInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA}),
	("StructureTypeImportMemoryBufferCollectionFuchsia",
		#{const VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA}),
	("StructureTypeBufferCollectionImageCreateInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA}),
	("StructureTypeBufferCollectionPropertiesFuchsia",
		#{const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA}),
	("StructureTypeBufferConstraintsInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA}),
	("StructureTypeBufferCollectionBufferCreateInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA}),
	("StructureTypeImageConstraintsInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA}),
	("StructureTypeImageFormatConstraintsInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA}),
	("StructureTypeSysmemColorSpaceFuchsia",
		#{const VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA}),
	("StructureTypeBufferCollectionConstraintsInfoFuchsia",
		#{const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA}),
	("StructureTypeSubpassShadingPipelineCreateInfoHuawei",
		#{const VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI}),
	("StructureTypePhysicalDeviceSubpassShadingFeaturesHuawei",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI}),
	("StructureTypePhysicalDeviceSubpassShadingPropertiesHuawei",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI}),
	("StructureTypePhysicalDeviceInvocationMaskFeaturesHuawei",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI}),
	("StructureTypeMemoryGetRemoteAddressInfoNv",
		#{const VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV}),
	("StructureTypePhysicalDeviceExternalMemoryRdmaFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV}),
	("StructureTypePipelinePropertiesIdentifierExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_PROPERTIES_IDENTIFIER_EXT}),
	("StructureTypePhysicalDevicePipelinePropertiesFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT}),
	("StructureTypePhysicalDeviceFrameBoundaryFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT}),
	("StructureTypeFrameBoundaryExt",
		#{const VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT}),
	("StructureTypePhysicalDeviceMultisampledRenderToSingleSampledFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT}),
	("StructureTypeSubpassResolvePerformanceQueryExt",
		#{const VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT}),
	("StructureTypeMultisampledRenderToSingleSampledInfoExt",
		#{const VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT}),
	("StructureTypePhysicalDeviceExtendedDynamicState2FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT}),
	("StructureTypeScreenSurfaceCreateInfoQnx",
		#{const VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX}),
	("StructureTypePhysicalDeviceColorWriteEnableFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT}),
	("StructureTypePipelineColorWriteCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDevicePrimitivesGeneratedQueryFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT}),
	("StructureTypePhysicalDeviceRayTracingMaintenance1FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR}),
	("StructureTypePhysicalDeviceImageViewMinLodFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT}),
	("StructureTypeImageViewMinLodCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceMultiDrawFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT}),
	("StructureTypePhysicalDeviceMultiDrawPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceImage2dViewOf3dFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT}),
	("StructureTypePhysicalDeviceShaderTileImageFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT}),
	("StructureTypePhysicalDeviceShaderTileImagePropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT}),
	("StructureTypeMicromapBuildInfoExt",
		#{const VK_STRUCTURE_TYPE_MICROMAP_BUILD_INFO_EXT}),
	("StructureTypeMicromapVersionInfoExt",
		#{const VK_STRUCTURE_TYPE_MICROMAP_VERSION_INFO_EXT}),
	("StructureTypeCopyMicromapInfoExt",
		#{const VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT}),
	("StructureTypeCopyMicromapToMemoryInfoExt",
		#{const VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT}),
	("StructureTypeCopyMemoryToMicromapInfoExt",
		#{const VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT}),
	("StructureTypePhysicalDeviceOpacityMicromapFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT}),
	("StructureTypePhysicalDeviceOpacityMicromapPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT}),
	("StructureTypeMicromapCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_MICROMAP_CREATE_INFO_EXT}),
	("StructureTypeMicromapBuildSizesInfoExt",
		#{const VK_STRUCTURE_TYPE_MICROMAP_BUILD_SIZES_INFO_EXT}),
	("StructureTypeAccelerationStructureTrianglesOpacityMicromapExt",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT}),
	("StructureTypePhysicalDeviceClusterCullingShaderFeaturesHuawei",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI}),
	("StructureTypePhysicalDeviceClusterCullingShaderPropertiesHuawei",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI}),
	("StructureTypePhysicalDeviceClusterCullingShaderVrsFeaturesHuawei",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_VRS_FEATURES_HUAWEI}),
	("StructureTypePhysicalDeviceBorderColorSwizzleFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT}),
	("StructureTypeSamplerBorderColorComponentMappingCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT}),
	("StructureTypePhysicalDevicePageableDeviceLocalMemoryFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT}),
	("StructureTypePhysicalDeviceShaderCorePropertiesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM}),
	("StructureTypeDeviceQueueShaderCoreControlCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM}),
	("StructureTypePhysicalDeviceSchedulingControlsFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM}),
	("StructureTypePhysicalDeviceSchedulingControlsPropertiesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM}),
	("StructureTypePhysicalDeviceImageSlicedViewOf3dFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT}),
	("StructureTypeImageViewSlicedCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceDescriptorSetHostMappingFeaturesValve",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE}),
	("StructureTypeDescriptorSetBindingReferenceValve",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE}),
	("StructureTypeDescriptorSetLayoutHostMappingInfoValve",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE}),
	("StructureTypePhysicalDeviceNonSeamlessCubeMapFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT}),
	("StructureTypePhysicalDeviceRenderPassStripedFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM}),
	("StructureTypePhysicalDeviceRenderPassStripedPropertiesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_PROPERTIES_ARM}),
	("StructureTypeRenderPassStripeBeginInfoArm",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM}),
	("StructureTypeRenderPassStripeInfoArm",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM}),
	("StructureTypeRenderPassStripeSubmitInfoArm",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM}),
	("StructureTypePhysicalDeviceCopyMemoryIndirectFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV}),
	("StructureTypePhysicalDeviceCopyMemoryIndirectPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceMemoryDecompressionFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV}),
	("StructureTypePhysicalDeviceMemoryDecompressionPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV}),
	("StructureTypeComputePipelineIndirectBufferInfoNv",
		#{const VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV}),
	("StructureTypePipelineIndirectDeviceAddressInfoNv",
		#{const VK_STRUCTURE_TYPE_PIPELINE_INDIRECT_DEVICE_ADDRESS_INFO_NV}),
	("StructureTypePhysicalDeviceRayTracingLinearSweptSpheresFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV}),
	("StructureTypeAccelerationStructureGeometryLinearSweptSpheresDataNv",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_LINEAR_SWEPT_SPHERES_DATA_NV}),
	("StructureTypeAccelerationStructureGeometrySpheresDataNv",
		#{const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_SPHERES_DATA_NV}),
	("StructureTypePhysicalDeviceLinearColorAttachmentFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV}),
	("StructureTypePhysicalDeviceShaderMaximalReconvergenceFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR}),
	("StructureTypePhysicalDeviceImageCompressionControlSwapchainFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT}),
	("StructureTypePhysicalDeviceImageProcessingFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM}),
	("StructureTypePhysicalDeviceImageProcessingPropertiesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM}),
	("StructureTypeImageViewSampleWeightCreateInfoQcom",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM}),
	("StructureTypePhysicalDeviceNestedCommandBufferFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT}),
	("StructureTypePhysicalDeviceNestedCommandBufferPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT}),
	("StructureTypeExternalMemoryAcquireUnmodifiedExt",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT}),
	("StructureTypePhysicalDeviceExtendedDynamicState3FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT}),
	("StructureTypePhysicalDeviceExtendedDynamicState3PropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceSubpassMergeFeedbackFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT}),
	("StructureTypeRenderPassCreationControlExt",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT}),
	("StructureTypeRenderPassCreationFeedbackCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT}),
	("StructureTypeRenderPassSubpassFeedbackCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT}),
	("StructureTypeDirectDriverLoadingInfoLunarg",
		#{const VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG}),
	("StructureTypeDirectDriverLoadingListLunarg",
		#{const VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG}),
	("StructureTypeTensorCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_CREATE_INFO_ARM}),
	("StructureTypeTensorViewCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_VIEW_CREATE_INFO_ARM}),
	("StructureTypeBindTensorMemoryInfoArm",
		#{const VK_STRUCTURE_TYPE_BIND_TENSOR_MEMORY_INFO_ARM}),
	("StructureTypeWriteDescriptorSetTensorArm",
		#{const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_TENSOR_ARM}),
	("StructureTypePhysicalDeviceTensorPropertiesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TENSOR_PROPERTIES_ARM}),
	("StructureTypeTensorFormatPropertiesArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_FORMAT_PROPERTIES_ARM}),
	("StructureTypeTensorDescriptionArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_DESCRIPTION_ARM}),
	("StructureTypeTensorMemoryRequirementsInfoArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_MEMORY_REQUIREMENTS_INFO_ARM}),
	("StructureTypeTensorMemoryBarrierArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_MEMORY_BARRIER_ARM}),
	("StructureTypePhysicalDeviceTensorFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TENSOR_FEATURES_ARM}),
	("StructureTypeDeviceTensorMemoryRequirementsArm",
		#{const VK_STRUCTURE_TYPE_DEVICE_TENSOR_MEMORY_REQUIREMENTS_ARM}),
	("StructureTypeCopyTensorInfoArm",
		#{const VK_STRUCTURE_TYPE_COPY_TENSOR_INFO_ARM}),
	("StructureTypeTensorCopyArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_COPY_ARM}),
	("StructureTypeTensorDependencyInfoArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_DEPENDENCY_INFO_ARM}),
	("StructureTypeMemoryDedicatedAllocateInfoTensorArm",
		#{const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_TENSOR_ARM}),
	("StructureTypePhysicalDeviceExternalTensorInfoArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_TENSOR_INFO_ARM}),
	("StructureTypeExternalTensorPropertiesArm",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_TENSOR_PROPERTIES_ARM}),
	("StructureTypeExternalMemoryTensorCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_TENSOR_CREATE_INFO_ARM}),
	("StructureTypePhysicalDeviceDescriptorBufferTensorFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_TENSOR_FEATURES_ARM}),
	("StructureTypePhysicalDeviceDescriptorBufferTensorPropertiesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_TENSOR_PROPERTIES_ARM}),
	("StructureTypeDescriptorGetTensorInfoArm",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_GET_TENSOR_INFO_ARM}),
	("StructureTypeTensorCaptureDescriptorDataInfoArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_CAPTURE_DESCRIPTOR_DATA_INFO_ARM}),
	("StructureTypeTensorViewCaptureDescriptorDataInfoArm",
		#{const VK_STRUCTURE_TYPE_TENSOR_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_ARM}),
	("StructureTypeFrameBoundaryTensorsArm",
		#{const VK_STRUCTURE_TYPE_FRAME_BOUNDARY_TENSORS_ARM}),
	("StructureTypePhysicalDeviceShaderModuleIdentifierFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT}),
	("StructureTypePhysicalDeviceShaderModuleIdentifierPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT}),
	("StructureTypePipelineShaderStageModuleIdentifierCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT}),
	("StructureTypeShaderModuleIdentifierExt",
		#{const VK_STRUCTURE_TYPE_SHADER_MODULE_IDENTIFIER_EXT}),
	("StructureTypePhysicalDeviceRasterizationOrderAttachmentAccessFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT}),
	("StructureTypePhysicalDeviceOpticalFlowFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV}),
	("StructureTypePhysicalDeviceOpticalFlowPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV}),
	("StructureTypeOpticalFlowImageFormatInfoNv",
		#{const VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV}),
	("StructureTypeOpticalFlowImageFormatPropertiesNv",
		#{const VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV}),
	("StructureTypeOpticalFlowSessionCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV}),
	("StructureTypeOpticalFlowExecuteInfoNv",
		#{const VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV}),
	("StructureTypeOpticalFlowSessionCreatePrivateDataInfoNv",
		#{const VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV}),
	("StructureTypePhysicalDeviceLegacyDitheringFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT}),
	("StructureTypePhysicalDeviceExternalFormatResolveFeaturesAndroid",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_FEATURES_ANDROID}),
	("StructureTypePhysicalDeviceExternalFormatResolvePropertiesAndroid",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID}),
	("StructureTypeAndroidHardwareBufferFormatResolvePropertiesAndroid",
		#{const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID}),
	("StructureTypePhysicalDeviceAntiLagFeaturesAmd",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ANTI_LAG_FEATURES_AMD}),
	("StructureTypeAntiLagDataAmd",
		#{const VK_STRUCTURE_TYPE_ANTI_LAG_DATA_AMD}),
	("StructureTypeAntiLagPresentationInfoAmd",
		#{const VK_STRUCTURE_TYPE_ANTI_LAG_PRESENTATION_INFO_AMD}),
	("StructureTypeSurfaceCapabilitiesPresentId2Khr",
		#{const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_ID_2_KHR}),
	("StructureTypePresentId2Khr",
		#{const VK_STRUCTURE_TYPE_PRESENT_ID_2_KHR}),
	("StructureTypePhysicalDevicePresentId2FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_2_FEATURES_KHR}),
	("StructureTypeSurfaceCapabilitiesPresentWait2Khr",
		#{const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_WAIT_2_KHR}),
	("StructureTypePhysicalDevicePresentWait2FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_2_FEATURES_KHR}),
	("StructureTypePresentWait2InfoKhr",
		#{const VK_STRUCTURE_TYPE_PRESENT_WAIT_2_INFO_KHR}),
	("StructureTypePhysicalDeviceRayTracingPositionFetchFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR}),
	("StructureTypePhysicalDeviceShaderObjectFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT}),
	("StructureTypePhysicalDeviceShaderObjectPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT}),
	("StructureTypeShaderCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT}),
	("StructureTypePhysicalDevicePipelineBinaryFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR}),
	("StructureTypePipelineBinaryCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_BINARY_CREATE_INFO_KHR}),
	("StructureTypePipelineBinaryInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_BINARY_INFO_KHR}),
	("StructureTypePipelineBinaryKeyKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_BINARY_KEY_KHR}),
	("StructureTypePhysicalDevicePipelineBinaryPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_PROPERTIES_KHR}),
	("StructureTypeReleaseCapturedPipelineDataInfoKhr",
		#{const VK_STRUCTURE_TYPE_RELEASE_CAPTURED_PIPELINE_DATA_INFO_KHR}),
	("StructureTypePipelineBinaryDataInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_BINARY_DATA_INFO_KHR}),
	("StructureTypePipelineCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_CREATE_INFO_KHR}),
	("StructureTypeDevicePipelineBinaryInternalCacheControlKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR}),
	("StructureTypePipelineBinaryHandlesInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_BINARY_HANDLES_INFO_KHR}),
	("StructureTypePhysicalDeviceTilePropertiesFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM}),
	("StructureTypeTilePropertiesQcom",
		#{const VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM}),
	("StructureTypePhysicalDeviceAmigoProfilingFeaturesSec",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC}),
	("StructureTypeAmigoProfilingSubmitInfoSec",
		#{const VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC}),
	("StructureTypeSurfacePresentModeKhr",
		#{const VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_KHR}),
	("StructureTypeSurfacePresentScalingCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_KHR}),
	("StructureTypeSurfacePresentModeCompatibilityKhr",
		#{const VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_KHR}),
	("StructureTypePhysicalDeviceSwapchainMaintenance1FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_KHR}),
	("StructureTypeSwapchainPresentFenceInfoKhr",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_KHR}),
	("StructureTypeSwapchainPresentModesCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_KHR}),
	("StructureTypeSwapchainPresentModeInfoKhr",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_KHR}),
	("StructureTypeSwapchainPresentScalingCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_KHR}),
	("StructureTypeReleaseSwapchainImagesInfoKhr",
		#{const VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_KHR}),
	("StructureTypePhysicalDeviceMultiviewPerViewViewportsFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM}),
	("StructureTypePhysicalDeviceRayTracingInvocationReorderFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV}),
	("StructureTypePhysicalDeviceRayTracingInvocationReorderPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceCooperativeVectorFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV}),
	("StructureTypePhysicalDeviceCooperativeVectorPropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_PROPERTIES_NV}),
	("StructureTypeCooperativeVectorPropertiesNv",
		#{const VK_STRUCTURE_TYPE_COOPERATIVE_VECTOR_PROPERTIES_NV}),
	("StructureTypeConvertCooperativeVectorMatrixInfoNv",
		#{const VK_STRUCTURE_TYPE_CONVERT_COOPERATIVE_VECTOR_MATRIX_INFO_NV}),
	("StructureTypePhysicalDeviceExtendedSparseAddressSpaceFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV}),
	("StructureTypePhysicalDeviceExtendedSparseAddressSpacePropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceMutableDescriptorTypeFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT}),
	("StructureTypeMutableDescriptorTypeCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceLegacyVertexAttributesFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT}),
	("StructureTypePhysicalDeviceLegacyVertexAttributesPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT}),
	("StructureTypeLayerSettingsCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceShaderCoreBuiltinsFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM}),
	("StructureTypePhysicalDeviceShaderCoreBuiltinsPropertiesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM}),
	("StructureTypePhysicalDevicePipelineLibraryGroupHandlesFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT}),
	("StructureTypePhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT}),
	("StructureTypeLatencySleepModeInfoNv",
		#{const VK_STRUCTURE_TYPE_LATENCY_SLEEP_MODE_INFO_NV}),
	("StructureTypeLatencySleepInfoNv",
		#{const VK_STRUCTURE_TYPE_LATENCY_SLEEP_INFO_NV}),
	("StructureTypeSetLatencyMarkerInfoNv",
		#{const VK_STRUCTURE_TYPE_SET_LATENCY_MARKER_INFO_NV}),
	("StructureTypeGetLatencyMarkerInfoNv",
		#{const VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV}),
	("StructureTypeLatencyTimingsFrameReportNv",
		#{const VK_STRUCTURE_TYPE_LATENCY_TIMINGS_FRAME_REPORT_NV}),
	("StructureTypeLatencySubmissionPresentIdNv",
		#{const VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV}),
	("StructureTypeOutOfBandQueueTypeInfoNv",
		#{const VK_STRUCTURE_TYPE_OUT_OF_BAND_QUEUE_TYPE_INFO_NV}),
	("StructureTypeSwapchainLatencyCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_LATENCY_CREATE_INFO_NV}),
	("StructureTypeLatencySurfaceCapabilitiesNv",
		#{const VK_STRUCTURE_TYPE_LATENCY_SURFACE_CAPABILITIES_NV}),
	("StructureTypePhysicalDeviceCooperativeMatrixFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR}),
	("StructureTypeCooperativeMatrixPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceCooperativeMatrixPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_KHR}),
	("StructureTypeDataGraphPipelineCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CREATE_INFO_ARM}),
	("StructureTypeDataGraphPipelineSessionCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_CREATE_INFO_ARM}),
	("StructureTypeDataGraphPipelineResourceInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_RESOURCE_INFO_ARM}),
	("StructureTypeDataGraphPipelineConstantArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_ARM}),
	("StructureTypeDataGraphPipelineSessionMemoryRequirementsInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_MEMORY_REQUIREMENTS_INFO_ARM}),
	("StructureTypeBindDataGraphPipelineSessionMemoryInfoArm",
		#{const VK_STRUCTURE_TYPE_BIND_DATA_GRAPH_PIPELINE_SESSION_MEMORY_INFO_ARM}),
	("StructureTypePhysicalDeviceDataGraphFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DATA_GRAPH_FEATURES_ARM}),
	("StructureTypeDataGraphPipelineShaderModuleCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SHADER_MODULE_CREATE_INFO_ARM}),
	("StructureTypeDataGraphPipelinePropertyQueryResultArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_PROPERTY_QUERY_RESULT_ARM}),
	("StructureTypeDataGraphPipelineInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_INFO_ARM}),
	("StructureTypeDataGraphPipelineCompilerControlCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_COMPILER_CONTROL_CREATE_INFO_ARM}),
	("StructureTypeDataGraphPipelineSessionBindPointRequirementsInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENTS_INFO_ARM}),
	("StructureTypeDataGraphPipelineSessionBindPointRequirementArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENT_ARM}),
	("StructureTypeDataGraphPipelineIdentifierCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_IDENTIFIER_CREATE_INFO_ARM}),
	("StructureTypeDataGraphPipelineDispatchInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_DISPATCH_INFO_ARM}),
	("StructureTypeDataGraphProcessingEngineCreateInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PROCESSING_ENGINE_CREATE_INFO_ARM}),
	("StructureTypeQueueFamilyDataGraphProcessingEnginePropertiesArm",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_DATA_GRAPH_PROCESSING_ENGINE_PROPERTIES_ARM}),
	("StructureTypeQueueFamilyDataGraphPropertiesArm",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_DATA_GRAPH_PROPERTIES_ARM}),
	("StructureTypePhysicalDeviceQueueFamilyDataGraphProcessingEngineInfoArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_QUEUE_FAMILY_DATA_GRAPH_PROCESSING_ENGINE_INFO_ARM}),
	("StructureTypeDataGraphPipelineConstantTensorSemiStructuredSparsityInfoArm",
		#{const VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_TENSOR_SEMI_STRUCTURED_SPARSITY_INFO_ARM}),
	("StructureTypePhysicalDeviceMultiviewPerViewRenderAreasFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM}),
	("StructureTypeMultiviewPerViewRenderAreasRenderPassBeginInfoQcom",
		#{const VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM}),
	("StructureTypePhysicalDeviceComputeShaderDerivativesFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR}),
	("StructureTypePhysicalDeviceComputeShaderDerivativesPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR}),
	("StructureTypeVideoDecodeAv1CapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_CAPABILITIES_KHR}),
	("StructureTypeVideoDecodeAv1PictureInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PICTURE_INFO_KHR}),
	("StructureTypeVideoDecodeAv1ProfileInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR}),
	("StructureTypeVideoDecodeAv1SessionParametersCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR}),
	("StructureTypeVideoDecodeAv1DpbSlotInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_DPB_SLOT_INFO_KHR}),
	("StructureTypeVideoEncodeAv1CapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_CAPABILITIES_KHR}),
	("StructureTypeVideoEncodeAv1SessionParametersCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR}),
	("StructureTypeVideoEncodeAv1PictureInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PICTURE_INFO_KHR}),
	("StructureTypeVideoEncodeAv1DpbSlotInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_DPB_SLOT_INFO_KHR}),
	("StructureTypePhysicalDeviceVideoEncodeAv1FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_AV1_FEATURES_KHR}),
	("StructureTypeVideoEncodeAv1ProfileInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PROFILE_INFO_KHR}),
	("StructureTypeVideoEncodeAv1RateControlInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_INFO_KHR}),
	("StructureTypeVideoEncodeAv1RateControlLayerInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_LAYER_INFO_KHR}),
	("StructureTypeVideoEncodeAv1QualityLevelPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUALITY_LEVEL_PROPERTIES_KHR}),
	("StructureTypeVideoEncodeAv1SessionCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_CREATE_INFO_KHR}),
	("StructureTypeVideoEncodeAv1GopRemainingFrameInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_GOP_REMAINING_FRAME_INFO_KHR}),
	("StructureTypePhysicalDeviceVideoDecodeVp9FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_DECODE_VP9_FEATURES_KHR}),
	("StructureTypeVideoDecodeVp9CapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_CAPABILITIES_KHR}),
	("StructureTypeVideoDecodeVp9PictureInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_PICTURE_INFO_KHR}),
	("StructureTypeVideoDecodeVp9ProfileInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_PROFILE_INFO_KHR}),
	("StructureTypePhysicalDeviceVideoMaintenance1FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR}),
	("StructureTypeVideoInlineQueryInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_INLINE_QUERY_INFO_KHR}),
	("StructureTypePhysicalDevicePerStageDescriptorSetFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV}),
	("StructureTypePhysicalDeviceImageProcessing2FeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM}),
	("StructureTypePhysicalDeviceImageProcessing2PropertiesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_PROPERTIES_QCOM}),
	("StructureTypeSamplerBlockMatchWindowCreateInfoQcom",
		#{const VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM}),
	("StructureTypeSamplerCubicWeightsCreateInfoQcom",
		#{const VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM}),
	("StructureTypePhysicalDeviceCubicWeightsFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM}),
	("StructureTypeBlitImageCubicWeightsInfoQcom",
		#{const VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM}),
	("StructureTypePhysicalDeviceYcbcrDegammaFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM}),
	("StructureTypeSamplerYcbcrConversionYcbcrDegammaCreateInfoQcom",
		#{const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM}),
	("StructureTypePhysicalDeviceCubicClampFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM}),
	("StructureTypePhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT}),
	("StructureTypePhysicalDeviceUnifiedImageLayoutsFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFIED_IMAGE_LAYOUTS_FEATURES_KHR}),
	("StructureTypeAttachmentFeedbackLoopInfoExt",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_FEEDBACK_LOOP_INFO_EXT}),
	("StructureTypeScreenBufferPropertiesQnx",
		#{const VK_STRUCTURE_TYPE_SCREEN_BUFFER_PROPERTIES_QNX}),
	("StructureTypeScreenBufferFormatPropertiesQnx",
		#{const VK_STRUCTURE_TYPE_SCREEN_BUFFER_FORMAT_PROPERTIES_QNX}),
	("StructureTypeImportScreenBufferInfoQnx",
		#{const VK_STRUCTURE_TYPE_IMPORT_SCREEN_BUFFER_INFO_QNX}),
	("StructureTypeExternalFormatQnx",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX}),
	("StructureTypePhysicalDeviceExternalMemoryScreenBufferFeaturesQnx",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCREEN_BUFFER_FEATURES_QNX}),
	("StructureTypePhysicalDeviceLayeredDriverPropertiesMsft",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_DRIVER_PROPERTIES_MSFT}),
	("StructureTypeCalibratedTimestampInfoKhr",
		#{const VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR}),
	("StructureTypeSetDescriptorBufferOffsetsInfoExt",
		#{const VK_STRUCTURE_TYPE_SET_DESCRIPTOR_BUFFER_OFFSETS_INFO_EXT}),
	("StructureTypeBindDescriptorBufferEmbeddedSamplersInfoExt",
		#{const VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT}),
	("StructureTypePhysicalDeviceDescriptorPoolOverallocationFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV}),
	("StructureTypePhysicalDeviceTileMemoryHeapFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_MEMORY_HEAP_FEATURES_QCOM}),
	("StructureTypePhysicalDeviceTileMemoryHeapPropertiesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_MEMORY_HEAP_PROPERTIES_QCOM}),
	("StructureTypeTileMemoryRequirementsQcom",
		#{const VK_STRUCTURE_TYPE_TILE_MEMORY_REQUIREMENTS_QCOM}),
	("StructureTypeTileMemoryBindInfoQcom",
		#{const VK_STRUCTURE_TYPE_TILE_MEMORY_BIND_INFO_QCOM}),
	("StructureTypeTileMemorySizeInfoQcom",
		#{const VK_STRUCTURE_TYPE_TILE_MEMORY_SIZE_INFO_QCOM}),
	("StructureTypeDisplaySurfaceStereoCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_DISPLAY_SURFACE_STEREO_CREATE_INFO_NV}),
	("StructureTypeDisplayModeStereoPropertiesNv",
		#{const VK_STRUCTURE_TYPE_DISPLAY_MODE_STEREO_PROPERTIES_NV}),
	("StructureTypeVideoEncodeIntraRefreshCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_INTRA_REFRESH_CAPABILITIES_KHR}),
	("StructureTypeVideoEncodeSessionIntraRefreshCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_INTRA_REFRESH_CREATE_INFO_KHR}),
	("StructureTypeVideoEncodeIntraRefreshInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_INTRA_REFRESH_INFO_KHR}),
	("StructureTypeVideoReferenceIntraRefreshInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_REFERENCE_INTRA_REFRESH_INFO_KHR}),
	("StructureTypePhysicalDeviceVideoEncodeIntraRefreshFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_INTRA_REFRESH_FEATURES_KHR}),
	("StructureTypeVideoEncodeQuantizationMapCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_CAPABILITIES_KHR}),
	("StructureTypeVideoFormatQuantizationMapPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_FORMAT_QUANTIZATION_MAP_PROPERTIES_KHR}),
	("StructureTypeVideoEncodeQuantizationMapInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_INFO_KHR}),
	("StructureTypeVideoEncodeQuantizationMapSessionParametersCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_SESSION_PARAMETERS_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceVideoEncodeQuantizationMapFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUANTIZATION_MAP_FEATURES_KHR}),
	("StructureTypeVideoEncodeH264QuantizationMapCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUANTIZATION_MAP_CAPABILITIES_KHR}),
	("StructureTypeVideoEncodeH265QuantizationMapCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUANTIZATION_MAP_CAPABILITIES_KHR}),
	("StructureTypeVideoFormatH265QuantizationMapPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_FORMAT_H265_QUANTIZATION_MAP_PROPERTIES_KHR}),
	("StructureTypeVideoEncodeAv1QuantizationMapCapabilitiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUANTIZATION_MAP_CAPABILITIES_KHR}),
	("StructureTypeVideoFormatAv1QuantizationMapPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_FORMAT_AV1_QUANTIZATION_MAP_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceRawAccessChainsFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAW_ACCESS_CHAINS_FEATURES_NV}),
	("StructureTypeExternalComputeQueueDeviceCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DEVICE_CREATE_INFO_NV}),
	("StructureTypeExternalComputeQueueCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_CREATE_INFO_NV}),
	("StructureTypeExternalComputeQueueDataParamsNv",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DATA_PARAMS_NV}),
	("StructureTypePhysicalDeviceExternalComputeQueuePropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_COMPUTE_QUEUE_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR}),
	("StructureTypePhysicalDeviceCommandBufferInheritanceFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMMAND_BUFFER_INHERITANCE_FEATURES_NV}),
	("StructureTypePhysicalDeviceMaintenance7FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR}),
	("StructureTypePhysicalDeviceMaintenance7PropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceLayeredApiPropertiesListKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_LIST_KHR}),
	("StructureTypePhysicalDeviceLayeredApiPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceLayeredApiVulkanPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_VULKAN_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceShaderAtomicFloat16VectorFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT16_VECTOR_FEATURES_NV}),
	("StructureTypePhysicalDeviceShaderReplicatedCompositesFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT}),
	("StructureTypePhysicalDeviceShaderFloat8FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT8_FEATURES_EXT}),
	("StructureTypePhysicalDeviceRayTracingValidationFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_VALIDATION_FEATURES_NV}),
	("StructureTypePhysicalDeviceClusterAccelerationStructureFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_FEATURES_NV}),
	("StructureTypePhysicalDeviceClusterAccelerationStructurePropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_PROPERTIES_NV}),
	("StructureTypeClusterAccelerationStructureClustersBottomLevelInputNv",
		#{const VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_CLUSTERS_BOTTOM_LEVEL_INPUT_NV}),
	("StructureTypeClusterAccelerationStructureTriangleClusterInputNv",
		#{const VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_TRIANGLE_CLUSTER_INPUT_NV}),
	("StructureTypeClusterAccelerationStructureMoveObjectsInputNv",
		#{const VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_MOVE_OBJECTS_INPUT_NV}),
	("StructureTypeClusterAccelerationStructureInputInfoNv",
		#{const VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_INPUT_INFO_NV}),
	("StructureTypeClusterAccelerationStructureCommandsInfoNv",
		#{const VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_COMMANDS_INFO_NV}),
	("StructureTypeRayTracingPipelineClusterAccelerationStructureCreateInfoNv",
		#{const VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CLUSTER_ACCELERATION_STRUCTURE_CREATE_INFO_NV}),
	("StructureTypePhysicalDevicePartitionedAccelerationStructureFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_FEATURES_NV}),
	("StructureTypePhysicalDevicePartitionedAccelerationStructurePropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_PROPERTIES_NV}),
	("StructureTypeWriteDescriptorSetPartitionedAccelerationStructureNv",
		#{const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_PARTITIONED_ACCELERATION_STRUCTURE_NV}),
	("StructureTypePartitionedAccelerationStructureInstancesInputNv",
		#{const VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCES_INPUT_NV}),
	("StructureTypeBuildPartitionedAccelerationStructureInfoNv",
		#{const VK_STRUCTURE_TYPE_BUILD_PARTITIONED_ACCELERATION_STRUCTURE_INFO_NV}),
	("StructureTypePartitionedAccelerationStructureFlagsNv",
		#{const VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_FLAGS_NV}),
	("StructureTypePhysicalDeviceDeviceGeneratedCommandsFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT}),
	("StructureTypePhysicalDeviceDeviceGeneratedCommandsPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_EXT}),
	("StructureTypeGeneratedCommandsMemoryRequirementsInfoExt",
		#{const VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_EXT}),
	("StructureTypeIndirectExecutionSetCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_CREATE_INFO_EXT}),
	("StructureTypeGeneratedCommandsInfoExt",
		#{const VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_EXT}),
	("StructureTypeIndirectCommandsLayoutCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_EXT}),
	("StructureTypeIndirectCommandsLayoutTokenExt",
		#{const VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_EXT}),
	("StructureTypeWriteIndirectExecutionSetPipelineExt",
		#{const VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_PIPELINE_EXT}),
	("StructureTypeWriteIndirectExecutionSetShaderExt",
		#{const VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_SHADER_EXT}),
	("StructureTypeIndirectExecutionSetPipelineInfoExt",
		#{const VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_PIPELINE_INFO_EXT}),
	("StructureTypeIndirectExecutionSetShaderInfoExt",
		#{const VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_INFO_EXT}),
	("StructureTypeIndirectExecutionSetShaderLayoutInfoExt",
		#{const VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_LAYOUT_INFO_EXT}),
	("StructureTypeGeneratedCommandsPipelineInfoExt",
		#{const VK_STRUCTURE_TYPE_GENERATED_COMMANDS_PIPELINE_INFO_EXT}),
	("StructureTypeGeneratedCommandsShaderInfoExt",
		#{const VK_STRUCTURE_TYPE_GENERATED_COMMANDS_SHADER_INFO_EXT}),
	("StructureTypePhysicalDeviceMaintenance8FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_8_FEATURES_KHR}),
	("StructureTypeMemoryBarrierAccessFlags3Khr",
		#{const VK_STRUCTURE_TYPE_MEMORY_BARRIER_ACCESS_FLAGS_3_KHR}),
	("StructureTypePhysicalDeviceImageAlignmentControlFeaturesMesa",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_FEATURES_MESA}),
	("StructureTypePhysicalDeviceImageAlignmentControlPropertiesMesa",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_PROPERTIES_MESA}),
	("StructureTypeImageAlignmentControlCreateInfoMesa",
		#{const VK_STRUCTURE_TYPE_IMAGE_ALIGNMENT_CONTROL_CREATE_INFO_MESA}),
	("StructureTypePhysicalDeviceDepthClampControlFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT}),
	("StructureTypePipelineViewportDepthClampControlCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLAMP_CONTROL_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceMaintenance9FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_9_FEATURES_KHR}),
	("StructureTypePhysicalDeviceMaintenance9PropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_9_PROPERTIES_KHR}),
	("StructureTypeQueueFamilyOwnershipTransferPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_OWNERSHIP_TRANSFER_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceVideoMaintenance2FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_2_FEATURES_KHR}),
	("StructureTypeVideoDecodeH264InlineSessionParametersInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_INLINE_SESSION_PARAMETERS_INFO_KHR}),
	("StructureTypeVideoDecodeH265InlineSessionParametersInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_INLINE_SESSION_PARAMETERS_INFO_KHR}),
	("StructureTypeVideoDecodeAv1InlineSessionParametersInfoKhr",
		#{const VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_INLINE_SESSION_PARAMETERS_INFO_KHR}),
	("StructureTypePhysicalDeviceHdrVividFeaturesHuawei",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HDR_VIVID_FEATURES_HUAWEI}),
	("StructureTypeHdrVividDynamicMetadataHuawei",
		#{const VK_STRUCTURE_TYPE_HDR_VIVID_DYNAMIC_METADATA_HUAWEI}),
	("StructureTypePhysicalDeviceCooperativeMatrix2FeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV}),
	("StructureTypeCooperativeMatrixFlexibleDimensionsPropertiesNv",
		#{const VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_FLEXIBLE_DIMENSIONS_PROPERTIES_NV}),
	("StructureTypePhysicalDeviceCooperativeMatrix2PropertiesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_PROPERTIES_NV}),
	("StructureTypePhysicalDevicePipelineOpacityMicromapFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_OPACITY_MICROMAP_FEATURES_ARM}),
	("StructureTypeImportMemoryMetalHandleInfoExt",
		#{const VK_STRUCTURE_TYPE_IMPORT_MEMORY_METAL_HANDLE_INFO_EXT}),
	("StructureTypeMemoryMetalHandlePropertiesExt",
		#{const VK_STRUCTURE_TYPE_MEMORY_METAL_HANDLE_PROPERTIES_EXT}),
	("StructureTypeMemoryGetMetalHandleInfoExt",
		#{const VK_STRUCTURE_TYPE_MEMORY_GET_METAL_HANDLE_INFO_EXT}),
	("StructureTypePhysicalDeviceDepthClampZeroOneFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR}),
	("StructureTypePhysicalDeviceVertexAttributeRobustnessFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_ROBUSTNESS_FEATURES_EXT}),
	("StructureTypePhysicalDeviceFormatPackFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FORMAT_PACK_FEATURES_ARM}),
	("StructureTypePhysicalDeviceFragmentDensityMapLayeredFeaturesValve",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_LAYERED_FEATURES_VALVE}),
	("StructureTypePhysicalDeviceFragmentDensityMapLayeredPropertiesValve",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_LAYERED_PROPERTIES_VALVE}),
	("StructureTypePipelineFragmentDensityMapLayeredCreateInfoValve",
		#{const VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_DENSITY_MAP_LAYERED_CREATE_INFO_VALVE}),
	("StructureTypePhysicalDeviceRobustness2FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_KHR}),
	("StructureTypePhysicalDeviceRobustness2PropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceFragmentDensityMapOffsetFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_EXT}),
	("StructureTypePhysicalDeviceFragmentDensityMapOffsetPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_EXT}),
	("StructureTypeRenderPassFragmentDensityMapOffsetEndInfoExt",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_EXT}),
	("StructureTypeRenderingEndInfoExt",
		#{const VK_STRUCTURE_TYPE_RENDERING_END_INFO_EXT}),
	("StructureTypePhysicalDeviceZeroInitializeDeviceMemoryFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_DEVICE_MEMORY_FEATURES_EXT}),
	("StructureTypePhysicalDevicePresentModeFifoLatestReadyFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_KHR}),
	("StructureTypePhysicalDevicePipelineCacheIncrementalModeFeaturesSec",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CACHE_INCREMENTAL_MODE_FEATURES_SEC}),
	("StructureTypePhysicalDeviceVariablePointerFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES}),
	("StructureTypePhysicalDeviceShaderDrawParameterFeatures",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES}),
	("StructureTypeDebugReportCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DEBUG_REPORT_CREATE_INFO_EXT}),
	("StructureTypeRenderingInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDERING_INFO_KHR}),
	("StructureTypeRenderingAttachmentInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO_KHR}),
	("StructureTypePipelineRenderingCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceDynamicRenderingFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES_KHR}),
	("StructureTypeCommandBufferInheritanceRenderingInfoKhr",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO_KHR}),
	("StructureTypeRenderPassMultiviewCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceMultiviewFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR}),
	("StructureTypePhysicalDeviceMultiviewPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceFeatures2Khr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR}),
	("StructureTypePhysicalDeviceProperties2Khr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR}),
	("StructureTypeFormatProperties2Khr",
		#{const VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR}),
	("StructureTypeImageFormatProperties2Khr",
		#{const VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR}),
	("StructureTypePhysicalDeviceImageFormatInfo2Khr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR}),
	("StructureTypeQueueFamilyProperties2Khr",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR}),
	("StructureTypePhysicalDeviceMemoryProperties2Khr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR}),
	("StructureTypeSparseImageFormatProperties2Khr",
		#{const VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR}),
	("StructureTypePhysicalDeviceSparseImageFormatInfo2Khr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR}),
	("StructureTypeMemoryAllocateFlagsInfoKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR}),
	("StructureTypeDeviceGroupRenderPassBeginInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR}),
	("StructureTypeDeviceGroupCommandBufferBeginInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR}),
	("StructureTypeDeviceGroupSubmitInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR}),
	("StructureTypeDeviceGroupBindSparseInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR}),
	("StructureTypeBindBufferMemoryDeviceGroupInfoKhr",
		#{const VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR}),
	("StructureTypeBindImageMemoryDeviceGroupInfoKhr",
		#{const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR}),
	("StructureTypePhysicalDeviceTextureCompressionAstcHdrFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT}),
	("StructureTypePipelineRobustnessCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT}),
	("StructureTypePhysicalDevicePipelineRobustnessFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES_EXT}),
	("StructureTypePhysicalDevicePipelineRobustnessPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceGroupPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR}),
	("StructureTypeDeviceGroupDeviceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceExternalImageFormatInfoKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR}),
	("StructureTypeExternalImageFormatPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceExternalBufferInfoKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR}),
	("StructureTypeExternalBufferPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceIdPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR}),
	("StructureTypeExternalMemoryBufferCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR}),
	("StructureTypeExternalMemoryImageCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR}),
	("StructureTypeExportMemoryAllocateInfoKhr",
		#{const VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR}),
	("StructureTypePhysicalDeviceExternalSemaphoreInfoKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR}),
	("StructureTypeExternalSemaphorePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR}),
	("StructureTypeExportSemaphoreCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDevicePushDescriptorPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceShaderFloat16Int8FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR}),
	("StructureTypePhysicalDeviceFloat16Int8FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT16_INT8_FEATURES_KHR}),
	("StructureTypePhysicalDevice16bitStorageFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR}),
	("StructureTypeDescriptorUpdateTemplateCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceImagelessFramebufferFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR}),
	("StructureTypeFramebufferAttachmentsCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO_KHR}),
	("StructureTypeFramebufferAttachmentImageInfoKhr",
		#{const VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO_KHR}),
	("StructureTypeRenderPassAttachmentBeginInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO_KHR}),
	("StructureTypeAttachmentDescription2Khr",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2_KHR}),
	("StructureTypeAttachmentReference2Khr",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2_KHR}),
	("StructureTypeSubpassDescription2Khr",
		#{const VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2_KHR}),
	("StructureTypeSubpassDependency2Khr",
		#{const VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2_KHR}),
	("StructureTypeRenderPassCreateInfo2Khr",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2_KHR}),
	("StructureTypeSubpassBeginInfoKhr",
		#{const VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO_KHR}),
	("StructureTypeSubpassEndInfoKhr",
		#{const VK_STRUCTURE_TYPE_SUBPASS_END_INFO_KHR}),
	("StructureTypePhysicalDeviceExternalFenceInfoKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR}),
	("StructureTypeExternalFencePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR}),
	("StructureTypeExportFenceCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDevicePointClippingPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR}),
	("StructureTypeRenderPassInputAttachmentAspectCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR}),
	("StructureTypeImageViewUsageCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR}),
	("StructureTypePipelineTessellationDomainOriginStateCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceVariablePointersFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR}),
	("StructureTypePhysicalDeviceVariablePointerFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR}),
	("StructureTypeMemoryDedicatedRequirementsKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR}),
	("StructureTypeMemoryDedicatedAllocateInfoKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR}),
	("StructureTypePhysicalDeviceSamplerFilterMinmaxPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT}),
	("StructureTypeSamplerReductionModeCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceInlineUniformBlockFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT}),
	("StructureTypePhysicalDeviceInlineUniformBlockPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT}),
	("StructureTypeWriteDescriptorSetInlineUniformBlockExt",
		#{const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT}),
	("StructureTypeDescriptorPoolInlineUniformBlockCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT}),
	("StructureTypeBufferMemoryRequirementsInfo2Khr",
		#{const VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR}),
	("StructureTypeImageMemoryRequirementsInfo2Khr",
		#{const VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR}),
	("StructureTypeImageSparseMemoryRequirementsInfo2Khr",
		#{const VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR}),
	("StructureTypeMemoryRequirements2Khr",
		#{const VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR}),
	("StructureTypeSparseImageMemoryRequirements2Khr",
		#{const VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR}),
	("StructureTypeImageFormatListCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR}),
	("StructureTypeAttachmentSampleCountInfoNv",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_NV}),
	("StructureTypeSamplerYcbcrConversionCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR}),
	("StructureTypeSamplerYcbcrConversionInfoKhr",
		#{const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR}),
	("StructureTypeBindImagePlaneMemoryInfoKhr",
		#{const VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR}),
	("StructureTypeImagePlaneMemoryRequirementsInfoKhr",
		#{const VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR}),
	("StructureTypePhysicalDeviceSamplerYcbcrConversionFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR}),
	("StructureTypeSamplerYcbcrConversionImageFormatPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR}),
	("StructureTypeBindBufferMemoryInfoKhr",
		#{const VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR}),
	("StructureTypeBindImageMemoryInfoKhr",
		#{const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR}),
	("StructureTypeDescriptorSetLayoutBindingFlagsCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceDescriptorIndexingFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT}),
	("StructureTypePhysicalDeviceDescriptorIndexingPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT}),
	("StructureTypeDescriptorSetVariableDescriptorCountAllocateInfoExt",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT}),
	("StructureTypeDescriptorSetVariableDescriptorCountLayoutSupportExt",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT}),
	("StructureTypePhysicalDeviceMaintenance3PropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR}),
	("StructureTypeDescriptorSetLayoutSupportKhr",
		#{const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR}),
	("StructureTypeDeviceQueueGlobalPriorityCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceShaderSubgroupExtendedTypesFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES_KHR}),
	("StructureTypePhysicalDevice8bitStorageFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR}),
	("StructureTypePhysicalDeviceShaderAtomicInt64FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES_KHR}),
	("StructureTypeCalibratedTimestampInfoExt",
		#{const VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT}),
	("StructureTypeDeviceQueueGlobalPriorityCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceGlobalPriorityQueryFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR}),
	("StructureTypeQueueFamilyGlobalPriorityPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR}),
	("StructureTypePipelineVertexInputDivisorStateCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceVertexAttributeDivisorFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT}),
	("StructureTypePipelineCreationFeedbackCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceDriverPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceFloatControlsPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceDepthStencilResolvePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES_KHR}),
	("StructureTypeSubpassDescriptionDepthStencilResolveKhr",
		#{const VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE_KHR}),
	("StructureTypePhysicalDeviceComputeShaderDerivativesFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV}),
	("StructureTypePhysicalDeviceFragmentShaderBarycentricFeaturesNv",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV}),
	("StructureTypePhysicalDeviceTimelineSemaphoreFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR}),
	("StructureTypePhysicalDeviceTimelineSemaphorePropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR}),
	("StructureTypeSemaphoreTypeCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR}),
	("StructureTypeTimelineSemaphoreSubmitInfoKhr",
		#{const VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR}),
	("StructureTypeSemaphoreWaitInfoKhr",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR}),
	("StructureTypeSemaphoreSignalInfoKhr",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR}),
	("StructureTypeQueryPoolCreateInfoIntel",
		#{const VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL}),
	("StructureTypePhysicalDeviceVulkanMemoryModelFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES_KHR}),
	("StructureTypePhysicalDeviceShaderTerminateInvocationFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR}),
	("StructureTypePhysicalDeviceScalarBlockLayoutFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT}),
	("StructureTypePhysicalDeviceSubgroupSizeControlPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT}),
	("StructureTypePipelineShaderStageRequiredSubgroupSizeCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceSubgroupSizeControlFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT}),
	("StructureTypePhysicalDeviceDynamicRenderingLocalReadFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES_KHR}),
	("StructureTypeRenderingAttachmentLocationInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO_KHR}),
	("StructureTypeRenderingInputAttachmentIndexInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO_KHR}),
	("StructureTypePhysicalDeviceSeparateDepthStencilLayoutsFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES_KHR}),
	("StructureTypeAttachmentReferenceStencilLayoutKhr",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT_KHR}),
	("StructureTypeAttachmentDescriptionStencilLayoutKhr",
		#{const VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT_KHR}),
	("StructureTypePhysicalDeviceBufferAddressFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT}),
	("StructureTypeBufferDeviceAddressInfoExt",
		#{const VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_EXT}),
	("StructureTypePhysicalDeviceToolPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT}),
	("StructureTypeImageStencilUsageCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceUniformBufferStandardLayoutFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES_KHR}),
	("StructureTypePhysicalDeviceBufferDeviceAddressFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_KHR}),
	("StructureTypeBufferDeviceAddressInfoKhr",
		#{const VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_KHR}),
	("StructureTypeBufferOpaqueCaptureAddressCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO_KHR}),
	("StructureTypeMemoryOpaqueCaptureAddressAllocateInfoKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO_KHR}),
	("StructureTypeDeviceMemoryOpaqueCaptureAddressInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO_KHR}),
	("StructureTypePhysicalDeviceLineRasterizationFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT}),
	("StructureTypePipelineRasterizationLineStateCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceLineRasterizationPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceHostQueryResetFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES_EXT}),
	("StructureTypePhysicalDeviceIndexTypeUint8FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT}),
	("StructureTypePhysicalDeviceHostImageCopyFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES_EXT}),
	("StructureTypePhysicalDeviceHostImageCopyPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES_EXT}),
	("StructureTypeMemoryToImageCopyExt",
		#{const VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY_EXT}),
	("StructureTypeImageToMemoryCopyExt",
		#{const VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY_EXT}),
	("StructureTypeCopyImageToMemoryInfoExt",
		#{const VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO_EXT}),
	("StructureTypeCopyMemoryToImageInfoExt",
		#{const VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO_EXT}),
	("StructureTypeHostImageLayoutTransitionInfoExt",
		#{const VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO_EXT}),
	("StructureTypeCopyImageToImageInfoExt",
		#{const VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO_EXT}),
	("StructureTypeSubresourceHostMemcpySizeExt",
		#{const VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE_EXT}),
	("StructureTypeHostImageCopyDevicePerformanceQueryExt",
		#{const VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY_EXT}),
	("StructureTypeMemoryMapInfoKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_MAP_INFO_KHR}),
	("StructureTypeMemoryUnmapInfoKhr",
		#{const VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO_KHR}),
	("StructureTypeSurfacePresentModeExt",
		#{const VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_EXT}),
	("StructureTypeSurfacePresentScalingCapabilitiesExt",
		#{const VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_EXT}),
	("StructureTypeSurfacePresentModeCompatibilityExt",
		#{const VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_EXT}),
	("StructureTypePhysicalDeviceSwapchainMaintenance1FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT}),
	("StructureTypeSwapchainPresentFenceInfoExt",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT}),
	("StructureTypeSwapchainPresentModesCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT}),
	("StructureTypeSwapchainPresentModeInfoExt",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT}),
	("StructureTypeSwapchainPresentScalingCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT}),
	("StructureTypeReleaseSwapchainImagesInfoExt",
		#{const VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_EXT}),
	("StructureTypePhysicalDeviceShaderDemoteToHelperInvocationFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT}),
	("StructureTypePhysicalDeviceShaderIntegerDotProductFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR}),
	("StructureTypePhysicalDeviceShaderIntegerDotProductPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceTexelBufferAlignmentPropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceRobustness2FeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT}),
	("StructureTypePhysicalDeviceRobustness2PropertiesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT}),
	("StructureTypePhysicalDevicePrivateDataFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT}),
	("StructureTypeDevicePrivateDataCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT}),
	("StructureTypePrivateDataSlotCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT}),
	("StructureTypePhysicalDevicePipelineCreationCacheControlFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT}),
	("StructureTypeMemoryBarrier2Khr",
		#{const VK_STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR}),
	("StructureTypeBufferMemoryBarrier2Khr",
		#{const VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR}),
	("StructureTypeImageMemoryBarrier2Khr",
		#{const VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR}),
	("StructureTypeDependencyInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEPENDENCY_INFO_KHR}),
	("StructureTypeSubmitInfo2Khr",
		#{const VK_STRUCTURE_TYPE_SUBMIT_INFO_2_KHR}),
	("StructureTypeSemaphoreSubmitInfoKhr",
		#{const VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR}),
	("StructureTypeCommandBufferSubmitInfoKhr",
		#{const VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR}),
	("StructureTypePhysicalDeviceSynchronization2FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR}),
	("StructureTypePhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR}),
	("StructureTypePhysicalDeviceImageRobustnessFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT}),
	("StructureTypeCopyBufferInfo2Khr",
		#{const VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR}),
	("StructureTypeCopyImageInfo2Khr",
		#{const VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR}),
	("StructureTypeCopyBufferToImageInfo2Khr",
		#{const VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR}),
	("StructureTypeCopyImageToBufferInfo2Khr",
		#{const VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR}),
	("StructureTypeBlitImageInfo2Khr",
		#{const VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR}),
	("StructureTypeResolveImageInfo2Khr",
		#{const VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR}),
	("StructureTypeBufferCopy2Khr",
		#{const VK_STRUCTURE_TYPE_BUFFER_COPY_2_KHR}),
	("StructureTypeImageCopy2Khr",
		#{const VK_STRUCTURE_TYPE_IMAGE_COPY_2_KHR}),
	("StructureTypeImageBlit2Khr",
		#{const VK_STRUCTURE_TYPE_IMAGE_BLIT_2_KHR}),
	("StructureTypeBufferImageCopy2Khr",
		#{const VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR}),
	("StructureTypeImageResolve2Khr",
		#{const VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR}),
	("StructureTypeSubresourceLayout2Ext",
		#{const VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2_EXT}),
	("StructureTypeImageSubresource2Ext",
		#{const VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2_EXT}),
	("StructureTypePhysicalDeviceRasterizationOrderAttachmentAccessFeaturesArm",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_ARM}),
	("StructureTypePhysicalDeviceMutableDescriptorTypeFeaturesValve",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE}),
	("StructureTypeMutableDescriptorTypeCreateInfoValve",
		#{const VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE}),
	("StructureTypeFormatProperties3Khr",
		#{const VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3_KHR}),
	("StructureTypePhysicalDevicePresentModeFifoLatestReadyFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_EXT}),
	("StructureTypePipelineInfoExt",
		#{const VK_STRUCTURE_TYPE_PIPELINE_INFO_EXT}),
	("StructureTypePhysicalDeviceGlobalPriorityQueryFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT}),
	("StructureTypeQueueFamilyGlobalPriorityPropertiesExt",
		#{const VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT}),
	("StructureTypePhysicalDeviceMaintenance4FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES_KHR}),
	("StructureTypePhysicalDeviceMaintenance4PropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES_KHR}),
	("StructureTypeDeviceBufferMemoryRequirementsKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS_KHR}),
	("StructureTypeDeviceImageMemoryRequirementsKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS_KHR}),
	("StructureTypePhysicalDeviceShaderSubgroupRotateFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES_KHR}),
	("StructureTypePhysicalDeviceDepthClampZeroOneFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_EXT}),
	("StructureTypePhysicalDeviceFragmentDensityMapOffsetFeaturesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM}),
	("StructureTypePhysicalDeviceFragmentDensityMapOffsetPropertiesQcom",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM}),
	("StructureTypeSubpassFragmentDensityMapOffsetEndInfoQcom",
		#{const VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM}),
	("StructureTypePhysicalDevicePipelineProtectedAccessFeaturesExt",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES_EXT}),
	("StructureTypePhysicalDeviceMaintenance5FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES_KHR}),
	("StructureTypePhysicalDeviceMaintenance5PropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES_KHR}),
	("StructureTypeRenderingAreaInfoKhr",
		#{const VK_STRUCTURE_TYPE_RENDERING_AREA_INFO_KHR}),
	("StructureTypeDeviceImageSubresourceInfoKhr",
		#{const VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO_KHR}),
	("StructureTypeSubresourceLayout2Khr",
		#{const VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2_KHR}),
	("StructureTypeImageSubresource2Khr",
		#{const VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2_KHR}),
	("StructureTypePipelineCreateFlags2CreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR}),
	("StructureTypeBufferUsageFlags2CreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO_KHR}),
	("StructureTypeShaderRequiredSubgroupSizeCreateInfoExt",
		#{const VK_STRUCTURE_TYPE_SHADER_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT}),
	("StructureTypePhysicalDeviceVertexAttributeDivisorPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_KHR}),
	("StructureTypePipelineVertexInputDivisorStateCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceVertexAttributeDivisorFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_KHR}),
	("StructureTypePhysicalDeviceShaderFloatControls2FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES_KHR}),
	("StructureTypePhysicalDeviceIndexTypeUint8FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_KHR}),
	("StructureTypePhysicalDeviceLineRasterizationFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_KHR}),
	("StructureTypePipelineRasterizationLineStateCreateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_KHR}),
	("StructureTypePhysicalDeviceLineRasterizationPropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_KHR}),
	("StructureTypePhysicalDeviceShaderExpectAssumeFeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES_KHR}),
	("StructureTypePhysicalDeviceMaintenance6FeaturesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES_KHR}),
	("StructureTypePhysicalDeviceMaintenance6PropertiesKhr",
		#{const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES_KHR}),
	("StructureTypeBindMemoryStatusKhr",
		#{const VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS_KHR}),
	("StructureTypeBindDescriptorSetsInfoKhr",
		#{const VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO_KHR}),
	("StructureTypePushConstantsInfoKhr",
		#{const VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO_KHR}),
	("StructureTypePushDescriptorSetInfoKhr",
		#{const VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO_KHR}),
	("StructureTypePushDescriptorSetWithTemplateInfoKhr",
		#{const VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_WITH_TEMPLATE_INFO_KHR}),
	("StructureTypeMaxEnum", #{const VK_STRUCTURE_TYPE_MAX_ENUM}) ]

enum "SystemAllocationScope" ''#{type VkSystemAllocationScope}
		[''Show, ''Eq, ''Storable] [
	("SystemAllocationScopeCommand",
		#{const VK_SYSTEM_ALLOCATION_SCOPE_COMMAND}),
	("SystemAllocationScopeObject",
		#{const VK_SYSTEM_ALLOCATION_SCOPE_OBJECT}),
	("SystemAllocationScopeCache",
		#{const VK_SYSTEM_ALLOCATION_SCOPE_CACHE}),
	("SystemAllocationScopeDevice",
		#{const VK_SYSTEM_ALLOCATION_SCOPE_DEVICE}),
	("SystemAllocationScopeInstance",
		#{const VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE}),
	("SystemAllocationScopeMaxEnum",
		#{const VK_SYSTEM_ALLOCATION_SCOPE_MAX_ENUM}) ]

enum "InternalAllocationType" ''#{type VkInternalAllocationType}
		[''Show, ''Eq, ''Storable] [
	("InternalAllocationTypeExecutable",
		#{const VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE}),
	("InternalAllocationTypeMaxEnum",
		#{const VK_INTERNAL_ALLOCATION_TYPE_MAX_ENUM}) ]

enum "ObjectType" ''#{type VkObjectType}
		[''Show, ''Eq, ''Storable] [
	("ObjectTypeUnknown", #{const VK_OBJECT_TYPE_UNKNOWN}),
	("ObjectTypeInstance", #{const VK_OBJECT_TYPE_INSTANCE}),
	("ObjectTypePhysicalDevice", #{const VK_OBJECT_TYPE_PHYSICAL_DEVICE}),
	("ObjectTypeDevice", #{const VK_OBJECT_TYPE_DEVICE}),
	("ObjectTypeQueue", #{const VK_OBJECT_TYPE_QUEUE}),
	("ObjectTypeSemaphore", #{const VK_OBJECT_TYPE_SEMAPHORE}),
	("ObjectTypeCommandBuffer", #{const VK_OBJECT_TYPE_COMMAND_BUFFER}),
	("ObjectTypeFence", #{const VK_OBJECT_TYPE_FENCE}),
	("ObjectTypeDeviceMemory", #{const VK_OBJECT_TYPE_DEVICE_MEMORY}),
	("ObjectTypeBuffer", #{const VK_OBJECT_TYPE_BUFFER}),
	("ObjectTypeImage", #{const VK_OBJECT_TYPE_IMAGE}),
	("ObjectTypeEvent", #{const VK_OBJECT_TYPE_EVENT}),
	("ObjectTypeQueryPool", #{const VK_OBJECT_TYPE_QUERY_POOL}),
	("ObjectTypeBufferView", #{const VK_OBJECT_TYPE_BUFFER_VIEW}),
	("ObjectTypeImageView", #{const VK_OBJECT_TYPE_IMAGE_VIEW}),
	("ObjectTypeShaderModule", #{const VK_OBJECT_TYPE_SHADER_MODULE}),
	("ObjectTypePipelineCache", #{const VK_OBJECT_TYPE_PIPELINE_CACHE}),
	("ObjectTypePipelineLayout", #{const VK_OBJECT_TYPE_PIPELINE_LAYOUT}),
	("ObjectTypeRenderPass", #{const VK_OBJECT_TYPE_RENDER_PASS}),
	("ObjectTypePipeline", #{const VK_OBJECT_TYPE_PIPELINE}),
	("ObjectTypeDescriptorSetLayout",
		#{const VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT}),
	("ObjectTypeSampler", #{const VK_OBJECT_TYPE_SAMPLER}),
	("ObjectTypeDescriptorPool", #{const VK_OBJECT_TYPE_DESCRIPTOR_POOL}),
	("ObjectTypeDescriptorSet", #{const VK_OBJECT_TYPE_DESCRIPTOR_SET}),
	("ObjectTypeFramebuffer", #{const VK_OBJECT_TYPE_FRAMEBUFFER}),
	("ObjectTypeCommandPool", #{const VK_OBJECT_TYPE_COMMAND_POOL}),
	("ObjectTypeSamplerYcbcrConversion",
		#{const VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION}),
	("ObjectTypeDescriptorUpdateTemplate",
		#{const VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE}),
	("ObjectTypePrivateDataSlot",
		#{const VK_OBJECT_TYPE_PRIVATE_DATA_SLOT}),
	("ObjectTypeSurfaceKhr", #{const VK_OBJECT_TYPE_SURFACE_KHR}),
	("ObjectTypeSwapchainKhr", #{const VK_OBJECT_TYPE_SWAPCHAIN_KHR}),
	("ObjectTypeDisplayKhr", #{const VK_OBJECT_TYPE_DISPLAY_KHR}),
	("ObjectTypeDisplayModeKhr", #{const VK_OBJECT_TYPE_DISPLAY_MODE_KHR}),
	("ObjectTypeDebugReportCallbackExt",
		#{const VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT}),
	("ObjectTypeVideoSessionKhr",
		#{const VK_OBJECT_TYPE_VIDEO_SESSION_KHR}),
	("ObjectTypeVideoSessionParametersKhr",
		#{const VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR}),
	("ObjectTypeCuModuleNvx", #{const VK_OBJECT_TYPE_CU_MODULE_NVX}),
	("ObjectTypeCuFunctionNvx", #{const VK_OBJECT_TYPE_CU_FUNCTION_NVX}),
	("ObjectTypeDebugUtilsMessengerExt",
		#{const VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT}),
	("ObjectTypeAccelerationStructureKhr",
		#{const VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR}),
	("ObjectTypeValidationCacheExt",
		#{const VK_OBJECT_TYPE_VALIDATION_CACHE_EXT}),
	("ObjectTypeAccelerationStructureNv",
		#{const VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV}),
	("ObjectTypePerformanceConfigurationIntel",
		#{const VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL}),
	("ObjectTypeDeferredOperationKhr",
		#{const VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR}),
	("ObjectTypeIndirectCommandsLayoutNv",
		#{const VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV}),
	("ObjectTypeBufferCollectionFuchsia",
		#{const VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA}),
	("ObjectTypeMicromapExt", #{const VK_OBJECT_TYPE_MICROMAP_EXT}),
	("ObjectTypeTensorArm", #{const VK_OBJECT_TYPE_TENSOR_ARM}),
	("ObjectTypeTensorViewArm", #{const VK_OBJECT_TYPE_TENSOR_VIEW_ARM}),
	("ObjectTypeOpticalFlowSessionNv",
		#{const VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV}),
	("ObjectTypeShaderExt", #{const VK_OBJECT_TYPE_SHADER_EXT}),
	("ObjectTypePipelineBinaryKhr",
		#{const VK_OBJECT_TYPE_PIPELINE_BINARY_KHR}),
	("ObjectTypeDataGraphPipelineSessionArm",
		#{const VK_OBJECT_TYPE_DATA_GRAPH_PIPELINE_SESSION_ARM}),
	("ObjectTypeExternalComputeQueueNv",
		#{const VK_OBJECT_TYPE_EXTERNAL_COMPUTE_QUEUE_NV}),
	("ObjectTypeIndirectCommandsLayoutExt",
		#{const VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_EXT}),
	("ObjectTypeIndirectExecutionSetExt",
		#{const VK_OBJECT_TYPE_INDIRECT_EXECUTION_SET_EXT}),
	("ObjectTypeDescriptorUpdateTemplateKhr",
		#{const VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR}),
	("ObjectTypeSamplerYcbcrConversionKhr",
		#{const VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR}),
	("ObjectTypePrivateDataSlotExt",
		#{const VK_OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT}),
	("ObjectTypeMaxEnum", #{const VK_OBJECT_TYPE_MAX_ENUM}) ]

enum "SharingMode" ''#{type VkSharingMode}
		[''Show, ''Eq, ''Storable] [
	("SharingModeExclusive", #{const VK_SHARING_MODE_EXCLUSIVE}),
	("SharingModeConcurrent", #{const VK_SHARING_MODE_CONCURRENT}),
	("SharingModeMaxEnum", #{const VK_SHARING_MODE_MAX_ENUM}) ]

enum "PrimitiveTopology" ''#{type VkPrimitiveTopology}
		[''Show, ''Eq, ''Storable] [
	("PrimitiveTopologyPointList",
		#{const VK_PRIMITIVE_TOPOLOGY_POINT_LIST}),
	("PrimitiveTopologyLineList", #{const VK_PRIMITIVE_TOPOLOGY_LINE_LIST}),
	("PrimitiveTopologyLineStrip",
		#{const VK_PRIMITIVE_TOPOLOGY_LINE_STRIP}),
	("PrimitiveTopologyTriangleList",
		#{const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST}),
	("PrimitiveTopologyTriangleStrip",
		#{const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP}),
	("PrimitiveTopologyTriangleFan",
		#{const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN}),
	("PrimitiveTopologyLineListWithAdjacency",
		#{const VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY}),
	("PrimitiveTopologyLineStripWithAdjacency",
		#{const VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY}),
	("PrimitiveTopologyTriangleListWithAdjacency",
		#{const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY}),
	("PrimitiveTopologyTriangleStripWithAdjacency",
		#{const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY}),
	("PrimitiveTopologyPatchList",
		#{const VK_PRIMITIVE_TOPOLOGY_PATCH_LIST}),
	("PrimitiveTopologyMaxEnum", #{const VK_PRIMITIVE_TOPOLOGY_MAX_ENUM}) ]

enum "PolygonMode" ''#{type VkPolygonMode}
		[''Show, ''Eq, ''Storable] [
	("PolygonModeFill", #{const VK_POLYGON_MODE_FILL}),
	("PolygonModeLine", #{const VK_POLYGON_MODE_LINE}),
	("PolygonModePoint", #{const VK_POLYGON_MODE_POINT}),
	("PolygonModeFillRectangleNv",
		#{const VK_POLYGON_MODE_FILL_RECTANGLE_NV}),
	("PolygonModeMaxEnum", #{const VK_POLYGON_MODE_MAX_ENUM}) ]

enum "FrontFace" ''#{type VkFrontFace}
		[''Show, ''Eq, ''Storable] [
	("FrontFaceCounterClockwise", #{const VK_FRONT_FACE_COUNTER_CLOCKWISE}),
	("FrontFaceClockwise", #{const VK_FRONT_FACE_CLOCKWISE}),
	("FrontFaceMaxEnum", #{const VK_FRONT_FACE_MAX_ENUM}) ]

enum "CompareOp" ''#{type VkCompareOp}
		[''Show, ''Eq, ''Storable] [
	("CompareOpNever", #{const VK_COMPARE_OP_NEVER}),
	("CompareOpLess", #{const VK_COMPARE_OP_LESS}),
	("CompareOpEqual", #{const VK_COMPARE_OP_EQUAL}),
	("CompareOpLessOrEqual", #{const VK_COMPARE_OP_LESS_OR_EQUAL}),
	("CompareOpGreater", #{const VK_COMPARE_OP_GREATER}),
	("CompareOpNotEqual", #{const VK_COMPARE_OP_NOT_EQUAL}),
	("CompareOpGreaterOrEqual", #{const VK_COMPARE_OP_GREATER_OR_EQUAL}),
	("CompareOpAlways", #{const VK_COMPARE_OP_ALWAYS}),
	("CompareOpMaxEnum", #{const VK_COMPARE_OP_MAX_ENUM}) ]

enum "StencilOp" ''#{type VkStencilOp}
		[''Show, ''Eq, ''Storable] [
	("StencilOpKeep", #{const VK_STENCIL_OP_KEEP}),
	("StencilOpZero", #{const VK_STENCIL_OP_ZERO}),
	("StencilOpReplace", #{const VK_STENCIL_OP_REPLACE}),
	("StencilOpIncrementAndClamp",
		#{const VK_STENCIL_OP_INCREMENT_AND_CLAMP}),
	("StencilOpDecrementAndClamp",
		#{const VK_STENCIL_OP_DECREMENT_AND_CLAMP}),
	("StencilOpInvert", #{const VK_STENCIL_OP_INVERT}),
	("StencilOpIncrementAndWrap",
		#{const VK_STENCIL_OP_INCREMENT_AND_WRAP}),
	("StencilOpDecrementAndWrap",
		#{const VK_STENCIL_OP_DECREMENT_AND_WRAP}),
	("StencilOpMaxEnum", #{const VK_STENCIL_OP_MAX_ENUM}) ]

enum "BlendFactor" ''#{type VkBlendFactor}
		[''Show, ''Eq, ''Storable] [
	("BlendFactorZero", #{const VK_BLEND_FACTOR_ZERO}),
	("BlendFactorOne", #{const VK_BLEND_FACTOR_ONE}),
	("BlendFactorSrcColor", #{const VK_BLEND_FACTOR_SRC_COLOR}),
	("BlendFactorOneMinusSrcColor",
		#{const VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR}),
	("BlendFactorDstColor", #{const VK_BLEND_FACTOR_DST_COLOR}),
	("BlendFactorOneMinusDstColor",
		#{const VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR}),
	("BlendFactorSrcAlpha", #{const VK_BLEND_FACTOR_SRC_ALPHA}),
	("BlendFactorOneMinusSrcAlpha",
		#{const VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA}),
	("BlendFactorDstAlpha", #{const VK_BLEND_FACTOR_DST_ALPHA}),
	("BlendFactorOneMinusDstAlpha",
		#{const VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA}),
	("BlendFactorConstantColor", #{const VK_BLEND_FACTOR_CONSTANT_COLOR}),
	("BlendFactorOneMinusConstantColor",
		#{const VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR}),
	("BlendFactorConstantAlpha", #{const VK_BLEND_FACTOR_CONSTANT_ALPHA}),
	("BlendFactorOneMinusConstantAlpha",
		#{const VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA}),
	("BlendFactorSrcAlphaSaturate",
		#{const VK_BLEND_FACTOR_SRC_ALPHA_SATURATE}),
	("BlendFactorSrc1Color", #{const VK_BLEND_FACTOR_SRC1_COLOR}),
	("BlendFactorOneMinusSrc1Color",
		#{const VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR}),
	("BlendFactorSrc1Alpha", #{const VK_BLEND_FACTOR_SRC1_ALPHA}),
	("BlendFactorOneMinusSrc1Alpha",
		#{const VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA}),
	("BlendFactorMaxEnum", #{const VK_BLEND_FACTOR_MAX_ENUM}) ]

enum "BlendOp" ''#{type VkBlendOp}
		[''Show, ''Eq, ''Storable] [
	("BlendOpAdd", #{const VK_BLEND_OP_ADD}),
	("BlendOpSubtract", #{const VK_BLEND_OP_SUBTRACT}),
	("BlendOpReverseSubtract", #{const VK_BLEND_OP_REVERSE_SUBTRACT}),
	("BlendOpMin", #{const VK_BLEND_OP_MIN}),
	("BlendOpMax", #{const VK_BLEND_OP_MAX}),
	("BlendOpZeroExt", #{const VK_BLEND_OP_ZERO_EXT}),
	("BlendOpSrcExt", #{const VK_BLEND_OP_SRC_EXT}),
	("BlendOpDstExt", #{const VK_BLEND_OP_DST_EXT}),
	("BlendOpSrcOverExt", #{const VK_BLEND_OP_SRC_OVER_EXT}),
	("BlendOpDstOverExt", #{const VK_BLEND_OP_DST_OVER_EXT}),
	("BlendOpSrcInExt", #{const VK_BLEND_OP_SRC_IN_EXT}),
	("BlendOpDstInExt", #{const VK_BLEND_OP_DST_IN_EXT}),
	("BlendOpSrcOutExt", #{const VK_BLEND_OP_SRC_OUT_EXT}),
	("BlendOpDstOutExt", #{const VK_BLEND_OP_DST_OUT_EXT}),
	("BlendOpSrcAtopExt", #{const VK_BLEND_OP_SRC_ATOP_EXT}),
	("BlendOpDstAtopExt", #{const VK_BLEND_OP_DST_ATOP_EXT}),
	("BlendOpXorExt", #{const VK_BLEND_OP_XOR_EXT}),
	("BlendOpMultiplyExt", #{const VK_BLEND_OP_MULTIPLY_EXT}),
	("BlendOpScreenExt", #{const VK_BLEND_OP_SCREEN_EXT}),
	("BlendOpOverlayExt", #{const VK_BLEND_OP_OVERLAY_EXT}),
	("BlendOpDarkenExt", #{const VK_BLEND_OP_DARKEN_EXT}),
	("BlendOpLightenExt", #{const VK_BLEND_OP_LIGHTEN_EXT}),
	("BlendOpColordodgeExt", #{const VK_BLEND_OP_COLORDODGE_EXT}),
	("BlendOpColorburnExt", #{const VK_BLEND_OP_COLORBURN_EXT}),
	("BlendOpHardlightExt", #{const VK_BLEND_OP_HARDLIGHT_EXT}),
	("BlendOpSoftlightExt", #{const VK_BLEND_OP_SOFTLIGHT_EXT}),
	("BlendOpDifferenceExt", #{const VK_BLEND_OP_DIFFERENCE_EXT}),
	("BlendOpExclusionExt", #{const VK_BLEND_OP_EXCLUSION_EXT}),
	("BlendOpInvertExt", #{const VK_BLEND_OP_INVERT_EXT}),
	("BlendOpInvertRgbExt", #{const VK_BLEND_OP_INVERT_RGB_EXT}),
	("BlendOpLineardodgeExt", #{const VK_BLEND_OP_LINEARDODGE_EXT}),
	("BlendOpLinearburnExt", #{const VK_BLEND_OP_LINEARBURN_EXT}),
	("BlendOpVividlightExt", #{const VK_BLEND_OP_VIVIDLIGHT_EXT}),
	("BlendOpLinearlightExt", #{const VK_BLEND_OP_LINEARLIGHT_EXT}),
	("BlendOpPinlightExt", #{const VK_BLEND_OP_PINLIGHT_EXT}),
	("BlendOpHardmixExt", #{const VK_BLEND_OP_HARDMIX_EXT}),
	("BlendOpHslHueExt", #{const VK_BLEND_OP_HSL_HUE_EXT}),
	("BlendOpHslSaturationExt", #{const VK_BLEND_OP_HSL_SATURATION_EXT}),
	("BlendOpHslColorExt", #{const VK_BLEND_OP_HSL_COLOR_EXT}),
	("BlendOpHslLuminosityExt", #{const VK_BLEND_OP_HSL_LUMINOSITY_EXT}),
	("BlendOpPlusExt", #{const VK_BLEND_OP_PLUS_EXT}),
	("BlendOpPlusClampedExt", #{const VK_BLEND_OP_PLUS_CLAMPED_EXT}),
	("BlendOpPlusClampedAlphaExt",
		#{const VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT}),
	("BlendOpPlusDarkerExt", #{const VK_BLEND_OP_PLUS_DARKER_EXT}),
	("BlendOpMinusExt", #{const VK_BLEND_OP_MINUS_EXT}),
	("BlendOpMinusClampedExt", #{const VK_BLEND_OP_MINUS_CLAMPED_EXT}),
	("BlendOpContrastExt", #{const VK_BLEND_OP_CONTRAST_EXT}),
	("BlendOpInvertOvgExt", #{const VK_BLEND_OP_INVERT_OVG_EXT}),
	("BlendOpRedExt", #{const VK_BLEND_OP_RED_EXT}),
	("BlendOpGreenExt", #{const VK_BLEND_OP_GREEN_EXT}),
	("BlendOpBlueExt", #{const VK_BLEND_OP_BLUE_EXT}),
	("BlendOpMaxEnum", #{const VK_BLEND_OP_MAX_ENUM}) ]

enum "LogicOp" ''#{type VkLogicOp}
		[''Show, ''Eq, ''Storable] [
	("LogicOpClear", #{const VK_LOGIC_OP_CLEAR}),
	("LogicOpAnd", #{const VK_LOGIC_OP_AND}),
	("LogicOpAndReverse", #{const VK_LOGIC_OP_AND_REVERSE}),
	("LogicOpCopy", #{const VK_LOGIC_OP_COPY}),
	("LogicOpAndInverted", #{const VK_LOGIC_OP_AND_INVERTED}),
	("LogicOpNoOp", #{const VK_LOGIC_OP_NO_OP}),
	("LogicOpXor", #{const VK_LOGIC_OP_XOR}),
	("LogicOpOr", #{const VK_LOGIC_OP_OR}),
	("LogicOpNor", #{const VK_LOGIC_OP_NOR}),
	("LogicOpEquivalent", #{const VK_LOGIC_OP_EQUIVALENT}),
	("LogicOpInvert", #{const VK_LOGIC_OP_INVERT}),
	("LogicOpOrReverse", #{const VK_LOGIC_OP_OR_REVERSE}),
	("LogicOpCopyInverted", #{const VK_LOGIC_OP_COPY_INVERTED}),
	("LogicOpOrInverted", #{const VK_LOGIC_OP_OR_INVERTED}),
	("LogicOpNand", #{const VK_LOGIC_OP_NAND}),
	("LogicOpSet", #{const VK_LOGIC_OP_SET}),
	("LogicOpMaxEnum", #{const VK_LOGIC_OP_MAX_ENUM}) ]

enum "DynamicState" ''#{type VkDynamicState}
		[''Show, ''Eq, ''Storable] [
	("DynamicStateViewport", #{const VK_DYNAMIC_STATE_VIEWPORT}),
	("DynamicStateScissor", #{const VK_DYNAMIC_STATE_SCISSOR}),
	("DynamicStateLineWidth", #{const VK_DYNAMIC_STATE_LINE_WIDTH}),
	("DynamicStateDepthBias", #{const VK_DYNAMIC_STATE_DEPTH_BIAS}),
	("DynamicStateBlendConstants",
		#{const VK_DYNAMIC_STATE_BLEND_CONSTANTS}),
	("DynamicStateDepthBounds", #{const VK_DYNAMIC_STATE_DEPTH_BOUNDS}),
	("DynamicStateStencilCompareMask",
		#{const VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK}),
	("DynamicStateStencilWriteMask",
		#{const VK_DYNAMIC_STATE_STENCIL_WRITE_MASK}),
	("DynamicStateStencilReference",
		#{const VK_DYNAMIC_STATE_STENCIL_REFERENCE}),
	("DynamicStateCullMode", #{const VK_DYNAMIC_STATE_CULL_MODE}),
	("DynamicStateFrontFace", #{const VK_DYNAMIC_STATE_FRONT_FACE}),
	("DynamicStatePrimitiveTopology",
		#{const VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY}),
	("DynamicStateViewportWithCount",
		#{const VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT}),
	("DynamicStateScissorWithCount",
		#{const VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT}),
	("DynamicStateVertexInputBindingStride",
		#{const VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE}),
	("DynamicStateDepthTestEnable",
		#{const VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE}),
	("DynamicStateDepthWriteEnable",
		#{const VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE}),
	("DynamicStateDepthCompareOp",
		#{const VK_DYNAMIC_STATE_DEPTH_COMPARE_OP}),
	("DynamicStateDepthBoundsTestEnable",
		#{const VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE}),
	("DynamicStateStencilTestEnable",
		#{const VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE}),
	("DynamicStateStencilOp", #{const VK_DYNAMIC_STATE_STENCIL_OP}),
	("DynamicStateRasterizerDiscardEnable",
		#{const VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE}),
	("DynamicStateDepthBiasEnable",
		#{const VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE}),
	("DynamicStatePrimitiveRestartEnable",
		#{const VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE}),
	("DynamicStateLineStipple", #{const VK_DYNAMIC_STATE_LINE_STIPPLE}),
	("DynamicStateViewportWScalingNv",
		#{const VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV}),
	("DynamicStateDiscardRectangleExt",
		#{const VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT}),
	("DynamicStateDiscardRectangleEnableExt",
		#{const VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT}),
	("DynamicStateDiscardRectangleModeExt",
		#{const VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT}),
	("DynamicStateSampleLocationsExt",
		#{const VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT}),
	("DynamicStateRayTracingPipelineStackSizeKhr",
		#{const VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR}),
	("DynamicStateViewportShadingRatePaletteNv",
		#{const VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV}),
	("DynamicStateViewportCoarseSampleOrderNv",
		#{const VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV}),
	("DynamicStateExclusiveScissorEnableNv",
		#{const VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV}),
	("DynamicStateExclusiveScissorNv",
		#{const VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV}),
	("DynamicStateFragmentShadingRateKhr",
		#{const VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR}),
	("DynamicStateVertexInputExt",
		#{const VK_DYNAMIC_STATE_VERTEX_INPUT_EXT}),
	("DynamicStatePatchControlPointsExt",
		#{const VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT}),
	("DynamicStateLogicOpExt", #{const VK_DYNAMIC_STATE_LOGIC_OP_EXT}),
	("DynamicStateColorWriteEnableExt",
		#{const VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT}),
	("DynamicStateDepthClampEnableExt",
		#{const VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT}),
	("DynamicStatePolygonModeExt",
		#{const VK_DYNAMIC_STATE_POLYGON_MODE_EXT}),
	("DynamicStateRasterizationSamplesExt",
		#{const VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT}),
	("DynamicStateSampleMaskExt",
		#{const VK_DYNAMIC_STATE_SAMPLE_MASK_EXT}),
	("DynamicStateAlphaToCoverageEnableExt",
		#{const VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT}),
	("DynamicStateAlphaToOneEnableExt",
		#{const VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT}),
	("DynamicStateLogicOpEnableExt",
		#{const VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT}),
	("DynamicStateColorBlendEnableExt",
		#{const VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT}),
	("DynamicStateColorBlendEquationExt",
		#{const VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT}),
	("DynamicStateColorWriteMaskExt",
		#{const VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT}),
	("DynamicStateTessellationDomainOriginExt",
		#{const VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT}),
	("DynamicStateRasterizationStreamExt",
		#{const VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT}),
	("DynamicStateConservativeRasterizationModeExt",
		#{const VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT}),
	("DynamicStateExtraPrimitiveOverestimationSizeExt",
		#{const VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT}),
	("DynamicStateDepthClipEnableExt",
		#{const VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT}),
	("DynamicStateSampleLocationsEnableExt",
		#{const VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT}),
	("DynamicStateColorBlendAdvancedExt",
		#{const VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT}),
	("DynamicStateProvokingVertexModeExt",
		#{const VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT}),
	("DynamicStateLineRasterizationModeExt",
		#{const VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT}),
	("DynamicStateLineStippleEnableExt",
		#{const VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT}),
	("DynamicStateDepthClipNegativeOneToOneExt",
		#{const VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT}),
	("DynamicStateViewportWScalingEnableNv",
		#{const VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV}),
	("DynamicStateViewportSwizzleNv",
		#{const VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV}),
	("DynamicStateCoverageToColorEnableNv",
		#{const VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV}),
	("DynamicStateCoverageToColorLocationNv",
		#{const VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV}),
	("DynamicStateCoverageModulationModeNv",
		#{const VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV}),
	("DynamicStateCoverageModulationTableEnableNv",
		#{const VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV}),
	("DynamicStateCoverageModulationTableNv",
		#{const VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV}),
	("DynamicStateShadingRateImageEnableNv",
		#{const VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV}),
	("DynamicStateRepresentativeFragmentTestEnableNv",
		#{const VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV}),
	("DynamicStateCoverageReductionModeNv",
		#{const VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV}),
	("DynamicStateAttachmentFeedbackLoopEnableExt",
		#{const VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT}),
	("DynamicStateDepthClampRangeExt",
		#{const VK_DYNAMIC_STATE_DEPTH_CLAMP_RANGE_EXT}),
	("DynamicStateLineStippleExt",
		#{const VK_DYNAMIC_STATE_LINE_STIPPLE_EXT}),
	("DynamicStateCullModeExt", #{const VK_DYNAMIC_STATE_CULL_MODE_EXT}),
	("DynamicStateFrontFaceExt", #{const VK_DYNAMIC_STATE_FRONT_FACE_EXT}),
	("DynamicStatePrimitiveTopologyExt",
		#{const VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT}),
	("DynamicStateViewportWithCountExt",
		#{const VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT}),
	("DynamicStateScissorWithCountExt",
		#{const VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT}),
	("DynamicStateVertexInputBindingStrideExt",
		#{const VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT}),
	("DynamicStateDepthTestEnableExt",
		#{const VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT}),
	("DynamicStateDepthWriteEnableExt",
		#{const VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT}),
	("DynamicStateDepthCompareOpExt",
		#{const VK_DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT}),
	("DynamicStateDepthBoundsTestEnableExt",
		#{const VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT}),
	("DynamicStateStencilTestEnableExt",
		#{const VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT}),
	("DynamicStateStencilOpExt", #{const VK_DYNAMIC_STATE_STENCIL_OP_EXT}),
	("DynamicStateRasterizerDiscardEnableExt",
		#{const VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT}),
	("DynamicStateDepthBiasEnableExt",
		#{const VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE_EXT}),
	("DynamicStatePrimitiveRestartEnableExt",
		#{const VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE_EXT}),
	("DynamicStateLineStippleKhr",
		#{const VK_DYNAMIC_STATE_LINE_STIPPLE_KHR}),
	("DynamicStateMaxEnum", #{const VK_DYNAMIC_STATE_MAX_ENUM}) ]

enum "IndexType" ''#{type VkIndexType}
		[''Show, ''Eq, ''Storable] [
	("IndexTypeUint16", #{const VK_INDEX_TYPE_UINT16}),
	("IndexTypeUint32", #{const VK_INDEX_TYPE_UINT32}),
	("IndexTypeUint8", #{const VK_INDEX_TYPE_UINT8}),
	("IndexTypeNoneKhr", #{const VK_INDEX_TYPE_NONE_KHR}),
	("IndexTypeNoneNv", #{const VK_INDEX_TYPE_NONE_NV}),
	("IndexTypeUint8Ext", #{const VK_INDEX_TYPE_UINT8_EXT}),
	("IndexTypeUint8Khr", #{const VK_INDEX_TYPE_UINT8_KHR}),
	("IndexTypeMaxEnum", #{const VK_INDEX_TYPE_MAX_ENUM}) ]

enum "Filter" ''#{type VkFilter}
		[''Show, ''Eq, ''Storable] [
	("FilterNearest", #{const VK_FILTER_NEAREST}),
	("FilterLinear", #{const VK_FILTER_LINEAR}),
	("FilterCubicExt", #{const VK_FILTER_CUBIC_EXT}),
	("FilterCubicImg", #{const VK_FILTER_CUBIC_IMG}),
	("FilterMaxEnum", #{const VK_FILTER_MAX_ENUM}) ]

enum "BorderColor" ''#{type VkBorderColor}
		[''Show, ''Eq, ''Storable] [
	("BorderColorFloatTransparentBlack",
		#{const VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK}),
	("BorderColorIntTransparentBlack",
		#{const VK_BORDER_COLOR_INT_TRANSPARENT_BLACK}),
	("BorderColorFloatOpaqueBlack",
		#{const VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK}),
	("BorderColorIntOpaqueBlack",
		#{const VK_BORDER_COLOR_INT_OPAQUE_BLACK}),
	("BorderColorFloatOpaqueWhite",
		#{const VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE}),
	("BorderColorIntOpaqueWhite",
		#{const VK_BORDER_COLOR_INT_OPAQUE_WHITE}),
	("BorderColorFloatCustomExt",
		#{const VK_BORDER_COLOR_FLOAT_CUSTOM_EXT}),
	("BorderColorIntCustomExt", #{const VK_BORDER_COLOR_INT_CUSTOM_EXT}),
	("BorderColorMaxEnum", #{const VK_BORDER_COLOR_MAX_ENUM}) ]

enum "Format" ''#{type VkFormat}
		[''Show, ''Eq, ''Storable] [
	("FormatUndefined", #{const VK_FORMAT_UNDEFINED}),
	("FormatR4g4UnormPack8", #{const VK_FORMAT_R4G4_UNORM_PACK8}),
	("FormatR4g4b4a4UnormPack16", #{const VK_FORMAT_R4G4B4A4_UNORM_PACK16}),
	("FormatB4g4r4a4UnormPack16", #{const VK_FORMAT_B4G4R4A4_UNORM_PACK16}),
	("FormatR5g6b5UnormPack16", #{const VK_FORMAT_R5G6B5_UNORM_PACK16}),
	("FormatB5g6r5UnormPack16", #{const VK_FORMAT_B5G6R5_UNORM_PACK16}),
	("FormatR5g5b5a1UnormPack16", #{const VK_FORMAT_R5G5B5A1_UNORM_PACK16}),
	("FormatB5g5r5a1UnormPack16", #{const VK_FORMAT_B5G5R5A1_UNORM_PACK16}),
	("FormatA1r5g5b5UnormPack16", #{const VK_FORMAT_A1R5G5B5_UNORM_PACK16}),
	("FormatR8Unorm", #{const VK_FORMAT_R8_UNORM}),
	("FormatR8Snorm", #{const VK_FORMAT_R8_SNORM}),
	("FormatR8Uscaled", #{const VK_FORMAT_R8_USCALED}),
	("FormatR8Sscaled", #{const VK_FORMAT_R8_SSCALED}),
	("FormatR8Uint", #{const VK_FORMAT_R8_UINT}),
	("FormatR8Sint", #{const VK_FORMAT_R8_SINT}),
	("FormatR8Srgb", #{const VK_FORMAT_R8_SRGB}),
	("FormatR8g8Unorm", #{const VK_FORMAT_R8G8_UNORM}),
	("FormatR8g8Snorm", #{const VK_FORMAT_R8G8_SNORM}),
	("FormatR8g8Uscaled", #{const VK_FORMAT_R8G8_USCALED}),
	("FormatR8g8Sscaled", #{const VK_FORMAT_R8G8_SSCALED}),
	("FormatR8g8Uint", #{const VK_FORMAT_R8G8_UINT}),
	("FormatR8g8Sint", #{const VK_FORMAT_R8G8_SINT}),
	("FormatR8g8Srgb", #{const VK_FORMAT_R8G8_SRGB}),
	("FormatR8g8b8Unorm", #{const VK_FORMAT_R8G8B8_UNORM}),
	("FormatR8g8b8Snorm", #{const VK_FORMAT_R8G8B8_SNORM}),
	("FormatR8g8b8Uscaled", #{const VK_FORMAT_R8G8B8_USCALED}),
	("FormatR8g8b8Sscaled", #{const VK_FORMAT_R8G8B8_SSCALED}),
	("FormatR8g8b8Uint", #{const VK_FORMAT_R8G8B8_UINT}),
	("FormatR8g8b8Sint", #{const VK_FORMAT_R8G8B8_SINT}),
	("FormatR8g8b8Srgb", #{const VK_FORMAT_R8G8B8_SRGB}),
	("FormatB8g8r8Unorm", #{const VK_FORMAT_B8G8R8_UNORM}),
	("FormatB8g8r8Snorm", #{const VK_FORMAT_B8G8R8_SNORM}),
	("FormatB8g8r8Uscaled", #{const VK_FORMAT_B8G8R8_USCALED}),
	("FormatB8g8r8Sscaled", #{const VK_FORMAT_B8G8R8_SSCALED}),
	("FormatB8g8r8Uint", #{const VK_FORMAT_B8G8R8_UINT}),
	("FormatB8g8r8Sint", #{const VK_FORMAT_B8G8R8_SINT}),
	("FormatB8g8r8Srgb", #{const VK_FORMAT_B8G8R8_SRGB}),
	("FormatR8g8b8a8Unorm", #{const VK_FORMAT_R8G8B8A8_UNORM}),
	("FormatR8g8b8a8Snorm", #{const VK_FORMAT_R8G8B8A8_SNORM}),
	("FormatR8g8b8a8Uscaled", #{const VK_FORMAT_R8G8B8A8_USCALED}),
	("FormatR8g8b8a8Sscaled", #{const VK_FORMAT_R8G8B8A8_SSCALED}),
	("FormatR8g8b8a8Uint", #{const VK_FORMAT_R8G8B8A8_UINT}),
	("FormatR8g8b8a8Sint", #{const VK_FORMAT_R8G8B8A8_SINT}),
	("FormatR8g8b8a8Srgb", #{const VK_FORMAT_R8G8B8A8_SRGB}),
	("FormatB8g8r8a8Unorm", #{const VK_FORMAT_B8G8R8A8_UNORM}),
	("FormatB8g8r8a8Snorm", #{const VK_FORMAT_B8G8R8A8_SNORM}),
	("FormatB8g8r8a8Uscaled", #{const VK_FORMAT_B8G8R8A8_USCALED}),
	("FormatB8g8r8a8Sscaled", #{const VK_FORMAT_B8G8R8A8_SSCALED}),
	("FormatB8g8r8a8Uint", #{const VK_FORMAT_B8G8R8A8_UINT}),
	("FormatB8g8r8a8Sint", #{const VK_FORMAT_B8G8R8A8_SINT}),
	("FormatB8g8r8a8Srgb", #{const VK_FORMAT_B8G8R8A8_SRGB}),
	("FormatA8b8g8r8UnormPack32", #{const VK_FORMAT_A8B8G8R8_UNORM_PACK32}),
	("FormatA8b8g8r8SnormPack32", #{const VK_FORMAT_A8B8G8R8_SNORM_PACK32}),
	("FormatA8b8g8r8UscaledPack32",
		#{const VK_FORMAT_A8B8G8R8_USCALED_PACK32}),
	("FormatA8b8g8r8SscaledPack32",
		#{const VK_FORMAT_A8B8G8R8_SSCALED_PACK32}),
	("FormatA8b8g8r8UintPack32", #{const VK_FORMAT_A8B8G8R8_UINT_PACK32}),
	("FormatA8b8g8r8SintPack32", #{const VK_FORMAT_A8B8G8R8_SINT_PACK32}),
	("FormatA8b8g8r8SrgbPack32", #{const VK_FORMAT_A8B8G8R8_SRGB_PACK32}),
	("FormatA2r10g10b10UnormPack32",
		#{const VK_FORMAT_A2R10G10B10_UNORM_PACK32}),
	("FormatA2r10g10b10SnormPack32",
		#{const VK_FORMAT_A2R10G10B10_SNORM_PACK32}),
	("FormatA2r10g10b10UscaledPack32",
		#{const VK_FORMAT_A2R10G10B10_USCALED_PACK32}),
	("FormatA2r10g10b10SscaledPack32",
		#{const VK_FORMAT_A2R10G10B10_SSCALED_PACK32}),
	("FormatA2r10g10b10UintPack32",
		#{const VK_FORMAT_A2R10G10B10_UINT_PACK32}),
	("FormatA2r10g10b10SintPack32",
		#{const VK_FORMAT_A2R10G10B10_SINT_PACK32}),
	("FormatA2b10g10r10UnormPack32",
		#{const VK_FORMAT_A2B10G10R10_UNORM_PACK32}),
	("FormatA2b10g10r10SnormPack32",
		#{const VK_FORMAT_A2B10G10R10_SNORM_PACK32}),
	("FormatA2b10g10r10UscaledPack32",
		#{const VK_FORMAT_A2B10G10R10_USCALED_PACK32}),
	("FormatA2b10g10r10SscaledPack32",
		#{const VK_FORMAT_A2B10G10R10_SSCALED_PACK32}),
	("FormatA2b10g10r10UintPack32",
		#{const VK_FORMAT_A2B10G10R10_UINT_PACK32}),
	("FormatA2b10g10r10SintPack32",
		#{const VK_FORMAT_A2B10G10R10_SINT_PACK32}),
	("FormatR16Unorm", #{const VK_FORMAT_R16_UNORM}),
	("FormatR16Snorm", #{const VK_FORMAT_R16_SNORM}),
	("FormatR16Uscaled", #{const VK_FORMAT_R16_USCALED}),
	("FormatR16Sscaled", #{const VK_FORMAT_R16_SSCALED}),
	("FormatR16Uint", #{const VK_FORMAT_R16_UINT}),
	("FormatR16Sint", #{const VK_FORMAT_R16_SINT}),
	("FormatR16Sfloat", #{const VK_FORMAT_R16_SFLOAT}),
	("FormatR16g16Unorm", #{const VK_FORMAT_R16G16_UNORM}),
	("FormatR16g16Snorm", #{const VK_FORMAT_R16G16_SNORM}),
	("FormatR16g16Uscaled", #{const VK_FORMAT_R16G16_USCALED}),
	("FormatR16g16Sscaled", #{const VK_FORMAT_R16G16_SSCALED}),
	("FormatR16g16Uint", #{const VK_FORMAT_R16G16_UINT}),
	("FormatR16g16Sint", #{const VK_FORMAT_R16G16_SINT}),
	("FormatR16g16Sfloat", #{const VK_FORMAT_R16G16_SFLOAT}),
	("FormatR16g16b16Unorm", #{const VK_FORMAT_R16G16B16_UNORM}),
	("FormatR16g16b16Snorm", #{const VK_FORMAT_R16G16B16_SNORM}),
	("FormatR16g16b16Uscaled", #{const VK_FORMAT_R16G16B16_USCALED}),
	("FormatR16g16b16Sscaled", #{const VK_FORMAT_R16G16B16_SSCALED}),
	("FormatR16g16b16Uint", #{const VK_FORMAT_R16G16B16_UINT}),
	("FormatR16g16b16Sint", #{const VK_FORMAT_R16G16B16_SINT}),
	("FormatR16g16b16Sfloat", #{const VK_FORMAT_R16G16B16_SFLOAT}),
	("FormatR16g16b16a16Unorm", #{const VK_FORMAT_R16G16B16A16_UNORM}),
	("FormatR16g16b16a16Snorm", #{const VK_FORMAT_R16G16B16A16_SNORM}),
	("FormatR16g16b16a16Uscaled", #{const VK_FORMAT_R16G16B16A16_USCALED}),
	("FormatR16g16b16a16Sscaled", #{const VK_FORMAT_R16G16B16A16_SSCALED}),
	("FormatR16g16b16a16Uint", #{const VK_FORMAT_R16G16B16A16_UINT}),
	("FormatR16g16b16a16Sint", #{const VK_FORMAT_R16G16B16A16_SINT}),
	("FormatR16g16b16a16Sfloat", #{const VK_FORMAT_R16G16B16A16_SFLOAT}),
	("FormatR32Uint", #{const VK_FORMAT_R32_UINT}),
	("FormatR32Sint", #{const VK_FORMAT_R32_SINT}),
	("FormatR32Sfloat", #{const VK_FORMAT_R32_SFLOAT}),
	("FormatR32g32Uint", #{const VK_FORMAT_R32G32_UINT}),
	("FormatR32g32Sint", #{const VK_FORMAT_R32G32_SINT}),
	("FormatR32g32Sfloat", #{const VK_FORMAT_R32G32_SFLOAT}),
	("FormatR32g32b32Uint", #{const VK_FORMAT_R32G32B32_UINT}),
	("FormatR32g32b32Sint", #{const VK_FORMAT_R32G32B32_SINT}),
	("FormatR32g32b32Sfloat", #{const VK_FORMAT_R32G32B32_SFLOAT}),
	("FormatR32g32b32a32Uint", #{const VK_FORMAT_R32G32B32A32_UINT}),
	("FormatR32g32b32a32Sint", #{const VK_FORMAT_R32G32B32A32_SINT}),
	("FormatR32g32b32a32Sfloat", #{const VK_FORMAT_R32G32B32A32_SFLOAT}),
	("FormatR64Uint", #{const VK_FORMAT_R64_UINT}),
	("FormatR64Sint", #{const VK_FORMAT_R64_SINT}),
	("FormatR64Sfloat", #{const VK_FORMAT_R64_SFLOAT}),
	("FormatR64g64Uint", #{const VK_FORMAT_R64G64_UINT}),
	("FormatR64g64Sint", #{const VK_FORMAT_R64G64_SINT}),
	("FormatR64g64Sfloat", #{const VK_FORMAT_R64G64_SFLOAT}),
	("FormatR64g64b64Uint", #{const VK_FORMAT_R64G64B64_UINT}),
	("FormatR64g64b64Sint", #{const VK_FORMAT_R64G64B64_SINT}),
	("FormatR64g64b64Sfloat", #{const VK_FORMAT_R64G64B64_SFLOAT}),
	("FormatR64g64b64a64Uint", #{const VK_FORMAT_R64G64B64A64_UINT}),
	("FormatR64g64b64a64Sint", #{const VK_FORMAT_R64G64B64A64_SINT}),
	("FormatR64g64b64a64Sfloat", #{const VK_FORMAT_R64G64B64A64_SFLOAT}),
	("FormatB10g11r11UfloatPack32",
		#{const VK_FORMAT_B10G11R11_UFLOAT_PACK32}),
	("FormatE5b9g9r9UfloatPack32",
		#{const VK_FORMAT_E5B9G9R9_UFLOAT_PACK32}),
	("FormatD16Unorm", #{const VK_FORMAT_D16_UNORM}),
	("FormatX8D24UnormPack32", #{const VK_FORMAT_X8_D24_UNORM_PACK32}),
	("FormatD32Sfloat", #{const VK_FORMAT_D32_SFLOAT}),
	("FormatS8Uint", #{const VK_FORMAT_S8_UINT}),
	("FormatD16UnormS8Uint", #{const VK_FORMAT_D16_UNORM_S8_UINT}),
	("FormatD24UnormS8Uint", #{const VK_FORMAT_D24_UNORM_S8_UINT}),
	("FormatD32SfloatS8Uint", #{const VK_FORMAT_D32_SFLOAT_S8_UINT}),
	("FormatBc1RgbUnormBlock", #{const VK_FORMAT_BC1_RGB_UNORM_BLOCK}),
	("FormatBc1RgbSrgbBlock", #{const VK_FORMAT_BC1_RGB_SRGB_BLOCK}),
	("FormatBc1RgbaUnormBlock", #{const VK_FORMAT_BC1_RGBA_UNORM_BLOCK}),
	("FormatBc1RgbaSrgbBlock", #{const VK_FORMAT_BC1_RGBA_SRGB_BLOCK}),
	("FormatBc2UnormBlock", #{const VK_FORMAT_BC2_UNORM_BLOCK}),
	("FormatBc2SrgbBlock", #{const VK_FORMAT_BC2_SRGB_BLOCK}),
	("FormatBc3UnormBlock", #{const VK_FORMAT_BC3_UNORM_BLOCK}),
	("FormatBc3SrgbBlock", #{const VK_FORMAT_BC3_SRGB_BLOCK}),
	("FormatBc4UnormBlock", #{const VK_FORMAT_BC4_UNORM_BLOCK}),
	("FormatBc4SnormBlock", #{const VK_FORMAT_BC4_SNORM_BLOCK}),
	("FormatBc5UnormBlock", #{const VK_FORMAT_BC5_UNORM_BLOCK}),
	("FormatBc5SnormBlock", #{const VK_FORMAT_BC5_SNORM_BLOCK}),
	("FormatBc6hUfloatBlock", #{const VK_FORMAT_BC6H_UFLOAT_BLOCK}),
	("FormatBc6hSfloatBlock", #{const VK_FORMAT_BC6H_SFLOAT_BLOCK}),
	("FormatBc7UnormBlock", #{const VK_FORMAT_BC7_UNORM_BLOCK}),
	("FormatBc7SrgbBlock", #{const VK_FORMAT_BC7_SRGB_BLOCK}),
	("FormatEtc2R8g8b8UnormBlock",
		#{const VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK}),
	("FormatEtc2R8g8b8SrgbBlock",
		#{const VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK}),
	("FormatEtc2R8g8b8a1UnormBlock",
		#{const VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK}),
	("FormatEtc2R8g8b8a1SrgbBlock",
		#{const VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK}),
	("FormatEtc2R8g8b8a8UnormBlock",
		#{const VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK}),
	("FormatEtc2R8g8b8a8SrgbBlock",
		#{const VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK}),
	("FormatEacR11UnormBlock", #{const VK_FORMAT_EAC_R11_UNORM_BLOCK}),
	("FormatEacR11SnormBlock", #{const VK_FORMAT_EAC_R11_SNORM_BLOCK}),
	("FormatEacR11g11UnormBlock",
		#{const VK_FORMAT_EAC_R11G11_UNORM_BLOCK}),
	("FormatEacR11g11SnormBlock",
		#{const VK_FORMAT_EAC_R11G11_SNORM_BLOCK}),
	("FormatAstc4x4UnormBlock", #{const VK_FORMAT_ASTC_4x4_UNORM_BLOCK}),
	("FormatAstc4x4SrgbBlock", #{const VK_FORMAT_ASTC_4x4_SRGB_BLOCK}),
	("FormatAstc5x4UnormBlock", #{const VK_FORMAT_ASTC_5x4_UNORM_BLOCK}),
	("FormatAstc5x4SrgbBlock", #{const VK_FORMAT_ASTC_5x4_SRGB_BLOCK}),
	("FormatAstc5x5UnormBlock", #{const VK_FORMAT_ASTC_5x5_UNORM_BLOCK}),
	("FormatAstc5x5SrgbBlock", #{const VK_FORMAT_ASTC_5x5_SRGB_BLOCK}),
	("FormatAstc6x5UnormBlock", #{const VK_FORMAT_ASTC_6x5_UNORM_BLOCK}),
	("FormatAstc6x5SrgbBlock", #{const VK_FORMAT_ASTC_6x5_SRGB_BLOCK}),
	("FormatAstc6x6UnormBlock", #{const VK_FORMAT_ASTC_6x6_UNORM_BLOCK}),
	("FormatAstc6x6SrgbBlock", #{const VK_FORMAT_ASTC_6x6_SRGB_BLOCK}),
	("FormatAstc8x5UnormBlock", #{const VK_FORMAT_ASTC_8x5_UNORM_BLOCK}),
	("FormatAstc8x5SrgbBlock", #{const VK_FORMAT_ASTC_8x5_SRGB_BLOCK}),
	("FormatAstc8x6UnormBlock", #{const VK_FORMAT_ASTC_8x6_UNORM_BLOCK}),
	("FormatAstc8x6SrgbBlock", #{const VK_FORMAT_ASTC_8x6_SRGB_BLOCK}),
	("FormatAstc8x8UnormBlock", #{const VK_FORMAT_ASTC_8x8_UNORM_BLOCK}),
	("FormatAstc8x8SrgbBlock", #{const VK_FORMAT_ASTC_8x8_SRGB_BLOCK}),
	("FormatAstc10x5UnormBlock", #{const VK_FORMAT_ASTC_10x5_UNORM_BLOCK}),
	("FormatAstc10x5SrgbBlock", #{const VK_FORMAT_ASTC_10x5_SRGB_BLOCK}),
	("FormatAstc10x6UnormBlock", #{const VK_FORMAT_ASTC_10x6_UNORM_BLOCK}),
	("FormatAstc10x6SrgbBlock", #{const VK_FORMAT_ASTC_10x6_SRGB_BLOCK}),
	("FormatAstc10x8UnormBlock", #{const VK_FORMAT_ASTC_10x8_UNORM_BLOCK}),
	("FormatAstc10x8SrgbBlock", #{const VK_FORMAT_ASTC_10x8_SRGB_BLOCK}),
	("FormatAstc10x10UnormBlock",
		#{const VK_FORMAT_ASTC_10x10_UNORM_BLOCK}),
	("FormatAstc10x10SrgbBlock", #{const VK_FORMAT_ASTC_10x10_SRGB_BLOCK}),
	("FormatAstc12x10UnormBlock",
		#{const VK_FORMAT_ASTC_12x10_UNORM_BLOCK}),
	("FormatAstc12x10SrgbBlock", #{const VK_FORMAT_ASTC_12x10_SRGB_BLOCK}),
	("FormatAstc12x12UnormBlock",
		#{const VK_FORMAT_ASTC_12x12_UNORM_BLOCK}),
	("FormatAstc12x12SrgbBlock", #{const VK_FORMAT_ASTC_12x12_SRGB_BLOCK}),
	("FormatG8b8g8r8422Unorm", #{const VK_FORMAT_G8B8G8R8_422_UNORM}),
	("FormatB8g8r8g8422Unorm", #{const VK_FORMAT_B8G8R8G8_422_UNORM}),
	("FormatG8B8R83plane420Unorm",
		#{const VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM}),
	("FormatG8B8r82plane420Unorm",
		#{const VK_FORMAT_G8_B8R8_2PLANE_420_UNORM}),
	("FormatG8B8R83plane422Unorm",
		#{const VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM}),
	("FormatG8B8r82plane422Unorm",
		#{const VK_FORMAT_G8_B8R8_2PLANE_422_UNORM}),
	("FormatG8B8R83plane444Unorm",
		#{const VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM}),
	("FormatR10x6UnormPack16", #{const VK_FORMAT_R10X6_UNORM_PACK16}),
	("FormatR10x6g10x6Unorm2pack16",
		#{const VK_FORMAT_R10X6G10X6_UNORM_2PACK16}),
	("FormatR10x6g10x6b10x6a10x6Unorm4pack16",
		#{const VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16}),
	("FormatG10x6b10x6g10x6r10x6422Unorm4pack16",
		#{const VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16}),
	("FormatB10x6g10x6r10x6g10x6422Unorm4pack16",
		#{const VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16}),
	("FormatG10x6B10x6R10x63plane420Unorm3pack16",
		#{const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16}),
	("FormatG10x6B10x6r10x62plane420Unorm3pack16",
		#{const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16}),
	("FormatG10x6B10x6R10x63plane422Unorm3pack16",
		#{const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16}),
	("FormatG10x6B10x6r10x62plane422Unorm3pack16",
		#{const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16}),
	("FormatG10x6B10x6R10x63plane444Unorm3pack16",
		#{const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16}),
	("FormatR12x4UnormPack16", #{const VK_FORMAT_R12X4_UNORM_PACK16}),
	("FormatR12x4g12x4Unorm2pack16",
		#{const VK_FORMAT_R12X4G12X4_UNORM_2PACK16}),
	("FormatR12x4g12x4b12x4a12x4Unorm4pack16",
		#{const VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16}),
	("FormatG12x4b12x4g12x4r12x4422Unorm4pack16",
		#{const VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16}),
	("FormatB12x4g12x4r12x4g12x4422Unorm4pack16",
		#{const VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16}),
	("FormatG12x4B12x4R12x43plane420Unorm3pack16",
		#{const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16}),
	("FormatG12x4B12x4r12x42plane420Unorm3pack16",
		#{const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16}),
	("FormatG12x4B12x4R12x43plane422Unorm3pack16",
		#{const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16}),
	("FormatG12x4B12x4r12x42plane422Unorm3pack16",
		#{const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16}),
	("FormatG12x4B12x4R12x43plane444Unorm3pack16",
		#{const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16}),
	("FormatG16b16g16r16422Unorm",
		#{const VK_FORMAT_G16B16G16R16_422_UNORM}),
	("FormatB16g16r16g16422Unorm",
		#{const VK_FORMAT_B16G16R16G16_422_UNORM}),
	("FormatG16B16R163plane420Unorm",
		#{const VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM}),
	("FormatG16B16r162plane420Unorm",
		#{const VK_FORMAT_G16_B16R16_2PLANE_420_UNORM}),
	("FormatG16B16R163plane422Unorm",
		#{const VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM}),
	("FormatG16B16r162plane422Unorm",
		#{const VK_FORMAT_G16_B16R16_2PLANE_422_UNORM}),
	("FormatG16B16R163plane444Unorm",
		#{const VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM}),
	("FormatG8B8r82plane444Unorm",
		#{const VK_FORMAT_G8_B8R8_2PLANE_444_UNORM}),
	("FormatG10x6B10x6r10x62plane444Unorm3pack16",
		#{const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16}),
	("FormatG12x4B12x4r12x42plane444Unorm3pack16",
		#{const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16}),
	("FormatG16B16r162plane444Unorm",
		#{const VK_FORMAT_G16_B16R16_2PLANE_444_UNORM}),
	("FormatA4r4g4b4UnormPack16", #{const VK_FORMAT_A4R4G4B4_UNORM_PACK16}),
	("FormatA4b4g4r4UnormPack16", #{const VK_FORMAT_A4B4G4R4_UNORM_PACK16}),
	("FormatAstc4x4SfloatBlock", #{const VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK}),
	("FormatAstc5x4SfloatBlock", #{const VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK}),
	("FormatAstc5x5SfloatBlock", #{const VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK}),
	("FormatAstc6x5SfloatBlock", #{const VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK}),
	("FormatAstc6x6SfloatBlock", #{const VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK}),
	("FormatAstc8x5SfloatBlock", #{const VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK}),
	("FormatAstc8x6SfloatBlock", #{const VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK}),
	("FormatAstc8x8SfloatBlock", #{const VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK}),
	("FormatAstc10x5SfloatBlock",
		#{const VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK}),
	("FormatAstc10x6SfloatBlock",
		#{const VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK}),
	("FormatAstc10x8SfloatBlock",
		#{const VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK}),
	("FormatAstc10x10SfloatBlock",
		#{const VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK}),
	("FormatAstc12x10SfloatBlock",
		#{const VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK}),
	("FormatAstc12x12SfloatBlock",
		#{const VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK}),
	("FormatA1b5g5r5UnormPack16", #{const VK_FORMAT_A1B5G5R5_UNORM_PACK16}),
	("FormatA8Unorm", #{const VK_FORMAT_A8_UNORM}),
	("FormatPvrtc12bppUnormBlockImg",
		#{const VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG}),
	("FormatPvrtc14bppUnormBlockImg",
		#{const VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG}),
	("FormatPvrtc22bppUnormBlockImg",
		#{const VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG}),
	("FormatPvrtc24bppUnormBlockImg",
		#{const VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG}),
	("FormatPvrtc12bppSrgbBlockImg",
		#{const VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG}),
	("FormatPvrtc14bppSrgbBlockImg",
		#{const VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG}),
	("FormatPvrtc22bppSrgbBlockImg",
		#{const VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG}),
	("FormatPvrtc24bppSrgbBlockImg",
		#{const VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG}),
	("FormatR8BoolArm", #{const VK_FORMAT_R8_BOOL_ARM}),
	("FormatR16g16Sfixed5Nv", #{const VK_FORMAT_R16G16_SFIXED5_NV}),
	("FormatR10x6UintPack16Arm", #{const VK_FORMAT_R10X6_UINT_PACK16_ARM}),
	("FormatR10x6g10x6Uint2pack16Arm",
		#{const VK_FORMAT_R10X6G10X6_UINT_2PACK16_ARM}),
	("FormatR10x6g10x6b10x6a10x6Uint4pack16Arm",
		#{const VK_FORMAT_R10X6G10X6B10X6A10X6_UINT_4PACK16_ARM}),
	("FormatR12x4UintPack16Arm", #{const VK_FORMAT_R12X4_UINT_PACK16_ARM}),
	("FormatR12x4g12x4Uint2pack16Arm",
		#{const VK_FORMAT_R12X4G12X4_UINT_2PACK16_ARM}),
	("FormatR12x4g12x4b12x4a12x4Uint4pack16Arm",
		#{const VK_FORMAT_R12X4G12X4B12X4A12X4_UINT_4PACK16_ARM}),
	("FormatR14x2UintPack16Arm", #{const VK_FORMAT_R14X2_UINT_PACK16_ARM}),
	("FormatR14x2g14x2Uint2pack16Arm",
		#{const VK_FORMAT_R14X2G14X2_UINT_2PACK16_ARM}),
	("FormatR14x2g14x2b14x2a14x2Uint4pack16Arm",
		#{const VK_FORMAT_R14X2G14X2B14X2A14X2_UINT_4PACK16_ARM}),
	("FormatR14x2UnormPack16Arm",
		#{const VK_FORMAT_R14X2_UNORM_PACK16_ARM}),
	("FormatR14x2g14x2Unorm2pack16Arm",
		#{const VK_FORMAT_R14X2G14X2_UNORM_2PACK16_ARM}),
	("FormatR14x2g14x2b14x2a14x2Unorm4pack16Arm",
		#{const VK_FORMAT_R14X2G14X2B14X2A14X2_UNORM_4PACK16_ARM}),
	("FormatG14x2B14x2r14x22plane420Unorm3pack16Arm",
		#{const VK_FORMAT_G14X2_B14X2R14X2_2PLANE_420_UNORM_3PACK16_ARM}),
	("FormatG14x2B14x2r14x22plane422Unorm3pack16Arm",
		#{const VK_FORMAT_G14X2_B14X2R14X2_2PLANE_422_UNORM_3PACK16_ARM}),
	("FormatAstc4x4SfloatBlockExt",
		#{const VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT}),
	("FormatAstc5x4SfloatBlockExt",
		#{const VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT}),
	("FormatAstc5x5SfloatBlockExt",
		#{const VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT}),
	("FormatAstc6x5SfloatBlockExt",
		#{const VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT}),
	("FormatAstc6x6SfloatBlockExt",
		#{const VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT}),
	("FormatAstc8x5SfloatBlockExt",
		#{const VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT}),
	("FormatAstc8x6SfloatBlockExt",
		#{const VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT}),
	("FormatAstc8x8SfloatBlockExt",
		#{const VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT}),
	("FormatAstc10x5SfloatBlockExt",
		#{const VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT}),
	("FormatAstc10x6SfloatBlockExt",
		#{const VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT}),
	("FormatAstc10x8SfloatBlockExt",
		#{const VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT}),
	("FormatAstc10x10SfloatBlockExt",
		#{const VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT}),
	("FormatAstc12x10SfloatBlockExt",
		#{const VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT}),
	("FormatAstc12x12SfloatBlockExt",
		#{const VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT}),
	("FormatG8b8g8r8422UnormKhr",
		#{const VK_FORMAT_G8B8G8R8_422_UNORM_KHR}),
	("FormatB8g8r8g8422UnormKhr",
		#{const VK_FORMAT_B8G8R8G8_422_UNORM_KHR}),
	("FormatG8B8R83plane420UnormKhr",
		#{const VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR}),
	("FormatG8B8r82plane420UnormKhr",
		#{const VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR}),
	("FormatG8B8R83plane422UnormKhr",
		#{const VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR}),
	("FormatG8B8r82plane422UnormKhr",
		#{const VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR}),
	("FormatG8B8R83plane444UnormKhr",
		#{const VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR}),
	("FormatR10x6UnormPack16Khr",
		#{const VK_FORMAT_R10X6_UNORM_PACK16_KHR}),
	("FormatR10x6g10x6Unorm2pack16Khr",
		#{const VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR}),
	("FormatR10x6g10x6b10x6a10x6Unorm4pack16Khr",
		#{const VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR}),
	("FormatG10x6b10x6g10x6r10x6422Unorm4pack16Khr",
		#{const VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR}),
	("FormatB10x6g10x6r10x6g10x6422Unorm4pack16Khr",
		#{const VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR}),
	("FormatG10x6B10x6R10x63plane420Unorm3pack16Khr",
		#{const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR}),
	("FormatG10x6B10x6r10x62plane420Unorm3pack16Khr",
		#{const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR}),
	("FormatG10x6B10x6R10x63plane422Unorm3pack16Khr",
		#{const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR}),
	("FormatG10x6B10x6r10x62plane422Unorm3pack16Khr",
		#{const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR}),
	("FormatG10x6B10x6R10x63plane444Unorm3pack16Khr",
		#{const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR}),
	("FormatR12x4UnormPack16Khr",
		#{const VK_FORMAT_R12X4_UNORM_PACK16_KHR}),
	("FormatR12x4g12x4Unorm2pack16Khr",
		#{const VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR}),
	("FormatR12x4g12x4b12x4a12x4Unorm4pack16Khr",
		#{const VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR}),
	("FormatG12x4b12x4g12x4r12x4422Unorm4pack16Khr",
		#{const VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR}),
	("FormatB12x4g12x4r12x4g12x4422Unorm4pack16Khr",
		#{const VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR}),
	("FormatG12x4B12x4R12x43plane420Unorm3pack16Khr",
		#{const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR}),
	("FormatG12x4B12x4r12x42plane420Unorm3pack16Khr",
		#{const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR}),
	("FormatG12x4B12x4R12x43plane422Unorm3pack16Khr",
		#{const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR}),
	("FormatG12x4B12x4r12x42plane422Unorm3pack16Khr",
		#{const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR}),
	("FormatG12x4B12x4R12x43plane444Unorm3pack16Khr",
		#{const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR}),
	("FormatG16b16g16r16422UnormKhr",
		#{const VK_FORMAT_G16B16G16R16_422_UNORM_KHR}),
	("FormatB16g16r16g16422UnormKhr",
		#{const VK_FORMAT_B16G16R16G16_422_UNORM_KHR}),
	("FormatG16B16R163plane420UnormKhr",
		#{const VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR}),
	("FormatG16B16r162plane420UnormKhr",
		#{const VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR}),
	("FormatG16B16R163plane422UnormKhr",
		#{const VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR}),
	("FormatG16B16r162plane422UnormKhr",
		#{const VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR}),
	("FormatG16B16R163plane444UnormKhr",
		#{const VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR}),
	("FormatG8B8r82plane444UnormExt",
		#{const VK_FORMAT_G8_B8R8_2PLANE_444_UNORM_EXT}),
	("FormatG10x6B10x6r10x62plane444Unorm3pack16Ext",
		#{const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT}),
	("FormatG12x4B12x4r12x42plane444Unorm3pack16Ext",
		#{const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT}),
	("FormatG16B16r162plane444UnormExt",
		#{const VK_FORMAT_G16_B16R16_2PLANE_444_UNORM_EXT}),
	("FormatA4r4g4b4UnormPack16Ext",
		#{const VK_FORMAT_A4R4G4B4_UNORM_PACK16_EXT}),
	("FormatA4b4g4r4UnormPack16Ext",
		#{const VK_FORMAT_A4B4G4R4_UNORM_PACK16_EXT}),
	("FormatR16g16S105Nv", #{const VK_FORMAT_R16G16_S10_5_NV}),
	("FormatA1b5g5r5UnormPack16Khr",
		#{const VK_FORMAT_A1B5G5R5_UNORM_PACK16_KHR}),
	("FormatA8UnormKhr", #{const VK_FORMAT_A8_UNORM_KHR}),
	("FormatMaxEnum", #{const VK_FORMAT_MAX_ENUM}) ]

enum "SubmitFlagBits" ''#{type VkSubmitFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("SubmitProtectedBit", #{const VK_SUBMIT_PROTECTED_BIT}),
	("SubmitProtectedBitKhr", #{const VK_SUBMIT_PROTECTED_BIT_KHR}),
	("SubmitFlagBitsMaxEnum", #{const VK_SUBMIT_FLAG_BITS_MAX_ENUM}) ]

enum "AccessFlagBits" ''#{type VkAccessFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("AccessFlagsZero", 0),
	("AccessIndirectCommandReadBit",
		#{const VK_ACCESS_INDIRECT_COMMAND_READ_BIT}),
	("AccessIndexReadBit", #{const VK_ACCESS_INDEX_READ_BIT}),
	("AccessVertexAttributeReadBit",
		#{const VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT}),
	("AccessUniformReadBit", #{const VK_ACCESS_UNIFORM_READ_BIT}),
	("AccessInputAttachmentReadBit",
		#{const VK_ACCESS_INPUT_ATTACHMENT_READ_BIT}),
	("AccessShaderReadBit", #{const VK_ACCESS_SHADER_READ_BIT}),
	("AccessShaderWriteBit", #{const VK_ACCESS_SHADER_WRITE_BIT}),
	("AccessColorAttachmentReadBit",
		#{const VK_ACCESS_COLOR_ATTACHMENT_READ_BIT}),
	("AccessColorAttachmentWriteBit",
		#{const VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT}),
	("AccessDepthStencilAttachmentReadBit",
		#{const VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT}),
	("AccessDepthStencilAttachmentWriteBit",
		#{const VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT}),
	("AccessTransferReadBit", #{const VK_ACCESS_TRANSFER_READ_BIT}),
	("AccessTransferWriteBit", #{const VK_ACCESS_TRANSFER_WRITE_BIT}),
	("AccessHostReadBit", #{const VK_ACCESS_HOST_READ_BIT}),
	("AccessHostWriteBit", #{const VK_ACCESS_HOST_WRITE_BIT}),
	("AccessMemoryReadBit", #{const VK_ACCESS_MEMORY_READ_BIT}),
	("AccessMemoryWriteBit", #{const VK_ACCESS_MEMORY_WRITE_BIT}),
	("AccessNone", #{const VK_ACCESS_NONE}),
	("AccessTransformFeedbackWriteBitExt",
		#{const VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT}),
	("AccessTransformFeedbackCounterReadBitExt",
		#{const VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT}),
	("AccessTransformFeedbackCounterWriteBitExt",
		#{const VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT}),
	("AccessConditionalRenderingReadBitExt",
		#{const VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT}),
	("AccessColorAttachmentReadNoncoherentBitExt",
		#{const VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT}),
	("AccessAccelerationStructureReadBitKhr",
		#{const VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR}),
	("AccessAccelerationStructureWriteBitKhr",
		#{const VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR}),
	("AccessFragmentDensityMapReadBitExt",
		#{const VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT}),
	("AccessFragmentShadingRateAttachmentReadBitKhr",
		#{const VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR}),
	("AccessCommandPreprocessReadBitExt",
		#{const VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_EXT}),
	("AccessCommandPreprocessWriteBitExt",
		#{const VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_EXT}),
	("AccessShadingRateImageReadBitNv",
		#{const VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV}),
	("AccessAccelerationStructureReadBitNv",
		#{const VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_NV}),
	("AccessAccelerationStructureWriteBitNv",
		#{const VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_NV}),
	("AccessCommandPreprocessReadBitNv",
		#{const VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV}),
	("AccessCommandPreprocessWriteBitNv",
		#{const VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV}),
	("AccessNoneKhr", #{const VK_ACCESS_NONE_KHR}),
	("AccessFlagBitsMaxEnum", #{const VK_ACCESS_FLAG_BITS_MAX_ENUM}) ]

enum "DependencyFlagBits" ''#{type VkDependencyFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("DependencyFlagsZero", 0),
	("DependencyByRegionBit", #{const VK_DEPENDENCY_BY_REGION_BIT}),
	("DependencyDeviceGroupBit", #{const VK_DEPENDENCY_DEVICE_GROUP_BIT}),
	("DependencyViewLocalBit", #{const VK_DEPENDENCY_VIEW_LOCAL_BIT}),
	("DependencyFeedbackLoopBitExt",
		#{const VK_DEPENDENCY_FEEDBACK_LOOP_BIT_EXT}),
	("DependencyQueueFamilyOwnershipTransferUseAllStagesBitKhr",
		#{const VK_DEPENDENCY_QUEUE_FAMILY_OWNERSHIP_TRANSFER_USE_ALL_STAGES_BIT_KHR}),
	("DependencyAsymmetricEventBitKhr",
		#{const VK_DEPENDENCY_ASYMMETRIC_EVENT_BIT_KHR}),
	("DependencyViewLocalBitKhr",
		#{const VK_DEPENDENCY_VIEW_LOCAL_BIT_KHR}),
	("DependencyDeviceGroupBitKhr",
		#{const VK_DEPENDENCY_DEVICE_GROUP_BIT_KHR}),
	("DependencyFlagBitsMaxEnum",
		#{const VK_DEPENDENCY_FLAG_BITS_MAX_ENUM}) ]

enum "QueryControlFlagBits" ''#{type VkQueryControlFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("QueryControlFlagsZero", 0),
	("QueryControlPreciseBit", #{const VK_QUERY_CONTROL_PRECISE_BIT}),
	("QueryControlFlagBitsMaxEnum",
		#{const VK_QUERY_CONTROL_FLAG_BITS_MAX_ENUM}) ]

enum "QueryPipelineStatisticFlagBits" ''#{type VkQueryPipelineStatisticFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("QueryPipelineStatisticFlagsZero", 0),
	("QueryPipelineStatisticInputAssemblyVerticesBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT}),
	("QueryPipelineStatisticInputAssemblyPrimitivesBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT}),
	("QueryPipelineStatisticVertexShaderInvocationsBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT}),
	("QueryPipelineStatisticGeometryShaderInvocationsBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT}),
	("QueryPipelineStatisticGeometryShaderPrimitivesBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT}),
	("QueryPipelineStatisticClippingInvocationsBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT}),
	("QueryPipelineStatisticClippingPrimitivesBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT}),
	("QueryPipelineStatisticFragmentShaderInvocationsBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT}),
	("QueryPipelineStatisticTessellationControlShaderPatchesBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT}),
	("QueryPipelineStatisticTessellationEvaluationShaderInvocationsBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT}),
	("QueryPipelineStatisticComputeShaderInvocationsBit",
		#{const VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT}),
	("QueryPipelineStatisticTaskShaderInvocationsBitExt",
		#{const VK_QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT}),
	("QueryPipelineStatisticMeshShaderInvocationsBitExt",
		#{const VK_QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT}),
	("QueryPipelineStatisticClusterCullingShaderInvocationsBitHuawei",
		#{const VK_QUERY_PIPELINE_STATISTIC_CLUSTER_CULLING_SHADER_INVOCATIONS_BIT_HUAWEI}),
	("QueryPipelineStatisticFlagBitsMaxEnum",
		#{const VK_QUERY_PIPELINE_STATISTIC_FLAG_BITS_MAX_ENUM}) ]

enum "CullModeFlagBits" ''#{type VkCullModeFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("CullModeFlagsZero", 0),
	("CullModeNone", #{const VK_CULL_MODE_NONE}),
	("CullModeFrontBit", #{const VK_CULL_MODE_FRONT_BIT}),
	("CullModeBackBit", #{const VK_CULL_MODE_BACK_BIT}),
	("CullModeFrontAndBack", #{const VK_CULL_MODE_FRONT_AND_BACK}),
	("CullModeFlagBitsMaxEnum", #{const VK_CULL_MODE_FLAG_BITS_MAX_ENUM}) ]

enum "ShaderStageFlagBits" ''#{type VkShaderStageFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("ShaderStageFlagsZero", 0),
	("ShaderStageVertexBit", #{const VK_SHADER_STAGE_VERTEX_BIT}),
	("ShaderStageTessellationControlBit",
		#{const VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT}),
	("ShaderStageTessellationEvaluationBit",
		#{const VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT}),
	("ShaderStageGeometryBit", #{const VK_SHADER_STAGE_GEOMETRY_BIT}),
	("ShaderStageFragmentBit", #{const VK_SHADER_STAGE_FRAGMENT_BIT}),
	("ShaderStageComputeBit", #{const VK_SHADER_STAGE_COMPUTE_BIT}),
	("ShaderStageAllGraphics", #{const VK_SHADER_STAGE_ALL_GRAPHICS}),
	("ShaderStageAll", #{const VK_SHADER_STAGE_ALL}),
	("ShaderStageRaygenBitKhr", #{const VK_SHADER_STAGE_RAYGEN_BIT_KHR}),
	("ShaderStageAnyHitBitKhr", #{const VK_SHADER_STAGE_ANY_HIT_BIT_KHR}),
	("ShaderStageClosestHitBitKhr",
		#{const VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR}),
	("ShaderStageMissBitKhr", #{const VK_SHADER_STAGE_MISS_BIT_KHR}),
	("ShaderStageIntersectionBitKhr",
		#{const VK_SHADER_STAGE_INTERSECTION_BIT_KHR}),
	("ShaderStageCallableBitKhr",
		#{const VK_SHADER_STAGE_CALLABLE_BIT_KHR}),
	("ShaderStageTaskBitExt", #{const VK_SHADER_STAGE_TASK_BIT_EXT}),
	("ShaderStageMeshBitExt", #{const VK_SHADER_STAGE_MESH_BIT_EXT}),
	("ShaderStageSubpassShadingBitHuawei",
		#{const VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI}),
	("ShaderStageClusterCullingBitHuawei",
		#{const VK_SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI}),
	("ShaderStageRaygenBitNv", #{const VK_SHADER_STAGE_RAYGEN_BIT_NV}),
	("ShaderStageAnyHitBitNv", #{const VK_SHADER_STAGE_ANY_HIT_BIT_NV}),
	("ShaderStageClosestHitBitNv",
		#{const VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV}),
	("ShaderStageMissBitNv", #{const VK_SHADER_STAGE_MISS_BIT_NV}),
	("ShaderStageIntersectionBitNv",
		#{const VK_SHADER_STAGE_INTERSECTION_BIT_NV}),
	("ShaderStageCallableBitNv", #{const VK_SHADER_STAGE_CALLABLE_BIT_NV}),
	("ShaderStageTaskBitNv", #{const VK_SHADER_STAGE_TASK_BIT_NV}),
	("ShaderStageMeshBitNv", #{const VK_SHADER_STAGE_MESH_BIT_NV}),
	("ShaderStageFlagBitsMaxEnum",
		#{const VK_SHADER_STAGE_FLAG_BITS_MAX_ENUM}) ]

enum "FormatFeatureFlagBits" ''#{type VkFormatFeatureFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits, ''FiniteBits] [
	("FormatFeatureFlagsZero", 0),
	("FormatFeatureSampledImageBit",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT}),
	("FormatFeatureStorageImageBit",
		#{const VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT}),
	("FormatFeatureStorageImageAtomicBit",
		#{const VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT}),
	("FormatFeatureUniformTexelBufferBit",
		#{const VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT}),
	("FormatFeatureStorageTexelBufferBit",
		#{const VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT}),
	("FormatFeatureStorageTexelBufferAtomicBit",
		#{const VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT}),
	("FormatFeatureVertexBufferBit",
		#{const VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT}),
	("FormatFeatureColorAttachmentBit",
		#{const VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT}),
	("FormatFeatureColorAttachmentBlendBit",
		#{const VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT}),
	("FormatFeatureDepthStencilAttachmentBit",
		#{const VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT}),
	("FormatFeatureBlitSrcBit", #{const VK_FORMAT_FEATURE_BLIT_SRC_BIT}),
	("FormatFeatureBlitDstBit", #{const VK_FORMAT_FEATURE_BLIT_DST_BIT}),
	("FormatFeatureSampledImageFilterLinearBit",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT}),
	("FormatFeatureTransferSrcBit",
		#{const VK_FORMAT_FEATURE_TRANSFER_SRC_BIT}),
	("FormatFeatureTransferDstBit",
		#{const VK_FORMAT_FEATURE_TRANSFER_DST_BIT}),
	("FormatFeatureMidpointChromaSamplesBit",
		#{const VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT}),
	("FormatFeatureSampledImageYcbcrConversionLinearFilterBit",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT}),
	("FormatFeatureSampledImageYcbcrConversionSeparateReconstructionFilterBit",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT}),
	("FormatFeatureSampledImageYcbcrConversionChromaReconstructionExplicitBit",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT}),
	("FormatFeatureSampledImageYcbcrConversionChromaReconstructionExplicitForceableBit",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT}),
	("FormatFeatureDisjointBit", #{const VK_FORMAT_FEATURE_DISJOINT_BIT}),
	("FormatFeatureCositedChromaSamplesBit",
		#{const VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT}),
	("FormatFeatureSampledImageFilterMinmaxBit",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT}),
	("FormatFeatureVideoDecodeOutputBitKhr",
		#{const VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR}),
	("FormatFeatureVideoDecodeDpbBitKhr",
		#{const VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR}),
	("FormatFeatureAccelerationStructureVertexBufferBitKhr",
		#{const VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR}),
	("FormatFeatureSampledImageFilterCubicBitExt",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT}),
	("FormatFeatureFragmentDensityMapBitExt",
		#{const VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT}),
	("FormatFeatureFragmentShadingRateAttachmentBitKhr",
		#{const VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR}),
	("FormatFeatureVideoEncodeInputBitKhr",
		#{const VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR}),
	("FormatFeatureVideoEncodeDpbBitKhr",
		#{const VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR}),
	("FormatFeatureSampledImageFilterCubicBitImg",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG}),
	("FormatFeatureTransferSrcBitKhr",
		#{const VK_FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR}),
	("FormatFeatureTransferDstBitKhr",
		#{const VK_FORMAT_FEATURE_TRANSFER_DST_BIT_KHR}),
	("FormatFeatureSampledImageFilterMinmaxBitExt",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT}),
	("FormatFeatureMidpointChromaSamplesBitKhr",
		#{const VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR}),
	("FormatFeatureSampledImageYcbcrConversionLinearFilterBitKhr",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR}),
	("FormatFeatureSampledImageYcbcrConversionSeparateReconstructionFilterBitKhr",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR}),
	("FormatFeatureSampledImageYcbcrConversionChromaReconstructionExplicitBitKhr",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR}),
	("FormatFeatureSampledImageYcbcrConversionChromaReconstructionExplicitForceableBitKhr",
		#{const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR}),
	("FormatFeatureDisjointBitKhr",
		#{const VK_FORMAT_FEATURE_DISJOINT_BIT_KHR}),
	("FormatFeatureCositedChromaSamplesBitKhr",
		#{const VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR}),
	("FormatFeatureFlagBitsMaxEnum",
		#{const VK_FORMAT_FEATURE_FLAG_BITS_MAX_ENUM}) ]

type PtrDynamicState = Ptr DynamicState
type AccessFlags = AccessFlagBits
type AccessFlags2 = AccessFlagBits2
type DependencyFlags = DependencyFlagBits
type QueryControlFlags = QueryControlFlagBits
type QueryPipelineStatisticFlags = QueryPipelineStatisticFlagBits
type CullModeFlags = CullModeFlagBits
type ShaderStageFlags = ShaderStageFlagBits
type FormatFeatureFlags = FormatFeatureFlagBits
type SubmitFlags = SubmitFlagBits
