-- This file is automatically generated by the tools/makeEnum.hs
--	% stack runghc --cwd tools/ makeEnum

{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE TypeSynonymInstances #-}
{-# LANGUAGE PatternSynonyms #-}
{-# LANGUAGE GeneralizedNewtypeDeriving #-}
{-# OPTIONS_GHC -Wall -fno-warn-missing-export-lists -fno-warn-tabs #-}

module Gpu.Vulkan.Image.Enum where

import Foreign.Storable
import Foreign.C.Enum
import Data.Bits
import Data.Word

#include <vulkan/vulkan.h>

enum "UsageFlagBits" ''#{type VkImageUsageFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("UsageFlagsZero", 0),
	("UsageTransferSrcBit", #{const VK_IMAGE_USAGE_TRANSFER_SRC_BIT}),
	("UsageTransferDstBit", #{const VK_IMAGE_USAGE_TRANSFER_DST_BIT}),
	("UsageSampledBit", #{const VK_IMAGE_USAGE_SAMPLED_BIT}),
	("UsageStorageBit", #{const VK_IMAGE_USAGE_STORAGE_BIT}),
	("UsageColorAttachmentBit",
		#{const VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT}),
	("UsageDepthStencilAttachmentBit",
		#{const VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT}),
	("UsageTransientAttachmentBit",
		#{const VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT}),
	("UsageInputAttachmentBit",
		#{const VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT}),
	("UsageHostTransferBit",
		#{const VK_IMAGE_USAGE_HOST_TRANSFER_BIT}),
	("UsageVideoDecodeDstBitKhr",
		#{const VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR}),
	("UsageVideoDecodeSrcBitKhr",
		#{const VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR}),
	("UsageVideoDecodeDpbBitKhr",
		#{const VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR}),
	("UsageFragmentDensityMapBitExt",
		#{const VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT}),
	("UsageFragmentShadingRateAttachmentBitKhr",
		#{const VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR}),
	("UsageVideoEncodeDstBitKhr",
		#{const VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR}),
	("UsageVideoEncodeSrcBitKhr",
		#{const VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR}),
	("UsageVideoEncodeDpbBitKhr",
		#{const VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR}),
	("UsageAttachmentFeedbackLoopBitExt",
		#{const VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT}),
	("UsageInvocationMaskBitHuawei",
		#{const VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI}),
	("UsageSampleWeightBitQcom",
		#{const VK_IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM}),
	("UsageSampleBlockMatchBitQcom",
		#{const VK_IMAGE_USAGE_SAMPLE_BLOCK_MATCH_BIT_QCOM}),
	("UsageTensorAliasingBitArm",
		#{const VK_IMAGE_USAGE_TENSOR_ALIASING_BIT_ARM}),
	("UsageTileMemoryBitQcom",
		#{const VK_IMAGE_USAGE_TILE_MEMORY_BIT_QCOM}),
	("UsageVideoEncodeQuantizationDeltaMapBitKhr",
		#{const VK_IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR}),
	("UsageVideoEncodeEmphasisMapBitKhr",
		#{const VK_IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR}),
	("UsageShadingRateImageBitNv",
		#{const VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV}),
	("UsageHostTransferBitExt",
		#{const VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT}),
	("UsageFlagBitsMaxEnum",
		#{const VK_IMAGE_USAGE_FLAG_BITS_MAX_ENUM}) ]

enum "AspectFlagBits" ''#{type VkImageAspectFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("AspectFlagsZero", 0),
	("AspectColorBit", #{const VK_IMAGE_ASPECT_COLOR_BIT}),
	("AspectDepthBit", #{const VK_IMAGE_ASPECT_DEPTH_BIT}),
	("AspectStencilBit", #{const VK_IMAGE_ASPECT_STENCIL_BIT}),
	("AspectMetadataBit", #{const VK_IMAGE_ASPECT_METADATA_BIT}),
	("AspectPlane0Bit", #{const VK_IMAGE_ASPECT_PLANE_0_BIT}),
	("AspectPlane1Bit", #{const VK_IMAGE_ASPECT_PLANE_1_BIT}),
	("AspectPlane2Bit", #{const VK_IMAGE_ASPECT_PLANE_2_BIT}),
	("AspectNone", #{const VK_IMAGE_ASPECT_NONE}),
	("AspectMemoryPlane0BitExt",
		#{const VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT}),
	("AspectMemoryPlane1BitExt",
		#{const VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT}),
	("AspectMemoryPlane2BitExt",
		#{const VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT}),
	("AspectMemoryPlane3BitExt",
		#{const VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT}),
	("AspectPlane0BitKhr", #{const VK_IMAGE_ASPECT_PLANE_0_BIT_KHR}),
	("AspectPlane1BitKhr", #{const VK_IMAGE_ASPECT_PLANE_1_BIT_KHR}),
	("AspectPlane2BitKhr", #{const VK_IMAGE_ASPECT_PLANE_2_BIT_KHR}),
	("AspectNoneKhr", #{const VK_IMAGE_ASPECT_NONE_KHR}),
	("AspectFlagBitsMaxEnum",
		#{const VK_IMAGE_ASPECT_FLAG_BITS_MAX_ENUM}) ]

enum "Layout" ''#{type VkImageLayout}
		[''Show, ''Eq, ''Storable] [
	("LayoutUndefined", #{const VK_IMAGE_LAYOUT_UNDEFINED}),
	("LayoutGeneral", #{const VK_IMAGE_LAYOUT_GENERAL}),
	("LayoutColorAttachmentOptimal",
		#{const VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL}),
	("LayoutDepthStencilAttachmentOptimal",
		#{const VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL}),
	("LayoutDepthStencilReadOnlyOptimal",
		#{const VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL}),
	("LayoutShaderReadOnlyOptimal",
		#{const VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL}),
	("LayoutTransferSrcOptimal",
		#{const VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL}),
	("LayoutTransferDstOptimal",
		#{const VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL}),
	("LayoutPreinitialized", #{const VK_IMAGE_LAYOUT_PREINITIALIZED}),
	("LayoutDepthReadOnlyStencilAttachmentOptimal",
		#{const VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL}),
	("LayoutDepthAttachmentStencilReadOnlyOptimal",
		#{const VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL}),
	("LayoutDepthAttachmentOptimal",
		#{const VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL}),
	("LayoutDepthReadOnlyOptimal",
		#{const VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL}),
	("LayoutStencilAttachmentOptimal",
		#{const VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL}),
	("LayoutStencilReadOnlyOptimal",
		#{const VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL}),
	("LayoutReadOnlyOptimal",
		#{const VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL}),
	("LayoutAttachmentOptimal",
		#{const VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL}),
	("LayoutRenderingLocalRead",
		#{const VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ}),
	("LayoutPresentSrcKhr", #{const VK_IMAGE_LAYOUT_PRESENT_SRC_KHR}),
	("LayoutVideoDecodeDstKhr",
		#{const VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR}),
	("LayoutVideoDecodeSrcKhr",
		#{const VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR}),
	("LayoutVideoDecodeDpbKhr",
		#{const VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR}),
	("LayoutSharedPresentKhr",
		#{const VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR}),
	("LayoutFragmentDensityMapOptimalExt",
		#{const VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT}),
	("LayoutFragmentShadingRateAttachmentOptimalKhr",
		#{const VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR}),
	("LayoutVideoEncodeDstKhr",
		#{const VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR}),
	("LayoutVideoEncodeSrcKhr",
		#{const VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR}),
	("LayoutVideoEncodeDpbKhr",
		#{const VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR}),
	("LayoutAttachmentFeedbackLoopOptimalExt",
		#{const VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT}),
	("LayoutTensorAliasingArm",
		#{const VK_IMAGE_LAYOUT_TENSOR_ALIASING_ARM}),
	("LayoutVideoEncodeQuantizationMapKhr",
		#{const VK_IMAGE_LAYOUT_VIDEO_ENCODE_QUANTIZATION_MAP_KHR}),
	("LayoutZeroInitializedExt",
		#{const VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT}),
	("LayoutDepthReadOnlyStencilAttachmentOptimalKhr",
		#{const VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL_KHR}),
	("LayoutDepthAttachmentStencilReadOnlyOptimalKhr",
		#{const VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL_KHR}),
	("LayoutShadingRateOptimalNv",
		#{const VK_IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV}),
	("LayoutRenderingLocalReadKhr",
		#{const VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR}),
	("LayoutDepthAttachmentOptimalKhr",
		#{const VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL_KHR}),
	("LayoutDepthReadOnlyOptimalKhr",
		#{const VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL_KHR}),
	("LayoutStencilAttachmentOptimalKhr",
		#{const VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL_KHR}),
	("LayoutStencilReadOnlyOptimalKhr",
		#{const VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL_KHR}),
	("LayoutReadOnlyOptimalKhr",
		#{const VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR}),
	("LayoutAttachmentOptimalKhr",
		#{const VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR}),
	("LayoutMaxEnum", #{const VK_IMAGE_LAYOUT_MAX_ENUM}) ]

enum "CreateFlagBits" ''#{type VkImageCreateFlagBits}
		[''Show, ''Eq, ''Storable, ''Bits] [
	("CreateFlagsZero", 0),
	("CreateSparseBindingBit",
		#{const VK_IMAGE_CREATE_SPARSE_BINDING_BIT}),
	("CreateSparseResidencyBit",
		#{const VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT}),
	("CreateSparseAliasedBit",
		#{const VK_IMAGE_CREATE_SPARSE_ALIASED_BIT}),
	("CreateMutableFormatBit",
		#{const VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT}),
	("CreateCubeCompatibleBit",
		#{const VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT}),
	("CreateAliasBit", #{const VK_IMAGE_CREATE_ALIAS_BIT}),
	("CreateSplitInstanceBindRegionsBit",
		#{const VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT}),
	("Create2dArrayCompatibleBit",
		#{const VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT}),
	("CreateBlockTexelViewCompatibleBit",
		#{const VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT}),
	("CreateExtendedUsageBit",
		#{const VK_IMAGE_CREATE_EXTENDED_USAGE_BIT}),
	("CreateProtectedBit", #{const VK_IMAGE_CREATE_PROTECTED_BIT}),
	("CreateDisjointBit", #{const VK_IMAGE_CREATE_DISJOINT_BIT}),
	("CreateCornerSampledBitNv",
		#{const VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV}),
	("CreateSampleLocationsCompatibleDepthBitExt",
		#{const VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT}),
	("CreateSubsampledBitExt",
		#{const VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT}),
	("CreateDescriptorBufferCaptureReplayBitExt",
		#{const VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT}),
	("CreateMultisampledRenderToSingleSampledBitExt",
		#{const VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT}),
	("Create2dViewCompatibleBitExt",
		#{const VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT}),
	("CreateVideoProfileIndependentBitKhr",
		#{const VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR}),
	("CreateFragmentDensityMapOffsetBitExt",
		#{const VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_EXT}),
	("CreateSplitInstanceBindRegionsBitKhr",
		#{const VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR}),
	("Create2dArrayCompatibleBitKhr",
		#{const VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR}),
	("CreateBlockTexelViewCompatibleBitKhr",
		#{const VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_KHR}),
	("CreateExtendedUsageBitKhr",
		#{const VK_IMAGE_CREATE_EXTENDED_USAGE_BIT_KHR}),
	("CreateDisjointBitKhr",
		#{const VK_IMAGE_CREATE_DISJOINT_BIT_KHR}),
	("CreateAliasBitKhr", #{const VK_IMAGE_CREATE_ALIAS_BIT_KHR}),
	("CreateFragmentDensityMapOffsetBitQcom",
		#{const VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM}),
	("CreateFlagBitsMaxEnum",
		#{const VK_IMAGE_CREATE_FLAG_BITS_MAX_ENUM}) ]

enum "Type" ''#{type VkImageType}
		[''Show, ''Eq, ''Storable] [
	("Type1d", #{const VK_IMAGE_TYPE_1D}),
	("Type2d", #{const VK_IMAGE_TYPE_2D}),
	("Type3d", #{const VK_IMAGE_TYPE_3D}),
	("TypeMaxEnum", #{const VK_IMAGE_TYPE_MAX_ENUM}) ]

enum "Tiling" ''#{type VkImageTiling}
		[''Show, ''Eq, ''Storable] [
	("TilingOptimal", #{const VK_IMAGE_TILING_OPTIMAL}),
	("TilingLinear", #{const VK_IMAGE_TILING_LINEAR}),
	("TilingDrmFormatModifierExt",
		#{const VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT}),
	("TilingMaxEnum", #{const VK_IMAGE_TILING_MAX_ENUM}) ]

type UsageFlags = UsageFlagBits
type AspectFlags = AspectFlagBits
type CreateFlags = CreateFlagBits
