//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleAshes();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2024 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define ASHES_STYLE_PROPS_COUNT  16

// Custom style name: Ashes
static const GuiStyleProp ashesStyleProps[ASHES_STYLE_PROPS_COUNT] = {
    { 0, 0, 0xf0f0f0ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, 0x868686ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, 0xe6e6e6ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, 0x929999ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, 0xeaeaeaff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, 0x98a1a8ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, 0x3f3f3fff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, 0xf6f6f6ff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, 0x414141ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, 0x8b8b8bff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, 0x777777ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, 0x959595ff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 16, 0x00000010 },    // DEFAULT_TEXT_SIZE 
    { 0, 18, 0x9dadb1ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, 0x6b6b6bff },    // DEFAULT_BACKGROUND_COLOR 
    { 0, 20, 0x00000018 },    // DEFAULT_TEXT_LINE_SPACING 
};

// WARNING: This style uses a custom font: "v5loxical.ttf" (size: 16, spacing: 1)

#define ASHES_STYLE_FONT_ATLAS_COMP_SIZE 2042

// Font atlas image pixels data: DEFLATE compressed
static unsigned char ashesFontData[ASHES_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0xdd, 0xd1, 0xb2, 0xab, 0x36, 0x0c, 0x05, 0x50, 0xff, 0xff, 0x4f, 0xab, 0x0f, 0x9d, 0x4e, 0xdb, 0x69, 0x13, 0x90, 0x2c,
    0x83, 0x21, 0xeb, 0xae, 0xb7, 0x9c, 0xdc, 0x40, 0x0c, 0x1b, 0x63, 0x88, 0x45, 0x0c, 0x00, 0x00, 0x00, 0xe0, 0xe7, 0xc5,
    0xff, 0xbe, 0x12, 0x1f, 0xdf, 0x19, 0xa7, 0x3f, 0xe7, 0xdf, 0xaf, 0xc7, 0x87, 0xbf, 0xe6, 0x3e, 0x2f, 0x4e, 0x2f, 0xb7,
    0xf2, 0x97, 0xf8, 0xdf, 0xf5, 0x8b, 0xe9, 0xa5, 0xc6, 0xe9, 0x6f, 0xf3, 0xed, 0xbd, 0xdf, 0x96, 0xf9, 0xe9, 0x93, 0x22,
    0xb1, 0x8c, 0xec, 0xfb, 0x3f, 0x7f, 0xce, 0xd5, 0x2d, 0x1e, 0x5f, 0xfe, 0xf2, 0xfd, 0xaf, 0xd9, 0xd7, 0xe3, 0xe4, 0xab,
    0xdf, 0xfe, 0x12, 0x07, 0x7f, 0x39, 0x9b, 0xbb, 0x78, 0x40, 0xfe, 0xe3, 0xcb, 0xe7, 0x7d, 0xff, 0xc4, 0x98, 0x38, 0x26,
    0x9c, 0x5b, 0xee, 0x95, 0xed, 0xf9, 0x69, 0x4f, 0xcf, 0x6d, 0xeb, 0xef, 0x6d, 0x9c, 0xcb, 0x5c, 0x34, 0xac, 0xff, 0x6c,
    0xab, 0x45, 0xc3, 0xbb, 0xe3, 0xc4, 0xde, 0x92, 0xd9, 0x9b, 0xb3, 0x69, 0xab, 0xbd, 0x7f, 0x34, 0x6c, 0xaf, 0x6b, 0xf3,
    0xff, 0xcf, 0x7f, 0x23, 0x75, 0x14, 0x1c, 0x4d, 0xf9, 0xcf, 0xf7, 0xb9, 0xdf, 0x8e, 0xbe, 0x71, 0xd1, 0xd9, 0xd4, 0xb9,
    0x3d, 0xb4, 0xfe, 0x7a, 0xdf, 0xa7, 0x5f, 0x9d, 0xff, 0x68, 0xfc, 0x1f, 0x47, 0x6b, 0x17, 0xf2, 0x3f, 0xbd, 0x15, 0xa2,
    0xd8, 0xdb, 0x56, 0x7b, 0xa2, 0xd9, 0xad, 0x1f, 0x8b, 0x7b, 0xfa, 0x55, 0x09, 0xad, 0x1d, 0xcd, 0x22, 0xf9, 0x7f, 0x72,
    0x7d, 0x6c, 0x4c, 0x6f, 0xbd, 0xf3, 0xfb, 0x44, 0x7e, 0xfd, 0x8e, 0xf7, 0x00, 0xf9, 0xbf, 0x22, 0xff, 0x95, 0xe4, 0xc6,
    0x92, 0xa3, 0x7f, 0xf5, 0xca, 0xc0, 0x8a, 0xb6, 0xcc, 0xe5, 0x3f, 0x1a, 0x5b, 0x20, 0xdb, 0x6f, 0xe7, 0xd7, 0xff, 0xec,
    0x48, 0x3d, 0x6e, 0xec, 0xff, 0xbf, 0x1d, 0x1d, 0x33, 0x47, 0xcd, 0x6c, 0x3a, 0x73, 0xcb, 0xfd, 0x7b, 0x5d, 0xe7, 0xaf,
    0x88, 0xac, 0xc8, 0x7f, 0xf5, 0xfc, 0xbf, 0x72, 0x86, 0x3a, 0x36, 0xc9, 0xf3, 0xf5, 0xf9, 0x8f, 0xf6, 0x16, 0x58, 0x99,
    0xff, 0xb3, 0x6d, 0x1f, 0x0b, 0xc7, 0xff, 0xb9, 0xab, 0xab, 0xfb, 0xf7, 0xff, 0xf7, 0x5f, 0xff, 0x1b, 0xe5, 0xeb, 0x46,
    0xd9, 0x6b, 0x80, 0x71, 0xea, 0xec, 0xe1, 0x29, 0xf9, 0xef, 0x38, 0xfe, 0x55, 0x47, 0x4a, 0x1d, 0x57, 0xb8, 0xb2, 0xf9,
    0x8f, 0x86, 0xb6, 0x8f, 0xa5, 0x47, 0xff, 0x4a, 0xaf, 0x24, 0xff, 0xbd, 0xe3, 0xff, 0x38, 0x71, 0x06, 0x18, 0xaf, 0xe8,
    0xff, 0xf3, 0xa3, 0x9c, 0x68, 0xb8, 0x07, 0x57, 0xb9, 0xbb, 0x9a, 0xed, 0x31, 0x2b, 0xf7, 0x24, 0x77, 0x68, 0x77, 0xfd,
    0xff, 0x75, 0xdb, 0xa0, 0xb6, 0x2f, 0xfc, 0xf5, 0xff, 0x9e, 0xdf, 0xff, 0xef, 0xb4, 0x35, 0x90, 0xff, 0xab, 0xf7, 0xdb,
    0xb8, 0xb5, 0x7f, 0x95, 0x7f, 0xbf, 0x60, 0xeb, 0xca, 0xff, 0xda, 0xdf, 0xff, 0xc4, 0x41, 0x6f, 0x38, 0x1e, 0xd9, 0xff,
    0x5f, 0xb3, 0x36, 0x21, 0x79, 0xe0, 0x58, 0x2f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xfc, 0xd0, 0xec, 0x99, 0xcc, 0xec, 0xe5, 0x6a, 0x15, 0xe0, 0x8e, 0xf7, 0x57, 0x97, 0x10, 0x6d, 0xf5, 0x1f, 0xfb,
    0xaa, 0x49, 0x7e, 0x9e, 0x4d, 0x9a, 0x99, 0xf7, 0x9c, 0xab, 0x6f, 0x9e, 0xab, 0x24, 0x17, 0xc9, 0x9a, 0x6d, 0x91, 0xac,
    0x5b, 0x9c, 0xdd, 0x8e, 0xf3, 0xb3, 0xec, 0xe7, 0xfe, 0xff, 0xdf, 0xb5, 0x2a, 0xfa, 0xf6, 0xe5, 0xd1, 0xd4, 0x32, 0xd7,
    0xe5, 0x7f, 0xb4, 0xd7, 0x54, 0xcd, 0x57, 0xa8, 0xca, 0xd7, 0xc7, 0x1f, 0x9b, 0xe5, 0x3f, 0xb3, 0x3f, 0x66, 0xeb, 0xfe,
    0x44, 0x61, 0x56, 0x64, 0x4c, 0xcf, 0xb7, 0x8c, 0x85, 0xfb, 0x5d, 0x57, 0x05, 0xc9, 0x31, 0x99, 0xff, 0x3b, 0xf7, 0xfd,
    0x4a, 0x6d, 0x46, 0xf9, 0x7f, 0x43, 0xfe, 0x2b, 0xd5, 0x3d, 0x3b, 0xe6, 0x45, 0x77, 0xd5, 0xc7, 0x8d, 0xf4, 0x79, 0x51,
    0x66, 0x7f, 0x88, 0xa9, 0xca, 0xea, 0x91, 0x3e, 0x0e, 0xef, 0x98, 0x7f, 0xfd, 0x7f, 0xa5, 0x36, 0xde, 0xdd, 0xf9, 0x9f,
    0x7b, 0x22, 0xc0, 0xea, 0xea, 0x07, 0x6b, 0xfb, 0xa7, 0xde, 0xfe, 0x3f, 0x26, 0xf2, 0x9f, 0x7d, 0x86, 0xd9, 0x5e, 0xf9,
    0x9f, 0x3f, 0xff, 0xaf, 0x57, 0x3b, 0xef, 0x1a, 0x05, 0x8f, 0x86, 0xe3, 0x7d, 0xf5, 0x49, 0x82, 0x5d, 0xf9, 0x1f, 0x85,
    0xa7, 0xc0, 0xcd, 0x9e, 0x8f, 0x3e, 0x3b, 0xff, 0xb9, 0x2b, 0x11, 0xeb, 0xf2, 0xff, 0xec, 0xfe, 0x7f, 0xbc, 0xe0, 0xfc,
    0xbf, 0x63, 0x7b, 0x8f, 0x4d, 0xcf, 0xff, 0xbb, 0x46, 0xd1, 0xef, 0xcb, 0x7f, 0xf6, 0x7b, 0x76, 0x7c, 0xfe, 0x5b, 0xcf,
    0xff, 0xe5, 0xff, 0xed, 0xf9, 0xbf, 0xeb, 0x49, 0x66, 0x7b, 0xe4, 0x3f, 0x9a, 0xaa, 0xef, 0xca, 0xff, 0x5b, 0xf3, 0xbf,
    0xeb, 0xf5, 0xbf, 0xe7, 0xe6, 0x7f, 0x94, 0xc6, 0x66, 0x73, 0xef, 0x7e, 0x42, 0xff, 0x3f, 0x0a, 0xd7, 0xac, 0xf2, 0x23,
    0xd9, 0xeb, 0xc6, 0xff, 0xf2, 0x7f, 0xee, 0xee, 0xd9, 0xdd, 0xf9, 0x5f, 0x73, 0xff, 0xab, 0xef, 0xbc, 0xa0, 0xe3, 0xdd,
    0x7b, 0x8f, 0xff, 0x57, 0xff, 0x16, 0x67, 0xed, 0xf2, 0x7b, 0xae, 0xb4, 0x45, 0xf9, 0xba, 0x7d, 0xcf, 0x6f, 0x49, 0xf2,
    0xd7, 0xdf, 0xb2, 0x47, 0xce, 0x38, 0x78, 0x7f, 0x34, 0xf5, 0x73, 0x95, 0xea, 0xf0, 0x3b, 0xe4, 0x3f, 0xfb, 0xd4, 0x9f,
    0xec, 0xbb, 0xf7, 0xc8, 0xff, 0xfa, 0x96, 0xbd, 0x3a, 0xff, 0x4f, 0xfc, 0xb5, 0xe2, 0xef, 0xb5, 0x42, 0x2c, 0x7e, 0xff,
    0x6f, 0xef, 0x0b, 0x7b, 0x3d, 0x31, 0xcb, 0x76, 0xe5, 0xca, 0xbe, 0x15, 0xad, 0x05, 0x8e, 0xac, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x9b, 0xfb, 0x70, 0x34, 0x7f, 0x32, 0x9a, 0xaa, 0x20, 0x64, 0xeb, 0xc0,
    0x8d, 0xd3, 0xb5, 0xf0, 0xa3, 0x54, 0x79, 0x76, 0xbe, 0xba, 0xc2, 0xf7, 0x19, 0xcd, 0x9f, 0xbf, 0x69, 0x14, 0x66, 0x09,
    0x67, 0x9f, 0x6d, 0x50, 0xa9, 0xad, 0x50, 0x5f, 0x56, 0x14, 0xab, 0x48, 0xce, 0xb7, 0x41, 0x14, 0x9e, 0xef, 0x70, 0xf4,
    0x5d, 0xf2, 0x5b, 0x21, 0xf3, 0x5a, 0x65, 0x6e, 0xf9, 0x38, 0xf1, 0xdc, 0x81, 0x38, 0x9c, 0xdf, 0xd0, 0x9b, 0xff, 0xd5,
    0x75, 0xb0, 0x2b, 0xb5, 0x3c, 0xfe, 0xfb, 0xda, 0x7d, 0x75, 0x27, 0xbe, 0x1d, 0x77, 0x2a, 0x55, 0x28, 0xb2, 0xc7, 0xe1,
    0xfc, 0x5e, 0x38, 0xb7, 0xac, 0x91, 0xda, 0x02, 0x95, 0x7a, 0xe6, 0x9d, 0x6d, 0x1a, 0x85, 0x9a, 0x17, 0xe7, 0x7b, 0x9f,
    0x28, 0xb6, 0xfd, 0x4c, 0xcd, 0x9d, 0x33, 0x33, 0x8a, 0xa3, 0xb0, 0xe7, 0x75, 0xd5, 0xc1, 0x8d, 0x96, 0x4c, 0x77, 0x54,
    0xc1, 0xca, 0xd5, 0xee, 0xcd, 0xce, 0x24, 0x8d, 0xc9, 0xfd, 0x38, 0xbf, 0x7f, 0x47, 0x4b, 0x35, 0xae, 0xe3, 0x65, 0xc5,
    0x97, 0x65, 0x65, 0xf2, 0x5f, 0xef, 0x4b, 0xd7, 0xe7, 0x3f, 0xbf, 0x06, 0x99, 0x0a, 0x52, 0x73, 0xbd, 0xe3, 0x7c, 0xfe,
    0x77, 0xed, 0xff, 0xef, 0xce, 0x7f, 0xbe, 0x06, 0xcc, 0xd1, 0x79, 0x77, 0x65, 0x2f, 0x8a, 0x52, 0x26, 0xb3, 0xfb, 0x60,
    0xbd, 0xff, 0x8f, 0xd2, 0x39, 0x55, 0xe7, 0xb6, 0xbd, 0x22, 0xff, 0x63, 0x61, 0xfe, 0xef, 0xee, 0xff, 0xf7, 0xcc, 0x7f,
    0x5f, 0x2d, 0xdf, 0xb9, 0xfc, 0xe7, 0x53, 0x3e, 0x8a, 0x6b, 0xde, 0x77, 0xfe, 0x1f, 0xe9, 0xf1, 0xd3, 0xcc, 0xb2, 0xa2,
    0xe5, 0x5c, 0x6b, 0x1c, 0x3c, 0x9f, 0xf0, 0xf9, 0xf9, 0x1f, 0xc5, 0x33, 0xe0, 0xa3, 0xa7, 0x61, 0xe4, 0xdb, 0x67, 0x76,
    0x84, 0xbb, 0xbe, 0x0a, 0xf2, 0xf5, 0xcf, 0xc1, 0x88, 0x86, 0xb3, 0xfc, 0xa3, 0xca, 0x85, 0xb1, 0x41, 0xfe, 0xeb, 0xd7,
    0x87, 0xbb, 0xfa, 0xff, 0xee, 0xeb, 0xd6, 0x3d, 0xf9, 0x1f, 0xa5, 0x71, 0x4c, 0x5f, 0x3b, 0x8f, 0xa9, 0xfe, 0x7f, 0xbc,
    0x2c, 0xff, 0xd7, 0x3f, 0x07, 0x23, 0x5a, 0x46, 0xf9, 0x51, 0x7c, 0xde, 0x50, 0xef, 0xf9, 0xff, 0xb7, 0xe7, 0xe2, 0x46,
    0xf9, 0xd9, 0x70, 0x6b, 0xf3, 0x7f, 0xee, 0x6a, 0xf5, 0xca, 0xfc, 0x0f, 0xf9, 0x3f, 0x79, 0x87, 0xeb, 0xe8, 0x5e, 0xc5,
    0x48, 0xdf, 0x75, 0x99, 0xbd, 0x77, 0x74, 0xe5, 0xf9, 0xff, 0x75, 0xfd, 0xff, 0x58, 0x72, 0xfd, 0x7f, 0x45, 0x3f, 0xfb,
    0xa4, 0xfe, 0xff, 0xfb, 0x9e, 0xfd, 0x9c, 0xfc, 0x9f, 0x49, 0xdc, 0x78, 0x44, 0x45, 0xd1, 0xae, 0x4a, 0xd0, 0xd7, 0x5e,
    0xff, 0xeb, 0xbe, 0x9f, 0xd1, 0x73, 0xfe, 0x9f, 0xef, 0x49, 0xe7, 0x46, 0xb9, 0x9d, 0xcb, 0xba, 0xee, 0xfc, 0xff, 0x1d,
    0xf9, 0xef, 0x59, 0xbb, 0xfb, 0x2b, 0x20, 0xee, 0x99, 0xff, 0x51, 0xfc, 0x7d, 0xcd, 0xbd, 0xe7, 0xff, 0x57, 0xe6, 0x6c,
    0x8f, 0x7d, 0xe6, 0xbd, 0xf9, 0x3f, 0xfa, 0xfd, 0xcf, 0x13, 0xb7, 0xdb, 0xec, 0xd1, 0x27, 0x16, 0xbd, 0xf7, 0xae, 0xb3,
    0xa3, 0x98, 0xba, 0x56, 0x21, 0xff, 0x9d, 0xf9, 0x7f, 0x53, 0xc2, 0x9e, 0x92, 0xff, 0x55, 0x47, 0x8c, 0xa7, 0x3c, 0x19,
    0x42, 0xfe, 0xaf, 0xcd, 0xff, 0xaf, 0x24, 0xec, 0xbd, 0xf9, 0x7f, 0xdf, 0xd1, 0x2c, 0x3b, 0x86, 0x8e, 0x0b, 0xc7, 0xdd,
    0x71, 0xe3, 0x18, 0xbf, 0xba, 0x5e, 0xd7, 0xac, 0xf3, 0xae, 0x2d, 0xf3, 0x84, 0xb5, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x67, 0xb9, 0x44, 0xcb, 0x6c, 0xd9, 0x51, 0xaa, 0xc3, 0x9e, 0x9f, 0x0b, 0x99, 0xad,
    0x35, 0x3f, 0x5a, 0xea, 0x14, 0x57, 0xaa, 0xc5, 0x1e, 0xcf, 0x37, 0x8d, 0x64, 0x5b, 0xde, 0xb5, 0xad, 0xa2, 0xbc, 0xf4,
    0x95, 0xdb, 0xe4, 0xf3, 0xac, 0xa0, 0xfc, 0x93, 0x16, 0x2a, 0xd5, 0x33, 0xae, 0xcb, 0xc1, 0xea, 0xd9, 0xfc, 0xf9, 0xba,
    0xfc, 0xf3, 0x55, 0x4f, 0xfb, 0x9e, 0x14, 0xd0, 0xfd, 0x2d, 0x32, 0x75, 0x5e, 0xcf, 0xb5, 0x42, 0x34, 0xb5, 0xe5, 0x5d,
    0xdb, 0xea, 0x68, 0x8d, 0x62, 0xf9, 0xda, 0x76, 0xd5, 0xeb, 0x8e, 0x52, 0x3f, 0x78, 0x47, 0x0e, 0x2a, 0xfd, 0xd1, 0xfd,
    0xb3, 0x5c, 0xe7, 0xe7, 0xf7, 0xd6, 0xf3, 0xff, 0xd4, 0xf3, 0xb1, 0x67, 0x7c, 0xa7, 0xef, 0xb5, 0xb4, 0x76, 0xfa, 0x0e,
    0xd5, 0xfc, 0x77, 0x54, 0x97, 0xe9, 0x9c, 0xe7, 0x1e, 0x5f, 0x6a, 0x2e, 0x47, 0xeb, 0xf9, 0xff, 0x4e, 0xaf, 0x57, 0xf3,
    0x9f, 0x1f, 0x2f, 0xcc, 0x8e, 0x2f, 0xe6, 0x9f, 0x50, 0x94, 0xaf, 0xde, 0x79, 0xdf, 0xeb, 0xdd, 0xcf, 0x48, 0x5a, 0xfd,
    0x7a, 0x25, 0xff, 0xbb, 0xf6, 0x0d, 0x3d, 0xf9, 0x8f, 0x0d, 0xb7, 0x52, 0x7e, 0xf4, 0x36, 0x7f, 0x9e, 0x59, 0x3d, 0xbe,
    0x74, 0xe7, 0x7f, 0xc7, 0xb6, 0xcf, 0x8f, 0xff, 0x9f, 0x97, 0xff, 0x28, 0xf4, 0xc3, 0xf7, 0xf5, 0x83, 0x99, 0xa7, 0x58,
    0xd6, 0xc7, 0xf8, 0xfb, 0xef, 0x83, 0xf2, 0x7f, 0x77, 0xdb, 0x8f, 0x1f, 0xe8, 0xff, 0xf7, 0xd9, 0xef, 0xba, 0xc7, 0xc1,
    0xf2, 0x2f, 0xff, 0xf2, 0x1f, 0x27, 0xc6, 0x63, 0x7b, 0xbc, 0x7e, 0x5d, 0xfe, 0x73, 0x95, 0xf9, 0xd7, 0xbf, 0x5e, 0xcb,
    0xed, 0xda, 0x6d, 0x24, 0xff, 0xfb, 0xe5, 0x7f, 0xe6, 0x89, 0x61, 0x4f, 0x68, 0xf3, 0xde, 0xfb, 0x7f, 0xcf, 0x1a, 0x6b,
    0xea, 0xff, 0xe5, 0xbf, 0x7e, 0xff, 0xff, 0x1d, 0xf9, 0xef, 0xbe, 0x97, 0xf7, 0x94, 0xeb, 0x7f, 0xe3, 0xe0, 0xb9, 0x40,
    0x71, 0xcb, 0x73, 0xc4, 0xd6, 0xe4, 0xff, 0x19, 0xdb, 0xe4, 0x78, 0xaf, 0x7a, 0x52, 0xfe, 0x9f, 0xdf, 0xe6, 0x9d, 0xf7,
    0x25, 0xdf, 0xf1, 0xbd, 0x9f, 0x99, 0xff, 0x37, 0x6c, 0x93, 0xa3, 0x11, 0xd3, 0x9e, 0xfd, 0xff, 0xf3, 0x73, 0x10, 0x8b,
    0x7f, 0x83, 0xb2, 0x6f, 0xfe, 0xc7, 0x6b, 0xfa, 0xff, 0xe7, 0x6f, 0x93, 0xb8, 0xf1, 0x5b, 0xf4, 0xe6, 0x7f, 0xb7, 0xfb,
    0x7f, 0x77, 0xff, 0x06, 0xed, 0x69, 0xe7, 0x3d, 0xcf, 0xfb, 0xfd, 0x4f, 0x6d, 0x4c, 0xfd, 0xa4, 0x7d, 0xf1, 0xae, 0x3b,
    0xe7, 0x2a, 0xe2, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xd6, 0x55, 0xdf, 0x3c, 0x8a,
    0x33, 0xab, 0xce, 0xbd, 0x56, 0xa9, 0xe6, 0x1e, 0xcb, 0xbe, 0x6b, 0xa5, 0x36, 0x4b, 0xb4, 0xcd, 0x5d, 0xea, 0xda, 0x32,
    0x9f, 0x97, 0x1b, 0xc5, 0x2a, 0x2c, 0xbc, 0xeb, 0x08, 0xb0, 0xaa, 0x42, 0xfe, 0x68, 0xa8, 0x92, 0x5f, 0xab, 0xe6, 0x78,
    0x4f, 0x2d, 0xf7, 0xb9, 0x99, 0xb2, 0xeb, 0xb6, 0x4c, 0x6f, 0x9d, 0x7c, 0xde, 0x75, 0x04, 0x58, 0xf9, 0x1c, 0x91, 0x68,
    0xfc, 0xcc, 0xd8, 0xea, 0xbb, 0x8e, 0xaf, 0x33, 0xcf, 0x46, 0xa2, 0xf2, 0xc4, 0xfa, 0xb5, 0x8d, 0xd6, 0x96, 0x85, 0x3b,
    0x8e, 0x59, 0xcf, 0xde, 0x4b, 0xf7, 0xeb, 0x51, 0xe5, 0xff, 0xd7, 0x92, 0xb4, 0x7a, 0x8e, 0xf8, 0x6c, 0x5d, 0x8e, 0xfc,
    0x59, 0xea, 0x7e, 0x35, 0x1b, 0xa2, 0x30, 0xa7, 0x7f, 0x78, 0x4e, 0x06, 0x37, 0xf5, 0x3f, 0x9d, 0x75, 0x3b, 0xae, 0xcf,
    0xff, 0x5e, 0xaf, 0xd7, 0xfa, 0x7f, 0xf9, 0x47, 0xfe, 0xe5, 0x5f, 0xfe, 0x91, 0xff, 0xf7, 0xe6, 0x3f, 0xe4, 0x9f, 0x5b,
    0x47, 0xff, 0x2b, 0x9f, 0xdb, 0x21, 0xff, 0x73, 0x77, 0xff, 0xe4, 0x9f, 0x3b, 0xee, 0xfe, 0xf7, 0x55, 0xc8, 0x95, 0xff,
    0xda, 0xaf, 0xaf, 0xe4, 0x1f, 0xf9, 0x7f, 0x7b, 0xff, 0x2f, 0xff, 0xb8, 0xff, 0x77, 0x4d, 0xfe, 0xd5, 0xc9, 0xce, 0xfd,
    0x4a, 0x3a, 0xf7, 0x24, 0x44, 0xb8, 0xfe, 0xba, 0x85, 0xbd, 0xb1, 0xff, 0xb7, 0x99, 0x47, 0x2d, 0xab, 0xc5, 0xe1, 0x17,
    0xe6, 0x7f, 0xc9, 0x3f, 0xfc, 0xda, 0xc8, 0xaf, 0xfb, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xe3, 0xcf, 0x7f, 0xda, 0x01, 0xe4, 0x1f, 0xf8, 0xb9, 0xfc, 0xff,
    0x01 };

// Font glyphs rectangles data (on atlas)
static const Rectangle ashesFontRecs[189] = {
    { 4, 4, 4 , 16 },
    { 16, 4, 1 , 10 },
    { 25, 4, 3 , 3 },
    { 36, 4, 6 , 8 },
    { 50, 4, 5 , 11 },
    { 63, 4, 7 , 8 },
    { 78, 4, 6 , 9 },
    { 92, 4, 1 , 3 },
    { 101, 4, 3 , 12 },
    { 112, 4, 3 , 12 },
    { 123, 4, 5 , 5 },
    { 136, 4, 5 , 5 },
    { 149, 4, 2 , 2 },
    { 159, 4, 4 , 1 },
    { 171, 4, 1 , 1 },
    { 180, 4, 5 , 10 },
    { 193, 4, 4 , 8 },
    { 205, 4, 2 , 8 },
    { 215, 4, 4 , 8 },
    { 227, 4, 4 , 8 },
    { 239, 4, 6 , 8 },
    { 253, 4, 4 , 8 },
    { 265, 4, 4 , 8 },
    { 277, 4, 4 , 8 },
    { 289, 4, 4 , 8 },
    { 301, 4, 4 , 8 },
    { 313, 4, 1 , 5 },
    { 322, 4, 2 , 6 },
    { 332, 4, 4 , 7 },
    { 344, 4, 4 , 4 },
    { 356, 4, 4 , 7 },
    { 368, 4, 4 , 10 },
    { 380, 4, 8 , 7 },
    { 396, 4, 4 , 10 },
    { 408, 4, 4 , 10 },
    { 420, 4, 4 , 10 },
    { 432, 4, 4 , 10 },
    { 444, 4, 4 , 10 },
    { 456, 4, 5 , 10 },
    { 469, 4, 4 , 10 },
    { 481, 4, 4 , 10 },
    { 493, 4, 1 , 10 },
    { 4, 28, 3 , 10 },
    { 15, 28, 4 , 10 },
    { 27, 28, 4 , 10 },
    { 39, 28, 7 , 10 },
    { 54, 28, 4 , 10 },
    { 66, 28, 4 , 10 },
    { 78, 28, 4 , 10 },
    { 90, 28, 5 , 11 },
    { 103, 28, 4 , 10 },
    { 115, 28, 4 , 10 },
    { 127, 28, 5 , 10 },
    { 140, 28, 4 , 10 },
    { 152, 28, 4 , 10 },
    { 164, 28, 7 , 10 },
    { 179, 28, 4 , 10 },
    { 191, 28, 4 , 10 },
    { 203, 28, 4 , 10 },
    { 215, 28, 2 , 12 },
    { 225, 28, 5 , 10 },
    { 238, 28, 2 , 12 },
    { 248, 28, 5 , 3 },
    { 261, 28, 5 , 1 },
    { 274, 28, 2 , 2 },
    { 284, 28, 4 , 8 },
    { 296, 28, 4 , 10 },
    { 308, 28, 3 , 8 },
    { 319, 28, 4 , 10 },
    { 331, 28, 4 , 8 },
    { 343, 28, 3 , 10 },
    { 354, 28, 5 , 11 },
    { 367, 28, 4 , 10 },
    { 379, 28, 1 , 10 },
    { 388, 28, 3 , 13 },
    { 399, 28, 4 , 10 },
    { 411, 28, 2 , 10 },
    { 421, 28, 7 , 8 },
    { 436, 28, 4 , 8 },
    { 448, 28, 4 , 8 },
    { 460, 28, 4 , 11 },
    { 472, 28, 4 , 11 },
    { 484, 28, 3 , 8 },
    { 495, 28, 4 , 8 },
    { 4, 52, 3 , 10 },
    { 15, 52, 4 , 8 },
    { 27, 52, 5 , 8 },
    { 40, 52, 7 , 8 },
    { 55, 52, 4 , 8 },
    { 67, 52, 4 , 11 },
    { 79, 52, 4 , 8 },
    { 91, 52, 4 , 12 },
    { 103, 52, 1 , 10 },
    { 112, 52, 4 , 12 },
    { 124, 52, 4 , 2 },
    { 136, 52, 1 , 10 },
    { 145, 52, 4 , 12 },
    { 157, 52, 5 , 10 },
    { 170, 52, 5 , 10 },
    { 183, 52, 5 , 10 },
    { 196, 52, 6 , 13 },
    { 210, 52, 4 , 10 },
    { 222, 52, 6 , 13 },
    { 236, 52, 7 , 9 },
    { 251, 52, 3 , 7 },
    { 262, 52, 6 , 5 },
    { 276, 52, 6 , 13 },
    { 290, 52, 7 , 9 },
    { 305, 52, 4 , 1 },
    { 317, 52, 3 , 5 },
    { 328, 52, 5 , 7 },
    { 341, 52, 3 , 5 },
    { 352, 52, 6 , 13 },
    { 366, 52, 6 , 13 },
    { 380, 52, 4 , 11 },
    { 392, 52, 6 , 10 },
    { 406, 52, 3 , 3 },
    { 417, 52, 6 , 13 },
    { 431, 52, 2 , 5 },
    { 441, 52, 3 , 5 },
    { 452, 52, 6 , 5 },
    { 466, 52, 7 , 10 },
    { 481, 52, 7 , 8 },
    { 496, 52, 6 , 13 },
    { 4, 76, 4 , 10 },
    { 16, 76, 4 , 13 },
    { 28, 76, 4 , 13 },
    { 40, 76, 4 , 13 },
    { 52, 76, 4 , 13 },
    { 64, 76, 4 , 13 },
    { 76, 76, 4 , 13 },
    { 88, 76, 7 , 10 },
    { 103, 76, 4 , 13 },
    { 115, 76, 4 , 13 },
    { 127, 76, 4 , 13 },
    { 139, 76, 4 , 13 },
    { 151, 76, 4 , 13 },
    { 163, 76, 2 , 13 },
    { 173, 76, 2 , 13 },
    { 183, 76, 3 , 13 },
    { 194, 76, 3 , 13 },
    { 205, 76, 5 , 10 },
    { 218, 76, 4 , 13 },
    { 230, 76, 4 , 13 },
    { 242, 76, 4 , 13 },
    { 254, 76, 4 , 13 },
    { 266, 76, 4 , 13 },
    { 278, 76, 4 , 13 },
    { 290, 76, 5 , 5 },
    { 303, 76, 6 , 12 },
    { 317, 76, 4 , 13 },
    { 329, 76, 4 , 13 },
    { 341, 76, 4 , 13 },
    { 353, 76, 4 , 13 },
    { 365, 76, 4 , 13 },
    { 377, 76, 6 , 13 },
    { 391, 76, 5 , 12 },
    { 404, 76, 4 , 12 },
    { 416, 76, 4 , 12 },
    { 428, 76, 4 , 12 },
    { 440, 76, 4 , 12 },
    { 452, 76, 4 , 12 },
    { 464, 76, 4 , 12 },
    { 476, 76, 7 , 8 },
    { 491, 76, 3 , 11 },
    { 4, 100, 4 , 12 },
    { 16, 100, 4 , 12 },
    { 28, 100, 4 , 12 },
    { 40, 100, 4 , 12 },
    { 52, 100, 3 , 12 },
    { 63, 100, 3 , 12 },
    { 74, 100, 3 , 12 },
    { 85, 100, 3 , 12 },
    { 96, 100, 6 , 13 },
    { 110, 100, 4 , 12 },
    { 122, 100, 4 , 12 },
    { 134, 100, 4 , 12 },
    { 146, 100, 4 , 12 },
    { 158, 100, 4 , 12 },
    { 170, 100, 4 , 12 },
    { 182, 100, 5 , 5 },
    { 195, 100, 6 , 10 },
    { 209, 100, 4 , 12 },
    { 221, 100, 4 , 12 },
    { 233, 100, 4 , 12 },
    { 245, 100, 4 , 12 },
    { 257, 100, 4 , 15 },
    { 269, 100, 6 , 13 },
    { 283, 100, 4 , 15 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo ashesFontGlyphs[189] = {
    { 32, 0, 13, 4, { 0 }},
    { 33, 0, 3, 4, { 0 }},
    { 34, 0, 1, 5, { 0 }},
    { 35, 0, 4, 8, { 0 }},
    { 36, 0, 2, 7, { 0 }},
    { 37, 0, 5, 9, { 0 }},
    { 38, 0, 4, 8, { 0 }},
    { 39, 0, 1, 3, { 0 }},
    { 40, 0, 2, 5, { 0 }},
    { 41, 0, 2, 5, { 0 }},
    { 42, 0, 3, 7, { 0 }},
    { 43, 0, 6, 7, { 0 }},
    { 44, 0, 12, 4, { 0 }},
    { 45, 0, 9, 5, { 0 }},
    { 46, 0, 12, 3, { 0 }},
    { 47, 0, 3, 7, { 0 }},
    { 48, 0, 5, 6, { 0 }},
    { 49, 0, 5, 4, { 0 }},
    { 50, 0, 5, 6, { 0 }},
    { 51, 0, 5, 6, { 0 }},
    { 52, 0, 5, 8, { 0 }},
    { 53, 0, 5, 6, { 0 }},
    { 54, 0, 5, 6, { 0 }},
    { 55, 0, 5, 6, { 0 }},
    { 56, 0, 5, 6, { 0 }},
    { 57, 0, 5, 6, { 0 }},
    { 58, 0, 8, 3, { 0 }},
    { 59, 0, 8, 4, { 0 }},
    { 60, 0, 5, 6, { 0 }},
    { 61, 0, 7, 7, { 0 }},
    { 62, 0, 5, 6, { 0 }},
    { 63, 1, 3, 7, { 0 }},
    { 64, 0, 5, 10, { 0 }},
    { 65, 0, 3, 6, { 0 }},
    { 66, 0, 3, 6, { 0 }},
    { 67, 0, 3, 6, { 0 }},
    { 68, 0, 3, 6, { 0 }},
    { 69, 0, 3, 6, { 0 }},
    { 70, 0, 3, 6, { 0 }},
    { 71, 0, 3, 6, { 0 }},
    { 72, 0, 3, 6, { 0 }},
    { 73, 0, 3, 3, { 0 }},
    { 74, 0, 3, 5, { 0 }},
    { 75, 0, 3, 6, { 0 }},
    { 76, 0, 3, 6, { 0 }},
    { 77, 0, 3, 9, { 0 }},
    { 78, 0, 3, 6, { 0 }},
    { 79, 0, 3, 6, { 0 }},
    { 80, 0, 3, 6, { 0 }},
    { 81, 0, 3, 7, { 0 }},
    { 82, 0, 3, 6, { 0 }},
    { 83, 0, 3, 6, { 0 }},
    { 84, 0, 3, 6, { 0 }},
    { 85, 0, 3, 6, { 0 }},
    { 86, 0, 3, 6, { 0 }},
    { 87, 0, 3, 9, { 0 }},
    { 88, 0, 3, 6, { 0 }},
    { 89, 0, 3, 6, { 0 }},
    { 90, 0, 3, 6, { 0 }},
    { 91, 0, 2, 4, { 0 }},
    { 92, 0, 3, 7, { 0 }},
    { 93, 0, 2, 4, { 0 }},
    { 94, 0, 3, 7, { 0 }},
    { 95, 0, 12, 7, { 0 }},
    { 96, 0, 1, 4, { 0 }},
    { 97, 0, 5, 6, { 0 }},
    { 98, 0, 3, 6, { 0 }},
    { 99, 0, 5, 5, { 0 }},
    { 100, 0, 3, 6, { 0 }},
    { 101, 0, 5, 6, { 0 }},
    { 102, 0, 3, 5, { 0 }},
    { 103, 0, 5, 6, { 0 }},
    { 104, 0, 3, 6, { 0 }},
    { 105, 0, 3, 3, { 0 }},
    { 106, 0, 3, 5, { 0 }},
    { 107, 0, 3, 6, { 0 }},
    { 108, 0, 3, 4, { 0 }},
    { 109, 0, 5, 9, { 0 }},
    { 110, 0, 5, 6, { 0 }},
    { 111, 0, 5, 6, { 0 }},
    { 112, 0, 5, 6, { 0 }},
    { 113, 0, 5, 6, { 0 }},
    { 114, 0, 5, 5, { 0 }},
    { 115, 0, 5, 6, { 0 }},
    { 116, 0, 3, 5, { 0 }},
    { 117, 0, 5, 6, { 0 }},
    { 118, 0, 5, 7, { 0 }},
    { 119, 0, 5, 9, { 0 }},
    { 120, 0, 5, 6, { 0 }},
    { 121, 0, 5, 6, { 0 }},
    { 122, 0, 5, 6, { 0 }},
    { 123, 0, 2, 6, { 0 }},
    { 124, 0, 3, 3, { 0 }},
    { 125, 0, 2, 6, { 0 }},
    { 126, 0, 1, 6, { 0 }},
    { 161, 0, 4, 4, { 0 }},
    { 162, 0, 3, 6, { 0 }},
    { 163, 0, 3, 7, { 0 }},
    { 8364, 0, 3, 7, { 0 }},
    { 165, 0, 3, 7, { 0 }},
    { 352, 1, 0, 8, { 0 }},
    { 167, 0, 3, 6, { 0 }},
    { 353, 1, 0, 8, { 0 }},
    { 169, 0, 1, 9, { 0 }},
    { 170, 0, 1, 5, { 0 }},
    { 171, 0, 6, 8, { 0 }},
    { 172, 1, 0, 8, { 0 }},
    { 174, 0, 1, 9, { 0 }},
    { 175, 0, 0, 6, { 0 }},
    { 176, 0, 1, 5, { 0 }},
    { 177, 0, 5, 7, { 0 }},
    { 178, 0, 1, 5, { 0 }},
    { 179, 1, 0, 8, { 0 }},
    { 381, 1, 0, 8, { 0 }},
    { 181, 0, 5, 6, { 0 }},
    { 182, 0, 3, 8, { 0 }},
    { 183, 0, 7, 5, { 0 }},
    { 382, 1, 0, 8, { 0 }},
    { 185, 0, 1, 4, { 0 }},
    { 186, 0, 1, 5, { 0 }},
    { 187, 0, 6, 8, { 0 }},
    { 338, 0, 3, 9, { 0 }},
    { 339, 0, 5, 9, { 0 }},
    { 376, 1, 0, 8, { 0 }},
    { 191, 0, 4, 6, { 0 }},
    { 192, 0, 0, 6, { 0 }},
    { 193, 0, 0, 6, { 0 }},
    { 194, 0, 0, 6, { 0 }},
    { 195, 0, 0, 6, { 0 }},
    { 196, 0, 0, 6, { 0 }},
    { 197, 0, 0, 6, { 0 }},
    { 198, 0, 3, 9, { 0 }},
    { 199, 0, 3, 6, { 0 }},
    { 200, 0, 0, 6, { 0 }},
    { 201, 0, 0, 6, { 0 }},
    { 202, 0, 0, 6, { 0 }},
    { 203, 0, 0, 6, { 0 }},
    { 204, 0, 0, 4, { 0 }},
    { 205, 0, 0, 4, { 0 }},
    { 206, 0, 0, 5, { 0 }},
    { 207, 0, 0, 5, { 0 }},
    { 208, 0, 3, 7, { 0 }},
    { 209, 0, 0, 6, { 0 }},
    { 210, 0, 0, 6, { 0 }},
    { 211, 0, 0, 6, { 0 }},
    { 212, 0, 0, 6, { 0 }},
    { 213, 0, 0, 6, { 0 }},
    { 214, 0, 0, 6, { 0 }},
    { 215, 0, 7, 7, { 0 }},
    { 216, 0, 2, 8, { 0 }},
    { 217, 0, 0, 6, { 0 }},
    { 218, 0, 0, 6, { 0 }},
    { 219, 0, 0, 6, { 0 }},
    { 220, 0, 0, 6, { 0 }},
    { 221, 0, 0, 6, { 0 }},
    { 222, 1, 0, 8, { 0 }},
    { 223, 0, 3, 7, { 0 }},
    { 224, 0, 1, 6, { 0 }},
    { 225, 0, 1, 6, { 0 }},
    { 226, 0, 1, 6, { 0 }},
    { 227, 0, 1, 6, { 0 }},
    { 228, 0, 1, 6, { 0 }},
    { 229, 0, 1, 6, { 0 }},
    { 230, 0, 5, 9, { 0 }},
    { 231, 0, 5, 5, { 0 }},
    { 232, 0, 1, 6, { 0 }},
    { 233, 0, 1, 6, { 0 }},
    { 234, 0, 1, 6, { 0 }},
    { 235, 0, 1, 6, { 0 }},
    { 236, 0, 1, 5, { 0 }},
    { 237, 0, 1, 5, { 0 }},
    { 238, 0, 1, 5, { 0 }},
    { 239, 0, 1, 5, { 0 }},
    { 240, 1, 0, 8, { 0 }},
    { 241, 0, 1, 6, { 0 }},
    { 242, 0, 1, 6, { 0 }},
    { 243, 0, 1, 6, { 0 }},
    { 244, 0, 1, 6, { 0 }},
    { 245, 0, 1, 6, { 0 }},
    { 246, 0, 1, 6, { 0 }},
    { 247, 0, 7, 7, { 0 }},
    { 248, 0, 4, 8, { 0 }},
    { 249, 0, 1, 6, { 0 }},
    { 250, 0, 1, 6, { 0 }},
    { 251, 0, 1, 6, { 0 }},
    { 252, 0, 1, 6, { 0 }},
    { 253, 0, 1, 6, { 0 }},
    { 254, 1, 0, 8, { 0 }},
    { 255, 0, 1, 6, { 0 }},
};

// Style loading function: Ashes
static void GuiLoadStyleAshes(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < ASHES_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(ashesStyleProps[i].controlId, ashesStyleProps[i].propertyId, ashesStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int ashesFontDataSize = 0;
    unsigned char *data = DecompressData(ashesFontData, ASHES_STYLE_FONT_ATLAS_COMP_SIZE, &ashesFontDataSize);
    Image imFont = { data, 512, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 16;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, ashesFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, ashesFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 510, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
